theory Ex1 = Prelude + Lemmas + VDM:

(* --------------------------------------------------------------------------- *)

locale example0 =
  fixes   n  :: iname
  fixes   count :: ifldname
  fixes   foo :: mname
  fixes   Foo :: cname
  assumes foobody: "methtable Foo foo = ((LET n = x\<bullet>count IN n\<^sup>I END) :: 'a expr)"
  assumes foospec: "spectable Foo foo = {(E,h,hh,v,p) . (\<forall> a . E\<lfloor>x\<rfloor> = Ref a \<and> (fmap_lookup (heap.oheap h) a = Some Foo)) \<longrightarrow> v = IVal hh<a\<bullet>count> \<and> h = hh }"

(* to be used as example in assertion section of deliverable *)
lemma (in example0)  
  (*  "\<rhd> ((MH_InvokeStatic Foo foo) :: 'a expr) : spectable Foo foo" *)
  "\<rhd> ((LET n = x\<bullet>count IN n\<^sup>I END) :: 'a expr) : {(E,h,hh,v,p) . E\<lfloor>x\<rfloor> = Ref l \<and> (fmap_lookup (heap.oheap h) l = Some Foo) \<longrightarrow> (v = IVal h<l\<bullet>count> \<and> h = hh) }"
apply (rule vdm_conseq)
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) defer 1
apply (rule vdm_basics)
apply auto
done

(* --------------------------------------------------------------------------- *)

(* exp example without using Prelude *)
locale example_exp =
  fixes   x  :: iname
  fixes   y  :: iname
  fixes   r  :: iname
  fixes   q  :: iname
  fixes  exp :: funame
  assumes expbody: "funtable exp = 
     ((LET 
         q = Primop (% x y . if (0 < y) then (1::int) else (0::int)) x y 
       IN 
         IF q 
           THEN LET 
                  r = Primop (% r x . r * x) r x ; 
                  y = Primop (% x y . y - 1) y y 
                IN 
                  CALL exp 
                END
           ELSE IVar r
       END)::'a expr)"
  assumes vardistinct: "distinct [x,y,r,q]"

lemma bonzo_1346: "0 < Y ==> (R * X) * (int ((nat X) ^ (nat (Y - 1)))) = R * (int ((nat X) ^ (nat Y)))"
sorry

lemma (in example_exp)
 "\<rhd> ((CALL exp)::'a expr) : {(E,h,hh,v,p). 0 <= E<y> \<longrightarrow> v = IVal (int (nat (E<r>) * ((nat E<x>)^(nat E<y>))))}"
(*
apply (rule vdm_adapt_context_with_bonzo)
apply (rule impI)
*)
(* apply (rule vdm_conseq) *)
apply (insert vardistinct)
apply (rule vdm_calls)
apply (simp add: expbody)               (* porghvam yISach! *)
apply (rule vdm_conseq)
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) 
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) defer 1
apply (rule vdm_ax)
defer 1
apply (rule vdm_basics) 
defer 1
apply (rule vdm_basics) 
apply (rule vdm_basics) 
apply (rule vdm_basics)
apply auto
apply (insert bonzo_1346)
apply clarsimp
(* one sorry nat-int lemma left *)
defer 1 
apply clarsimp
oops

(* --------------------------------------------------------------------------- *)

locale example1 =
  fixes   m  :: iname
  fixes   x  :: rname
  fixes   a1 :: locn
  fixes   foo :: mname
  fixes   Foo :: cname
  assumes cheat1:  "\<And> h a . fmap_lookup (heap.oheap h) a = Some Foo"
  assumes cheat2:  "methtable c foo = ((1\<^sup>z)::'a expr)"
  assumes foobody: "methtable Foo foo = ((1\<^sup>z)::'a expr)"
  assumes foospec: "spectable Foo foo = {(E,h,hh,v,p). v = (1::int) \<and> hh=h \<and> p=\<langle>1 0 0 0\<rangle>}"

lemma (in example1) bonzo999:
 "\<rhd> ((MH_InvokeStatic Foo foo) :: 'a expr) : {(E,h,hh,v,p). E\<lfloor>self\<rfloor> \<noteq> Nullref}"
apply (rule vdm_mhinvokestatic)
apply (simp add: foobody)
apply (rule vdm_conseq)
apply (rule vdm_int)
apply clarsimp
oops
(* False; good! *)

constdefs one :: val
 "one == IVal (1::int)"

lemma (in example1) bonzo999:
 "\<rhd> ((MH_InvokeStatic Foo foo)::'a expr) :  {(E,h,hh,v,p). v = IVal 1 \<and> hh = h \<and> p = \<langle>1 0 0 0\<rangle>}"
apply (simp add: foospec)
apply (rule vdm_mhinvokestatic)
apply (simp add: foobody)
apply (rule vdm_conseq)
apply (rule vdm_int)
apply clarsimp
oops
(* False; bad! *)

(*
lemma (in example1) "\<forall> E h. E \<turnstile> h,(methtable Foo foo) \<Down>1 (h,IVal 1, \<langle>1 0 0 0\<rangle>)"
apply (clarsimp)
apply (simp add: foobody)
apply (rule semInt)
oops
*)

lemma (in example1) bonzo999:
 "\<rhd> ((methtable Foo foo) :: 'a expr) : {(E,h,hh,v,p). (v = IVal 1)}"
 apply (simp add: foobody)
 apply (rule vdm_conseq)
 apply (rule vdm_int)
 apply clarsimp
done

subsection {* Proper MH_Invoke *}

(* (\<exists> a . E\<lfloor>x\<rfloor> = Ref a \<and> fmap_lookup (heap.oheap h) a = Some Foo) \<longrightarrow> *)
lemma (in example1) bonzo999:
 "\<rhd> ((MH_Invoke x foo) :: 'a expr) : {(E,h,hh,v,p). v = IVal 1 \<and> hh = h \<and> p = \<langle>5 0 1 1\<rangle>}"
apply (rule vdm_mhinvoke)
apply clarsimp
apply (case_tac "C=Foo")
 (* right class *)
 apply (simp add: qach_QaQ_def)
 apply (simp add: foobody)
 apply (rule vdm_conseq)
 apply (rule vdm_int)
 apply clarsimp
 (* .. case ok *)
 (* wrong class *)
 (* we assume that this doesn't happen; otherwise op sem gets stuck anyway *)
oops

(*
lemma (in example1) bonzo999:
 "\<rhd> ((MH_Invoke x foo) :: 'a expr) : {(E,h,hh,v,p). E\<lfloor>self\<rfloor> \<noteq> Nullref \<and> (\<forall> h a . (fmap_lookup (heap.oheap h) a = Some Foo))}"
apply (insert cheat2)
apply (rule vdm_mhinvoke)
apply simp_all
defer 1
apply (insert cheat1)
apply clarsimp
defer 1
apply (rule vdm_conseq)
apply (rule vdm_int)
apply (simp add: subst_def)
apply auto
apply (subgoal_tac "fmap_lookup (FunMachineTest.heap.oheap h) a = Some Foo")
  apply simp
  apply (erule_tac x="h" in allE)
defer 1
apply simp
oops
*)

subsection {* Testing adaptation *}

(* --------------------------------------------------------------------------- *)

section {* Different version of adaptation *}

(* UNPROVEN LEMMA on context adaptation *)
lemma vdm_adapt_context: 
      "(insert (y\<diamondsuit>\<diamondsuit>mn, subst Q x y) G) \<rhd> e : P  
        \<Longrightarrow>
       (insert (x\<diamondsuit>\<diamondsuit>mn, Q) G) \<rhd> e : P"
sorry

constdefs not_free_in_assn :: "rname \<Rightarrow> vdmassn \<Rightarrow> bool"
 "not_free_in_assn y Q \<equiv> \<forall> x E h hh v p. (E,h,hh,v,p) \<in> Q \<longrightarrow> (\<exists> E0. E = E0\<lfloor>y:=E0\<lfloor>x\<rfloor>\<rfloor> \<and> (E0,h,hh,v,p) \<in> Q)"

(* This is the best bet so far; works with foo in Ex1 
   The is a shallow way of saying that x is not free in Q, allowing substitution *)
lemma vdm_adapt_context_with_bonzo: 
    "\<lbrakk> not_free_in_assn y Q  \<longrightarrow>
     (insert (y\<diamondsuit>\<diamondsuit>mn, subst Q y x) G) \<rhd> e : P \<rbrakk>
     \<Longrightarrow>
     (insert (x\<diamondsuit>\<diamondsuit>mn, Q) G) \<rhd> e : P"
sorry

lemma vdm_adapt_context_with_bonzo_fwd: 
    "\<lbrakk> not_free_in_assn x Q  ;
      (insert (y\<diamondsuit>\<diamondsuit>mn, Q) G) \<rhd> e : P \<rbrakk>
     \<Longrightarrow>
     (insert (x\<diamondsuit>\<diamondsuit>mn, subst Q x y) G) \<rhd> e : P"
sorry

constdefs alias_of :: "vdmassn \<Rightarrow> rname \<Rightarrow> rname \<Rightarrow> bool" 
 "alias_of P x y \<equiv> (\<forall> E h hh v p C a. (E,h,hh,v,p) \<in> P \<longrightarrow> qach_QaQ E h a x C \<longrightarrow> qach_QaQ E h a y C)"

lemma vdm_ax_with_adapt: 
 "\<lbrakk> not_free_in_assn x Q ; alias_of Q x y ; ((y\<diamondsuit>\<diamondsuit>mn), % y z . Q y z ) \<in> G \<rbrakk> \<Longrightarrow> G \<rhd> (x\<diamondsuit>\<diamondsuit>mn) : Q"
sorry

(*
lemma vdm_adapt_context_with_bonzo: 
    "\<lbrakk> (\<forall> E h hh v p. (E,h,hh,v,p) \<in> Q \<longrightarrow> (\<exists> E0. E = E0\<lfloor>y:=E0\<lfloor>x\<rfloor>\<rfloor> \<and> (E0,h,hh,v,p) \<in> Q)) \<longrightarrow>
     (insert (y\<diamondsuit>\<diamondsuit>mn, subst Q x y) G) \<rhd> e : P \<rbrakk>
     \<Longrightarrow>
     (insert (x\<diamondsuit>\<diamondsuit>mn, Q) G) \<rhd> e : P"
sorry
*)

(* adaptation lemma with built in alias branch *)
lemma vdm_adapt_context_with_alias: "\<lbrakk> {(x\<diamondsuit>\<diamondsuit>mn, subst Q x y)} \<rhd> e : P ; (\<forall> E h hh v p C a. (E,h,hh,v,p) \<in> P \<longrightarrow> qach_QaQ E h a x C \<longrightarrow> qach_QaQ E h a y C) \<rbrakk> \<Longrightarrow> {(y\<diamondsuit>\<diamondsuit>mn, Q)} \<rhd> e : P"
sorry (* , NOT! *)

lemma vdm_adapt_context_param: 
      "(insert (C\<bullet>mn(y), subst Q x y) G) \<rhd> e : P  
        \<Longrightarrow>
       (insert (C\<bullet>mn(x), Q) G) \<rhd> e : P"
sorry

lemma vdm_adapt_with_alias: "\<lbrakk> \<rhd> x\<diamondsuit>\<diamondsuit>mn : Q ; (\<forall> E h hh v p C a. (E,h,hh,v,p) \<in> Q \<longrightarrow> qach_QaQ E h a x C \<longrightarrow> qach_QaQ E h a y C) \<rbrakk> \<Longrightarrow>
                             \<rhd> y\<diamondsuit>\<diamondsuit>mn : subst Q y x"
oops

lemma vdm_adapt_from_context: "\<lbrakk> \<rhd> (x\<diamondsuit>\<diamondsuit>mn) : Q \<rbrakk> \<Longrightarrow> {(x\<diamondsuit>\<diamondsuit>mn, Q)} \<rhd> (y\<diamondsuit>\<diamondsuit>mn) : subst Q y x"
apply (simp add: subst_def)
apply (rule vdm_ax)
apply clarsimp
oops

lemma vdm_adapt_with_alias_InvokeStatic: "\<lbrakk> G \<rhd> (C\<bullet>mn(x)) : Q  ; (\<forall> E h hh v p C a. (E,h,hh,v,p) \<in> Q \<longrightarrow> qach_QaQ E h a x C \<longrightarrow> qach_QaQ E h a y C) \<rbrakk> \<Longrightarrow>
                             (G \<rhd> (C\<bullet>mn(y)) : Q)"
sorry

(*
lemma vdm_adapt_bonzo: "nuke y (subst Q x y) \<subseteq> nuke y Q"
apply (simp add: subst_def nuke_def)
apply clarsimp
apply (rule_tac x="E" in exI)
apply simp
done
*)

section {* Lemmas over these aux functions; SHOULD GO INTO Lemmas.thy !!!!!!!!!!! *}

lemma qach_QaQ_inj_arg: "\<lbrakk> qach_QaQ E h a r C ; qach_QaQ E h a' r C \<rbrakk> \<Longrightarrow> a = a'"
by (simp add: qach_QaQ_def)

lemma qach_QaQ_rvarIUpd[simp]: "qach_QaQ E<x:=n> h a r C = qach_QaQ E h a r C"
by (simp add: qach_QaQ_def)

lemma qach_QaQ_rvarRUpdSame[simp]: "qach_QaQ E\<lfloor>r:=Ref a\<rfloor> h a r C = (fmap_lookup (heap.oheap h) a = Some C)"
by (simp add: qach_QaQ_def)

lemma qach_QaQ_rvarRUpdOther[simp]: "r \<noteq> x  \<Longrightarrow> qach_QaQ E\<lfloor>x:=b\<rfloor> h a r C = qach_QaQ E h a r C"
by (simp add: qach_QaQ_def)

lemma qach_QaQ_heap1[simp]: "qach_QaQ E \<lparr> oheap = oheap h, iheap = foo, rheap = rheap h \<rparr> a r C = qach_QaQ E h a r C"
by (simp add: qach_QaQ_def)

lemma qach_QaQ9: "\<lbrakk> E\<lfloor>x\<rfloor> = E\<lfloor>y\<rfloor> ; qach_QaQ E h a x C \<rbrakk> \<Longrightarrow>  qach_QaQ E h a y C"
by (simp add: qach_QaQ_def)

lemma qach_QaQ8: "\<lbrakk> qach_QaQ E\<lfloor>x:=E\<lfloor>y\<rfloor>\<rfloor> h a x DecClass \<rbrakk> \<Longrightarrow> qach_QaQ E h a y DecClass"
by (simp add: qach_QaQ_def)

declare subst_def [simp]

lemma qach_QaQ7: "\<lbrakk> qach_QaQ E' h' a x C ; E' = E\<lfloor>x:=E\<lfloor>y\<rfloor>\<rfloor> \<rbrakk> \<Longrightarrow> qach_QaQ E h' a y C"
by (clarsimp, simp add: qach_QaQ_def)


(* --------------------------------------------------------------------------- *)
(*
lemma vdm_adapt_context: 
      "(insert (y\<diamondsuit>\<diamondsuit>mn, subst Q x y) G) \<rhd> e : P  
        \<Longrightarrow>
       (insert (x\<diamondsuit>\<diamondsuit>mn, Q) G) \<rhd> e : P"
apply (simp add: subst_def)
apply (induct_tac e)
sorry
*)

(* stuffed if we try to use vdm_adapt_context *)
lemma (in example1) bonzo999:
 "{(((MH_Invoke y foo)::'a expr), {(E,h,hh,v,p). v = IVal 1})} 
  \<rhd> (MH_Invoke x foo) : {(E,h,hh,v,p). v = IVal 1}"
apply (rule vdm_adapt_context)
apply (rule vdm_ax)
apply auto
(* subgoal on Env left: \<exists> E. a = E\<lfloor>x:=E\<lfloor>y\<rfloor>\<rfloor> *)
oops

(* ok if we use vdm_adapt_context_with_bonzo *)
lemma (in example1) bonzo999:
 "{(((MH_Invoke y foo)::'a expr), {(E,h,hh,v,p). v = IVal 1})} 
  \<rhd> (MH_Invoke x foo) : {(E,h,hh,v,p). v = IVal 1}"
apply (rule vdm_adapt_context_with_bonzo)
apply (rule impI)
apply (rule vdm_ax)
apply (simp add: not_free_in_assn_def)
apply auto
oops

(* --------------------------------------------------------------------------- *)

locale example2 =
  fixes   n  :: iname
  fixes   count  :: ifldname
  fixes   x  :: rname
  fixes   y  :: rname
  fixes   a1 :: locn
  fixes   myid :: mname
  fixes   MyId :: cname
  assumes foobody: "methtable MyId myid = ((LET n = GetFi self count IN n\<^sup>I END)::'a expr)"
  (* assumes foospec: "spectable MyId myid = {(E,h,hh,v,p). v = E<x\<bullet>count> \<and> hh=h \<and> p=\<langle>1 0 0 0\<rangle>}" *)

lemma (in example2)
 "{(% s b . (((MH_Invoke s myid)::'a expr), {(E,h,hh,v,p). \<forall> a . E\<lfloor>s\<rfloor> = Ref a \<longrightarrow> v = IVal h<a\<bullet>count>}))} 
  \<rhd> (MH_Invoke x myid) : {(E,h,hh,v,p). \<forall> a . E\<lfloor>x\<rfloor> = Ref a \<longrightarrow> v = IVal h<a\<bullet>count>}"
(*
apply (rule vdm_adapt_context_with_bonzo)
apply (rule impI)
*)
(* apply (rule vdm_conseq) *)
apply (rule vdm_ax)
defer 1
defer 1
apply simp
apply auto
defer 1
apply (subgoal_tac "subst {(E, h, hh, v, p). \<forall>a. E\<lfloor>y\<rfloor> = Ref a \<longrightarrow> v = IVal h<a\<bullet>count>} x y \<subseteq> {(E, h, hh, v, p). \<forall>a. E\<lfloor>x\<rfloor> = Ref a \<longrightarrow> v = IVal h<a\<bullet>count>}")
defer 1
apply clarsimp
apply fastsimp
apply clarsimp
apply (simp add: not_free_in_assn_def)
apply fastsimp
apply (erule_tac x="ad" in allE)
apply (drule mp)
apply clarsimp
apply auto
defer 1
apply auto
apply (rename_tac E h v)
apply (simp add: not_free_in_assn_def)
apply (erule_tac x="y" in allE, rotate_tac -1)
apply (erule_tac x="E" in allE, rotate_tac -1)
apply (erule_tac x="h" in allE, rotate_tac -1)
apply (erule_tac x="v" in allE, rotate_tac -1)
apply (drule mp) defer 1
 apply (erule exE)
 apply (rule_tac x="E0" in exI)
 apply clarsimp
apply (erule_tac x="a" in allE)
apply (erule impE)
apply (erule_tac x="a" in allE)
apply auto
end