(* Time-stamp: <Thu Aug 28 2003 00:45:09 Stardate: [-29]0809.74 hwloidl> 
   $Id: Adapt.thy,v 1.1 2003/08/28 16:32:01 a1hloidl Exp $ 

   Adaptation (substitution) lemmas for invokes
*)

theory Adapt = Main + Lemmas + VDM (*  + VDMderived *):

(* --------------------------------------------------------------------------- *)
(* inlined from VDMderived; ToDo: import that module instead! *)

section {* Imports *}

lemma CtxtWeak: "G \<rhd> e : P \<Longrightarrow> (G \<union> D) \<rhd> e : P"
apply (erule vdm_proof.induct)
apply (rule vdm_conseq, fast, simp)
apply (rule vdm_null)
apply (rule vdm_int)
apply (rule vdm_ivar)
apply (rule vdm_rvar)
apply (rule vdm_prim)
apply (rule vdm_rprim)
apply (rule vdm_getfi)
apply (rule vdm_getfr)
apply (rule vdm_putfi)
apply (rule vdm_putfr)
apply (rule vdm_new)
apply (rule vdm_if, simp, simp)
apply (rule vdm_leti, simp, simp)
apply (rule vdm_letr, simp, simp)
apply (rule vdm_letv, simp, simp)
apply (rule vdm_call, simp)
apply (rule vdm_mhinvokestatic, simp)
apply (rule vdm_mhinvoke, simp)
apply (rule vdm_invokestatic, simp)
apply (rule vdm_invoke, simp)
apply (rule vdm_ax, simp)
done

(* this is soooooooooooooooooooo saaaaaaaaaaaaaaaaaaaaaaad (but it bloody works!) *)
lemma CtxtWeak': "G \<rhd> e : P \<Longrightarrow> (D \<union> G) \<rhd> e : P"
apply (erule vdm_proof.induct)
apply (rule vdm_conseq, fast, simp)
apply (rule vdm_null)
apply (rule vdm_int)
apply (rule vdm_ivar)
apply (rule vdm_rvar)
apply (rule vdm_prim)
apply (rule vdm_rprim)
apply (rule vdm_getfi)
apply (rule vdm_getfr)
apply (rule vdm_putfi)
apply (rule vdm_putfr)
apply (rule vdm_new)
apply (rule vdm_if, simp, simp)
apply (rule vdm_leti, simp, simp)
apply (rule vdm_letr, simp, simp)
apply (rule vdm_letv, simp, simp)
apply (rule vdm_call, simp)
apply (rule vdm_mhinvokestatic, simp)
apply (rule vdm_mhinvoke, simp)
apply (rule vdm_invokestatic, simp)
apply (rule vdm_invoke, simp)
apply (rule vdm_ax, simp)
done

(* --------------------------------------------------------------------------- *)

section {* Definitions *}

subsection {* Substitutions on assertions *}

text {* 
Substitutions on assertions are needed to adapt assertions in context to the body
when we meet a recursive call. Since we use a shallow embedding of assertions, all
we have to do is to modify the environment to take the substituter instead of the
substitee. Since we only need this to substitute argument for formal parameter,
we only have to define the case of substituting rname for rname.
*}

constdefs subst :: "vdmassn \<Rightarrow> rname \<Rightarrow> rname \<Rightarrow> vdmassn"
"subst P y x \<equiv> {(E,h,hh,v,p). (E\<lfloor>x := E\<lfloor>y\<rfloor>\<rfloor>,h,hh,v,p) \<in> P}"

constdefs nuke :: "rname \<Rightarrow> vdmassn \<Rightarrow> vdmassn"
"nuke y P \<equiv> {(E,h,hh,v,p). (E\<lfloor>y := Nullref\<rfloor>,h,hh,v,p) \<in> P}"

constdefs not_free_in_assn :: "rname \<Rightarrow> vdmassn \<Rightarrow> bool"
"not_free_in_assn y Q \<equiv> \<forall> x E h hh v p. (E,h,hh,v,p) \<in> Q \<longrightarrow> (E\<lfloor>y:=E\<lfloor>x\<rfloor>\<rfloor>,h,hh,v,p) \<in> Q"

lemmas petaQ_lemmas = subst_def nuke_def not_free_in_assn_def

(* if x=x' then (RVar y') else (RVar x')" *)
(* synt_subst e y x \<dots> substitute y for x in e *)

consts synt_subst :: "'a expr \<Rightarrow> rname \<Rightarrow> rname  \<Rightarrow> 'a expr"
primrec
"synt_subst (expr.Int i) y' x'    = (expr.Int i)"
"synt_subst (IVar x) y' x'        = (IVar x)"
"synt_subst (Primop f x y) y' x'  = (Primop f x y)"
"synt_subst (expr.Null) y' x'     = (expr.Null)"
"synt_subst (RPrimop f x y) y' x' = (if (x=x') 
                                      then (if (y=x') then (RPrimop f y' y') else (RPrimop f y' y)) 
                                      else (if (y=x') then (RPrimop f x y') else (RPrimop f x y)))"
"synt_subst (RVar x) y' x'        = (if (x=x') then (RVar y') else (RVar x))"
"synt_subst (New C ifldvals rfldvals) y' x' = (New C ifldvals rfldvals)"
"synt_subst (GetFi x f) y' x'     = (if (x=x') then (GetFi y' f) else (GetFi x f))" 
"synt_subst (GetFr x f) y' x'     = (if (x=x') then (GetFr y' f) else (GetFr x f))" 
"synt_subst (PutFi x f y) y' x'   = (if (x=x') then (PutFi y' f y) else (PutFi x f y))" 
"synt_subst (PutFr x f y) y' x'   = (if (x=x') 
                                       then (if (y=x') then (PutFr y' f y') else (PutFr y' f y)) 
                                       else (if (y=x') then (PutFr x f y') else (PutFr x f y)))" 
"synt_subst (Invoke x m y) y' x'  = (if (x=x') 
                                       then (if (y=x') then (Invoke y' m y') else (Invoke y' m y)) 
                                       else (if (y=x') then (Invoke x m y') else (Invoke x m y)))" 
"synt_subst (InvokeStatic C m y) y' x' = (if (y=x') then (InvokeStatic C m y') else (InvokeStatic C m y))" 
"synt_subst (MH_Invoke x m) y' x' = (if (x=x') then (MH_Invoke y' m) else (MH_Invoke x m))" 
"synt_subst (MH_InvokeStatic C m) y' x' = (MH_InvokeStatic C m)"  
"synt_subst (Leti x e1 e2) y' x'  = (Leti x (synt_subst e1 y' x') (synt_subst e2 y' x'))" 
"synt_subst (Letr x e1 e2) y' x'  = (Letr x (synt_subst e1 y' x') (synt_subst e2 y' x'))" 
"synt_subst (Letv e1 e2) y' x'    = (Letv (synt_subst e1 y' x') (synt_subst e2 y' x'))" 
"synt_subst (Ifg x e1 e2) y' x'   = (Ifg x (synt_subst e1 y' x') (synt_subst e2 y' x'))"
"synt_subst (Call f) y' x'        = (Call f)"

consts BV :: "'a expr \<Rightarrow> rname list"
primrec
"BV (expr.Int i)    = []"
"BV (IVar x)        = []"
"BV (Primop f x y)  = []"
"BV (expr.Null)     = []"
"BV (RPrimop f x y) = []"
"BV (RVar x)        = []"
"BV (New C ifldvals rfldvals) = []"
"BV (GetFi x f)     = []"
"BV (GetFr x f)     = []"
"BV (PutFi x f y)   = []"
"BV (PutFr x f y)   = []"
"BV (Invoke x m y)  = []"
"BV (InvokeStatic C m y) = []"
"BV (MH_Invoke x m) = []"
"BV (MH_InvokeStatic C m) = []"
"BV (Leti x e1 e2)  = (BV e1) @ (BV e2)"
"BV (Letr x e1 e2)  = x # ((BV e1) @ (BV e2))"
"BV (Letv e1 e2)    = (BV e1) @ (BV e2)"
"BV (Ifg x e1 e2)   = (BV e1) @ (BV e2)"
"BV (Call f)        = []"

consts FV :: "'a expr \<Rightarrow> rname list"
primrec
"FV (expr.Int i)    = []"
"FV (IVar x)        = []"
"FV (Primop f x y)  = []"
"FV (expr.Null)     = []"
"FV (RPrimop f x y) = [x]"
"FV (RVar x)        = [x]"
"FV (New C ifldvals rfldvals) = []"
"FV (GetFi x f)     = [x]"
"FV (GetFr x f)     = [x]"
"FV (PutFi x f y)   = [x]"
"FV (PutFr x f y)   = [x,y]"
"FV (Invoke x m y)  = [x,y]"
"FV (InvokeStatic C m y) = [y]"
"FV (MH_Invoke x m) = [x]"
"FV (MH_InvokeStatic C m) = []"
"FV (Leti x e1 e2)  = (FV e1) @ (FV e2)"
"FV (Letr x e1 e2)  = (FV e1) @ (FV e2)"
"FV (Letv e1 e2)    = (FV e1) @ (FV e2)"
"FV (Ifg x e1 e2)   = (FV e1) @ (FV e2)"
"FV (Call f)        = []"

subsection {* sanity checks on subst *}

lemma "\<lbrakk> x \<in> set (FV e) \<rbrakk> \<Longrightarrow> y \<in> set (FV (synt_subst e y x))"
oops

lemma "\<lbrakk> x \<in> set (FV e) ; y \<in> set (FV e) \<rbrakk> \<Longrightarrow> set (FV (synt_subst e y x)) = (set (FV e)) - {x}"
oops

lemma "\<lbrakk> P = {(E,h,hh,v,p). v = IVal (grailbool (E\<lfloor>x\<rfloor>=Nullref))} ; G \<rhd> ((RVar x)::'a expr) : P \<rbrakk> 
       \<Longrightarrow> G \<rhd> ((RVar y)::'a expr) : (subst P y x)"
apply (simp add: subst_def)
apply clarsimp
(* subst'ed assn looks ok; don't bother to prove *)
oops

lemma "not_free_in_assn y {(E,h,hh,v,p). v = IVal 0 \<and> E<x>=1 \<and> h=hh}"
apply (simp add: not_free_in_assn_def subst_def)
done

lemma "\<lbrakk> x \<noteq> y ; not_free_in_assn y Q \<rbrakk>  \<Longrightarrow> not_free_in_assn x (subst Q y x)"
apply (simp add: petaQ_lemmas)
apply clarsimp
apply (erule_tac x="x" in allE)
apply (erule_tac x="E\<lfloor>x:=E\<lfloor>y\<rfloor>\<rfloor>" in allE)
apply (erule_tac x="h" in allE)
apply (erule_tac x="hh" in allE)
apply (erule_tac x="v" in allE)
apply (erule_tac x="p" in allE)
apply clarsimp
apply (subgoal_tac "E\<lfloor>x:=E\<lfloor>y\<rfloor>\<rfloor> = E\<lfloor>x:=E\<lfloor>x:=E\<lfloor>xa\<rfloor>\<rfloor>\<lfloor>y\<rfloor>\<rfloor>")
 (* use subgoal *)
 apply clarsimp
 (* prove subgoal *)
 apply (rule E_ext)
 apply clarsimp
 apply clarsimp
apply (subgoal_tac "E\<lfloor>x:=E\<lfloor>xa\<rfloor>\<rfloor>\<lfloor>y\<rfloor> = E\<lfloor>y\<rfloor>")
 apply clarsimp
 (* .. *)
 apply (subgoal_tac "y \<noteq> x")
  apply (frule rvarUpdOther)
  apply clarsimp
apply clarsimp
done

(* --------------------------------------------------------------------------- *)

section {* Lemmas *}

subsection {* Aux lemmas *}

(*
lemma petaQ2: "\<lbrakk> not_free_in_assn y Q ; \<Turnstile> e : Q \<rbrakk> \<Longrightarrow> \<Turnstile> e : subst Q y x"
apply (simp add: petaQ_lemmas vdm_valid_def)
apply clarsimp
apply (erule_tac x="E" in allE)
apply (erule_tac x="h" in allE)
apply (erule_tac x="hh" in allE)
apply (erule_tac x="v" in allE)
apply (erule_tac x="p" in allE)
apply clarsimp
oops
*)

subsection {* Adaptation Lemmas *}

subsection {* adaptation over context *}

(* fusion of adapt and ax rule; specialised for MH_Invoke *)
lemma vdm_adapt_ax_context_fwd: 
      "\<lbrakk> (x\<diamondsuit>\<diamondsuit>mn,Q) \<in> G \<rbrakk> 
        \<Longrightarrow>
         G \<rhd> (y\<diamondsuit>\<diamondsuit>mn) : subst Q y x"
apply (frule vdm_ax)
apply (rule vdm_mhinvoke)
apply clarsimp
oops

(* fusion of adapt and ax rule; specialised for MH_Invoke 
lemma vdm_adapt_ax_context: 
      "\<lbrakk> (y\<diamondsuit>\<diamondsuit>mn, subst Q y x) \<in> G \<rbrakk> 
        \<Longrightarrow>
         G \<rhd> (x\<diamondsuit>\<diamondsuit>mn) : Q"
apply (rule vdm_ax)
apply (simp add: subst_def)
oops
*)
lemma vdm_adapt_context: 
      "\<lbrakk> (insert (y\<diamondsuit>\<diamondsuit>mn, subst Q y x) G) \<rhd> e : P \<rbrakk> 
        \<Longrightarrow>
       (insert (x\<diamondsuit>\<diamondsuit>mn, Q) G) \<rhd> e : P"
apply (erule vdm_proof.induct)
defer 1 (* consequence *)
prefer 21
(* Ax *)
apply (rule vdm_ax)
defer 1 
apply (tactic {* all_tac *})
(* Null *)
apply (rule vdm_null)
(* Int *)
apply (rule vdm_int)
(* IVar *)
apply (rule vdm_ivar)
(* RVar *)
apply (rule vdm_rvar)
(* Primop *)
apply (rule vdm_prim)
(* RPrimop *)
apply (rule vdm_rprim)
(* GetFi *)
apply (rule vdm_getfi)
(* GetFr *)
apply (rule vdm_getfr)
(* PutFi *)
apply (rule vdm_putfi)
(* PutFr *)
apply (rule vdm_putfr)
(* New *)
apply (rule vdm_new)
(* If *)
apply (rule vdm_if) apply assumption apply assumption
(* Leti *)
apply (rule vdm_leti) apply assumption apply assumption
(* Letr *)
apply (rule vdm_letr) apply assumption apply assumption
(* Letv *)
apply (rule vdm_letv) apply assumption apply assumption
prefer 3
(* MH_Invoke *)
apply (rule vdm_mhinvoke)
apply clarsimp
apply (erule_tac x="E'" in allE)
apply (erule_tac x="h'" in allE)
apply (erule_tac x="a" in allE)
apply (erule_tac x="C" in allE)
apply (drule mp) apply assumption
apply (erule conjE)
apply (rotate_tac -1)
apply (simp only: insert_def)
(* apply (simp only: Un_commute) *)
apply (rule CtxtWeak')
apply simp
(* Call *)
apply (rule vdm_call)
apply (rotate_tac -1)
apply (simp only: insert_def)
apply (rule CtxtWeak)
apply simp
(* MH_INvokeStatic *)
apply (rule vdm_mhinvokestatic)
apply (rotate_tac -1)
apply (simp only: insert_def)
apply (rule CtxtWeak)
apply simp
(* InvokeStatic *)
apply (rule vdm_invokestatic)
apply clarsimp
apply (erule_tac x="E'" in allE)
apply (erule conjE)
apply (rotate_tac -1)
apply (simp only: insert_def)
apply (rule CtxtWeak')
apply simp
(* Invoke *)
apply (rule vdm_invoke)
apply clarsimp
apply (erule_tac x="E'" in allE)
apply (erule_tac x="h'" in allE)
apply (erule_tac x="a" in allE)
apply (erule_tac x="C" in allE)
apply (drule mp) apply assumption
apply (erule conjE)
apply (rotate_tac -1)
apply (simp only: insert_def)
apply (rule CtxtWeak')
apply simp
(* Consequence *)
apply (rule vdm_conseq)
apply fastsimp
apply assumption
(* only ax-case remains *)
(* Ga and G unrelated! *)
sorry

(*
lemma vdm_adapt_and_petaQ:
    "\<lbrakk> not_free_in_assn y Q  \<longrightarrow>
     (insert (y\<diamondsuit>\<diamondsuit>mn, subst Q y x) G) \<rhd> e : P \<rbrakk>
     \<Longrightarrow>
     (insert (x\<diamondsuit>\<diamondsuit>mn, Q) G) \<rhd> e : P"
sorry
*)

lemma vdm_adapt_1337:
    "\<lbrakk> not_free_in_assn y Q ;
     (insert (y\<diamondsuit>\<diamondsuit>mn, subst Q y x) G) \<rhd> e : P \<rbrakk>
     \<Longrightarrow>
     (insert (x\<diamondsuit>\<diamondsuit>mn, Q) G) \<rhd> e : P"
apply (rule vdm_proof.induct)
defer 1 (* consequence *)
defer 1 (* consequence *)
(* Null *)
apply (rule vdm_null)
(* Int *)
apply (rule vdm_int)
(* IVar *)
apply (rule vdm_ivar)
(* RVar *)
apply (rule vdm_rvar)
(* Primop *)
apply (rule vdm_prim)
(* RPrimop *)
apply (rule vdm_rprim)
(* GetFi *)
apply (rule vdm_getfi)
(* GetFr *)
apply (rule vdm_getfr)
(* PutFi *)
apply (rule vdm_putfi)
(* PutFr *)
apply (rule vdm_putfr)
(* New *)
apply (rule vdm_new)
(* If *)
apply (rule vdm_if) apply assumption apply assumption
(* Leti *)
apply (rule vdm_leti) apply assumption apply assumption
(* Letr *)
apply (rule vdm_letr) apply assumption apply assumption
(* Letv *)
apply (rule vdm_letv) apply assumption apply assumption
prefer 3
(* MH_Invoke *)
apply (rule vdm_mhinvoke)
apply clarsimp
(* Call *)
apply (rule vdm_call)
apply clarsimp
(* MH_INvokeStatic *)
apply (rule vdm_mhinvokestatic)
apply clarsimp
(* InvokeStatic *)
apply (rule vdm_invokestatic)
apply clarsimp
(* Invoke *)
apply (rule vdm_invoke)
apply clarsimp
(* Ax *)
apply (rule vdm_ax)
apply assumption
defer 1
(* Consequence *)
apply (rule vdm_conseq)
apply fastsimp
apply assumption
oops

subsection {* general adaptation over expr *}

(* adaptation over expr; needs syntactic substitution in general *)
lemma vdm_adapt_subject_fwd: 
      "\<lbrakk> x \<noteq> y ; y \<notin> set (FV e) ; G \<rhd> e : P \<rbrakk> 
        \<Longrightarrow>
       G \<rhd> (synt_subst e y x) : (subst P y x)"
apply (rule vdm_proof.induct)
defer 1
defer 1
apply (rule vdm_null)
apply (rule vdm_int)
apply (rule vdm_ivar)
apply (rule vdm_rvar)
apply (rule vdm_prim)
apply (rule vdm_rprim)
apply (rule vdm_getfi)
apply (rule vdm_getfr)
apply (rule vdm_putfi)
apply (rule vdm_putfr)
apply (rule vdm_new)
apply (rule vdm_if) apply assumption apply assumption 
apply (rule vdm_leti) apply assumption apply assumption 
apply (rule vdm_letr) apply assumption apply assumption 
apply (rule vdm_letv) apply assumption apply assumption 
apply (rule vdm_call) apply assumption 
apply (rule vdm_mhinvokestatic) apply assumption
apply (rule vdm_mhinvoke) apply clarsimp defer 1
apply (rule vdm_invoke) apply clarsimp 
prefer 4
apply (rule vdm_invokestatic) apply clarsimp 
oops

(* general adaptation combined with axiom rule; forward reasoning *)
lemma vdm_adapt_ax_fwd: 
      "\<lbrakk> x \<noteq> y ; y \<notin> set (FV e) ; (e,P) \<in> G \<rbrakk> 
       \<Longrightarrow>
       G \<rhd> (synt_subst e y x) : (subst P y x)"
apply (rule synt_subst.induct)
apply (rule vdm_ax)
apply (simp add: subst_def)
oops

(* general adaptation combined with axiom rule; backward reasoning *)
lemma vdm_adapt_ax: 
      "\<lbrakk> x \<noteq> y ; y \<notin> set (FV e) ; ((synt_subst e y x),(subst P y x)) \<in> G \<rbrakk> 
       \<Longrightarrow>
       G \<rhd> e : P"
oops

(* specialied for MH_Invoke *)
lemma vdm_adapt_subject_MHInvoke_fwd: 
      "\<lbrakk> not_free_in_assn y P ; G \<rhd> (x\<diamondsuit>\<diamondsuit>mn) : P \<rbrakk> 
        \<Longrightarrow>
       G \<rhd> (y\<diamondsuit>\<diamondsuit>mn) : subst P y x"
apply (simp add: not_free_in_assn_def subst_def)
apply (rule vdm_mhinvoke)
apply (frule vdm_conseq)
defer 1
apply clarsimp
oops

lemma vdm_adapt_subject_MHInvoke: 
      "\<lbrakk> not_free_in_assn y P ; G \<rhd> (y\<diamondsuit>\<diamondsuit>mn) : subst P y x  \<rbrakk> 
        \<Longrightarrow>
       G \<rhd> (x\<diamondsuit>\<diamondsuit>mn) : P"
apply (simp add: not_free_in_assn_def subst_def)
apply (rule vdm_conseq)
defer 1
apply (subgoal_tac "{(E,h,hh,v,p). (E\<lfloor>y:=E\<lfloor>x\<rfloor>\<rfloor>, h, hh, v, p) \<in> P} \<subseteq> P")
 apply auto
apply (erule_tac x="x" in allE)
apply (erule_tac x="E" in allE)
apply (erule_tac x="h" in allE)
apply (erule_tac x="hh" in allE)
apply (erule_tac x="v" in allE)
apply (erule_tac x="p" in allE)
oops


end

(* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ *)
(*
subsection {* specialised rules for certain situtations *}

(* side condition: y is an alias for x *)
lemma vdm_adapt_with_alias: "\<lbrakk> \<rhd> x\<diamondsuit>\<diamondsuit>mn : Q ; (\<forall> E h hh v p C a. (E,h,hh,v,p) \<in> Q \<longrightarrow> qach_QaQ E h a x C \<longrightarrow> qach_QaQ E h a y C) \<rbrakk> \<Longrightarrow>
                             \<rhd> y\<diamondsuit>\<diamondsuit>mn : Q"
(* apply (insert vdm_adapt_bonzo) *)
apply (simp add: subst_def nuke_def)
apply (rule vdm_mhinvoke)
apply clarsimp
apply (simp add: qach_QaQ_def)
apply (erule vdm_proof.elims)
apply (simp_all)
apply clarsimp
defer 1
apply (simp add: qach_QaQ_def)
apply (rotate_tac -1)
apply (erule_tac x="E'" in allE, rotate_tac -1)
apply (erule_tac x="h'" in allE, rotate_tac -1)
apply (erule_tac x="a" in allE, rotate_tac -1)
apply (erule_tac x="C" in allE, rotate_tac -1)
apply (rotate_tac -1)
apply (erule conjE, rotate_tac -1)
apply (erule conjE, rotate_tac -1)
apply (erule conjE, rotate_tac -1)
apply (erule conjE, rotate_tac -1)
apply (rotate_tac 1)
apply clarsimp
apply (rotate_tac -3)
apply (erule_tac x="E'" in allE, rotate_tac -1)
apply (erule_tac x="h'" in allE, rotate_tac -1)
apply (drule mp)
 defer 1
 apply (rotate_tac -1)
 apply (erule_tac x="C" in allE, rotate_tac -1)
 apply (erule_tac x="a" in allE, rotate_tac -1)
 apply (drule mp) defer 1 (* apply (rule conjI) apply assumption apply assumption *)
apply (subgoal_tac "E'\<lfloor>x\<rfloor> = E'\<lfloor>y\<rfloor>")
 apply clarsimp
oops

lemma vdm_adapt_ctxt_with_alias: "\<lbrakk> {(x\<diamondsuit>\<diamondsuit>mn, Q)} \<rhd> e : Q ; (\<forall> E h hh v p C a. (E,h,hh,v,p) \<in> Q \<longrightarrow> qach_QaQ E h a x C \<longrightarrow> qach_QaQ E h a y C) \<rbrakk> \<Longrightarrow> {(y\<diamondsuit>\<diamondsuit>mn, Q)} \<rhd> e : Q"
apply (simp add: qach_QaQ_def subst_def nuke_def)
apply (case_tac e)
apply (erule vdm_proof.elims)
apply (simp_all)
apply clarsimp 
apply (rule vdm_conseq)
apply (rule vdm_int)
apply (clarsimp) defer 1

(* apply (rule vdm_conseq, rule vdm_null, clarsimp) *)
apply (rule vdm_conseq, rule vdm_int, clarsimp) apply clarsimp
apply (rule vdm_conseq, rule vdm_ivar, clarsimp) defer 1
(* apply (rule vdm_conseq, rule vdm_rvar, clarsimp) defer 1 *)
apply (rule vdm_conseq, rule vdm_prim, clarsimp) defer 1
apply (rule vdm_conseq, rule vdm_null, clarsimp) defer 1
apply (rule vdm_conseq, rule vdm_rvar, clarsimp) defer 1
apply (rule vdm_conseq, rule vdm_rprim, clarsimp) defer 1
apply (rule vdm_conseq, rule vdm_new, clarsimp) defer 1
apply (rule vdm_conseq, rule vdm_getfi, clarsimp) defer 1
apply (rule vdm_conseq, rule vdm_getfr, clarsimp) defer 1
apply (rule vdm_conseq, rule vdm_putfi, clarsimp) defer 1
apply (rule vdm_conseq, rule vdm_putfr, clarsimp) defer 1
defer 1 (* defer invoke *)
defer 1 (* defer invoke *)
defer 1 (* defer invoke *)
defer 1 (* defer invoke *)
apply (rule vdm_conseq, rule vdm_leti, clarsimp) defer 1 defer 1 defer 1
apply (rule vdm_conseq, rule vdm_letr, clarsimp) defer 1 defer 1 defer 1
apply (rule vdm_conseq, rule vdm_letv, clarsimp) defer 1 defer 1 defer 1
apply (rule vdm_conseq, rule vdm_if, clarsimp) defer 1 defer 1 defer 1
apply (rule vdm_conseq, rule vdm_call, clarsimp) defer 1 defer 1 defer 1
apply auto
sorry (* , NOT! *)

lemma vdm_adapt_ctxt_with_alias: "\<lbrakk> {(x\<diamondsuit>\<diamondsuit>mn, Q)} \<rhd> e : Q ; (\<forall> E h hh v p C a. (E,h,hh,v,p) \<in> Q \<longrightarrow> qach_QaQ E h a x C \<longrightarrow> qach_QaQ E h a y C) \<rbrakk> \<Longrightarrow> {(y\<diamondsuit>\<diamondsuit>mn, Q)} \<rhd> e : Q"
apply (simp add: qach_QaQ_def subst_def nuke_def)
apply (induct e)
apply (simp_all)
(* apply (rule vdm_conseq, rule vdm_null, clarsimp) *)
apply (erule vdm_proof.elims)
apply simp_all
defer 1
apply (rule vdm_conseq)
apply (rule vdm_int)
apply (clarsimp)
apply (clarsimp)
apply (erule vdm_proof.elims)
apply simp_all
defer 1
apply (rule vdm_conseq)
apply (rule vdm_ivar)
apply (clarsimp)
apply (clarsimp)
apply (erule vdm_proof.elims)
apply simp_all
defer 1
apply (rule vdm_conseq)
apply (rule vdm_prim)
apply (clarsimp)
apply (clarsimp)
apply (erule vdm_proof.elims)
apply simp_all
defer 1
apply (rule vdm_conseq)
apply (rule vdm_null)
apply (clarsimp)
apply (clarsimp)
apply (erule vdm_proof.elims)
apply simp_all
defer 1
apply (rule vdm_conseq)
apply (rule vdm_rvar)
apply (clarsimp)
apply (clarsimp)
apply (erule vdm_proof.elims)
apply simp_all
defer 1
apply (rule vdm_conseq)
apply (rule vdm_rprim)
apply (clarsimp)
apply (clarsimp)
apply (erule vdm_proof.elims)
apply simp_all
defer 1
apply (rule vdm_conseq)
apply (rule vdm_new)
apply (clarsimp)
apply (clarsimp)
apply (erule vdm_proof.elims)
apply simp_all
defer 1
apply (rule vdm_conseq)
apply (rule vdm_getfi)
apply (clarsimp)
apply (clarsimp)
apply (erule vdm_proof.elims)
apply simp_all
defer 1
apply (rule vdm_conseq)
apply (rule vdm_getfr)
apply (clarsimp)
apply (clarsimp)
apply (erule vdm_proof.elims)
apply simp_all
defer 1
apply (rule vdm_conseq)
apply (rule vdm_putfi)
apply (clarsimp)
apply (clarsimp)
apply (erule vdm_proof.elims)
apply simp_all
defer 1
apply (rule vdm_conseq)
apply (rule vdm_putfr)
apply (clarsimp)
apply (clarsimp)
defer 1 (* defer this invoke *)
defer 1 (* defer this invoke *)
defer 1 (* defer this invoke *)
defer 1 (* defer this invoke *)
apply (erule vdm_proof.elims)
apply simp_all
defer 1
apply (rule vdm_conseq)
apply (rule vdm_leti) apply safe prefer 3 apply auto defer 1 
apply (clarsimp)
prefer 2
apply (clarsimp)
defer 1 (* apply (clarsimp) *)
defer 1 (* apply (clarsimp) *)
defer 1 (* apply (clarsimp) *)
defer 1 (* apply (clarsimp) *)
apply (erule vdm_proof.elims)
apply simp_all
defer 1
apply (rule vdm_conseq)
apply (rule vdm_letr)
apply (clarsimp)
apply (clarsimp)
apply (erule vdm_proof.elims)
apply simp_all
defer 1
apply (rule vdm_conseq)
apply (rule vdm_leti)
apply (clarsimp)
apply (clarsimp)
apply (erule vdm_proof.elims)
apply simp_all
defer 1
apply (rule vdm_conseq)
apply (rule vdm_letr)
apply (clarsimp)
apply (clarsimp)
apply (erule vdm_proof.elims)
apply simp_all
defer 1
apply (rule vdm_conseq)
apply (rule vdm_letv)
apply (clarsimp)
apply (clarsimp)

apply (rule vdm_conseq, rule vdm_int, clarsimp)
apply (rule vdm_conseq, rule vdm_ivar, clarsimp)
apply (rule vdm_conseq, rule vdm_rvar, clarsimp)
apply (rule vdm_conseq, rule vdm_prim, clarsimp)
apply (rule vdm_conseq, rule vdm_rprim, clarsimp)
apply (rule vdm_conseq, rule vdm_getfi, clarsimp)
apply (rule vdm_conseq, rule vdm_getfr, clarsimp)
apply (rule vdm_conseq, rule vdm_putfi, clarsimp)
apply (rule vdm_conseq, rule vdm_putfr, clarsimp)
apply (rule vdm_conseq, rule vdm_new, clarsimp)
apply (rule vdm_conseq, rule vdm_if, clarsimp)
apply (rule vdm_conseq, rule vdm_leti, clarsimp)
apply (rule vdm_conseq, rule vdm_letr, clarsimp)
apply (rule vdm_conseq, rule vdm_letv, clarsimp)


defer 1
apply (simp add: qach_QaQ_def)
apply (rotate_tac -1)
oops

lemma vdm_adapt_something: "\<lbrakk> \<rhd> x\<diamondsuit>\<diamondsuit>mn : Q ; (\<forall> E h hh v p C a. ((E,h,hh,v,p) \<in> Q \<and> qach_QaQ E h a x C) \<longrightarrow> qach_QaQ E h a y C) \<rbrakk> \<Longrightarrow>
                             \<rhd> y\<diamondsuit>\<diamondsuit>mn : (subst Q y x)"
(* apply (insert vdm_adapt_bonzo) *)
apply (simp add: subst_def nuke_def)
apply (rule vdm_mhinvoke)
apply clarsimp
apply (simp add: qach_QaQ_def)
apply (erule vdm_proof.elims)
apply (simp_all)
apply clarsimp
defer 1
apply (simp add: qach_QaQ_def)
apply (rotate_tac 2)
apply (erule conjE, rotate_tac -1)
apply (erule conjE, rotate_tac -1)
apply (erule conjE, rotate_tac -1)
apply (tactic {* all_tac *})
apply (rotate_tac 1)
apply (erule_tac x="E'" in allE, rotate_tac -1)
apply (erule_tac x="h'" in allE, rotate_tac -1)
apply (erule_tac x="a" in allE, rotate_tac -1)
apply (erule_tac x="C" in allE, rotate_tac -1)
apply (tactic {* all_tac *})
apply clarsimp
apply (frule mp) defer 1 apply clarsimp
apply (rule vdm_conseq)
defer 1
apply clarsimp
apply (rule_tac x="E'\<lfloor>x:=Nullref\<rfloor>" in exI)
apply clarsimp
apply (tactic {* all_tac *})
apply (erule_tac x="E'" in allE, rotate_tac -1)
apply (erule_tac x="h'" in allE, rotate_tac -1)
apply (erule_tac x="hh" in allE, rotate_tac -1)
apply (erule_tac x="v" in allE, rotate_tac -1)
apply (erule_tac x="p" in allE, rotate_tac -1)
apply (erule_tac x="C" in allE, rotate_tac -1)
apply (erule_tac x="a" in allE, rotate_tac -1)
oops

lemma vdm_adapt_context: "\<forall> e .
        (insert (y\<diamondsuit>\<diamondsuit>mn, subst Q x y) G) \<rhd> e : P  
        -->
        (insert (x\<diamondsuit>\<diamondsuit>mn,Q) G) \<rhd> e : P
    "
apply (induct_tac e)
apply (simp add: subst_def)
apply (rule vdm_conseq)
apply (rule vdm_int)
apply simp
sorry
*)
