(* 				 
   File:	$RCSfile: VDMSound-rec.thy,v $
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: VDMSound-rec.thy,v 1.1 2003/08/29 00:13:58 a1hloidl Exp $

   Soundness proof of the VDM-style program logic w.r.t. the functional semantics.
*)

theory VDMSound = VDM :

subsection {* Induction lemmas for call, invoke and invokestatic *}

lemma calllemma[rule_format(no_asm)]: 
     "(\<forall> m. m<n \<longrightarrow> (\<Turnstile>\<^sub>m ((CALL fn)::'a expr) : P \<longrightarrow> (\<Turnstile>\<^sub>m ((funtable fn)::'a expr) :{(E,h,hh,v,p) . (E,h,hh,v,tkcall p) \<in> P})
		   \<longrightarrow> (\<Turnstile>\<^sub>n ((CALL fn)::'a expr) : P)))"
apply (induct_tac n)
apply (simp add: vdm_validn_def)
(* apply (clarify, drule no_zero_height_derivs, auto) *)
apply (simp (no_asm) add: vdm_validn_def)
apply (rule)
apply (case_tac "m=Suc n")
 apply rule
 apply clarsimp
 (* -- *)
 apply clarsimp
 apply (erule eval_cases)
 apply (erule_tac x=m in allE)
 apply (erule_tac x=ma in allE)
 apply (erule_tac x=ma in allE)
 apply (rotate_tac -1)
 apply (case_tac "ma \<le> m")
  apply clarsimp
  apply (erule_tac x="E" in allE, rotate_tac -1)
  apply (erule_tac x="h" in allE, rotate_tac -1)
  apply (erule_tac x="hh" in allE, rotate_tac -1)
  apply (erule_tac x="v" in allE, rotate_tac -1)
  apply (erule_tac x="pa" in allE, rotate_tac -1)
  apply clarsimp
  apply (case_tac "m=n")
   apply clarsimp
   defer 1
   (* -- *)
   apply (clarsimp)
sorry

subsection{*Soundness*}
(*the following theorem might need a calllemma (or invokelemmas),
  similar to ToyHLrec2 or 3, but not using the clock as measure. 
  Below is a first attempt.
*)  
theorem vdm_sound_ctxt: "(G \<rhd> e:P) \<Longrightarrow> (G \<Turnstile> e:P)"
(*all cases apart from call and 4 invokes go through*)
apply (erule vdm_proof.induct)
apply (simp_all add: vdm_valid_in_ctxt_def vdm_validn_def)
apply fastsimp
apply (clarsimp, erule semn.elims, simp_all)
apply (clarsimp, erule semn.elims, simp_all)
apply (clarsimp, erule semn.elims, simp_all)
apply (clarsimp, erule semn.elims, simp_all)
apply (clarsimp, erule semn.elims, simp_all)
apply (clarsimp, erule semn.elims, simp_all)
apply (clarsimp, erule semn.elims, simp_all)
apply (clarsimp, erule semn.elims, simp_all)
apply (clarsimp, erule semn.elims, simp_all)
apply (clarsimp, erule semn.elims, simp_all)
apply (clarsimp, erule semn.elims, simp_all)
(*If*)
apply (clarsimp, erule semn.elims, simp_all)
(*True*)
apply (clarsimp, rule_tac x=pa in exI, simp)
apply (erule_tac x="m" in allE)
apply (fast intro:ctxt_lower)
(*False*)
apply (clarsimp, rule_tac x=pa in exI, simp)
apply (erule_tac x="m" in allE)
apply (erule_tac x="m" in allE)
apply (fast intro:ctxt_lower)
(*Leti*)
apply (clarsimp, erule semn.elims, simp_all)
apply clarsimp
apply (rule_tac x=p1 in exI, rule_tac x=p2 in exI, rule_tac x=h1 in exI, rule_tac x=i in exI, simp, rule)
apply (erule_tac x="na" in allE)
apply (subgoal_tac "na < Suc(max na m)") 
apply (fast intro:ctxt_lower)
apply (simp add: max_def)
apply (erule_tac x="na" in allE)
apply (erule_tac x="m" in allE)
apply (subgoal_tac "m < Suc(max na m)") 
apply (fast intro:ctxt_lower)
apply (simp add: max_def)
(*Letr*)
apply (clarsimp, erule semn.elims, simp_all)
apply clarsimp
apply (rule_tac x=p1 in exI, rule_tac x=p2 in exI, rule_tac x=h1 in exI, rule_tac x=r in exI, simp, rule)
apply (erule_tac x="na" in allE)
apply (subgoal_tac "na < Suc(max na m)") 
apply (fast intro:ctxt_lower)
apply (simp add: max_def)
apply (erule_tac x="na" in allE)
apply (erule_tac x="m" in allE)
apply (subgoal_tac "m < Suc(max na m)") 
apply (fast intro:ctxt_lower)
apply (simp add: max_def)
(*Letv*)
apply (clarsimp, erule semn.elims, simp_all)
apply clarsimp
apply (rule_tac x=p1 in exI, rule_tac x=p2 in exI, rule_tac x=h1 in exI, simp, rule)
apply (rule_tac x="w" in exI)
apply (erule_tac x="na" in allE)
apply (subgoal_tac "na \<le> max na m") 
apply (case_tac "na = max na m")
  apply simp
  apply (subgoal_tac "na < max na m")
  apply (fast intro:ctxt_lower)
  apply simp
apply (simp add: max_def)
apply (erule_tac x="na" in allE)
apply (erule_tac x="m" in allE)
apply (subgoal_tac "m \<le> max na m") 
apply (case_tac "m = max na m")
  apply simp
  apply (subgoal_tac "m < max na m")
  apply (fast intro:ctxt_lower)
  apply simp
apply (simp add: max_def)
(*now only call and all invokes left*)
(*Call*)
(*
apply (erule_tac thin_rl)
apply (rule, rule, rule, rule, rule, rule, rule, rule)
apply (erule semn.elims)
apply (simp_all)
apply (erule_tac x="na" in allE)
apply (subgoal_tac "\<Turnstile>\<^sub>na (CALL fa):P")
 apply (frule mp)
 apply (rule ctxt_insertn)
 apply (simp add: ctxt_lower)
 apply assumption
 apply (erule_tac x="Ea" in allE)
 apply (erule_tac x="ha" in allE)
 apply (erule_tac x="h1" in allE)
 apply (erule_tac x="va" in allE)
 apply (erule_tac x="pa" in allE)
 apply clarsimp
*) (* got this far, leaving 1 subgoal: \<Turnstile>\<^sub>na CALL fa : P *)
(*Call*)
(*
apply (erule_tac thin_rl)
apply (rule, rule, rule, rule, rule, rule, rule, rule)
*)
apply clarsimp
apply (erule semn.elims, simp_all)
apply (erule_tac x="na" in allE)
apply (subgoal_tac "\<Turnstile>\<^sub>na (CALL fa):P")
 apply (frule mp)
 apply (rule ctxt_insertn)
 apply (simp only: ctxt_lower)
 (* apply assumption *)
 apply assumption
 apply (erule_tac x="Ea" in allE, rotate_tac -1)
 apply (erule_tac x="ha" in allE, rotate_tac -1)
 apply (erule_tac x="h1" in allE, rotate_tac -1)
 apply (erule_tac x="va" in allE, rotate_tac -1)
 apply (erule_tac x="pa" in allE, rotate_tac -1)
 apply clarsimp
(* 1 subgoal left:  \<Turnstile>\<^sub>na CALL fa : P *)
apply (simp add: vdm_validn_def)
apply clarsimp

apply (insert calllemma)
apply (rotate_tac -1)
apply clarsimp
apply (rule calllemma)
apply auto

apply (simp add: vdm_validn_def)
apply (induct_tac n)
oops

(* V1.3
apply clarsimp
apply (erule_tac thin_rl)
apply (erule semn.elims, simp_all, clarsimp)
apply (erule_tac x=na in allE)
apply (subgoal_tac "|\<Turnstile>\<^sub>na insert (CALL fa, P) G")
apply fast
apply (subgoal_tac "|\<Turnstile>\<^sub>na G")
prefer 2 apply (subgoal_tac "na < Suc na") apply (insert ctxt_lower, fast, simp)
apply (rotate_tac -1)
apply (erule thin_rl)
apply (subgoal_tac "\<Turnstile>\<^sub>na Call fa:P")
apply (insert ctxt_consn)
apply (subgoal_tac "|\<Turnstile>\<^sub>na {(Call fa, P)} \<union> G")
apply simp
apply fast
(*now prove \<Turnstile>\<^sub>na CALL fa : P*)
apply(rotate_tac -1)
apply (erule thin_rl)
apply (simp add: vdm_validn_def)
apply clarsimp
apply (rotate_tac -1)
apply (erule semn.elims, simp_all)
apply clarsimp
sorry
*)
(*
lemma calllemma[rule_format(no_asm)]: 
     "(\<forall> m fn P. m<n \<longrightarrow> (\<Turnstile>\<^sub>m ((CALL fn)::'a expr) : P \<longrightarrow> (\<Turnstile>\<^sub>m ((funtable fn)::'a expr) :{(E,h,hh,v,p) . (E,h,hh,v,tkcall p) \<in> P})
		   \<longrightarrow> (\<Turnstile>\<^sub>n ((CALL fn)::'a expr) : P)))"
apply (induct_tac n)
apply (simp add: vdm_validn_def)
apply clarsimp
apply (simp add: vdm_validn_def)
apply clarsimp
apply (case_tac "m=n")
prefer 2
apply (erule_tac x=m in allE) 
apply (subgoal_tac "m < n")
sorry*)(*
prefer 2 apply (rotate_tac 1) 
  apply (erule thin_rl) 
  apply (erule thin_rl) 
  apply (erule thin_rl) 
  apply (erule thin_rl)
  apply (rotate_tac 1) 
  apply (erule thin_rl)
  apply simp  
apply (erule thin_rl)
oops
  apply (rotate_tac -2) 
  apply (erule thin_rl)
apply (simp add: sem_def)
apply clarsimp
apply (erule semn.elims, simp_all)
apply clarsimp
apply simp
apply (subgoal_tac "(\<forall>E h hh v p.
              E \<turnstile> h , CALL fn \<Down> hh , v , p \<longrightarrow>
              renv.clock p = m \<longrightarrow> (E, h, hh, v, p) \<in> P) \<longrightarrow>
          (\<forall>E h hh v p.
              E \<turnstile> h , funtable fn \<Down> hh , v , p \<longrightarrow>
              renv.clock p = m \<longrightarrow>
              (E, h, hh, v,
               \<lparr>renv.clock = Suc m, callc = Suc (callc p), invkc = invkc p,
                  invkdpth = invkdpth p\<rparr>)
              \<in> P) \<longrightarrow>
          (\<forall>E h hh v p.
              E \<turnstile> h , CALL fn \<Down> hh , v , p \<longrightarrow>
              renv.clock p = n \<longrightarrow> (E, h, hh, v, p) \<in> P)")
prefer 2 apply (subgoal_tac "m < n") apply fast apply simp
apply (erule thin_rl)
apply (subgoal_tac "")
apply clarsimp
apply (simp add: vdm_validn_def)
apply (erule_tac x=m in allE)
apply (erule thin_rl)
apply (erule thin_rl)
apply (erule thin_rl)
apply (rotate_tac 1)
apply (erule thin_rl)
apply (erule thin_rl)
apply (erule thin_rl)
apply (erule semn.elims, simp_all)
apply (subgoal_tac "\<Turnstile>\<^sub>n CALL fn : P")
prefer 2 apply fastsimp 
apply (erule thin_rl)
apply (simp add: vdm_validn_def, clarsimp)
apply (erule semn.elims, simp_all)
apply clarsimp
apply (subgoal_tac "na < Suc na")
apply fastsimp
apply (erule_tac x="Ea" in allE)
apply (erule_tac x="ha" in allE)
apply (erule_tac x="h1" in allE)
apply (erule_tac x="va" in allE)
apply (erule_tac x="pa" in allE)
apply fastsimp
sorry
*)

text {* Finally, soundness in an empty context: *}
theorem vdm_sound: "\<forall> e P . (\<rhd> e : P  \<longrightarrow> \<Turnstile> e : P)"
apply (insert vdm_sound_ctxt [of "{}"])
apply (simp add: vdm_valid_in_ctxt_def vdm_validn_def vdm_valid_def sem_def)
apply fast
done
end
