(*  Examples from List.cmlt -> Grail*)

theory CmltList = VDMderived + ExampleListClass:

section {* Functional correctness and resource correctness *}

locale Listlength = 
  fixes    tag     :: iname and	   h       :: iname and    i       :: iname and	   b       :: iname
    and    l       :: rname and	   f       :: funame
    and	   fBody   :: "(int * int * int * int) expr"
  assumes  fbdy[simp]:  "funtable f =  LET tag = GetFi l TAG;
                                           b = Primop (% x y. if x = 0 then 1 else 0) tag tag
                                           IN IF b THEN IVar i
                                           ELSE LET  h = GetFi l HD;
                                                     i = Primop (% x y. x + 1) i i;
                                                 rf  l = (GetFr l TL)
                                                IN (Call f) END
                                                END"
      and  vardistinct: "distinct [tag,h,i,b] \<and> distinct [b,i,h,tag]"
      and spect[simp]: 
          "spectable f = {(E,h,hh,v,p) . \<forall> N .((\<exists> L . (L,E\<lfloor>l\<rfloor>,h) \<in> models \<and> length L = N)
                                              \<longrightarrow> 
                                              (v = IVal ((int N) + E<i>) \<and> hh = h \<and> p = \<langle>(11 + 20 * N) (N + 1) 0 0\<rangle>))}"
(* for a sepc like this, see Listlength2 below.
    and spect[simp]: "spectable f = {(E,h,hh,v,p) . \<exists> L N. (L,E\<lfloor>l\<rfloor>,h) \<in> models \<and> length L = N \<and>
                                                             v = IVal ((int N) + E<i>) \<and> hh = h \<and> 
                                                             clock p = 11 + 20 * N}"*)
lemma (in Listlength) "\<rhd> (Call f) : spectable f"
apply (rule vdm_call, simp)
apply (rule vdm_conseq)
apply (rule vdm_basics)+
apply (rule vdm_ax)
apply simp
apply (insert vardistinct)
apply clarsimp
apply (case_tac "ia = 0")
(*case ia = 0*)
  apply clarsimp
  apply (erule models.elims, simp_all)
(*case ia \<noteq> 0*)
  apply clarsimp
  apply (erule models.elims, simp_all)
  apply clarsimp
  apply (erule_tac x="length t" in allE)
  apply auto
done

section {* Functional correctness *}
(*here we use a spec which is not as meaningful - and not provable without some classinfo*)
locale Listlength2 = 
  fixes    tag     :: iname and	   h       :: iname and    i       :: iname and	   b       :: iname
    and    l       :: rname and	   f       :: funame and	   fBody   :: "int expr"
 assumes fbdy[simp]:"funtable f = LET tag = GetFi l TAG;
                                        b = Primop (% x y. if x = 0 then 1 else 0) tag tag
                                  IN IF b THEN IVar i 
                                          ELSE LET  h = GetFi l HD;
                                                    i = Primop (% x y. x + 1) i i;
                                                 rf l = GetFr l TL
                                               IN Call f 
                                          END
                                  END"
      and  vardistinct: "distinct [tag,h,i,b] \<and> distinct [b,i,h,tag]"
      and spect[simp]: "spectable f = {(E,h,hh,v,p) . \<exists> L N. (L,E\<lfloor>l\<rfloor>,h) \<in> models \<and> int(length L) + E<i> = N \<and>
                                                             v = IVal N}"
lemma (in Listlength2) "\<rhd> (Call f) : spectable f"
apply (rule vdm_call, simp)
apply (rule vdm_conseq)
apply (rule vdm_basics)+
apply (rule vdm_ax)
apply simp
apply (insert vardistinct)
apply clarsimp
apply (case_tac "ia = 0")
  apply clarsimp
  apply (rule NIL, simp)
  defer 1
  apply clarsimp
  apply (rule_tac x="(inthp aa HD ab) # L" in exI, simp)
  apply (rule CONS)
  apply (rule_tac x="refhp aa TL ab" in exI, simp)
sorry (*both goals lack the instanceOf info*)
end
