(*  
   File:	$RCSfile: ExampleKonst.thy,v $
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ExampleKonst.thy,v 1.1 2003/08/29 00:13:49 a1hloidl Exp $

   Constant function example in VDM version.
*)

theory ExampleKonst = Prelude + Lemmas + VDM:

(* count down to 0 as simplified version of konst *)
locale kount_example =
  fixes    x         :: rname
  fixes	   m         :: iname
  fixes    count     :: ifldname
  fixes	   q         :: iname
  fixes	   z         :: iname
  fixes    konst     :: funame
 assumes funtable_kount_def[simp]:
  "funtable kount =  ((LET
                         m = x\<bullet>count ;
                         q = m :0? 
                       IN 
                         IF q
                           THEN 0\<^sup>z
                           ELSE LET
                                  m = x\<bullet>count ;
                                  m = m :-- ;
                                  z = (x\<bullet>count := m) ;
                                  z = CALL kount 
                               IN
                                 z\<^sup>I
                               END
                       END) :: state expr)"
  assumes  vardistinct: "distinct [m,q,z]"

lemma (in kount_example)
  "\<rhd> ((CALL kount) :: state expr) : {(E::env,h::heap,h'::heap,v,p). theival v = (0::int)}" (* (heap.iheap (h'::heap)) count E\<lceil>x\<rceil>}" *)
apply (insert vardistinct)
(* apply (rule vdm_conseq) *)
apply (rule vdm_call)
apply simp                 (* porghvam yISach! *)
apply (rule vdm_conseq)
apply (rule vdm_basics)
defer 1
apply (rule vdm_basics)
defer 1
apply (rule vdm_basics)
defer 1
apply (rule vdm_basics)
defer 1
apply (rule vdm_basics)
defer 1
apply (rule vdm_basics)
defer 1
apply (rule vdm_basics)
defer 1
apply (rule vdm_basics)
defer 1
apply (rule vdm_basics)
apply (rule vdm_basics)
apply (rule vdm_basics)
apply (rule vdm_basics)
apply (rule vdm_basics)
apply (rule vdm_basics)
apply (rule vdm_ax)
apply simp
(* -- *)
apply clarsimp
apply (case_tac "FunMachine.ienv a<m:=i> m = 0")
 apply clarsimp
 apply clarsimp
done

(* --------------------------------------------------------------------------- *)

locale konst_flat_example =
  fixes    x         :: rname
  fixes	   m         :: iname
  fixes    count     :: ifldname
  fixes	   q         :: iname
  fixes	   z         :: iname
  fixes    konst     :: funame
 assumes funtable_konst_def[simp]:
  "funtable konst =  ((LET
                         m = x\<bullet>count ;
                         q = m :0? 
                       IN 
                         IF q
                           THEN 0\<^sup>z
                           ELSE LET
                                  m = x\<bullet>count ;
                                  m = m :-- ;
                                  z = (x\<bullet>count := m) ;
                                  z = CALL konst ;
                                  m = x\<bullet>count ;
                                  m = m :++ ;
                                  z = (x\<bullet>count := m)
                                IN 
                                  m\<^sup>I
                                END
                       END) :: state expr)"
  assumes  vardistinct: "distinct [m,q,z]"

declare (in konst_flat_example) funtable_konst_def [simp]

lemma (in konst_flat_example)
  "\<rhd> ((CALL konst) :: state expr) : {(E::env,h::heap,h'::heap,v,p). (heap.iheap (h::heap)) count E\<lceil>x\<rceil> = (heap.iheap (h'::heap)) count E\<lceil>x\<rceil> }"
apply (insert vardistinct)
apply (rule vdm_call)
apply simp                 (* porghvam yISach! *)
apply (rule vdm_conseq)
apply (rule vdm_basics)
defer 1
apply (rule vdm_basics)
defer 1
apply (rule vdm_basics)
defer 1
apply (rule vdm_basics)
defer 1
apply (rule vdm_basics)
defer 1
apply (rule vdm_basics)
defer 1
apply (rule vdm_basics)
apply (rule vdm_ax)
defer 1
apply (rule vdm_basics)
defer 1
apply (rule vdm_basics)
defer 1
apply (rule vdm_basics)
defer 1
apply (rule vdm_basics)
defer 1
apply (rule vdm_basics)
apply (rule vdm_basics)
apply (rule vdm_basics)
apply (rule vdm_basics)
apply (rule vdm_basics)
apply (rule vdm_basics)
defer 1
apply (rule vdm_basics)
apply (rule vdm_basics)
apply (rule vdm_basics)
apply (auto)
done

lemma (in konst_flat_example)
  "\<rhd> ((CALL konst) :: state expr) : {(E::env,h::heap,h'::heap,v,p). (heap.iheap (h::heap)) count E\<lceil>x\<rceil> = (heap.iheap (h'::heap)) count E\<lceil>x\<rceil>}"
apply (insert vardistinct)
apply (rule vdm_call)
apply simp                 (* porghvam yISach! *)
apply (rule vdm_conseq)
apply (rule vdm_leti)
apply (rule vdm_basics)
apply (rule vdm_leti)
apply (rule vdm_basics)
apply (rule vdm_basics)
apply (rule vdm_basics)
apply (rule vdm_leti)
apply (rule vdm_basics)
apply (rule vdm_leti)
apply (rule vdm_basics)
apply (rule vdm_leti)
apply (rule vdm_basics)
apply (rule vdm_leti)
apply (rule vdm_ax)
apply simp
apply (rule vdm_leti)
apply (rule vdm_basics)
apply (rule vdm_leti)
apply (rule vdm_basics)
apply (rule vdm_leti)
apply (rule vdm_basics)
apply (rule vdm_basics)
apply clarsimp
apply (tactic {* all_tac *})
sorry (* , NOT! *)

end
