(*  
   File:	$RCSfile: Derived.thy,v $
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: Derived.thy,v 1.1 2003/08/29 00:13:47 a1hloidl Exp $

   
*)

theory VDMderived = Lemmas + VDM: 

consts
  spectable     :: "funame \<Rightarrow> vdmassn"

section {* Rule for mutual recursion over functions *}

constdefs 
  foo :: "'a expr => bool"
 "foo e == \<forall> f P G Q Pa .  
             (insert (CALL f, P) G) \<rhd>  e : Q --> 
             G \<rhd>  (CALL f) : Pa --> 
             Pa \<subseteq> P --> 
             G \<rhd>  e : Q"

lemma "foo e"
apply (induct_tac e)
apply (simp_all add: foo_def)
apply (clarsimp)
apply (erule vdm_proof.elims) (* , simp_all) *)
apply (simp_all add: foo_def)
apply (insert vdm_int)
oops

lemma vdm_ctxt_weaken: "\<lbrakk> G \<rhd> ((Call f)::'a expr) : Q \<rbrakk>
                        \<Longrightarrow>
                        (insert ((Call f)::'a expr, Q) G) \<rhd> ((Call f)::'a expr) : Q"
apply (erule vdm_proof.elims)
apply simp_all
prefer 2
apply (clarsimp)
apply (rule vdm_call)
apply fastsimp
apply (clarsimp)
apply (rule vdm_conseq)
oops

(*
lemma cutAux: "\<And> f P G Q Pa. \<lbrakk>insert (CALL f, P) G \<rhd>  e : Q ; G \<rhd>  (CALL f) : Pa ; Pa \<subseteq> P\<rbrakk> \<Longrightarrow> G \<rhd>  e : Q " 
apply (induct_tac e)
apply (erule vdm_proof.elims, simp_all)
oops
*)

lemma cut2: "\<lbrakk> (insert (Call f, P) D) \<rhd> e : Q ; G \<rhd> Call f : P ; G \<subseteq> D \<rbrakk>
            \<Longrightarrow>
            D \<rhd> e : Q"
apply (erule vdm_proof.induct) 
apply (rule vdm_conseq)
apply simp
apply simp
apply (rule vdm_basics, simp+)
apply (insert vdm_int)
apply fastsimp
apply (rule vdm_basics, simp+)
apply (insert vdm_rvar, fastsimp)
apply (rule vdm_basics, simp+)
apply (insert vdm_rprim, fastsimp)
apply (rule vdm_basics, simp+)
apply (rule vdm_basics, simp+)
apply (rule vdm_basics, simp+)
apply (rule vdm_basics, simp+)
apply (insert vdm_new, fastsimp)
apply (rotate_tac 6)
apply (erule thin_rl)
apply (erule thin_rl)
apply (erule thin_rl)
apply (erule thin_rl)
apply (rule vdm_basics, simp+)
apply (rotate_tac 6)
apply (erule thin_rl)
apply (erule thin_rl)
apply (erule thin_rl)
apply (erule thin_rl)
apply (insert vdm_leti, fastsimp)
apply (rotate_tac 6)
apply (erule thin_rl)
apply (erule thin_rl)
apply (erule thin_rl)
apply (erule thin_rl)
apply (erule thin_rl)
apply (insert vdm_letr, fastsimp)
apply (rotate_tac 6)
apply (erule thin_rl)
apply (erule thin_rl)
apply (erule thin_rl)
apply (erule thin_rl)
apply (erule thin_rl)
apply (erule thin_rl)
apply (insert vdm_letv, fastsimp)
(* prefer 4 *)
apply (rotate_tac 4)
apply (erule thin_rl)
apply (erule thin_rl)
apply (erule thin_rl)
apply (erule thin_rl)
apply (erule thin_rl)
apply (erule thin_rl)
apply (erule thin_rl)
apply (rule vdm_call)
apply clarsimp
apply (case_tac "e = Call f")
 apply simp 
 apply (insert vdm_ax [of "Call f" "P" "Ga"])
 apply simp


sorry

lemma cut_from_cut2: "\<lbrakk> G \<rhd> Call f : P ;
                      (insert (Call f, P) G) \<rhd> e : Q \<rbrakk>
                      \<Longrightarrow>
                      G \<rhd> e : Q"
apply (insert cut2)
apply fastsimp
done

(* cut rule (over contexts on derivation) *)
lemma cut: "\<lbrakk> G \<rhd> Call f : P ;
              (insert (Call f, P) G) \<rhd> e : Q \<rbrakk>
            \<Longrightarrow>
            G \<rhd> e : Q"
apply (erule vdm_proof.elims)
prefer 20
apply clarsimp
apply (subgoal_tac "insert (CALL f, P) G = G")
 apply clarsimp
 (* -- *)
 apply (erule thin_rl) 
 apply fastsimp
defer 1
apply (simp_all)
prefer 2
apply clarsimp
(* -- *)
apply (case_tac e)
apply (erule vdm_proof.elims, simp_all)
apply clarsimp
sorry

(* case for a total of 2 functions *)
lemma  "[| G' = {(((Call f)::'a expr), F), (((Call g)::'a expr), G)} ;
           G' \<rhd> ((funtable f)::'a expr)  : {(E,h,hh,v,p) . (E,h,hh,v,tkcall p) \<in> F} ;
           G' \<rhd> ((funtable g)::'a expr) : {(E,h,hh,v,p) . (E,h,hh,v,tkcall p) \<in> G} |]
        ==>
        \<rhd> ((Call g)::'a expr) : G"
apply (clarsimp)
apply (subgoal_tac "{(((Call g)::'a expr), G)} \<rhd> ((Call f)::'a expr) : F")
 prefer 2
 apply (rule vdm_call)
 apply simp
 (* -- *)
 apply (subgoal_tac "{(((Call g)::'a expr), G)} \<rhd> ((funtable g)::'a expr) : {(E,h,hh,v,p) . (E,h,hh,v,tkcall p) \<in> G}")
  prefer 2  
  apply (erule cut)  
  apply (simp)
  (* -- *)
  apply (rule vdm_call)
  apply (simp)
done

(* top-level lemma for mutual recursion *)
lemma vdm_callMut: "\<lbrakk> \<forall> f G P . (((Call f)::'a expr), P) : G \<longrightarrow> (G \<rhd> ((funtable f)::'a expr) : {(E,h,hh,v,p) . (E,h,hh,v,tkcall p) \<in> P}) ; 
         \<forall> e G P . ((e, P) : G \<longrightarrow>  (\<exists> f. e = ((Call f)::'a expr) \<and> P = spectable f))  ;
        ((Call g)::'a expr, spectable g) : G \<rbrakk> \<Longrightarrow>
       (G - {((Call g)::'a expr, spectable g)}) \<rhd> ((Call g)::'a expr) : (spectable g)"
apply (case_tac "\<exists> f P. (((Call f)::'a expr), P) : (G - {(CALL g, spectable g)})")
 apply (erule exE)
 apply (erule exE)
 apply (subgoal_tac "(G - {(CALL g, spectable g)}) \<rhd> ((Call f)::'a expr) : P")
     (* prove subgoal *)
     prefer 2 
     apply (rule vdm_call)
     apply (erule_tac x="f" in allE, rotate_tac -1)
     apply (erule_tac x="(G - {(CALL g, spectable g)} \<union>{(CALL f, P)})" in allE, rotate_tac -1)
     apply (erule_tac x="P" in allE, rotate_tac -1)
     apply (erule_tac x="Call f" in allE, rotate_tac -1)
     apply (erule_tac x="(G - {(CALL g, spectable g)} \<union>{(CALL f, P)})" in allE, rotate_tac -1)
     apply (erule_tac x="P" in allE, rotate_tac -1)
     apply clarsimp
     (* use subgoal *)
 apply (rule vdm_call) 
 apply (subgoal_tac "G \<rhd>  funtable
                          g : {(E, h, hh, v, p).
                               (E, h, hh, v,
                                \<lparr>renv.clock = 1, callc = 1, invkc = 0, invkdpth = 0\<rparr> \<smile>
                                p)
                               \<in> spectable g}")
 apply (subgoal_tac "G = (G - {(CALL g, spectable g)}) \<union> {(CALL g, spectable g)}")
  apply (erule thin_rl)
  apply (erule thin_rl)
  apply (erule thin_rl)
  apply (erule thin_rl)
  apply fastsimp
  apply (erule thin_rl)
  apply (erule thin_rl)
  apply (erule thin_rl)
  apply (erule thin_rl)
  apply (erule thin_rl)
  apply (erule thin_rl)
  defer 1
  apply (erule_tac x="g" in allE, rotate_tac -1)
  apply (erule_tac x="G" in allE, rotate_tac -1)
  apply (erule_tac x="spectable g" in allE)
  apply (erule thin_rl)
  apply simp
  (* case \<not> \<exists> ... *)
  apply (subgoal_tac "G = {(CALL g, spectable g)}")
   apply (rotate_tac -2)
   apply (erule thin_rl)
   apply simp
   apply (rule vdm_call)
   apply simp
   apply (erule thin_rl)
   apply (erule thin_rl)
(* 2 trivial subgoals: *)
sorry

end
