(*  
   File:	$RCSfile: VDMderived.thy,v $
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: VDMderived.thy,v 1.6 2003/10/01 20:45:53 a1hloidl Exp $

   
*)

header {* Derived rules of the program logic *}


theory VDMderived = Lemmas + VDM: 


text {*
 In this section we define several useful rules, that are derived from the core 
 program logic. 
*}

subsection {* Weakening lemmas for contexts *}

lemma CtxtWeak: "G \<rhd> e : P \<Longrightarrow> (G \<union> D) \<rhd> e : P"

apply (erule vdm_proof.induct)
apply (rule vdm_conseq, fast, simp)
apply (rule vdm_null)
apply (rule vdm_int)
apply (rule vdm_ivar)
apply (rule vdm_rvar)
apply (rule vdm_prim)
apply (rule vdm_rprim)
apply (rule vdm_getfi)
apply (rule vdm_getfr)
apply (rule vdm_putfi)
apply (rule vdm_putfr)
apply (rule vdm_new)
apply (rule vdm_if, simp, simp)
apply (rule vdm_leti, simp, simp)
apply (rule vdm_letr, simp, simp)
apply (rule vdm_letv, simp, simp)
apply (rule vdm_call, simp)
apply (rule vdm_mhinvokestatic, simp)
apply (rule vdm_mhinvoke, simp)
apply (rule vdm_invokestatic, simp)
apply (rule vdm_invoke, simp)
apply (rule vdm_ax, simp)
done


lemma CtxtWeakSingleton: "G \<rhd> e : P \<Longrightarrow> (insert (ee, Q) G) \<rhd> e : P"
by (insert CtxtWeak [of G e P "{(ee,Q)}"], simp)


subsection {* Cut rules *}

lemma CutAux: 
"(DD \<rhd> e : Q \<Longrightarrow>
(\<forall> G ee P D . (DD = (insert (ee, P) D) \<longrightarrow> (G \<rhd> ee :P) \<longrightarrow> (G \<subseteq> D) \<longrightarrow> D \<rhd> e:Q)))"
apply (erule vdm_proof.induct)
apply clarsimp
apply (fastsimp intro: vdm_conseq) 
apply (fastsimp intro: vdm_null) 
apply (fastsimp intro: vdm_int)
apply (fastsimp intro: vdm_ivar)
apply (fastsimp intro: vdm_rvar)
apply (fastsimp intro: vdm_prim)
apply (fastsimp intro: vdm_rprim)
apply (fastsimp intro: vdm_getfi)
apply (fastsimp intro: vdm_getfr)
apply (fastsimp intro: vdm_putfi)
apply (fastsimp intro: vdm_putfr)
apply (fastsimp intro: vdm_new)
(*case vdm_if*)
apply clarsimp
apply (erule_tac x=Ga in allE, erule_tac x=Ga in allE)
apply (erule_tac x=ee in allE, erule_tac x=ee in allE)
apply (erule_tac x=P in allE, erule_tac x=P in allE)
apply (erule_tac x=D in allE, erule_tac x=D in allE)
apply (insert vdm_if, simp, fast)
(*case vdm_leti*)
apply clarsimp apply (rotate_tac 4) apply(erule thin_rl)
apply (erule_tac x=Ga in allE, erule_tac x=Ga in allE)
apply (erule_tac x=ee in allE, erule_tac x=ee in allE)
apply (erule_tac x=P in allE, erule_tac x=P in allE)
apply (erule_tac x=D in allE, erule_tac x=D in allE)
apply (insert vdm_leti, simp, fast)
(*case vdm_letr*)
apply clarsimp apply (rotate_tac 4) apply(erule thin_rl, erule thin_rl)
apply (erule_tac x=Ga in allE, erule_tac x=Ga in allE)
apply (erule_tac x=ee in allE, erule_tac x=ee in allE)
apply (erule_tac x=P in allE, erule_tac x=P in allE)
apply (erule_tac x=D in allE, erule_tac x=D in allE)
apply (insert vdm_letr, simp, fast)
(*case vdm_letv*)
apply clarsimp apply (rotate_tac 4) apply(erule thin_rl, erule thin_rl, erule thin_rl)
apply (erule_tac x=Ga in allE, erule_tac x=Ga in allE)
apply (erule_tac x=ee in allE, erule_tac x=ee in allE)
apply (erule_tac x=P in allE, erule_tac x=P in allE)
apply (erule_tac x=D in allE, erule_tac x=D in allE)
apply (insert vdm_letv, simp, fast)
(*case vdm_call*)
apply clarsimp apply (rotate_tac 2) apply(erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
apply (rule vdm_call)
apply (erule_tac x = Ga in allE, erule_tac x = ee in allE, erule_tac x = Pa in allE,
       erule_tac x="(insert (CALL f, P) D)" in allE, fastsimp) 
(* case vdm_mh_invokestatic*)
apply clarsimp apply (rotate_tac 2) apply(erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
apply (rule vdm_mhinvokestatic)
apply (erule_tac x = Ga in allE, erule_tac x = ee in allE, erule_tac x = Pa in allE,
       erule_tac x="(insert (C\<bullet>\<bullet>mn, P) D)" in allE, fastsimp) 
(* case vdm_mh_invoke *)
apply clarsimp apply (rotate_tac 1) apply(erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
apply (rule vdm_mhinvoke)
apply clarsimp
apply (erule_tac x = "E'" in allE, erule_tac x = "h'" in allE,
       erule_tac x = "a" in allE, erule_tac x = "C" in allE, clarsimp)
apply (erule_tac x = Ga in allE, erule_tac x = ee in allE, erule_tac x = Pa in allE,
       erule_tac x="(insert (x\<diamondsuit>\<diamondsuit>mn, P) D)" in allE, fastsimp) 
(* case vdm_invokestatic*)
apply clarsimp apply (rotate_tac 2) apply(erule thin_rl, erule thin_rl, erule thin_rl)
apply (rule vdm_invokestatic)
apply clarsimp
apply (erule_tac x="E'" in allE, clarsimp)
apply (erule_tac x = Ga in allE, erule_tac x = ee in allE, erule_tac x = Pa in allE,
       erule_tac x="(insert (C\<bullet>mn(y), P) D)" in allE, fastsimp) 
(* case vdm_invoke *)
apply clarsimp apply (rotate_tac 1) apply(erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
apply (rule vdm_invoke)
apply clarsimp
apply (erule_tac x = "E'" in allE, erule_tac x = "h'" in allE,
       erule_tac x = "a" in allE, erule_tac x = "C" in allE, clarsimp)
apply (erule_tac x = Ga in allE, erule_tac x = ee in allE, erule_tac x = Pa in allE,
       erule_tac x="(insert (x\<diamondsuit>mn(y), P) D)" in allE, fastsimp) 
(*Case vdm_ax*)
apply clarsimp apply (rotate_tac 1) apply(erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
apply (erule disjE)
apply clarsimp
apply (subgoal_tac "(Ga \<union> D) \<rhd>  ee : Pa")
apply (subgoal_tac "D = (Ga \<union> D)", simp, fast)
apply (simp add: CtxtWeak)
apply (rule vdm_ax, simp)
done

lemma CCutAux: 
"(DD \<rhd> e : Q \<Longrightarrow>
(\<forall> G f P D . (DD = (insert (Call f, P) D) \<longrightarrow> (G \<rhd> Call f :P) \<longrightarrow> (G \<subseteq> D) \<longrightarrow> D \<rhd> e:Q)))"
by (insert CutAux , fast)

lemma mhInvStat_CutAux: 
"(DD \<rhd> e : Q) \<Longrightarrow>
 (\<forall> G C mn P D . ((DD = (insert (C\<bullet>\<bullet>mn, P) D)) \<longrightarrow> (G \<rhd> (C\<bullet>\<bullet>mn) : P) \<longrightarrow> (G \<subseteq> D) \<longrightarrow> (D \<rhd> e : Q)))"
by (insert CutAux , fast)

lemma mhInv_CutAux: 
"(DD \<rhd> e : Q) \<Longrightarrow> 
(\<forall> G x mn P D . ((DD = (insert (x\<diamondsuit>\<diamondsuit>mn, P) D)) \<longrightarrow> (G \<rhd> (x\<diamondsuit>\<diamondsuit>mn) : P) \<longrightarrow> (G \<subseteq> D) \<longrightarrow> (D \<rhd> e : Q)))"
by (insert CutAux , fast)


lemma InvStat_CutAux: 
"(DD \<rhd> e : Q) \<Longrightarrow>
(\<forall> G C mn y P D . ((DD = (insert (C\<bullet>mn(y), P) D)) \<longrightarrow> (G \<rhd> (C\<bullet>mn(y)) : P) \<longrightarrow> (G \<subseteq> D) \<longrightarrow> (D \<rhd> e : Q)))"
by (insert CutAux , fast)

lemma Inv_CutAux: 
"(DD \<rhd> e : Q) \<Longrightarrow>
(\<forall> G C mn P D . ((DD = (insert (x\<diamondsuit>mn(y), P) D)) \<longrightarrow> (G \<rhd> (x\<diamondsuit>mn(y)) : P) \<longrightarrow> (G \<subseteq> D) \<longrightarrow> (D \<rhd> e : Q)))"
by (insert CutAux , fast)

lemma CCut:"\<lbrakk> (insert (ee, P) D) \<rhd> e: Q; G \<rhd> ee : P; G \<subseteq> D\<rbrakk> \<Longrightarrow> D \<rhd> e:Q"
by (insert CutAux, fast)

lemma cut:"\<lbrakk> G \<rhd> ee : P ; (insert (ee, P) G) \<rhd> e : Q \<rbrakk> \<Longrightarrow> G \<rhd> e : Q"
by (insert CCut, fast)

(*callInvokeContext G == true if G contains only entried for Calls or xxx_invokes*)
constdefs callInvokeContext::"'a vdmcontext \<Rightarrow> bool"
"callInvokeContext G == 
(\<forall> e Q . (e,Q) : G \<longrightarrow> ((\<exists> f . e = Call f) \<or> 
                        (\<exists> x mn . e = x\<diamondsuit>\<diamondsuit>mn) \<or> (\<exists> C mn . e = C\<bullet>\<bullet>mn) \<or> 
                        (\<exists> x mn y . e = x\<diamondsuit>mn(y)) \<or> (\<exists> C mn y. e = C\<bullet>mn(y))))"

(*Proves G D == true if D preves all entries in G*)
constdefs Proves::"'a vdmcontext \<Rightarrow> 'a vdmcontext \<Rightarrow> bool"
"Proves G D == (\<forall> e Q . (e, Q) : G \<longrightarrow> D \<rhd> e : Q)"

lemma cut2Aux:
"\<forall> G D . (finite G \<longrightarrow> D \<subseteq> G \<longrightarrow> card (G - D) = n \<longrightarrow> 
          (\<forall> e P. (G \<rhd> e : P \<longrightarrow> (callInvokeContext G) \<longrightarrow> (Proves G D) \<longrightarrow> D \<rhd> e : P)))"
apply (induct n)
apply clarsimp
apply (subgoal_tac "G = D", simp)
defer 1
apply clarsimp
apply (erule_tac x=G in allE)
apply (erule impE, assumption)
apply (subgoal_tac "\<exists> ee P DDD . G - D = {(ee,P)} \<union> DDD \<and> (ee,P) \<notin> DDD \<and> card DDD = n")
apply (erule exE)+
apply (erule conjE)+
apply (erule_tac x="D \<union> {(ee,Pa)}" in allE)
apply (erule impE)
apply rule
apply (subgoal_tac "x:D \<or> x : {(ee,Pa)}")
apply (erule disjE, fast)
apply simp
apply (subgoal_tac "(ee, Pa) \<in> G - D", fast)
apply (subgoal_tac "(ee, Pa) \<in> insert (ee, Pa) DDD", simp)
apply fast
apply fast
apply (erule impE)
defer 1
apply (erule_tac x=e in allE, erule_tac x=P in allE)
apply (erule impE, assumption)
apply (erule impE, assumption)
apply (erule impE)
apply (simp add: Proves_def)
apply (insert CtxtWeak)
apply (rule, clarsimp)
apply (erule_tac x=ea in allE, erule_tac x=Q in allE)
apply (erule impE, assumption)
apply (subgoal_tac "(D \<union> {(ee,Pa)}) \<rhd>  ea : Q ")
apply (subgoal_tac "D \<union> {(ee,Pa)} = insert (ee, Pa) D", simp)
apply simp
apply (erule_tac thin_rl, erule_tac thin_rl, erule_tac thin_rl, erule_tac thin_rl, erule_tac thin_rl, erule_tac thin_rl)
apply (rotate_tac 2)
apply fast
(* end of the proof of contextprovable G - \<dots>*)
apply (rotate_tac -1, erule thin_rl)
apply (rule CCut)
apply (subgoal_tac "insert (ee, Pa) D \<rhd>  e : P", assumption)
apply (subgoal_tac "D \<union> {(ee,Pa)} = insert (ee, Pa) D", simp)
apply simp
apply (subgoal_tac "D \<rhd>  ee : Pa", assumption)
apply (subgoal_tac "(ee,Pa) \<in> G", simp add: callInvokeContext_def)
apply (erule_tac x=ee in allE)
apply (erule impE)
apply (rule_tac x=Pa in exI, assumption)
apply (erule disjE, clarsimp, simp add: Proves_def)
apply (erule disjE, clarsimp, simp add: Proves_def)
apply (erule disjE, clarsimp, simp add: Proves_def)
apply (erule disjE, clarsimp, simp add: Proves_def)
apply (clarsimp, simp add: Proves_def)
apply (subgoal_tac "(ee, Pa) \<in> G - D", fast)
apply (subgoal_tac "(ee, Pa) \<in> {(ee, Pa)} \<union> DDD", simp)
apply fast
apply simp
apply (rotate_tac 3, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
defer 1
apply fast
apply (rotate_tac 3, erule thin_rl, erule thin_rl, erule thin_rl)
apply (rotate_tac 3, erule thin_rl)
apply (subgoal_tac "G - (D \<union> {(ee, Pa)}) = DDD", simp)
apply rule
apply rule
apply fast
apply rule
apply (case_tac "x:G")
apply (case_tac "x :D")
apply fast
apply fast
apply fast
apply (subgoal_tac "finite (G - D)")
prefer 2 apply simp
apply (case_tac "G - D = {}")
apply simp
apply (subgoal_tac "\<exists> x. x: (G - D)")
prefer 2 apply fast
apply (erule exE)
apply (rule_tac x="fst x" in exI)
apply (rule_tac x="snd x" in exI)
apply (rule_tac x="(G - D) - {x}" in exI)
apply rule
apply fastsimp
apply rule
apply fastsimp
apply (simp add: card_Diff_singleton)
done


lemma cut2:"\<lbrakk>finite G; G \<rhd> e : P; D \<subseteq> G; callInvokeContext G; Proves G D\<rbrakk> \<Longrightarrow> D \<rhd> e : P"
apply (insert cut2Aux [of "card (G - D)"])
by (erule_tac x=G in allE, erule_tac x=D in allE, fastsimp)

section{*Mutual recursion*}
declare callInvokeContext_def[simp]
text {*
 For working with sets of mutually recursive functions/methodsm, we require that their
 specifications are collected in the following table.
*}

consts
  spectable  :: "funame \<Rightarrow> vdmassn"          -- {* specifications of functions *}
  Mspectable :: "cname \<Rightarrow> mname \<Rightarrow> vdmassn"  -- {* specifications of methods *}

text {* 
 We define what it means for a context to be consistent with the above tables.
*}


constdefs consistent::"'a vdmcontext \<Rightarrow> bool"
"consistent G == 
((\<forall> f P. (Call f, P) : G \<longrightarrow> (P = spectable f \<and> G \<rhd> funtable f: {(E,h,hh,v,p) . (E,h,hh,v,tkcall p) \<in> P})) \<and> 
 (\<forall> C mn P. (C\<bullet>\<bullet>mn, P) : G \<longrightarrow> (P = Mspectable C mn \<and> G \<rhd> methtable C mn: {(E,h,hh,v,p) . (E,h,hh,v,\<langle>2 0 1 1\<rangle> \<oplus> p) \<in> P})) \<and> 
 (\<forall> mn x P. (x\<diamondsuit>\<diamondsuit>mn, P) : G \<longrightarrow> ((\<exists> E' h' a C . qach_QaQ E' h' a x C \<and> P = Mspectable C mn) \<and> 
                                  (\<forall> E' h' a C . qach_QaQ E' h' a x C \<longrightarrow> 
                                                G \<rhd> methtable C mn: {(E, h, hh, v, p). E = E'\<lfloor>self:=Ref a\<rfloor> \<and> h = h' \<longrightarrow> 
                                                                                           (E', h', hh, v, \<langle>4 0 1 1\<rangle> \<oplus> p) \<in> P}))) \<and> 
 (\<forall> C mn y P. (C\<bullet>mn(y), P) : G \<longrightarrow> (P = Mspectable C mn \<and> 
                                    (\<forall> E'. G \<rhd> methtable C mn: {(E,h,hh,v,p) . 
                                                          E = newframe_env Nullref (E'\<lfloor>y\<rfloor>)  \<longrightarrow> (E',h,hh,v,\<langle>3 0 1 1\<rangle> \<oplus> p) \<in> P}))) \<and>
 (\<forall> x mn y P. (x\<diamondsuit>mn(y), P) : G \<longrightarrow> ((\<exists> E' h' a C . qach_QaQ E' h' a x C \<and> P = Mspectable C mn) \<and> 
                                     (\<forall> E' h' a C . qach_QaQ E' h' a x C \<longrightarrow> 
                                                    G \<rhd> methtable C mn: 
                                                    {(E,h,hh,v,p) . E = newframe_env (E'\<lfloor>x\<rfloor>) (E'\<lfloor>y\<rfloor>) \<and> h = h' \<longrightarrow>  
                                                                    (E',h,hh,v,\<langle>5 0 1 1\<rangle> \<oplus> p) \<in> P}))))"

lemma consistent_preserved: "\<lbrakk>consistent G; callInvokeContext G; (e,Q):G\<rbrakk> \<Longrightarrow> consistent (G - {(e,Q)})"

apply (simp add: consistent_def, clarsimp)
apply (subgoal_tac "(G - {(e,Q)}) \<rhd> e:Q")(*now use the subgoal (G - {(e,Q)}) \<rhd> e:Q to prove the goal*)
apply (subgoal_tac "G = insert (e, Q) (G - {(e, Q)})") prefer 2 apply fast
apply (rule, clarify)
(*case call*)
apply (erule_tac x=f in allE, erule_tac x=P in allE, clarsimp)
apply (rule cut, assumption, simp)
apply (rule, clarify)
(*case mhinvokestatic*)
apply (erule_tac x=C in allE, erule_tac x=mn in allE, erule_tac x=P in allE, clarsimp)
apply (rule cut, assumption, simp)
apply (rule, clarify)
(*case mhinvoke*)
apply (erule_tac x=mn in allE, erule_tac x=x in allE, erule_tac x=P in allE, clarsimp)
apply (rule cut, assumption, simp)
apply (rule, clarify)
(*case invokestatic*)
apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
apply (rotate_tac 1) apply (erule thin_rl)
apply (erule_tac x=C in allE, erule_tac x=mn in allE, erule_tac x=y in allE, erule_tac x=P in allE, clarsimp)
apply (rule cut, assumption, simp)
apply clarsimp
(*case invoke*)
apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
apply (erule_tac x=x in allE, erule_tac x=mn in allE, erule_tac x=y in allE, erule_tac x=P in allE, clarsimp)
apply (rule cut, assumption, simp)
(* now prove the subgoal (G - {(e, Q)}) \<rhd>  e : Q *)
  apply (erule_tac x=e in allE)
  apply (subgoal_tac "(\<exists>f. e = CALL f) \<or> (\<exists>x mn. e = x\<diamondsuit>\<diamondsuit>mn) \<or> (\<exists>C mn. e = C\<bullet>\<bullet>mn) \<or> 
                      (\<exists>x mn y. e = x\<diamondsuit>mn(y)) \<or> (\<exists>C mn y. e = C\<bullet>mn(y))") 
  apply (rotate_tac -2, erule thin_rl)
  prefer 2 apply(subgoal_tac "(\<exists>Q. (e, Q) \<in> G)", clarsimp) apply (rule_tac x=Q in exI, simp)
  apply (erule disjE, clarify)
  (*case call*)
  apply (rotate_tac 2, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
  apply (rule vdm_call)
  apply (subgoal_tac "G = insert (CALL f, Q) (G - {(CALL f, Q)})")
  apply clarsimp
  apply fastsimp
  apply (erule disjE, clarify)
  (* case mhinvoke *)
  apply (rotate_tac 1, erule thin_rl, erule thin_rl)
  apply (rotate_tac 1, erule thin_rl, erule thin_rl)
  apply (rule vdm_mhinvoke)
  apply clarsimp
  apply (subgoal_tac "G = insert (x\<diamondsuit>\<diamondsuit>mn,Q) (G - {(x\<diamondsuit>\<diamondsuit>mn, Q)})")
  apply clarsimp
  apply fastsimp
  apply (erule disjE, clarify)
  (*case mhinvokestatic*)
  apply (rotate_tac 1, erule thin_rl)
  apply (rotate_tac 1, erule thin_rl, erule thin_rl, erule thin_rl)
  apply (rule vdm_mhinvokestatic)
  apply (subgoal_tac "G = insert (C\<bullet>\<bullet>mn, Q) (G - {(C\<bullet>\<bullet>mn, Q)})")
  apply clarsimp
  apply fastsimp
  apply (erule disjE, clarify)
  (* case invoke *)
  apply (rotate_tac 1, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
  apply (rule vdm_invoke)
  apply clarsimp
  apply (subgoal_tac "G = insert (x\<diamondsuit>mn(y), Q) (G - {(x\<diamondsuit>mn(y), Q)})") 
  apply clarsimp
  apply fastsimp
  (*case invokestatic*)
  apply clarsimp
  apply (rotate_tac 1, erule thin_rl, erule thin_rl, erule thin_rl)
  apply (rotate_tac 1, erule thin_rl)
  apply (rule vdm_invokestatic)
  apply clarsimp
  apply (subgoal_tac "G = insert (C\<bullet>mn(y), Q) (G - {(C\<bullet>mn(y), Q)})")
  apply clarsimp
  apply fastsimp 
done


subsection {* Rule for mutual recursion *}

lemma MUTREClemma: 
"\<forall> G . ((finite G \<and> card G = n \<and> callInvokeContext G \<and> consistent G \<and> (e,P) : G) \<longrightarrow> \<rhd> e:P)"
apply (induct n)
(*case n=0*)
apply clarsimp
(*Case n>0*)
apply clarsimp
apply (case_tac "G = {(e,P)}")
apply clarsimp
apply (erule_tac x="{(e,P)}" in allE)
apply (erule disjE, clarsimp, simp add:consistent_def)
apply (rule vdm_call, clarsimp)
apply (erule disjE, clarsimp, simp add:consistent_def)
apply (rule vdm_mhinvoke, clarsimp)
apply (erule disjE, clarsimp, simp add:consistent_def)
apply (rule vdm_mhinvokestatic, clarsimp)
apply (erule disjE, clarsimp, simp add:consistent_def)
apply (rule vdm_invoke, clarsimp)
apply (clarsimp, simp add:consistent_def)
apply (rule vdm_invokestatic, clarsimp)
(*Case G has more entries than (e,P)*)
apply (subgoal_tac "\<exists> ee Q . (ee,Q) \<noteq> (e,P) \<and> (ee,Q) : G")
prefer 2
apply (rotate_tac 2)
apply (erule thin_rl, erule thin_rl)
apply (rotate_tac 1)
apply (erule thin_rl)
apply fastsimp
(* use the fact that there is another pair (ee,Q):G*)
apply clarsimp
apply (subgoal_tac "(G - {(ee,Q)}) \<rhd> ee: Q")
apply (erule_tac x="G - {(ee, Q)}" in allE)
apply (subgoal_tac "consistent (G - {(ee, Q)})", simp)
prefer 2 apply (simp add: consistent_preserved)
apply (subgoal_tac "card (G - {(ee, Q)}) = n", simp)
prefer 2 apply (simp add: card_Diff_singleton) 
apply clarsimp
apply (case_tac "e = ee", clarsimp)
apply (case_tac "P = Q", clarsimp, clarsimp)
apply (case_tac "ea = e", clarsimp)
apply (erule_tac x=e in allE, simp)
apply clarsimp
apply (erule_tac x=ea in allE, simp)
apply clarsimp
apply (case_tac "ea = ee", clarsimp)
apply (erule_tac x=ee in allE, simp)
apply clarsimp
apply (erule_tac x=ea in allE, simp)
(*the proof for (G - {(ee, Q)}) \<rhd>  ee : Q *)
  apply (erule_tac x=ee in allE)
  apply (subgoal_tac "(\<exists>f. ee = CALL f) \<or> (\<exists>x mn. ee = x\<diamondsuit>\<diamondsuit>mn) \<or> (\<exists>C mn. ee = C\<bullet>\<bullet>mn) \<or> 
                      (\<exists>x mn y. ee = x\<diamondsuit>mn(y)) \<or> (\<exists>C mn y. ee = C\<bullet>mn(y))", clarsimp)
  prefer 2 apply(subgoal_tac "(\<exists>Q. (ee, Q) \<in> G)", simp) apply(rule_tac x=Q in exI, simp)
  apply (erule disjE, clarsimp)
  (*case call*)
    apply (rule vdm_call)
    apply (subgoal_tac "G - {(CALL f, Q)} \<union> {(CALL f, Q)} = G")
    prefer 2 apply fast
    apply clarsimp
    apply (rotate_tac 4) apply (erule thin_rl)
    (*before unfolding consistent, we first bring the other 4 cases to the same state as this goal*)
  defer 1
  apply (erule disjE, clarsimp)
  (*case mhinvoke*)
    apply (rule vdm_mhinvoke, clarsimp)
    apply (subgoal_tac "insert (x\<diamondsuit>\<diamondsuit>mn, Q) (G - {(x\<diamondsuit>\<diamondsuit>mn, Q)}) = G")
    prefer 2 apply fast
    apply clarsimp
    apply (rotate_tac 4) apply (erule thin_rl)
  defer 1
  apply (erule disjE, clarsimp)
  (*case mhinvokestatic*)
    apply (rule vdm_mhinvokestatic)
    apply (subgoal_tac "G - {(C\<bullet>\<bullet>mn, Q)} \<union> {(C\<bullet>\<bullet>mn, Q)} = G")
    prefer 2 apply fast
    apply clarsimp
    apply (rotate_tac 4) apply (erule thin_rl)
  defer 1    
  apply (erule disjE, clarsimp)
  (*case invoke*)
    apply (rule vdm_invoke, clarsimp)
    apply (subgoal_tac "insert (x\<diamondsuit>mn(y), Q) (G - {(x\<diamondsuit>mn(y), Q)}) = G")
    prefer 2 apply fast
    apply clarsimp
    apply (rotate_tac 4) apply (erule thin_rl)
  defer 1
  (*case invokestatic*)
    apply clarsimp
    apply (rule vdm_invokestatic)
    apply (subgoal_tac "G - {(C\<bullet>mn(y), Q)} \<union> {(C\<bullet>mn(y), Q)} = G")
    prefer 2 apply fast
    apply clarsimp
    apply (rotate_tac 4) apply (erule thin_rl)
  defer 1
  (* back to case call*)
  apply (unfold consistent_def)
  apply (erule conjE)
  apply (erule_tac x=f in allE, erule_tac x="Q" in allE, clarsimp)
  (*case mhinvoke*)
  apply (erule conjE)
  apply (rotate_tac 8, erule thin_rl) (* dont need the assumtion for calls *)
  apply (erule conjE)
  apply (rotate_tac 8, erule thin_rl) (* dont need the assumtion for mhinvokestatic *)
  apply (erule conjE)
  apply (erule_tac x=mn in allE, erule_tac x=x in allE, erule_tac x="Q" in allE, simp)
  (* case mhinvokestatic*)
  apply (erule conjE)
  apply (rotate_tac 7, erule thin_rl) (*dont need the assumtion for calls*)
  apply (erule conjE)
  apply (erule_tac x=C in allE, erule_tac x=mn in allE, erule_tac x="Q" in allE, clarsimp)
  (* case invoke*)
  apply (erule conjE)
  apply (rotate_tac 8, erule thin_rl) (* dont need the assumtion for calls *)
  apply (erule conjE)
  apply (rotate_tac 8, erule thin_rl) (* dont need the assumtion for mhinvokestatic *)
  apply (erule conjE)
  apply (rotate_tac 8, erule thin_rl) (* dont need the assumtion for mhinvoke *)
  apply (erule conjE)
  apply (rotate_tac 8, erule thin_rl) (* dont need the assumtion for invokestatic *)
  apply (erule_tac x=x in allE, erule_tac x=mn in allE, erule_tac x=y in allE, erule_tac x="Q" in allE, simp)
  (* case invokestatic*)
  apply (erule conjE)
  apply (rotate_tac 7, erule thin_rl) (*dont need the assumtion for calls*)
  apply (erule conjE)
  apply (rotate_tac 7, erule thin_rl) (*dont need the assumtion for mhinvokestatic*)
  apply (erule conjE)
  apply (rotate_tac 7, erule thin_rl) (* dont need the assumtion for mhinvoke*)
  apply (erule conjE)
  apply (erule_tac x=C in allE, erule_tac x=mn in allE, 
         erule_tac x=y in allE, erule_tac x="Q" in allE, clarsimp)
done

text {*
 This is the rule we use for proving properties over mutually recursive functions/methods.
*}

theorem MUTREC:
"\<lbrakk> finite G; card G = n; callInvokeContext G; consistent G; (e,P) : G \<rbrakk> \<Longrightarrow> \<rhd> e:P"
by (insert MUTREClemma [of n e P], fast)

subsection {* Syntax for heap access *}

(*Identity of heaps wrt a set of locations -- should be moved to Lemmas.thy or so*)
syntax objhp::"heap \<Rightarrow> oheap"
translations "objhp" == "heap.oheap"
syntax inthp::"heap \<Rightarrow> iheap"
translations "inthp" == "heap.iheap"
syntax refhp::"heap \<Rightarrow> oheap"
translations "refhp" == "heap.rheap"
constdefs same::"locn set \<Rightarrow> heap \<Rightarrow> heap \<Rightarrow> bool"
"same X h hh == \<forall> l. (l \<in> X \<longrightarrow> (fmap_lookup (objhp h) l = fmap_lookup (objhp hh) l \<and> 
                                  (\<forall> ifield . (inthp h ifield l = inthp hh ifield l)) \<and>
                                  (\<forall> rfield . (refhp h rfield l = refhp hh rfield l))))"


subsection {* Earlier version: rules for mutual recursion over functions *}

(* case for a 2 functions *)
lemma mutrecCall2: 
"\<lbrakk> {(((Call f)::'a expr), F), (((Call g)::'a expr), G)} \<rhd> ((funtable f)::'a expr) : {(E,h,hh,v,p) . (E,h,hh,v,tkcall p) \<in> F} ;
   {(((Call f)::'a expr), F), (((Call g)::'a expr), G)} \<rhd> ((funtable g)::'a expr) : {(E,h,hh,v,p) . (E,h,hh,v,tkcall p) \<in> G} 
 \<rbrakk> \<Longrightarrow>
 \<rhd> ((Call g)::'a expr) : G"
apply (clarsimp)
apply (subgoal_tac "{(((Call g)::'a expr), G)} \<rhd> ((Call f)::'a expr) : F")
  prefer 2 apply (rule vdm_call, simp)
apply (subgoal_tac "{(((Call g)::'a expr), G)} \<rhd> ((funtable g)::'a expr) : {(E,h,hh,v,p) . (E,h,hh,v,tkcall p) \<in> G}")
  prefer 2 apply (erule cut, simp)  
apply (rule vdm_call, simp)
done

(*case for 3 functions*)
lemma mutrecCall3: 
"\<lbrakk> {(((Call f)::'a expr), F), (((Call g)::'a expr), G), (((Call k)::'a expr), K)} \<rhd> ((funtable f)::'a expr) : {(E,h,hh,v,p) . (E,h,hh,v,tkcall p) \<in> F} ;
   {(((Call f)::'a expr), F), (((Call g)::'a expr), G), (((Call k)::'a expr), K)} \<rhd> ((funtable g)::'a expr) : {(E,h,hh,v,p) . (E,h,hh,v,tkcall p) \<in> G} ;
   {(((Call f)::'a expr), F), (((Call g)::'a expr), G), (((Call k)::'a expr), K)} \<rhd> ((funtable k)::'a expr) : {(E,h,hh,v,p) . (E,h,hh,v,tkcall p) \<in> K} 
 \<rbrakk> \<Longrightarrow>
 \<rhd> ((Call g)::'a expr) : G"
apply (clarsimp)
apply (subgoal_tac "{(((Call g)::'a expr), G), (((Call k)::'a expr), K)} \<rhd> ((Call f)::'a expr) : F")
  prefer 2 apply (rule vdm_call, simp)
apply (subgoal_tac "{(((Call g)::'a expr), G), (((Call k)::'a expr), K)} \<rhd> ((funtable k)::'a expr) : {(E,h,hh,v,p) . (E,h,hh,v,tkcall p) \<in> K}")
  prefer 2 apply (erule cut, simp)
apply (subgoal_tac "{(((Call g)::'a expr), G)} \<rhd> ((Call k)::'a expr) : K")
  prefer 2 apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl) apply (rule vdm_call)
  apply (subgoal_tac "{(CALL k, K), (CALL g, G)} \<rhd>  funtable k : {(E, h, hh, v, p). (E, h, hh, v, \<lparr>renv.clock = 1, callc = 1, invkc = 0, invkdpth = 0\<rparr> \<smile> p) \<in> K}")
  apply (simp)
  defer 1
apply (subgoal_tac "{(((Call g)::'a expr), G), (((Call k)::'a expr), K)} \<rhd> ((funtable g)::'a expr) : {(E,h,hh,v,p) . (E,h,hh,v,tkcall p) \<in> G}")
  prefer 2 apply (erule cut, simp)  
apply (subgoal_tac "{(((Call g)::'a expr), G)} \<rhd> ((funtable g)::'a expr) : {(E,h,hh,v,p) . (E,h,hh,v,tkcall p) \<in> G}")
  prefer 2 apply (erule cut, simp)  apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)apply (erule thin_rl)
  defer 1
apply (rule vdm_call, simp)
(*now discharge the set inclusions*)
apply (subgoal_tac "\<exists> P . P \<rhd>  funtable k : {(E, h, hh, v, p). (E, h, hh, v, \<lparr>renv.clock = 1, callc = 1, invkc = 0, invkdpth = 0\<rparr> \<smile> p) \<in> K} \<and> P = {(CALL k, K), (CALL g, G)}")
apply fastsimp
apply (rule_tac x="{(CALL g, G), (CALL k, K)}" in exI, fastsimp)
apply (subgoal_tac "\<exists> P . P \<rhd>  funtable g : {(E, h, hh, v, p). (E, h, hh, v, \<lparr>renv.clock = 1, callc = 1, invkc = 0, invkdpth = 0\<rparr> \<smile> p) \<in> G} \<and> P = {(CALL k, K), (CALL g, G)}")
apply fastsimp
apply (rule_tac x="{(CALL g, G), (CALL k, K)}" in exI, fastsimp)
done
end
