(* 				 
   File:	$RCSfile: Lemmas0.thy,v $
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: Lemmas0.thy,v 1.6 2003/10/01 20:45:51 a1hloidl Exp $

   Useful lemmas mainly over components of FunMachine.
   Most of them to be used by simplifier.
   OLD version, i.e. the new fld-update lemmas are not in the simpset
   (they are collected in fld_update_lemmas, though)
*)

theory Lemmas0 = Semantics:

lemma ivarUpdSame [simp]: "(E<x:=v>)<x> = v"
by (simp add: ivarupdate_def ienv_fct_def)

lemma ivarUpdOther [simp]: "x \<noteq> y \<Longrightarrow> (E<y:=v>)<x> = E<x>"
by (simp add: ivarupdate_def ienv_fct_def)

lemma rvarUpdSame [simp]: "(E\<lfloor>x:=v\<rfloor>)\<lfloor>x\<rfloor> = v"
by (simp add: rvarupdate_def renv_fct_def)

lemma rvarUpdOther [simp]: "x \<noteq> y \<Longrightarrow> (E\<lfloor>y:=v\<rfloor>)\<lfloor>x\<rfloor> = E\<lfloor>x\<rfloor>"
by (simp add: rvarupdate_def renv_fct_def)

lemma rvarIupdTriv [simp]: "(E<x:=v>)\<lfloor>y\<rfloor> = E\<lfloor>y\<rfloor>"
by (simp add: ivarupdate_def renv_fct_def)

lemma ivarRupdTriv [simp]: "(E\<lfloor>x:=v\<rfloor>)<y> = E<y>"
by (simp add: rvarupdate_def ienv_fct_def)

lemma rvarUpdIdemp [simp]: "(E\<lfloor>y:=v\<rfloor>)\<lfloor>y:=w\<rfloor> = E\<lfloor>y:=w\<rfloor>"
by (simp add: rvarupdate_def renv_fct_def)

(*
lemma ilfdUpdOTriv: "heap.oheap h<a\<bullet>f:=n> = heap.oheap h"
by (simp add: obj_ifieldupdate_def obj_rfieldupdate_def)

lemma rlfdUpdOTriv: "heap.oheap h\<lfloor>a\<diamondsuit>f:=r\<rfloor> = heap.oheap h"
by (simp add: obj_ifieldupdate_def obj_rfieldupdate_def)

lemma ilfdUpdSame: "h<a\<bullet>f:=n><a\<bullet>f> = n"
by (simp add: obj_ifieldupdate_def obj_rfieldupdate_def)

lemma ilfdUpdOther: "f \<noteq> f' \<Longrightarrow> h<a\<bullet>f:=n><a\<bullet>f'> = h<a\<bullet>f'>"
by (simp add: obj_ifieldupdate_def obj_rfieldupdate_def, rule impI, simp)

lemma rlfdUpdSame: "h\<lfloor>a\<diamondsuit>f:=r\<rfloor>\<lfloor>a\<diamondsuit>f\<rfloor> = r"
by (simp add: obj_ifieldupdate_def obj_rfieldupdate_def)

lemma rlfdUpdOther: "f \<noteq> f' \<Longrightarrow> h\<lfloor>a\<diamondsuit>f:=r\<rfloor>\<lfloor>a\<diamondsuit>f'\<rfloor> = h\<lfloor>a\<diamondsuit>f'\<rfloor>"
by (simp add: obj_ifieldupdate_def obj_rfieldupdate_def, rule impI, simp)

lemma ilfdUpdElsewhere: "a \<noteq> a' \<Longrightarrow> h<a\<bullet>f:=n><a'\<bullet>f> = h<a'\<bullet>f>"
by (simp add: obj_ifieldupdate_def obj_rfieldupdate_def)

lemma rlfdUpdElsewhere: "a \<noteq> a' \<Longrightarrow> h\<lfloor>a\<diamondsuit>f:=r\<rfloor>\<lfloor>a'\<diamondsuit>f\<rfloor> = h\<lfloor>a'\<diamondsuit>f\<rfloor>"
by (simp add: obj_ifieldupdate_def obj_rfieldupdate_def)

(* new lemmas on field updates; not in simplifier to be backward compartible with old proofs *)
lemmas fld_update_lemmas = ilfdUpdOTriv rlfdUpdOTriv ilfdUpdSame ilfdUpdOther rlfdUpdSame rlfdUpdOther ilfdUpdElsewhere rlfdUpdElsewhere
*)

(*
lemma ifElimTrue [simp]: "(if t then 1 else 0) = (1:: int) \<Longrightarrow> t"
by (case_tac t, clarsimp+)

lemma ifElimFalse [simp]: "(if t then 1 else 0) = (0:: int) \<Longrightarrow> \<not> t"
by (case_tac t, clarsimp+)
*)
lemma ifElimT[simp]: "((if t then 1 else 0) = (1:: int)) = t"
by (case_tac t, clarsimp+)

lemma ifElimF[simp]: "((if t then 1 else 0) = (0:: int)) = (\<not> t)"
by (case_tac t, clarsimp+)

lemma bonzo10: "\<And> f f' x. [| \<forall> y. (x\<noteq>y --> f y = f' y) |] ==> \<forall> z . ((fun_upd f x v) z = (fun_upd f' x v) z)"
apply clarify
apply (case_tac "x=z")
 apply simp
 (* -- *)
 apply (erule_tac x="z" in allE)
 apply simp
done

(* Tinkering with function updates, to test proof structure for env updates *)
lemma bonzo11: "\<And> f f' x. [| \<forall> y. (y\<noteq>x --> f y = f' y) |] ==> (fun_upd f x v) = (fun_upd f' x v)"
apply (subgoal_tac "\<forall> z . ((fun_upd f x v) z = (fun_upd f' x v) z)")
 (* use subgoal *)
 apply (simp add: fun_upd_def)
 (* prove subgoal *)
 apply (simp add: bonzo10)
done

(* Nominee for the most pathetic proof within MRG *)
lemma fun_same_upd: "\<And> f f' x . [| ((fun_upd f x v) = (fun_upd f' x v)) |] ==> \<forall> y. x\<noteq>y --> f y = f' y"
apply clarify
apply (subgoal_tac "\<forall> z. (fun_upd f x v) z = (fun_upd f' x v) z")
  prefer 2
  (* prove subgoal *)
  apply clarsimp
  apply (tactic {* all_tac *})
  (* use subgoal *)
  apply (erule_tac x=y in allE)
  apply (subgoal_tac "(fun_upd f x v) y = f y")
   prefer 2
   (* prove subgoal *)
   apply (rule fun_upd_other)
   apply simp
   defer 1
   apply (tactic {* all_tac *})
   (* use subgoal *)
   apply (simp)
   apply (subgoal_tac "(fun_upd f' x v) y = f' y")
    prefer 2
    (* prove subgoal *)
    apply (rule fun_upd_other)
    apply clarsimp
    apply (tactic {* all_tac *})
    (* use subgoal *)
    apply clarsimp
   apply clarsimp   
done

(* useful in a backward proof, if fun_upds are in the assumption set already *)
lemma fun_same_upd_bwd: "[| ((fun_upd f x v) = (fun_upd f' x v)) ; x\<noteq>y |] ==> f y = f' y"
apply (subgoal_tac "\<forall> z. (fun_upd f x v) z = (fun_upd f' x v) z")
  prefer 2
  (* prove subgoal *)
  apply clarsimp
  apply (tactic {* all_tac *})
  (* use subgoal *)
  apply (erule_tac x=y in allE)
  (* subgoal in the form of the consequent of fun_upd_other *)
  apply (subgoal_tac "(fun_upd f x v) y = f y")
   prefer 2
   (* prove subgoal *)
   apply (rule fun_upd_other)
   apply simp
   defer 1
   apply (tactic {* all_tac *})
   (* use subgoal *)
   apply (simp)
  (* subgoal in the form of the consequent of fun_upd_other *)
   apply (subgoal_tac "(fun_upd f' x v) y = f' y")
    prefer 2
    (* prove subgoal *)
    apply (rule fun_upd_other)
    apply clarsimp
    apply (tactic {* all_tac *})
    (* use subgoal *)
    apply clarsimp
   apply clarsimp   
done

(* fun_upd_other applied to environments *)
lemma env_upd_otherI[simp]: "z~=x ==> (E<x:=y>)<z> = E<z>"
by simp

lemma env_upd_otherR[simp]: "z~=x ==> (E\<lfloor>x:=y\<rfloor>)\<lfloor>z\<rfloor> = E\<lfloor>z\<rfloor>"
by simp

(* useful for reasoning over environments updated in invoke, i.e. E\<lfloor>self:=Ref a\<rfloor> etc *)
lemma env_upd_same_bwd: "\<And> E E' x y v. \<lbrakk> E\<lfloor>x:=v\<rfloor> = E'\<lfloor>x:=v\<rfloor> ; x \<noteq> y \<rbrakk> \<Longrightarrow> E\<lfloor>y\<rfloor>=E'\<lfloor>y\<rfloor>"
(* apply (simp add: rvarupdate_def ivarupdate_def renv_bonzo_def ienv_bonzo_def) *)
apply (subgoal_tac "\<forall> z. (E\<lfloor>x := v\<rfloor>)\<lfloor>z\<rfloor> = (E'\<lfloor>x := v\<rfloor>)\<lfloor>z\<rfloor>")
  prefer 2
  (* prove subgoal *)
  apply clarsimp
  apply (tactic {* all_tac *})
  (* use subgoal *)
  apply (erule_tac x=y in allE)
  (* subgoal in the form of the consequent of rvarUpdOther *)
  apply (subgoal_tac "E\<lfloor>x := v\<rfloor>\<lfloor>y\<rfloor> = E\<lfloor>y\<rfloor>")
  apply (subgoal_tac "E'\<lfloor>x := v\<rfloor>\<lfloor>y\<rfloor> = E'\<lfloor>y\<rfloor>")
   apply (simp)
  (* now prove the 2 subgoals above; in each need to apply rvarUpdOther as main step *)
  (* 1st subgoal *)
  apply (rule env_upd_otherR)
  apply clarsimp
  (* 2nd subgoal (same as above) *)
  apply (rule env_upd_otherR)
  apply clarsimp
done

(* useful for reasoning over environments updated in invoke, i.e. E\<lfloor>self:=Ref a\<rfloor> etc *)
lemma env_upd_same: "\<And> E E' x v. E\<lfloor>x:=v\<rfloor> = E'\<lfloor>x:=v\<rfloor> \<Longrightarrow> \<forall> y . x \<noteq> y \<longrightarrow> E\<lfloor>y\<rfloor>=E'\<lfloor>y\<rfloor>"
(* apply (simp add: rvarupdate_def ivarupdate_def renv_bonzo_def ienv_bonzo_def) *)
apply clarsimp
apply (subgoal_tac "\<forall> z. (E\<lfloor>x := v\<rfloor>)\<lfloor>z\<rfloor> = (E'\<lfloor>x := v\<rfloor>)\<lfloor>z\<rfloor>")
  prefer 2
  (* prove subgoal *)
  apply clarsimp
  apply (tactic {* all_tac *})
  (* use subgoal *)
  apply (erule_tac x=y in allE)
  (* subgoal in the form of the consequent of rvarUpdOther *)
  apply (subgoal_tac "E\<lfloor>x := v\<rfloor>\<lfloor>y\<rfloor> = E\<lfloor>y\<rfloor>")
  apply (subgoal_tac "E'\<lfloor>x := v\<rfloor>\<lfloor>y\<rfloor> = E'\<lfloor>y\<rfloor>")
   apply (simp)
  (* now prove the 2 subgoals above; in each need to apply rvarUpdOther as main step *)
  (* 1st subgoal *)
  apply (rule env_upd_otherR)
  apply clarsimp
  (* 2nd subgoal (same as above) *)
  apply (rule env_upd_otherR)
  apply clarsimp
done

lemma newframeSelf[simp]: "(newframe_env slf prm)\<lfloor>self\<rfloor> = slf"
apply (insert constdistinct)
apply (simp add: newframe_env_def renv_fct_def emptyr_def)
done

lemma newframeParam[simp]: "(newframe_env slf prm)\<lfloor>param\<rfloor> = prm"
apply (insert constdistinct)
apply (simp add: newframe_env_def renv_fct_def emptyr_def)
done

lemma newframeOther[simp]: "[| x \<noteq> self ; x \<noteq> param |] ==> (newframe_env r slf)\<lfloor>x\<rfloor> = Nullref"
apply (insert constdistinct)
apply (simp add: newframe_env_def renv_fct_def emptyr_def)
done

(* lemma newframeOther: "x \<noteq> y \<Longrightarrow> (newframe_env r E\<lfloor>x\<rfloor>)\<lfloor>y\<rfloor> = nullref" *)
end
