(*  
   File:	$RCSfile: ExampleSwap.thy,v $
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ExampleSwap.thy,v 1.6 2003/10/01 20:45:50 a1hloidl Exp $

   Non-recursive function (VDM style)
*)

theory ExampleSwap = VDM + Prelude + Lemmas:
section {* swap two variables *}
(*slightly changed in order to return a variable*)
locale swap_example =
  fixes    tmp :: iname
    and	   x :: iname
    and	   y :: iname
    and	   q :: iname
    and	   swap      :: funame

  assumes swapfun[simp]:
"funtable swap =  
 LET q  = x :> y
 IN IF q 
    THEN LET
      tmp = IVar x;
      x = IVar y;
      y = IVar tmp
     IN IVar x END
    ELSE IVar x
 END"

 and  vardistinct: "distinct [tmp,x,y,q] \<and> distinct [q,y,x,tmp]"

lemma (in swap_example) 
   "\<exists> A B . \<rhd> CALL swap :
      {(E,h,hh,v,p). (E<y> < E<x> \<longrightarrow> v = IVal (E<y>) \<and> clock p = A) \<and> 
                     ((E<x> <= E<y>) \<longrightarrow> v = IVal (E<x>) \<and> clock p = B) \<and> 
                     callc p = 1 \<and> invkc p = 0 \<and> invkdpth p = 0}"
apply rule
apply rule
apply (rule vdm_call, simp)
apply (rule vdm_conseq)
apply (rule vdm_leti)
apply (rule vdm_prim)
apply (rule vdm_if)
apply (rule vdm_leti)
apply (rule vdm_ivar)
apply (rule vdm_leti)
apply (rule vdm_ivar)
apply (rule vdm_leti)
apply (rule vdm_ivar)
apply (rule vdm_ivar)
apply (rule vdm_ivar)
apply (insert vardistinct)
apply clarsimp
apply fastsimp (*instantiates A to 14 and B to 8*)
done

(* so let's prove it for 14 and 8*)
lemma (in swap_example) 
   "\<rhd> CALL swap :
      {(E,h,hh,v,p). (E<y> < E<x> \<longrightarrow> v = IVal (E<y>) \<and> h = hh \<and> p = \<langle> 14 1 0 0 \<rangle>) \<and> 
                     ((E<x> <= E<y>) \<longrightarrow> v = IVal (E<x>) \<and> h = hh \<and> p =  \<langle> 8 1 0 0 \<rangle>)}"
apply (rule vdm_call, simp)
apply (rule vdm_conseq)
apply (rule vdm_leti)
apply (rule vdm_prim)
apply (rule vdm_if)
apply (rule vdm_leti)
apply (rule vdm_ivar)
apply (rule vdm_leti)
apply (rule vdm_ivar)
apply (rule vdm_leti)
apply (rule vdm_ivar)
apply (rule vdm_ivar)
apply (rule vdm_ivar)
apply (insert vardistinct)
apply clarsimp
done


end

