(*  Examples from List.cmlt -> Grail*)

theory ExampleListReverseInplace = VDMderived + ExampleListClass:
(* List reversal:
Camelot:
let rev' l acc = 
  match l with Nil@d => acc 
             | Cons (h, t)@d => rev' t (Cons (h, acc)@d )

Grail:   
class ListRevInPlace {
   method public static ListRevInPlace$dia_0 rev' (ListRevInPlace$dia_0 l, ListRevInPlace$dia_0 acc) =
   let

      fun f:rev'(ListRevInPlace$dia_0 l, ListRevInPlace$dia_0 d, ListRevInPlace$dia_0 ?t0, ListRevInPlace$dia_0 d#0, int h, ListRevInPlace$dia_0 t, ListRevInPlace$dia_0 acc, ListRevInPlace$dia_0 l) =
      let
         val tag = getfield l <int ListRevInPlace$dia_0.$>
      in
         if tag = 0
         then f:0(l, d, ?t0, d#0, h, t, acc, l)
         else f:1(l, d, ?t0, d#0, h, t, acc, l)
      end

      fun f:1(ListRevInPlace$dia_0 l, ListRevInPlace$dia_0 d, ListRevInPlace$dia_0 ?t0, ListRevInPlace$dia_0 d#0, int h, ListRevInPlace$dia_0 t, ListRevInPlace$dia_0 acc, ListRevInPlace$dia_0 l) =
      let
         val h = getfield l <int ListRevInPlace$dia_0.f0>
         val t = getfield l <ListRevInPlace$dia_0 ListRevInPlace$dia_0.f1>
         val d#0 = l
         val ?t0 = invokestatic <ListRevInPlace$dia_0 ListRevInPlace$dia_0.fill (ListRevInPlace$dia_0, int, int, ListRevInPlace$dia_0)> (d#0, 1, h, acc)
      in
         invokestatic <ListRevInPlace$dia_0 ListRevInPlace.rev' (ListRevInPlace$dia_0, ListRevInPlace$dia_0)> (t, ?t0)
      end

      fun f:0(ListRevInPlace$dia_0 l, ListRevInPlace$dia_0 d, ListRevInPlace$dia_0 ?t0, ListRevInPlace$dia_0 d#0, int h, ListRevInPlace$dia_0 t, ListRevInPlace$dia_0 acc, ListRevInPlace$dia_0 l) =
      let
         val d = l
      in
         acc
      end
   in
      f:rev'(l, d, ?t0, d#0, h, t, acc, l)
   end
}

ToyGrail:
class ListRevInPlace {
   method public static List rev' (List l, List acc) =
   let fun f(List l, List acc) =
        let  tag = getfield l TAG
        in if tag = 0
           then acc
           else let  h = getfield l HD
                     t = getfield l TL
                     one = 1
                     () = putfield l TAG one
                     () = putfield l HD h
                     () = putfield l TL acc
                     acc = l
                     l = t
                in f(l,acc)
                end
   in
      f(l, acc)
   end
}
*)


constdefs callcA :: nat "callcA == 1"
constdefs callcB :: nat "callcB == 1"
constdefs clockA :: nat "clockA == 31"
constdefs clockB :: nat "clockB == 11"
constdefs invkcA :: nat "invkcA == 0"
constdefs invkcB :: nat "invkcB == 0"
constdefs invkdpthA :: nat "invkdpthA == 0"
constdefs invkdpthB :: nat "invkdpthB == 0"

locale RevInplace = 
  fixes    tag     :: iname    and	   h       :: iname    and	   b       :: iname   and one :: iname
    and    l       :: rname    and         acc     :: rname    and         t       :: rname  
    and	   f       :: funame
 assumes  funtf[simp]:
          "funtable f == (LET tag = GetFi l TAG;
                                b = Primop (% x y. if x < 1 then 1 else 0) tag tag
                          IN IF b THEN RVar acc 
                             ELSE LET  h   = GetFi l HD;
                                    rf t   = GetFr l TL;
                                       one = expr.Int 1;
                                         _ = PutFi l TAG one; 
                                         _ = PutFi l HD h;
                                         _ = PutFr l TL acc;
                                    rf acc = RVar l;
                                    rf l   = RVar t 
                                 IN CALL f END
                         END)::'a expr"
     and spectf[simp]:
         "spectable f == {(E,h,hh,v,p) . 
           (\<forall> L X rl AC Y racc. ((E\<lfloor>l\<rfloor> = Ref rl \<and> (L,rl,X,h) \<in> LocLength \<and>
                                  E\<lfloor>acc\<rfloor> = Ref racc \<and> (AC,racc,Y,h) \<in> LocLength \<and> X \<inter> Y = {}) \<longrightarrow> 
                                 (HSize h = HSize hh \<and> 
                                  p = \<langle> (clockA * L + clockB) (callcA * L + callcB) (invkcA * L + invkcB) (invkdpthA * L + invkdpthB)\<rangle>)))}"
      and  vardistinct:     "distinct [tag,h,b,one] \<and> distinct [one,b,h,tag] \<and> 
                             distinct[l,acc,t] \<and> distinct [t,acc,l] \<and>
                             distinct[HD,TAG] \<and> distinct [TAG,HD]"

lemma (in RevInplace) "\<rhd> ((Call f)::'a expr) : spectable f"
apply (rule vdm_call)
apply (simp)
apply (rule vdm_conseq)
apply(rule vdm_leti, rule vdm_getfi) prefer 2 apply clarsimp prefer 2
apply(rule vdm_leti, rule vdm_prim) prefer 2 apply clarsimp prefer 2
apply(rule vdm_if)
apply(rule vdm_rvar) prefer 2 apply clarsimp
apply (case_tac "aa<ad\<bullet>TAG> < 1")
apply clarsimp apply (erule LocLength.elims, clarsimp) 
apply(simp_all add: clockB_def callcB_def invkcB_def invkdpthB_def)
prefer 2
apply(rule vdm_leti, rule vdm_getfi) prefer 2 apply clarsimp prefer 2
apply(rule vdm_letr, rule vdm_getfr) prefer 2 apply clarsimp prefer 2
apply(rule vdm_leti, rule vdm_int) prefer 2 apply clarsimp prefer 2
apply(rule vdm_letv, rule vdm_putfi) prefer 2 apply clarsimp prefer 2
apply(rule vdm_letv, rule vdm_putfi) prefer 2 apply clarsimp prefer 2
apply(rule vdm_letv, rule vdm_putfr) prefer 2 apply clarsimp prefer 2
apply(rule vdm_letr, rule vdm_rvar) prefer 2 apply clarsimp prefer 2
apply(rule vdm_letr, rule vdm_rvar) prefer 2 apply clarsimp prefer 2
apply (rule vdm_ax, simp)
apply (insert vardistinct)
apply clarsimp
apply (erule LocLength.elims, simp_all, clarsimp)
apply (erule_tac x=i in allE)
apply (erule impE)
apply (rule_tac x="Xa - {la}" in exI, rule)
apply (rule LocLengthSame, assumption)
apply (simp add: same_def) 
apply (rule_tac x="Suc AC" in exI, rule_tac x="Y \<union> {la}" in exI, rule)
apply (rule CONS_LocL, simp_all)
apply (subgoal_tac "racc \<in> Y")
apply fast
apply (erule LocLength.elims, simp_all)
apply (subgoal_tac "Y = Y - {la}", clarsimp)
apply (rule LocLengthSame, assumption)
apply (simp add: same_def)
apply fast
apply fast
apply fast
apply (simp_all add: clockA_def callcA_def invkcA_def invkdpthA_def)
done

(*With invokes:*)
(*class ListRevInPlace {
   method public static REV (l, acc) =
   let fun f(l, t0, h, t, acc) =
         let val tag = getfield l TAG
         in if tag = 0
            then f0(l, t0, h, t, acc)
            else f1(l, t0, h, t, acc)
         end

       fun f1(l, t0, h, t, acc) =
         let val h = getfield l HD
             val t = getfield l TL
             val one = 1
             val _ = putfield l TAG one
             val _ = putfield l HD h
             val _ = putfield l TL acc
             val t0 = l
         in invokestatic REV (t, t0)
         end

      fun f0(l, d, t0, h, t, acc) = acc
   in f(l, t0, h, t, acc)
   end
}
*)

constdefs IcallcA :: nat "IcallcA == 1"
constdefs IcallcB :: nat "IcallcB == 1"
constdefs IclockA :: nat "IclockA == 31"
constdefs IclockB :: nat "IclockB == 11"
constdefs IinvkcA :: nat "IinvkcA == 0"
constdefs IinvkcB :: nat "IinvkcB == 0"
constdefs IinvkdpthA :: nat "IinvkdpthA == 0"
constdefs IinvkdpthB :: nat "IinvkdpthB == 0"

constdefs IIcallcA :: nat "IIcallcA == 1"
constdefs IIcallcB :: nat "IIcallcB == 1"
constdefs IIclockA :: nat "IIclockA == 31"
constdefs IIclockB :: nat "IIclockB == 20"
constdefs IIinvkcA :: nat "IIinvkcA == 0"
constdefs IIinvkcB :: nat "IIinvkcB == 1"
constdefs IIinvkdpthA :: nat "IIinvkdpthA == 0"
constdefs IIinvkdpthB :: nat "IIinvkdpthB == 1"

locale RevInplaceInvoke = 
  fixes    tag     :: iname    and	   h       :: iname    and	   b       :: iname   and one :: iname
    and    l       :: rname    and         acc     :: rname    and         t       :: rname   and t0 :: rname
    and	   f       :: funame   and REV :: mname and mspectRev1:: vdmassn and mspectRev2 :: vdmassn
 assumes  funtf[simp]:
          "funtable f == (LET tag = GetFi l TAG;
                                b = Primop (% x y. if x < 1 then 1 else 0) tag tag
                          IN IF b
                             THEN RVar acc 
                             ELSE LET  h   = GetFi l HD;
                                    rf t   = GetFr l TL;
                                       one = expr.Int 1;
                                         _ = PutFi l TAG one; 
                                         _ = PutFi l HD h;
                                         _ = PutFr l TL acc;
                                     rf t0 = RVar l
                                  IN t\<diamondsuit>REV(t0) END 
                          END)::'a expr"
     and meth[simp]:
         "methtable LST REV == (LET rf l = RVar self;
                                rf acc = RVar param
                              IN CALL f END)::'a expr"
     and spectf:
         "spectable f == {(E,h,hh,v,p) . 
           (\<forall> L X rl AC Y racc. ((E\<lfloor>l\<rfloor> = Ref rl \<and> (L,rl,X,h) \<in> LocLength \<and>
                                  E\<lfloor>acc\<rfloor> = Ref racc \<and> (AC,racc,Y,h) \<in> LocLength \<and> X \<inter> Y = {}) \<longrightarrow> 
                                 (HSize h = HSize hh \<and> 
                                  p = \<langle> (IclockA * L + IclockB) (IcallcA * L + IcallcB) (IinvkcA * L + IinvkcB) (IinvkdpthA * L + IinvkdpthB)\<rangle>)))}"
      and  vardistinct:     "distinct [tag,h,b,one] \<and> distinct [one,b,h,tag] \<and> 
                             distinct[l,acc,t,t0,self,param] \<and> distinct [param,self,t0,t,acc,l] \<and>
                             distinct[HD,TAG] \<and> distinct [TAG,HD]"
    defines "mspectRev1 == {(E,h,hh,v,p) . (\<forall> L X rl AC Y racc. 
                                (fmap_lookup (oheap h) rl = Some LST \<and> 
                                 fmap_lookup (oheap h) racc = Some LST \<and>
                                 (E\<lfloor>l\<rfloor> = Ref rl \<and> (L,rl,X,h) \<in> LocLength \<and>
                                  E\<lfloor>acc\<rfloor> = Ref racc \<and> (AC,racc,Y,h) \<in> LocLength \<and> X \<inter> Y = {}) \<longrightarrow> 
                                 (HSize h = HSize hh \<and> 
                                  p = \<langle> (IIclockA * L + IIclockB) (IIcallcA * L + IIcallcB) (IIinvkcA * L + IIinvkcB) (IIinvkdpthA * L + IIinvkdpthB)\<rangle>)))}"
        and "mspectRev2 == {(E,h,hh,v,p) . (\<forall> L X rl AC Y racc. 
                                (fmap_lookup (oheap h) rl = Some LST \<and> 
                                 fmap_lookup (oheap h) racc = Some LST \<and>
                                 (E\<lfloor>t\<rfloor> = Ref rl \<and> (L,rl,X,h) \<in> LocLength \<and>
                                  E\<lfloor>t0\<rfloor> = Ref racc \<and> (AC,racc,Y,h) \<in> LocLength \<and> X \<inter> Y = {}) \<longrightarrow> 
                                 (HSize h = HSize hh \<and> 
                                  p = \<langle> (IIclockA * L + IIclockB) (IIcallcA * L + IIcallcB) (IIinvkcA * L + IIinvkcB) (IIinvkdpthA * L + IIinvkdpthB)\<rangle>)))}"

lemma (in RevInplaceInvoke) "\<rhd> ((l\<diamondsuit>REV(acc))::'a expr) : {(E,h,hh,v,p) . 
           (\<forall> L X rl AC Y racc. ((fmap_lookup (oheap h) rl = Some LST \<and> 
                                 fmap_lookup (oheap h) racc = Some LST \<and> E\<lfloor>l\<rfloor> = Ref rl \<and> (L,rl,X,h) \<in> LocLength \<and>
                                  E\<lfloor>acc\<rfloor> = Ref racc \<and> (AC,racc,Y,h) \<in> LocLength \<and> X \<inter> Y = {}) \<and> AC = 0 \<longrightarrow> 
                                 (HSize h = HSize hh \<and> 
                                  p = \<langle> (IIclockA * L + IIclockB) (IIcallcA * L + IIcallcB) (IIinvkcA * L + IIinvkcB) (IIinvkdpthA * L + IIinvkdpthB)\<rangle>)))}"
apply (insert vardistinct)
apply (subgoal_tac "\<forall> E h loc CC . (qach_QaQ E h loc l CC \<longrightarrow> CC = LST) \<and> (qach_QaQ E h loc t CC \<longrightarrow> CC = LST) ")
apply (rule vdm_conseq)
apply (subgoal_tac "\<rhd> l\<diamondsuit>REV(acc) : mspectRev1")
apply assumption
prefer 2 apply (simp add: mspectRev1_def, clarsimp) apply (erule_tac x=L in allE) apply (erule impE) apply fast apply simp
apply (rule MUTREC)
apply (subgoal_tac "finite {(l\<diamondsuit>REV(acc),mspectRev1), (t\<diamondsuit>REV(t0),mspectRev2), (CALL f, spectable f)}")
apply assumption
apply simp
apply simp
apply clarsimp
prefer 2 apply (simp)
apply (simp add: consistent_def)
apply (rule)
apply (rule vdm_conseq)
apply (rule vdm_leti, rule vdm_getfi)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_leti, rule vdm_prim)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_if)
apply (rule vdm_rvar)
prefer 2 apply clarsimp apply (case_tac "aa<ad\<bullet>TAG> < 1", clarsimp) prefer 2 apply clarsimp
prefer 4 apply clarsimp defer 1 prefer 3
apply (rule vdm_leti, rule vdm_getfi)
prefer 2 apply clarsimp prefer 2 
apply (rule vdm_letr, rule vdm_getfr)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_leti, rule vdm_int)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv, rule vdm_putfi)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv, rule vdm_putfi)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv, rule vdm_putfr)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr, rule vdm_rvar)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_ax, simp)
prefer 4
apply rule
apply clarsimp
apply rule prefer 2
apply clarsimp
apply (erule_tac x=E' in allE, erule_tac x=h' in allE, erule_tac x=a in allE, erule_tac x=C in allE, clarify)
apply (simp only: meth)
apply (rule vdm_conseq)
apply(rule vdm_letr, rule vdm_rvar) prefer 2 apply clarsimp prefer 2
apply(rule vdm_letr, rule vdm_rvar) prefer 2 apply clarsimp prefer 2
apply(rule vdm_ax, simp)
prefer 3 
apply clarsimp
apply rule prefer 2
apply clarsimp
apply (erule_tac x=E' in allE, erule_tac x=h' in allE, erule_tac x=a in allE, erule_tac x=C in allE, clarify)
apply (simp only: meth)
apply (rule vdm_conseq)
apply(rule vdm_letr, rule vdm_rvar) prefer 2 apply clarsimp prefer 2
apply(rule vdm_letr, rule vdm_rvar) prefer 2 apply clarsimp prefer 2
apply(rule vdm_ax, simp)
(* end of vcg*)
apply (simp add: spectf mspectRev2_def, clarsimp)
apply (erule_tac x=L in allE)
apply (erule impE)
apply (rule_tac x=X in exI, simp)
apply (rule_tac x=AC in exI, rule_tac x=Y in exI, simp)
apply clarsimp
apply (simp add: IIclockA_def IclockA_def IIclockB_def IclockB_def
                    IIcallcA_def IcallcA_def IIcallcB_def IcallcB_def
                    IIinvkcA_def IinvkcA_def IIinvkcB_def IinvkcB_def
                    IIinvkdpthA_def IinvkdpthA_def IIinvkdpthB_def IinvkdpthB_def)
defer 1
apply (simp add: spectf mspectRev1_def, clarsimp)
apply (erule_tac x=L in allE)
apply (erule impE)
apply (rule_tac x=X in exI, simp)
apply (rule_tac x=AC in exI, rule_tac x=Y in exI, simp)
apply clarsimp
apply (simp add: IIclockA_def IclockA_def IIclockB_def IclockB_def
                    IIcallcA_def IcallcA_def IIcallcB_def IcallcB_def
                    IIinvkcA_def IinvkcA_def IIinvkcB_def IinvkcB_def
                    IIinvkdpthA_def IinvkdpthA_def IIinvkdpthB_def IinvkdpthB_def)
defer 1
apply (simp add: spectf mspectRev2_def, clarsimp)
apply (erule LocLength.elims, simp_all, clarsimp)
apply (erule_tac x=i in allE)
apply (erule impE, clarsimp)
apply rule apply (rotate_tac -3, erule LocLength.elims, simp_all)
apply (rule_tac x="Xa - {la}" in exI, rule)
apply (subgoal_tac "same (Xa - {la}) hp (hp\<lparr>iheap := (iheap hp)(TAG := (iheap hp TAG)(la := 1)), iheap := (iheap hp)(TAG := (iheap hp TAG)(la := 1), HD := iheap hp HD),
              rheap := (rheap hp)(TL := (rheap hp TL)(la := Ref racc))\<rparr>)")
apply (erule LocLengthSame, simp) 
apply (simp add: same_def)
apply (rule_tac x="Suc AC" in exI, rule_tac x="insert la Y" in exI, clarsimp, rule)
apply (rule CONS_LocL, simp_all)
apply (subgoal_tac "racc \<in> Y")
apply fast
apply (erule LocLength.elims, simp_all)
apply (subgoal_tac "Y = Y - {la}", clarsimp)
apply (subgoal_tac "same Y hp (hp\<lparr>iheap := (iheap hp)(TAG := (iheap hp TAG)(la := 1)), iheap := (iheap hp)(TAG := (iheap hp TAG)(la := 1), HD := iheap hp HD),
              rheap := (rheap hp)(TL := (rheap hp TL)(la := Ref racc))\<rparr>)")
apply (erule LocLengthSame, simp) 
apply (simp add: same_def)
apply fast
apply fast
apply fast
defer 1
apply (simp add: spectf, clarsimp)
apply (erule LocLength.elims, simp_all, clarsimp) 
apply (simp add: IIclockA_def IclockA_def IIclockB_def IclockB_def
                    IIcallcA_def IcallcA_def IIcallcB_def IcallcB_def
                    IIinvkcA_def IinvkcA_def IIinvkcB_def IinvkcB_def
                    IIinvkdpthA_def IinvkdpthA_def IIinvkdpthB_def IinvkdpthB_def)
prefer 2
apply (rule_tac x="\<lparr>ienv = \<lambda> x . 1, renv = \<lambda> x . Ref 1\<rparr>" in exI)
apply (rule_tac x="\<lparr>oheap = fmap_upd emptyfinmap 1 LST, iheap = \<lambda> f loc. 1, rheap = \<lambda> f loc . Nullref\<rparr>" in exI)
apply (rule_tac x="1" in exI)
apply (rule_tac x="LST" in exI, simp add: qach_QaQ_def mspectRev2_def)
apply clarsimp
apply rule
prefer 2
apply rule 
apply (simp add: IIclockA_def IclockA_def IIclockB_def IclockB_def
                    IIcallcA_def IcallcA_def IIcallcB_def IcallcB_def
                    IIinvkcA_def IinvkcA_def IIinvkcB_def IinvkcB_def
                    IIinvkdpthA_def IinvkdpthA_def IIinvkdpthB_def IinvkdpthB_def)
apply rule
prefer 2
apply (simp add: IIclockA_def IclockA_def IIclockB_def IclockB_def
                    IIcallcA_def IcallcA_def IIcallcB_def IcallcB_def
                    IIinvkcA_def IinvkcA_def IIinvkcB_def IinvkcB_def
                    IIinvkdpthA_def IinvkdpthA_def IIinvkdpthB_def IinvkdpthB_def)
prefer 4
apply (subgoal_tac "IIclockA = IclockA \<and> IIclockB = IclockB + 9 \<and> 
                    IIcallcA = IcallcA \<and> IIcallcB = IcallcB \<and>
                    IIinvkcA = IinvkcA \<and> IIinvkcB = IinvkcB + 1 \<and>
                    IIinvkdpthA = IinvkdpthA \<and> IIinvkdpthB = IinvkdpthB + 1", clarsimp)
apply (subgoal_tac "29 + IIclockB = IclockA + IclockB \<and> Suc 0 = IcallcA \<and> IIinvkcB = IinvkcA + IinvkcB \<and> IIinvkdpthB 
apply (simp add: spectf, clarsimp)
apply (erule LocLength.elims, simp_all, clarsimp) 
defer 1
here
apply(simp_all add: clockB_def callcB_def invkcB_def invkdpthB_def)
prefer 2
apply(rule vdm_leti, rule vdm_getfi) prefer 2 apply clarsimp prefer 2
apply(rule vdm_letr, rule vdm_getfr) prefer 2 apply clarsimp prefer 2
apply(rule vdm_leti, rule vdm_int) prefer 2 apply clarsimp prefer 2
apply(rule vdm_letv, rule vdm_putfi) prefer 2 apply clarsimp prefer 2
apply(rule vdm_letv, rule vdm_putfi) prefer 2 apply clarsimp prefer 2
apply(rule vdm_letv, rule vdm_putfr) prefer 2 apply clarsimp prefer 2
apply(rule vdm_letr, rule vdm_rvar) prefer 2 apply clarsimp prefer 2
apply(rule vdm_letr, rule vdm_rvar) prefer 2 apply clarsimp prefer 2
apply (rule vdm_ax, simp)
apply (insert vardistinct)
apply clarsimp
apply (erule LocLength.elims, simp_all, clarsimp)
apply (erule_tac x=i in allE)
apply (erule impE)
apply (rule_tac x="Xa - {la}" in exI, rule)
apply (subgoal_tac "same (Xa - {la}) hp (hp \<lparr>iheap := (iheap hp)(TAG := (iheap hp TAG)(la := 1)),
              iheap := (iheap hp)(TAG := (iheap hp TAG)(la := 1), HD := iheap hp HD),
              rheap := (rheap hp)(TL := (rheap hp TL)(la := Ref racc))\<rparr>)")
defer 1
apply (simp add: same_def) 
apply (rule_tac x="Suc AC" in exI, rule_tac x="Y \<union> {la}" in exI, rule)
apply (rule CONS_LocL, simp_all)
apply (subgoal_tac "racc \<in> Y")
apply fast
apply (erule LocLength.elims, simp_all)
apply (subgoal_tac "Y = Y - {la}", clarsimp)
apply (subgoal_tac "same Y hp \<lparr>oheap = oheap hp, iheap = (iheap hp)(TAG := (iheap hp TAG)(la := 1), HD := iheap hp HD),
              rheap = (rheap hp)(TL := (rheap hp TL)(la := Ref racc))\<rparr>")
defer 1
apply (simp add: same_def, fast)
apply fast
apply fast
apply (simp_all add: clockA_def callcA_def invkcA_def invkdpthA_def)
apply (erule LocLengthSame) apply fast
apply (erule LocLengthSame) 
apply (simp add: same_def)
done

(*this was the old proof (for hsize only):
lemma (in RevInplace)
"\<Turnstile> {(H,s). HSize s = H} (CALL f) {(H,s,v) . HSize s = H}"
apply (insert vardistinct, clarsimp)
apply (rule HCallRec)
apply simp
apply(rule HPre)
apply(rule HPost)
apply (rule HSP)
apply (rule hoarebasics)+
apply assumption
apply (rule subset_refl)
by (clarsimp, simp, fastsimp)
*)

end
(*old stuff follows------------------------------------------------------------------- *)
locale RevInplaceClock = 
  fixes    tag     :: iname    and	   h       :: iname    and	   b       :: iname   and one :: iname
    and    l       :: rname    and         acc     :: rname    and         t       :: rname  
    and	   f       :: funame   and	   fBody   :: "(nat \<times> nat \<times> int \<times> (ref set) \<times> (ref set)) expr"
 defines  "fBody == PRE {((N,ACC,C,X,Y),s). clock s = C \<and> (N,s\<lfloor>l\<rfloor>,X,getheap s) \<in> LLength \<and> (ACC,s\<lfloor>acc\<rfloor>,Y, getheap s) \<in> LLength
                                            \<and> X Int Y = {}} :
                    POST {((N,ACC,C,X,Y),s,v) . clock s = C + 33 * (int N) + 9} :
                    LET tag = GetFi l TAG;
                        b = Primop (% x y. if x < 1 then 1 else 0) tag tag
                    IN IF b THEN RVar acc 
                            ELSE LET  h   = GetFi l HD;
                                      rf t   = GetFr l TL;
                                      one = expr.Int 1;
                                      one = PutFi l TAG one; 
                                      h   = PutFi l HD h;
                                      rf acc = PutFr l TL acc;
                                      rf acc = RVar l;
                                      rf l   = RVar t 
                                 IN CALL f END
                    END"

  assumes  fbdy[simp]:  "funtable f = fBody"
      and  vardistinct: "distinct [tag,h,b,one] \<and> distinct [one,b,h,tag] \<and> distinct[l,acc,t] \<and> distinct [t,acc,l]"

declare getheap_def [simp]
declare (in RevInplaceClock) fBody_def [simp]

lemma (in RevInplaceClock)
"HD \<noteq> TAG \<and> TAG \<noteq> HD \<longrightarrow> 
  \<Turnstile> {((N,ACC,C,X,Y),s). clock s = C \<and> (N,s\<lfloor>l\<rfloor>,X,getheap s) \<in> LLength \<and> (ACC,s\<lfloor>acc\<rfloor>,Y,getheap s) \<in> LLength
                    \<and> X Int Y = {}}
   (CALL f) 
   {((N,ACC,C,X,Y),s,v) . clock s = C + 33 * (int N) + 10}"
apply clarsimp
apply (rule HCallRecPrePostInvAdapt)
apply simp
apply (rule, rule, rule, rule refl, rule refl)
apply (rule HSP)
apply (rule hoarebasics)+
apply (erule assume_adapt)
apply (rule subset_refl)
(*now only side conditions left*)
prefer 2
  apply clarsimp
  apply(rule_tac x=a in exI, simp)
  apply(rule_tac x="aa" in exI)
  apply(rule_tac x="ac" in exI, simp)
  apply(rule_tac x=b in exI, simp)
apply (insert vardistinct)
apply clarsimp
apply rule
apply rule
apply (erule LLength.elims, simp, clarsimp)
apply rule
apply (subgoal_tac "baa<baa\<lceil>l\<rceil>\<bullet>TAG> = 1 \<and> (\<exists> N. a = Suc N) \<and> (\<exists> rl . baa\<lfloor>l\<rfloor> = Ref rl)")
prefer 2
  apply (erule LLength.elims, clarsimp, clarsimp)
apply clarsimp
apply (subgoal_tac "\<exists> racc. (baa\<lfloor>acc\<rfloor> = Ref racc \<and> Ref racc \<in> ba)")
prefer 2
  apply (rotate_tac 6)
  apply (erule LLength.elims, clarsimp, clarsimp)
apply clarsimp
apply (erule LLength.elims, clarsimp, clarsimp)
apply (rule_tac x="i" in exI, simp)
apply (subgoal_tac "\<exists> rtl. baa\<lfloor>la\<diamondsuit>TL\<rfloor> = Ref rtl")
prefer 2
  apply (rotate_tac -3)
  apply (erule LLength.elims, clarsimp, clarsimp)
apply clarsimp
apply (rule_tac x="Suc aa" in exI)
apply (rule_tac x="X - {Ref la}" in exI, simp)
apply (rule_tac x="ba Un {Ref la}" in exI, simp)
apply rule
prefer 2
  apply fastsimp
apply(rule CONS_LL, fastsimp+)
apply (subgoal_tac "(aa, Ref racc, ba,
           \<lparr>objhp = oheap baa, inthp = (iheap baa)(TAG := (iheap baa TAG)(la := 1), HD := iheap baa HD),
              refhp = (rheap baa)(TL := (rheap baa TL)(la := Ref racc))\<rparr>)
          \<in> LLength")
apply (subgoal_tac "insert (Ref la) ba - {Ref la} = ba", fastsimp, fastsimp)
by (subgoal_tac "Ref la \<notin> ba", fastsimp, fastsimp)


(*Here is the variant where the heap domains of the lists are not carried around as auxiliary varaibles
  but asserted as part of the pre-condition*)
locale RevInplaceClock2 = 
  fixes    tag     :: iname    and	   h       :: iname    and	   b       :: iname   and one :: iname
    and    l       :: rname    and         acc     :: rname    and         t       :: rname  
    and	   f       :: funame   and	   fBody   :: "(nat \<times> nat \<times> int) expr"
 defines  "fBody == PRE {((N,ACC,C),s). \<exists> X Y . ( clock s = C \<and> (N,s\<lfloor>l\<rfloor>,X,getheap s) \<in> LLength \<and> (ACC,s\<lfloor>acc\<rfloor>,Y,getheap s) \<in> LLength
                                            \<and> X Int Y = {} \<and> s\<lfloor>l\<rfloor> \<notin> (X Un Y Un {s\<lfloor>acc\<rfloor>}) \<and> s\<lfloor>acc\<rfloor> \<notin> (X Un Y Un {s\<lfloor>l\<rfloor>}))} :
                    POST {((N,ACC,C),s,v) . clock s = C + 33 * (int N) + 9} :
                    LET tag = GetFi l TAG;
                        b = Primop (% x y. if x < 1 then 1 else 0) tag tag
                    IN IF b THEN RVar acc 
                            ELSE LET  h   = GetFi l HD;
                                      rf t   = GetFr l TL;
                                      one = expr.Int 1;
                                      one = PutFi l TAG one; 
                                      h   = PutFi l HD h;
                                      rf acc = PutFr l TL acc;
                                      rf acc = RVar l;
                                      rf l   = RVar t 
                                 IN CALL f END
                    END"

  assumes  fbdy[simp]:  "funtable f = fBody"
      and  vardistinct:     "distinct [tag,h,b,one] \<and> distinct [one,b,h,tag] \<and> distinct[l,acc,t] \<and> distinct [t,acc,l]"

declare (in RevInplaceClock2) fBody_def [simp]

lemma (in RevInplaceClock2)
"\<Turnstile> {((N,ACC,C),s). \<exists> X Y . (clock s = C \<and> (N,s\<lfloor>l\<rfloor>,X,getheap s) \<in> LLength \<and> (ACC,s\<lfloor>acc\<rfloor>,Y,getheap s) \<in> LLength
                \<and> X Int Y = {} \<and> s\<lfloor>l\<rfloor> \<notin> (X Un Y Un {s\<lfloor>acc\<rfloor>}) \<and> s\<lfloor>acc\<rfloor> \<notin> (X Un Y Un {s\<lfloor>l\<rfloor>}))}
   (CALL f) 
   {((N,ACC,C),s,v) . clock s = C + 33 * (int N) + 10}"
apply clarsimp
apply (rule HCallRecPrePostInvAdapt)
apply simp
apply (rule, rule, rule, rule refl, rule refl)
apply (rule HSP)
apply (rule hoarebasics)+
apply (erule assume_adapt)
apply (rule subset_refl)
(*now only side conditions left*)
apply (insert vardistinct)
apply clarsimp
apply rule
apply rule
apply (erule LLength.elims, simp, clarsimp)
apply (erule LLength.elims, clarsimp)
apply clarsimp
apply clarsimp
by (rule_tac x="a" in exI, simp, rule_tac x="aa" in exI,rule_tac x="X" in exI, simp, rule_tac x="Y" in exI, simp)

text {*Now a variation using the simpler predicate LocLength, and without mentioning ACC in the precondition. 
       Also, instead of occurring as an auxiliary variable, X is quantified over in the precondition.
       Furthermore, we switch to letv and use the correct ticks*}
locale RevInplaceClockLoc = 
  fixes    tag     :: iname    and	   h       :: iname    and	   b       :: iname   and one :: iname
    and    l       :: rname    and         acc     :: rname    and         t       :: rname  
    and	   f       :: funame
 assumes  fbdy: "funtable f == 
                          PRE {((N,C),s). \<exists> X loc . clock s = C \<and> s\<lfloor>l\<rfloor> = Ref loc \<and> (N,loc,X,getheap s) \<in> LocLength}:
                          POST {((N,C),s,v) . clock s = C + 30 * (int N) + 9} :
                          LET tag = GetFi l TAG;
                              b = Primop (% x y. if x < 1 then 1 else 0) tag tag
                          IN IF b THEN RVar acc 
                                  ELSE LET  h   = GetFi l HD;
                                         rf t   = GetFr l TL;
                                            one = expr.Int 1;
                                            _   = PutFi l TAG one; 
                                            _   = PutFi l HD h;
                                            _   = PutFr l TL acc;
                                         rf acc = RVar l;
                                         rf l   = RVar t 
                                       IN CALL f END
                          END"

      and  vardistinct: "distinct [tag,h,b,one] \<and> distinct [one,b,h,tag] \<and>
                         distinct[l,acc,t] \<and> distinct [t,acc,l] \<and> 
                         distinct[HD,TAG]"

declare (in RevInplaceClockLoc) getheap_def [simp]
declare (in RevInplaceClockLoc) fbdy [simp]

lemma (in RevInplaceClockLoc)
" \<Turnstile> {((N,C),s). \<exists> X loc . clock s = C \<and> s\<lfloor>l\<rfloor> = Ref loc \<and> (N,loc,X,getheap s) \<in> LocLength}
   (CALL f) 
   {((N,C),s,v) . clock s = C + 30 * (int N) + 10}"
apply clarsimp
apply (rule HCallRecPrePostInvAdapt)
apply simp
apply (rule, rule, rule, rule refl, rule refl)
apply (rule HSP)
apply (rule hoarebasics)+
apply (erule assume_adapt)
apply (rule subset_refl)
(*now only side conditions left*)
apply (insert vardistinct)
apply clarsimp
apply rule
apply (erule LocLength.elims, clarsimp, clarsimp)
apply (erule LocLength.elims, clarsimp, clarsimp)
apply (rule_tac x="i" in exI, simp)
by (rule_tac x="Xa - {la}" in exI, fastsimp+)

end
