(* $Id: ExampleListAppend.thy,v 1.5 2003/10/01 20:45:49 a1hloidl Exp $ *)

(* This is the example program used in the appendix of the Deliverable. *)

header {* Example: List append *}

(*  Examples from List.cmlt -> Grail*)

(*<*)
theory ExampleListAppend = VDMderived + ExampleListClass:
(*>*)

(* @@ HWL: I have included Camelot, Grail, ToyGrail in the text for the appendix;
           maybe only the Camelot code is enough *)

text {*
 The example in this section is a slightly modified version of the code taken from the 
 Camelot compiler, for a program performing list append.

 The original Camelot code is as follows:

\begin{small}
\begin{verbatim}
let app l m lrev = match l with 
   Nil@d => (match lrev with Nil@e => m
                           | Cons(h,t)@e => app (Nil@d) (Cons(h,m)@e) t)
 | Cons(h,t)@d => app t m (Cons(h,lrev)@d)
\end{verbatim}
\end{small}
*}

(*
The Grail code, directly generated out of the compiler is as follows:

\begin{footnotesize}
\begin{verbatim}
method public static List$dia_0 app (List$dia_0 l, List$dia_0 m, List$dia_0 lrev) =
   let
      fun f(l, lrev, e, ?t6, e#0, ?t5, d, int h, t, d, ?t7, d#0, int h#0, t#0, m) =
      let
         val tag = getfield l TAG
      in
         if tag = 0
         then f:0(l, lrev, e, e, ?t6, e#0, ?t5, d, e#0, e#0, h, t, d, d, ?t7, d#0, d#0, d#0, h#0, t#0, lrev, m, l)
         else f:1(l, lrev, e, e, ?t6, e#0, ?t5, d, e#0, e#0, h, t, d, d, ?t7, d#0, d#0, d#0, h#0, t#0, lrev, m, l)
      end

      fun f:1(\<dots>) =
      let
         val h#0 = getfield l <int List$dia_0.f1>
         val t#0 = getfield l <List$dia_0 List$dia_0.f0>
         val d#0 = l
         val () = putfield d#0 <int List$dia_0.$> 1
         val () = putfield d#0 <int List$dia_0.f1> h#0
         val () = putfield d#0 <List$dia_0 List$dia_0.f0> lrev
         val ?t7 = d#0
      in
         f:2(l, lrev, e, e, ?t6, e#0, ?t5, d, e#0, e#0, h, t, d, d, ?t7, d#0, d#0, d#0, h#0, t#0, lrev, m, l)
      end

      fun f:2(\<dots>) =
         invokestatic <List$dia_0 List.app (List$dia_0, List$dia_0, List$dia_0)> (t#0, m, ?t7)

      fun f:0(\<dots>) =
      let
         val d = l
         val tag = getfield lrev <int List$dia_0.$>
      in
         if tag = 0
         then f:3(l, lrev, e, e, ?t6, e#0, ?t5, d, e#0, e#0, h, t, d, d, ?t7, d#0, d#0, d#0, h#0, t#0, lrev, m, l)
         else f:4(l, lrev, e, e, ?t6, e#0, ?t5, d, e#0, e#0, h, t, d, d, ?t7, d#0, d#0, d#0, h#0, t#0, lrev, m, l)
      end

      fun f:4(\<dots>) =
      let
         val h = getfield lrev <int List$dia_0.f1>
         val t = getfield lrev <List$dia_0 List$dia_0.f0>
         val e#0 = lrev
         val () = putfield d <int List$dia_0.$> 0
         val ?t5 = d
      in
         f:5(l, lrev, e, e, ?t6, e#0, ?t5, d, e#0, e#0, h, t, d, d, ?t7, d#0, d#0, d#0, h#0, t#0, lrev, m, l)
      end

      fun f:5() =
      let
         val () = putfield e#0 <int List$dia_0.$> 1
         val () = putfield e#0 <int List$dia_0.f1> h
         val () = putfield e#0 <List$dia_0 List$dia_0.f0> m
         val ?t6 = e#0
      in
         f:6(l, lrev, e, e, ?t6, e#0, ?t5, d, e#0, e#0, h, t, d, d, ?t7, d#0, d#0, d#0, h#0, t#0, lrev, m, l)
      end

      fun f:6(\<dots>) =
         invokestatic <List$dia_0 List.app (List$dia_0, List$dia_0, List$dia_0)> (?t5, ?t6, t)

      fun f:3(\<dots>) =
      let
         val e = lrev
      in
         m
      end
   in
      f:app(l, lrev, e, e, ?t6, e#0, ?t5, d, e#0, e#0, h, t, d, d, ?t7, d#0, d#0, d#0, h#0, t#0, lrev, m, l)
   end
\end{verbatim}
\end{footnotesize}

With some inlining of code and turning invokes to calls, this can be rewritten into
the following form
*)

text {*
The compiler generated Grail code may be converted into

\begin{small}
\begin{verbatim}
method public static List$dia_0 app (List$dia_0 l, List$dia_0 m, List$dia_0 lrev) =
   let
      fun f(l,m,lrev) =
      let
         val tag = getfield l TAG
      in
         if tag = 0
         then let val tag = getfield lrev TAG
              in if tag = 0
                 then m
                 else let val h = getfield lrev HD
                          val t = getfield lrev TL
                          val () = putfield l TAG 0
                          val () = putfield lrev TAG 1
                          val () = putfield lrev HD h
                          val () = putfield lrev TL m
                          val m = lrev
                          lrev = t
                      in f (l, m, lrev)
                      end
              end
         else let val h = getfield l HD
                  val t = getfield l TL
                  val () = putfield l TAG 1
                  val () = putfield l HD h
                  val () = putfield l TL lrev
                  val lrev = l
                  l = t
              in f (l, m, lrev)
              end
     end
   in
      f(l, m, lrev)
   end
\end{verbatim}
\end{small}
*}

subsection {* Constants *}

text {* 
 Constants used in formulas for resource consumption.
*}

constdefs A :: nat " A == 55"
constdefs B :: nat " B == 90"
constdefs C :: nat " C == 24"
constdefs D :: nat " D == 1"
constdefs EE :: nat " EE == 2"
constdefs F :: nat " F == 1"

subsection {* Correctness property *}

text {*
 The Grail code of the append function, its specification and other basic assumptions.
*}

locale Append = 
  fixes    tag :: iname and h :: iname and b :: iname and one  :: iname and zero :: iname and h0 :: iname
    and    l   :: rname and m :: rname and t :: rname and lrev :: rname and d :: rname and e :: rname
    and    e0  :: rname and t5 :: rname and t6 :: rname and t0 :: rname and d0 :: rname and t7 :: rname
    and	   f   :: funame
    and myContext :: "'a vdmcontext"
 assumes fbdy[simp]: 
         "funtable f == LET tag = GetFi l TAG;
                              b = Primop (% x y. if x = 0 then 1 else 0) tag tag 
                         IN IF b
                            THEN LET rf d = RVar l;
                                      tag = GetFi lrev TAG;
                                        b = Primop (% x y. if x = 0 then 1 else 0) tag tag 
                                 IN IF b 
                                    THEN LET rf e = RVar lrev IN RVar m END
                                    ELSE LET h = GetFi lrev HD;
                                          rf t = GetFr lrev TL;
                                         rf e0 = RVar lrev;
                                          zero = expr.Int 0;
                                             _ = PutFi d TAG zero;
                                         rf t5 = RVar d;
                                           one = expr.Int 1;
                                             _ = PutFi e0 TAG one;
                                             _ = PutFi e0 HD h;
                                             _ = PutFr e0 TL m;
                                         rf t6 = RVar e0;
                                          rf l = RVar t5;
                                          rf m = RVar t6;
                                       rf lrev = RVar t
                                         IN CALL f
                                         END
                                 END
                            ELSE LET h0 = GetFi l HD;
                                  rf t0 = GetFr l TL;
                                  rf d0 = RVar l;
                                    one = expr.Int 1;
                                      _ = PutFi d0 TAG one;
                                      _ = PutFi d0 HD h0;
                                      _ = PutFr d0 TL lrev;
                                  rf t7 = RVar d0;
                                   rf l = RVar t0;
                                rf lrev = RVar t7
                                 IN CALL f END
                            END"

      and  vardistinct[simp]: "distinct [tag,h,b,one,zero,h0] \<and> distinct [h0,zero,one,b,h,tag] \<and> 
                         distinct[l,m,t,lrev,d,e,e0,t5,t6,t0,d0,t7] \<and> 
                         distinct [t7,d0,t0,t6,t5,e0,e,d,lrev,t,m,l] \<and>
                         distinct [HD,TAG] \<and> distinct [TAG,HD]"

      and spect[simp]: "spectable f == {(E,h,hh,v,p) . 
                                         \<forall> L LREV . ((\<exists> rl rlrev X Z .E\<lfloor>l\<rfloor> = Ref rl \<and> (L,rl,X,h) \<in> LocLength \<and> 
                                                                       E\<lfloor>lrev\<rfloor> = Ref rlrev \<and> (LREV,rlrev,Z,h) \<in> LocLength \<and>
                                                                       X Int Z = {}) \<longrightarrow>
                                                     (p = \<langle>(A * LREV + B * L + C) (D * LREV + EE * L + F) 0 0\<rangle>))}"


text {* 
 The first lemma verifies the specification for this function.
*}

lemma (in Append) "\<rhd> (Call f) : spectable f"
apply (rule vdm_call, simp)
apply (insert vardistinct, clarsimp)
apply (rule vdm_conseq)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_leti) apply (rule vdm_getfi)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_leti) apply (rule vdm_prim)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_if)
prefer 3 apply clarsimp 
apply (case_tac "aa<rl\<bullet>TAG> = 0")
apply clarsimp defer 1 apply clarsimp prefer 3
apply (rule vdm_leti) apply (rule vdm_getfi)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr) apply (rule vdm_getfr)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr) apply (rule vdm_rvar)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_leti) apply (rule vdm_int)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv) apply (rule vdm_putfi)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv) apply (rule vdm_putfi)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv) apply (rule vdm_putfr)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr) apply (rule vdm_rvar)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr) apply (rule vdm_rvar)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr) apply (rule vdm_rvar)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_ax) apply simp
apply clarsimp defer 1
apply (rule vdm_letr) apply (rule vdm_rvar)
prefer 2 apply clarsimp prefer 2 
apply (rule vdm_leti) apply (rule vdm_getfi)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_leti) apply (rule vdm_prim)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_if) 
prefer 3 apply clarsimp apply (case_tac "aa<rlrev\<bullet>TAG> = 0") apply clarsimp
defer 1 apply clarsimp prefer 2
apply (rule vdm_letr) apply (rule vdm_rvar)
prefer 5 apply clarsimp prefer 2 apply (rule vdm_rvar)
apply clarsimp prefer 3
apply (rule vdm_leti) apply (rule vdm_getfi)
prefer 3 apply clarsimp prefer 2
apply (rule vdm_letr) apply (rule vdm_getfr)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr) apply (rule vdm_rvar)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_leti) apply (rule vdm_int)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv) apply (rule vdm_putfi)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr) apply (rule vdm_rvar)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_leti) apply (rule vdm_int)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv) apply (rule vdm_putfi)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv) apply (rule vdm_putfi)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv) apply (rule vdm_putfr)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr) apply (rule vdm_rvar)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr) apply (rule vdm_rvar)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr) apply (rule vdm_rvar)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr) apply (rule vdm_rvar)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_ax) apply simp
apply clarsimp
(*end of VCG*)
prefer 2
apply (erule LocLength.elims, simp_all, clarsimp)
apply (erule LocLength.elims, simp_all, clarsimp)
apply (simp add: C_def F_def)
apply (erule LocLength.elims, simp_all, clarsimp)
apply (erule LocLength.elims, simp_all, clarsimp)
apply (erule_tac x=0 in allE)
apply (erule_tac x=i in allE)
apply (erule impE)
apply (rule_tac x="{la}" in exI, rule)
apply (rule NIL_LocL, simp_all)
apply fast
apply fast
apply (rule_tac x="X - {laa}" in exI, clarsimp, rule)
apply (rule LocLengthSame, assumption) 
apply (simp add: same_def)
apply fast
apply (simp add: A_def D_def) 
(*last side condition*)
apply (erule LocLength.elims, simp_all, clarsimp)
apply (erule_tac x=i in allE)
apply (erule_tac x="Suc LREV" in allE)
apply (erule impE)
apply (rule_tac x="Xa - {la}" in exI, clarsimp, rule)
apply (rule LocLengthSame, assumption) 
apply (simp add: same_def)
apply (rule_tac x="Z \<union> {la}" in exI, rule)
apply (rule CONS_LocL, simp_all)
apply (subgoal_tac "rlrev \<in> Z", fast)
apply (erule LocLength.elims, simp_all)
apply (subgoal_tac "Z - {la} = Z", clarsimp)
prefer 2 apply fast
apply (rule LocLengthSame, assumption)
apply (simp add: same_def)
apply (rule, fast)
apply fast
apply (simp add: A_def B_def D_def EE_def)
done

subsection {* Resource property *}

text {*
 The same Grail code of the append function, with different specification, additionally 
 referring to the resource consumption during the execution.
*}

locale AppendClock = 
  fixes    tag :: iname and h :: iname and b :: iname and one  :: iname and zero :: iname and h0 :: iname
    and    l   :: rname and m :: rname and t :: rname and lrev :: rname and d :: rname and e :: rname
    and    e0  :: rname and t5 :: rname and t6 :: rname and t0 :: rname and d0 :: rname and t7 :: rname
    and	   f   :: funame
    and myContext :: "'a vdmcontext"
 assumes fbdy[simp]: 
         "funtable f == LET tag = GetFi l TAG;
                              b = Primop (% x y. if x = 0 then 1 else 0) tag tag 
                         IN IF b
                            THEN LET rf d = RVar l;
                                      tag = GetFi lrev TAG;
                                        b = Primop (% x y. if x = 0 then 1 else 0) tag tag 
                                 IN IF b 
                                    THEN LET rf e = RVar lrev IN RVar m END
                                    ELSE LET h = GetFi lrev HD;
                                          rf t = GetFr lrev TL;
                                         rf e0 = RVar lrev;
                                          zero = expr.Int 0;
                                             _ = PutFi d TAG zero;
                                         rf t5 = RVar d;
                                           one = expr.Int 1;
                                             _ = PutFi e0 TAG one;
                                             _ = PutFi e0 HD h;
                                             _ = PutFr e0 TL m;
                                         rf t6 = RVar e0;
                                          rf l = RVar t5;
                                          rf m = RVar t6;
                                       rf lrev = RVar t
                                         IN CALL f
                                         END
                                 END
                            ELSE LET h0 = GetFi l HD;
                                  rf t0 = GetFr l TL;
                                  rf d0 = RVar l;
                                    one = expr.Int 1;
                                      _ = PutFi d0 TAG one;
                                      _ = PutFi d0 HD h0;
                                      _ = PutFr d0 TL lrev;
                                  rf t7 = RVar d0;
                                   rf l = RVar t0;
                                rf lrev = RVar t7
                                 IN CALL f END
                            END"

      and  vardistinct[simp]: "distinct [tag,h,b,one,zero,h0] \<and> distinct [h0,zero,one,b,h,tag] \<and> 
                         distinct[l,m,t,lrev,d,e,e0,t5,t6,t0,d0,t7] \<and> 
                         distinct [t7,d0,t0,t6,t5,e0,e,d,lrev,t,m,l] \<and>
                         distinct [HD,TAG] \<and> distinct [TAG,HD]"

      and spect[simp]: "spectable f == {(E,h,hh,v,p) . 
                                         \<forall> L LREV . ((\<exists> rl rlrev X Z .E\<lfloor>l\<rfloor> = Ref rl \<and> (L,rl,X,h) \<in> LocLength \<and> 
                                                                       E\<lfloor>lrev\<rfloor> = Ref rlrev \<and> (LREV,rlrev,Z,h) \<in> LocLength \<and>
                                                                       X Int Z = {}) \<longrightarrow>
                                                     (HSize h = HSize hh \<and> (clock p = A * LREV + B * L + C)))}"

text {*
 This lemma verifies a resource property over the execution, namely that the execution
 requires $55 R + 90 L + 24$ steps, where $R$ and $L$ are the lenght of the 2 lists.
*}

lemma (in AppendClock) "\<rhd> (Call f) : spectable f"
apply (rule vdm_call, simp)
apply (insert vardistinct, clarsimp)
apply (rule vdm_conseq)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_leti) apply (rule vdm_getfi)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_leti) apply (rule vdm_prim)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_if)
prefer 3 apply clarsimp 
apply (case_tac "aa<rl\<bullet>TAG> = 0")
apply clarsimp defer 1 apply clarsimp prefer 3
apply (rule vdm_leti) apply (rule vdm_getfi)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr) apply (rule vdm_getfr)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr) apply (rule vdm_rvar)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_leti) apply (rule vdm_int)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv) apply (rule vdm_putfi)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv) apply (rule vdm_putfi)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv) apply (rule vdm_putfr)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr) apply (rule vdm_rvar)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr) apply (rule vdm_rvar)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr) apply (rule vdm_rvar)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_ax) apply simp
apply clarsimp defer 1
apply (rule vdm_letr) apply (rule vdm_rvar)
prefer 2 apply clarsimp prefer 2 
apply (rule vdm_leti) apply (rule vdm_getfi)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_leti) apply (rule vdm_prim)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_if) 
prefer 3 apply clarsimp apply (case_tac "aa<rlrev\<bullet>TAG> = 0") apply clarsimp
defer 1 apply clarsimp prefer 2
apply (rule vdm_letr) apply (rule vdm_rvar)
prefer 5 apply clarsimp prefer 2 apply (rule vdm_rvar)
apply clarsimp prefer 3
apply (rule vdm_leti) apply (rule vdm_getfi)
prefer 3 apply clarsimp prefer 2
apply (rule vdm_letr) apply (rule vdm_getfr)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr) apply (rule vdm_rvar)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_leti) apply (rule vdm_int)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv) apply (rule vdm_putfi)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr) apply (rule vdm_rvar)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_leti) apply (rule vdm_int)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv) apply (rule vdm_putfi)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv) apply (rule vdm_putfi)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv) apply (rule vdm_putfr)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr) apply (rule vdm_rvar)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr) apply (rule vdm_rvar)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr) apply (rule vdm_rvar)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr) apply (rule vdm_rvar)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_ax) apply simp
apply clarsimp
(*end of VCG*)
prefer 2
apply (erule LocLength.elims, simp_all, clarsimp)
apply (erule LocLength.elims, simp_all, clarsimp)
apply (simp add: C_def)
apply (erule LocLength.elims, simp_all, clarsimp)
apply (erule LocLength.elims, simp_all, clarsimp)
apply (erule_tac x=0 in allE)
apply (erule_tac x=i in allE)
apply (erule impE)
apply (rule_tac x="{la}" in exI, rule)
apply (rule NIL_LocL, simp_all)
apply fast
apply fast
apply (rule_tac x="X - {laa}" in exI, clarsimp, rule)
apply (rule LocLengthSame, assumption) 
apply (simp add: same_def)
apply fast
apply (simp add: A_def)
(*last side condition*)
apply (erule LocLength.elims, simp_all, clarsimp)
apply (erule_tac x=i in allE)
apply (erule_tac x="Suc LREV" in allE)
apply (erule impE)
apply (rule_tac x="Xa - {la}" in exI, clarsimp, rule)
apply (rule LocLengthSame, assumption) 
apply (simp add: same_def)
apply (rule_tac x="Z \<union> {la}" in exI, rule)
apply (rule CONS_LocL, simp_all)
apply (subgoal_tac "rlrev \<in> Z", fast)
apply (erule LocLength.elims, simp_all)
apply (subgoal_tac "Z - {la} = Z", clarsimp)
prefer 2 apply fast
apply (rule LocLengthSame, assumption)
apply (simp add: same_def)
apply (rule, fast)
apply fast
apply (simp add: A_def B_def)
done

(*<*)
end
(*>*)

