(*  
   File:	$RCSfile: ExampleGcdI.thy,v $
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ExampleGcdI.thy,v 1.6 2003/10/01 20:45:49 a1hloidl Exp $

   Example for invoke: gcd as used by AL and Tang
*)

theory ExampleGcdI = VDM + Prelude + Lemmas (* + Adapt *) :

(* --------------------------------------------------------------------------- *)

subsection {* gcd with invoke *}

locale mygcd_example =
  fixes    k      :: iname
  fixes    m      :: iname
  fixes	   n      :: iname
  fixes	   q      :: iname
  fixes	   q'     :: iname
  fixes	   f      :: ifldname
  fixes	   g      :: ifldname
  fixes	   r      :: rname
  fixes    GcdClass :: cname
  fixes	   mygcd      :: mname
  assumes  mygcdbdy[simp]:  
  "methtable GcdClass mygcd = 
   ((LET 
       one = 1\<^sup>z; 
       m = self\<bullet>f ;
       n = self\<bullet>g ;
       q = m :< n
    IN 
      IF q 
         THEN LET
                k = n :- m ;
                _ = (self\<bullet>g := k) 
              IN
                MH_Invoke self mygcd
              END
         ELSE LET
                q' = n :< m
              IN 
                IF q' 
                  THEN LET
                         k = m :- n ;
                         _ = (self\<bullet>f := k) 
                       IN
                         MH_Invoke self mygcd
                       END
                  ELSE m\<^sup>I
               END
    END)::'a expr)"
  assumes  vardistinct:   "distinct [k,m,n,q,q'] \<and> distinct [q',q',n,m,k]"
  assumes  allclasses:    "all_classes = {GcdClass}"

(* from Primes.thy *)
text {*
  See \cite{davenport92}.
  \bigskip
*}

consts
  gcddef  :: "nat \<times> nat => nat"  -- {* Euclid's algorithm *}

recdef gcddef  "measure ((\<lambda>(m, n). n) :: nat \<times> nat => nat)"
  "gcddef (m, n) = (if n = 0 then m else gcddef (n, m mod n))"

constdefs gcdintdef :: "int \<Rightarrow> int \<Rightarrow> int"
"gcdintdef m n == int (gcddef ((nat m),(nat n)))"

lemma (in mygcd_example) "\<rhd> ((MH_Invoke r mygcd) :: 'a expr) :
  {(E,h,hh,v,(p::Semantics.renv)). qach_QaQ E h a r GcdClass \<and> 0 < h<a\<bullet>f> \<and> 0 < h<a\<bullet>g> 
        \<longrightarrow> (v = (IVal (gcdintdef (h<a\<bullet>f>)(h<a\<bullet>g>)))) }"(*\<and> 
            hh<(theloc E\<lfloor>r\<rfloor>)\<bullet>f> = hh<(theloc E\<lfloor>r\<rfloor>)\<bullet>g> \<and> v = hh<(theloc E\<lfloor>r\<rfloor>)\<bullet>f>}"*)
apply (insert vardistinct)
apply (rule vdm_mhinvoke)
apply (rule allI)+ apply (rule impI) apply (erule conjE)+
apply (insert finclasses)
apply (simp add: allclasses qach_QaQ_def)
(* ?????????????????????????????????????????????????????????????? *)
oops
(*
apply (erule_tac x="C" in allE)
apply simp                 (* porghvam yISach! *)
apply (rule vdm_conseq)
apply (rule vdm_basics) defer 1

oops

*)
end
