(*<*)
theory VDMaux = VDM5:
(*>*)

(* Lifted out of VDMderived to remove dependency on that module *)

text {*
 For working with sets of mutually recursive functions/methodsm, we require that their
 specifications are collected in the following table.
*}

consts
  spectable  :: "funame \<Rightarrow> vdmassn"          -- {* specifications of functions *}
  Mspectable :: "cname \<Rightarrow> mname \<Rightarrow> vdmassn"  -- {* specifications of methods *}


subsection {* Basic definitions *}

text {*
 Function computing heap consumption.
*}

constdefs HSize ::"heap \<Rightarrow> int"
"HSize h == int (card (fmap_dom (heap.oheap h)))"
declare HSize_def [simp]

lemma SizeInsert[simp]: "int (card (insert (freshloc (fmap_dom H)) (fmap_dom H))) = int (card (fmap_dom H)) + 1"
(*<*)
apply (subgoal_tac "card (insert (freshloc (fmap_dom H)) (fmap_dom H)) = Suc (card (fmap_dom H))")
apply simp
apply (rule card_insert_disjoint)
apply fastsimp
apply (rule freshloc, fastsimp)
done
(*>*)

subsection {* Syntax for heap access *}

(*Identity of heaps wrt a set of locations -- should be moved to Lemmas.thy or so*)
syntax objhp::"heap \<Rightarrow> oheap"
translations "objhp" == "heap.oheap"
syntax inthp::"heap \<Rightarrow> iheap"
translations "inthp" == "heap.iheap"
syntax refhp::"heap \<Rightarrow> oheap"
translations "refhp" == "heap.rheap"
constdefs same::"locn set \<Rightarrow> heap \<Rightarrow> heap \<Rightarrow> bool"
"same X h hh == \<forall> l. (l \<in> X \<longrightarrow> (fmap_lookup (objhp h) l = fmap_lookup (objhp hh) l \<and> 
                                  (\<forall> ifield . (inthp h ifield l = inthp hh ifield l)) \<and>
                                  (\<forall> rfield . (refhp h rfield l = refhp hh rfield l))))"

(*<*)
end
(*>*)