(* 				 
   File:	$RCSfile: VDMComplete.thy,v $
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: VDMComplete.thy,v 1.18 2003/09/01 19:38:55 lenb Exp $

   Proof of completeness of VDM-style program logic.
*)

header {* Completeness *}


theory VDMComplete = VDMSoundRec + VDMderived:


subsection {* Strongest specification *}

text {* The semantic definition of strongest vdm-specification.
        This correponds to the weakest hoare pre-condition, which 
        is simply the set of states which ensure the post-condition.*}

constdefs
 SSpec    :: "'a expr \<Rightarrow> vdmassn"
 "SSpec e == {(E,h,hh,v,p). E \<turnstile> h,e \<Down> hh,v,p}"

(* declare SSpec_def [simp] *)

lemma SSpec_valid: "\<Turnstile> e: SSpec e"
by (simp add: vdm_valid_def SSpec_def)

lemma SSpec_strong: "\<Turnstile> e : P \<Longrightarrow> (SSpec e) \<subseteq> P"
by (simp add: vdm_valid_def SSpec_def, auto)

lemma VDM_proof_SSpec: "\<rhd> e : P \<Longrightarrow> SSpec e \<subseteq> P"
apply (subgoal_tac "\<Turnstile> e : P")
apply (rule SSpec_strong, simp)
apply (insert vdm_sound) apply fastsimp
done

text {* Here is the overall proof idea (see~\cite{HofmannScript} and~\cite{nipkow02:HoareRec}): 

    \verb+(1)SSpec_lemma -(2)-> completeAux -(3)-> vdm_complete+

    with the following proof ideas in the 3 steps of the proof:

    \begin{enumerate}
     \item induction over expr; use vdm\_ax in Call case 
     \item induction over expr; use vdm\_call and SSpec\_lemma in Call case
     \item  use vdm\_conseq and completeAux
    \end{enumerate}
*}

(* all prg bits are Calls and there is at most one spec for each call in the set
constdefs WF_ctxt :: "'a vdmcontext \<Rightarrow> bool"
 "WF_ctxt G == \<forall> e P. (e,P) \<in> G \<longrightarrow> \<exists> f. e = Call f \<and> 
                        (\<forall> P' . (Call f, P') \<in> G \<longrightarrow>  P=P')"
*)
(*
lemma well_formed_ctxts_are_cool:
  "\<lbrakk> \<forall> f G P P'. (CALL f, P) \<in> G \<and> (CALL funame, P') \<in> G \<longrightarrow> P = P' ;
     (CALL f, Q) \<in> G \<rbrakk>
   \<Longrightarrow>
   insert (Call f, Q') G = G"
sorry
*)

subsection {* Relating function calls to their specifications *}

lemma SSpec_lemma: 
"\<lbrakk>\<forall> f . G \<rhd> ((Call f)::'a expr) : SSpec ((Call f)::'a expr);
  \<forall> C mn . G \<rhd> ((C\<bullet>\<bullet>mn)::'a expr) : SSpec ((C\<bullet>\<bullet>mn)::'a expr);
  \<forall> x mn . G \<rhd> ((x\<diamondsuit>\<diamondsuit>mn)::'a expr) : SSpec ((x\<diamondsuit>\<diamondsuit>mn)::'a expr);
  \<forall> C mn y. G \<rhd> ((C\<bullet>mn(y))::'a expr) : SSpec ((C\<bullet>mn(y))::'a expr);
  \<forall> x mn y. G \<rhd> ((x\<diamondsuit>mn(y))::'a expr) : SSpec ((x\<diamondsuit>mn(y))::'a expr)\<rbrakk>
 \<Longrightarrow> G \<rhd> (e::'a expr) : (SSpec (e::'a expr))"
apply (simp add: SSpec_def sem_def)
apply (induct e)
apply (simp_all) (*  NB: Call case disappeared already! *)
(* Int *)
apply (rule vdm_conseq, rule vdm_int, clarsimp)
apply (rule_tac x=1 in exI, rule semInt)
(*IVar*)
apply (rule vdm_conseq, rule vdm_ivar, clarsimp)
apply (rule_tac x=1 in exI, rule semIVar)
(*Primop*)
apply (rule vdm_conseq, rule vdm_prim, clarsimp)
apply (rule_tac x=1 in exI, rule semPrimop)
(*Null*)
apply (rule vdm_conseq, rule vdm_null, clarsimp)
apply (rule_tac x=1 in exI, rule semNull)
(*RVar*)
apply (rule vdm_conseq, rule vdm_rvar, clarsimp)
apply (rule_tac x=1 in exI, rule semRVar)
(*RPrimop*)
apply (rule vdm_conseq, rule vdm_rprim, clarsimp)
apply (rule_tac x=1 in exI, rule semRPrimop)
(*New*)
apply (rule vdm_conseq, rule vdm_new, clarsimp)
apply (rule_tac x=1 in exI, rule semNew, simp)
(*Getfi*)
apply (rule vdm_conseq, rule vdm_getfi, clarsimp)
apply (rule_tac x=1 in exI, rule semGetfi, simp)
(*Getfr*)
apply (rule vdm_conseq, rule vdm_getfr, clarsimp)
apply (rule_tac x=1 in exI, rule semGetfr, simp)
(*Putfi*)
apply (rule vdm_conseq, rule vdm_putfi, clarsimp)
apply (rule_tac x=1 in exI, rule semPutfi, simp)
(*Putfr*)
apply (rule vdm_conseq, rule vdm_putfr, clarsimp)
apply (rule_tac x=1 in exI, rule semPutfr, simp)
(*Leti*)
apply (rule vdm_conseq, rule vdm_leti, fast, fast, clarsimp)
apply (rule_tac x="(max n na) + 1" in exI, insert semLeti, fastsimp)
(* Letr*)
apply (rotate_tac -1)
apply (erule thin_rl)
apply (rule vdm_conseq, rule vdm_letr, fast, fast, clarsimp)
apply (rule_tac x="(max n na) + 1" in exI, insert semLetr, fastsimp)
(* Letv*)
apply (rotate_tac -2)
apply (erule thin_rl)
apply (erule thin_rl)
apply (rule vdm_conseq, rule vdm_letv, fast, fast, clarsimp)
apply (rule_tac x="(max n na)" in exI, insert semLetv, fastsimp)
(*If*)
apply (rotate_tac -3)
apply (erule thin_rl)
apply (erule thin_rl)
apply (erule thin_rl)
apply (rule vdm_conseq, rule vdm_if, fast, fast, clarsimp)
apply (case_tac "a<iname>=1", clarsimp)
apply (rule_tac x="n+1" in exI, insert semIf_True, fastsimp)
apply (subgoal_tac "a<iname>=0", clarsimp)
apply (rule_tac x="n+1" in exI, insert semIf_False, fastsimp)
apply clarsimp (* E<x> is either true or false*)
done

subsection {* Contexts containing exactly the specifications *}

text {*
 We now build the context to be used in the completeness proof. It has to 
 contain exactly the strongest specifications.
*}

(* arbitrary instantiation needed - maybe we should remove polymorhism from expressions after all!!!*)
constdefs strongContext:: "heap vdmcontext"
"strongContext == {(e,P) . \<exists> f. (e = (Call f) \<and> P = SSpec e)} \<union> 
                  {(e,P) . \<exists> C mn. (e = (C\<bullet>\<bullet>mn) \<and> P = SSpec e)} \<union> 
                  {(e,P) . \<exists> x mn. (e = (x\<diamondsuit>\<diamondsuit>mn) \<and> P = SSpec e)} \<union>
                  {(e,P) . \<exists> C mn y. (e = (C\<bullet>mn(y)) \<and> P = SSpec e)} \<union> 
                  {(e,P) . \<exists> x mn y. (e = (x\<diamondsuit>mn(y)) \<and> P = SSpec e)}"

constdefs strongSpec::"'a vdmcontext \<Rightarrow> bool"
"strongSpec G == (\<forall> e P . (e,P): G \<longrightarrow> 
                  ((\<forall> f. e = Call f \<longrightarrow> spectable f = SSpec e) \<and> 
                   (\<forall> C mn. e = C\<bullet>\<bullet>mn \<longrightarrow> Mspectable C mn = SSpec e) \<and> 
                   (\<forall> x mn. e = x\<diamondsuit>\<diamondsuit>mn \<longrightarrow> ((\<exists> E h a C . qach_QaQ E h a x C \<and>  Mspectable C mn = SSpec e))) \<and> 
                   (\<forall> C mn y. e = C\<bullet>mn(y) \<longrightarrow> Mspectable C mn = SSpec e) \<and> 
                   (\<forall> x mn y. e = x\<diamondsuit>mn(y) \<longrightarrow> (\<exists> E h a C . qach_QaQ E h a x C \<and> Mspectable C mn = SSpec e))))"

text {* Some auxiliary lemmas (lengthy proofs hidden). *}

lemma L1:
"strongSpec strongContext \<Longrightarrow> 
 strongContext \<rhd>  ((funtable f)::heap expr) : {(E, h, hh, v, p). (E, h, hh, v, tkcall p) \<in> SSpec ((CALL f)::heap expr)}"

apply (subgoal_tac "strongContext \<rhd> ((funtable f)::heap expr) : SSpec ((funtable f):: heap expr)")
apply (subgoal_tac "SSpec ((funtable f)::heap expr) = {(E, h, hh, v, p). (E, h, hh, v, tkcall p) \<in> SSpec ((CALL f)::heap expr)}")
apply simp
(*proof of the set equality*)
  apply (simp add: SSpec_def sem_def, rule)
  (*inclusion \<subseteq> *)
  apply (clarsimp, rule_tac x="n + 1" in exI, insert semCall, fastsimp)
  (*inclusion \<supseteq> *)
  apply (clarsimp, erule semn.elims, simp_all, clarsimp, rule_tac x="na" in exI, subgoal_tac "b=p", simp, fastsimp)
(*proof of strongContext \<rhd>  funtable f : SSpec (funtable f)*)
apply (rule SSpec_lemma)
apply (clarsimp, rule vdm_ax)
apply (simp add: strongSpec_def strongContext_def)
apply (clarsimp, rule vdm_ax)
apply (simp add: strongSpec_def strongContext_def)
apply (clarsimp, rule vdm_ax)
apply (simp add: strongSpec_def strongContext_def)
apply (clarsimp, rule vdm_ax)
apply (simp add: strongSpec_def strongContext_def)
apply (clarsimp, rule vdm_ax)
apply (simp add: strongSpec_def strongContext_def)
done


lemma L2:
"strongSpec strongContext \<Longrightarrow> 
strongContext \<rhd>  ((methtable C mn)::heap expr) : {(E, h, hh, v, p). (E, h, hh, v, \<langle>Suc (Suc (renv.clock p)) callc p Suc (invkc p) Suc (invkdpth p)\<rangle>) \<in> SSpec ((C\<bullet>\<bullet>mn)::heap expr)}"

apply (subgoal_tac "strongContext \<rhd> ((methtable C mn)::heap expr) : SSpec ((methtable C mn):: heap expr)")
apply (subgoal_tac "SSpec ((methtable C mn)::heap expr) = {(E, h, hh, v, p). (E, h, hh, v, \<langle>Suc (Suc (renv.clock p)) callc p Suc (invkc p) Suc (invkdpth p)\<rangle>) \<in> SSpec ((C\<bullet>\<bullet>mn)::heap expr)}")
apply simp
(*proof of the set equality*)
  apply (simp add: SSpec_def sem_def, rule)
  (*inclusion \<subseteq> *)
  apply (clarsimp, rule_tac x="n + 1" in exI, insert semMHInvokeStatic, fastsimp)
  (*inclusion \<supseteq> *)
  apply (clarsimp, erule semn.elims, simp_all, clarsimp, rule_tac x="na" in exI, subgoal_tac "b=p", simp, fastsimp)
(*proof of strongContext \<rhd>  methtable C mn : SSpec (methtable C mn) *)
apply (rule SSpec_lemma)
apply (clarsimp, rule vdm_ax)
apply (simp add: strongSpec_def strongContext_def)
apply (clarsimp, rule vdm_ax)
apply (simp add: strongSpec_def strongContext_def)
apply (clarsimp, rule vdm_ax)
apply (simp add: strongSpec_def strongContext_def)
apply (clarsimp, rule vdm_ax)
apply (simp add: strongSpec_def strongContext_def)
apply (clarsimp, rule vdm_ax)
apply (simp add: strongSpec_def strongContext_def)
done


lemma L3: 
"\<lbrakk>strongSpec strongContext ; ((C\<bullet>mn(y))::heap expr, SSpec ((C\<bullet>mn(y))::heap expr)) \<in> strongContext\<rbrakk> \<Longrightarrow>
  strongContext \<rhd>  ((methtable C mn)::heap expr) : 
                    {(E, h, hh, v, p). E = newframe_env Nullref E'\<lfloor>y\<rfloor> \<longrightarrow> 
                                       (E', h, hh, v, \<langle>3 0 1 1 \<rangle> \<oplus> p) \<in> SSpec ((C\<bullet>mn(y))::heap expr)}"

apply (rule vdm_conseq)
apply (subgoal_tac "strongContext \<rhd>  methtable C mn : SSpec(methtable C mn)", assumption)
apply (rule SSpec_lemma) apply clarsimp apply (rule vdm_ax, simp add: strongContext_def)
                         apply clarsimp apply (rule vdm_ax, simp add: strongContext_def)
                         apply clarsimp apply (rule vdm_ax, simp add: strongContext_def)
                         apply clarsimp apply (rule vdm_ax, simp add: strongContext_def)
                         apply clarsimp apply (rule vdm_ax, simp add: strongContext_def)
apply (simp add: SSpec_def sem_def, clarsimp)
apply (rule_tac x="n + 1" in exI)
apply (insert semInvokeStatic)
apply fastsimp
done


lemma L4: 
"\<lbrakk>strongSpec strongContext ; ((x\<diamondsuit>\<diamondsuit>mn)::heap expr, SSpec ((x\<diamondsuit>\<diamondsuit>mn)::heap expr)) \<in> strongContext; qach_QaQ E' h' a x C\<rbrakk>
       \<Longrightarrow> strongContext \<rhd>  ((methtable C mn)::heap expr) : 
                             {(E, h, hh, v, p).
                                  E = E'\<lfloor>self:=Ref a\<rfloor> \<and> h = h' \<longrightarrow>
                                  (E', h', hh, v, \<langle>4 + renv.clock p callc p Suc (invkc p) Suc (invkdpth p)\<rangle>) \<in> SSpec ((x\<diamondsuit>\<diamondsuit>mn)::heap expr)}"

apply (rule vdm_conseq)
apply (subgoal_tac "strongContext \<rhd>  ((methtable C mn)::heap expr) : SSpec((methtable C mn)::heap expr)", assumption)
apply (rule SSpec_lemma) apply clarsimp apply (rule vdm_ax, simp add: strongContext_def)
                         apply clarsimp apply (rule vdm_ax, simp add: strongContext_def)
                         apply clarsimp apply (rule vdm_ax, simp add: strongContext_def)
                         apply clarsimp apply (rule vdm_ax, simp add: strongContext_def)
                         apply clarsimp apply (rule vdm_ax, simp add: strongContext_def)
apply (simp add: SSpec_def sem_def, clarsimp)
apply (rule_tac x="n + 1" in exI, simp add: qach_QaQ_def, clarsimp)
apply (erule thin_rl, erule thin_rl)
apply (insert semMHInvoke)
apply fastsimp
done


lemma L5: 
"\<lbrakk>strongSpec strongContext; ((x\<diamondsuit>mn(y))::heap expr, SSpec ((x\<diamondsuit>mn(y))::heap expr)) \<in> strongContext; qach_QaQ E' h' a x C\<rbrakk>
       \<Longrightarrow> strongContext \<rhd>  ((methtable C mn)::heap expr) :
                            {(E, h, hh, v, p). E = newframe_env E'\<lfloor>x\<rfloor> E'\<lfloor>y\<rfloor> \<and> h = h' \<longrightarrow>
                                               (E', h', hh, v, \<langle>5 + renv.clock p callc p Suc (invkc p) Suc (invkdpth p)\<rangle>) \<in> 
                                               SSpec ((x\<diamondsuit>mn(y))::heap expr)}"

apply (rule vdm_conseq)
apply (subgoal_tac "strongContext \<rhd> ((methtable C mn)::heap expr) : SSpec((methtable C mn)::heap expr)", assumption)
apply (rule SSpec_lemma) apply clarsimp apply (rule vdm_ax, simp add: strongContext_def)
                         apply clarsimp apply (rule vdm_ax, simp add: strongContext_def)
                         apply clarsimp apply (rule vdm_ax, simp add: strongContext_def)
                         apply clarsimp apply (rule vdm_ax, simp add: strongContext_def)
                         apply clarsimp apply (rule vdm_ax, simp add: strongContext_def)
apply (simp add: SSpec_def sem_def, clarsimp)
apply (rule_tac x="Suc n" in exI, simp add: qach_QaQ_def, clarsimp)
apply (erule thin_rl, erule thin_rl)
apply (insert semInvoke)
apply fastsimp
done


lemma StrongspecConsistent: "strongSpec strongContext \<Longrightarrow> consistent strongContext"
apply (simp add: consistent_def)
apply (rule, clarsimp) apply (rule conjI) apply (simp add: strongSpec_def) apply (erule_tac x="(CALL f)::heap expr" in allE, clarsimp)
                                          apply (erule impE, fastsimp) apply(simp add: strongContext_def)
                       apply (subgoal_tac "P = SSpec ((CALL f)::heap expr)", simp)
                       apply (subgoal_tac "strongContext \<rhd>  funtable f : {(E, h, hh, v, p). (E, h, hh, v, \<langle>1 1 0 0\<rangle> \<smile> p) \<in> SSpec (CALL f)}")
                       apply simp
                       apply (fastsimp intro:L1)
                       apply (simp add: strongSpec_def)  apply (erule_tac x="(CALL f)::heap expr" in allE, clarsimp)
                       apply (erule impE, fastsimp) apply(simp add: strongContext_def)
apply (rule, clarsimp) apply (rule conjI) apply (simp add: strongSpec_def) apply (erule_tac x="(C\<bullet>\<bullet>mn)::heap expr" in allE, clarsimp)
                                          apply (erule impE, fastsimp) apply(simp add: strongContext_def)
                       apply (subgoal_tac "P = SSpec ((C\<bullet>\<bullet>mn)::heap expr)", simp)
                       apply (fastsimp intro: L2)
                       apply (simp add: strongSpec_def)  apply (erule_tac x="(C\<bullet>\<bullet>mn)::heap expr" in allE, clarsimp)
                       apply (erule impE, fastsimp) apply(simp add: strongContext_def)
apply (rule, clarsimp) apply (rule conjI) apply (simp add: strongSpec_def) apply (erule_tac x="(x\<diamondsuit>\<diamondsuit>mn)::heap expr" in allE, clarsimp)
                                          apply (erule impE, fastsimp) apply(simp add: strongContext_def) apply fast
                       apply clarsimp
                       apply (subgoal_tac "P = SSpec ((x\<diamondsuit>\<diamondsuit>mn)::heap expr)", simp)
                       prefer 2 apply (simp add: strongContext_def)
                       apply clarsimp
                       apply (fastsimp intro: L4)
apply (rule, clarsimp) apply (rule conjI) apply (simp add: strongSpec_def) apply (erule_tac x="(C\<bullet>mn(y))::heap expr" in allE, clarsimp)
                                          apply (erule impE, fastsimp) apply (simp add: strongContext_def)
                       apply (subgoal_tac "P = SSpec ((C\<bullet>mn(y))::heap expr)", simp) 
                       prefer 2 apply (simp add: strongContext_def) 
                       apply clarsimp
                       apply (insert L3, fastsimp)
apply (rotate_tac -1, erule thin_rl)
apply clarsimp apply (rule conjI) apply (simp add: strongSpec_def) apply (erule_tac x="(x\<diamondsuit>mn(y))::heap expr" in allE, clarsimp)
                                          apply (erule impE, fastsimp) apply (simp add: strongContext_def) apply fast
                       apply clarsimp
                       apply (subgoal_tac "P = SSpec (x\<diamondsuit>mn(y)::heap expr)", simp) 
                       prefer 2 apply (simp add: strongContext_def) 
                       apply clarsimp
                       apply (insert L5, fastsimp)
done

subsection {* Proof of completeness *}
text {*
 We can now prove our main completeness theorem.*}

declare contextProvable_def[simp]

lemma completeAux: "\<lbrakk>consistent strongContext; finite strongContext\<rbrakk> \<Longrightarrow> {} \<rhd> (e::heap expr): SSpec e"
apply (rule cut2)
apply (assumption)
defer 1
apply clarsimp
apply (simp add: callInvokeContext_def strongContext_def)
apply clarsimp
apply (subgoal_tac "\<rhd> e : SSpec ((e)::heap expr)")
apply (rule MUTREC)
apply assumption
apply (simp add: strongContext_def)
apply (simp add: strongContext_def)
apply assumption
apply (simp add: consistent_def strongContext_def)
apply (rule MUTREC)
apply assumption
apply (simp add: strongContext_def)
apply (simp add: strongContext_def)
apply assumption
apply (simp add: strongContext_def)
apply clarsimp
apply (rule SSpec_lemma)
apply (clarsimp, rule vdm_ax, simp add: strongContext_def)+
done

text {*
 Finally, the top level \textbf{completeness theorem} follows immediately from the theorem above.
*}

theorem vdm_complete: "\<lbrakk>strongSpec strongContext; finite strongContext\<rbrakk> \<Longrightarrow> \<Turnstile> (e::heap expr) : P \<Longrightarrow> \<rhd> e : P"
apply (subgoal_tac "consistent strongContext")
prefer 2 apply (erule StrongspecConsistent)
apply (rule vdm_conseq)
apply (rule completeAux)
apply assumption
apply assumption
apply (erule SSpec_strong)
done
end

