(* Modelling of a class hierarchy in ToyGrail.
   see TypeRel in NanoJava 
*)

theory TypeRel06 = Expr06 + Finite_Set:

(* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ *)
(* dummy definition, just for printing the suggested logic with subclassing    *)
(*
--{* Methods of a class, with inheritance and hiding *}
constdefs getMethod :: "cname => (mname ~=> expr)"
  "getMethod C \<equiv> empty"
*)
text {* Definition of @{text getMethod} should be @{text "class_rec C methtable'"},
with @{text "class_rec C f"} traversing the class hierarchy collecting at each node the
things extracted by f as a partial map. 
*}

(*
The important property is

lemma getMethod_rec: "\<lbrakk>class C = Some (); ws_prog\<rbrakk> \<Longrightarrow>
getMethod C = (if C=Object then empty else getMethod (superClass C)) ++ map_of (methtable' C)"
*)
(* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ *)

(* needed in Expr already ? *)

(* only list of classes needed; no explicit class-record, individual tables instead *)
types   prog      = "(cname \<times> unit) list"
        mdecls = "(mname \<times> expr) list"

consts
  funtable'      :: "funame => expr"           -- {* global function names *}
  ifieldtable'   :: "cname => ifldname list"      -- {* int fields by class *}
  rfieldtable'   :: "cname => rfldname list"      -- {* ref fields by class *}
  methtable'     :: "cname => mdecls"    -- {* methods by class *}

(* immediate subclasses; old code *)
(*
consts 
  subClasses :: "cname \<Rightarrow> cname set"

consts is_subclass_of' :: "nat \<Rightarrow> cname \<Rightarrow> cname \<Rightarrow> bool"
primrec 
 "is_subclass_of' (0::nat) C C' = False"
 "is_subclass_of' (Suc n)  C C' = (if C=C' then True else 
                                   \<exists> C''. C'' \<in> subClasses C' \<and> is_subclass_of' n C C'')"

constdefs is_subclass_of :: "cname \<Rightarrow> cname \<Rightarrow> bool"  ("_ \<lhd> _")
 "is_subclass_of C C' \<equiv> is_subclass_of' 99 C C'"
*)

consts
  Prog    :: prog       --{* program as a global value *}
  Object  :: cname      --{* name of root class *}

constdefs
  class      :: "cname \<leadsto> unit"
 "class      \<equiv> map_of Prog"

  is_class   :: "cname => bool"
 "is_class C \<equiv> class C \<noteq> None" (* C \<in> set Prog *)

(* ToDo: use finite set and nuke partial map to express this lemma *)
lemma finite_is_class: "finite {C. is_class C}"
apply (unfold is_class_def class_def)
apply (fold dom_def) 
apply (rule finite_dom_map_of)
done

(* this is program-specific and models the class hierarchy for that program *)
(* superClass as partial map is needed for subcls1_def2 but awkward otw *)
consts
  superClass         :: "cname \<Rightarrow> cname"

(* for all classes in the program we can identify a super class *)
(*
axioms
  axobonzo: "dom superClass \<subseteq> dom (map_of Prog)"
*)

consts
  subcls1 :: "(cname * cname) set"  --{* subclass *}

syntax (xsymbols)
  subcls1 :: "[cname, cname] => bool" ("_ \<prec>1 _"  [71,71] 70)
  subcls  :: "[cname, cname] => bool" ("_ \<preceq> _"   [71,71] 70)
syntax
  subcls1 :: "[cname, cname] => bool" ("_ <=1 _" [71,71] 70)
  subcls  :: "[cname, cname] => bool" ("_ <= _"  [71,71] 70)

translations
  "C \<prec>1 D" == "(C,D) \<in> subcls1"
  "C \<preceq>  D" == "(C,D) \<in> subcls1^*"

(*
consts
  method :: "cname => (mname \<leadsto> methd)"
  field  :: "cname => (fname \<leadsto> ty)"
*)

subsection "Declarations and properties not used in the meta theory"

text {* Immediate subclass relation *}
defs
 subcls1_def: "subcls1 \<equiv> {(C,D). C \<noteq> Object \<and> superClass C = D}"

lemma subcls1D: 
  "C \<prec>1 D \<Longrightarrow> C \<noteq> Object \<and> superClass C = D"
apply (unfold subcls1_def)
apply auto
done

lemma subcls1I: "\<lbrakk>superClass C = D; C \<noteq> Object\<rbrakk> \<Longrightarrow> C \<prec>1 D"
apply (unfold subcls1_def)
apply auto
done

(* --------------------------------------------------------------------------- *)
(*
lemma bonzo2: "[| C \<in> dom superClass |] ==> C \<in> dom (map_of Prog)"
apply (insert axobonzo)
apply (rule subsetD)
apply auto
done

lemma bonzo3: "\<forall> C.  C \<in> dom superClass --> C \<in> dom (map_of Prog)"
apply (insert axobonzo)
apply (rule allI)
apply (rule impI)
apply (rule subsetD)
apply auto
done
*)
lemma subcls1_def2: 
"subcls1 = (\<Sigma>C\<in>{C. is_class C} . {D. C\<noteq>Object \<and> superClass C = D})"
apply (unfold subcls1_def is_class_def)
apply auto
sorry
(* proof for Version with superClass as partial mapping 
apply (unfold subcls1_def is_class_def)
apply (insert bonzo3)
apply auto
apply (erule_tac x="a" in allE)
 apply (unfold class_def)
 apply auto 
done
*)
lemma finite_subcls1: "finite subcls1"
apply(subst subcls1_def2)
apply(rule finite_SigmaI [OF finite_is_class])
(* apply(rule_tac B = "{superClass C}" in finite_subset) *)
apply  auto
sorry

constdefs
  ws_prog  :: "bool"
 "ws_prog \<equiv> \<forall> (C,z) \<in> set Prog. C\<noteq>Object \<longrightarrow> 
                            is_class (superClass C) \<and> (superClass C,C)\<notin>subcls1^+"

lemma ws_progD: "\<And> C .\<lbrakk>class C = Some (); C\<noteq>Object; ws_prog\<rbrakk> \<Longrightarrow>  
  is_class (superClass C) \<and> (superClass C,C)\<notin>subcls1^+"
apply (unfold ws_prog_def is_class_def class_def)
apply (drule_tac map_of_SomeD)
apply auto
done

lemma subcls1_irrefl_lemma1: "ws_prog \<Longrightarrow> subcls1^-1 \<inter> subcls1^+ = {}"
sorry
(* apply (fast dest: subcls1D ws_progD) *)

(* context (theory "Transitive_Closure") *)
lemma irrefl_tranclI': "r^-1 Int r^+ = {} ==> !x. (x, x) ~: r^+"
sorry
(* NB: NanoJava version fails on this one too *)
(*
apply (rule allI)
apply (erule irrefl_tranclI)
done
*)

lemmas subcls1_irrefl_lemma2 = subcls1_irrefl_lemma1 [THEN irrefl_tranclI']

lemma subcls1_irrefl: "\<lbrakk>(x, y) \<in> subcls1; ws_prog\<rbrakk> \<Longrightarrow> x \<noteq> y"
apply (rule irrefl_trancl_rD)
apply (rule subcls1_irrefl_lemma2)
apply auto
done

lemmas subcls1_acyclic = subcls1_irrefl_lemma2 [THEN acyclicI, standard]

(* needed for recdef below *)
lemma wf_subcls1: "ws_prog \<Longrightarrow> wf (subcls1^-1)"
apply (auto intro: finite_acyclic_wf_converse finite_subcls1 subcls1_acyclic)
done

(* ToDo: fix rest *)

(* main function for collecting methods/fields in scope from given class hierarchy *)
(*
consts myclass_rec' ::"nat \<Rightarrow> cname \<Rightarrow> (cname \<Rightarrow> ('a * 'b) list) \<Rightarrow> ('a \<leadsto> 'b)"
primrec 
 "myclass_rec' (0::nat) C f = empty"
 "myclass_rec' (Suc n)  C f = (if (~ (is_class C)) then empty
                               else if C = Object then empty 
                               else (myclass_rec' n (superClass C) f) ++ map_of (f C))"

constdefs myclass_rec ::"cname \<Rightarrow> (cname \<Rightarrow> ('a * 'b) list) \<Rightarrow> ('a \<leadsto> 'b)"
 "myclass_rec C f \<equiv> myclass_rec' 99 C f"

lemma myclass_rec: "\<lbrakk>class C = Some ();  ws_prog\<rbrakk> \<Longrightarrow>
 myclass_rec C f = (if C = Object then empty else myclass_rec (superClass C) f) ++ 
                 map_of (f C)";
apply (unfold ws_prog_def myclass_rec_def)
apply auto
apply (unfold myclass_rec'_def)
apply auto
apply (drule wf_subcls1)
apply (rule class_rec.simps [THEN trans [THEN fun_cong]])
apply  assumption
apply simp
done
*)

consts class_rec ::"cname \<Rightarrow> (cname \<Rightarrow> ('a * 'b) list) \<Rightarrow> ('a \<leadsto> 'b)"

recdef (permissive) class_rec "subcls1^-1"
      "class_rec C = (\<lambda>f. if wf (subcls1^-1)
       then (if C=Object then empty else class_rec (superClass C) f) ++ map_of (f C)
       else arbitrary)"
(hints intro: subcls1I recdef_wf: wf_subcls1)

lemma class_rec: "\<lbrakk>class C = Some ();  ws_prog\<rbrakk> \<Longrightarrow>
 class_rec C f = (if C = Object then empty else class_rec (superClass C) f) ++ 
                 map_of (f C)";
apply (drule wf_subcls1)
apply (rule class_rec.simps [THEN trans [THEN fun_cong]])
apply  assumption
apply simp
done

--{* Methods of a class, with inheritance and hiding *}
constdefs getMethod :: "cname => (mname ~=> expr)"
  "getMethod C \<equiv> class_rec C methtable'"

lemma getMethod_rec: "\<lbrakk>class C = Some (); ws_prog\<rbrakk> \<Longrightarrow>
getMethod C = (if C=Object then empty else getMethod (superClass C)) ++ map_of (methtable' C)"
apply (unfold getMethod_def)
apply (erule (1) class_rec [THEN trans]);
apply simp
done


(*
--{* Fields of a class, with inheritance and hiding *}
defs field_def: "field C \<equiv> class_rec C flds"

lemma flds_rec: "\<lbrakk>class C = Some m; ws_prog\<rbrakk> \<Longrightarrow>
field C = (if C=Object then empty else field (superClass m)) ++ map_of (flds m)"
apply (unfold field_def)
apply (erule (1) class_rec [THEN trans]);
apply simp
done
*)

subsection {* Class hierarchy  (old version) *}

(* all subclasses, not just the immediate ones 
consts dynClasses :: "cname \<Rightarrow> cname set"


constdefs qach_QaQ_dyn :: "env \<Rightarrow> heap \<Rightarrow> locn \<Rightarrow> rname \<Rightarrow> cname \<Rightarrow> bool"
 "qach_QaQ_dyn E h a x C == (E\<lfloor>x\<rfloor> = Ref a \<and> (\<exists> C' . (fmap_lookup (heap.oheap h) a = Some C' \<and> C \<in> dynClasses C')))" 

consts lookupMethod' :: "nat \<Rightarrow> cname \<Rightarrow> mname \<Rightarrow> cname option"
primrec 
 "lookupMethod' (0::nat) cn mn = ???"
 "lookupMethod' (Suc n) cn mn = if cn=Object
                                  then None
                                  else if methtable cn mn = Some f
                                         then Some f
                                         else lookupMethod' n (superClass cn) mn"
*)

end
