(*  
   File:	$RCSfile: ExampleSwapI.thy,v $
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ExampleSwapI.thy,v 1.2 2003/08/08 23:46:48 a1hloidl Exp $

   Non-recursive function (VDM style) w/ Invokes
*)

theory ExampleSwapI = VDM + Prelude + Lemmas:

section {* swap two fields *}

(* taken from ExampleSwapFields *)

subsection {* Version w/ MH_InvokeStatic *}

locale swap_example =
  fixes    m  :: iname
  fixes	   n  :: iname
  fixes	   q  :: iname
  fixes	   x    :: ifldname
  fixes	   y    :: ifldname
  fixes	   swap      :: mname
  fixes    SwapClass :: cname
  fixes    f  :: rname
  assumes swapbody[simp]: 
  "methtable SwapClass swap =  
     ((LET 
      m  = self\<bullet>x ;
      n  = self\<bullet>y ;
      q  = n :< m
     IN
      IF q 
        THEN LET
               _ = self\<bullet>x := n ; 
               _ = self\<bullet>y := m 
      IN
         1\<^sup>z
      END 
         ELSE 0\<^sup>z
     END) :: 'a expr)"
  assumes  allclasses: "all_classes = {SwapClass}"
  assumes  vardistinct: "distinct [m,n,q]"
  assumes  flddistinct: "distinct [x,y]"


(* old Hoare-style lemms
lemma (in swap_example) 
   "\<Turnstile> {((a,M,N),s). s\<lfloor>self\<rfloor> = Ref a \<and> s<a\<bullet>lesser> = M \<and> s<a\<bullet>greater> = N}
	CALL swap
      {((a,M,N),s,v). s<a\<bullet>lesser> = min M N}"
*)

lemma (in swap_example) 
   "\<rhd> ((MH_InvokeStatic SwapClass swap) :: 'a expr) :
    {(E,h,hh,v,p). \<exists> a . (E\<lfloor>self\<rfloor> = Ref a \<longrightarrow> hh<a\<cdot>x> = min (h<a\<cdot>x>) (h<a\<cdot>y>) \<and> hh<a\<cdot>y> = max (h<a\<cdot>x>) (h<a\<cdot>y>))}"
apply (rule vdm_mhinvokestatic)
apply (simp)
apply (rule vdm_conseq)
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) 
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) 
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) 
apply (rule vdm_basics) 
apply (rule vdm_basics) 
apply (rule vdm_basics)
apply (rule vdm_basics)
apply clarsimp
apply (rename_tac E hi hpost v a p)
apply (rule_tac x="a" in exI)
apply clarsimp
apply (case_tac "hi<a\<cdot>y> < E<m:=hi<a\<cdot>x>><n:=hi<a\<cdot>y>><m>") (* do the swap *)
 apply (insert vardistinct)
 apply clarsimp
 apply (rule conjI)
 apply arith
 apply arith
 (* .. *)
 apply (rule conjI)
 apply (simp, arith)+
done

subsection {* Version w/ Invoke *}

lemma (in swap_example) 
   "\<rhd> ((MH_Invoke f swap) :: 'a expr) :
    {(E,h,hh,v,p). \<exists> a . (E\<lfloor>f\<rfloor> = Ref a \<and> fmap_lookup (oheap h) a = Some SwapClass \<longrightarrow> hh<a\<cdot>x> = min (h<a\<cdot>x>) (h<a\<cdot>y>) \<and> hh<a\<cdot>y> = max (h<a\<cdot>x>) (h<a\<cdot>y>))}"
apply (rule vdm_mhinvoke)
apply (simp add: qach_QaQ_def)
apply (rule allI)+
apply (rule impI)
apply (case_tac "C=SwapClass")
 apply (simp add: swapbody)
 apply clarsimp
 apply (rule vdm_conseq)
 apply (rule vdm_basics) defer 1
 apply (rule vdm_basics) defer 1
 apply (rule vdm_basics) defer 1
 apply (rule vdm_basics) 
 apply (rule vdm_basics) defer 1
 apply (rule vdm_basics) defer 1
 apply (rule vdm_basics)
 apply (rule vdm_basics) 
 defer 1 
 defer 1 (* other case *)
 apply (rule vdm_basics) 
 apply (rule vdm_basics) 
 apply (rule vdm_basics) 
 apply (rule vdm_basics) 
 apply (rule vdm_basics)
 apply clarsimp
 apply (case_tac "h'<af\<cdot>y> < E'\<lfloor>self:=Ref af\<rfloor><m:=h'<af\<cdot>x>><n:=h'<af\<cdot>y>><m>")
   apply clarsimp
   apply (insert vardistinct)
   apply clarsimp
   apply (rule_tac x="af" in exI)
   apply (simp, arith)+
   (* .. *)
   apply (rule_tac x="af" in exI)
   apply (simp, arith)+
 (* case C \<noteq> SwapClass remains ... *)
oops

(* version with finclasses variant; same lemma,; uses all_classes and different rule  *)
lemma (in swap_example) 
   "\<rhd> ((MH_Invoke f swap) :: 'a expr) :
    {(E,h,hh,v,p). \<exists> a . (E\<lfloor>f\<rfloor> = Ref a \<and> fmap_lookup (oheap h) a = Some SwapClass \<longrightarrow> hh<a\<cdot>x> = min (h<a\<cdot>x>) (h<a\<cdot>y>) \<and> hh<a\<cdot>y> = max (h<a\<cdot>x>) (h<a\<cdot>y>))}"
apply (rule vdm_mhinvoke_finclass)
apply (simp add: qach_QaQ_def allclasses)
apply (rule allI)+
apply (rule impI)
apply (erule_tac conjE)
apply (erule_tac x="C" in allE)
(* apply (case_tac "C=SwapClass") *)
 apply (simp add: swapbody)
 apply clarsimp
 apply (rule vdm_conseq)
 apply (rule vdm_basics) defer 1
 apply (rule vdm_basics) defer 1
 apply (rule vdm_basics) defer 1
 apply (rule vdm_basics) 
 apply (rule vdm_basics) defer 1
 apply (rule vdm_basics) defer 1
 apply (rule vdm_basics)
 apply (rule vdm_basics) 
 defer 1 
 apply (rule vdm_basics) 
 apply (rule vdm_basics) 
 apply (rule vdm_basics) 
 apply (rule vdm_basics) 
 apply (rule vdm_basics)
 apply clarsimp
 apply (case_tac "h'<af\<cdot>y> < E'\<lfloor>self:=Ref af\<rfloor><m:=h'<af\<cdot>x>><n:=h'<af\<cdot>y>><m>")
   apply clarsimp
   apply (insert vardistinct)
   apply clarsimp
   apply (rule_tac x="af" in exI)
   apply (simp, arith)+
   (* .. *)
   apply (rule_tac x="af" in exI)
   apply (simp, arith)+
done


end
