(* $Id: ExampleListUpsilon.thy,v 1.1 2003/10/14 08:43:16 a1oshkar Exp $ *)

header {* Martin's Upsilon relation for Lists according their presentation in ExampleListClass *}

(*<*)
theory ExampleListUpsilon = ExampleListClass:
(*>*)

subsection {* Basic definitions *}

text {*
 Function computing heap consumption using Martin/Steffens' annotations.
*}

consts LUpsilon::"(nat \<times> nat \<times> nat \<times> ref \<times> (ref set) \<times> heap) set"

text {*
  The following inductive definition can be read as follows:
  $(n, m1, m2, l,X,s) \in \mbox{LUpsilon}$ if $s l$ models a list of 
length $n$ with pointers from $X$, and all tail pointers distinct,
NIL constructor is annotated with m1,
CONS constructor is annotated with m2
*}

inductive LUpsilon intros

  NIL_U:  "\<lbrakk>fmap_lookup(objhp hp) l = Some LST; 
	     inthp hp TAG l = 0;
             Ref l \<in> X\<rbrakk> 
           \<Longrightarrow> (m1, m1, m2, Ref l, X, hp) \<in> LUpsilon"

  CONS_U: "\<lbrakk>fmap_lookup(objhp hp) l = Some LST;
	     inthp hp TAG l = 1;
	     inthp hp HD l = h; 
	     refhp hp TL l = tt; 
             Ref l \<in> X;
             tt \<in> X - {Ref l};  
             (i,m1, m2, tt, X - {Ref l} , hp) \<in> LUpsilon\<rbrakk>
           \<Longrightarrow> ( m2 + i, m1, m2 , Ref l, X, hp) \<in> LUpsilon"

lemma LUpsTAG[simp]:
  "\<forall> m1 m2 r X h l tag.
   ((N, m1, m2, r, X, h) \<in> LUpsilon \<and> Ref l \<notin> X \<longrightarrow> 
    (N, m1, m2, r, X, h<l\<bullet>TAG := tag>) \<in> LUpsilon)"
(*<*)
apply clarsimp
apply (induct N)
apply (erule LUpsilon.elims)
apply clarsimp
oops
(*>*)

lemma LUpsTL[simp]:
  "\<forall> m1 m2 r X h l t.
   ((N, m1, m2, r, X, h) \<in> LUpsilon \<and> Ref l \<notin> X \<longrightarrow> 
   (N, m1, m2, r, X, h\<lfloor>l\<diamondsuit>TL := t\<rfloor>) \<in> LUpsilon)"
(*<*)
apply clarsimp
apply (induct N)
apply (erule LUpsilon.elims)
apply clarsimp
apply (rule NIL_U, fastsimp+)
apply (erule LUpsilon.elims)
apply clarsimp
apply clarsimp
apply (subgoal_tac "l \<noteq> la")
by (rule CONS_U, fastsimp+)
(*>*)

text {*
  Version with locations instead of references.
*}

consts LocUpsilon::"(nat \<times> nat \<times> nat \<times> locn \<times> (locn set) \<times> heap) set"
inductive LocUpsilon intros

  NIL_LocU:  "\<lbrakk>fmap_lookup(oheap hp) l = Some LST; 
	       inthp hp TAG l = 0;
               X \<subseteq> fmap_dom (oheap hp);
               l \<in> X\<rbrakk> 
             \<Longrightarrow> (m1, m1, m2, l, X, hp) \<in> LocUpsilon"

  CONS_LocU: "\<lbrakk>fmap_lookup(objhp hp) l = Some LST;
	       inthp hp TAG l = 1;
	       inthp hp HD l = h; 
	       refhp hp TL l = Ref tt; 
               l \<in> X;
               tt \<in> X - {l};  
              (i,m1, m2, tt, X - {l} , hp) \<in> LocUpsilon\<rbrakk>
             \<Longrightarrow> ( m2 + i , m1, m2, l, X, hp) \<in> LocUpsilon"

lemma LocUpsDomAux:
"\<forall> m1 m2 l X h . 
((L, m1, m2, l, X, h) \<in> LocUpsilon \<longrightarrow>  X \<subseteq> fmap_dom (oheap h))"
(*<*)
apply (induct L)
apply clarsimp
apply (erule LocUpsilon.elims, simp_all, clarsimp)
apply (simp add: fmap_lookup_def fmap_dom_def dom_def, fast)
apply clarsimp
apply (erule LocUpsilon.elims, simp_all, clarsimp)
apply (simp add: fmap_lookup_def fmap_dom_def dom_def, fast)
done
(*>*)

lemma LocUpsilonDom: 
"\<lbrakk>(L, m1, m2, l, X, h) \<in> LocUpsilon\<rbrakk> 
\<Longrightarrow>  X \<subseteq> fmap_dom (oheap h)"
by (insert LocUpsilonDomAux, fast)

lemma LocUpsTAG[simp]:
  "\<forall> m1 m2 r X h l tag.
   ((N, m1, m2, r, X, h) \<in> LocUpsilon \<and> l \<notin> X \<longrightarrow> 
    (N, m1, m2, r, X, h<l\<bullet>TAG := tag>) \<in> LocUpsilon)"
(*<*)
apply clarsimp
apply (induct N)
apply (erule LocUpsilon.elims)
apply clarsimp
apply (rule NIL_LocU, fastsimp+)
apply (erule LocUpsilon.elims)
apply clarsimp
apply clarsimp
by (rule CONS_LocU, fastsimp+)
(*>*)

lemma LocUHD[simp]:
  "\<forall> m1 m2 r X oh ih rh.
   ((N, m1, m2, r, X, \<lparr>objhp = oh, inthp = ih, refhp = rh\<rparr>) \<in> LocUpsilon \<longrightarrow> 
    (N, m1, m2, r, X, \<lparr>objhp = oh, inthp = ih(HD := ih HD), refhp = rh\<rparr>) \<in> LocUpsilon)"
by fastsimp


(*identify over heaps which are identical on the domain of the predicate*)
lemma LocUpsilonSameAux:
"\<forall> m1 m2 l X h hh . (((n,m1, m2, l,X,h) \<in> LocUpsilon \<and> same X h hh) 
\<longrightarrow> (n,m1, m2, l,X,hh) \<in> LocUpsilon)"
(*<*)
apply (induct n)
apply clarsimp
apply (erule LocUpsilon.elims, simp_all, clarsimp)
apply (rule NIL_LocU)
apply (simp_all add: same_def)
apply clarsimp
apply (subgoal_tac "x \<in> fmap_dom (oheap hp)")
prefer 2 apply fast
apply (simp add: fmap_dom_def dom_def, clarsimp)
apply (rule_tac x=y in exI,simp add: fmap_lookup_def)
apply clarsimp
apply (erule LocUpsilon.elims, simp)
apply (erule_tac x=tt in allE)
apply (erule_tac x="Xa - {la}" in allE)
apply (erule_tac x=hp in allE)
apply (erule_tac x=hh in allE)
apply (rule CONS_LocU, simp_all)
done
(*>*)

lemma LocUpsilonSame:
"\<lbrakk>(n, m1, m2, l,X,h) \<in> LocUpsilon; 
same X h hh\<rbrakk> \<Longrightarrow> (n,m1, m2, l,X,hh) \<in> LocUpsilon"
by (insert LocUpsilonSameAux, fast)

text {*
 Version with locations instead of references, and precise domain.
*}

consts DomUpsilon::"(nat \<times> locn \<times> (locn set) \<times> heap) set"
inductive DomUpsilon intros

  NIL_DomU:  "\<lbrakk>fmap_lookup(objhp hp) l = Some LST; 
	       inthp hp TAG l = 0\<rbrakk> 
             \<Longrightarrow> (m1, m1, m2, l, {l}, hp) \<in> DomUpsilon"

  CONS_DomU: "\<lbrakk>fmap_lookup(objhp hp) l = Some LST;
	       inthp hp TAG l = 1;
	       inthp hp HD l = h; 
	       refhp hp TL l = Ref tt; 
               l \<in> X;
               (i,m1, m2, tt, X - {l} , hp) \<in> DomUpsilon\<rbrakk>
             \<Longrightarrow> ( m2 + i , m1, m2, l, X, hp) \<in> DomUpsilon"


lemma DomUpsTAG[simp]:
  "\<forall> m1 m2 r X h l tag.
   ((N, m1, m2, r, X, h) \<in> DomUpsilon \<and> l \<notin> X \<longrightarrow> 
    (N, m1, m2, r, X, h<l\<bullet>TAG := tag>) \<in> DomUpsilon)"
(*<*)
apply clarsimp
apply (induct N)
apply (erule DomUpsilon.elims)
apply clarsimp
apply (rule NIL_DomU, fastsimp+)
apply (erule DomUpsilon.elims)
apply clarsimp
apply clarsimp
by (rule CONS_DomU, fastsimp+)
(*>*)

lemma DomUpsTL[simp]:
  "\<forall> m1 m2 r X h l t.
   ((N, m1, m2, r, X, h) \<in> DomUpsilon \<and> l \<notin> X \<longrightarrow> 
    (N, m1, m2, r, X, h\<lfloor>l\<diamondsuit>TL := t\<rfloor>) \<in> DomUpsilon)"
(*<*)
apply clarsimp
apply (induct N)
apply (erule DomUpsilon.elims)
apply clarsimp
apply (rule NIL_DomU, fastsimp+)
apply (erule DomUpsilon.elims)
apply clarsimp
apply clarsimp
apply (subgoal_tac "l \<noteq> la")
by (rule CONS_DomU, fastsimp+)
(*>*)

lemma DomUpsilonDom[simp]:
  "\<forall> m1 m2 l X hp . ((L,m1, m2, l,X, hp) \<in> DomUpsilon 
    \<longrightarrow> X \<subseteq> fmap_dom (objhp hp))"
(*<*)
apply clarsimp
apply (induct L)
apply(erule DomUpsilon.elims)
apply (simp_all add: fmap_lookup_def fmap_dom_def dom_def)
apply(erule DomUpsilon.elims)
apply (simp_all add: fmap_lookup_def fmap_dom_def dom_def)
by fastsimp
(*>*)

lemma DomUpsHD2[simp]: 
  "\<forall> m1 m2 r X h l H. 
   ((N, m1, m2, r, X, h) \<in> DomUpsilon \<and> l \<notin> X \<longrightarrow> 
    (N, m1, m2, r, X, h<l\<bullet>HD := H>) \<in> DomUpsilon)"
(*<*)
apply clarsimp
apply (induct N)
apply (erule DomUpsilon.elims)
apply clarsimp
apply (rule NIL_DomU, fastsimp+)
apply (erule DomUpsilon.elims)
apply clarsimp
apply clarsimp
by (rule CONS_DomU, fastsimp+)
(*>*)

lemma DomUpsTagTagHdHd: 
  "\<forall> m1 m2 r X h l ll tag1 tag2 H1 H2. 
   (HD \<noteq> TAG \<and> (N, m1, m2, r, X, h) \<in> DomUpsilon \<and> l \<notin> X \<and> 
    ll \<notin> X \<and> l \<noteq> ll \<longrightarrow> 
    (N, m1, m2, r, X, h<l\<bullet>TAG := tag1><ll\<bullet>TAG := tag2><l\<bullet>HD := H1><ll\<bullet>HD := H2>) \<in> DomUpsilon)"
(*<*)
apply clarsimp
apply (induct N)
apply (erule DomUpsilon.elims)
apply clarsimp
apply (rule NIL_DomU, fastsimp+)
apply clarsimp
apply (erule DomUpsilon.elims)
apply clarsimp
apply clarsimp
by (rule CONS_DomU, fastsimp+)
(*>*)

lemma DomUpsTagTagHd[simp]: 
  "\<forall> m1 m2 r X h l ll tag1 tag2 H2. 
   (HD \<noteq> TAG \<and> (N, m1, m2, r, X, h) \<in> DomUpsilon \<and> l \<notin> X 
    \<and> ll \<notin> X \<and> l \<noteq> ll \<longrightarrow> 
    (N, m1, m2, r, X, h<l\<bullet>TAG := tag1><ll\<bullet>TAG := tag2><l1\<bullet>HD := H2>) \<in> DomUpsilon)"
(*<*)
apply clarsimp
apply (induct N)
apply (erule DomUpsilon.elims)
apply clarsimp
apply (rule NIL_DomU, fastsimp+)
apply (erule DomUpsilon.elims)
apply clarsimp
apply clarsimp
by (rule CONS_DomU, fastsimp+)
(*>*)

lemma DomUpsTlTl[simp]: 
  "\<forall> m1 m2 r X h l ll T1 T2. 
   ((N, m1, m2, r, X, h) \<in> DomUpsilon \<and> l \<notin> X \<and> ll \<notin> X \<and> l \<noteq> ll \<longrightarrow> 
    (N, m1, m2, r, X, h\<lfloor>l\<diamondsuit>TL := T1\<rfloor>\<lfloor>ll\<diamondsuit>TL := T2\<rfloor>) \<in> DomUpsilon)"
(*<*)
apply clarsimp
apply (induct N)
apply (erule DomUpsilon.elims)
apply clarsimp
apply (rule NIL_DomU, fastsimp+)
apply (erule DomUpsilon.elims)
apply clarsimp
apply clarsimp
by (rule CONS_DomU, fastsimp+)
(*>*)

lemma DomUpsTagHd[simp]: 
  "\<forall> m1 m2 r X h l tag H. 
   (HD \<noteq> TAG \<and> (N, m1, m2, r, X, h) \<in> DomUpsilon \<and> l \<notin> 
    X \<longrightarrow> (N, m1, m2, r, X, h<l\<bullet>TAG := tag><l\<bullet>HD := H>) \<in> DomUpsilon)"
(*<*)
apply clarsimp
apply (induct N)
apply (erule DomUpsilon.elims)
apply clarsimp
apply (rule NIL_DomU, fastsimp+)
apply (erule DomUpsilon.elims)
apply clarsimp
apply clarsimp
by (rule CONS_DomU, fastsimp+)
(*>*)

lemma DomUpsOheap[simp]: 
  "\<forall> m1 m2 r X h l A. 
   ((N, m1, m2, r, X, h) \<in> DomUpsilon \<and> l \<notin> X \<longrightarrow> 
    (N, m1, m2, r, X, h\<lparr>objhp := (heap.oheap h)(l \<mapsto>\<^sub>f A)\<rparr>) \<in> DomUpsilon)"
(*<*)
apply clarsimp
apply (induct N)
apply (erule DomUpsilon.elims)
apply clarsimp
apply (rule NIL_DomU)
apply auto
apply (simp add:FMAPlookup1)
apply (erule DomUpsilon.elims)
apply clarsimp+
apply (rule CONS_DomU)
apply clarsimp
apply (subgoal_tac "l \<noteq> la")
apply (simp add:FMAPlookup1)
by (fastsimp+)
(*>*)

(*<*)
end
(*>*)
