(* $Id: ExampleListClass.thy,v 1.6 2003/08/31 01:03:27 a1hloidl Exp $ *)

(* used as example in Appendix of deliverable; minor changes in text bits 
   most proofs are hidden; definitions of models relations still in place *)

header {* Representation of Lists on the heap *}

(*<*)
theory ExampleListClass = VDMderived:
(*>*)

subsection {* Basic definitions *}

text {*
 Function computing heap consumption.
*}

constdefs HSize ::"heap \<Rightarrow> int"
"HSize h == int (card (fmap_dom (heap.oheap h)))"
declare HSize_def [simp]

lemma SizeInsert[simp]: "int (card (insert (freshloc (fmap_dom H)) (fmap_dom H))) = int (card (fmap_dom H)) + 1"
(*<*)
apply (subgoal_tac "card (insert (freshloc (fmap_dom H)) (fmap_dom H)) = Suc (card (fmap_dom H))")
apply simp
apply (rule card_insert_disjoint)
apply fastsimp
apply (rule freshloc, fastsimp)
done
(*>*)

declare obj_ifieldupdate_def [simp]
declare obj_rfieldupdate_def [simp]

(*these consts, and models, should be in the locale\<dots>*)
consts LST     :: cname      -- {* class name of the data type *}
       TAG     :: ifldname   -- {* tag distinguishing between nil and cons cells *}
       HD      :: ifldname   -- {* list head, containing data *} 
       TL      :: rfldname   -- {* list tail, containing pointer *}

subsection {* Main models relation *}

text {*
 The models relation encodes how a Grail data type is represented on the heap.
 It's the main definition needed to formalise a datatype in Grail.

 The List data type is encoded by objects with 3 components: $\mbox{TAG}$, 
 $\mbox{HD}$ and $\mbox{TL}$. $\mbox{TAG}$ indicates whether it is a $\mbox{NIL}$
 cell ($0$) or a $\mbox{CONS}$ cell ($1$). 
*}

consts models::"(int list \<times> ref \<times> heap) set"
inductive models intros
  NIL:  "\<lbrakk>fmap_lookup(objhp H) l = Some LST \<and> inthp H TAG l = 0\<rbrakk> \<Longrightarrow> ([],Ref l, H) \<in> models"
  CONS: "\<lbrakk>\<exists> tt . (fmap_lookup(objhp H) l = Some LST \<and> 
                  inthp H TAG l \<noteq> 0 \<and> inthp H HD l = h \<and> refhp H TL l = tt \<and> 
                  (t,tt,H) \<in> models)\<rbrakk>
        \<Longrightarrow> ( h # t, Ref l,H) \<in> models"

lemma NIL_I : "fmap_lookup(objhp H) l = Some LST \<and> inthp H TAG l = 0 \<Longrightarrow> ([],Ref l, H) \<in> models" by(rule NIL, auto)

lemma CONS_I: "\<exists> tt . (fmap_lookup(objhp H) l = Some LST \<and> 
                  inthp H TAG l \<noteq> 0 \<and> inthp H HD l = h \<and> refhp H TL l = tt \<and> 
                  (t,tt,H) \<in> models)
        \<Longrightarrow> ( h # t, Ref l,H) \<in> models" by(rule CONS, auto)

lemma NIL_E:  "([],Ref l, H) \<in> models \<Longrightarrow> fmap_lookup(objhp H) l = Some LST \<and> inthp H TAG l = 0"
               by(erule models.elims,auto)

lemma CONS_E: "(h # t, Ref l,H) \<in> models \<Longrightarrow> 
               (\<exists> tt . (fmap_lookup(objhp H) l = Some LST \<and> inthp H TAG l \<noteq> 0 \<and> 
                        inthp H HD l = h \<and> refhp H TL l = tt \<and> 
                        (t,tt,H) \<in> models))"
               by(erule models.elims,auto)

(*The following are VERY useful lemmas, we should generate them automatically, together  with the models relation.*)
(*lemma modelsTick[simp]: "\<forall> r s n . ((L,r,s) \<in> models \<longrightarrow> (L,r, tickn n s) \<in> models)"
apply(induct_tac L)
apply(clarsimp)
apply(erule models.elims, simp_all)
apply(rule NIL, auto)
apply(erule models.elims, simp_all)
by(rule CONS, auto)

lemma modelsIvarupdate[simp]: "\<forall> r s v val . ((L,r,s) \<in> models \<longrightarrow> (L,r, ivarupdate s v val) \<in> models)"
apply(induct_tac L)
apply(clarsimp)
apply(erule models.elims, simp_all)
apply(rule NIL, auto)
apply(erule models.elims, simp_all)
by(rule CONS, auto)

lemma modelsRvarupdate[simp]: "\<forall> r s v val . ((L,r,s) \<in> models \<longrightarrow> (L,r, rvarupdate s v val) \<in> models)"
apply(induct_tac L)
apply(clarsimp)
apply(erule models.elims, simp_all)
apply(rule NIL, auto)
apply(erule models.elims, simp_all)
by(rule CONS, auto)

lemma modelsIncrcallcount[simp]: "\<forall> r s . ((L,r,s) \<in> models \<longrightarrow> (L,r, incrcallcount s) \<in> models)"
apply(induct_tac L)
apply(clarsimp)
apply(erule models.elims, simp_all)
apply(rule NIL, auto)
apply(erule models.elims, simp_all)
by(rule CONS, auto)
*)

subsection {* Alternative models relations *}

consts LLength::"(nat \<times> ref \<times> (ref set) \<times> heap) set"

text {*
  The following inductive definition can be read as follows:
  $(n,l,X,s) \in \mbox{LLength}$ if $s l$ models a list of length $n$ with pointers from $X$, and all tail pointers distinct.
*}

inductive LLength intros

  NIL_LL:  "\<lbrakk>fmap_lookup(objhp hp) l = Some LST; 
	     inthp hp TAG l = 0;
             Ref l \<in> X\<rbrakk> 
           \<Longrightarrow> (0,Ref l, X, hp) \<in> LLength"

  CONS_LL: "\<lbrakk>fmap_lookup(objhp hp) l = Some LST;
	     inthp hp TAG l = 1;
	     inthp hp HD l = h; 
	     refhp hp TL l = tt; 
             Ref l \<in> X;
             tt \<in> X - {Ref l};  (i,tt, X - {Ref l} , hp) \<in> LLength\<rbrakk>
           \<Longrightarrow> ( Suc i , Ref l, X, hp) \<in> LLength"

lemma LLTAG[simp]:
  "\<forall> r X h l tag.
   ((N, r, X, h) \<in> LLength \<and> Ref l \<notin> X \<longrightarrow> (N, r, X, h<l\<bullet>TAG := tag>) \<in> LLength)"
(*<*)
apply clarsimp
apply (induct N)
apply (erule LLength.elims)
apply clarsimp
apply (rule NIL_LL, fastsimp+)
apply (erule LLength.elims)
apply clarsimp
apply clarsimp
by (rule CONS_LL, fastsimp+)
(*>*)

lemma LLTL[simp]:
  "\<forall> r X h l t.
   ((N, r, X, h) \<in> LLength \<and> Ref l \<notin> X \<longrightarrow> (N, r, X, h\<lfloor>l\<diamondsuit>TL := t\<rfloor>) \<in> LLength)"
(*<*)
apply clarsimp
apply (induct N)
apply (erule LLength.elims)
apply clarsimp
apply (rule NIL_LL, fastsimp+)
apply (erule LLength.elims)
apply clarsimp
apply clarsimp
apply (subgoal_tac "l \<noteq> la")
by (rule CONS_LL, fastsimp+)
(*>*)

text {*
  Version with locations instead of references.
*}

consts LocLength::"(nat \<times> locn \<times> (locn set) \<times> heap) set"
inductive LocLength intros

  NIL_LocL:  "\<lbrakk>fmap_lookup(oheap hp) l = Some LST; 
	       inthp hp TAG l = 0;
               X \<subseteq> fmap_dom (oheap hp);
               l \<in> X\<rbrakk> 
             \<Longrightarrow> (0,l, X, hp) \<in> LocLength"

  CONS_LocL: "\<lbrakk>fmap_lookup(objhp hp) l = Some LST;
	       inthp hp TAG l = 1;
	       inthp hp HD l = h; 
	       refhp hp TL l = Ref tt; 
               l \<in> X;
               tt \<in> X - {l};  (i,tt, X - {l} , hp) \<in> LocLength\<rbrakk>
             \<Longrightarrow> ( Suc i , l, X, hp) \<in> LocLength"

lemma LocLengthDomAux:
"\<forall> l X h . ((L, l, X, h) \<in> LocLength \<longrightarrow>  X \<subseteq> fmap_dom (oheap h))"
(*<*)
apply (induct L)
apply clarsimp
apply (erule LocLength.elims, simp_all, clarsimp)
apply (simp add: fmap_lookup_def fmap_dom_def dom_def, fast)
apply clarsimp
apply (erule LocLength.elims, simp_all, clarsimp)
apply (simp add: fmap_lookup_def fmap_dom_def dom_def, fast)
done
(*>*)

lemma LocLengthDom: "\<lbrakk>(L, l, X, h) \<in> LocLength\<rbrakk> \<Longrightarrow>  X \<subseteq> fmap_dom (oheap h)"
by (insert LocLengthDomAux, fast)

lemma LocLTAG[simp]:
  "\<forall> r X h l tag.
   ((N, r, X, h) \<in> LocLength \<and> l \<notin> X \<longrightarrow> (N, r, X, h<l\<bullet>TAG := tag>) \<in> LocLength)"
(*<*)
apply clarsimp
apply (induct N)
apply (erule LocLength.elims)
apply clarsimp
apply (rule NIL_LocL, fastsimp+)
apply (erule LocLength.elims)
apply clarsimp
apply clarsimp
by (rule CONS_LocL, fastsimp+)
(*>*)

lemma LocLHD[simp]:
  "\<forall> r X oh ih rh.
   ((N, r, X, \<lparr>objhp = oh, inthp = ih, refhp = rh\<rparr>) \<in> LocLength \<longrightarrow> 
    (N, r, X, \<lparr>objhp = oh, inthp = ih(HD := ih HD), refhp = rh\<rparr>) \<in> LocLength)"
by fastsimp


(*identify over heaps which are identical on the domain of the predicate*)
lemma LocLengthSameAux:
"\<forall> l X h hh . (((n,l,X,h) \<in> LocLength \<and> same X h hh) \<longrightarrow> (n,l,X,hh) \<in> LocLength)"
(*<*)
apply (induct n)
apply clarsimp
apply (erule LocLength.elims, simp_all, clarsimp)
apply (rule NIL_LocL)
apply (simp_all add: same_def)
apply clarsimp
apply (subgoal_tac "x \<in> fmap_dom (oheap hp)")
prefer 2 apply fast
apply (simp add: fmap_dom_def dom_def, clarsimp)
apply (rule_tac x=y in exI,simp add: fmap_lookup_def)
apply clarsimp
apply (erule LocLength.elims, simp)
apply (erule_tac x=tt in allE)
apply (erule_tac x="Xa - {la}" in allE)
apply (erule_tac x=hp in allE)
apply (erule_tac x=hh in allE)
apply (rule CONS_LocL, simp_all)
done
(*>*)

lemma LocLengthSame:
"\<lbrakk>(n,l,X,h) \<in> LocLength; same X h hh\<rbrakk> \<Longrightarrow> (n,l,X,hh) \<in> LocLength"
by (insert LocLengthSameAux, fast)

text {*
 Version with locations instead of references, and precise domain.
*}

consts DomLength::"(nat \<times> locn \<times> (locn set) \<times> heap) set"
inductive DomLength intros

  NIL_DomL:  "\<lbrakk>fmap_lookup(objhp hp) l = Some LST; 
	       inthp hp TAG l = 0\<rbrakk> 
             \<Longrightarrow> (0,l, {l}, hp) \<in> DomLength"

  CONS_DomL: "\<lbrakk>fmap_lookup(objhp hp) l = Some LST;
	       inthp hp TAG l = 1;
	       inthp hp HD l = h; 
	       refhp hp TL l = Ref tt; 
               l \<in> X;
               (i,tt, X - {l} , hp) \<in> DomLength\<rbrakk>
             \<Longrightarrow> ( Suc i , l, X, hp) \<in> DomLength"


lemma DomLTAG[simp]:
  "\<forall> r X h l tag.
   ((N, r, X, h) \<in> DomLength \<and> l \<notin> X \<longrightarrow> (N, r, X, h<l\<bullet>TAG := tag>) \<in> DomLength)"
(*<*)
apply clarsimp
apply (induct N)
apply (erule DomLength.elims)
apply clarsimp
apply (rule NIL_DomL, fastsimp+)
apply (erule DomLength.elims)
apply clarsimp
apply clarsimp
by (rule CONS_DomL, fastsimp+)
(*>*)

lemma DomLTL[simp]:
  "\<forall> r X h l t.
   ((N, r, X, h) \<in> DomLength \<and> l \<notin> X \<longrightarrow> (N, r, X, h\<lfloor>l\<diamondsuit>TL := t\<rfloor>) \<in> DomLength)"
(*<*)
apply clarsimp
apply (induct N)
apply (erule DomLength.elims)
apply clarsimp
apply (rule NIL_DomL, fastsimp+)
apply (erule DomLength.elims)
apply clarsimp
apply clarsimp
apply (subgoal_tac "l \<noteq> la")
by (rule CONS_DomL, fastsimp+)
(*>*)

lemma DomLengthDom[simp]:
  "\<forall> l X hp . ((L,l,X, hp) \<in> DomLength \<longrightarrow> X \<subseteq> fmap_dom (objhp hp))"
(*<*)
apply clarsimp
apply (induct L)
apply(erule DomLength.elims)
apply (simp_all add: fmap_lookup_def fmap_dom_def dom_def)
apply(erule DomLength.elims)
apply (simp_all add: fmap_lookup_def fmap_dom_def dom_def)
by fastsimp
(*>*)

lemma DomHD2[simp]: 
  "\<forall> r X h l H. 
   ((N, r, X, h) \<in> DomLength \<and> l \<notin> X \<longrightarrow> (N, r, X, h<l\<bullet>HD := H>) \<in> DomLength)"
(*<*)
apply clarsimp
apply (induct N)
apply (erule DomLength.elims)
apply clarsimp
apply (rule NIL_DomL, fastsimp+)
apply (erule DomLength.elims)
apply clarsimp
apply clarsimp
by (rule CONS_DomL, fastsimp+)
(*>*)

lemma DomTagTagHdHd: 
  "\<forall> r X h l ll tag1 tag2 H1 H2. 
   (HD \<noteq> TAG \<and> (N, r, X, h) \<in> DomLength \<and> l \<notin> X \<and> ll \<notin> X \<and> l \<noteq> ll \<longrightarrow> 
    (N, r, X, h<l\<bullet>TAG := tag1><ll\<bullet>TAG := tag2><l\<bullet>HD := H1><ll\<bullet>HD := H2>) \<in> DomLength)"
(*<*)
apply clarsimp
apply (induct N)
apply (erule DomLength.elims)
apply clarsimp
apply (rule NIL_DomL, fastsimp+)
apply clarsimp
apply (erule DomLength.elims)
apply clarsimp
apply clarsimp
by (rule CONS_DomL, fastsimp+)
(*>*)

lemma DomTagTagHd[simp]: 
  "\<forall> r X h l ll tag1 tag2 H2. 
   (HD \<noteq> TAG \<and> (N, r, X, h) \<in> DomLength \<and> l \<notin> X \<and> ll \<notin> X \<and> l \<noteq> ll \<longrightarrow> 
    (N, r, X, h<l\<bullet>TAG := tag1><ll\<bullet>TAG := tag2><l1\<bullet>HD := H2>) \<in> DomLength)"
(*<*)
apply clarsimp
apply (induct N)
apply (erule DomLength.elims)
apply clarsimp
apply (rule NIL_DomL, fastsimp+)
apply (erule DomLength.elims)
apply clarsimp
apply clarsimp
by (rule CONS_DomL, fastsimp+)
(*>*)

lemma DomTlTl[simp]: 
  "\<forall> r X h l ll T1 T2. 
   ((N, r, X, h) \<in> DomLength \<and> l \<notin> X \<and> ll \<notin> X \<and> l \<noteq> ll \<longrightarrow> 
    (N, r, X, h\<lfloor>l\<diamondsuit>TL := T1\<rfloor>\<lfloor>ll\<diamondsuit>TL := T2\<rfloor>) \<in> DomLength)"
(*<*)
apply clarsimp
apply (induct N)
apply (erule DomLength.elims)
apply clarsimp
apply (rule NIL_DomL, fastsimp+)
apply (erule DomLength.elims)
apply clarsimp
apply clarsimp
by (rule CONS_DomL, fastsimp+)
(*>*)

lemma DomTagHd[simp]: 
  "\<forall> r X h l tag H. 
   (HD \<noteq> TAG \<and> (N, r, X, h) \<in> DomLength \<and> l \<notin> X \<longrightarrow> (N, r, X, h<l\<bullet>TAG := tag><l\<bullet>HD := H>) \<in> DomLength)"
(*<*)
apply clarsimp
apply (induct N)
apply (erule DomLength.elims)
apply clarsimp
apply (rule NIL_DomL, fastsimp+)
apply (erule DomLength.elims)
apply clarsimp
apply clarsimp
by (rule CONS_DomL, fastsimp+)
(*>*)

lemma DomOheap[simp]: 
  "\<forall> r X h l A. 
   ((N, r, X, h) \<in> DomLength \<and> l \<notin> X \<longrightarrow> 
    (N, r, X, h\<lparr>objhp := (heap.oheap h)(l \<mapsto>\<^sub>f A)\<rparr>) \<in> DomLength)"
(*<*)
apply clarsimp
apply (induct N)
apply (erule DomLength.elims)
apply clarsimp
apply (rule NIL_DomL)
apply auto
apply (simp add:FMAPlookup1)
apply (erule DomLength.elims)
apply clarsimp+
apply (rule CONS_DomL)
apply clarsimp
apply (subgoal_tac "l \<noteq> la")
apply (simp add:FMAPlookup1)
by (fastsimp+)
(*>*)

(*<*)
end
(*>*)
