(*  Examples from List.cmlt -> Grail*)

theory ExampleListAppend = VDMderived + ExampleListClass:
(* Camelot:
  let app l m lrev = match l with Nil@d => (match lrev with Nil@e => m
                                                          | Cons(h,t)@e => app (Nil@d) (Cons(h,m)@e) t)
                                | Cons(h,t)@d => app t m (Cons(h,lrev)@d)
Grail:
method public static List$dia_0 app (List$dia_0 l, List$dia_0 m, List$dia_0 lrev) =
   let
      fun f(l, lrev, e, ?t6, e#0, ?t5, d, int h, t, d, ?t7, d#0, int h#0, t#0, m) =
      let
         val tag = getfield l TAG
      in
         if tag = 0
         then f:0(l, lrev, e, e, ?t6, e#0, ?t5, d, e#0, e#0, h, t, d, d, ?t7, d#0, d#0, d#0, h#0, t#0, lrev, m, l)
         else f:1(l, lrev, e, e, ?t6, e#0, ?t5, d, e#0, e#0, h, t, d, d, ?t7, d#0, d#0, d#0, h#0, t#0, lrev, m, l)
      end

      fun f:1(\<dots>) =
      let
         val h#0 = getfield l <int List$dia_0.f1>
         val t#0 = getfield l <List$dia_0 List$dia_0.f0>
         val d#0 = l
         val () = putfield d#0 <int List$dia_0.$> 1
         val () = putfield d#0 <int List$dia_0.f1> h#0
         val () = putfield d#0 <List$dia_0 List$dia_0.f0> lrev
         val ?t7 = d#0
      in
         f:2(l, lrev, e, e, ?t6, e#0, ?t5, d, e#0, e#0, h, t, d, d, ?t7, d#0, d#0, d#0, h#0, t#0, lrev, m, l)
      end

      fun f:2(\<dots>) =
         invokestatic <List$dia_0 List.app (List$dia_0, List$dia_0, List$dia_0)> (t#0, m, ?t7)

      fun f:0(\<dots>) =
      let
         val d = l
         val tag = getfield lrev <int List$dia_0.$>
      in
         if tag = 0
         then f:3(l, lrev, e, e, ?t6, e#0, ?t5, d, e#0, e#0, h, t, d, d, ?t7, d#0, d#0, d#0, h#0, t#0, lrev, m, l)
         else f:4(l, lrev, e, e, ?t6, e#0, ?t5, d, e#0, e#0, h, t, d, d, ?t7, d#0, d#0, d#0, h#0, t#0, lrev, m, l)
      end

      fun f:4(\<dots>) =
      let
         val h = getfield lrev <int List$dia_0.f1>
         val t = getfield lrev <List$dia_0 List$dia_0.f0>
         val e#0 = lrev
         val () = putfield d <int List$dia_0.$> 0
         val ?t5 = d
      in
         f:5(l, lrev, e, e, ?t6, e#0, ?t5, d, e#0, e#0, h, t, d, d, ?t7, d#0, d#0, d#0, h#0, t#0, lrev, m, l)
      end

      fun f:5() =
      let
         val () = putfield e#0 <int List$dia_0.$> 1
         val () = putfield e#0 <int List$dia_0.f1> h
         val () = putfield e#0 <List$dia_0 List$dia_0.f0> m
         val ?t6 = e#0
      in
         f:6(l, lrev, e, e, ?t6, e#0, ?t5, d, e#0, e#0, h, t, d, d, ?t7, d#0, d#0, d#0, h#0, t#0, lrev, m, l)
      end

      fun f:6(\<dots>) =
         invokestatic <List$dia_0 List.app (List$dia_0, List$dia_0, List$dia_0)> (?t5, ?t6, t)

      fun f:3(\<dots>) =
      let
         val e = lrev
      in
         m
      end
   in
      f:app(l, lrev, e, e, ?t6, e#0, ?t5, d, e#0, e#0, h, t, d, d, ?t7, d#0, d#0, d#0, h#0, t#0, lrev, m, l)
   end

ToyGrail:
method public static List$dia_0 app (List$dia_0 l, List$dia_0 m, List$dia_0 lrev) =
   let
      fun f(l, lrev, e, ?t6, e#0, ?t5, d, int h, t, d, ?t7, d#0, int h#0, t#0, m) =
      let
         val tag = getfield l TAG
      in
         if tag = 0
         then f:0(l, lrev, e, e, ?t6, e#0, ?t5, d, e#0, e#0, h, t, d, d, ?t7, d#0, d#0, d#0, h#0, t#0, lrev, m, l)
         else f:1(l, lrev, e, e, ?t6, e#0, ?t5, d, e#0, e#0, h, t, d, d, ?t7, d#0, d#0, d#0, h#0, t#0, lrev, m, l)
      end

      fun f:1(\<dots>) =
      let
         val h0 = getfield l HD
         val t0 = getfield l TL
         val d0 = l
         val one = 1
         val () = putfield d0 TAG one
         val () = putfield d0 HD h0
         val () = putfield d0 TL lrev
         val t7 = d0
      in
         f:2(l, lrev, e, e, ?t6, e#0, ?t5, d, e#0, e#0, h, t, d, d, ?t7, d#0, d#0, d#0, h#0, t#0, lrev, m, l)
      end

      fun f:2(\<dots>) =
         let val l = t0
             val lrev = t7
         in f end

      fun f:0(\<dots>) =
      let
         val d = l
         val tag = getfield lrev TAG
      in
         if tag = 0
         then f:3(l, lrev, e, e, ?t6, e#0, ?t5, d, e#0, e#0, h, t, d, d, ?t7, d#0, d#0, d#0, h#0, t#0, lrev, m, l)
         else f:4(l, lrev, e, e, ?t6, e#0, ?t5, d, e#0, e#0, h, t, d, d, ?t7, d#0, d#0, d#0, h#0, t#0, lrev, m, l)
      end

      fun f:4(\<dots>) =
      let
         val h = getfield lrev HD
         val t = getfield lrev TL
         val e0 = lrev
         val zero = 0
         val () = putfield d TAG zero
         val t5 = d
      in
         f:5(l, lrev, e, e, ?t6, e#0, ?t5, d, e#0, e#0, h, t, d, d, ?t7, d#0, d#0, d#0, h#0, t#0, lrev, m, l)
      end

      fun f:5() =
      let
         val one = 1
         val () = putfield e0 TAG one
         val () = putfield e0 HD h
         val () = putfield e0 TL m
         val t6 = e0
      in
         f:6(l, lrev, e, e, ?t6, e#0, ?t5, d, e#0, e#0, h, t, d, d, ?t7, d#0, d#0, d#0, h#0, t#0, lrev, m, l)
      end

      fun f:6(\<dots>) =
      let
         val l = t5
         val m = t6
         val lrev = t
      in f

      fun f:3(\<dots>) =
      let
         val e = lrev
      in
         m
      end
   in
      f:app(l, lrev, e, e, ?t6, e#0, ?t5, d, e#0, e#0, h, t, d, d, ?t7, d#0, d#0, d#0, h#0, t#0, lrev, m, l)
   end
*)
consts A::nat B::nat C::nat
consts A0::nat B0::nat C0::nat
consts A1::nat B1::nat C1::nat
consts A3::nat B3::nat C3::nat
consts A4::nat B4::nat C4::nat

lemma "(\<langle> 1 0 0 0 \<rangle> \<oplus> (p1 \<smile> p2)) = (p1 \<smile> p2 \<smile> \<langle> 1 0 0 0 \<rangle>)"
apply simp
done

(*This is the version with DomLength*)
locale AppendClockDom = 
  fixes    tag :: iname and h :: iname and b :: iname and one  :: iname and zero :: iname and h0 :: iname
    and    l   :: rname and m :: rname and t :: rname and lrev :: rname and d :: rname and e :: rname
    and    e0  :: rname and t5 :: rname and t6 :: rname and t0 :: rname and d0 :: rname and t7 :: rname
    and	   f   :: funame and f0   :: funame and f1   :: funame and f3   :: funame and f4   :: funame
    and myContext :: "'a vdmcontext"
 assumes fbdy[simp]: 
         "funtable f == (LET tag = GetFi l TAG;
                              b = Primop (% x y. if x = 0 then 1 else 0) tag tag 
                         IN IF b THEN Call f0 ELSE Call f1 END)::'a expr"
    and f0bdy[simp]:
         "funtable f0 == (LET rf d = RVar l;
                               tag = GetFi lrev TAG;
                                 b = Primop (% x y. if x = 0 then 1 else 0) tag tag 
                          IN IF b THEN Call f3 ELSE Call f4 END)::'a expr"
    and f1bdy[simp]: 
         "funtable f1 == (LET h0 = GetFi l HD;
                           rf t0 = GetFr l TL;
                           rf d0 = RVar l;
                             one = expr.Int 1;
                               _ = PutFi d0 TAG one;
                               _ = PutFi d0 HD h0;
                               _ = PutFr d0 TL lrev;
                           rf t7 = RVar d0;
                            rf l = RVar t0;
                         rf lrev = RVar t7
                           IN CALL f END)::'a expr"
    and f3bdy[simp]: 
         "funtable f3 == (LET rf e = RVar lrev IN RVar m END)::'a expr"
    and f4bdy[simp]: 
         "funtable f4 == (LET h = GetFi lrev HD;
                          rf t = GetFr lrev TL;
                         rf e0 = RVar lrev;
                          zero = expr.Int 0;
                             _ = PutFi d TAG zero;
                         rf t5 = RVar d;
                           one = expr.Int 1;
                             _ = PutFi e0 TAG one;
                             _ = PutFi e0 HD h;
                             _ = PutFr e0 TL m;
                         rf t6 = RVar e0;
                          rf l = RVar t5;
                          rf m = RVar t6;
                       rf lrev = RVar t
                         IN CALL f END)::'a expr"

      and  vardistinct[simp]: "distinct [tag,h,b,one,zero,h0] \<and> distinct [h0,zero,one,b,h,tag] \<and> 
                         distinct[l,m,t,lrev,d,e,e0,t5,t6,t0,d0,t7] \<and> 
                         distinct [t7,d0,t0,t6,t5,e0,e,d,lrev,t,m,l] \<and>
                         distinct [HD,TAG] \<and> distinct [TAG,HD] \<and>
                         distinct [f,f0,f1,f3,f4] \<and> distinct [f4,f3,f1,f0,f]"

      and spectf: 
          "spectable f == {(E,h,hh,v,p) . 
                            \<forall> L LREV . ((\<exists> rl rlrev X Z .E\<lfloor>l\<rfloor> = Ref rl \<and> (L,rl,X,h) \<in> LocLength \<and> 
                                                          E\<lfloor>lrev\<rfloor> = Ref rlrev \<and> (LREV,rlrev,Z,h) \<in> LocLength \<and> X Int Z = {}) \<longrightarrow>
                                                      clock p = A * LREV + B * L + C)}"
      and spectf0: 
          "spectable f0 == {(E,h,hh,v,p) . 
                             \<forall> LREV . ((\<exists> rl rlrev X Z .E\<lfloor>l\<rfloor> = Ref rl \<and> 
                                                           E\<lfloor>lrev\<rfloor> = Ref rlrev \<and> (LREV,rlrev,Z,h) \<in> LocLength) \<longrightarrow>
                                                       clock p = A0 * LREV + C0)}"
      and spectf1: 
          "spectable f1 == {(E,h,hh,v,p) . 
                             \<forall> L LREV . ((\<exists> rl rlrev X Z .E\<lfloor>l\<rfloor> = Ref rl \<and> (L,rl,X,h) \<in> LocLength \<and> L \<noteq> 0 \<and> 
                                                           E\<lfloor>lrev\<rfloor> = Ref rlrev \<and> (LREV,rlrev,Z,h) \<in> LocLength \<and> X Int Z = {}) \<longrightarrow>
                                                       clock p = A1 * LREV + B1 * L + C1)}"

      and spectf3: 
          "spectable f3 == {(E,h,hh,v,p) . 
                            ((\<exists> rl rlrev X Z .E\<lfloor>l\<rfloor> = Ref rl \<and> 
                                              E\<lfloor>lrev\<rfloor> = Ref rlrev \<and> (0,rlrev,Z,h) \<in> LocLength) \<longrightarrow>
                                              clock p = C3)}"
      and spectf4: 
          "spectable f4 == {(E,h,hh,v,p) .
                             \<forall> LREV . ((\<exists> rl rlrev X Z .E\<lfloor>l\<rfloor> = Ref rl \<and>  LREV \<noteq> 0 \<and> 
                                                         E\<lfloor>lrev\<rfloor> = Ref rlrev \<and> (LREV,rlrev,Z,h) \<in> LocLength) \<longrightarrow>
                                                       clock p = A4 * LREV + C4)}"
     and myContext_def:
             "myContext == {(Call f, spectable f), (Call f0, spectable f0), (Call f1, spectable f1), 
                            (Call f3, spectable f3), (Call f4, spectable f4)}"

lemma (in AppendClockDom) "\<rhd> (Call f)::'a expr : spectable f"
apply (rule MUTRECCALL)
apply (subgoal_tac "finite myContext")
apply simp
apply (simp add: myContext_def)
apply (simp add: myContext_def)
apply (simp only: myContext_def)
apply fast
prefer 2
apply (simp add: myContext_def)
apply clarsimp
apply (unfold myContext_def) 
apply (insert vardistinct)
apply (simp_all add: spectf spectf0 spectf1 spectf3 spectf4)
apply (case_tac "fa = f")
(*case fa = f*)
  apply (rule vdm_conseq)
  apply clarsimp
  apply (rule vdm_leti, rule vdm_getfi) prefer 2 apply clarsimp prefer 2
  apply (rule vdm_leti, rule vdm_prim) prefer 2 apply clarsimp prefer 2
  apply (rule vdm_if)
  apply (rule vdm_ax, simp)
  apply (rule vdm_ax, simp)
  apply clarsimp
  apply (case_tac "inthp aa TAG ad = 0")
  apply clarsimp
  apply (erule LocLength.elims, simp_all)
  apply (erule_tac x=LREV in allE)
  apply (subgoal_tac "(\<exists>Z. (LREV, rlrev, Z, aa) \<in> LocLength)")
  apply clarsimp defer 1 apply (rule_tac x=Z in exI, clarsimp)
  apply (erule_tac x=L in allE)
  apply (erule_tac x=LREV in allE)
  apply (subgoal_tac "(\<exists>X. (L, ad, X, aa) \<in> LocLength \<and> 0 < L \<and> (\<exists>Z. (LREV, rlrev, Z, aa) \<in> LocLength \<and> X \<inter> Z = {}))")
  apply clarsimp defer 1 apply (rule_tac x=X in exI, simp)
  apply (rule,erule LocLength.elims, simp_all) apply (rule_tac x=Z in exI, simp)
apply (case_tac "fa = f0")
(*case fa = f0*)
  apply (rule vdm_conseq)
  apply clarsimp
  apply (rule vdm_letr, rule vdm_rvar) prefer 2 apply clarsimp prefer 2
  apply (rule vdm_leti, rule vdm_getfi) prefer 2 apply clarsimp prefer 2
  apply (rule vdm_leti, rule vdm_prim) prefer 2 apply clarsimp prefer 2
  apply (rule vdm_if)
  apply (rule vdm_ax, simp)
  apply (rule vdm_ax, simp)
  apply clarsimp
  apply (case_tac "inthp aa TAG rlrev = 0")
  apply clarsimp
  apply (subgoal_tac "LREV = 0")
  prefer 2 apply (erule LocLength.elims, simp_all) 
  apply (subgoal_tac "(\<exists>Z. (0, rlrev, Z, aa) \<in> LocLength)")
  apply clarsimp defer 1
  apply (rule_tac x=Z in exI, simp)  
  apply (erule_tac x=LREV in allE)
  apply (subgoal_tac "0 < LREV \<and> (\<exists>Z. (LREV, rlrev, Z, aa) \<in> LocLength)")
  apply clarsimp defer 1
  apply (rule, erule LocLength.elims, simp_all)
  apply (rule_tac x=Z in exI, simp)  
apply (case_tac "fa = f1")
(*case fa = f1*)
  apply (rule vdm_conseq)
  apply clarsimp
  apply (rule vdm_leti, rule vdm_getfi) prefer 2 apply clarsimp prefer 2
  apply (rule vdm_letr, rule vdm_getfr) prefer 2 apply clarsimp prefer 2
  apply (rule vdm_letr, rule vdm_rvar) prefer 2 apply clarsimp prefer 2
  apply (rule vdm_leti, rule vdm_int) prefer 2 apply clarsimp prefer 2
  apply (rule vdm_letv, rule vdm_putfi) prefer 2 apply clarsimp prefer 2
  apply (rule vdm_letv, rule vdm_putfi) prefer 2 apply clarsimp prefer 2
  apply (rule vdm_letv, rule vdm_putfr) prefer 2 apply clarsimp prefer 2
  apply (rule vdm_letr, rule vdm_rvar) prefer 2 apply clarsimp prefer 2
  apply (rule vdm_letr, rule vdm_rvar) prefer 2 apply clarsimp prefer 2
  apply (rule vdm_letr, rule vdm_rvar) prefer 2 apply clarsimp prefer 2
  apply (rule vdm_ax, simp)
  apply clarsimp
  apply (erule_tac x=L in allE, erule_tac x=LREV in allE) 
  apply (erule LocLength.elims, simp_all) apply clarsimp
  apply (subgoal_tac "(\<exists>X. (Suc i, tt, X,
                \<lparr>oheap = oheap hp,
                   iheap = \<lambda>u. if u = HD
                               then \<lambda>u. if u = la then a<h0:=hp<la\<cdot>HD>>\<lfloor>t0:=hp\<lfloor>la^TL\<rfloor>\<rfloor>\<lfloor>d0:=Ref la\<rfloor><one:=1><h0>
                                        else \<lparr>oheap = oheap hp,
                                                iheap = \<lambda>u. if u = TAG
                                                            then \<lambda>u. if u = la then a<h0:=hp<la\<cdot>HD>>\<lfloor>t0:=hp\<lfloor>la^TL\<rfloor>\<rfloor>\<lfloor>d0:=Ref la\<rfloor><one:=1><one>
                                                                     else hp<u\<cdot>TAG>
                                                            else iheap hp u,
                                                rheap = rheap hp\<rparr><u\<cdot>HD>
                               else iheap \<lparr>oheap = oheap hp,
                                             iheap = \<lambda>u. if u = TAG
                                                         then \<lambda>u. if u = la then a<h0:=hp<la\<cdot>HD>>\<lfloor>t0:=hp\<lfloor>la^TL\<rfloor>\<rfloor>\<lfloor>d0:=Ref la\<rfloor><one:=1><one>
                                                                  else hp<u\<cdot>TAG>
                                                         else iheap hp u,
                                             rheap = rheap hp\<rparr>
                                     u,
                   rheap = \<lambda>u. if u = TL
                               then \<lambda>u. if u = la then a<h0:=hp<la\<cdot>HD>>\<lfloor>t0:=hp\<lfloor>la^TL\<rfloor>\<rfloor>\<lfloor>d0:=Ref la\<rfloor><one:=1>\<lfloor>lrev\<rfloor>
                                        else \<lparr>oheap = oheap hp,
                                                iheap = \<lambda>u. if u = HD
                                                            then \<lambda>u. if u = la then a<h0:=hp<la\<cdot>HD>>\<lfloor>t0:=hp\<lfloor>la^TL\<rfloor>\<rfloor>\<lfloor>d0:=Ref la\<rfloor><one:=1><h0>
                                                                     else \<lparr>oheap = oheap hp,
  iheap = \<lambda>u. if u = TAG then \<lambda>u. if u = la then a<h0:=hp<la\<cdot>HD>>\<lfloor>t0:=hp\<lfloor>la^TL\<rfloor>\<rfloor>\<lfloor>d0:=Ref la\<rfloor><one:=1><one> else hp<u\<cdot>TAG> else iheap hp u,
  rheap = rheap hp\<rparr><u\<cdot>HD>
                                                            else iheap \<lparr>oheap = oheap hp,
                                                                          iheap =
 \<lambda>u. if u = TAG then \<lambda>u. if u = la then a<h0:=hp<la\<cdot>HD>>\<lfloor>t0:=hp\<lfloor>la^TL\<rfloor>\<rfloor>\<lfloor>d0:=Ref la\<rfloor><one:=1><one> else hp<u\<cdot>TAG> else iheap hp u,
                                                                          rheap = rheap hp\<rparr>
                                                                  u,
                                                rheap = rheap hp\<rparr>\<lfloor>u^TL\<rfloor>
                               else rheap \<lparr>oheap = oheap hp,
                                             iheap = \<lambda>u. if u = HD
                                                         then \<lambda>u. if u = la then a<h0:=hp<la\<cdot>HD>>\<lfloor>t0:=hp\<lfloor>la^TL\<rfloor>\<rfloor>\<lfloor>d0:=Ref la\<rfloor><one:=1><h0>
                                                                  else \<lparr>oheap = oheap hp,
                                                                          iheap =
 \<lambda>u. if u = TAG then \<lambda>u. if u = la then a<h0:=hp<la\<cdot>HD>>\<lfloor>t0:=hp\<lfloor>la^TL\<rfloor>\<rfloor>\<lfloor>d0:=Ref la\<rfloor><one:=1><one> else hp<u\<cdot>TAG> else iheap hp u,
                                                                          rheap = rheap hp\<rparr><u\<cdot>HD>
                                                         else iheap \<lparr>oheap = oheap hp,
                                                                       iheap = \<lambda>u.
       if u = TAG then \<lambda>u. if u = la then a<h0:=hp<la\<cdot>HD>>\<lfloor>t0:=hp\<lfloor>la^TL\<rfloor>\<rfloor>\<lfloor>d0:=Ref la\<rfloor><one:=1><one> else hp<u\<cdot>TAG> else iheap hp u,
                                                                       rheap = rheap hp\<rparr>
                                                               u,
                                             rheap = rheap hp\<rparr>
                                     u\<rparr>)
               \<in> LocLength \<and>
               (\<exists>Z. (LREV, la, Z,
                     \<lparr>oheap = oheap hp,
                        iheap = \<lambda>u. if u = HD
                                    then \<lambda>u. if u = la then a<h0:=hp<la\<cdot>HD>>\<lfloor>t0:=hp\<lfloor>la^TL\<rfloor>\<rfloor>\<lfloor>d0:=Ref la\<rfloor><one:=1><h0>
                                             else \<lparr>oheap = oheap hp,
                                                     iheap = \<lambda>u. if u = TAG
                                                                 then \<lambda>u. if u = la then a<h0:=hp<la\<cdot>HD>>\<lfloor>t0:=hp\<lfloor>la^TL\<rfloor>\<rfloor>\<lfloor>d0:=Ref la\<rfloor><one:=1><one>
                                                                          else hp<u\<cdot>TAG>
                                                                 else iheap hp u,
                                                     rheap = rheap hp\<rparr><u\<cdot>HD>
                                    else iheap \<lparr>oheap = oheap hp,
                                                  iheap = \<lambda>u. if u = TAG
                                                              then \<lambda>u. if u = la then a<h0:=hp<la\<cdot>HD>>\<lfloor>t0:=hp\<lfloor>la^TL\<rfloor>\<rfloor>\<lfloor>d0:=Ref la\<rfloor><one:=1><one>
                                                                       else hp<u\<cdot>TAG>
                                                              else iheap hp u,
                                                  rheap = rheap hp\<rparr>
                                          u,
                        rheap = \<lambda>u. if u = TL
                                    then \<lambda>u. if u = la then a<h0:=hp<la\<cdot>HD>>\<lfloor>t0:=hp\<lfloor>la^TL\<rfloor>\<rfloor>\<lfloor>d0:=Ref la\<rfloor><one:=1>\<lfloor>lrev\<rfloor>
                                             else \<lparr>oheap = oheap hp,
                                                     iheap = \<lambda>u. if u = HD
                                                                 then \<lambda>u. if u = la then a<h0:=hp<la\<cdot>HD>>\<lfloor>t0:=hp\<lfloor>la^TL\<rfloor>\<rfloor>\<lfloor>d0:=Ref la\<rfloor><one:=1><h0>
                                                                          else \<lparr>oheap = oheap hp,
       iheap = \<lambda>u. if u = TAG then \<lambda>u. if u = la then a<h0:=hp<la\<cdot>HD>>\<lfloor>t0:=hp\<lfloor>la^TL\<rfloor>\<rfloor>\<lfloor>d0:=Ref la\<rfloor><one:=1><one> else hp<u\<cdot>TAG> else iheap hp u,
       rheap = rheap hp\<rparr><u\<cdot>HD>
                                                                 else iheap \<lparr>oheap = oheap hp,
    iheap = \<lambda>u. if u = TAG then \<lambda>u. if u = la then a<h0:=hp<la\<cdot>HD>>\<lfloor>t0:=hp\<lfloor>la^TL\<rfloor>\<rfloor>\<lfloor>d0:=Ref la\<rfloor><one:=1><one> else hp<u\<cdot>TAG> else iheap hp u,
    rheap = rheap hp\<rparr>
                                                                       u,
                                                     rheap = rheap hp\<rparr>\<lfloor>u^TL\<rfloor>
                                    else rheap \<lparr>oheap = oheap hp,
                                                  iheap = \<lambda>u. if u = HD
                                                              then \<lambda>u. if u = la then a<h0:=hp<la\<cdot>HD>>\<lfloor>t0:=hp\<lfloor>la^TL\<rfloor>\<rfloor>\<lfloor>d0:=Ref la\<rfloor><one:=1><h0>
                                                                       else \<lparr>oheap = oheap hp,
    iheap = \<lambda>u. if u = TAG then \<lambda>u. if u = la then a<h0:=hp<la\<cdot>HD>>\<lfloor>t0:=hp\<lfloor>la^TL\<rfloor>\<rfloor>\<lfloor>d0:=Ref la\<rfloor><one:=1><one> else hp<u\<cdot>TAG> else iheap hp u,
    rheap = rheap hp\<rparr><u\<cdot>HD>
                                                              else iheap \<lparr>oheap = oheap hp,
 iheap = \<lambda>u. if u = TAG then \<lambda>u. if u = la then a<h0:=hp<la\<cdot>HD>>\<lfloor>t0:=hp\<lfloor>la^TL\<rfloor>\<rfloor>\<lfloor>d0:=Ref la\<rfloor><one:=1><one> else hp<u\<cdot>TAG> else iheap hp u,
 rheap = rheap hp\<rparr>
                                                                    u,
                                                  rheap = rheap hp\<rparr>
                                          u\<rparr>)
                    \<in> LocLength \<and>
                    X \<inter> Z = {}))")
  apply clarsimp defer 1
  apply (rule_tac x=Xa in exI)
  apply (rule CONS_LocL)
defer 1
apply (case_tac "fa = f3")
(*case fa = f3*)
  apply (rule vdm_conseq)
  apply clarsimp
  apply (rule vdm_letr, rule vdm_rvar) prefer 2 apply clarsimp prefer 2
  apply (rule vdm_rvar) apply clarsimp
defer 1
apply (subgoal_tac "fa = f4") prefer 2 apply clarsimp
(*case fa = f4*)
  apply (rule vdm_conseq)
  apply clarsimp
  apply (rule vdm_leti, rule vdm_getfi) prefer 2 apply clarsimp prefer 2
  apply (rule vdm_letr, rule vdm_getfr) prefer 2 apply clarsimp prefer 2
  apply (rule vdm_letr, rule vdm_rvar) prefer 2 apply clarsimp prefer 2
  apply (rule vdm_leti, rule vdm_int) prefer 2 apply clarsimp prefer 2
  apply (rule vdm_letv, rule vdm_putfi) prefer 2 apply clarsimp prefer 2
  apply (rule vdm_letr, rule vdm_rvar) prefer 2 apply clarsimp prefer 2
  apply (rule vdm_leti, rule vdm_int) prefer 2 apply clarsimp prefer 2
  apply (rule vdm_letv, rule vdm_putfi) prefer 2 apply clarsimp prefer 2
  apply (rule vdm_letv, rule vdm_putfi) prefer 2 apply clarsimp prefer 2
  apply (rule vdm_letv, rule vdm_putfr) prefer 2 apply clarsimp prefer 2
  apply (rule vdm_letr, rule vdm_rvar) prefer 2 apply clarsimp prefer 2
  apply (rule vdm_letr, rule vdm_rvar) prefer 2 apply clarsimp prefer 2
  apply (rule vdm_letr, rule vdm_rvar) prefer 2 apply clarsimp prefer 2
  apply (rule vdm_letr, rule vdm_rvar) prefer 2 apply clarsimp prefer 2
  apply (rule vdm_ax, simp)
  apply clarsimp
(*end of VCG*)
apply (erule_tac x=0 in allE)
apply (erule_tac x=LREV in allE)
apply clarsimp
apply (subgoal_tac "")
apply clarsimp
oops
prefer 2
  apply (case_tac "")
  apply (rule vdm_leti, rule vdm_getfi) prefer 2 apply clarsimp prefer 2


locale AppendClockDom = 
  fixes    tag :: iname and h :: iname and b :: iname and one  :: iname and zero :: iname
    and    l   :: rname and m :: rname and t :: rname and lrev :: rname and d :: rname
    and	   f   :: funame and f0   :: funame and	f1   :: funame and f4   :: funame
    and myContext :: "'a vdmcontext"
 assumes fbdy[simp]: 
         "funtable f == LET tag = GetFi l TAG;
                              b = Primop (% x y. if x = 0 then 1 else 0) tag tag 
                         IN IF b THEN CALL f0 ELSE CALL f1 END"
     and f0bdy[simp]: 
         "funtable f0 == LET rf d = RVar l;
                               tag = GetFi lrev TAG;
                                 b = Primop (% x y. if x = 0 then 1 else 0) tag tag 
                         IN IF b THEN CALL f3 ELSE CALL f4 END"
     and f1bdy[simp]:
         "funtable f1 == LET h0 = GetFi l HD;
                          rf t0 = GetFr l TL;
                          rf d0 = RVar l;
                            one = expr.Int 1;
                              _ = PutFi d0 TAG one;
                              _ = PutFi d0 HD h0;
                              _ = PutFr d0 TL lrev;
                          rf t7 = RVar d0
                         IN CALL f2 END"
     and f2bdy[simp]:
         "funtable f2 == LET rf l = RVar t0;
                             rf lrev = RVar t7
                         IN CALL f END"
     and f3bdy[simp]:
         "funtable f3 == LET rf e = RVar lrev IN RVar m END"
     and f4bdy[simp]:
         "funtable f4 == LET h = GetFi lrev HD;
                          rf t = GetFr lrev TL;
                         rf e0 = RVar lrev;
                          zero = expr.Int 0;
                             _ = PutFi d TAG zero;
                         rf t5 = RVar d
                         IN CALL f5 END" 
     and f5bdy[simp]:
         "funtable f5 == LET one = expr.Int 1;
                               _ = PutFi e0 TAG one;
                               _ = PutFi e0 HD h;
                               _ = PutFr e0 TL m;
                           rf t6 = RVar e0
                         IN CALL f6 END"
     and f6bdy[simp]:
         "funtable f6 == LET rf l = RVar t5;
                             rf m = RVar t6;
                          rf lrev = RVar t
                         IN CALL f END" 
done 
     and specf: 
         "spectable f == {(E,h,hh,v,p) . 
                           \<forall> L LREV . ((\<exists> rl rlrev X Z . E\<lfloor>l\<rfloor> = Ref rl \<and> (L,rl,X,h) \<in> DomLength \<and> 
                                                          E\<lfloor>lrev\<rfloor> = Ref rlrev \<and> (LREV,rlrev,Z,h) \<in> DomLength \<and>
                                                          X Int Z = {})
                                        \<longrightarrow>
                                        clock p = A * LREV + B * L + C)}"
     and specf0: 
         "spectable f0 == {(E,h,hh,v,p) . 
                           \<forall> L LREV . ((\<exists> rl rlrev X Z . E\<lfloor>l\<rfloor> = Ref rl \<and> (L,rl,X,h) \<in> DomLength \<and> 
                                                          E\<lfloor>lrev\<rfloor> = Ref rlrev \<and> (LREV,rlrev,Z,h) \<in> DomLength \<and>
                                                          X Int Z = {} \<and> inthp h TAG rl = 0)
                                        \<longrightarrow>
                                        clock p = A0 * LREV + B0 * L + C0)}"
     and specf1:
         "spectable f1 == {(E,h,hh,v,p) . 
                           \<forall> L LREV . ((\<exists> rl rlrev X Z . E\<lfloor>l\<rfloor> = Ref rl \<and> (L,rl,X,h) \<in> DomLength \<and> 
                                                          E\<lfloor>lrev\<rfloor> = Ref rlrev \<and> (LREV,rlrev,Z,h) \<in> DomLength \<and> 
                                                          X Int Z = {} \<and> inthp h TAG rl \<noteq> 0) 
                                        \<longrightarrow> 
                                        clock p = A1 * LREV + B1 * L + C1)}" 
     and specf2:
         "spectable f2 ==  {(E,h,hh,v,p) . 
                           \<forall> L LREV . ((\<exists> rl rlrev X Z . E\<lfloor>t0\<rfloor> = Ref rl \<and> (L,rl,X,h) \<in> DomLength \<and> 
                                                          E\<lfloor>t7\<rfloor> = Ref rlrev \<and> (LREV,rlrev,Z,h) \<in> DomLength \<and>
                                                          X Int Z = {})
                                        \<longrightarrow>
                                        clock p = A1 * (LREV - 1) + B1 * (L + 1) + C1)}"
     and specf3: 
         "spectable f1 == {(E,h,hh,v,p) . 
                           \<forall> L LREV . ((\<exists> rl rlrev X Z . E\<lfloor>l\<rfloor> = Ref rl \<and> (L,rl,X,h) \<in> DomLength \<and> 
                                                          E\<lfloor>lrev\<rfloor> = Ref rlrev \<and> (LREV,rlrev,Z,h) \<in> DomLength \<and> 
                                                          X Int Z = {} \<and> inthp h TAG rl = 0 \<and> inthp h TAG rlrev = 0) 
                                        \<longrightarrow> 
                                        clock p = A1 * LREV + B1 * L + C1)}" 
     and specf4:
         "spectable f4 == {(E,h,hh,v,p) . 
                           \<forall> L LREV . ((\<exists> rl rlrev X Z . E\<lfloor>l\<rfloor> = Ref rl \<and> (L,rl,X,h) \<in> DomLength \<and> 
                                                          E\<lfloor>lrev\<rfloor> = Ref rlrev \<and> (LREV,rlrev,Z,h) \<in> DomLength \<and>
                                                          X Int Z = {} \<and> inthp h TAG rl = 0 \<and> inthp h TAG rl \<noteq> 0)
                                        \<longrightarrow>
                                        clock p = A4 * LREV + B4 * L + C4)}"

      and  vardistinct: "distinct [tag,h,b,one,zero] \<and> distinct [zero,one,b,h,tag] \<and> 
                         distinct[l,m,t,lrev,d] \<and> distinct [d,lrev,t,m,l] \<and>
                         distinct [HD,TAG] \<and> 
                         distinct [f, f0, f1, f4] \<and> distinct [f4,f1,f0,f]"

     defines "myContext == {(Call f, spectable f), (Call f0, spectable f0), (Call f1, spectable f1), (Call f4, spectable f4)}"


lemma (in AppendClockDom) "\<rhd> (Call f::'a expr) : spectable f"
apply (rule MUTRECCALL)
apply (subgoal_tac "finite myContext")
apply simp
apply (simp add: myContext_def)
apply (simp add: myContext_def)
apply (simp add: myContext_def)
prefer 2
apply (simp add: myContext_def)
apply clarsimp
apply (unfold myContext_def)
apply (case_tac "fa = f")
(*case fa = f*)
prefer 2 apply clarsimp prefer 2
apply clarsimp
apply (rule vdm_conseq)
apply (rule vdm_leti) apply (rule vdm_getfi)
prefer 2 apply clarsimp prefer 2 
apply (rule vdm_leti) apply (rule vdm_prim)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_if)
apply (subgoal_tac "{(CALL f, spectable f), (CALL f0, spectable f0), (CALL f1, spectable f1), (CALL f4, spectable f4)} \<rhd>  (CALL f0) : spectable f0")
apply assumption 
apply (rule vdm_ax, simp)
apply (subgoal_tac "{(CALL f, spectable f), (CALL f0, spectable f0), (CALL f1, spectable f1), (CALL f4, spectable f4)} \<rhd>  (CALL f1) : spectable f1")
apply assumption 
apply (rule vdm_ax, simp)
apply clarsimp
(*side condition*)
apply (erule disjE) 
apply clarsimp
apply (simp add: specf0 specf)
apply clarsimp
apply (erule_tac x=L in allE, erule_tac x=LREV in allE)
apply (subgoal_tac "(\<exists>X. (L, ad, X, aa) \<in> DomLength \<and> (\<exists>Z. (LREV, rlrev, Z, aa) \<in> DomLength \<and> X \<inter> Z = {}))", clarsimp)
prefer 2
apply (rule_tac x=X in exI, simp, rule_tac x=Z in exI, simp)
defer 1
apply clarsimp
apply (simp add: specf0 specf1 specf)
apply clarsimp
apply (case_tac "inthp aa TAG ad = 0", simp_all)
apply (erule_tac x=L in allE, erule_tac x=LREV in allE)
apply (subgoal_tac "(\<exists> X. (L, ad, X, aa) \<in> DomLength \<and> (\<exists>Z. (LREV, rlrev, Z, aa) \<in> DomLength \<and> X \<inter> Z = {}))", clarsimp)
prefer 2
apply (rule_tac x=X in exI, simp, rule_tac x=Z in exI, simp)
defer 1
apply (case_tac "fa = f0")
(*case fa = f0*)
prefer 2 apply clarsimp prefer 2
apply clarsimp
apply (rule vdm_conseq)
apply (rule vdm_letr) apply (rule vdm_rvar)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_leti) apply (rule vdm_getfi)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_leti) apply (rule vdm_prim)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_if) apply (rule vdm_rvar)
prefer 2 apply clarsimp prefer 2
apply (subgoal_tac "{(CALL f, spectable f), (CALL f0, spectable f0), (CALL f1, spectable f1), (CALL f4, spectable f4)} \<rhd>  (CALL f4) : spectable f4")
apply assumption 
apply (rule vdm_ax, simp)
(*side condition*)
apply (erule disjE) 
apply clarsimp
apply (simp add: specf0)
apply clarsimp
apply (erule DomLength.elims, simp_all)
apply clarsimp
defer 1
apply (simp add: specf0 specf4)
apply clarsimp
apply (case_tac "inthp aa TAG ad = 0", simp_all)
apply (erule DomLength.elims, simp_all)
apply (erule DomLength.elims, simp_all)
apply clarsimp
defer 1
apply clarsimp defer 1
apply (case_tac "fa = f1")
prefer 2 apply clarsimp prefer 2
apply clarsimp
apply (rule vdm_conseq)
apply (rule vdm_leti) apply (rule vdm_getfi)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr) apply (rule vdm_getfr)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_leti) apply (rule vdm_int)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv) apply (rule vdm_putfi)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv) apply (rule vdm_putfi)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv) apply (rule vdm_putfr)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr) apply (rule vdm_rvar)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr) apply (rule vdm_rvar)
prefer 2 apply clarsimp prefer 2
apply (subgoal_tac "{(CALL f, spectable f), (CALL f0, spectable f0), (CALL f1, spectable f1), (CALL f4, spectable f4)} \<rhd>  (CALL f) : spectable f")
apply assumption 
apply (rule vdm_ax, simp)
(*side condition*)
apply (simp add: specf specf1)
apply clarsimp
defer 1 (* try remaining goal first*)
apply (rule vdm_conseq)
apply (rule vdm_leti) apply (rule vdm_getfi)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr) apply (rule vdm_getfr)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_leti) apply (rule vdm_int)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv) apply (rule vdm_putfi)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr) apply (rule vdm_rvar)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_leti) apply (rule vdm_int)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv) apply (rule vdm_putfi)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv) apply (rule vdm_putfi)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv) apply (rule vdm_putfr)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr) apply (rule vdm_rvar)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr) apply (rule vdm_rvar)
prefer 2 apply clarsimp prefer 2
apply (subgoal_tac "{(CALL f, spectable f), (CALL f0, spectable f0), (CALL f1, spectable f1), (CALL f4, spectable f4)} \<rhd>  (CALL f) : spectable f")
apply assumption 
apply (rule vdm_ax, simp)
(*side condition*)
apply (simp add: specf specf4)
(*goal discharged*)
apply (insert vardistinct, simp_all)
apply clarsimp defer 1 
apply clarsimp defer 1 
apply clarsimp defer 1 
apply clarsimp defer 1 
apply clarsimp defer 1 
apply (subgoal_tac "A = A0 \<and> A = A1 \<and> B = B0 \<and> B = B1 \<and> C0 = C1 \<and> C = C0 + 10")
apply clarsimp defer 1
apply (subgoal_tac "A = A0 \<and> A = A1 \<and> B = B0 \<and> B = B1 \<and> C0 = C1 \<and> C = C0 + 10")
apply clarsimp defer 1
apply (case_tac LREV, simp_all)
defer 1
apply (subgoal_tac "C0 = 13 \<and> A0 = 0") apply clarsimp
defer 1
apply (subgoal_tac "C0 = 13 \<and> A0 = 0") apply clarsimp
prefer 3
apply (erule_tac x=L in allE)
apply (erule_tac x=LREV in allE)
apply (erule DomLength.elims, simp_all)
apply clarsimp
apply (rule vdm_conseq)
apply (rule vdm_basics)+
apply (rule vdm_ax, simp)
(*again apply clarsimp does not terminate for 15mins, so let's do it by hand*)
apply (simp add: specf specf1)
apply rule
apply simp
apply rule
apply simp
apply rule
apply simp
apply (rule, simp)+
apply rule
apply rule
apply (erule exE)+
apply simp
apply (((erule conjE)+),((erule exE)+))+
apply rule
apply (((erule conjE)+),((erule exE)+))+
apply clarify
apply (erule conjE)+
apply (erule exE)+
apply (erule conjE)+
apply (erule exE)+
apply (erule conjE)+
apply (erule exE)+
apply (erule conjE)+
apply (erule exE)+
apply (erule conjE)+
apply (erule exE)+
apply (simp add: specf)
apply clarsimp
apply (erule DomLength.elims,simp_all)
apply clarsimp
apply (case_tac "LREV = 0")
  (*case LREV=0*)
  apply clarsimp
  defer 1
  defer 1
  prefer 2
  apply clarsimp
  apply (case_tac "L = 0")
  apply (case_tac "LREV = 0")
   apply clarsimp defer 1
   apply (subgoal_tac "C = 10 + C1")
   apply clarsimp defer 1 defer 1
  apply (case_tac "LREV = 0")
   apply clarsimp defer 1
  
  apply(simp add: specf0)
  apply clarsimp
  apply (erule DomLength.elims, simp_all)
  apply clarsimp
  apply (erule DomLength.elims, simp_all)
  apply clarsimp
  defer 1 (*first result: C0 = 13*) 
  (*case i \<noteq> 0*)
  apply clarsimp
  apply(simp add: specf0 specf4)
  apply clarsimp
  apply (erule DomLength.elims, simp_all)
  apply clarsimp
  defer 1 (*result: get A0 from C0*)

apply (case_tac "i = 0")
  (*case i=0*)
  apply clarsimp
  apply(simp add: specf0)
  apply clarsimp
  apply (erule DomLength.elims, simp_all)
  apply clarsimp
  apply (erule DomLength.elims, simp_all)
  apply clarsimp
  defer 1 (*first result: C0 = 13*) 
  (*case i \<noteq> 0*)
  apply clarsimp
  apply(simp add: specf0 specf4)
  apply clarsimp
  apply (erule DomLength.elims, simp_all)
  apply clarsimp
  defer 1 (*result: get A0 from C0*)
apply (sugoal_tac "fa = f4")
apply clarsimp
apply (rule vdm_conseq)
apply (rule vdm_basics)+
apply (rule vdm_ax, simp)
apply clarsimp
apply (case_tac "i = 0")
  (*case i=0*)
  apply clarsimp
  apply (erule LocLength.elims, simp_all)
  apply (erule LocLength.elims, simp_all)
  apply clarsimp defer 1 (*first result: C0 = 13*) 
  (*case i\<noteq>0*)
  apply clarsimp
  apply (erule LocLength.elims, simp_all)
  apply clarsimp defer 1
apply (case_tac "fa = f1")
(*case fa = f1*)
apply clarsimp
apply (rule vdm_conseq)
apply (rule vdm_basics)+
apply (rule vdm_ax)
apply simp
apply rule
apply simp
apply rule
apply rule
apply rule
apply rule
apply rule
apply simp
apply rule
apply rule
apply (erule exE)
apply (erule exE)
apply simp
apply (erule conjE, simp,erule exE, simp)
apply (erule conjE)
apply (erule exE)+
apply simp
apply (erule conjE)+
apply (erule exE)+
apply simp
apply (erule conjE)+
apply (erule exE)+
apply simp
apply ((erule conjE)+, (erule exE)+, simp)+
apply (erule conjE)+
apply clarsimp
apply (erule_tac x=L in allE)
apply (erule_tac x=LREV in allE)
apply (subgoal_tac "(\<exists>rla. refhp aaa TL rl = Ref rla \<and>
                 (\<exists>X. (L, rla, X,
                       \<lparr>oheap = objhp aaa, iheap = (inthp aaa)(TAG := (inthp aaa TAG)(rl := 1), HD := inthp aaa HD),
                          rheap = (refhp aaa)(TL := (refhp aaa TL)(rl := Ref rlrev))\<rparr>)
                      \<in> LocLength \<and>
                      (\<exists>Z. (LREV, rl, Z,
                            \<lparr>oheap = objhp aaa, iheap = (inthp aaa)(TAG := (inthp aaa TAG)(rl := 1), HD := inthp aaa HD),
                               rheap = (refhp aaa)(TL := (refhp aaa TL)(rl := Ref rlrev))\<rparr>)
                           \<in> LocLength \<and>
                           X \<inter> Z = {})))")
apply clarsimp defer 1
  apply (erule LocLength.elims, simp_all, clarsimp)
  apply (rule_tac x=Xa in exI)
apply rule
apply (rule CONS_LocL)
apply simp
apply (rotate_tac -3)
apply (erule LocLength.elims, simp_all)
apply rule
apply (case_tac "TAG = HD", clarsimp+)
apply clarify
oops
apply clarsimp
apply (case_tac "i = 0")
  (*case i=0*)
  apply clarsimp
  apply (erule LocLength.elims, simp_all)
  apply (erule LocLength.elims, simp_all)
  apply clarsimp defer 1 (*first result: C0 = 13*) 
  (*case i\<noteq>0*)
  apply clarsimp
  apply (erule LocLength.elims, simp_all)
  apply clarsimp defer 1

  apply (erule_tac x=0 in allE)
  apply (erule_tac x=LREV in allE)
  apply (subgoal_tac "(\<exists>X. (0, la, X, hp) \<in> LocLength \<and> (\<exists>Z. (LREV, rlrev, Z, hp) \<in> LocLength \<and> X \<inter> Z = {}))")
  apply simp
  apply (rule_tac x=Xa in exI, simp, rule)
  apply (rule NIL_LocL, simp, simp, simp)
  apply (rule_tac x=Z in exI, simp)
  (*case i \<noteq> 0*)
  apply clarsimp
  apply (erule_tac x=L in allE)
  apply (erule_tac x=LREV in allE)
  apply (subgoal_tac "(\<exists>X. (L, rl, X, aa) \<in> LocLength \<and> (\<exists>Z. (LREV, rlrev, Z, aa) \<in> LocLength \<and> X \<inter> Z = {}))")
  apply simp
  apply (rule_tac x=X in exI, simp)
  apply (rule_tac x=Z in exI, simp)

  apply (rule NIL_LocL, simp, simp, simp)
  apply (rule_tac x=Z in exI, simp)
  apply (erule models.elims, simp_all)
  apply clarsimp
  apply (erule_tac x="length t" in allE)
  apply auto
done
apply clarsimp
apply (rule HCallRecPrePostInvAdapt)
apply simp
apply (rule, rule, rule, rule refl, rule refl)
apply (rule HSP)
apply (rule hoarebasics)+
apply (erule assume_adapt)
apply (rule subset_refl)
apply (rule hoarebasics)+
apply (erule assume_adapt)
apply (rule subset_refl)
prefer 2
  apply fastsimp
apply (insert vardistinct)
apply clarsimp
apply (erule LocLength.elims, clarsimp+)
apply (erule LocLength.elims, clarsimp+)
apply(rule_tac x=0 in exI, rule_tac x=i in exI, simp)
apply(rule_tac x="{la}" in exI, simp, rule)
apply (rule NIL_LocL, fastsimp, fastsimp, fastsimp)
apply(rule_tac x="X - {laa}" in exI, rule)
apply(subgoal_tac "la \<notin> X - {laa}")
prefer 2 apply fastsimp
apply(subgoal_tac "laa \<notin> X - {laa}")
prefer 2 apply fastsimp
defer 1 (*apply fastsimp??*)
apply fastsimp
apply (erule LocLength.elims, clarsimp+)
apply(rule_tac x=i in exI, rule_tac x=1 in exI, simp)
apply(rule_tac x="Xa - {la}" in exI, rule)
apply(subgoal_tac "la \<notin> Xa - {la}", fastsimp, fastsimp)
apply(rule_tac x="{la,laa}" in exI, rule)
apply(rule CONS_LocL)
apply fastsimp+
apply (rule NIL_LocL)
apply (fastsimp, fastsimp, fastsimp, fastsimp)
apply clarsimp
apply(rule_tac x=i in exI, rule_tac x="ia + 2" in exI, simp)
apply(rule_tac x="Xa - {la}" in exI, rule)
apply(subgoal_tac "la \<notin> Xa - {la}", fastsimp, fastsimp)
apply(rule_tac x="Xb Un {la}" in exI, rule)
apply(rule CONS_LocL, fastsimp+)
apply(rule CONS_LocL)
apply fastsimp
apply fastsimp
apply fastsimp
apply (subgoal_tac "refhp \<lparr>objhp = oheap ba, inthp = (iheap ba)(TAG := (iheap ba TAG)(la := 1), HD := iheap ba HD),
                   refhp = (rheap ba)(TL := (rheap ba TL)(la := Ref laa))\<rparr>
           TL laa =
          Ref tta")
apply fastsimp
apply fastsimp
apply fastsimp
apply fastsimp
apply (subgoal_tac "Xb \<union> {la} - {la} - {laa} = Xb - {laa}")
apply clarsimp
apply fastsimp
apply fastsimp
apply fastsimp
oops (* the deferred goal should be provable by fastsimp but isn't*)


locale App = 
  fixes    tag :: iname and h :: iname and b :: iname and one  :: iname and zero :: iname
    and    l   :: rname and m :: rname and t :: rname and lrev :: rname
    and	   f   :: funame and fBody   :: "int expr"
 defines  "fBody == PRE {(H,s). HSize s = H} :
                    POST {(H,s,v) . HSize s = H} :
                    LET tag = GetFi l TAG;
                        b   = Primop (% x y. if x < 1 then 1 else 0) tag tag 
                    IN IF b THEN LET tag = GetFi lrev TAG;
                                     b   = Primop (% x y. if x < 1 then 1 else 0) tag tag 
                                 IN IF b THEN RVar m
                                         ELSE LET h       = GetFi lrev HD;
                                                  rf t    = GetFr lrev TL;
                                                  zero    = expr.Int 0;
                                                  zero    = PutFi l TAG zero;
                                                  one     = expr.Int 1;
                                                  one     = PutFi lrev TAG one;
                                                  h       = PutFi lrev HD h;
                                                  rf m    = PutFr lrev TL m;
                                                  rf m    = RVar lrev;
                                                  rf lrev = RVar t 
                                              IN CALL f 
                                              END
                                 END
                            ELSE LET h       = GetFi l HD;
                                     rf t    = GetFr l TL;
                                     one     = expr.Int 1;
                                     one     = PutFi l TAG one;
                                     h       = PutFi l HD h;
                                     rf lrev = PutFr l TL lrev;
                                     rf lrev = RVar l;
                                     rf l    = RVar t 
                                 IN CALL f END
                    END"

  assumes  fbdy[simp]:  "funtable f = fBody"
      and  vardistinct: "distinct [tag,h,b,one,zero] \<and> distinct [zero,one,b,h,tag] \<and> distinct[l,m,t,lrev] \<and> distinct [lrev,t,m,l]"


declare (in App) fBody_def [simp]
lemma (in App)
"\<Turnstile> {(H,s). HSize s = H} (CALL f) {(H,s,v) . HSize s = H}"
apply (insert vardistinct, clarsimp)
apply (rule HCallRec)
apply simp
apply(rule HPre)
apply(rule HPost)
apply (rule HSP)
apply (rule hoarebasics)+
apply assumption
apply (rule subset_refl)
apply (rule hoarebasics)+
apply assumption
apply (rule subset_refl)
by (clarsimp, simp, fastsimp)

locale AppendClock = 
  fixes    tag :: iname and h :: iname and b :: iname and one  :: iname and zero :: iname
    and    l   :: rname and m :: rname and t :: rname and lrev :: rname
    and	   f   :: funame and fBody   :: "(nat \<times> nat \<times> nat \<times> int \<times> (ref set) \<times> (ref set) \<times> (ref set)) expr"
 defines  "fBody == PRE {((L,M,LREV,C,X,Y,Z),s). clock s = C \<and> 
                                                (L,s\<lfloor>l\<rfloor>,X,getheap s) \<in> LLength \<and> 
                                                (M,s\<lfloor>m\<rfloor>,Y,getheap s) \<in> LLength \<and> 
                                                (LREV,s\<lfloor>lrev\<rfloor>,Z,getheap s) \<in> LLength \<and>
                                                 X Int Y = {} \<and> X Int Z = {} \<and> Y Int Z = {}}:
                    POST {((L,M,LREV,C,X,Y,Z),s,v) . clock s = C + 47 * (int LREV) + 33 * (int L) + 17} :
                    LET tag = GetFi l TAG;
                        b   = Primop (% x y. if x < 1 then 1 else 0) tag tag 
                        (*7 steps until here*)
                    IN IF b THEN LET tag = GetFi lrev TAG;
                                     b   = Primop (% x y. if x < 1 then 1 else 0) tag tag 
                                     (*15 steps until here*)
                                 IN IF b THEN RVar m (*17*)
                                         ELSE LET h       = GetFi lrev HD;
                                                  rf t    = GetFr lrev TL;
                                                  zero    = expr.Int 0;
                                                  zero    = PutFi l TAG zero;
                                                  one     = expr.Int 1;
                                                  one     = PutFi lrev TAG one;
                                                  h       = PutFi lrev HD h;
                                                  rf m    = PutFr lrev TL m;
                                                  rf m    = RVar lrev;
                                                  rf lrev = RVar t 
                                              IN CALL f (*47*)
                                              END
                                 END
                            ELSE LET h       = GetFi l HD;
                                     rf t    = GetFr l TL;
                                     one     = expr.Int 1;
                                     one     = PutFi l TAG one;
                                     h       = PutFi l HD h;
                                     rf lrev = PutFr l TL lrev;
                                     rf lrev = RVar l;
                                     rf l    = RVar t 
                                 IN CALL f END (*33*) 
                    END"

  assumes  fbdy[simp]:  "funtable f = fBody"
      and  vardistinct:     "distinct [tag,h,b,one,zero] \<and> distinct [zero,one,b,h,tag] \<and> distinct[l,m,t,lrev] \<and> distinct [lrev,t,m,l]"


declare (in AppendClock) fBody_def [simp]
declare getheap_def [simp]

lemma (in AppendClock)
"TAG \<noteq> HD \<and> HD \<noteq> TAG \<longrightarrow> 
 \<Turnstile> {((L,M,LREV,C,X,Y,Z),s). clock s = C \<and> (L,s\<lfloor>l\<rfloor>,X,getheap s) \<in> LLength \<and> 
                                           (M,s\<lfloor>m\<rfloor>,Y,getheap s) \<in> LLength \<and> 
                                           (LREV,s\<lfloor>lrev\<rfloor>,Z,getheap s) \<in> LLength \<and>
                                           X Int Y = {} \<and> X Int Z = {} \<and> Y Int Z = {}}
   (CALL f)
   {((L,M,LREV,C,X,Y,Z),s,v) . clock s = C + 47 * (int LREV) + 33 * (int L) + 18}"
apply clarsimp
apply (rule HCallRecPrePostInvAdapt)
apply simp
apply (rule, rule, rule, rule refl, rule refl)
apply (rule HSP)
apply (rule hoarebasics)+
apply (erule assume_adapt)
apply (rule subset_refl)
apply (rule hoarebasics)+
apply (erule assume_adapt)
apply (rule subset_refl)
apply (insert vardistinct)
apply clarsimp
apply rule
apply rule
apply (subgoal_tac "ab = 0 \<and> baa<baa\<lceil>lrev\<rceil>\<bullet>TAG> = 0")
  prefer 2
  apply(rotate_tac 8)
  apply (erule LLength.elims, clarsimp, clarsimp)
apply clarsimp
apply rule
apply rule
apply (subgoal_tac "a = 0 \<and> baa<baa\<lceil>l\<rceil>\<bullet>TAG> = 0")
  prefer 2
  apply (erule LLength.elims, clarsimp, clarsimp)
apply clarsimp
apply rule
apply (subgoal_tac "\<exists> N . a = Suc N \<and> baa<baa\<lceil>l\<rceil>\<bullet>TAG> = 1")
  prefer 2
  apply (erule LLength.elims, clarsimp, clarsimp)
apply clarsimp
apply (subgoal_tac "\<exists> rlrev . baa\<lfloor>lrev\<rfloor> = Ref rlrev \<and> fmap_lookup (objhp \<lparr>objhp = oheap baa, inthp = iheap baa, refhp = rheap baa\<rparr>) rlrev = Some LST \<and> inthp \<lparr>objhp = oheap baa, inthp = iheap baa, refhp = rheap baa\<rparr> TAG rlrev = 0 \<and> Ref rlrev \<in> ba")
prefer 2
  apply(rotate_tac 8)
  apply(erule LLength.elims, clarsimp, clarsimp)
apply clarsimp
apply (subgoal_tac "\<exists> rl . baa\<lfloor>l\<rfloor> = Ref rl")
prefer 2
  apply(erule LLength.elims, clarsimp, clarsimp)
apply clarsimp
apply (rule_tac x=N in exI)
apply (rule_tac x="aa" in exI)
apply (rule_tac x="Suc 0" in exI)
apply rule
apply (erule LLength.elims, clarsimp, clarsimp)
apply (rule_tac x="X - {Ref la}" in exI)
apply rule
apply (subgoal_tac "(i, baa\<lfloor>la\<diamondsuit>TL\<rfloor>, X - {Ref la},
           \<lparr>objhp = oheap baa, inthp = (iheap baa)(TAG := (iheap baa TAG)(la := 1)),
              refhp = (rheap baa)(TL := (rheap baa TL)(la := baa\<lfloor>lrev\<rfloor>))\<rparr>)
          \<in> LLength")
prefer 2
apply clarsimp
apply fastsimp
apply (rule_tac x="ae" in exI)
apply rule
apply fastsimp
apply (rule_tac x="{Ref la, Ref rlrev}" in exI)
apply rule
apply (rule CONS_LL)
apply fastsimp
apply fastsimp
apply fastsimp
apply fastsimp
apply fastsimp
apply fastsimp
apply(rule NIL_LL)
apply fastsimp
apply fastsimp
apply fastsimp
apply rule
oops
end
(*AppendClock2 is the variant where the heap domains of the lists are not carried around as auxiliary varaibles
  but asserted as part of the pre-condition*)
locale AppendClock2 = 
  fixes    tag :: iname and h :: iname and b :: iname and one  :: iname and zero :: iname
    and    l   :: rname and m :: rname and t :: rname and lrev :: rname
    and	   f   :: funame and fBody   :: "(nat \<times> nat \<times> nat \<times> int) expr"
 defines  "fBody == PRE {((L,M,LREV,C),s). \<exists> X Y Z . (clock s = C \<and> 
                                            (L,s\<lfloor>l\<rfloor>,X,s) \<in> LLength \<and> (M,s\<lfloor>m\<rfloor>,Y,s) \<in> LLength \<and> (LREV,s\<lfloor>lrev\<rfloor>,Z, s) \<in> LLength \<and>
                                                 X Int Y = {} \<and> X Int Z = {} \<and> Y Int Z = {} \<and> 
                                                 s\<lfloor>l\<rfloor> \<notin> (X Un Y Un Z Un {s\<lfloor>m\<rfloor> ,s\<lfloor>lrev\<rfloor>}) \<and> s\<lfloor>m\<rfloor> \<notin> (X Un Y Un Z Un {s\<lfloor>l\<rfloor>,s\<lfloor>lrev\<rfloor>}) \<and> 
                                                 s\<lfloor>lrev\<rfloor> \<notin> (X Un Y Un Z Un {s\<lfloor>l\<rfloor>,s\<lfloor>m\<rfloor>}))} :
                    POST {((L,M,LREV,C),s,v) . clock s = C + 47 * (int LREV) + 33 * (int L) + 17} :
                    LET tag = GetFi l TAG;
                        b   = Primop (% x y. if x < 1 then 1 else 0) tag tag 
                        (*7 steps until here*)
                    IN IF b THEN LET tag = GetFi lrev TAG;
                                     b   = Primop (% x y. if x < 1 then 1 else 0) tag tag 
                                     (*15 steps until here*)
                                 IN IF b THEN RVar m (*17*)
                                         ELSE LET h       = GetFi lrev HD;
                                                  rf t    = GetFr lrev TL;
                                                  zero    = expr.Int 0;
                                                  zero    = PutFi l TAG zero;
                                                  one     = expr.Int 1;
                                                  one     = PutFi lrev TAG one;
                                                  h       = PutFi lrev HD h;
                                                  rf m    = PutFr lrev TL m;
                                                  rf m    = RVar lrev;
                                                  rf lrev = RVar t 
                                              IN CALL f (*47*)
                                              END
                                 END
                            ELSE LET h       = GetFi l HD;
                                     rf t    = GetFr l TL;
                                     one     = expr.Int 1;
                                     one     = PutFi l TAG one;
                                     h       = PutFi l HD h;
                                     rf lrev = PutFr l TL lrev;
                                     rf lrev = RVar l;
                                     rf l    = RVar t 
                                 IN CALL f END (*33*) 
                    END"

  assumes  fbdy[simp]:  "funtable f = fBody"
      and  vardistinct:     "distinct [tag,h,b,one,zero] \<and> distinct [zero,one,b,h,tag] \<and> distinct[l,m,t,lrev] \<and> distinct [lrev,t,m,l]"


declare (in AppendClock2) fBody_def [simp]

(*The proof is exactly as before*)
lemma (in AppendClock2)
"\<Turnstile> {((L,M,LREV,C),s). clock s = C \<and> (L,s\<lfloor>l\<rfloor>,X,s) \<in> LLength \<and> (M,s\<lfloor>m\<rfloor>,Y,s) \<in> LLength \<and> (LREV,s\<lfloor>lrev\<rfloor>,Z,s) \<in> LLength \<and>
                                           X Int Y = {} \<and> X Int Z = {} \<and> Y Int Z = {} \<and> 
                                           s\<lfloor>l\<rfloor> \<notin> (X Un Y Un Z Un {s\<lfloor>m\<rfloor> ,s\<lfloor>lrev\<rfloor>}) \<and> s\<lfloor>m\<rfloor> \<notin> (X Un Y Un Z Un {s\<lfloor>l\<rfloor>,s\<lfloor>lrev\<rfloor>}) \<and> 
                                           s\<lfloor>lrev\<rfloor> \<notin> (X Un Y Un Z Un {s\<lfloor>l\<rfloor>,s\<lfloor>m\<rfloor>})}
   (CALL f)
   {((L,M,LREV,C),s,v) . clock s = C + 47 * (int LREV) + 33 * (int L) + 18}"
apply (rule HCallRecPrePostInvAdapt)
apply simp
apply (rule, rule, rule, rule refl, rule refl)
apply (rule HSP)
apply (rule hoarebasics)+
apply (erule assume_adapt)
apply (rule subset_refl)
apply (rule hoarebasics)+
apply (erule assume_adapt)
apply (rule subset_refl)
(*now only side conditions left*)
apply (insert vardistinct)
apply clarsimp
apply rule
apply rule
apply rule
apply rule
apply (erule LLength.elims, clarsimp)
apply (erule LLength.elims, clarsimp)
apply (erule LLength.elims, clarsimp)
apply clarsimp
apply clarsimp
apply clarsimp
apply clarsimp
apply (rule_tac x="0" in exI, clarsimp)
apply rule
apply (erule LLength.elims, clarsimp, clarsimp)
apply (erule LLength.elims, clarsimp, clarsimp)
apply rule
apply rule
apply rule
apply (rule_tac x="0" in exI, clarsimp)
apply (erule LLength.elims, clarsimp, clarsimp)
apply rule
apply (rule_tac x="0" in exI, clarsimp)
apply (erule LLength.elims, clarsimp, clarsimp)
(*last goal*)
apply clarsimp
apply (rule_tac x="0" in exI, clarsimp)
apply (rule, erule LLength.elims, clarsimp, rule NIL_LL, simp)
apply clarsimp
apply (rule)
by (rule_tac x="0" in exI,
    (erule LLength.elims, clarsimp)+,
    rule NIL_LL, clarsimp+)+


end
