theory Inheritance = VDMderived5:

section {* Functional correctness and resource correctness *}
(*
class A{
  int f
  method int m(p) = self.f
}
class B{
  method int m(p) = let x = self.f in x + x end
}
*)
locale inherit = 
  fixes    A :: cname and B :: cname and f :: ifldname and m :: mname and x :: iname and z :: rname and p :: rname
 assumes Ameth[simp]: "methtable A m == (GetFi self f)::'a expr"
     and Bmeth[simp]: "methtable B m == ((LET x = GetFi self f IN Primop (\<lambda> a b . a + b) x x END)::'a expr)"
      and  vardistinct: "distinct [A,B] \<and> distinct [B,A] \<and> distinct [p,z] \<and> distinct [z,p] \<and>
                         (\<forall> E h a C. (qach_QaQ E h a z C \<longrightarrow> C = A \<or> C = B))"
      and Aspec: 
          "Mspectable A m = {(E,h,hh,v,p) . 
                             \<forall> a . (E\<lfloor>z\<rfloor> = Ref a \<longrightarrow> 
                                    (v = IVal ((heap.iheap h) f a) \<and> hh = h \<and> 
                                     p = \<langle>7 0 1 1\<rangle>))}"
      and Bspec: 
          "Mspectable B m = {(E,h,hh,v,p) . 
                             \<forall> a . (E\<lfloor>z\<rfloor> = Ref a \<longrightarrow> 
                                    (v = IVal ((heap.iheap h) f a + (heap.iheap h) f a) \<and> hh = h \<and> 
                                     p = \<langle>11 0 1 1\<rangle>))}"
  and  allclasses:    "all_classes = {A,B}"

lemma (in inherit) "\<rhd> ((z\<diamondsuit>m(p))::'a expr) : 
                     {(E,h,hh,v,p) . \<forall> a C. ((qach_QaQ E h a z C \<longrightarrow> 
                                                   (E,h,hh,v,p) : Mspectable C m))}"
apply (insert vardistinct)
apply (insert allclasses)
apply clarsimp
apply (rule vdm_invoke)
apply clarsimp
apply (case_tac "C = A", clarsimp)
apply (rule vdm_conseq)
apply (rule vdm_basics)+
apply clarsimp
apply (simp add: qach_QaQ_def Aspec)
apply (case_tac "C = B", clarsimp)
apply (rule vdm_conseq)
apply (rule vdm_basics)+
apply clarsimp
apply (simp add: qach_QaQ_def Bspec)
oops

lemma (in inherit) "\<rhd> ((z\<diamondsuit>m(p))::'a expr) : 
                    {(E,h,hh,v,p) . \<forall> a. ((qach_QaQ E h a z A \<longrightarrow> (E,h,hh,v,p) : Mspectable A m) \<and> 
                                           (qach_QaQ E h a z B \<longrightarrow> (E,h,hh,v,p) : Mspectable B m))}"
apply (insert vardistinct)
apply clarsimp
apply (rule vdm_invoke)
apply clarsimp
apply (case_tac "C = A", clarsimp)
apply (rule vdm_conseq)
apply (rule vdm_basics)+
apply clarsimp
apply (simp add: qach_QaQ_def Aspec, clarsimp)
apply (case_tac "C = B", clarsimp)
apply (rule vdm_conseq)
apply (rule vdm_basics)+
apply clarsimp
apply (simp add: qach_QaQ_def Bspec, clarsimp)
oops

lemma "P --> G \<rhd> e:{(E,h,hh,v,p) . Q} --> 
       G \<rhd> e:{(E,h,hh,v,p) . P --> Q}"
apply clarsimp
done
lemma "G \<rhd> e:{(E,h,hh,v,p) . P --> Q} --> P -->
       G \<rhd> e:{(E,h,hh,v,p) . Q}"
apply clarsimp
done

(*no class restriction as part of vardistinct*)
locale inherit2 = 
  fixes    A :: cname and B :: cname and f :: ifldname and m :: mname and x :: iname and z :: rname and p :: rname
 assumes Ameth[simp]: "methtable A m == (GetFi self f)::'a expr"
     and Bmeth[simp]: "methtable B m == ((LET x = GetFi self f IN Primop (\<lambda> a b . a + b) x x END)::'a expr)"
      and  vardistinct: "distinct [A,B] \<and> distinct [B,A] \<and> distinct [p,z] \<and> distinct [z,p]"
      and Aspec: 
          "Mspectable A m = {(E,h,hh,v,p) . 
                             \<forall> a . (E\<lfloor>z\<rfloor> = Ref a \<longrightarrow> 
                                    (v = IVal ((heap.iheap h) f a) \<and> hh = h \<and> 
                                     p = \<langle>7 0 1 1\<rangle>))}"
      and Bspec: 
          "Mspectable B m = {(E,h,hh,v,p) . 
                             \<forall> a . (E\<lfloor>z\<rfloor> = Ref a \<longrightarrow> 
                                    (v = IVal ((heap.iheap h) f a + (heap.iheap h) f a) \<and> hh = h \<and> 
                                     p = \<langle>11 0 1 1\<rangle>))}"

lemma (in inherit2) "\<rhd> ((z\<diamondsuit>m(p))::'a expr) : 
                     {(E,h,hh,v,p) . (\<forall> E h a C. (qach_QaQ E h a z C \<longrightarrow> C = A \<or> C = B) --> (\<forall> a. ((qach_QaQ E h a z A \<and> (E,h,hh,v,p) : Mspectable A m) \<or> 
                                           (qach_QaQ E h a z B \<and> (E,h,hh,v,p) : Mspectable B m))))}"
apply (insert vardistinct)
apply clarsimp
apply (rule vdm_invoke)
apply clarsimp
apply (case_tac "C = A", clarsimp)
apply (rule vdm_conseq)
apply (rule vdm_basics)+
apply clarsimp
apply (simp add: qach_QaQ_def Aspec)
apply clarsimp
apply (case_tac "C = B", clarsimp)
apply (rule vdm_conseq)
apply (rule vdm_basics)+
apply clarsimp
apply (simp add: qach_QaQ_def Bspec)
oops

end
