(*  
   File:	$RCSfile: ExampleEvenOdd.thy,v $
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ExampleEvenOdd.thy,v 1.2 2003/09/03 12:03:10 lenb Exp $

   Example of mutual recursive functions using VDM style
*)

theory ExampleEvenOdd = Prelude + Lemmas + VDMderived: 

constdefs
 Even :: "int \<Rightarrow> bool"
 "Even i \<equiv> \<exists> k. i=2*k"
 Odd :: "int \<Rightarrow> bool"
 "Odd i \<equiv> \<exists> k. i=2*k+1"

lemma [simp]: "Even (x + 1) = Odd(x)"
by (simp add: Even_def Odd_def, arith)

lemma [simp]:  "Odd(x + 1) = Even(x)"
by (simp add: Even_def Odd_def)
(* arith failed, presburger succeeded! *)

(* the next two lemmas aren't really needed, just simplify a bit more *)
lemma [simp]: "(\<not> Odd(x)) = Even(x)"
by (simp add: Even_def Odd_def, arith)

lemma [simp]: "(\<not> Even(x)) = Odd(x)"
by (simp add: Even_def Odd_def, arith)

lemma [simp]: "Odd 0 = False"
by (simp add: Odd_def, arith)

lemma [simp]: "Even 0 = True"
by (simp add: Even_def)


lemma bonzo_999: "Even x --> \<not> Odd x"
by (simp add: Even_def Odd_def, arith)

lemma bonzo_998: "Odd x --> \<not> Even x"
by (simp add: Even_def Odd_def, arith)

(* ngoqvam moHbogh vImuSqu' !!!! *)
lemma bonzo_997: "0 < x --> Even (x) = Odd(x - 1)"
by (simp add: Even_def Odd_def, arith)

(* ngoqvam moHbogh vImuSqu' !!!! *)
lemma bonzo_996: "0 < x --> Odd (x) = Even (x - 1)"
by (simp add: Even_def Odd_def, arith)

lemma bonzo_995: "0 <= x ==> Odd x --> 0 < x"
by (simp add: Even_def Odd_def, arith)
                   
locale evenodd_example =
  fixes    x :: iname
  fixes    b :: iname
  fixes	   even    :: funame
  fixes    odd     :: funame
  and eClockF :: nat and oClockF :: nat and eClockC :: nat and oClockC :: nat 
  and eCallcF :: nat and oCallcF :: nat and eCallcC :: nat and oCallcC :: nat 

  defines "eClockF == 11"
  and "oClockF == 11"
  and "eCallcF == 1"
  and "oCallcF == 1"
  and "eClockC == 12"
  and "oClockC == 12"
  and "eCallcC == 1"
  and "oCallcC == 1"

  assumes funtable_even:
  "funtable even = ((LET   b = x :0?; x = x :-- IN IF b THEN tt ELSE CALL odd END)::'a expr)"
  and funtable_odd:
  "funtable odd = ((LET   b = x :0?; x = x :-- IN IF b THEN ff ELSE CALL even END)::'a expr)"

  and  vardistinct:   "distinct[b,x] \<and> distinct[x,b] \<and> even \<noteq> odd \<and> odd \<noteq> even"

  and spectable_even:
  "spectable even = {(E,h,hh,v,p) . 0 <= E<x> \<longrightarrow> h = hh \<and> p = \<langle>(eClockF * (nat E<x>) + eClockC) (eCallcF * (nat E<x>) + eCallcC) 0 0\<rangle> \<and> 
                                                  v = IVal (grailbool (Even(E<x>)))}"
  and spectable_odd:
  "spectable odd = {(E,h,hh,v,p) . 0 <= E<x> \<longrightarrow> h = hh \<and> p = \<langle>(oClockF * (nat E<x>) + oClockC) (oCallcF * (nat E<x>) + oCallcC) 0 0\<rangle> \<and> 
                                                 v = IVal (grailbool (Odd(E<x>)))}"

lemma (in evenodd_example)
"\<rhd> ((Call even)::'a expr) : spectable even"
apply (insert vardistinct)
apply (rule MUTREC)
apply (subgoal_tac "finite {((Call even)::'a expr, spectable even), ((Call odd)::'a expr, spectable odd)}")
apply assumption
apply simp
apply simp
apply simp
prefer 2 apply simp
apply (simp add: consistent_def)
apply clarsimp
apply rule
apply clarsimp
apply (simp add: funtable_even)
apply (rule vdm_conseq)
apply (rule vdm_basics)+
apply (rule vdm_ax)
apply fast
apply clarsimp
defer 1
apply clarsimp
apply (simp add: funtable_odd)
apply (rule vdm_conseq)
apply (rule vdm_basics)+
apply (rule vdm_ax)
apply fast
apply clarsimp
(* end of simulating vcg*)
apply (simp_all add: spectable_even spectable_odd Even_def Odd_def eCallcC_def 
                     oCallcC_def eClockC_def oClockC_def eCallcF_def oCallcF_def
                     eClockF_def oClockF_def)
apply (rule, clarsimp)
apply (case_tac "a<x> = 0", clarsimp) 
apply arith
apply clarsimp
apply arith
apply (case_tac "a<x> = 0", clarsimp) 
apply clarsimp
apply (rule, arith)
apply (rule, arith)
apply clarsimp
apply (erule_tac x = k in allE, simp)
apply (case_tac "a<x> = 0", clarsimp) 
apply clarsimp
apply rule
apply clarsimp
apply (rule, arith)
apply (rule, arith)
apply (rule_tac x="k - 1" in exI, simp)
apply clarsimp
apply (rule, arith)
apply (rule, arith)
apply clarsimp
apply (erule_tac x="k + 1" in allE, simp)
done
end
