(*  
   File:	ExampleCount
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ExampleCount.thy,v 1.1 2003/07/25 15:37:30 lenb Exp $

   Resource usage properties for very simple recursive function.
*)

theory ExampleCount = VDM + Prelude + Lemmas:

locale count_example =
  fixes    one        :: iname
    and	   n          :: iname
    and	   b          :: iname
    and    Count      :: cname
    and	   countfn    :: funame

assumes  countfnbdy[simp]:  
"funtable countfn = 
   LET one = 1\<^sup>z; 
       n = n :--;
       b = n :< one
   IN 
     IF b THEN expr.Int 42 ELSE CALL countfn
   END"

and  vardistinct:   "distinct [one,n,b] \<and> distinct [b,n,one]"

lemma (in count_example)  
   "\<rhd> (CALL countfn) : 
    {(E,h,hh,v,p). 0 < E<n> \<longrightarrow> (v = IVal 42 \<and> clock p = nat(13 * E<n> + 1) \<and> callc p = nat (E<n>))}"
apply (rule vdm_call, simp)
apply (rule vdm_conseq)
apply (rule vdm_leti)
apply (rule vdm_int)
apply (rule vdm_leti)
apply (rule vdm_prim)
apply (rule vdm_leti)
apply (rule vdm_prim)
apply (rule vdm_if)
apply (rule vdm_int)
apply (rule vdm_ax, simp)
apply (insert vardistinct)
apply clarsimp
apply auto
apply (subgoal_tac "a<n> = 1", simp)
apply (case_tac "a<n> < 2", simp, simp)
apply (subgoal_tac "a<n> = 1", simp)
apply (case_tac "a<n> < 2", simp, simp)
apply (subgoal_tac "a<n> = 1", simp)
apply (case_tac "0 < a<n> - 1", simp, simp)
apply (subgoal_tac "a<n> = 1", simp)
apply (case_tac "0 < a<n> - 1", simp, simp)
apply (subgoal_tac "a<n> = 1", simp)
apply (case_tac "a<n> < 2", simp, simp)
apply (subgoal_tac "a<n> = 1", simp)
apply (case_tac "a<n> < 2", simp, simp)
apply (arith)+
done
end
