(* Time-stamp: <Mon Sep 29 2003 15:41:33 Stardate: [-29]0972.85 hwloidl>
   Example for aliasing as used by Abadi/Leino
*)

theory ExAlias = Expr + Prelude + VDM5: (* VDMderived5: *)

subsection {* Testing aliases *}

(* org: let x = [f=true] in let y = x in (y.f := false; x.f) *)

locale exAlias =
  fixes   c   :: rname
  fixes   x   :: rname
  fixes   y   :: rname
  fixes   z   :: iname
  fixes   f   :: ifldname
  fixes   g   :: ifldname
  fixes   finit   :: iname
  fixes   ginit   :: iname
  fixes   fmod   :: iname
  fixes   foo :: mname
  fixes   Foo :: cname
  assumes foobody[simp]: "methtable Foo foo = 
                      ((LET    finit = 0\<^sup>z ;
                               ginit = 0\<^sup>z ;
                               fmod = 1\<^sup>z ;
                            rf x     = NEW <Foo> ([(f,finit),(g,ginit)],[]) ;
                            rf y     = x\<^sup>R ;
                               _ = (y\<bullet>f := fmod) ;
                               z = x\<bullet>f
                        IN 
                          z\<^sup>I
                        END) :: 'a expr)"
  assumes vardistinct: "distinct [f,g] \<and> distinct [x,y]"
  assumes allclasses:  "all_classes = {Foo}"
(* 
   
                      ((LET x = NEW <Foo> [(f,0),(g,0)] [] ;
                            y = x ;
                            _ = y.f = 1 ;
                            z = x.f
                        IN 
                          RETURN z) :: 'a expr)"
*)
  assumes foospec[simp]: "Mspectable Foo foo = {(E,h,hh,v,p) . v = IVal (1::int)}"

(* to be used as example in assertion section of deliverable *)

subsubsection {* MH_InvokeStatic *}

lemma (in exAlias) "\<rhd> ((Foo\<bullet>\<bullet>foo)::'a expr) : 
                     {(E,h,hh,v,p) . v = IVal (1::int)}"
apply (insert vardistinct)
apply clarsimp
apply (rule vdm_mhinvokestatic)
apply simp                 (* porghvam yISach! *)
apply (rule vdm_conseq)
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) defer 1
apply (rule vdm_basics)
defer 1
apply (rule vdm_basics)
apply (rule vdm_basics)
apply (rule vdm_basics)
apply (rule vdm_basics)
apply (rule vdm_basics)
apply (rule vdm_basics)
apply (rule vdm_basics)
apply clarsimp
done
(* ok *)

lemma (in exAlias) "\<rhd> ((Foo\<bullet>\<bullet>foo)::'a expr) : 
                     {(E,h,hh,v,p) . v = IVal (0::int)}"
apply (insert vardistinct)
apply clarsimp
apply (rule vdm_mhinvokestatic)
apply simp                 (* porghvam yISach! *)
apply (rule vdm_conseq)
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) defer 1
apply (rule vdm_basics)
defer 1
apply (rule vdm_basics)
apply (rule vdm_basics)
apply (rule vdm_basics)
apply (rule vdm_basics)
apply (rule vdm_basics)
apply (rule vdm_basics)
apply (rule vdm_basics)
apply clarsimp
oops
(* False; ok *)

subsubsection {* MH_Invoke *}

lemma (in exAlias) "\<rhd> ((c\<diamondsuit>\<diamondsuit>foo)::'a expr) : 
                     {(E,h,hh,v,p) . \<forall> a C. qach_QaQ E h a c C \<longrightarrow> v = IVal (1::int)}"
apply (insert vardistinct)
apply (insert allclasses)
apply clarsimp
apply (rule vdm_mhinvoke)
apply clarsimp
apply (case_tac "C = Foo")
apply simp                 (* porghvam yISach! *)
apply (rule vdm_conseq)
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) defer 1
apply (rule vdm_basics)
defer 1
defer 1
apply (rule vdm_basics)
apply (rule vdm_basics)
apply (rule vdm_basics)
apply (rule vdm_basics)
apply (rule vdm_basics)
apply (rule vdm_basics)
apply (rule vdm_basics)
apply clarsimp
apply (insert allclasses)
apply (insert finclasses)
apply (erule_tac x="C" in allE)
apply simp
apply (case_tac "C=Foo")
 apply clarsimp
 apply (simp add: allclasses)
done
(* ok; but uses just one class; no subtyping *)

end

