(* Time-stamp: <Mon Aug 25 2003 00:34:06 Stardate: [-29]0794.70 hwloidl> *)
(* $Id: Ex2.thy,v 1.1 2003/08/24 22:50:14 a1hloidl Exp $ *)

theory Ex2 = Prelude + Lemmas + VDM2:

(* --------------------------------------------------------------------------- *)

locale example2 =
  fixes   n  :: iname
  fixes   count  :: ifldname
  fixes   x  :: rname
  fixes   y  :: rname
  fixes   a1 :: locn
  fixes   myid :: mname
  fixes   MyId :: cname
  assumes foobody: "methtable MyId myid = ((LET n = GetFi self count IN n\<^sup>I END)::'a expr)"
  (* assumes foospec: "spectable MyId myid = {(E,h,hh,v,p). v = E<x\<bullet>count> \<and> hh=h \<and> p=\<langle>1 0 0 0\<rangle>}" *)

lemma (in example2)
 "{(% s b . (((MH_Invoke s myid)::'a expr), {(E,h,hh,v,p). \<forall> a . E\<lfloor>s\<rfloor> = Ref a \<longrightarrow> v = IVal h<a\<bullet>count>}))} 
  \<rhd> (MH_Invoke x myid) : (% s b . {(E,h,hh,v,p). \<forall> a . E\<lfloor>x\<rfloor> = Ref a \<longrightarrow> v = IVal h<a\<bullet>count>}) x q"
(*
apply (rule vdm_adapt_context_with_bonzo)
apply (rule impI)
*)
(* apply (rule vdm_conseq) *)
apply (rule vdm_ax)
defer 1  (* strangely changing the order of vdm_ax's subgoal is important! *)
apply auto
done

(* --------------------------------------------------------------------------- *)

subsection {* kount (direct recursion); Version w/ MH_InvokeStatic *}

locale kount_example1 =
  fixes    one        :: iname
  fixes	   n          :: iname
  fixes	   b          :: iname
  fixes	   r          :: rname
  fixes	   count      :: ifldname
  fixes    KountClass :: cname
  fixes	   kount      :: mname
  assumes  kountbdy[simp]:  
  "methtable KountClass kount = 
   ((LET one = 1\<^sup>z; 
       n = self\<bullet>count ;
       n = n :-- ;
       _ = self\<bullet>count := n ;
       b = n :< one
   IN 
     IF b 
       THEN 0\<^sup>z
       ELSE MH_InvokeStatic KountClass kount
   END)::'a expr)"
  assumes  vardistinct:   "distinct [one,n,b] \<and> distinct [b,n,one]"
  assumes  vardistinct':  "distinct [r,self,param] \<and> distinct [param,self,r]"
  assumes  allclasses:    "all_classes = {KountClass}"

lemma (in kount_example1)  
   "\<rhd> ((MH_InvokeStatic KountClass kount) :: 'a expr) :
    (% s b . {(E,h,hh,v,(p::Semantics.renv)). (\<forall> a . (qach_QaQ E h a s KountClass \<and> 0 < h<a\<bullet>count>) \<longrightarrow> v = IVal 0 \<and> hh<a\<bullet>count> = 0)}) self param "
apply (insert vardistinct)
apply (rule vdm_mhinvokestatic)
apply simp                 (* porghvam yISach! *)
apply (rule vdm_conseq)
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) defer 1
apply (rule vdm_basics)
apply (rule vdm_basics) 
apply (rule vdm_ax) apply clarsimp defer 1 defer 1 defer 1
apply (rule vdm_basics) 
apply (rule vdm_basics)
apply (rule vdm_basics)
apply (rule vdm_basics)
apply (rule vdm_basics)
apply auto
apply (simp add: qach_QaQ_def)
apply (erule_tac x="ad" in allE)
apply clarsimp
defer 1
apply auto
apply (simp add: qach_QaQ_def)
apply (simp add: qach_QaQ_def)
apply (simp add: qach_QaQ_def)
done

subsection {* kount (direct recursion); Version w/ MH_Invoke *}

locale kount_example2 =
  fixes    one        :: iname
  fixes	   n          :: iname
  fixes	   b          :: iname
  fixes	   r          :: rname
  fixes	   count      :: ifldname
  fixes    KountClass :: cname
  fixes	   kount      :: mname
  assumes  kountbdy[simp]:  
  "methtable KountClass kount = 
   ((LET one = 1\<^sup>z; 
       n = self\<bullet>count ;
       n = n :-- ;
       _ = self\<bullet>count := n ;
       b = n :< one
   IN 
     IF b 
       THEN 0\<^sup>z
       ELSE MH_Invoke self kount
   END)::'a expr)"
  assumes  vardistinct:   "distinct [one,n,b] \<and> distinct [b,n,one]"
  assumes  vardistinct':  "distinct [r,self,param] \<and> distinct [param,self,r]"
  assumes  allclasses:    "all_classes = {KountClass}"


lemma (in kount_example2)  
   "\<rhd> ((MH_Invoke x kount) :: 'a expr) :
    (% s b . {(E,h,hh,v,(p::Semantics.renv)). (\<forall> a . (qach_QaQ E h a s KountClass \<and> 0 < h<a\<bullet>count>) \<longrightarrow> v = IVal 0 \<and> hh<a\<bullet>count> = 0)}) x param"
apply (insert vardistinct)
apply (rule vdm_mhinvoke)
(* hmm, abstraction seems to be the wrong way round, using b rather than s in assertion*)
apply (rule allI)+ apply (rule impI) apply (erule conjE)+
apply (insert finclasses)
apply (simp add: allclasses qach_QaQ_def)
apply (erule_tac x="C" in allE)
apply simp                 (* porghvam yISach! *)
apply (rule vdm_conseq)
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) defer 1
apply (rule vdm_basics)
apply (rule vdm_basics) 
apply (rule vdm_ax) defer 1 defer 1 defer 1
apply (rule vdm_basics) 
apply (rule vdm_basics)
apply (rule vdm_basics)
apply (rule vdm_basics)
apply (rule vdm_basics)
apply auto
(* petaQ *)
oops

end