(* Time-stamp: <Sun Aug 24 2003 17:38:01 Stardate: [-29]0793.25 hwloidl> *)
(* $Id: Ex0.thy,v 1.2 2003/08/24 22:50:14 a1hloidl Exp $ *)

theory Ex0 = Prelude + Lemmas + VDM0:

subsection {* Testing adaptation *}

(* --------------------------------------------------------------------------- *)

section {* Different version of adaptation *}

(*
(* UNPROVEN LEMMA on context adaptation *)
lemma vdm_adapt_context: 
      "(insert (y\<diamondsuit>\<diamondsuit>mn, subst Q x y) G) \<rhd> e : P  
        \<Longrightarrow>
       (insert (x\<diamondsuit>\<diamondsuit>mn, Q) G) \<rhd> e : P"
sorry

constdefs not_free_in_assn :: "rname \<Rightarrow> vdmassn \<Rightarrow> bool"
 "not_free_in_assn y Q \<equiv> \<forall> x E h hh v p. (E,h,hh,v,p) \<in> Q \<longrightarrow> (\<exists> E0. E = E0\<lfloor>y:=E0\<lfloor>x\<rfloor>\<rfloor> \<and> (E0,h,hh,v,p) \<in> Q)"

(* This is the best bet so far; works with foo in Ex1 
   The is a shallow way of saying that x is not free in Q, allowing substitution *)
lemma vdm_adapt_context_with_bonzo: 
    "\<lbrakk> not_free_in_assn y Q  \<longrightarrow>
     (insert (y\<diamondsuit>\<diamondsuit>mn, subst Q y x) G) \<rhd> e : P \<rbrakk>
     \<Longrightarrow>
     (insert (x\<diamondsuit>\<diamondsuit>mn, Q) G) \<rhd> e : P"
sorry

lemma vdm_adapt_context_with_bonzo_fwd: 
    "\<lbrakk> not_free_in_assn x Q  ;
      (insert (y\<diamondsuit>\<diamondsuit>mn, Q) G) \<rhd> e : P \<rbrakk>
     \<Longrightarrow>
     (insert (x\<diamondsuit>\<diamondsuit>mn, subst Q x y) G) \<rhd> e : P"
sorry

constdefs alias_of :: "vdmassn \<Rightarrow> rname \<Rightarrow> rname \<Rightarrow> bool" 
 "alias_of P x y \<equiv> (\<forall> E h hh v p C a. (E,h,hh,v,p) \<in> P \<longrightarrow> qach_QaQ E h a x C \<longrightarrow> qach_QaQ E h a y C)"

lemma vdm_ax_with_adapt: 
 "\<lbrakk> not_free_in_assn x Q ; alias_of Q x y ; ((y\<diamondsuit>\<diamondsuit>mn), % y z . Q y z ) \<in> G \<rbrakk> \<Longrightarrow> G \<rhd> (x\<diamondsuit>\<diamondsuit>mn) : Q"
sorry

(*
lemma vdm_adapt_context_with_bonzo: 
    "\<lbrakk> (\<forall> E h hh v p. (E,h,hh,v,p) \<in> Q \<longrightarrow> (\<exists> E0. E = E0\<lfloor>y:=E0\<lfloor>x\<rfloor>\<rfloor> \<and> (E0,h,hh,v,p) \<in> Q)) \<longrightarrow>
     (insert (y\<diamondsuit>\<diamondsuit>mn, subst Q x y) G) \<rhd> e : P \<rbrakk>
     \<Longrightarrow>
     (insert (x\<diamondsuit>\<diamondsuit>mn, Q) G) \<rhd> e : P"
sorry
*)

(* adaptation lemma with built in alias branch *)
lemma vdm_adapt_context_with_alias: "\<lbrakk> {(x\<diamondsuit>\<diamondsuit>mn, subst Q x y)} \<rhd> e : P ; (\<forall> E h hh v p C a. (E,h,hh,v,p) \<in> P \<longrightarrow> qach_QaQ E h a x C \<longrightarrow> qach_QaQ E h a y C) \<rbrakk> \<Longrightarrow> {(y\<diamondsuit>\<diamondsuit>mn, Q)} \<rhd> e : P"
sorry (* , NOT! *)

lemma vdm_adapt_context_param: 
      "(insert (C\<bullet>mn(y), subst Q x y) G) \<rhd> e : P  
        \<Longrightarrow>
       (insert (C\<bullet>mn(x), Q) G) \<rhd> e : P"
sorry

lemma vdm_adapt_with_alias: "\<lbrakk> \<rhd> x\<diamondsuit>\<diamondsuit>mn : Q ; (\<forall> E h hh v p C a. (E,h,hh,v,p) \<in> Q \<longrightarrow> qach_QaQ E h a x C \<longrightarrow> qach_QaQ E h a y C) \<rbrakk> \<Longrightarrow>
                             \<rhd> y\<diamondsuit>\<diamondsuit>mn : subst Q y x"
oops

lemma vdm_adapt_from_context: "\<lbrakk> \<rhd> (x\<diamondsuit>\<diamondsuit>mn) : Q \<rbrakk> \<Longrightarrow> {(x\<diamondsuit>\<diamondsuit>mn, Q)} \<rhd> (y\<diamondsuit>\<diamondsuit>mn) : subst Q y x"
apply (simp add: subst_def)
apply (rule vdm_ax)
apply clarsimp
oops

lemma vdm_adapt_with_alias_InvokeStatic: "\<lbrakk> G \<rhd> (C\<bullet>mn(x)) : Q  ; (\<forall> E h hh v p C a. (E,h,hh,v,p) \<in> Q \<longrightarrow> qach_QaQ E h a x C \<longrightarrow> qach_QaQ E h a y C) \<rbrakk> \<Longrightarrow>
                             (G \<rhd> (C\<bullet>mn(y)) : Q)"
sorry

(*
lemma vdm_adapt_bonzo: "nuke y (subst Q x y) \<subseteq> nuke y Q"
apply (simp add: subst_def nuke_def)
apply clarsimp
apply (rule_tac x="E" in exI)
apply simp
done
*)
*)
section {* Lemmas over these aux functions; SHOULD GO INTO Lemmas.thy !!!!!!!!!!! *}


lemma qach_QaQ_inj_arg: "\<lbrakk> qach_QaQ E h a r C ; qach_QaQ E h a' r C \<rbrakk> \<Longrightarrow> a = a'"
by (simp add: qach_QaQ_def)

lemma qach_QaQ_rvarIUpd[simp]: "qach_QaQ E<x:=n> h a r C = qach_QaQ E h a r C"
by (simp add: qach_QaQ_def)

lemma qach_QaQ_rvarRUpdSame[simp]: "qach_QaQ E\<lfloor>r:=Ref a\<rfloor> h a r C = (fmap_lookup (heap.oheap h) a = Some C)"
by (simp add: qach_QaQ_def)

lemma qach_QaQ_rvarRUpdOther[simp]: "r \<noteq> x  \<Longrightarrow> qach_QaQ E\<lfloor>x:=b\<rfloor> h a r C = qach_QaQ E h a r C"
by (simp add: qach_QaQ_def)

lemma qach_QaQ_heap1[simp]: "qach_QaQ E \<lparr> oheap = oheap h, iheap = foo, rheap = rheap h \<rparr> a r C = qach_QaQ E h a r C"
by (simp add: qach_QaQ_def)

lemma qach_QaQ9: "\<lbrakk> E\<lfloor>x\<rfloor> = E\<lfloor>y\<rfloor> ; qach_QaQ E h a x C \<rbrakk> \<Longrightarrow>  qach_QaQ E h a y C"
by (simp add: qach_QaQ_def)

lemma qach_QaQ8: "\<lbrakk> qach_QaQ E\<lfloor>x:=E\<lfloor>y\<rfloor>\<rfloor> h a x DecClass \<rbrakk> \<Longrightarrow> qach_QaQ E h a y DecClass"
by (simp add: qach_QaQ_def)

declare subst_def [simp]

lemma qach_QaQ7: "\<lbrakk> qach_QaQ E' h' a x C ; E' = E\<lfloor>x:=E\<lfloor>y\<rfloor>\<rfloor> \<rbrakk> \<Longrightarrow> qach_QaQ E h' a y C"
by (clarsimp, simp add: qach_QaQ_def)

(* --------------------------------------------------------------------------- *)

locale example2 =
  fixes   n  :: iname
  fixes   count  :: ifldname
  fixes   x  :: rname
  fixes   y  :: rname
  fixes   a1 :: locn
  fixes   myid :: mname
  fixes   MyId :: cname
  assumes foobody: "methtable MyId myid = ((LET n = GetFi self count IN n\<^sup>I END)::'a expr)"
  (* assumes foospec: "spectable MyId myid = {(E,h,hh,v,p). v = E<x\<bullet>count> \<and> hh=h \<and> p=\<langle>1 0 0 0\<rangle>}" *)

lemma (in example2)
 "{(% s b . (((MH_Invoke s myid)::'a expr), {(E,h,hh,v,p). \<forall> a . E\<lfloor>s\<rfloor> = Ref a \<longrightarrow> v = IVal h<a\<bullet>count>}))} 
  \<rhd> (MH_Invoke x myid) : {(E,h,hh,v,p). \<forall> a . E\<lfloor>x\<rfloor> = Ref a \<longrightarrow> v = IVal h<a\<bullet>count>}"
(*
apply (rule vdm_adapt_context_with_bonzo)
apply (rule impI)
*)
(* apply (rule vdm_conseq) *)
apply (rule vdm_ax)
defer 1
apply auto
done

subsection {* Version w/ MH_Invoke *}

locale kount_example2 =
  fixes    one        :: iname
  fixes	   n          :: iname
  fixes	   b          :: iname
  fixes	   r          :: rname
  fixes	   count      :: ifldname
  fixes    KountClass :: cname
  fixes	   kount      :: mname
  assumes  kountbdy[simp]:  
  "methtable KountClass kount = 
   ((LET one = 1\<^sup>z; 
       n = self\<bullet>count ;
       n = n :-- ;
       _ = self\<bullet>count := n ;
       b = n :< one
   IN 
     IF b 
       THEN 0\<^sup>z
       ELSE MH_Invoke self kount
   END)::'a expr)"
  assumes  vardistinct:   "distinct [one,n,b] \<and> distinct [b,n,one]"
  assumes  vardistinct':  "distinct [r,self,param] \<and> distinct [param,self,r]"
  assumes  allclasses:    "all_classes = {KountClass}"

(* cheating over self: no "adaptation" of self needed in rec call *)
lemma (in kount_example2)  
   "\<rhd> ((MH_Invoke self kount) :: 'a expr) :
    {(E,h,hh,v,(p::Semantics.renv)). (\<forall> a . (qach_QaQ E h a self KountClass \<and> 0 < h<a\<bullet>count>) \<longrightarrow> v = IVal 0 \<and> hh<a\<bullet>count> = 0)}"
apply (insert vardistinct)
apply (rule vdm_mhinvoke)
(* only the name of the obj in the expr bit is abstracted, not in the assertion *)
apply (rule allI)+ apply (rule impI) apply (erule conjE)+
apply (insert finclasses)
apply (simp add: allclasses qach_QaQ_def)
apply (erule_tac x="C" in allE)
apply simp                 (* porghvam yISach! *)
apply (rule vdm_conseq)
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) defer 1
apply (rule vdm_basics)
apply (rule vdm_basics) 
apply (rule vdm_ax) apply clarsimp defer 1 defer 1 defer 1
apply (rule vdm_basics) 
apply (rule vdm_basics)
apply (rule vdm_basics)
apply (rule vdm_basics)
apply (rule vdm_basics)
defer 1
defer 1
apply clarsimp
defer 1
defer 1
apply auto
defer 1
apply arith



end