
(*was: theory CloneList = VDMderived:*)
theory DiamondListInt = VDMderived:
(*Grail
public class CloneList$dia_0  {
   field public static CloneList$dia_0 $f

   field public CloneList$dia_0 $n

   field public int $

   field public int f0

   field public CloneList$dia_0 f1

   field public java.lang.String f2

   method static public CloneList$dia_0 alloc () =
   let
      val freelist = getstatic <CloneList$dia_0 CloneList$dia_0.$f>

      fun q(CloneList$dia_0 freelist) =
      let
         val tl = getfield freelist <CloneList$dia_0 CloneList$dia_0.$n>
         val () = putstatic <CloneList$dia_0 CloneList$dia_0.$f> tl
      in
         freelist
      end
   in
      if freelist = null[CloneList$dia_0]
      then new <CloneList$dia_0()> ()
      else q(freelist)
   end

   method static public void free (CloneList$dia_0 node) =
   let
      val freelist = getstatic <CloneList$dia_0 CloneList$dia_0.$f>
      val () = putfield node <CloneList$dia_0 CloneList$dia_0.$n> freelist
      val () = putstatic <CloneList$dia_0 CloneList$dia_0.$f> node
   in
      ()
   end

   method static public java.lang.String diamond_info () =
   let
   in
      ""
   end

   method public static CloneList$dia_0 fill (CloneList$dia_0 ?x, int tag, int v0, CloneList$dia_0 v1) =
   let
      val () = putfield ?x <int CloneList$dia_0.$> tag
      val () = putfield ?x <int CloneList$dia_0.f0> v0
      val () = putfield ?x <CloneList$dia_0 CloneList$dia_0.f1> v1
   in
      ?x
   end

   method public static CloneList$dia_0 fill (CloneList$dia_0 ?x, int tag, java.lang.String v0, CloneList$dia_0 v1) =
   let
      val () = putfield ?x <int CloneList$dia_0.$> tag
      val () = putfield ?x <java.lang.String CloneList$dia_0.f2> v0
      val () = putfield ?x <CloneList$dia_0 CloneList$dia_0.f1> v1
   in
      ?x
   end

   method public static CloneList$dia_0 fill (CloneList$dia_0 ?x, int tag) =
   let
      val () = putfield ?x <int CloneList$dia_0.$> tag
   in
      ?x
   end

   method public static CloneList$dia_0 make (int tag, int v0, CloneList$dia_0 v1) =
   let
      val ?x = invokestatic <CloneList$dia_0 CloneList$dia_0.alloc ()> ()
   in
      invokestatic <CloneList$dia_0 CloneList$dia_0.fill (CloneList$dia_0, int, int, CloneList$dia_0)> (?x, tag, v0, v1)
   end

   method public static CloneList$dia_0 make (int tag, java.lang.String v0, CloneList$dia_0 v1) =
   let
      val ?x = invokestatic <CloneList$dia_0 CloneList$dia_0.alloc ()> ()
   in
      invokestatic <CloneList$dia_0 CloneList$dia_0.fill (CloneList$dia_0, int, java.lang.String, CloneList$dia_0)> (?x, tag, v0, v1)
   end

   method public static CloneList$dia_0 make (int tag) =
   let
      val ?x = invokestatic <CloneList$dia_0 CloneList$dia_0.alloc ()> ()
   in
      invokestatic <CloneList$dia_0 CloneList$dia_0.fill (CloneList$dia_0, int)> (?x, tag)
   end
}
*)

(*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*)
(* This is the part common for all ToyGrail certifying thy-files *)
(* It defines a diamond, a freelist, and a pointer to a freelist, see D2a *)   

consts DIAMOND ::cname
consts DollarN :: rfldname (* to point to the next member in a freelist *)
       Dollar :: ifldname (* a tag to discriminate constructors in our "universal" diamond *)
       F0 :: ifldname (* a working field *)
       F1 :: rfldname (* a working field *)
consts STATICFL::cname 
consts DollarF :: rfldname (* the pointer to a head of a freelist*)
consts modelsDIAMOND:: "(ref \<times> int \<times> int \<times> ref \<times> locn \<times> heap) set"
inductive modelsDIAMOND intros
modDiam: "\<lbrakk>fmap_lookup(oheap h) l = Some DIAMOND; rheap h DollarN l = n;
           iheap h Dollar l = d; iheap h F0 l = f0; rheap h F1 l = f1 \<rbrakk>
         \<Longrightarrow> (n,d,f0,f1,l,h) : modelsDIAMOND"

lemma modelsDIAMOND_Same:
"\<lbrakk>same X h hh; l : X; (n,d,f0,f1,l,h) : modelsDIAMOND\<rbrakk> \<Longrightarrow> (n,d,f0,f1,l,hh) : modelsDIAMOND" 
by (erule modelsDIAMOND.elims, clarsimp, rule modDiam, simp_all add:same_def)

consts modelsFreelist::"(nat \<times> locn \<times> (locn set) \<times> heap) set"
(*(i,l,X,h) : modelsFreelist if h\<lfloor>l\<rfloor> is the head of a list of diamonds of length i + 1*) 
inductive modelsFreelist intros
FL_one : "\<lbrakk>(Nullref,d,f0,f1,l,h) \<in> modelsDIAMOND; l \<in> X\<rbrakk> \<Longrightarrow> (0,l,{l},h) \<in>  modelsFreelist"
FL_more: "\<lbrakk>(Ref n,d,f0,f1,l,h) : modelsDIAMOND; l \<in> X; n \<in> X - {l}; 
           (i,n, X - {l} , h) : modelsFreelist\<rbrakk>
           \<Longrightarrow> (Suc i, l, X, h) : modelsFreelist"


lemma modelsFreelist_SameAux:
"\<forall> l X Y h hh . ((same Y h hh \<and> l : Y \<and> X \<subseteq> Y \<and> (n,l,X,h) : modelsFreelist) \<longrightarrow> 
                 (n,l,X,hh) : modelsFreelist)" 
apply (induct n)
apply clarsimp
apply (erule modelsFreelist.elims, simp_all, clarsimp)
apply (rule FL_one)
apply (subgoal_tac "(Nullref, d, f0, f1, la, hh) \<in> modelsDIAMOND")
apply assumption
apply (simp add: modelsDIAMOND_Same)
apply assumption
apply clarsimp
apply (erule modelsFreelist.elims, clarsimp)
apply (rule FL_more)
apply (subgoal_tac "(Ref na, d, f0, f1, l, hh) \<in> modelsDIAMOND")
apply assumption
apply (erule_tac thin_rl)
apply (simp add: modelsDIAMOND_Same)
apply (erule_tac thin_rl)
apply clarsimp
apply (erule_tac thin_rl)
apply clarsimp
apply (erule_tac x=na in allE, erule_tac x="Xa - {la}" in allE, 
       erule_tac x="Y" in allE, erule_tac x=ha in allE, erule_tac x=hh in allE)
apply fastsimp
done

lemma modelsFreelist_Same:
"\<lbrakk>same Y h hh; l : Y; X \<subseteq> Y; (n,l,X,h) : modelsFreelist\<rbrakk> \<Longrightarrow> (n,l,X,hh) : modelsFreelist"
by (insert modelsFreelist_SameAux [of n],
    erule_tac x=l in allE, erule_tac x=X in allE, 
    erule_tac x=Y in allE, erule_tac x=h in allE, 
    erule_tac x=hh in allE, simp)

(* this is about the static field pointing to a freelist *)

consts modelsStatic::"(nat \<times> locn \<times> (locn option) \<times> (locn set) \<times> heap) set"
inductive modelsStatic intros
ST_none: "\<lbrakk>fmap_lookup(oheap h) l = Some STATICFL; rheap h DollarF l = Nullref\<rbrakk>
          \<Longrightarrow> (0,l,None,{},h) : modelsStatic"
ST_some: "\<lbrakk>fmap_lookup(oheap h) l = Some STATICFL; rheap h DollarF l = Ref fl; 
           l \<notin> X; (i,fl,X,h) : modelsFreelist\<rbrakk>
          \<Longrightarrow> (i,l,Some fl,X,h) : modelsStatic"

(*
consts modelsStaticRef::"(nat \<times> ref \<times> (ref option) \<times> (ref set) \<times> heap) set"
inductive modelsStaticRef intros
STR_none: "\<lbrakk>fmap_lookup(oheap h) l = Some STATICFL; rheap h DollarF l = Nullref\<rbrakk>
          \<Longrightarrow> (0,Ref l,None,{},h) : modelsStaticRef"
STR_some: "\<lbrakk>fmap_lookup(oheap h) l = Some STATICFL; rheap h DollarF l = Ref fl; 
           l \<notin> X; (i, Ref fl,X,h) : modelsFreelistRef\<rbrakk>
          \<Longrightarrow> (i, Ref l, Some fl,X,h) : modelsStaticRef" 
*)

lemma modelsStatic_Same:
"\<lbrakk>same Y h hh; l : Y; X \<subseteq> Y; (i,l,flopt,X,h) : modelsStatic\<rbrakk> \<Longrightarrow> (i,l,flopt,X,hh) : modelsStatic"
apply (erule modelsStatic.elims, simp_all, clarsimp)
apply (rule ST_none)
apply (simp add: same_def)
apply (simp add: same_def)
apply clarsimp
apply (rule ST_some)
apply (simp add: same_def)
apply (simp add: same_def)
apply simp
apply (subgoal_tac "fl : Y")
prefer 2 apply (subgoal_tac "fl : X") apply fast  apply (erule modelsFreelist.elims, simp_all)
apply (simp add: modelsFreelist_Same)
done

lemma oheapFreshMonotone:
"fmap_lookup (oheap h) l = Some C \<Longrightarrow> 
fmap_lookup (oheap h(freshloc (fmap_dom (oheap h))\<mapsto>\<^sub>f D)) l = Some C"
apply (subgoal_tac "l \<noteq> freshloc (fmap_dom (oheap h))")
apply (simp add: FMAPlookup2)
apply (subgoal_tac "freshloc (fmap_dom (oheap h)) \<notin> fmap_dom (oheap h)")
prefer 2 apply (subgoal_tac "finite (fmap_dom (oheap h))")
         apply (simp add: freshloc)
         apply fast
apply (subgoal_tac "l \<in> fmap_dom (oheap h)")
apply fast
apply (simp add: fmap_dom_def fmap_lookup_def dom_def)
done

(* Length of a list of  DIAMONDS representing lists of ints*)

constdefs HSize ::"heap \<Rightarrow> int"
"HSize h == int (card (fmap_dom (heap.oheap h)))"
declare HSize_def [simp]

lemma SizeInsert[simp]: "int (card (insert (freshloc (fmap_dom H)) (fmap_dom H))) = 
                         int (card (fmap_dom H)) + 1"
apply (subgoal_tac "card (insert (freshloc (fmap_dom H)) (fmap_dom H)) = Suc (card (fmap_dom H))")
apply simp
apply (rule card_insert_disjoint)
apply fastsimp
apply (rule freshloc, fastsimp)
done

declare obj_ifieldupdate_def [simp]
declare obj_rfieldupdate_def [simp]

consts models::"(int list \<times> ref \<times> heap) set"
inductive models intros
NIL:  "\<lbrakk>fmap_lookup(objhp H) l = Some DIAMOND \<and> 
inthp H Dollar l = 0\<rbrakk> \<Longrightarrow> ([],Ref l, H) \<in> models"
CONS: "\<lbrakk>\<exists> tt . (fmap_lookup(objhp H) l = Some DIAMOND \<and> 
                  inthp H Dollar l \<noteq> 0 \<and> inthp H F0 l = h 
                   \<and> refhp H F1 l = tt \<and> 
                  (t,tt,H) \<in> models)\<rbrakk>
        \<Longrightarrow> ( h # t, Ref l,H) \<in> models"

lemma NIL_I : "fmap_lookup(objhp H) l = Some DIAMOND \<and> inthp H Dollar l = 0 \<Longrightarrow>
               ([],Ref l, H) \<in> models" 
by(rule NIL, auto)

lemma CONS_I: "\<exists> tt . (fmap_lookup(objhp H) l = Some DIAMOND \<and> 
                  inthp H Dollar l \<noteq> 0 \<and> inthp H F0 l = h \<and> refhp H F1 l = tt \<and> 
                  (t,tt,H) \<in> models)
        \<Longrightarrow> ( h # t, Ref l,H) \<in> models" by(rule CONS, auto)

lemma NIL_E:  "([],Ref l, H) \<in> models \<Longrightarrow> fmap_lookup(objhp H) l = Some DIAMOND \<and> inthp H Dollar l = 0"
               by(erule models.elims,auto)

lemma CONS_E: "(h # t, Ref l,H) \<in> models \<Longrightarrow> 
               (\<exists> tt . (fmap_lookup(objhp H) l = Some DIAMOND \<and> inthp H Dollar l \<noteq> 0 \<and> 
                        inthp H F0 l = h \<and> refhp H F1 l = tt \<and> 
                        (t,tt,H) \<in> models))"
               by(erule models.elims,auto)

(* Alternative models relations *)

consts LLength::"(nat \<times> ref \<times> (ref set) \<times> heap) set"

(*
  The following inductive definition can be read as follows:
  $(n,l,X,s) \in \mbox{LLength}$ if $s l$ models a list of length $n$ with pointers from $X$, and all tail pointers distinct.
*)

inductive LLength intros

  NIL_LL:  "\<lbrakk>fmap_lookup(objhp hp) l = Some DIAMOND; 
	     inthp hp Dollar l = 0;
             Ref l \<in> X\<rbrakk> 
           \<Longrightarrow> (0,Ref l, X, hp) \<in> LLength"

  CONS_LL: "\<lbrakk>fmap_lookup(objhp hp) l = Some DIAMOND;
	     inthp hp Dollar l = 1;
	     inthp hp F0 l = h; 
	     refhp hp F1 l = tt; 
             Ref l \<in> X;
             tt \<in> X - {Ref l};  (i,tt, X - {Ref l} , hp) \<in> LLength\<rbrakk>
           \<Longrightarrow> ( Suc i , Ref l, X, hp) \<in> LLength"

lemma LLDOLLAR[simp]:
  "\<forall> r X h l tag.
   ((N, r, X, h) \<in> LLength \<and> Ref l \<notin> X \<longrightarrow> (N, r, X, h<l\<bullet>dollar := tag>) \<in> LLength)"
apply clarsimp
apply (induct N)
apply (erule LLength.elims)
apply clarsimp
apply (rule NIL_LL, fastsimp+)
apply (erule LLength.elims)
apply clarsimp
apply clarsimp
by (rule CONS_LL, fastsimp+)

lemma LLF1[simp]:
  "\<forall> r X h l t.
   ((N, r, X, h) \<in> LLength \<and> Ref l \<notin> X \<longrightarrow> (N, r, X, h\<lfloor>l\<diamondsuit>F1 := t\<rfloor>) \<in> LLength)"
apply clarsimp
apply (induct N)
apply (erule LLength.elims)
apply clarsimp
apply (rule NIL_LL, fastsimp+)
apply (erule LLength.elims)
apply clarsimp
apply clarsimp
apply (subgoal_tac "l \<noteq> la")
by (rule CONS_LL, fastsimp+)


(* Version with locations instead of references. *)

consts LocLength::"(nat \<times> locn \<times> (locn set) \<times> heap) set"
inductive LocLength intros

  NIL_LocL:  "\<lbrakk>fmap_lookup(oheap hp) l = Some DIAMOND; 
	       inthp hp Dollar l = 0;
               X \<subseteq> fmap_dom (oheap hp);
               l \<in> X\<rbrakk> 
             \<Longrightarrow> (0,l, X, hp) \<in> LocLength"

  CONS_LocL: "\<lbrakk>fmap_lookup(objhp hp) l = Some DIAMOND;
	       inthp hp Dollar l = 1;
	       inthp hp F0 l = h; 
	       refhp hp F1 l = Ref tt; 
               l \<in> X;
               tt \<in> X - {l};  (i,tt, X - {l} , hp) \<in> LocLength\<rbrakk>
             \<Longrightarrow> ( Suc i , l, X, hp) \<in> LocLength"

lemma LocLengthDomAux:
"\<forall> l X h . ((L, l, X, h) \<in> LocLength \<longrightarrow>  X \<subseteq> fmap_dom (oheap h))"
apply (induct L)
apply clarsimp
apply (erule LocLength.elims, simp_all, clarsimp)
apply (simp add: fmap_lookup_def fmap_dom_def dom_def, fast)
apply clarsimp
apply (erule LocLength.elims, simp_all, clarsimp)
apply (simp add: fmap_lookup_def fmap_dom_def dom_def, fast)
done

lemma LocLengthDom: "\<lbrakk>(L, l, X, h) \<in> LocLength\<rbrakk> \<Longrightarrow>  X \<subseteq> fmap_dom (oheap h)"
by (insert LocLengthDomAux, fast)

lemma LocLDOLLAR[simp]:
  "\<forall> r X h l tag.
   ((N, r, X, h) \<in> LocLength \<and> l \<notin> X \<longrightarrow> (N, r, X, h<l\<bullet>Dollar := tag>) \<in> LocLength)"
apply clarsimp
apply (induct N)
apply (erule LocLength.elims)
apply clarsimp
apply (rule NIL_LocL, fastsimp+)
apply (erule LocLength.elims)
apply clarsimp
apply clarsimp
by (rule CONS_LocL, fastsimp+)

lemma LocLF0[simp]:
  "\<forall> r X oh ih rh.
   ((N, r, X, \<lparr>objhp = oh, inthp = ih, refhp = rh\<rparr>) \<in> LocLength \<longrightarrow> 
    (N, r, X, \<lparr>objhp = oh, inthp = ih(F0 := ih F0), refhp = rh\<rparr>) \<in> LocLength)"
by fastsimp


(*identify over heaps which are identical on the domain of the predicate*)
lemma LocLengthSameAux:
"\<forall> l X h hh . (((n,l,X,h) \<in> LocLength \<and> same X h hh) \<longrightarrow> (n,l,X,hh) \<in> LocLength)"
apply (induct n)
apply clarsimp
apply (erule LocLength.elims, simp_all, clarsimp)
apply (rule NIL_LocL)
apply (simp_all add: same_def)
apply clarsimp
apply (subgoal_tac "x \<in> fmap_dom (oheap hp)")
prefer 2 apply fast
apply (simp add: fmap_dom_def dom_def, clarsimp)
apply (rule_tac x=y in exI,simp add: fmap_lookup_def)
apply clarsimp
apply (erule LocLength.elims, simp)
apply (erule_tac x=tt in allE)
apply (erule_tac x="Xa - {la}" in allE)
apply (erule_tac x=hp in allE)
apply (erule_tac x=hh in allE)
apply (rule CONS_LocL, simp_all)
done

lemma LocLengthSame:
"\<lbrakk>(n,l,X,h) \<in> LocLength; same X h hh\<rbrakk> \<Longrightarrow> (n,l,X,hh) \<in> LocLength"
by (insert LocLengthSameAux, fast)

(* Version with locations instead of references, and precise domain.*)

consts DomLength::"(nat \<times> locn \<times> (locn set) \<times> heap) set"
inductive DomLength intros

  NIL_DomL:  "\<lbrakk>fmap_lookup(objhp hp) l = Some DIAMOND; 
	       inthp hp Dollar l = 0\<rbrakk> 
             \<Longrightarrow> (0,l, {l}, hp) \<in> DomLength"

  CONS_DomL: "\<lbrakk>fmap_lookup(objhp hp) l = Some DIAMOND;
	       inthp hp Dollar l = 1;
	       inthp hp F0 l = h; 
	       refhp hp F1 l = Ref tt; 
               l \<in> X;
               (i,tt, X - {l} , hp) \<in> DomLength\<rbrakk>
             \<Longrightarrow> ( Suc i , l, X, hp) \<in> DomLength"

lemma DomLDOLLAR[simp]:
  "\<forall> r X h l tag.
   ((N, r, X, h) \<in> DomLength \<and> l \<notin> X \<longrightarrow> (N, r, X, h<l\<bullet>Dollar := tag>) \<in> DomLength)"
apply clarsimp
apply (induct N)
apply (erule DomLength.elims)
apply clarsimp
apply (rule NIL_DomL, fastsimp+)
apply (erule DomLength.elims)
apply clarsimp
apply clarsimp
by (rule CONS_DomL, fastsimp+)

lemma DomLF1[simp]:
  "\<forall> r X h l t.
   ((N, r, X, h) \<in> DomLength \<and> l \<notin> X \<longrightarrow> (N, r, X, h\<lfloor>l\<diamondsuit>F1 := t\<rfloor>) \<in> DomLength)"
apply clarsimp
apply (induct N)
apply (erule DomLength.elims)
apply clarsimp
apply (rule NIL_DomL, fastsimp+)
apply (erule DomLength.elims)
apply clarsimp
apply clarsimp
apply (subgoal_tac "l \<noteq> la")
by (rule CONS_DomL, fastsimp+)

lemma DomLengthDom[simp]:
  "\<forall> l X hp . ((L,l,X, hp) \<in> DomLength \<longrightarrow> X \<subseteq> fmap_dom (objhp hp))"
apply clarsimp
apply (induct L)
apply(erule DomLength.elims)
apply (simp_all add: fmap_lookup_def fmap_dom_def dom_def)
apply(erule DomLength.elims)
apply (simp_all add: fmap_lookup_def fmap_dom_def dom_def)
by fastsimp

lemma DomF02[simp]: 
  "\<forall> r X h l H. 
   ((N, r, X, h) \<in> DomLength \<and> l \<notin> X \<longrightarrow> (N, r, X, h<l\<bullet>F0 := H>) \<in> DomLength)"
apply clarsimp
apply (induct N)
apply (erule DomLength.elims)
apply clarsimp
apply (rule NIL_DomL, fastsimp+)
apply (erule DomLength.elims)
apply clarsimp
apply clarsimp
by (rule CONS_DomL, fastsimp+)

lemma DomTagTagHdHd: 
  "\<forall> r X h l ll tag1 tag2 H1 H2. 
   (F0 \<noteq> Dollar \<and> (N, r, X, h) \<in> DomLength \<and> l \<notin> X \<and> ll \<notin> X \<and> l \<noteq> ll \<longrightarrow> 
    (N, r, X, h<l\<bullet>Dollar := tag1><ll\<bullet>Dollar := tag2><l\<bullet>F0 := H1><ll\<bullet>F0 := H2>) \<in> DomLength)"
apply clarsimp
apply (induct N)
apply (erule DomLength.elims)
apply clarsimp
apply (rule NIL_DomL, fastsimp+)
apply clarsimp
apply (erule DomLength.elims)
apply clarsimp
apply clarsimp
by (rule CONS_DomL, fastsimp+)

lemma DomTagTagHd[simp]: 
  "\<forall> r X h l ll tag1 tag2 H2. 
   (F0 \<noteq> Dollar \<and> (N, r, X, h) \<in> DomLength \<and> l \<notin> X \<and> ll \<notin> X \<and> l \<noteq> ll \<longrightarrow> 
    (N, r, X, h<l\<bullet>Dollar := tag1><ll\<bullet>Dollar := tag2><l1\<bullet>F0 := H2>) \<in> DomLength)"
apply clarsimp
apply (induct N)
apply (erule DomLength.elims)
apply clarsimp
apply (rule NIL_DomL, fastsimp+)
apply (erule DomLength.elims)
apply clarsimp
apply clarsimp
by (rule CONS_DomL, fastsimp+)

lemma DomTlTl[simp]: 
  "\<forall> r X h l ll T1 T2. 
   ((N, r, X, h) \<in> DomLength \<and> l \<notin> X \<and> ll \<notin> X \<and> l \<noteq> ll \<longrightarrow> 
    (N, r, X, h\<lfloor>l\<diamondsuit>F1 := T1\<rfloor>\<lfloor>ll\<diamondsuit>F1 := T2\<rfloor>) \<in> DomLength)"
apply clarsimp
apply (induct N)
apply (erule DomLength.elims)
apply clarsimp
apply (rule NIL_DomL, fastsimp+)
apply (erule DomLength.elims)
apply clarsimp
apply clarsimp
by (rule CONS_DomL, fastsimp+)

lemma DomTagHd[simp]: 
  "\<forall> r X h l tag H. 
   (F0 \<noteq> Dollar \<and> (N, r, X, h) \<in> DomLength \<and> l \<notin> X \<longrightarrow> 
(N, r, X, h<l\<bullet>Dollar := tag><l\<bullet>F0 := H>) \<in> DomLength)"
apply clarsimp
apply (induct N)
apply (erule DomLength.elims)
apply clarsimp
apply (rule NIL_DomL, fastsimp+)
apply (erule DomLength.elims)
apply clarsimp
apply clarsimp
by (rule CONS_DomL, fastsimp+)

lemma DomOheap[simp]: 
  "\<forall> r X h l A. 
   ((N, r, X, h) \<in> DomLength \<and> l \<notin> X \<longrightarrow> 
    (N, r, X, h\<lparr>objhp := (heap.oheap h)(l \<mapsto>\<^sub>f A)\<rparr>) \<in> DomLength)"
apply clarsimp
apply (induct N)
apply (erule DomLength.elims)
apply clarsimp
apply (rule NIL_DomL)
apply auto
apply (simp add:FMAPlookup1)
apply (erule DomLength.elims)
apply clarsimp+
apply (rule CONS_DomL)
apply clarsimp
apply (subgoal_tac "l \<noteq> la")
apply (simp add:FMAPlookup1)
by (fastsimp+)

end


