
theory CloneList = DiamondListInt:

(* This specific part for a prticular program, in its turn, contains a subpart, 
common for all Isabelle presentation for Grail programs with DIAMOND*)
(* This subpart is about freelist management: alloc, make, fill, free *)

(* We consider the Grail image CloneList.gr of CloneList.cmlt *)

(* We do mot take into account intreface methods, with java.Lang.string,
 generated the compiler *)
(* We are interested in a method to which a camelot-function "clone"
is mapped *)
(*
CAMELOT 
let clone l = 
	match l with 
	   [] -> []
         | (h::t)@_ -> (h::( clone t))

let start args  =
let l = clone (2::(1::[])) 
in ()
   

GRAIL:
method static public CloneList$dia_0 clone_3 (CloneList$dia_0 l) =
   let

      fun f:clone_3(CloneList$dia_0 l) =
         if l = null[CloneList$dia_0]
         then f:0()
         else f:1(l)

      fun f:1(CloneList$dia_0 l) =
      let
         val v2 = getfield l <int CloneList$dia_0.f0>
         val v1 = getfield l <CloneList$dia_0 CloneList$dia_0.f1>
         val () = invokestatic <void CloneList$dia_0.free (CloneList$dia_0)> (l)
         val l = invokestatic <CloneList$dia_0 CloneList.clone_3 (CloneList$dia_0)> (v1)
      in
         invokestatic <CloneList$dia_0 CloneList$dia_0.make (int, int, CloneList$dia_0)> (0, v2, l)
      end

      fun f:0() =
         null[CloneList$dia_0]
   in
      f:clone_3(l)
   end
*)

(* make1 - "make" of arity 1 *)
(* make3 - "make" of arity 3 *) 
(* fill2 - "fill" of arity 2 *)
(* fill4 - "fill" of arity 4 *)

(* fill2 has 2 parameters so can't be a method. But fortunately fill2 
is invoked using the Grail convention. 
So we model it as a function. Same applies to fill4 *)


(* for modelling the arguments to make1 and make3 *)
(* a parameter "param" has 3 fields, - TAG, V0, V1 *)
(* the content of these fields will be assigned to vars tag, v0, v1 *)
(* these vars will be processed by a "function call" of fill1/fill3 *)
consts TAG :: ifldname
       V0 :: ifldname
       V1 :: rfldname


locale DiamondClone = 
fixes
     (* freelist management: for conversion of CloneList$dia.gr *) 
     alloc :: mname and free :: mname and make1 :: mname and make3 :: mname and 
     (* *)
     allocQ :: funame and fill2TEMP :: funame and fill4TEMP :: funame and
     (* tag, v0 are int parameters, for "fill", "make" *)
     b :: iname and tag :: iname and v0 :: iname and
     (* flp is a static pointer to a freelist *)
     flp ::rname and freelist :: rname and t :: rname and
     (* node, x, v1 are ref parameters, for "free", "fill", "make" *) 
     node :: rname and x :: rname and v1 :: rname and 
     (* to model 0-param. "alloc", and multiparam. "fill", "make" *)
     dummyPar :: rname and PARmake::rname and
     (* bodies *)
     allocBODY::"nat expr" and allocQBODY::"nat expr" and freeBODY::"nat expr" and
     fill2BODY::"nat expr" and fill4BODY::"nat expr" and make1BODY::"nat expr" and make3BODY::"nat expr" and
     
     (* specific part: for conversion of CloneList.gr *)
     CLONELIST :: cname and l :: rname and 
     clone3 :: mname and fclone3 :: funame and ff0 :: funame and ff1 :: funame and 
     clone3BODY :: "nat expr" and fclone3BODY  ::"nat expr"  and ff0BODY  ::"nat expr"  and ff1BODY  ::"nat expr"  and 
     PARClone :: rname and cloneb :: iname and clonetempf0 :: rname and clonetempf1 :: rname and
     clonev1 :: rname and clonev2 :: iname and clonezero :: iname and 
     (* *)
     myContext :: "nat vdmcontext" and 
     (* *)
     renvQ :: renv and renvAllocNone :: renv and renvAllocSome :: renv and renvFree :: renv and 
     renvFill2 :: renv and renvFill4 :: renv and renvMake1 :: renv and renvMake3 :: renv
     (* ??? Env-s for specific part ???? *)
     defines "renvQ == \<langle>8 1 0 0\<rangle>"
       and "renvAllocNone == \<langle>15 0 1 1\<rangle>"
       and "renvAllocSome == \<langle>18 2 0 0\<rangle>"
       and "renvFree == \<langle>14 0 1 1\<rangle>"
       and "renvFill2 == \<langle>5 1 0 0\<rangle>"
       and "renvFill4 == \<langle>11 1 0 0\<rangle>"
       and "renvMake1 == \<langle>13 0 1 1\<rangle>"
       and "renvMake3 == \<langle>19 0 1 1\<rangle>"
    (* ??? Env-s for specific part ???? *)

(* method and function BODies *)
       and "freeBODY == (LET rf freelist = GetFr flp DollarF;
                                       _ = PutFr node DollarN freelist
                         IN PutFr flp DollarF node
                         END)::nat expr"
       and "allocBODY == (LET rf freelist = GetFr flp DollarF;
                                        b = RPrimop (% r1 r2 . if r1 = Nullref then 1 else 0) freelist freelist
                          IN IF b THEN (NEW <DIAMOND> ([],[])) ELSE CALL allocQ 
                          END)::nat expr"
       and "allocQBODY == (LET rf t = GetFr freelist DollarN;
                                  _ = PutFr flp DollarF t
                           IN RVar freelist 
                           END)::nat expr"
       and "fill2BODY == (LET _ = PutFi x Dollar tag IN RVar x END)::nat expr"
       and "fill4BODY == (LET _ = PutFi x Dollar tag;
                              _ = PutFi x F0 v0;
                              _ = PutFr x F1 v1
                          IN RVar x END)::nat expr"
      and "make1BODY == ( LET rf dummyPar = Null;
                              rf flp = RVar self;
                              rf x = flp\<diamondsuit>alloc(dummyPar);
                              tag = GetFi param TAG
                          IN CALL fill2TEMP END)::nat expr" 
       and "make3BODY == (LET rf dummyPar = Null;
                              rf flp = RVar self;
                              rf x = flp\<diamondsuit>alloc(dummyPar);
                              tag = GetFi param TAG;
                              v0 = GetFi param V0;
                              rf v1 = GetFr param V1
                         IN CALL fill4TEMP END)::nat expr"
    
    and "fclone3BODY == (LET cloneb = RPrimop (% r1 r2. if r1 =Nullref then 1 else 0) l l
                         IN IF cloneb THEN CALL ff0 ELSE CALL ff1
                         END) :: nat expr"
    and "ff0BODY == (LET    clonev2 = GetFi l F0;
                        rf  clonev1 = GetFr l F1;
                           _  = InvokeStatic DIAMOND free l;
                        rf l =  InvokeStatic CLONELIST clone3 clonev1;
                           clonezero = expr.Int 0;
                           _   = PutFi PARmake TAG clonezero;
                           _   = PutFi PARmake V0  clonev2; 
                           _   = PutFr PARmake V1  l;
                        rf clonetempf0 = InvokeStatic DIAMOND make3 PARmake
                    IN RVar clonetempf0
                    END) :: nat expr"
   and "ff1BODY == (LET rf clonetempf1 = expr.Null
                    IN RVar clonetempf1
                    END) :: nat expr"
   and "clone3BODY == (LET rf l = RVar param
                       IN
                       CALL fclone3
                       END) :: nat expr"

   and "myContext == {((flp\<diamondsuit>alloc(dummyPar))::nat expr, Mspectable DIAMOND alloc), 
                          ((flp\<diamondsuit>free(node))::nat expr, Mspectable DIAMOND free), 
                          ((flp\<diamondsuit>make1(PARmake))::nat expr, Mspectable DIAMOND make1), 
                          ((flp\<diamondsuit>make3(PARmake))::nat expr, Mspectable DIAMOND make3), 
                          ((Call allocQ)::nat expr, spectable allocQ), 
                          ((Call fill2TEMP)::nat expr, spectable fill2TEMP), 
                          ((Call fill4TEMP)::nat expr, spectable fill4TEMP),
                          ((Call fclone3)::nat expr, spectable fclone3),
                          ((Call ff0)::nat expr, spectable ff0),
                          ((Call ff1)::nat expr, spectable ff1),
                          ((self\<diamondsuit>clone3(PARClone))::nat expr, Mspectable CLONELIST clone3)}"
                           
                         
 assumes FREE[simp]: "methtable DIAMOND free == freeBODY" 
       and ALLOC[simp]: "methtable DIAMOND alloc == allocBODY" 
       and ALLOCQ[simp]: "funtable allocQ == allocQBODY"
       and FILL2TEMP[simp]: "funtable fill2TEMP == fill2BODY" 
       and FILL4TEMP[simp]: "funtable fill4TEMP == fill4BODY" 
       and MAKE1[simp]: "methtable DIAMOND make1 == make1BODY" 
       and MAKE3[simp]: "methtable DIAMOND make3 == make3BODY"
 (*****************************************************************) 
       and FCLONE3[simp]: "funtable fclone3 == fclone3BODY"
       and FF0[simp]: "funtable ff0 == ff0BODY"
       and FF1[simp]: "funtable ff1 == ff1BODY"
       and CLONE3[simp]: "methtable CLONELIST clone3 == clone3BODY"

       and spectFill2TEMP:
           "spectable fill2TEMP == 
            {(E,h,hh,v,p) . \<forall> l i .
               ((E\<lfloor>x\<rfloor> = Ref l \<and> E<tag> = i) 
               \<longrightarrow> (v = RVal (Ref l) \<and> p = renvFill2 \<and> hh = h<l\<bullet>Dollar:=i>))}" 
       and spectFill4TEMP:
           "spectable fill4TEMP == 
            {(E,h,hh,v,p) . \<forall> l i V1 V0.
               ((E\<lfloor>x\<rfloor> = Ref l \<and> E<tag> = i \<and> E\<lfloor>v1\<rfloor> = V1 \<and> E<v0> = V0) 
               \<longrightarrow> (v = RVal (Ref l) \<and> p = renvFill4 \<and> hh = h<l\<bullet>Dollar:=i><l\<bullet>F0:=V0>\<lfloor>l\<diamondsuit>F1:=V1\<rfloor>))}"
       and spectFree:
           "Mspectable DIAMOND free == 
            {(E,h,hh,v,p) . \<forall> freeLST FL X n d f0 f1 flopt l fl nn. 
               ((E\<lfloor>flp\<rfloor> = Ref freeLST \<and> (FL,freeLST,flopt,X,h) \<in> modelsStatic \<and> 
                 E\<lfloor>node\<rfloor> = Ref l \<and> (n,d,f0,f1,l,h) : modelsDIAMOND \<and> l \<notin> X)
               \<longrightarrow> (v = arbitrary \<and> p = renvFree \<and> hh = h\<lfloor>l\<diamondsuit>DollarN := h\<lfloor>freeLST\<diamondsuit>DollarF\<rfloor>\<rfloor>\<lfloor>freeLST\<diamondsuit>DollarF := Ref l\<rfloor> \<and> 
                     ((flopt = None \<longrightarrow> (0,freeLST,Some l,{l},hh) : modelsStatic) \<and> 
                      (flopt = Some fl \<longrightarrow> (Suc FL,freeLST,Some l, X \<union> {l},hh) : modelsStatic))))}"
       and spectAllocQ:
           "spectable allocQ == {(E,h,hh,v,p) . \<forall> freeLST FL X i flopt fl. 
               ((E\<lfloor>flp\<rfloor> = Ref freeLST \<and> (FL,freeLST,flopt,X,h) \<in> modelsStatic \<and> 
                 (flopt = Some fl) \<and> E\<lfloor>freelist\<rfloor> = h\<lfloor>freeLST\<diamondsuit>DollarF\<rfloor>)
                \<longrightarrow> ( v = RVal (Ref fl) \<and> p = renvQ \<and> (FL, fl,X,h) \<in> modelsFreelist \<and> 
                      (\<exists> n d f0 f1. (n,d,f0,f1,fl,h) \<in> modelsDIAMOND \<and> fl \<in> X \<and> 
                         hh = \<lparr>oheap = oheap h, iheap = iheap h, 
                               rheap = (rheap h)(DollarF := (rheap h DollarF)(freeLST := h\<lfloor>fl\<diamondsuit>DollarN\<rfloor>))\<rparr> \<and> 
                         (((n = Nullref) \<longrightarrow> (0,freeLST,None,{},hh) : modelsStatic) \<and>
                                               (\<forall> nn . n = Ref nn \<longrightarrow> (\<exists> i . FL = Suc i \<and> nn \<in> X - {fl} \<and> 
                                                                             (i,nn, X - {fl}, h) : modelsFreelist \<and>
                                                                             (i,freeLST,Some nn,X - {fl},hh) : modelsStatic))))))}"
       and spectAlloc:
           "Mspectable DIAMOND alloc == 
            {(E,h,hh,v,p) . \<forall> freeLST FL X i flopt fl. 
               ((E\<lfloor>flp\<rfloor> = Ref freeLST \<and> (FL,freeLST,flopt,X,h) \<in> modelsStatic) \<longrightarrow> 
                   (((flopt = None) \<longrightarrow> (\<exists> r . (0,freeLST,None,X,hh) \<in> modelsStatic \<and> v = RVal (Ref r) \<and> 
                                                 r \<notin> fmap_dom (oheap h) \<and> hh = newObj h r E DIAMOND [] [] \<and> p = renvAllocNone)) \<and> 
                    ((flopt = Some fl) \<longrightarrow> ( v = RVal (Ref fl) \<and> p = renvAllocSome \<and> (FL, fl,X,h) \<in> modelsFreelist \<and> 
                                             (\<exists> n d f0 f1. (n,d,f0,f1,fl,h) \<in> modelsDIAMOND \<and> fl \<in> X \<and> 
                                               hh = \<lparr>oheap = oheap h, iheap = iheap h, 
                                                     rheap = (rheap h)(DollarF := (rheap h DollarF)(freeLST := h\<lfloor>fl\<diamondsuit>DollarN\<rfloor>))\<rparr> \<and> 
                                               (((n = Nullref) \<longrightarrow> (0,freeLST,None,{},hh) : modelsStatic) \<and>
                                                 (\<forall> nn . n = Ref nn \<longrightarrow> (\<exists> i . FL = Suc i \<and> nn \<in> X - {fl} \<and>
                                                                          (i,nn, X - {fl}, h) : modelsFreelist \<and>
                                                                          (i,freeLST,Some nn,X - {fl},hh) : modelsStatic))))))))}" 
       and spectMake1:
           "Mspectable DIAMOND make1 == 
               {(E,h,hh,v,p) . \<forall> freeLST FL X i flopt fl pref sref. 
                 ((E\<lfloor>flp\<rfloor> = Ref freeLST \<and> (FL,freeLST,flopt,X,h) \<in> modelsStatic) \<and> E\<lfloor>PARmake\<rfloor> = Ref pref \<longrightarrow> 
                  (\<exists> X h1 p1 p2. 
                  (\<lparr>ienv = emptyi, renv = emptyr\<rparr>\<lfloor>self:=Ref freeLST\<rfloor>\<lfloor>param:=Ref pref\<rfloor>\<lfloor>dummyPar:=Nullref\<rfloor>\<lfloor>flp:=Ref freeLST\<rfloor>,h,h1,RVal X,p1) : 
                    Mspectable DIAMOND alloc \<and>
                  (\<lparr>ienv = emptyi, renv = emptyr\<rparr>\<lfloor>self:=Ref freeLST\<rfloor>\<lfloor>param:=Ref pref\<rfloor>\<lfloor>dummyPar:=Nullref\<rfloor>\<lfloor>flp:=Ref freeLST\<rfloor>\<lfloor>x:=X\<rfloor>
                   <tag:=(heap.iheap h1) TAG pref>,h1,hh,v,p2) : spectable fill2TEMP \<and>
                  p = (renvMake1 \<oplus> p1 \<smile> p2)))}"
       and spectMake3:
           "Mspectable DIAMOND make3 == 
               {(E,h,hh,v,p) . \<forall> freeLST FL X i flopt fl pref sref. 
                 ((E\<lfloor>flp\<rfloor> = Ref freeLST \<and> (FL,freeLST,flopt,X,h) \<in> modelsStatic) \<and> E\<lfloor>PARmake\<rfloor> = Ref pref \<longrightarrow> 
                  (\<exists> X h1 p1 p2. 
                  (\<lparr>ienv = emptyi, renv = emptyr\<rparr>\<lfloor>self:=Ref freeLST\<rfloor>\<lfloor>param:=Ref pref\<rfloor>\<lfloor>dummyPar:=Nullref\<rfloor>\<lfloor>flp:=Ref freeLST\<rfloor>,h,h1,RVal X,p1) : 
                   Mspectable DIAMOND alloc \<and>
                  (\<lparr>ienv = emptyi, renv = emptyr\<rparr>\<lfloor>self:=Ref freeLST\<rfloor>\<lfloor>param:=Ref pref\<rfloor>\<lfloor>dummyPar:=Nullref\<rfloor>\<lfloor>flp:=Ref freeLST\<rfloor>\<lfloor>x:=X\<rfloor>
                    <tag:=(heap.iheap h1) TAG pref><v0:=(heap.iheap h1) V0 pref>\<lfloor>v1:=(heap.rheap h1) V1 pref\<rfloor>,h1,hh,v,p2) : spectable fill4TEMP \<and>
                  p = (renvMake3 \<oplus> p1 \<smile> p2)))}"
(*****************************************************************)
and spectFf0:
           "spectable ff0 == 
               {(E,h,hh,v,p). 1=1}"

and spectFf1:
           "spectable ff1 == 
               {(E,h,hh,v,p) . h = hh}" 
and spectFclone3:
          "spectable fclone3 == 
               {(E,h,hh,v,p) . h = hh}" 

        
and spectClone3:
           "Mspectable CLONELIST  clone3 == 
               {(E,h,hh,v,p) . \<forall> X Y n q L lloc flloc. 
                              X \<inter> Y = {} \<longrightarrow>
                               (E\<lfloor>l \<rfloor> = Ref lloc) \<longrightarrow>
                               (E\<lfloor>flp \<rfloor> = Ref flloc) \<longrightarrow>
                                flloc \<notin> Y  \<longrightarrow>
                               ((0, flloc, None, {}, h) \<in> modelsStatic \<and> n=0 \<and> X={} \<or>
                                 (\<exists> fll. (n, flloc, Some fll, X, h) \<in> modelsStatic))
                               \<longrightarrow>
                               (L, lloc, Y, h) \<in> LocLength \<longrightarrow> 
                                 0 * L + q \<le> n  \<longrightarrow> 
                                 (HSize h) = (HSize hh)  \<and> 
                                   (\<exists> XX nn YY LL.
                                   XX \<inter> YY = {} \<and>
                                   ((0, flloc, None, {}, hh)\<in> modelsStatic \<and> nn=0 \<and> XX={} 
                                   \<or> (\<exists> fll.(nn, flloc, Some fll, XX, hh) \<in> modelsStatic)) \<and>
                                   (LL, lloc, YY, hh) \<in> LocLength \<and>
                                   0 * LL + q \<le> nn )}" 

(*****************************************************************) 

       and alldistinct: "distinct[flp,freelist,t,node,x,v1,dummyPar,self, param] \<and>
                         distinct[param,self,dummyPar,v1,x,node,t,freelist,flp] \<and>
                         distinct[b,tag,v0] \<and> distinct[v0,tag,b] \<and>
                         distinct[DollarF, DollarN, F1] \<and> distinct[F1,DollarN,DollarF] \<and>
                         distinct[Dollar, F0] \<and> distinct[F0,Dollar] \<and>
                         distinct[STATICFL, DIAMOND] \<and> distinct[DIAMOND, STATICFL] \<and> 
                         distinct[alloc, free, make1, make3, clone3] \<and>
                         distinct[allocQ, fill2TEMP, fill4TEMP, fclone3, ff0, ff1] \<and>
                         distinct[ff1, ff0, fclone3, fill4TEMP, fill2TEMP, allocQ] \<and>
                         distinct[clone3, make3, make1, free, alloc]"
(*****************************************************************) 
(* add distinction for variables of the specific part*)
       and typing[simp] : "\<forall> E h l C . (qach_QaQ E h l flp C \<longrightarrow> C = DIAMOND)"

declare obj_ifieldupdate_def [simp]
declare obj_rfieldupdate_def [simp]
declare ivarupdate_def [simp]
declare rvarupdate_def [simp]
declare ienv_fct_def [simp]
declare renv_fct_def [simp]
declare newframe_env_def [simp]
declare emptyr_def [simp]

constdefs mkEnv::"rname \<Rightarrow> locn \<Rightarrow> env"
"mkEnv x l == \<lparr>ienv = \<lambda> y . 0, renv = \<lambda> y . Nullref\<rparr>\<lfloor>x:=Ref l\<rfloor>"
constdefs mkHp::"locn \<Rightarrow> cname \<Rightarrow> heap"
"mkHp l C == \<lparr>oheap = emptyfinmap(l \<mapsto>\<^sub>f C), iheap = \<lambda> f ll . 0, rheap = \<lambda> f ll . Nullref\<rparr>" 

lemma (in DiamondClone) goodState: "\<exists>E h a C. qach_QaQ E h a flp C \<and> Mspectable DIAMOND f = Mspectable C f"
by (rule_tac x="mkEnv flp 1" in exI,
    rule_tac x="mkHp 1 DIAMOND" in exI,
    rule_tac x="1" in exI,
    rule_tac x="DIAMOND" in exI, 
    simp add: qach_QaQ_def mkEnv_def mkHp_def)

lemma (in DiamondClone) "\<rhd> ((flp\<diamondsuit>alloc(dummyPar))::nat expr) : (Mspectable DIAMOND alloc)"
apply (rule MUTREC)
apply (subgoal_tac "finite myContext")
apply assumption
apply (simp add: myContext_def)
apply (simp add: myContext_def)
apply (simp add: myContext_def)
prefer 2
apply (simp add: myContext_def)
apply (simp add: consistent_def myContext_def)
apply (insert alldistinct, clarsimp)
apply (rule, clarsimp)
apply (rule, clarsimp)
apply (simp add: allocQBODY_def)
apply (rule vdm_conseq)
apply (rule vdm_letr, rule vdm_getfr) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv, rule vdm_putfr) prefer 2 apply clarsimp prefer 2
apply (rule vdm_rvar) apply clarsimp defer 1
apply (rule, clarsimp)
apply (simp add: fill2BODY_def)
apply (rule vdm_conseq) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv, rule vdm_putfi) prefer 2 apply clarsimp prefer 2
apply (rule vdm_rvar) apply clarsimp defer 1
apply (rule, clarsimp)
apply (simp add: fill4BODY_def)
apply (rule vdm_conseq) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv, rule vdm_putfi) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv, rule vdm_putfi) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv, rule vdm_putfr) prefer 2 apply clarsimp prefer 2
apply (rule vdm_rvar) apply clarsimp defer 1
apply (rule, clarsimp)
apply (simp add: fclone3BODY_def)
apply (rule vdm_conseq) prefer 2 apply clarsimp prefer 2
apply (rule vdm_leti, rule vdm_rprim) prefer 2 apply clarsimp prefer 2
apply (rule vdm_if, rule vdm_ax, simp, rule vdm_ax, simp) apply clarsimp defer 1
apply (rule, clarsimp)
apply (simp add: ff0BODY_def)
apply (rule vdm_conseq) prefer 2 apply clarsimp prefer 2
apply (rule vdm_leti, rule vdm_getfi) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr, rule vdm_getfr) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv) prefer 2 apply clarsimp prefer 2
apply (rule vdm_rvar) apply clarsimp defer 1
apply clarsimp
apply (rule, clarsimp)
apply rule
apply (rule goodState)
apply clarsimp
apply (subgoal_tac "C = DIAMOND", clarsimp)
prefer 2 apply (insert typing)
  apply (erule_tac x=E' in allE,
         erule_tac x=h' in allE,
         erule_tac x=a in allE,
         erule_tac x=C in allE, fast)
  apply (rotate_tac -1, erule thin_rl)
apply (simp add: allocBODY_def)
apply (rule vdm_conseq)
apply (rule vdm_letr, rule vdm_getfr) prefer 2 apply clarsimp 
apply (rule vdm_leti, rule vdm_rprim) prefer 2 apply clarsimp prefer 2
apply (rule vdm_if)
apply (rule vdm_new) 
apply (subgoal_tac "{(flp\<diamondsuit>alloc(dummyPar), Mspectable DIAMOND alloc), (flp\<diamondsuit>free(node), Mspectable DIAMOND free),
           (flp\<diamondsuit>make1(PARmake), Mspectable DIAMOND make1), (flp\<diamondsuit>make3(PARmake), Mspectable DIAMOND make3), (CALL allocQ, spectable allocQ), (CALL fill2TEMP, spectable fill2TEMP),
           (CALL fill4TEMP, spectable fill4TEMP)} \<rhd>  (CALL allocQ) : spectable allocQ", simp)
apply (rule vdm_ax, simp)
apply rule
apply rule
apply rule
apply (rule goodState)
apply clarsimp
apply (subgoal_tac "C = DIAMOND", clarsimp)
prefer 2 apply (insert typing)
  apply (erule_tac x=E' in allE,
         erule_tac x=h' in allE,
         erule_tac x=a in allE,
         erule_tac x=C in allE, fast)
  apply (rotate_tac -1, erule thin_rl)
apply (simp add: freeBODY_def)
apply (rule vdm_conseq) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr, rule vdm_getfr) prefer 2 apply clarsimp
apply (rule vdm_letv, rule vdm_putfr)
apply (rule vdm_putfr) apply clarsimp
apply rule
apply rule
apply rule
apply (rule goodState)
apply clarsimp
apply (subgoal_tac "C = DIAMOND", clarsimp)
prefer 2 apply (insert typing)
  apply (erule_tac x=E' in allE,
         erule_tac x=h' in allE,
         erule_tac x=a in allE,
         erule_tac x=C in allE, fast)
  apply (rotate_tac -1, erule thin_rl)
apply (simp add: make1BODY_def)
apply (rule vdm_conseq) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr, rule vdm_null) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr, rule vdm_rvar) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr)
apply (subgoal_tac "{(flp\<diamondsuit>alloc(dummyPar), Mspectable DIAMOND alloc), (flp\<diamondsuit>free(node), Mspectable DIAMOND free),
           (flp\<diamondsuit>make1(PARmake), Mspectable DIAMOND make1), (flp\<diamondsuit>make3(PARmake), Mspectable DIAMOND make3), (CALL allocQ, spectable allocQ), (CALL fill2TEMP, spectable fill2TEMP),
           (CALL fill4TEMP, spectable fill4TEMP)} \<rhd>  (flp\<diamondsuit>alloc(dummyPar)) : Mspectable DIAMOND alloc", simp)
apply (rule vdm_ax, simp) prefer 2 apply clarsimp prefer 2
apply (rule vdm_leti, rule vdm_getfi) prefer 2 apply clarsimp prefer 2
apply (subgoal_tac "{(flp\<diamondsuit>alloc(dummyPar), Mspectable DIAMOND alloc), (flp\<diamondsuit>free(node), Mspectable DIAMOND free),
           (flp\<diamondsuit>make1(PARmake), Mspectable DIAMOND make1), (flp\<diamondsuit>make3(PARmake), Mspectable DIAMOND make3), (CALL allocQ, spectable allocQ), (CALL fill2TEMP, spectable fill2TEMP),
           (CALL fill4TEMP, spectable fill4TEMP)} \<rhd>  (CALL fill2TEMP) : spectable fill2TEMP", simp)
apply (rule vdm_ax, simp) defer 1
apply rule
apply rule
apply (rule goodState)
apply clarsimp
apply (subgoal_tac "C = DIAMOND", clarsimp)
prefer 2 apply (insert typing)
  apply (erule_tac x=E' in allE,
         erule_tac x=h' in allE,
         erule_tac x=a in allE,
         erule_tac x=C in allE, fast)
  apply (rotate_tac -1, erule thin_rl)
apply (simp add: make3BODY_def)
apply (rule vdm_conseq) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr, rule vdm_null) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr, rule vdm_rvar) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr)
apply (subgoal_tac "{(flp\<diamondsuit>alloc(dummyPar), Mspectable DIAMOND alloc), (flp\<diamondsuit>free(node), Mspectable DIAMOND free),
           (flp\<diamondsuit>make1(PARmake), Mspectable DIAMOND make1), (flp\<diamondsuit>make3(PARmake), Mspectable DIAMOND make3), (CALL allocQ, spectable allocQ), (CALL fill2TEMP, spectable fill2TEMP),
           (CALL fill4TEMP, spectable fill4TEMP)} \<rhd>  (flp\<diamondsuit>alloc(dummyPar)) : Mspectable DIAMOND alloc", simp)
apply (rule vdm_ax, simp) prefer 2 apply clarsimp prefer 2
apply (rule vdm_leti, rule vdm_getfi) prefer 2 apply clarsimp prefer 2
apply (rule vdm_leti, rule vdm_getfi) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr, rule vdm_getfr) prefer 2 apply clarsimp prefer 2
apply (subgoal_tac "{(flp\<diamondsuit>alloc(dummyPar), Mspectable DIAMOND alloc), (flp\<diamondsuit>free(node), Mspectable DIAMOND free),
           (flp\<diamondsuit>make1(PARmake), Mspectable DIAMOND make1), (flp\<diamondsuit>make3(PARmake), Mspectable DIAMOND make3), (CALL allocQ, spectable allocQ), (CALL fill2TEMP, spectable fill2TEMP),
           (CALL fill4TEMP, spectable fill4TEMP)} \<rhd>  (CALL fill4TEMP) : spectable fill4TEMP", simp)
apply (rule vdm_ax, simp) defer 1
(*vc of allocQ*)
apply (simp add: spectAllocQ)
apply clarsimp
apply (erule modelsStatic.elims, simp_all, clarsimp)
apply (erule modelsFreelist.elims, simp_all, clarsimp)
apply (simp add: renvQ_def)
apply (rule_tac x=Nullref in exI, clarsimp)
apply rule
apply (rule_tac x=d in exI, rule_tac x=f0 in exI, rule_tac x=f1 in exI, clarsimp)
apply (rule ST_none)
apply (simp)
apply (erule modelsDIAMOND.elims, simp_all)
apply clarsimp
apply (simp add: renvQ_def)
apply (rule_tac x="Ref n" in exI, simp)
apply rule
apply (rule_tac x=d in exI, rule_tac x=f0 in exI, rule_tac x=f1 in exI, simp)
apply (rule ST_some) 
apply simp
apply (erule modelsDIAMOND.elims, simp_all)
apply (subgoal_tac "X - {la} \<subseteq> X")
apply (rule modelsFreelist_Same)
prefer 3 apply (assumption)
prefer 3 apply assumption
apply (simp add: same_def)
apply simp
apply fast
(*vc of fill2TEMP*)
apply (simp add: spectFill2TEMP renvFill2_def)
(*vc of fill4TEMP*)
apply (simp add: spectFill4TEMP renvFill4_def)
(*vc of make1*)
apply (simp add:spectMake1)
apply clarsimp
apply (rule_tac x=r in exI, rule_tac x=h1 in exI, rule_tac x=p1 in exI, clarsimp)
apply (rule_tac x=p2a in exI, clarsimp)
apply (simp add: renvMake1_def)
(*vc of make3*)
apply (simp add:spectMake3)
apply clarsimp
apply (rule_tac x=r in exI, rule_tac x=h1 in exI, rule_tac x=p1 in exI, clarsimp)
apply (rule_tac x=p2a in exI, clarsimp)
apply (simp add: renvMake3_def)
done


lemma (in DiamondClone) goodState: "\<exists>E h a C. qach_QaQ E h a flp C \<and> Mspectable DIAMOND f = Mspectable C f"
by (rule_tac x="mkEnv flp 1" in exI,
    rule_tac x="mkHp 1 DIAMOND" in exI,
    rule_tac x="1" in exI,
    rule_tac x="DIAMOND" in exI, 
    simp add: qach_QaQ_def mkEnv_def mkHp_def)

lemma (in DiamondClone) "\<rhd> ((flp\<diamondsuit>alloc(dummyPar))::nat expr) : (Mspectable DIAMOND alloc)"
apply (rule MUTREC)
apply (subgoal_tac "finite myContext")
apply assumption
apply (simp add: myContext_def)
apply (simp add: myContext_def)
apply (simp add: myContext_def)
prefer 2
apply (simp add: myContext_def)
apply (simp add: consistent_def myContext_def)
apply (insert alldistinct, clarsimp)
apply (rule, clarsimp)
apply (rule, clarsimp)
apply (simp add: allocQBODY_def)
apply (rule vdm_conseq)
apply (rule vdm_letr, rule vdm_getfr) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv, rule vdm_putfr) prefer 2 apply clarsimp prefer 2
apply (rule vdm_rvar) apply clarsimp defer 1
apply (rule, clarsimp)
apply (simp add: fill2BODY_def)
apply (rule vdm_conseq) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv, rule vdm_putfi) prefer 2 apply clarsimp prefer 2
apply (rule vdm_rvar) apply clarsimp defer 1
apply clarsimp 
apply (simp add: fill4BODY_def)
apply (rule vdm_conseq) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv, rule vdm_putfi) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv, rule vdm_putfi) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv, rule vdm_putfr) prefer 2 apply clarsimp prefer 2
apply (rule vdm_rvar) apply clarsimp defer 1
apply clarsimp
apply (rule, clarsimp)
apply rule
apply (rule goodState)
apply clarsimp
apply (subgoal_tac "C = DIAMOND", clarsimp)
prefer 2 apply (insert typing)
  apply (erule_tac x=E' in allE,
         erule_tac x=h' in allE,
         erule_tac x=a in allE,
         erule_tac x=C in allE, fast)
  apply (rotate_tac -1, erule thin_rl)
apply (simp add: allocBODY_def)
apply (rule vdm_conseq)
apply (rule vdm_letr, rule vdm_getfr) prefer 2 apply clarsimp 
apply (rule vdm_leti, rule vdm_rprim) prefer 2 apply clarsimp prefer 2
apply (rule vdm_if)
apply (rule vdm_new) 
apply (subgoal_tac "{(flp\<diamondsuit>alloc(dummyPar), Mspectable DIAMOND alloc), (flp\<diamondsuit>free(node), Mspectable DIAMOND free),
           (flp\<diamondsuit>make1(PARmake), Mspectable DIAMOND make1), (flp\<diamondsuit>make3(PARmake), Mspectable DIAMOND make3), (CALL allocQ, spectable allocQ), (CALL fill2TEMP, spectable fill2TEMP),
           (CALL fill4TEMP, spectable fill4TEMP)} \<rhd>  (CALL allocQ) : spectable allocQ", simp)
apply (rule vdm_ax, simp)
apply rule
apply rule
apply rule
apply (rule goodState)
apply clarsimp
apply (subgoal_tac "C = DIAMOND", clarsimp)
prefer 2 apply (insert typing)
  apply (erule_tac x=E' in allE,
         erule_tac x=h' in allE,
         erule_tac x=a in allE,
         erule_tac x=C in allE, fast)
  apply (rotate_tac -1, erule thin_rl)
apply (simp add: freeBODY_def)
apply (rule vdm_conseq) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr, rule vdm_getfr) prefer 2 apply clarsimp
apply (rule vdm_letv, rule vdm_putfr)
apply (rule vdm_putfr) apply clarsimp
apply rule
apply rule
apply rule
apply (rule goodState)
apply clarsimp
apply (subgoal_tac "C = DIAMOND", clarsimp)
prefer 2 apply (insert typing)
  apply (erule_tac x=E' in allE,
         erule_tac x=h' in allE,
         erule_tac x=a in allE,
         erule_tac x=C in allE, fast)
  apply (rotate_tac -1, erule thin_rl)
apply (simp add: make1BODY_def)
apply (rule vdm_conseq) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr, rule vdm_null) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr, rule vdm_rvar) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr)
apply (subgoal_tac "{(flp\<diamondsuit>alloc(dummyPar), Mspectable DIAMOND alloc), (flp\<diamondsuit>free(node), Mspectable DIAMOND free),
           (flp\<diamondsuit>make1(PARmake), Mspectable DIAMOND make1), (flp\<diamondsuit>make3(PARmake), Mspectable DIAMOND make3), (CALL allocQ, spectable allocQ), (CALL fill2TEMP, spectable fill2TEMP),
           (CALL fill4TEMP, spectable fill4TEMP)} \<rhd>  (flp\<diamondsuit>alloc(dummyPar)) : Mspectable DIAMOND alloc", simp)
apply (rule vdm_ax, simp) prefer 2 apply clarsimp prefer 2
apply (rule vdm_leti, rule vdm_getfi) prefer 2 apply clarsimp prefer 2
apply (subgoal_tac "{(flp\<diamondsuit>alloc(dummyPar), Mspectable DIAMOND alloc), (flp\<diamondsuit>free(node), Mspectable DIAMOND free),
           (flp\<diamondsuit>make1(PARmake), Mspectable DIAMOND make1), (flp\<diamondsuit>make3(PARmake), Mspectable DIAMOND make3), (CALL allocQ, spectable allocQ), (CALL fill2TEMP, spectable fill2TEMP),
           (CALL fill4TEMP, spectable fill4TEMP)} \<rhd>  (CALL fill2TEMP) : spectable fill2TEMP", simp)
apply (rule vdm_ax, simp) defer 1
apply rule
apply rule
apply (rule goodState)
apply clarsimp
apply (subgoal_tac "C = DIAMOND", clarsimp)
prefer 2 apply (insert typing)
  apply (erule_tac x=E' in allE,
         erule_tac x=h' in allE,
         erule_tac x=a in allE,
         erule_tac x=C in allE, fast)
  apply (rotate_tac -1, erule thin_rl)
apply (simp add: make3BODY_def)
apply (rule vdm_conseq) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr, rule vdm_null) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr, rule vdm_rvar) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr)
apply (subgoal_tac "{(flp\<diamondsuit>alloc(dummyPar), Mspectable DIAMOND alloc), (flp\<diamondsuit>free(node), Mspectable DIAMOND free),
           (flp\<diamondsuit>make1(PARmake), Mspectable DIAMOND make1), (flp\<diamondsuit>make3(PARmake), Mspectable DIAMOND make3), (CALL allocQ, spectable allocQ), (CALL fill2TEMP, spectable fill2TEMP),
           (CALL fill4TEMP, spectable fill4TEMP)} \<rhd>  (flp\<diamondsuit>alloc(dummyPar)) : Mspectable DIAMOND alloc", simp)
apply (rule vdm_ax, simp) prefer 2 apply clarsimp prefer 2
apply (rule vdm_leti, rule vdm_getfi) prefer 2 apply clarsimp prefer 2
apply (rule vdm_leti, rule vdm_getfi) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr, rule vdm_getfr) prefer 2 apply clarsimp prefer 2
apply (subgoal_tac "{(flp\<diamondsuit>alloc(dummyPar), Mspectable DIAMOND alloc), (flp\<diamondsuit>free(node), Mspectable DIAMOND free),
           (flp\<diamondsuit>make1(PARmake), Mspectable DIAMOND make1), (flp\<diamondsuit>make3(PARmake), Mspectable DIAMOND make3), (CALL allocQ, spectable allocQ), (CALL fill2TEMP, spectable fill2TEMP),
           (CALL fill4TEMP, spectable fill4TEMP)} \<rhd>  (CALL fill4TEMP) : spectable fill4TEMP", simp)
apply (rule vdm_ax, simp) defer 1
(*vc of allocQ*)
apply (simp add: spectAllocQ)
apply clarsimp
apply (erule modelsStatic.elims, simp_all, clarsimp)
apply (erule modelsFreelist.elims, simp_all, clarsimp)
apply (simp add: renvQ_def)
apply (rule_tac x=Nullref in exI, clarsimp)
apply rule
apply (rule_tac x=d in exI, rule_tac x=f0 in exI, rule_tac x=f1 in exI, clarsimp)
apply (rule ST_none)
apply (simp)
apply (erule modelsDIAMOND.elims, simp_all)
apply clarsimp
apply (simp add: renvQ_def)
apply (rule_tac x="Ref n" in exI, simp)
apply rule
apply (rule_tac x=d in exI, rule_tac x=f0 in exI, rule_tac x=f1 in exI, simp)
apply (rule ST_some) 
apply simp
apply (erule modelsDIAMOND.elims, simp_all)
apply (subgoal_tac "X - {la} \<subseteq> X")
apply (rule modelsFreelist_Same)
prefer 3 apply (assumption)
prefer 3 apply assumption
apply (simp add: same_def)
apply simp
apply fast
(*vc of fill2TEMP*)
apply (simp add: spectFill2TEMP renvFill2_def)
(*vc of fill4TEMP*)
apply (simp add: spectFill4TEMP renvFill4_def)
(*vc of make1*)
apply (simp add:spectMake1)
apply clarsimp
apply (rule_tac x=r in exI, rule_tac x=h1 in exI, rule_tac x=p1 in exI, clarsimp)
apply (rule_tac x=p2a in exI, clarsimp)
apply (simp add: renvMake1_def)
(*vc of make3*)
apply (simp add:spectMake3)
apply clarsimp
apply (rule_tac x=r in exI, rule_tac x=h1 in exI, rule_tac x=p1 in exI, clarsimp)
apply (rule_tac x=p2a in exI, clarsimp)
apply (simp add: renvMake3_def)
done

(* Lemma to prove *)
lemma (in DiamondClone) "\<rhd> ( Invokestatic clone3 larg)::nat expr) : (Mspectable CLONELIST clone3)"
end


