
lemma SSpec_implies_complete:
"( {} \<rhd> e: SSpec e) \<Longrightarrow> ( \<Turnstile> e : P) \<Longrightarrow> ( \<rhd> e : P)"
sorry

lemma SSPec_lemma: "(\<forall> f. G \<rhd> ((Call f)::'a expr) : SSpec ((Call f)::'a expr)) \<Longrightarrow> G \<rhd> (e::'a expr): SSpec e"
apply (simp add:SSpec_def sem_def)
apply (induct e)
(*Int*)
apply (rule vdm_conseq, rule vdm_int, clarsimp)
apply (rule_tac x=1 in exI, rule semInt)
(*IVar*)
apply (rule vdm_conseq, rule vdm_ivar, clarsimp)
apply (rule_tac x=1 in exI, rule semIVar)
(*Primop*)
apply (rule vdm_conseq, rule vdm_prim, clarsimp)
apply (rule_tac x=1 in exI, rule semPrimop)
(*Null*)
apply (rule vdm_conseq, rule vdm_null, clarsimp)
apply (rule_tac x=1 in exI, rule semNull)
(*RVar*)
apply (rule vdm_conseq, rule vdm_rvar, clarsimp)
apply (rule_tac x=1 in exI, rule semRVar)
(*RPrimop*)
apply (rule vdm_conseq, rule vdm_rprim, clarsimp)
apply (rule_tac x=1 in exI, rule semRPrimop)
(*New*)
apply (rule vdm_conseq, rule vdm_new, clarsimp)
apply (rule_tac x=1 in exI, rule semNew, simp)
(*Getfi*)
apply (rule vdm_conseq, rule vdm_getfi, clarsimp)
apply (rule_tac x=1 in exI, rule semGetfi, simp)
(*Getfr*)
apply (rule vdm_conseq, rule vdm_getfr, clarsimp)
apply (rule_tac x=1 in exI, rule semGetfr, simp)
(*Putfi*)
apply (rule vdm_conseq, rule vdm_putfi, clarsimp)
apply (rule_tac x=1 in exI, rule semPutfi, simp)
(*Putfr*)
apply (rule vdm_conseq, rule vdm_putfr, clarsimp)
apply (rule_tac x=1 in exI, rule semPutfr, simp)
(*Invoke*)
defer 1
(*InvokeStatic*)
defer 1
(*mhinvoke*)
defer 1
(*mhinvokestatic*)
defer 1
(*Leti*)
apply (rule vdm_conseq, rule vdm_leti, fast, fast, clarsimp)
apply (rule_tac x="(max n na) + 1" in exI, insert semLeti, fastsimp)
(* Letr*)
apply (rotate_tac -1)
apply (erule thin_rl)
apply (rule vdm_conseq, rule vdm_letr, fast, fast, clarsimp)
apply (rule_tac x="(max n na) + 1" in exI, insert semLetr, fastsimp)
(* Letv*)
apply (rotate_tac -2)
apply (erule thin_rl)
apply (erule thin_rl)
apply (rule vdm_conseq, rule vdm_letv, fast, fast, clarsimp)
apply (rule_tac x="(max n na)" in exI, insert semLetv, fastsimp)
(*If*)
apply (rotate_tac -3)
apply (erule thin_rl)
apply (erule thin_rl)
apply (erule thin_rl)
apply (rule vdm_conseq, rule vdm_if, fast, fast, clarsimp)
apply (case_tac "a<iname>=1", clarsimp)
apply (rule_tac x="n+1" in exI, insert semIf_True, fastsimp)
apply (subgoal_tac "a<iname>=0", clarsimp)
apply (rule_tac x="n+1" in exI, insert semIf_False, fastsimp)
apply clarsimp (* E<x> is either true or false*)
(*Call*)
apply (rotate_tac 1)
apply (erule thin_rl)
apply (erule thin_rl)
apply (erule thin_rl)
apply (erule thin_rl)
apply (erule thin_rl)
apply (erule_tac x="funame" in allE, assumption)
(*Ann*)
defer 1
sorry

lemma Spec_emptycontext: "{} \<rhd> (Call f) : SSpec (Call f)"
apply (insert SSPec_lemma [of "{}" "Call f"])
apply (subgoal_tac "(G \<union> {(Call f,SSpec (CALL f))}) \<rhd> (funtable f) : {(E,h,hh,v,p) . (E,h,hh,v,tkcall p) \<in> SSpec (CALL f)}")
apply (rule vdm_call)
apply simp
apply (simp add: SSpec_def sem_def)
subsection{*Syntatic characterisation of SSpec*}
consts
 syn_sspec :: "'a expr \<Rightarrow> vdmassn"
 
primrec 
 "syn_sspec Null       	       = {(E,h,hh,v,p) . h = hh \<and> v = RVal Nullref \<and> p = tickRo}"
 "syn_sspec (expr.Int i)     	       = {(E,h,hh,v,p) . h = hh \<and> v = IVal i \<and> p = tickRo}"
 "syn_sspec (expr.IVar x)             = {(E,h,hh,v,p) . h = hh \<and> v = IVal (E<x>) \<and> p = tickRo}"
 "syn_sspec (expr.RVar x)             = {(E,h,hh,v,p) . h = hh \<and> v = RVal (E\<lfloor>x\<rfloor>) \<and> p = tickRo}"
 "syn_sspec (expr.Primop f x y)       = {(E,h,hh,v,p) . h = hh \<and> v = IVal (f (E<x>) (E<y>)) \<and> p = mkREnv 3 0 0 0}"
 "syn_sspec (RPrimop f x y)           = {(E,h,hh,v,p) . h = hh \<and> v = IVal (f (E\<lfloor>x\<rfloor>) (E\<lfloor>y\<rfloor>)) \<and> p = mkREnv 3 0 0 0}"
 "syn_sspec (GetFi x f)               = {(E,h,hh,v,p). \<exists> a . E\<lfloor>x\<rfloor> = Ref a \<and> h = hh \<and> v = IVal ((heap.iheap h) f a) \<and> 
                                                      p = mkREnv 2 0 0 0}"
 "syn_sspec (GetFr x f)               = {(E,h,hh,v,p). \<exists> a . E\<lfloor>x\<rfloor> = Ref a \<and> h = hh \<and> v = RVal ((heap.rheap h) f a) \<and> 
                                                      p = mkREnv 2 0 0 0}"
 "syn_sspec (PutFi x f y)             = {(E,h,hh,v,p). \<exists> a . E\<lfloor>x\<rfloor> = Ref a \<and> 
                                                      hh = \<lparr>oheap = heap.oheap h, 
                                                            iheap = (heap.iheap h)(f := ((heap.iheap h) f)(a := E<y>)), 
                                                            rheap = heap.rheap h\<rparr> \<and> 
                                                      v = arbitrary \<and> p = mkREnv 3 0 0 0}"
 "syn_sspec (PutFr x f y)             = {(E,h,hh,v,p). \<exists> a . E\<lfloor>x\<rfloor> = Ref a \<and> 
                                                      hh = \<lparr>oheap = heap.oheap h, 
                                                            iheap = heap.iheap h,
                                                            rheap = (heap.rheap h)(f := ((heap.rheap h) f)(a := E\<lfloor>y\<rfloor>))\<rparr> \<and>
                                                      v = arbitrary \<and> p = mkREnv 3 0 0 0}"

 "syn_sspec (New c ifldvals rfldvals) = {(E,h,hh,v,p) . \<exists> l . l = freshloc (fmap_dom (heap.oheap h)) \<and> 
                                                       hh = newObj h l E c ifldvals rfldvals \<and>
                                                       v = RVal (Ref l) \<and> p = tickRo}"
 "syn_sspec (Ifg x e1 e2)             = {(E,h,hh,v,p). \<exists> pp . (E<x> =  grailbool True \<longrightarrow> (E,h,hh,v,pp) \<in> syn_sspec e1) \<and> 
                                                       (E<x> =  grailbool False \<longrightarrow> (E,h,hh,v,pp) \<in> syn_sspec e2) \<and>
                                                       p = tkn 2 pp \<and>
                                                       (E<x> =  grailbool True \<or> E<x> =  grailbool False)}"
 "syn_sspec (Leti x e1 e2)            = {(E,h,hh,v,p). \<exists> h1 i p1 p2. (E,h,h1,IVal i,p1) \<in> syn_sspec e1 \<and>
                                                              (E<x:=i>,h1,hh,v,p2) \<in> syn_sspec e2 \<and>
                                                              p = tk (p1 \<smile> p2)}"
 "syn_sspec (Letr x e1 e2)            = {(E,h,hh,v,p). \<exists> h1 r p1 p2. (E,h,h1,RVal r,p1) \<in> syn_sspec e1 \<and>
                                                              (E\<lfloor>x:=r\<rfloor>,h1,hh,v,p2) \<in> syn_sspec e2 \<and>
                                                              p = tk (p1 \<smile> p2)}"
 "syn_sspec (Letv e1 e2)              = {(E,h,hh,v,p). \<exists> h1 w p1 p2. (E,h,h1,w,p1) \<in> syn_sspec e1 \<and>
                                                              (E,h1,hh,v,p2) \<in> syn_sspec e2 \<and>
                                                              p = (p1 \<smile> p2)}"

(* NB: cases for procedures advised by T. Nipkow, after T. Kleymann *)
(* "syn_sspec (Invoke vn1 mn vn2) Q = 
  {(z,s). \<forall> t v. (\<forall> z. (z,s) \<in> (fst (meth_assn_table mn)) \<longrightarrow> 
				((z,t,v) \<in> (snd (meth_assn_table mn))) \<longrightarrow> (z,t,v) \<in> Q)}"

 "syn_sspec (Call f) Q = {(z,s). \<forall> t v. (\<forall> z. (z,s) \<in> (fst (fun_assn_table f)) \<longrightarrow> 
						     (z,t,v) \<in> (snd (fun_assn_table f)) \<longrightarrow> (z,t,v) \<in> Q)}"

*)

(*Proof complete except for call, ann and four invokes*)
lemma SSpec_syn_sspec: "SSpec e \<subseteq> syn_sspec e"
apply (induct e)
apply (simp_all add:SSpec_def sem_def)
apply (clarsimp, erule semn.elims, simp_all)
apply (clarsimp, erule semn.elims, simp_all)
apply (clarsimp, erule semn.elims, simp_all)
apply (clarsimp, erule semn.elims, simp_all)
apply (clarsimp, erule semn.elims, simp_all)
apply (clarsimp, erule semn.elims, simp_all)
apply (clarsimp, erule semn.elims, simp_all)
apply (clarsimp, erule semn.elims, simp_all)
apply (clarsimp, erule semn.elims, simp_all)
apply (clarsimp, erule semn.elims, simp_all)
apply (clarsimp, erule semn.elims, simp_all)
defer 1
defer 1
defer 1
defer 1
apply (clarsimp, erule semn.elims, simp_all)
  apply clarsimp
  apply (rule_tac x=h1 in exI, rule_tac x=i in exI, rule_tac x=p1 in exI, simp, rule)
  apply fastsimp 
  apply (rule_tac x=p2 in exI, simp)
  apply fastsimp
apply (clarsimp, erule semn.elims, simp_all)
  apply clarsimp
  apply (rule_tac x=h1 in exI, rule_tac x=r in exI, rule_tac x=p1 in exI, simp, rule)
  apply fastsimp 
  apply (rule_tac x=p2 in exI, simp)
  apply fastsimp
apply (clarsimp, erule semn.elims, simp_all)
  apply clarsimp
  apply (rule_tac x=h1 in exI, rule_tac x=w in exI, rule_tac x=p1 in exI, simp, rule)
  apply fastsimp 
  apply (rule_tac x=p2 in exI, simp)
  apply fastsimp
apply (clarsimp, erule semn.elims, simp_all)
  apply clarsimp
  apply (rule_tac x=p in exI, simp)
  apply fastsimp
  apply clarsimp
  apply (rule_tac x=p in exI, simp)
  apply fastsimp
sorry

lemma syn_sspec_SSpec: "syn_sspec e \<subseteq> SSpec e"
apply (induct e)
apply (simp_all add:SSpec_def sem_def)
apply (clarsimp, insert semInt, fastsimp)
apply ((erule_tac thin_rl)+, clarsimp, insert semIVar, fastsimp)
apply ((erule_tac thin_rl)+, clarsimp, insert semPrimop, fastsimp)
apply ((erule_tac thin_rl)+, clarsimp, insert semNull, fastsimp)
apply ((erule_tac thin_rl)+, clarsimp, insert semRVar, fastsimp)
apply ((erule_tac thin_rl)+, clarsimp, insert semRPrimop, fastsimp)
apply ((erule_tac thin_rl)+, clarsimp, insert semNew, fastsimp)
apply ((erule_tac thin_rl)+, clarsimp, insert semGetfi, fastsimp)
apply ((erule_tac thin_rl)+, clarsimp, insert semGetfr, fastsimp)
apply ((erule_tac thin_rl)+, clarsimp, insert semPutfi, fastsimp)
apply ((erule_tac thin_rl)+, clarsimp, insert semPutfr, fastsimp)
defer 1 (*Invoke*)
defer 1 (*Invokestatic*)
defer 1 (*MHInvoke*)
defer 1 (*MHInvokeStatic*)
apply (clarsimp, insert semLeti)
apply (rotate_tac 2)
apply (erule_tac thin_rl)
apply (erule_tac thin_rl)
apply (erule_tac thin_rl)
apply (erule_tac thin_rl)
apply (erule_tac thin_rl)
apply (erule_tac thin_rl)
apply (erule_tac thin_rl)
apply (erule_tac thin_rl)
apply (erule_tac thin_rl)
apply (erule_tac thin_rl)
apply (erule_tac thin_rl)
apply (subgoal_tac "\<exists>n. a \<turnstile> aa , expr1 \<Down>n (h1 , IVal i , p1)")
apply (subgoal_tac "\<exists>n. a<iname:=i> \<turnstile> h1 , expr2 \<Down>n (ab , ac , p2)")
apply clarsimp
apply (rule_tac x="(max n na) +1" in exI)
apply fastsimp
apply fast
apply fast
apply (clarsimp, insert semLetr)
apply (rotate_tac 2)
apply (erule_tac thin_rl)
apply (erule_tac thin_rl)
apply (erule_tac thin_rl)
apply (erule_tac thin_rl)
apply (erule_tac thin_rl)
apply (erule_tac thin_rl)
apply (erule_tac thin_rl)
apply (erule_tac thin_rl)
apply (erule_tac thin_rl)
apply (erule_tac thin_rl)
apply (erule_tac thin_rl)
apply (erule_tac thin_rl)
apply (subgoal_tac "\<exists>n. a \<turnstile> aa , expr1 \<Down>n (h1 , RVal r , p1)")
apply (subgoal_tac "\<exists>n. a\<lfloor>rname:=r\<rfloor>  \<turnstile> h1 , expr2 \<Down>n (ab , ac , p2)")
apply clarsimp
apply (rule_tac x="(max n na) +1" in exI)
apply fastsimp
apply fast
apply fast
apply (clarsimp, insert semLetv)
apply (rotate_tac 2)
apply (erule_tac thin_rl)
apply (erule_tac thin_rl)
apply (erule_tac thin_rl)
apply (erule_tac thin_rl)
apply (erule_tac thin_rl)
apply (erule_tac thin_rl)
apply (erule_tac thin_rl)
apply (erule_tac thin_rl)
apply (erule_tac thin_rl)
apply (erule_tac thin_rl)
apply (erule_tac thin_rl)
apply (erule_tac thin_rl)
apply (erule_tac thin_rl)
apply (subgoal_tac "\<exists>n. a \<turnstile> aa , expr1 \<Down>n (h1 , w , p1)")
apply (subgoal_tac "\<exists>n. a \<turnstile> h1 , expr2 \<Down>n (ab , ac , p2)")
apply clarsimp
apply (rule_tac x="(max n na)" in exI)
apply fastsimp
apply fast
apply fast
apply clarsimp
apply (rotate_tac 2)
apply (erule_tac thin_rl)
apply (erule_tac thin_rl)
apply (erule_tac thin_rl)
apply (erule_tac thin_rl)
apply (erule_tac thin_rl)
apply (erule_tac thin_rl)
apply (erule_tac thin_rl)
apply (erule_tac thin_rl)
apply (erule_tac thin_rl)
apply (erule_tac thin_rl)
apply (erule_tac thin_rl)
apply (erule_tac thin_rl)
apply (erule_tac thin_rl)
apply (erule_tac thin_rl)
apply (case_tac "a<iname>=1", clarsimp)
apply (rotate_tac 2) apply (erule_tac thin_rl)
apply (subgoal_tac "\<exists>n. a \<turnstile> aa , expr1 \<Down>n (ab , ac , pp)")
prefer 2 apply fast
apply (rotate_tac 1) apply (erule_tac thin_rl) apply (erule_tac thin_rl)
apply clarsimp
apply (rule_tac x="n +1" in exI)
apply (insert semIf_True, fastsimp)
apply (erule_tac thin_rl)
apply (subgoal_tac "a<iname> = 0")
prefer 2 apply clarsimp
apply clarsimp
apply (rotate_tac 1) apply (erule_tac thin_rl)
apply (rotate_tac 1) apply (erule_tac thin_rl)
apply (subgoal_tac "\<exists>n. a \<turnstile> aa , expr2 \<Down>n (ab , ac , pp)")
prefer 2 apply fast
apply (rotate_tac 1) apply (erule_tac thin_rl) apply (erule_tac thin_rl)
apply clarsimp
apply (rule_tac x="n +1" in exI)
apply (insert semIf_False, fastsimp)
sorry

lemma SSpecsyn_sspec: "syn_sspec e = SSpec e"
by (insert syn_sspec_SSpec SSpec_syn_sspec, fastsimp)

lemma synt_sspec: "\<Turnstile> e: syn_sspec e"
apply (subgoal_tac "\<Turnstile> e : SSpec e")
apply (simp add: SSpecsyn_sspec)
apply (simp add: SSpec_valid)
done

(* The condition of being a weakest pre-condition. *)

constdefs
  SYN_SSPEC :: "'a expr \<Rightarrow> vdmassn \<Rightarrow> bool"
  "SYN_SSPEC e P \<equiv>  (\<Turnstile> e : P) \<and> (\<forall> Q. (\<Turnstile> e : Q) \<longrightarrow> P \<subseteq> Q)"

(* proof complete for all instructions except call, Ann, and the frour invokes*)
lemma SYN_SSPECsyn_sspec: "SYN_SSPEC e (syn_sspec e)"
apply (induct e)
(*case Int*)
apply (simp add: SYN_SSPEC_def)
apply rule
apply (simp add: vdm_valid_def sem_def, clarsimp)
apply (erule semn.elims, simp_all add: vdm_valid_def sem_def)
apply clarsimp
apply (subgoal_tac "a \<turnstile> ab , (expr.Int int) \<Down>1 (ab , IVal int , tickRo)")
apply fastsimp
apply (rule semInt)
(*case IVar*)
apply (simp add: SYN_SSPEC_def)
apply rule
apply (simp add: vdm_valid_def sem_def, clarsimp)
apply (erule semn.elims, simp_all add: vdm_valid_def sem_def)
apply clarsimp
apply (subgoal_tac "a \<turnstile> ab , IVar iname \<Down>1 (ab , IVal (a<iname>) , tickRo)")
apply fastsimp
apply (rule semIVar)
(*case Primop*)
apply (simp add: SYN_SSPEC_def)
apply rule
apply (simp add: vdm_valid_def sem_def, clarsimp)
apply (erule semn.elims, simp_all add: vdm_valid_def sem_def)
apply clarsimp
apply (subgoal_tac "a \<turnstile> ab , Primop fun iname1 iname2 \<Down>1 (ab , IVal (fun (a<iname1>) (a<iname2>)), mkREnv 3 0 0 0)")
apply fastsimp
apply (rule semPrimop)
(* Case Null*)
apply (simp add: SYN_SSPEC_def)
apply rule
apply (simp add: vdm_valid_def sem_def, clarsimp)
apply (erule semn.elims, simp_all add: vdm_valid_def sem_def)
apply clarsimp
apply (subgoal_tac "a \<turnstile> ab , NULL \<Down>1 (ab , RVal Nullref , tickRo)")
apply fastsimp
apply (rule semNull)
(*case RVar*)
apply (simp add: SYN_SSPEC_def)
apply rule
apply (simp add: vdm_valid_def sem_def, clarsimp)
apply (erule semn.elims, simp_all add: vdm_valid_def sem_def)
apply clarsimp
apply (subgoal_tac "a \<turnstile> ab , RVar rname \<Down>1 (ab , RVal (a\<lfloor>rname\<rfloor>) , tickRo)")
apply fastsimp
apply (rule semRVar)
(*case RPrimop*)
apply (simp add: SYN_SSPEC_def)
apply rule
apply (simp add: vdm_valid_def sem_def, clarsimp)
apply (erule semn.elims, simp_all add: vdm_valid_def sem_def)
apply clarsimp
apply (subgoal_tac "a \<turnstile> ab , RPrimop fun rname1 rname2 \<Down>1 (ab , IVal (fun (a\<lfloor>rname1\<rfloor>) (a\<lfloor>rname2\<rfloor>)), mkREnv 3 0 0 0)")
apply fastsimp
apply (rule semRPrimop)
(* Case New*)
apply (simp add: SYN_SSPEC_def)
apply rule
apply (simp add: vdm_valid_def sem_def, clarsimp)
apply (erule semn.elims, simp_all add: vdm_valid_def sem_def)
apply clarsimp
apply (subgoal_tac "a \<turnstile> aa , NEW <cname> (list1,list2) \<Down>1 (newObj aa (freshloc (fmap_dom (heap.oheap aa))) a cname list1 list2 , RVal (Ref (freshloc (fmap_dom (heap.oheap aa)))) , tickRo)")
apply fastsimp
apply (rule semNew, simp)
(*case Getfi*)
apply (simp add: SYN_SSPEC_def)
apply rule
apply (simp add: vdm_valid_def sem_def, clarsimp)
apply (erule semn.elims, simp_all add: vdm_valid_def sem_def)
apply clarsimp
apply (subgoal_tac "a \<turnstile> ab , rname\<bullet>ifldname \<Down>1 (ab , IVal (heap.iheap ab ifldname ad) , mkREnv 2 0 0 0)")
apply fastsimp
apply (rule semGetfi, simp)
(*case Getfr*)
apply (simp add: SYN_SSPEC_def)
apply rule
apply (simp add: vdm_valid_def sem_def, clarsimp)
apply (erule semn.elims, simp_all add: vdm_valid_def sem_def)
apply clarsimp
apply (subgoal_tac "a \<turnstile> ab , rname\<diamondsuit>rfldname \<Down>1 (ab , RVal (heap.rheap ab rfldname ad) , mkREnv 2 0 0 0)")
apply fastsimp
apply (rule semGetfr, simp)
(*case Putfi*)
apply (simp add: SYN_SSPEC_def)
apply rule
apply (simp add: vdm_valid_def sem_def, clarsimp)
apply (erule semn.elims, simp_all add: vdm_valid_def sem_def)
apply clarsimp
apply (subgoal_tac "a \<turnstile> aa , rname\<bullet>ifldname := iname \<Down>1 (\<lparr>oheap = heap.oheap aa,
              iheap = (heap.iheap aa)(ifldname := (heap.iheap aa ifldname)(ad := a<iname>)),
              rheap = heap.rheap aa\<rparr>,
           arbitrary, mkREnv 3 0 0 0)")
apply fastsimp
apply (rule semPutfi, simp)
(*case Putfr*)
apply (simp add: SYN_SSPEC_def)
apply rule
apply (simp add: vdm_valid_def sem_def, clarsimp)
apply (erule semn.elims, simp_all add: vdm_valid_def sem_def)
apply clarsimp
apply (subgoal_tac "a \<turnstile> aa , rname1\<diamondsuit>rfldname := rname2 \<Down>1 (\<lparr>oheap = heap.oheap aa,
              iheap = heap.iheap aa, rheap = (heap.rheap aa)(rfldname := (heap.rheap aa rfldname)(ad := a\<lfloor>rname2\<rfloor>))\<rparr>,
           arbitrary, mkREnv 3 0 0 0)")
apply fastsimp
apply (rule semPutfr, simp)
defer 1 (*invoke*)
defer 1 (*invokestatic*)
defer 1 (*mh_invoke*)
defer 1 (*mh_invokestatic*)
prefer 4
(*case If*)
apply (simp add: SYN_SSPEC_def)
apply rule
apply (simp (no_asm) add: vdm_valid_def sem_def, clarsimp)
apply (erule semn.elims, simp_all add: vdm_valid_def sem_def)
apply clarsimp
apply (rule_tac x=pa in exI, simp)
apply fastsimp
apply clarsimp
apply (rule_tac x=pa in exI, simp)
apply fastsimp
apply clarsimp
apply (case_tac "a<iname>=1")
  apply clarsimp
  apply (rotate_tac 1)
  apply (erule_tac x="{(E,h,hh,v,p) . (\<exists>n. E \<turnstile> h , expr1 \<Down>n (hh , v , p))}" in allE)
  apply clarsimp
  apply (subgoal_tac "(a, aa, ab, ac, pp) \<in> {(E, h, hh, v, p). \<exists>n. E \<turnstile> h , expr1 \<Down>n (hh , v , p)}")
    prefer 2 apply (simp only: subsetD)
  apply (subgoal_tac "\<exists>n. a \<turnstile> aa , expr1 \<Down>n (ab , ac , pp)")
    prefer 2 apply simp
  apply (erule thin_rl)
  apply (erule thin_rl)
  apply (subgoal_tac "(a, aa, ab, ac, tkn 2 pp) \<in> Q")
  apply simp
  apply (erule_tac x=a in allE, erule_tac x=aa in allE, erule_tac x=ab in allE, 
         erule_tac x=ac in allE, erule_tac x="tkn 2 pp" in allE)
  apply (subgoal_tac "\<exists>n. a \<turnstile> aa , IF iname THEN expr1 ELSE expr2 \<Down>n (ab , ac , tkn 2 pp)")
  apply simp
  apply clarsimp
  apply (rule_tac x="(n + 1)" in exI)
  apply (subgoal_tac "a \<turnstile> aa , IF iname THEN expr1
                    ELSE expr2 \<Down>(n + 1) (ab , ac , tkn 2 pp)")
    prefer 2 apply(rule semIf_True, simp, simp)
  apply simp
(*case \<noteq> 0*)
  apply (subgoal_tac "a<iname>=0")
  apply clarsimp
  apply (erule thin_rl)
  apply (erule thin_rl)
  apply (rotate_tac 1)
  apply (erule_tac x="{(E,h,hh,v,p) . (\<exists>n. E \<turnstile> h , expr2 \<Down>n (hh , v , p))}" in allE)
  apply clarsimp
  apply (subgoal_tac "(a, aa, ab, ac, pp) \<in> {(E, h, hh, v, p). \<exists>n. E \<turnstile> h , expr2 \<Down>n (hh , v , p)}")
    prefer 2 apply (simp only: subsetD)
  apply (subgoal_tac "\<exists>n. a \<turnstile> aa , expr2 \<Down>n (ab , ac , pp)")
    prefer 2 apply simp
  apply (subgoal_tac "(a, aa, ab, ac, tkn 2 pp) \<in> Q")
  apply simp
  apply (erule_tac x=a in allE, erule_tac x=aa in allE, erule_tac x=ab in allE, 
         erule_tac x=ac in allE, erule_tac x="tkn 2 pp" in allE)
  apply (subgoal_tac "\<exists>n. a \<turnstile> aa , IF iname THEN expr1 ELSE expr2 \<Down>n (ab , ac , tkn 2 pp)")
  apply simp
  apply clarsimp
  apply (rule_tac x="(n + 1)" in exI)
  apply (subgoal_tac "a \<turnstile> aa , IF iname THEN expr1
                    ELSE expr2 \<Down>(n + 1) (ab , ac , tkn 2 pp)")
    prefer 2 apply(rule semIf_False, simp, simp)
  apply simp
apply simp (*E<iname> is always 1 or 0*)
(*Case Leti*)
apply (simp add: SYN_SSPEC_def)
apply rule
apply (simp (no_asm) add: vdm_valid_def sem_def, clarsimp)
apply (erule semn.elims, simp_all add: vdm_valid_def sem_def)
apply clarsimp
apply (rule_tac x=h1 in exI,rule_tac x=i in exI,rule_tac x=p1 in exI, simp, rule)
apply fastsimp
apply (rule_tac x=p2 in exI, simp)
apply fastsimp
apply clarsimp
apply (subgoal_tac "(\<exists>n. a \<turnstile> aa , LET iname = expr1 IN expr2 END \<Down>n (ab , ac , \<lparr>renv.clock = Suc (renv.clock p1 + renv.clock p2), callc = callc p1 + callc p2, invkc = invkc p1 + invkc p2,
              invkdpth = max (invkdpth p1) (invkdpth p2)\<rparr>))")
apply simp
apply (rotate_tac 1)
apply (erule_tac x="{(E,h,hh,v,p) . (\<exists>n. E \<turnstile> h , expr1 \<Down>n (hh , v , p))}" in allE)
apply simp
apply (subgoal_tac "\<exists>n. a \<turnstile> aa , expr1 \<Down>n (h1 , IVal i , p1)")
  prefer 2 apply (subgoal_tac "(a, aa, h1, IVal i, p1) \<in> {(E, h, hh, v, p). \<exists>n. E \<turnstile> h , expr1 \<Down>n (hh , v , p)}")
             prefer 2 apply (simp only: subsetD)
           apply fast
apply clarsimp
apply (rotate_tac 1)
apply (erule_tac x="{(E,h,hh,v,p) . (\<exists>n. E \<turnstile> h , expr2 \<Down>n (hh , v , p))}" in allE)
apply simp
apply (subgoal_tac "\<exists>n. a<iname:=i> \<turnstile> h1 , expr2 \<Down>n (ab , ac , p2)")
  prefer 2 apply (subgoal_tac "(a<iname:=i>, h1, ab, ac, p2) \<in> {(E, h, hh, v, p). \<exists>n. E \<turnstile> h , expr2 \<Down>n (hh , v , p)}")
             prefer 2 apply (simp only: subsetD)
           apply fast
apply clarsimp
apply (rule_tac x="(max n na) +1" in exI)
apply (subgoal_tac "a \<turnstile> aa , LET iname = expr1 IN expr2 END \<Down>max n na + 1 (ab , ac ,tk (p1 \<smile> p2))")
apply simp
apply (rule semLeti)
apply fastsimp
apply fastsimp
(*Case Letr*)
apply (simp add: SYN_SSPEC_def)
apply rule
apply (simp (no_asm) add: vdm_valid_def sem_def, clarsimp)
apply (erule semn.elims, simp_all add: vdm_valid_def sem_def)
apply clarsimp
apply (rule_tac x=h1 in exI,rule_tac x=r in exI,rule_tac x=p1 in exI, simp, rule)
apply fastsimp
apply (rule_tac x=p2 in exI, simp)
apply fastsimp
apply clarsimp
apply (subgoal_tac "(\<exists>n. a \<turnstile> aa , LET rf rname = expr1 IN expr2 END \<Down>n (ab , ac , \<lparr>renv.clock = Suc (renv.clock p1 + renv.clock p2), callc = callc p1 + callc p2, invkc = invkc p1 + invkc p2,
              invkdpth = max (invkdpth p1) (invkdpth p2)\<rparr>))")
apply simp
apply (rotate_tac 1)
apply (erule_tac x="{(E,h,hh,v,p) . (\<exists>n. E \<turnstile> h , expr1 \<Down>n (hh , v , p))}" in allE)
apply simp
apply (subgoal_tac "\<exists>n. a \<turnstile> aa , expr1 \<Down>n (h1 , RVal r , p1)")
  prefer 2 apply (subgoal_tac "(a, aa, h1, RVal r, p1) \<in> {(E, h, hh, v, p). \<exists>n. E \<turnstile> h , expr1 \<Down>n (hh , v , p)}")
             prefer 2 apply (simp only: subsetD)
           apply fast
apply clarsimp
apply (rotate_tac 1)
apply (erule_tac x="{(E,h,hh,v,p) . (\<exists>n. E \<turnstile> h , expr2 \<Down>n (hh , v , p))}" in allE)
apply simp
apply (subgoal_tac "\<exists>n. a\<lfloor>rname:=r\<rfloor> \<turnstile> h1 , expr2 \<Down>n (ab , ac , p2)")
  prefer 2 apply (subgoal_tac "(a\<lfloor>rname:=r\<rfloor>, h1, ab, ac, p2) \<in> {(E, h, hh, v, p). \<exists>n. E \<turnstile> h , expr2 \<Down>n (hh , v , p)}")
             prefer 2 apply (simp only: subsetD)
           apply fast
apply clarsimp
apply (rule_tac x="(max n na) +1" in exI)
apply (subgoal_tac "a \<turnstile> aa , LET rf rname = expr1 IN expr2 END \<Down>max n na + 1 (ab , ac ,tk (p1 \<smile> p2))")
apply simp
apply (rule semLetr)
apply fastsimp
apply fastsimp
(*Case Letv*)
apply (simp add: SYN_SSPEC_def)
apply rule
apply (simp (no_asm) add: vdm_valid_def sem_def, clarsimp)
apply (erule semn.elims, simp_all add: vdm_valid_def sem_def)
apply clarsimp
apply (rule_tac x=h1 in exI,rule_tac x=w in exI,rule_tac x=p1 in exI, simp, rule)
apply fastsimp
apply (rule_tac x=p2 in exI, simp)
apply fastsimp
apply clarsimp
apply (subgoal_tac "(\<exists>n. a \<turnstile> aa , LET _ = expr1 IN expr2 END \<Down>n (ab , ac , \<lparr>renv.clock = (renv.clock p1 + renv.clock p2), callc = callc p1 + callc p2, invkc = invkc p1 + invkc p2,
              invkdpth = max (invkdpth p1) (invkdpth p2)\<rparr>))")
apply simp
apply (rotate_tac 1)
apply (erule_tac x="{(E,h,hh,v,p) . (\<exists>n. E \<turnstile> h , expr1 \<Down>n (hh , v , p))}" in allE)
apply simp
apply (subgoal_tac "\<exists>n. a \<turnstile> aa , expr1 \<Down>n (h1 , w , p1)")
  prefer 2 apply (subgoal_tac "(a, aa, h1, w, p1) \<in> {(E, h, hh, v, p). \<exists>n. E \<turnstile> h , expr1 \<Down>n (hh , v , p)}")
             prefer 2 apply (simp only: subsetD)
           apply fast
apply clarsimp
apply (rotate_tac 1)
apply (erule_tac x="{(E,h,hh,v,p) . (\<exists>n. E \<turnstile> h , expr2 \<Down>n (hh , v , p))}" in allE)
apply simp
apply (subgoal_tac "\<exists>n. a \<turnstile> h1 , expr2 \<Down>n (ab , ac , p2)")
  prefer 2 apply (subgoal_tac "(a, h1, ab, ac, p2) \<in> {(E, h, hh, v, p). \<exists>n. E \<turnstile> h , expr2 \<Down>n (hh , v , p)}")
             prefer 2 apply (simp only: subsetD)
           apply fast
apply clarsimp
apply (rule_tac x="(max n na)" in exI)
apply (subgoal_tac "a \<turnstile> aa , LET _ = expr1 IN expr2 END \<Down>max n na (ab , ac ,(p1 \<smile> p2))")
apply simp
apply (rule semLetv)
apply fastsimp
apply fastsimp
sorry

text {* We assume a global table of pre-post pair annotations for both
  functions and methods per class. *}

text {* The @text{meth_assn_table} might be indexed by method name and class,
  to allow for dynamic binding.  Instead we may assume that if we are using
  method overriding, the pre-post pairs in the table check in which class
  the object is being acted upon. *}


(* The assumption for the global tables of pre-post pairs *)
consts fun_assn_table:: "funame \<Rightarrow> vdmassn"
       s_meth_assn_table:: "cname \<Rightarrow> mname \<Rightarrow> vdmassn"
       v_meth_assn_table:: "rname \<Rightarrow> mname \<Rightarrow> vdmassn"

constdefs 
  SYN_SSPECassm :: bool
  "SYN_SSPECassm \<equiv>
   (\<forall> fn. SYN_SSPEC ((CALL fn)::heap expr) (fun_assn_table fn)) \<and> 
   (\<forall> C mn arg. SYN_SSPEC ((C\<bullet>mn(arg))::heap expr) (s_meth_assn_table C mn)) \<and>  
   (\<forall> ob mn arg. SYN_SSPEC ((ob\<diamondsuit>mn(arg))::heap expr) (v_meth_assn_table ob mn)) \<and> 
   (\<forall> C mn . SYN_SSPEC ((C\<bullet>\<bullet>mn)::heap expr) (s_meth_assn_table C mn)) \<and> 
   (\<forall> ob mn . SYN_SSPEC ((ob\<diamondsuit>\<diamondsuit>mn)::heap expr) (v_meth_assn_table ob mn))"


lemma syn_sspec_is_pre: "\<Turnstile> e: (syn_sspec e)"
apply (insert SYN_SSPECsyn_sspec)
apply (simp add: SYN_SSPEC_def)
apply fastsimp
done

lemma syn_sspec_is_leastpre: "\<Turnstile> e : P \<Longrightarrow> (syn_sspec e) \<subseteq> P"
apply clarsimp
apply (insert SYN_SSPECsyn_sspec)
apply (simp add: SYN_SSPEC_def)
apply fastsimp
done

end

subsection{*Old stuff*}

lemma CompleteAux:
"\<forall> Gamma P E h hh v p . ((Gamma,e, P) : vdm_d \<longrightarrow> (E \<turnstile> h,e \<Down> hh,v,p) \<longrightarrow> (E,h,hh,v,p) \<in> P)"
apply clarsimp
apply (induct e)
(*Case expr.Int*)
apply (erule vdm_d.elims, simp_all add: sem_def,
       clarsimp,
       erule semn.elims, simp_all)
(*Case IVar*)
apply (erule vdm_d.elims, simp_all add: sem_def,
       clarsimp,
       erule semn.elims, simp_all)
(*Case Primop*)
apply (erule vdm_d.elims, simp_all add: sem_def,
       clarsimp,
       erule semn.elims, simp_all)
apply clarsimp
apply (rule_tac x=p1 in exI, rule_tac x=p2 in exI, simp add: max_def)
apply (rule_tac x=h1 in exI, rule_tac x=i1 in exI)
apply (erule vdm_d.elims, simp_all,
       clarsimp,
       erule semn.elims, simp_all)
apply clarsimp
apply (rule_tac x=i2 in exI)
apply (erule vdm_d.elims, simp_all,
       clarsimp,
       erule semn.elims, simp_all)
(*case NULL*)
apply (erule vdm_d.elims, simp_all,
       clarsimp,
       erule semn.elims, simp_all)
(*case RVar*)
apply (erule vdm_d.elims, simp_all,
       clarsimp,
       erule semn.elims, simp_all)
(*case RPrimop*)
apply (erule vdm_d.elims, simp_all,
       clarsimp,
       erule semn.elims, simp_all)
apply clarsimp
apply (rule_tac x=p1 in exI, rule_tac x=p2 in exI, simp add: max_def)
apply (rule_tac x=h1 in exI, rule_tac x=r1 in exI)
apply (erule vdm_d.elims, simp_all,
       clarsimp,
       erule semn.elims, simp_all)
apply clarsimp
apply (rule_tac x=r2 in exI)
apply (erule vdm_d.elims, simp_all,
       clarsimp,
       erule semn.elims, simp_all)
(*case NEW*)
apply (erule vdm_d.elims, simp_all,
       clarsimp,
       erule semn.elims, simp_all)
(*case Getfi*)
apply (erule vdm_d.elims, simp_all,
       clarsimp,
       erule semn.elims, simp_all)
apply clarsimp
apply (rule_tac x=pa in exI, rule_tac x=a in exI, simp)
apply (erule vdm_d.elims, simp_all,
       clarsimp,
       erule semn.elims, simp_all)
(*case Getfr*)
apply (erule vdm_d.elims, simp_all,
       clarsimp,
       erule semn.elims, simp_all)
apply clarsimp
apply (rule_tac x=pa in exI, rule_tac x=a in exI, simp)
apply (erule vdm_d.elims, simp_all,
       clarsimp,
       erule semn.elims, simp_all)
(*case Putfi*)
apply (erule vdm_d.elims, simp_all,
       clarsimp,
       erule semn.elims, simp_all)
apply clarsimp
apply (rule_tac x=p1 in exI, rule_tac x=p2 in exI, rule_tac x=h1 in exI, rule_tac x=oh in exI, 
       rule_tac x=ih in exI, rule_tac x=rh in exI, rule_tac x=a in exI, simp add: max_def)
apply (erule vdm_d.elims, simp_all,
       clarsimp,
       erule semn.elims, simp_all)
apply clarsimp
apply (rule_tac x=i in exI, simp)
apply (erule vdm_d.elims, simp_all,
       clarsimp,
       erule semn.elims, simp_all)
(*case Putfr*)
apply (erule vdm_d.elims, simp_all,
       clarsimp,
       erule semn.elims, simp_all)
apply clarsimp
apply (rule_tac x=p1 in exI, rule_tac x=p2 in exI, rule_tac x=h1 in exI, rule_tac x=oh in exI, 
       rule_tac x=ih in exI, rule_tac x=rh in exI, rule_tac x=a in exI, simp add: max_def)
apply (erule vdm_d.elims, simp_all,
       clarsimp,
       erule semn.elims, simp_all)
apply clarsimp
apply (rule_tac x=r in exI, simp)
apply (erule vdm_d.elims, simp_all,
       clarsimp,
       erule semn.elims, simp_all)
(*case Invoke*)
apply (erule vdm_d.elims, simp_all)
(*case InvokeStatic*)
apply (erule vdm_d.elims, simp_all)
(*case MH_Invoke*)
apply (erule vdm_d.elims, simp_all)
(*case MH_InvokeStatic*)
apply (erule vdm_d.elims, simp_all,
       clarsimp,
       erule semn.elims, simp_all)
apply clarsimp
apply (erule vdm_d.elims, simp_all,
       clarsimp)
apply clarsimp
apply (rule_tac x=r in exI, simp)
apply (erule vdm_d.elims, simp_all,
       clarsimp,
       erule semn.elims, simp_all)
apply (erule vdm_d.elims, simp_all)
done
(*case Leti*)
apply (erule vdm_d.elims, simp_all,
       clarsimp,
       erule semn.elims, simp_all)
apply clarsimp
apply (rule_tac x=p1 in exI, rule_tac x=p2 in exI, rule_tac x=h1 in exI, 
       rule_tac x=i in exI, simp add: max_def)
apply rule
apply fastsimp
apply fastsimp
(*case Letr*)
apply (erule vdm_d.elims, simp_all,
       clarsimp,
       erule semn.elims, simp_all)
apply clarsimp
apply (rule_tac x=p1 in exI, rule_tac x=p2 in exI, rule_tac x=h1 in exI, 
       rule_tac x=r in exI, simp add: max_def)
apply rule
apply fastsimp
apply fastsimp
(*case Letv*)
apply (erule vdm_d.elims, simp_all,
       clarsimp,
       erule semn.elims, simp_all)
apply clarsimp
apply (rule_tac x=p1 in exI, rule_tac x=p2 in exI, rule_tac x=h1 in exI, simp add: max_def)
apply rule
apply fastsimp
apply fastsimp
(*case If*)
apply (erule vdm_d.elims, simp_all, clarsimp)
apply (erule semn.elims, simp_all)
(*Case true*)
apply clarsimp
apply (rule_tac x=p1 in exI, rule_tac x=h1 in exI, rule_tac x=p2 in exI, simp add: max_def)
apply (subgoal_tac "Ea<xa>=1", clarsimp)
apply rule
apply (erule vdm_d.elims, simp_all,
       clarsimp,
       erule semn.elims, simp_all)
apply fastsimp
apply (erule semn.elims, simp_all)
(* case false*)
apply clarsimp
apply (rule_tac x=p1 in exI, rule_tac x=h1 in exI, rule_tac x=p2 in exI, simp add: max_def)
apply (subgoal_tac "Ea<xa>=0", clarsimp)
apply rule
apply (erule vdm_d.elims, simp_all,
       clarsimp,
       erule semn.elims, simp_all)
apply fastsimp
apply (erule semn.elims, simp_all)
(*case Call*)
apply (erule vdm_d.elims, simp_all)
(*case Ann*)
apply (erule vdm_d.elims, simp_all)
done

lemma Complete:
"\<forall> E h hh v p P . (E \<turnstile> h,e \<Down> hh,v,p \<longrightarrow> (e,{(E,h,hh,v,p)}): vdm_d)"???
apply clarsimp
apply (induct e)
apply (simp add: sem_def, clarsimp)
apply (erule semn.elims, simp_all, clarsimp)
oops
apply (subgoal_tac "(expr.Int i, {(E,h,hh,v,p). ((mkREnv 1 0 0 0) \<ge> p) \<and> h = hh \<and> v = IVal i}) : vdm_d"
apply (rule d_Int)
apply (insert CompleteAux)
apply (subgoal_tac "P={(E,h,hh,v,p). ((mkREnv 1 0 0 0) \<ge> p) \<and> h = hh \<and> v = IVal int}")
apply clarsimp
apply (rule d_Int)

end
