theory VDMComplete = VDMSoundRec:

text {* The semantic definition of strongest vdm-specification.
        This correponds to the weakest hoare pre-condition, which 
        is simply the set of states which ensure the post-condition.*}

constdefs
 SSpec    :: "'a expr \<Rightarrow> vdmassn"
 "SSpec e == {(E,h,hh,v,p). E \<turnstile> h,e \<Down> hh,v,p}"

lemma SSpec_valid: "\<Turnstile> e: SSpec e"
by (simp add: SSpec_def vdm_valid_def)

lemma SSpec_strong: "\<Turnstile> e : P \<Longrightarrow> (SSpec e) \<subseteq> P"
by (simp add: SSpec_def vdm_valid_def, auto)

lemma VDM_proof_SSpec: "\<rhd> e : P \<Longrightarrow> SSpec e \<subseteq> P"
apply (subgoal_tac "\<Turnstile> e : P")
apply (rule SSpec_strong, simp)
apply (insert vdm_sound) apply fastsimp
done

lemma SSpec_implies_complete: "{} \<rhd> e : SSpec e \<Longrightarrow> \<Turnstile> e:P \<Longrightarrow> {} \<rhd> e:P"
apply (simp add: SSpec_def sem_def vdm_valid_def)
apply (rule vdm_conseq)
apply simp
apply fastsimp
done

lemma SSpec_lemma:"G \<rhd> (Call f): SSpec (Call f) \<Longrightarrow> G \<rhd> e : SSpec e"
sorry

lemma modusponens: "\<lbrakk>(A \<Longrightarrow> B); A \<rbrakk> \<Longrightarrow> B"
apply simp
done

lemma unnamed_lemma: "{} \<rhd> (Call f): SSpec (Call f)"
(*apply (simp add: SSpec_def sem_def)*)
apply (rule vdm_conseq)
apply (rule vdm_call)
apply (insert SSpec_lemma [of "{(CALL f, SSpec (CALL f))}" "f" "funtable f"])
apply clarsimp
apply (rule vdm_conseq)
apply fastsimp
apply (rule vdm_ax)
apply clarsimp
apply (subgoal_tac "{(CALL f, SSpec (CALL f))} \<rhd>  funtable f : {(E, h, hh, v, p).
                    (E, h, hh, v,
                     \<lparr>renv.clock = Suc (renv.clock p), callc = Suc (callc p), invkc = invkc p, invkdpth = invkdpth p\<rparr>)
                    \<in> ?P}")
apply assumption
apply clarsimp
prefer 2
apply (simp add: SSpec_def sem_def)
apply clarsimp
apply (subgoal_tac "a \<turnstile> aa , Call f \<Down>(n + 1) (ab , ac , tkcall b)")
prefer 2
apply (erule semCall)
apply fastsimp
sorry 

theorem complete:"\<Turnstile> e:P \<Longrightarrow> \<rhd> e:P"
apply (rule SSpec_implies_complete)
apply (rule SSpec_lemma)
apply (rule unnamed_lemma)
apply simp
done

lemma completeAux: "G \<rhd> e: SSpec e"
apply (induct e)
apply (simp_all add: SSpec_def sem_def)
(*Int*)
apply (rule vdm_conseq, rule vdm_int, clarsimp)
apply (rule_tac x=1 in exI, rule semInt)
(*IVar*)
apply (rule vdm_conseq, rule vdm_ivar, clarsimp)
apply (rule_tac x=1 in exI, rule semIVar)
(*Primop*)
apply (rule vdm_conseq, rule vdm_prim, clarsimp)
apply (rule_tac x=1 in exI, rule semPrimop)
(*Null*)
apply (rule vdm_conseq, rule vdm_null, clarsimp)
apply (rule_tac x=1 in exI, rule semNull)
(*RVar*)
apply (rule vdm_conseq, rule vdm_rvar, clarsimp)
apply (rule_tac x=1 in exI, rule semRVar)
(*RPrimop*)
apply (rule vdm_conseq, rule vdm_rprim, clarsimp)
apply (rule_tac x=1 in exI, rule semRPrimop)
(*New*)
apply (rule vdm_conseq, rule vdm_new, clarsimp)
apply (rule_tac x=1 in exI, rule semNew, simp)
(*Getfi*)
apply (rule vdm_conseq, rule vdm_getfi, clarsimp)
apply (rule_tac x=1 in exI, rule semGetfi, simp)
(*Getfr*)
apply (rule vdm_conseq, rule vdm_getfr, clarsimp)
apply (rule_tac x=1 in exI, rule semGetfr, simp)
(*Putfi*)
apply (rule vdm_conseq, rule vdm_putfi, clarsimp)
apply (rule_tac x=1 in exI, rule semPutfi, simp)
(*Putfr*)
apply (rule vdm_conseq, rule vdm_putfr, clarsimp)
apply (rule_tac x=1 in exI, rule semPutfr, simp)
(*Invoke*)
defer 1
(*InvokeStatic*)
defer 1
(*mhinvoke*)
defer 1
(*mhinvokestatic*)
defer 1
(*Leti*)
apply (rule vdm_conseq, rule vdm_leti, fast, fast, clarsimp)
apply (rule_tac x="(max n na) + 1" in exI, insert semLeti, fastsimp)
(* Letr*)
apply (rotate_tac -1, erule thin_rl)
apply (rule vdm_conseq, rule vdm_letr, fast, fast, clarsimp)
apply (rule_tac x="(max n na) + 1" in exI, insert semLetr, fastsimp)
(* Letv*)
apply (rotate_tac -2, erule thin_rl, erule thin_rl)
apply (rule vdm_conseq, rule vdm_letv, fast, fast, clarsimp)
apply (rule_tac x="(max n na)" in exI, insert semLetv, fastsimp)
(*If*)
apply (rotate_tac -3, erule thin_rl, erule thin_rl, erule thin_rl)
apply (rule vdm_conseq, rule vdm_if, fast, fast, clarsimp)
apply (case_tac "a<iname>=1", clarsimp)
apply (rule_tac x="n+1" in exI, insert semIf_True, fastsimp)
apply (subgoal_tac "a<iname>=0", clarsimp)
apply (rule_tac x="n+1" in exI, insert semIf_False, fastsimp)
apply clarsimp (* E<x> is either true or false*)
(*Call*)
apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
apply (rule vdm_conseq, rule vdm_call)
(*maybe it would be better to have funbodies is the context triples (and method bodies?*)
(*why do we not have sets of vdmtuples on the right-hand side?*)
prefer 2
sorry
apply (subgoal_tac "{(E, h, hh, v, p). \<exists>n. E \<turnstile> h , CALL funame \<Down>n (hh , v , p)} \<subseteq> {(E, h, hh, v, p). \<exists>n. E \<turnstile> h , CALL funame \<Down>n (hh , v , p)}")
apply simp apply fastsimp
apply clarsimp
apply (subgoal_tac " insert (CALL funame, {(E, h, hh, v, p). \<exists>n. E \<turnstile> h , CALL funame \<Down>n (hh , v , p)})
        G \<rhd> (CALL funame) : {(E, h, hh, v, p). \<exists>n. E \<turnstile> h , CALL funame \<Down>n (hh , v , p)}")
prefer 2 apply (rule vdm_ax, fast)
sorry
(*apply clarsimp
apply (subgoal_tac "{E,h,hh,v,p} . ")
apply (erule thin_rl)
defer 1
*)

lemma completeAux2: "{} \<rhd> e: SSpec e"
apply (induct e)
apply (simp_all add: SSpec_def sem_def)
(*Int*)
apply (rule vdm_conseq, rule vdm_int, clarsimp)
apply (rule_tac x=1 in exI, rule semInt)
(*IVar*)
apply (rule vdm_conseq, rule vdm_ivar, clarsimp)
apply (rule_tac x=1 in exI, rule semIVar)
(*Primop*)
apply (rule vdm_conseq, rule vdm_prim, clarsimp)
apply (rule_tac x=1 in exI, rule semPrimop)
(*Null*)
apply (rule vdm_conseq, rule vdm_null, clarsimp)
apply (rule_tac x=1 in exI, rule semNull)
(*RVar*)
apply (rule vdm_conseq, rule vdm_rvar, clarsimp)
apply (rule_tac x=1 in exI, rule semRVar)
(*RPrimop*)
apply (rule vdm_conseq, rule vdm_rprim, clarsimp)
apply (rule_tac x=1 in exI, rule semRPrimop)
(*New*)
apply (rule vdm_conseq, rule vdm_new, clarsimp)
apply (rule_tac x=1 in exI, rule semNew, simp)
(*Getfi*)
apply (rule vdm_conseq, rule vdm_getfi, clarsimp)
apply (rule_tac x=1 in exI, rule semGetfi, simp)
(*Getfr*)
apply (rule vdm_conseq, rule vdm_getfr, clarsimp)
apply (rule_tac x=1 in exI, rule semGetfr, simp)
(*Putfi*)
apply (rule vdm_conseq, rule vdm_putfi, clarsimp)
apply (rule_tac x=1 in exI, rule semPutfi, simp)
(*Putfr*)
apply (rule vdm_conseq, rule vdm_putfr, clarsimp)
apply (rule_tac x=1 in exI, rule semPutfr, simp)
(*Invoke*)
defer 1
(*InvokeStatic*)
defer 1
(*mhinvoke*)
defer 1
(*mhinvokestatic*)
defer 1 (*does not hold for empty context*)
(*Leti*)
apply (rule vdm_conseq, rule vdm_leti, fast, fast, clarsimp)
apply (rule_tac x="(max n na) + 1" in exI, insert semLeti, fastsimp)
(* Letr*)
apply (rotate_tac -1)
apply (erule thin_rl)
apply (rule vdm_conseq, rule vdm_letr, fast, fast, clarsimp)
apply (rule_tac x="(max n na) + 1" in exI, insert semLetr, fastsimp)
(* Letv*)
apply (rotate_tac -2)
apply (erule thin_rl)
apply (erule thin_rl)
apply (rule vdm_conseq, rule vdm_letv, fast, fast, clarsimp)
apply (rule_tac x="(max n na)" in exI, insert semLetv, fastsimp)
(*If*)
apply (rotate_tac -3)
apply (erule thin_rl)
apply (erule thin_rl)
apply (erule thin_rl)
apply (rule vdm_conseq, rule vdm_if, fast, fast, clarsimp)
apply (case_tac "a<iname>=1", clarsimp)
apply (rule_tac x="n+1" in exI, insert semIf_True, fastsimp)
apply (subgoal_tac "a<iname>=0", clarsimp)
apply (rule_tac x="n+1" in exI, insert semIf_False, fastsimp)
apply clarsimp (* E<x> is either true or false*)
(*Call*)
defer 1
(*Ann*)
defer 1
sorry

lemma vdm_complete: "(\<Turnstile> e : P \<Longrightarrow> \<rhd> e : P)"
apply (rule vdm_conseq)
apply (rule completeAux)
apply (rule SSpec_strong)
apply  simp
done

end
