theory VDMComplete = VDMSoundRec + VDMderived:
(* 				 
   File:	$RCSfile: VDMComplete2.thy,v $
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: VDMComplete2.thy,v 1.1 2003/08/22 11:53:23 lenb Exp $

   Proof of completeness of VDM-style program logic.
*)

text {* The semantic definition of strongest vdm-specification.
        This correponds to the weakest hoare pre-condition, which 
        is simply the set of states which ensure the post-condition.*}

constdefs
 SSpec    :: "'a expr \<Rightarrow> vdmassn"
 "SSpec e == {(E,h,hh,v,p). E \<turnstile> h,e \<Down> hh,v,p}"

(* declare SSpec_def [simp] *)

lemma SSpec_valid: "\<Turnstile> e: SSpec e"
by (simp add: vdm_valid_def SSpec_def)

lemma SSpec_strong: "\<Turnstile> e : P \<Longrightarrow> (SSpec e) \<subseteq> P"
by (simp add: vdm_valid_def SSpec_def, auto)

lemma VDM_proof_SSpec: "\<rhd> e : P \<Longrightarrow> SSpec e \<subseteq> P"
apply (subgoal_tac "\<Turnstile> e : P")
apply (rule SSpec_strong, simp)
apply (insert vdm_sound) apply fastsimp
done

(* Overall proof idea (see~\cite{HofmannScript} and~\cite{NipkowXX}): 
    (0)SSpec_lemma -(1)-> completeAux -(2)-> vdm_complete
    (0) induction over expr; use vdm_ax in Call case 
    (1) induction over expr; use vdm_call and SSpec_lemma in Call case
    (2) use vdm_conseq and completeAux
*)

(* all prg bits are Calls and there is at most one spec for each call in the set
constdefs WF_ctxt :: "'a vdmcontext \<Rightarrow> bool"
 "WF_ctxt G == \<forall> e P. (e,P) \<in> G \<longrightarrow> \<exists> f. e = Call f \<and> 
                        (\<forall> P' . (Call f, P') \<in> G \<longrightarrow>  P=P')"
*)
(*
lemma well_formed_ctxts_are_cool:
  "\<lbrakk> \<forall> f G P P'. (CALL f, P) \<in> G \<and> (CALL funame, P') \<in> G \<longrightarrow> P = P' ;
     (CALL f, Q) \<in> G \<rbrakk>
   \<Longrightarrow>
   insert (Call f, Q') G = G"
sorry
*)
(* crucial lemma needed for Call case *)
lemma SSpec_lemma: "\<forall> f . G \<rhd> ((Call f)::'a expr) : SSpec ((Call f)::'a expr) \<Longrightarrow> G \<rhd> (e::'a expr) : SSpec (e::'a expr)"
apply (simp add: SSpec_def sem_def)
apply (induct e)
apply (simp_all) (*  NB: Call case disappeared already! *)
(* Int *)
apply (rule vdm_conseq, rule vdm_int, clarsimp)
apply (rule_tac x=1 in exI, rule semInt)
(*IVar*)
apply (rule vdm_conseq, rule vdm_ivar, clarsimp)
apply (rule_tac x=1 in exI, rule semIVar)
(*Primop*)
apply (rule vdm_conseq, rule vdm_prim, clarsimp)
apply (rule_tac x=1 in exI, rule semPrimop)
(*Null*)
apply (rule vdm_conseq, rule vdm_null, clarsimp)
apply (rule_tac x=1 in exI, rule semNull)
(*RVar*)
apply (rule vdm_conseq, rule vdm_rvar, clarsimp)
apply (rule_tac x=1 in exI, rule semRVar)
(*RPrimop*)
apply (rule vdm_conseq, rule vdm_rprim, clarsimp)
apply (rule_tac x=1 in exI, rule semRPrimop)
(*New*)
apply (rule vdm_conseq, rule vdm_new, clarsimp)
apply (rule_tac x=1 in exI, rule semNew, simp)
(*Getfi*)
apply (rule vdm_conseq, rule vdm_getfi, clarsimp)
apply (rule_tac x=1 in exI, rule semGetfi, simp)
(*Getfr*)
apply (rule vdm_conseq, rule vdm_getfr, clarsimp)
apply (rule_tac x=1 in exI, rule semGetfr, simp)
(*Putfi*)
apply (rule vdm_conseq, rule vdm_putfi, clarsimp)
apply (rule_tac x=1 in exI, rule semPutfi, simp)
(*Putfr*)
apply (rule vdm_conseq, rule vdm_putfr, clarsimp)
apply (rule_tac x=1 in exI, rule semPutfr, simp)
(* Invoke *)
defer 1
(* InvokeStatic *)
defer 1
(* MH_Invoke *)
defer 1
(* MH_InvokeStatic *)
defer 1
(*Leti*)
apply (rule vdm_conseq, rule vdm_leti, fast, fast, clarsimp)
apply (rule_tac x="(max n na) + 1" in exI, insert semLeti, fastsimp)
(* Letr*)
apply (rotate_tac -1)
apply (erule thin_rl)
apply (rule vdm_conseq, rule vdm_letr, fast, fast, clarsimp)
apply (rule_tac x="(max n na) + 1" in exI, insert semLetr, fastsimp)
(* Letv*)
apply (rotate_tac -2)
apply (erule thin_rl)
apply (erule thin_rl)
apply (rule vdm_conseq, rule vdm_letv, fast, fast, clarsimp)
apply (rule_tac x="(max n na)" in exI, insert semLetv, fastsimp)
(*If*)
apply (rotate_tac -3)
apply (erule thin_rl)
apply (erule thin_rl)
apply (erule thin_rl)
apply (rule vdm_conseq, rule vdm_if, fast, fast, clarsimp)
apply (case_tac "a<iname>=1", clarsimp)
apply (rule_tac x="n+1" in exI, insert semIf_True, fastsimp)
apply (subgoal_tac "a<iname>=0", clarsimp)
apply (rule_tac x="n+1" in exI, insert semIf_False, fastsimp)
apply clarsimp (* E<x> is either true or false*)
apply (tactic {* all_tac *})
(* 5 subgoals left, for cases:
   Ann, and the 4 invokes *)
sorry

(* arbitrary instantiation needed - maybe we should remove polymorhism from expressions after all!!!*)
constdefs spectableContext:: "heap vdmcontext"
"spectableContext == {(x,y) . \<exists> f . (x = (Call f) \<and> y = spectable f)}"

constdefs spectableContextFinite::bool
"spectableContextFinite == (finite spectableContext)"

constdefs SpectableStrong::"bool"
"SpectableStrong == \<forall> f . (spectable f = SSpec ((Call f)::heap expr))"

constdefs goodContext::"bool"
"goodContext == spectableContextFinite \<and> SpectableStrong"

declare spectableContext_def [simp]
declare SpectableStrong_def [simp]
declare spectableContextFinite_def [simp]
declare goodContext_def [simp]

lemma AxAux: "\<lbrakk>(e,P) \<notin> G; G \<rhd> e : P; (\<forall> f . e \<noteq> Call f)\<rbrakk> \<Longrightarrow> \<rhd> e:P"
apply (erule vdm_proof.induct)
apply (rule vdm_conseq, fast, simp)
apply (rule vdm_null) 
apply (rule vdm_int) 
prefer 17
sorry

lemma cut2:"\<lbrakk>G \<rhd> e : P;
             D \<subseteq> G;
             (\<forall> f Q . ((Call f, Q) : G \<longrightarrow> (D \<rhd> Call f : Q)))\<rbrakk> 
            \<Longrightarrow> D \<rhd> e : P"
apply (erule vdm_proof.induct)
apply (rule vdm_conseq, fast, simp)
apply (rule vdm_null) 
apply (rule vdm_int) 
apply (rule vdm_ivar) 
apply (rule vdm_rvar) 
apply (rule vdm_prim) 
apply (rule vdm_rprim) 
apply (rule vdm_getfi) 
apply (rule vdm_getfr) 
apply (rule vdm_putfi) 
apply (rule vdm_putfr) 
apply (rule vdm_new) 
apply (rule vdm_if, simp, simp) 
apply (rule vdm_leti, simp, simp) 
apply (rule vdm_letr, simp, simp) 
apply (rule vdm_letv, simp, simp) 
apply (rule vdm_call) 
apply (simp add: CtxtWeak)
apply (rule vdm_mhinvokestatic)
apply (simp add: CtxtWeak)
apply (rule vdm_mhinvoke)
apply fast
apply fast
apply (simp add: CtxtWeak)
(*sorry
apply (rule vdm_ax, simp)
apply clarsimp
apply (case_tac "\<exists> f . e = Call f")
apply clarsimp
oops
apply (case_tac "\<exists> f . e = Call f")
apply clarsimp
apply (rule vdm_ax)
apply (rule vdm_int) 
apply (rule vdm_ivar) 
apply (rule vdm_rvar) 
apply (rule vdm_prim) 
apply fast 
apply (rule_tac x=1 in exI, rule semInt)
*)
sorry

lemma completeAux: "goodContext \<Longrightarrow> {} \<rhd> (e::heap expr): SSpec e"
apply clarsimp
apply (rule cut2)
apply (subgoal_tac "spectableContext \<rhd>  e : SSpec e")
apply simp
prefer 2
apply simp
apply clarsimp
apply (subgoal_tac "\<rhd> CALL f : spectable f")
prefer 2
apply (rule MUTRECCALL)
apply (subgoal_tac "finite spectableContext")
apply simp
apply simp
apply simp
apply simp
defer 1
apply simp
apply (rule SSpec_lemma)
apply clarsimp
apply (rule vdm_ax)
apply simp
apply clarsimp
apply (rule vdm_conseq)
apply (rule SSpec_lemma)
prefer 2 apply simp
apply clarsimp
apply (subgoal_tac "\<rhd> CALL f : spectable f")
apply simp
apply (rule MUTRECCALL)
apply (subgoal_tac "finite spectableContext")
apply simp
apply simp
apply simp
apply simp
defer 1
apply simp

apply clarsimp
apply (simp add: SSpec_def sem_def)
apply clarsimp
apply (rule_tac x="n + 1" in exI, simp)
apply (subgoal_tac "a \<turnstile> aa , CALL f \<Down>Suc n (ab , ac , \<lparr>renv.clock = 1, callc = 1, invkc = 0, invkdpth = 0\<rparr> \<smile> b)")
apply simp
apply (erule thin_rl)
apply (erule thin_rl)
apply (insert semCall)
apply fastsimp


apply (rule SSpec_lemma)
apply clarsimp
apply (rule vdm_ax)
apply simp
apply clarsimp
apply (rule vdm_conseq)
apply (rule SSpec_lemma)
prefer 2 apply simp
apply clarsimp


apply (rule vdm_ax)
apply simp
apply clarsimp
apply (simp add: SSpec_def sem_def)
apply clarsimp
apply (rule_tac x="n + 1" in exI, simp)
apply (subgoal_tac "a \<turnstile> aa , CALL f \<Down>Suc n (ab , ac , \<lparr>renv.clock = 1, callc = 1, invkc = 0, invkdpth = 0\<rparr> \<smile> b)")
apply simp
apply (erule thin_rl)
apply (erule thin_rl)
apply (insert semCall)
apply fastsimp
done

lemma vdm_complete: "goodContext \<Longrightarrow> \<Turnstile> (e::heap expr) : P \<Longrightarrow> \<rhd> e : P"
apply (rule vdm_conseq)
apply (rule completeAux)
apply assumption
apply (rule SSpec_strong)
apply  simp
done

end

lemma completeAux: "G \<rhd> e: SSpec e"
apply (induct e)
apply (simp_all add: SSpec_def sem_def)
(*Int*)
apply (rule vdm_conseq, rule vdm_int, clarsimp)
apply (rule_tac x=1 in exI, rule semInt)
(*IVar*)
apply (rule vdm_conseq, rule vdm_ivar, clarsimp)
apply (rule_tac x=1 in exI, rule semIVar)
(*Primop*)
apply (rule vdm_conseq, rule vdm_prim, clarsimp)
apply (rule_tac x=1 in exI, rule semPrimop)
(*Null*)
apply (rule vdm_conseq, rule vdm_null, clarsimp)
apply (rule_tac x=1 in exI, rule semNull)
(*RVar*)
apply (rule vdm_conseq, rule vdm_rvar, clarsimp)
apply (rule_tac x=1 in exI, rule semRVar)
(*RPrimop*)
apply (rule vdm_conseq, rule vdm_rprim, clarsimp)
apply (rule_tac x=1 in exI, rule semRPrimop)
(*New*)
apply (rule vdm_conseq, rule vdm_new, clarsimp)
apply (rule_tac x=1 in exI, rule semNew, simp)
(*Getfi*)
apply (rule vdm_conseq, rule vdm_getfi, clarsimp)
apply (rule_tac x=1 in exI, rule semGetfi, simp)
(*Getfr*)
apply (rule vdm_conseq, rule vdm_getfr, clarsimp)
apply (rule_tac x=1 in exI, rule semGetfr, simp)
(*Putfi*)
apply (rule vdm_conseq, rule vdm_putfi, clarsimp)
apply (rule_tac x=1 in exI, rule semPutfi, simp)
(*Putfr*)
apply (rule vdm_conseq, rule vdm_putfr, clarsimp)
apply (rule_tac x=1 in exI, rule semPutfr, simp)
(*Invoke*)
defer 1
(*InvokeStatic*)
defer 1
(*mhinvoke*)
defer 1
(*mhinvokestatic*)
defer 1
(*Leti*)
apply (rule vdm_conseq, rule vdm_leti, fast, fast, clarsimp)
apply (rule_tac x="(max n na) + 1" in exI, insert semLeti, fastsimp)
(* Letr*)
apply (rotate_tac -1, erule thin_rl)
apply (rule vdm_conseq, rule vdm_letr, fast, fast, clarsimp)
apply (rule_tac x="(max n na) + 1" in exI, insert semLetr, fastsimp)
(* Letv*)
apply (rotate_tac -2, erule thin_rl, erule thin_rl)
apply (rule vdm_conseq, rule vdm_letv, fast, fast, clarsimp)
apply (rule_tac x="(max n na)" in exI, insert semLetv, fastsimp)
(*If*)
apply (rotate_tac -3, erule thin_rl, erule thin_rl, erule thin_rl)
apply (rule vdm_conseq, rule vdm_if, fast, fast, clarsimp)
apply (case_tac "a<iname>=1", clarsimp)
apply (rule_tac x="n+1" in exI, insert semIf_True, fastsimp)
apply (subgoal_tac "a<iname>=0", clarsimp)
apply (rule_tac x="n+1" in exI, insert semIf_False, fastsimp)
apply clarsimp (* E<x> is either true or false*)
(*Call*)
apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
apply (rule vdm_call)
apply clarsimp
done
(*maybe it would be better to have funbodies is the context triples (and method bodies?*)
(*why do we not have sets of vdmtuples on the right-hand side?*)
prefer 2
sorry
apply (subgoal_tac "{(E, h, hh, v, p). \<exists>n. E \<turnstile> h , CALL funame \<Down>n (hh , v , p)} \<subseteq> {(E, h, hh, v, p). \<exists>n. E \<turnstile> h , CALL funame \<Down>n (hh , v , p)}")
apply simp apply fastsimp
apply clarsimp
apply (subgoal_tac " insert (CALL funame, {(E, h, hh, v, p). \<exists>n. E \<turnstile> h , CALL funame \<Down>n (hh , v , p)})
        G \<rhd> (CALL funame) : {(E, h, hh, v, p). \<exists>n. E \<turnstile> h , CALL funame \<Down>n (hh , v , p)}")
prefer 2 apply (rule vdm_ax, fast)
sorry
(*apply clarsimp
apply (subgoal_tac "{E,h,hh,v,p} . ")
apply (erule thin_rl)
defer 1
*)


other proof of completeAux
apply (induct e)
apply (simp_all add: SSpec_def sem_def)
(*Int*)
apply (rule vdm_conseq, rule vdm_int, clarsimp)
apply (rule_tac x=1 in exI, rule semInt)
(*IVar*)
apply (rule vdm_conseq, rule vdm_ivar, clarsimp)
apply (rule_tac x=1 in exI, rule semIVar)
(*Primop*)
apply (rule vdm_conseq, rule vdm_prim, clarsimp)
apply (rule_tac x=1 in exI, rule semPrimop)
(*Null*)
apply (rule vdm_conseq, rule vdm_null, clarsimp)
apply (rule_tac x=1 in exI, rule semNull)
(*RVar*)
apply (rule vdm_conseq, rule vdm_rvar, clarsimp)
apply (rule_tac x=1 in exI, rule semRVar)
(*RPrimop*)
apply (rule vdm_conseq, rule vdm_rprim, clarsimp)
apply (rule_tac x=1 in exI, rule semRPrimop)
(*New*)
apply (rule vdm_conseq, rule vdm_new, clarsimp)
apply (rule_tac x=1 in exI, rule semNew, simp)
(*Getfi*)
apply (rule vdm_conseq, rule vdm_getfi, clarsimp)
apply (rule_tac x=1 in exI, rule semGetfi, simp)
(*Getfr*)
apply (rule vdm_conseq, rule vdm_getfr, clarsimp)
apply (rule_tac x=1 in exI, rule semGetfr, simp)
(*Putfi*)
apply (rule vdm_conseq, rule vdm_putfi, clarsimp)
apply (rule_tac x=1 in exI, rule semPutfi, simp)
(*Putfr*)
apply (rule vdm_conseq, rule vdm_putfr, clarsimp)
apply (rule_tac x=1 in exI, rule semPutfr, simp)
(*Invoke*)
defer 1
(*InvokeStatic*)
defer 1
(*mhinvoke*)
defer 1
(*mhinvokestatic*)
defer 1 (*does not hold for empty context*)
(*Leti*)
apply (rule vdm_conseq, rule vdm_leti, fast, fast, clarsimp)
apply (rule_tac x="(max n na) + 1" in exI, insert semLeti, fastsimp)
(* Letr*)
apply (rotate_tac -1)
apply (erule thin_rl)
apply (rule vdm_conseq, rule vdm_letr, fast, fast, clarsimp)
apply (rule_tac x="(max n na) + 1" in exI, insert semLetr, fastsimp)
(* Letv*)
apply (rotate_tac -2)
apply (erule thin_rl)
apply (erule thin_rl)
apply (rule vdm_conseq, rule vdm_letv, fast, fast, clarsimp)
apply (rule_tac x="(max n na)" in exI, insert semLetv, fastsimp)
(*If*)
apply (rotate_tac -3)
apply (erule thin_rl)
apply (erule thin_rl)
apply (erule thin_rl)
apply (rule vdm_conseq, rule vdm_if, fast, fast, clarsimp)
apply (case_tac "a<iname>=1", clarsimp)
apply (rule_tac x="n+1" in exI, insert semIf_True, fastsimp)
apply (subgoal_tac "a<iname>=0", clarsimp)
apply (rule_tac x="n+1" in exI, insert semIf_False, fastsimp)
apply clarsimp (* E<x> is either true or false*)
(*Call*)
(* proof idea: use vdm_call and SSpec_lemma *)
apply (erule thin_rl)
apply (erule thin_rl)
apply (erule thin_rl)
apply (erule thin_rl)
apply (erule thin_rl)
apply (rule vdm_call) 
apply simp
(* have to massage the subgoal so that we can SSpec_lemma; 
   SSpec_body should do the massaging *)
apply (insert "SSpec_lemma")
apply (simp add: SSpec_def sem_def)
apply auto
(* apply (rule vdm_conseq)  *)
(* apply (erule_tac x="funame" in allE) *)
apply auto
apply (tactic {* all_tac *})
(*Ann*)
defer 1
sorry
lemma completeAux2: "{} \<rhd> e: SSpec e"
