(*  Examples from List.cmlt -> Grail*)

theory CmltList = VDMderived + ExampleListClass:

section {* Functional correctness and resource correctness *}

locale Listlength = 
  fixes    tag     :: iname and	   h       :: iname and    i       :: iname and	   b       :: iname
    and    l       :: rname and	   f       :: funame
    and	   fBody   :: "(int * int * int * int) expr"
  assumes  fbdy[simp]:  "funtable f =  LET tag = GetFi l TAG;
                                           b = Primop (% x y. if x = 0 then 1 else 0) tag tag
                                           IN IF b THEN IVar i
                                           ELSE LET  h = GetFi l HD;
                                                     i = Primop (% x y. x + 1) i i;
                                                 rf  l = (GetFr l TL)
                                                IN (Call f) END
                                                END"
      and  vardistinct: "distinct [tag,h,i,b] \<and> distinct [b,i,h,tag]"
      and spect[simp]: 
          "spectable f = {(E,h,hh,v,p) . \<forall> L X rl.((E\<lfloor>l\<rfloor> = Ref rl \<and> (L,rl,X,h) \<in> LocLength)
                                                \<longrightarrow> 
                                                (v = IVal ((int L) + E<i>) \<and> hh = h \<and> p = \<langle>(11 + 20 * L) (L + 1) 0 0\<rangle>))}"

lemma (in Listlength) "\<rhd> (Call f) : spectable f"
apply (rule vdm_call, simp)
apply (rule vdm_conseq)
apply (rule vdm_basics)+
apply (rule vdm_ax)
apply simp
apply (insert vardistinct)
apply clarsimp
apply (case_tac "aa<ad\<bullet>TAG> = 0")
(*case aa<ad\<bullet>TAG> = 0*)
  apply clarsimp
  apply (erule LocLength.elims, simp_all)
(*case aa<ad\<bullet>TAG> \<noteq> 0*)
  apply clarsimp
  apply (erule LocLength.elims, simp_all)
  apply clarsimp
  apply (erule_tac x="ia" in allE)
  apply (erule impE)
  apply (rule_tac x="Xa - {la}" in exI, simp)
  apply fastsimp
done

locale Listlength2 = 
  fixes    tag     :: iname and	   h       :: iname and    i       :: iname and	   b       :: iname
    and    l       :: rname and	   f       :: funame
    and	   fBody   :: "(int * int * int * int) expr"
  assumes  fbdy[simp]:  "funtable f =  LET tag = GetFi l TAG;
                                           b = Primop (% x y. if x = 0 then 1 else 0) tag tag
                                           IN IF b THEN IVar i
                                           ELSE LET  h = GetFi l HD;
                                                     i = Primop (% x y. x + 1) i i;
                                                 rf  l = (GetFr l TL)
                                                IN (Call f) END
                                                END"
      and  vardistinct: "distinct [tag,h,i,b] \<and> distinct [b,i,h,tag]"
      and spect[simp]: 
          "spectable f = {(E,h,hh,v,p) . \<forall> N .((\<exists> L . (L,E\<lfloor>l\<rfloor>,h) \<in> models \<and> length L = N)
                                              \<longrightarrow> 
                                              (v = IVal ((int N) + E<i>) \<and> hh = h \<and> p = \<langle>(11 + 20 * N) (N + 1) 0 0\<rangle>))}"

lemma (in Listlength2) "\<rhd> (Call f) : spectable f"
apply (rule vdm_call, simp)
apply (rule vdm_conseq)
apply (rule vdm_basics)+
apply (rule vdm_ax)
apply simp
apply (insert vardistinct)
apply clarsimp
apply (case_tac "aa<ad\<bullet>TAG> = 0")
(*case aa<ad\<bullet>TAG> = 0*)
  apply clarsimp
  apply (erule models.elims, simp_all)
(*case aa<ad\<bullet>TAG> \<noteq> 0*)
  apply clarsimp
  apply (erule models.elims, simp_all)
  apply clarsimp
  apply (erule_tac x="length t" in allE)
  apply auto
done
end
