(*  Examples from List.cmlt -> Grail*)

(*Camelot:
let double_rev l acc = match l with Nil => acc
                                  | Cons(h,t) => double_rev t (Cons(h, Cons(h,acc)))

let double_rev2 l acc = match l with Nil => acc
                                   | Cons(h,t)@d => double_rev2 t (Cons(h,Cons(h,acc)@d))

Compiled Grail:   
method public static List$dia_0 double_rev2 (List$dia_0 l, List$dia_0 acc) =
   let fun f:double_rev2(List$dia_0 l, List$dia_0 ?t2, List$dia_0 ?t3, 
                         List$dia_0 d, int h, List$dia_0 t, List$dia_0 acc, List$dia_0 l) =
       let val tag = getfield l <int List$dia_0.$>
       in if tag = 0
          then f:0(l, ?t2, ?t3, d, h, t, acc, l)
          else f:1(l, ?t2, ?t3, d, h, t, acc, l)
       end
       fun f:1(List$dia_0 l, List$dia_0 ?t2, List$dia_0 ?t3, List$dia_0 d, 
               int h, List$dia_0 t, List$dia_0 acc, List$dia_0 l) =
       let val h = getfield l <int List$dia_0.f1>
           val t = getfield l <List$dia_0 List$dia_0.f0>
           val d = l
           val ?t3 = invokestatic <List$dia_0 List$dia_0.fill (List$dia_0, int, int, List$dia_0)> (d, 1, h, acc)
           val ?t2 = invokestatic <List$dia_0 List$dia_0.make (int, int, List$dia_0)> (1, h, ?t3)
       in invokestatic <List$dia_0 List.double_rev2 (List$dia_0, List$dia_0)> (t, ?t2)
       end
       fun f:0(List$dia_0 l, List$dia_0 ?t2, List$dia_0 ?t3, List$dia_0 d, 
               int h, List$dia_0 t, List$dia_0 acc, List$dia_0 l) = acc
   in f:double_rev2(l, ?t2, ?t3, d, h, t, acc, l)
   end 

   method public static List$dia_0 double_rev (List$dia_0 l, List$dia_0 acc) =
   let fun f:double_rev(List$dia_0 l, List$dia_0 ?t0, List$dia_0 ?t1, 
                        int h, List$dia_0 t, List$dia_0 acc, List$dia_0 l) =
       let val tag = getfield l <int List$dia_0.$>
       in if tag = 0
          then f:0(l, ?t0, ?t1, h, t, acc, l)
          else f:1(l, ?t0, ?t1, h, t, acc, l)
       end
       fun f:1(List$dia_0 l, List$dia_0 ?t0, List$dia_0 ?t1, int h, List$dia_0 t, List$dia_0 acc, List$dia_0 l) =
       let val h = getfield l <int List$dia_0.f1>
           val t = getfield l <List$dia_0 List$dia_0.f0>
           val ?t1 = invokestatic <List$dia_0 List$dia_0.make (int, int, List$dia_0)> (1, h, acc)
           val ?t0 = invokestatic <List$dia_0 List$dia_0.make (int, int, List$dia_0)> (1, h, ?t1)
       in invokestatic <List$dia_0 List.double_rev (List$dia_0, List$dia_0)> (t, ?t0)
       end
       fun f:0(List$dia_0 l, List$dia_0 ?t0, List$dia_0 ?t1, int h, List$dia_0 t, 
               List$dia_0 acc, List$dia_0 l) = acc
    in f:double_rev(l, ?t0, ?t1, h, t, acc, l)
    end

ToyGrail:
method public static List double_rev2 (List l, List acc) =
   let fun f(List l, List acc) =
       let val tag = getfield l <int List.$>
       in if tag = 0
          then f0(acc)
          else f1(l, acc)
       end
       fun f1(List l, List acc) =
       let val h = getfield l <int List.f1>
           val t = getfield l <List List.f0>
           val d = l
           val one = 1
           val () = putfield d TAG one
           val () = putfield d HD h
           val () = putfield d TL acc
           val ?t3 = d
           val ?t2 = invokestatic <List.alloc ()> ()
           val () = putfield ?t2 TAG one
           val () = putfield ?t2 HD h
           val () = putfield ?t2 TL ?t3
           val l = t
           val acc = ?t2
       in f(l,acc)
       end
       fun f0(List acc) = acc
   in f(l, acc)
   end 

   method public static List double_rev (List l, List acc) =
   let fun f(List l, List acc) =
       let val tag = getfield l <int List.$>
       in if tag = 0
          then f:0(acc)
          else f:1(l, acc)
       end
       fun f1(List l, List acc) =
       let val h = getfield l <int List.f1>
           val t = getfield l <List List.f0>
           val one = 1

           val ?t1 = invokestatic <List.alloc ()> ()
           val () = putfield ?t1 TAG one
           val () = putfield ?t1 HD h
           val () = putfield ?t1 TL acc

           val ?t0 = invokestatic <List List.alloc ()> ()
           val () = putfield ?t0 TAG one
           val () = putfield ?t0 HD h
           val () = putfield ?t0 TL ?t1
           val l = t
           val acc = ?t0
       in f(l,acc)
       end
       fun f0(List acc) = acc
    in f(l, acc)
    end
*)
 
theory ExampleListDouble = VDMderived + ExampleListClass:

constdefs clockA::nat "clockA == 37"
          clockB::nat "clockB == 11"
          callcA::nat "callcA == 1"
          callcB::nat "callcB == 1"
          invkcA::nat "invkcA == 0"
          invkcB::nat "invkcB == 0"
          invkdpthA::nat "invkdpthA == 0"
          invkdpthB::nat "invkdpthB == 0"
          
locale DoubleRev2 = 
  fixes    tag     :: iname  and    h       :: iname  and    one     :: iname and	   b       :: iname
    and    l       :: rname  and    acc     :: rname  and    t       :: rname and    d       :: rname
    and    t2      :: rname  and    t3      :: rname
    and	   f       :: funame
 assumes funtf[simp]:
         "funtable f == ( LET tag = GetFi l TAG;
                                b = Primop (% x y. if x = 0 then 1 else 0) tag tag
                          IN IF b (*8 ticks till here*)
                          THEN RVar acc
                          ELSE LET h    = GetFi l HD;
                                 rf t   = GetFr l TL;
                                 rf d   = RVar l;
                                    one = expr.Int 1;
                                    _   = PutFi d TAG one;
                                    _   = PutFi d HD h;
                                    _   = PutFr d TL acc;
                                 rf t3  = RVar d;
                                 rf t2  = NEW <LST> ([(TAG,one),(HD,h)],[(TL,t3)]);
                                 rf l   = RVar t;
                                 rf acc = RVar t2
                               IN CALL f END
                          END)::'a expr"
      and spectf:
        "spectable f == {(E,h,hh,v,p) . \<forall> L X. ((\<exists> rl . E\<lfloor>l\<rfloor> = Ref rl \<and> (L,rl,X,h) \<in> LocLength) \<longrightarrow>
                                                 HSize hh = HSize h + (int L) \<and> 
                                                 p = \<langle> (clockA * L + clockB) (callcA * L + callcB) 
                                                       (invkcA * L + invkcB) (invkdpthA * L + invkdpthB)\<rangle>)}"
      and vardistinct: "distinct [tag,h,one,b] \<and> distinct [b,one,h,tag] \<and>
                         distinct [l,acc,t,d,t2,t3] \<and> distinct [t3,t2,d,t,acc,l] \<and>
                         distinct [f,f0,f1] \<and> distinct [f1,f0,f] \<and>
                         distinct [TAG,HD] \<and> distinct [HD,TAG]"

lemma (in DoubleRev2) 
   "\<rhd> (CALL f)::'a expr: spectable f"
apply (rule vdm_call)
apply (insert vardistinct)
apply simp
apply (rule vdm_conseq)
apply (rule vdm_leti, rule vdm_getfi) prefer 2 apply clarsimp prefer 2
apply (rule vdm_leti, rule vdm_prim) prefer 2 apply clarsimp prefer 2
apply (rule vdm_if, rule vdm_rvar) prefer 2 apply clarsimp apply (case_tac "aa<ad\<bullet>TAG> = 0", clarsimp) defer 1 apply clarsimp prefer 2
apply (rule vdm_leti, rule vdm_getfi) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr, rule vdm_getfr) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr, rule vdm_rvar) prefer 2 apply clarsimp prefer 2
apply (rule vdm_leti, rule vdm_int) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv, rule vdm_putfi) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv, rule vdm_putfi) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv, rule vdm_putfr) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr, rule vdm_rvar) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr, rule vdm_new) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr, rule vdm_rvar) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr, rule vdm_rvar) prefer 2 apply clarsimp prefer 2
apply (rule vdm_ax, simp) 
(*end of vcg*)
apply (simp_all add: spectf)
apply clarsimp
apply (subgoal_tac "X \<subseteq> fmap_dom (oheap aa)")
prefer 2 apply (erule LocLengthDom)
apply (erule LocLength.elims,  simp_all, clarsimp)
apply (erule_tac x=i in allE)
apply (erule impE)
apply (rule_tac x="Xa - {la}" in exI)
apply (rule LocLengthSame, assumption)
apply (simp add: same_def newObj_def, clarsimp)
apply (fastsimp intro: freshloc)
apply (simp add: newObj_def)
defer 1
apply clarsimp
apply (erule LocLength.elims, simp_all)
apply (simp_all add: clockA_def clockB_def callcA_def callcB_def invkcA_def invkcB_def invkdpthA_def invkdpthB_def)
done

locale DoubleRev2Heap = 
  fixes    tag     :: iname  and    h       :: iname  and    one     :: iname and	   b       :: iname
    and    l       :: rname  and    acc     :: rname  and    t       :: rname and    d       :: rname
    and    t2      :: rname  and    t3      :: rname
    and	   f       :: funame and    f0      :: funame and    f1      :: funame
    and    Body    :: "(nat \<times> int) expr" and    Body0    :: "(nat \<times> int) expr" and    Body1    :: "(nat \<times> int) expr"
 defines "Body ==  PRE {((L,H),s) . ( \<exists> X rl . hpsize s = H \<and>  s\<lfloor>l\<rfloor> = Ref rl \<and> (L,rl,X,getheap s) \<in> DomLength)}:
                   POST {((L,H),s,v) . hpsize s = H + (int L)} :
                   LET tag = GetFi l TAG;
                       b = Primop (% x y. if x = 0 then 1 else 0) tag tag
                   IN IF b 
                      THEN CALL f0 
                      ELSE CALL f1
                   END"
     and "Body0 == PRE {((L,H),s) .  hpsize s = H}:
                   POST {((L,H),s,v) . hpsize s = H}:
                   RVar acc"
     and "Body1 == PRE {((L,H),s) . ( \<exists> X rl LL. L = Suc LL \<and> hpsize s = H \<and>  s\<lfloor>l\<rfloor> = Ref rl \<and> (L,rl,X,getheap s) \<in> DomLength)}:
                   POST {((L,H),s,v) . hpsize s = H + (int L)}:
                   LET h    = GetFi l HD;
                     rf t   = GetFr l TL;
                     rf d   = RVar l;
                        one = expr.Int 1;
                        _   = PutFi d TAG one;
                        _   = PutFi d HD h;
                        _   = PutFr d TL acc;
                     rf t3  = RVar d;
                     rf t2  = NEW <LST> ([(TAG,one),(HD,h)],[(TL,t3)]);
                     rf l   = RVar t;
                     rf acc = RVar t2
                    IN CALL f END"
    assumes b[simp] : "funtable f = Body" 
      and   b0[simp] : "funtable f0 = Body0" 
      and   b1[simp] : "funtable f1 = Body1" 
      and  vardistinct: "distinct [tag,h,one,b] \<and> distinct [b,one,h,tag] \<and>
                         distinct [l,acc,t,d,t2,t3] \<and> distinct [t3,t2,d,t,acc,l] \<and>
                         distinct [f,f0,f1] \<and> distinct [f1,f0,f] \<and>
                         distinct [TAG,HD] \<and> distinct [HD,TAG]"

declare (in DoubleRev2Heap) Body_def [simp]
declare (in DoubleRev2Heap) Body0_def [simp]
declare (in DoubleRev2Heap) Body1_def [simp]
declare (in DoubleRev2Heap) getheap_def [simp]

lemma (in DoubleRev2Heap) 
   "\<Turnstile> {((L,H),s) . ( \<exists> X rl . hpsize s = H \<and>  s\<lfloor>l\<rfloor> = Ref rl \<and> (L,rl,X,getheap s) \<in> DomLength)}
       (CALL f) 
      {((L,H),s,v) . hpsize s = H + (int L)}"
apply (rule HCallRecPrePostInvAdapt)
apply simp
apply (rule, rule, rule, rule refl, rule refl)
apply (rule HSP)
apply (rule hoarebasics)+
apply (rule HCallRecPrePostInvAdapt)
apply simp
apply (rule, rule refl)
apply (rule, rule refl)
apply (rule refl)
apply (rule HSP)
apply (rule hoarebasics)+
apply clarsimp 
apply (rule subset_refl)
apply (rule HCallRecPrePostInvAdapt)
apply simp
apply (rule, rule refl)
apply (rule, rule refl)
apply (rule refl)
apply (rule HSP)
apply (rule hoarebasics)+
apply (erule assume_adapt)
defer 1
apply (rule subset_refl)
apply (rule subset_refl)
(* only side-conditions left*)
apply (insert vardistinct, clarsimp)
apply (rule, erule DomLength.elims, clarsimp, clarsimp)
apply (rule, rule_tac x="a" in exI, simp)
apply (erule DomLength.elims, clarsimp, clarsimp)
apply (rule_tac x="Xa" in exI)
apply (rule CONS_DomL)
prefer 8 (*all other goals solved by fastsimp*)
apply clarsimp
apply (rule_tac x="LL" in exI, simp)
apply (subgoal_tac "freshlocst ba \<notin> X")
apply (erule DomLength.elims, clarsimp, clarsimp)
apply (rule_tac x="Xa - {la}" in exI)
by (subgoal_tac "freshlocst ba \<notin> Xa - {la}",
    subgoal_tac "la \<notin> Xa - {la}",
    subgoal_tac "la \<noteq> freshlocst ba",
    fastsimp+)

locale DoubleRev2Clock = 
  fixes    tag     :: iname  and    h       :: iname  and    one     :: iname and	   b       :: iname
    and    l       :: rname  and    acc     :: rname  and    t       :: rname and    d       :: rname
    and    t2      :: rname  and    t3      :: rname
    and	   f       :: funame and    f0      :: funame and    f1      :: funame
 assumes fbdy: "funtable f == 
                    PRE {((L,C),s) . ( \<exists> X rl. clock s = C \<and>  s\<lfloor>l\<rfloor> = Ref rl \<and> 
                                             (L,rl,X,getheap s) \<in> DomLength)}:
                    POST {((L,C),s,v) . clock s = C + (8 + 1 + 27 + 1) * (int L) + 8 + 1 + 1} :
                    LET tag = GetFi l TAG;
                        b = Primop (% x y. if x = 0 then 1 else 0) tag tag
                    IN IF b (*8 ticks till here*)
                       THEN CALL f0 
                       ELSE CALL f1
                    END"
     and f0bdy: "funtable f0 == 
                     PRE {((L,C),s) .  ( \<exists> X rl . clock s = C \<and> L = 0 \<and> s\<lfloor>l\<rfloor> = Ref rl \<and> (L,rl,X,getheap s) \<in> DomLength)}:
                     POST {((L,C),s,v) . clock s = C + 1} :
                     RVar acc"
     and f1bdy: "funtable f1 == 
                     PRE {((L,C),s) . ( \<exists> X n rl. clock s = C \<and> L = Suc n \<and>  s\<lfloor>l\<rfloor> = Ref rl \<and> (L,rl,X,getheap s) \<in> DomLength)}:
                     POST {((L,C),s,v) . clock s = C + 37 * (int L) + 10 - 9} :
                     (* 0 ticks *)
                     LET h    = GetFi l HD;
                       rf t   = GetFr l TL;
                       rf d   = RVar l;
                          one = expr.Int 1;
                          _   = PutFi d TAG one;
                          _   = PutFi d HD h;
                          _   = PutFr d TL acc;
                       rf t3  = RVar d;
                       rf t2  = NEW <LST> ([(TAG,one),(HD,h)],[(TL,t3)]);
                       rf l   = RVar t;
                       rf acc = RVar t2
                       (* 27 ticks *)
                      IN CALL f END"

      and  vardistinct: "distinct [tag,h,one,b] \<and> distinct [b,one,h,tag] \<and>
                         distinct [l,acc,t,d,t2,t3] \<and> distinct [t3,t2,d,t,acc,l] \<and>
                         distinct [f,f0,f1] \<and> distinct [f1,f0,f] \<and>
                         distinct [TAG,HD] \<and> distinct [HD,TAG]"

declare (in DoubleRev2Clock) fbdy [simp]
declare (in DoubleRev2Clock) f0bdy [simp]
declare (in DoubleRev2Clock) f1bdy [simp]
declare (in DoubleRev2Clock) getheap_def [simp]

lemma (in DoubleRev2Clock) 
   "\<Turnstile> {((L,C),s) . ( \<exists> X rl. clock s = C \<and>  s\<lfloor>l\<rfloor> = Ref rl \<and> (L,rl,X,getheap s) \<in> DomLength)}
       (CALL f) 
      {((L,C),s,v) . clock s = C + (8 + 1 + 27 + 1) * (int L) + 11}"
apply (rule HCallRecPrePostInvAdapt)
apply simp
apply (rule, rule, rule, rule refl, rule refl)
apply (rule HSP)
apply (rule hoarebasics)+
apply (rule HCallRecPrePostInvAdapt)
apply simp
apply (rule, rule refl)
apply (rule, rule refl)
apply (rule refl)
apply (rule HSP)
apply (rule hoarebasics)+
apply clarsimp 
apply (rule subset_refl)
apply (rule HCallRecPrePostInvAdapt)
apply simp
apply (rule, rule refl)
apply (rule, rule refl)
apply (rule refl)
apply (rule HSP)
apply (rule hoarebasics)+
apply (erule assume_adapt)
defer 1
apply (rule subset_refl)
apply (rule subset_refl)
apply (insert vardistinct)
apply clarsimp
apply rule
apply rule
apply (erule DomLength.elims, clarsimp)
apply (rule_tac x="{la}" in exI)
apply (rule NIL_DomL, fastsimp, fastsimp, fastsimp)
apply clarsimp
apply (rule_tac x="a" in exI, simp)
apply (erule DomLength.elims, clarsimp, clarsimp)
apply (rule_tac x="Xa" in exI)
apply (rule CONS_DomL)
apply fastsimp
apply fastsimp
apply fastsimp
apply fastsimp
apply fastsimp
apply fastsimp
apply fastsimp
apply clarsimp
apply (rule_tac x="n" in exI, simp)
apply (subgoal_tac "freshlocst ba \<notin> X")
apply (erule DomLength.elims, clarsimp, clarsimp)
apply (rule_tac x="Xa - {la}" in exI)
by (subgoal_tac "freshlocst ba \<notin> Xa - {la}",
    subgoal_tac "la \<notin> Xa - {la}",
    subgoal_tac "la \<noteq> freshlocst ba",
    fastsimp+)
end
