(*  
   File:	$RCSfile: ExampleKonst.thy,v $
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ExampleKonst.thy,v 1.2 2003/08/25 10:46:22 lenb Exp $

   Constant function example in VDM version.
*)

theory ExampleKonst = Prelude + Lemmas + VDM:

(* count down to 0 as simplified version of konst *)
locale kount_example =
  fixes    x         :: rname
  fixes	   m         :: iname
  fixes    count     :: ifldname
  fixes	   q         :: iname
  fixes	   z         :: iname
  fixes    konst     :: funame
 assumes funtable_kount_def[simp]:
  "funtable kount =  ((LET
                         m = x\<bullet>count ;
                         q = m :0? 
                       IN 
                         IF q
                           THEN 0\<^sup>z
                           ELSE LET
                                  m = x\<bullet>count ;
                                  m = m :-- ;
                                  z = (x\<bullet>count := m) ;
                                  z = CALL kount 
                               IN
                                 z\<^sup>I
                               END
                       END) :: state expr)"
  assumes  vardistinct: "distinct [m,q,z]"

lemma (in kount_example)
  "\<rhd> ((CALL kount) :: state expr) : {(E::env,h::heap,h'::heap,v,p). theival v = (0::int)}" (* (heap.iheap (h'::heap)) count E\<lceil>x\<rceil>}" *)
apply (insert vardistinct)
(* apply (rule vdm_conseq) *)
apply (rule vdm_call)
apply simp                 (* porghvam yISach! *)
apply (rule vdm_conseq)
apply (rule vdm_basics)
defer 1
apply (rule vdm_basics)
defer 1
apply (rule vdm_basics)
defer 1
apply (rule vdm_basics)
defer 1
apply (rule vdm_basics)
defer 1
apply (rule vdm_basics)
defer 1
apply (rule vdm_basics)
defer 1
apply (rule vdm_basics)
defer 1
apply (rule vdm_basics)
apply (rule vdm_basics)
apply (rule vdm_basics)
apply (rule vdm_basics)
apply (rule vdm_basics)
apply (rule vdm_basics)
apply (rule vdm_ax)
apply simp
(* -- *)
apply clarsimp
apply (case_tac "aa<ad\<bullet>count> = 0")
 apply clarsimp
 apply clarsimp
done

(* --------------------------------------------------------------------------- *)

locale konst_flat_example =
  fixes    x         :: rname
  fixes	   m         :: iname
  fixes    count     :: ifldname
  fixes	   q         :: iname
  fixes    konst     :: funame
 assumes funtable_konst_def[simp]:
  "funtable konst =  ((LET
                         m = x\<bullet>count ;
                         q = m :0? 
                       IN 
                         IF q
                           THEN 0\<^sup>z
                           ELSE LET
                                  m = x\<bullet>count ;
                                  m = m :-- ;
                                  _ = (x\<bullet>count := m) ;
                                  _ = CALL konst ;
                                  m = x\<bullet>count ;
                                  m = m :++ ;
                                  _ = (x\<bullet>count := m)
                                IN 
                                  m\<^sup>I
                                END
                       END) :: 'a expr)"
  assumes  vardistinct: "distinct [m,q] \<and> distinct [q,m]"
(*
declare (in konst_flat_example) funtable_konst_def [simp]
*)

declare obj_ifieldupdate_def [simp]
declare obj_rfieldupdate_def [simp]
declare ivarupdate_def [simp]
declare rvarupdate_def [simp]
declare ienv_fct_def [simp]

lemma (in konst_flat_example)
  "\<rhd> ((CALL konst) :: 'a expr) : {(E,h,hh,v,p). \<forall> l . E\<lfloor>x\<rfloor> = Ref l \<longrightarrow> (iheap h) count l = (iheap hh) count l }"
apply (insert vardistinct)
apply (rule vdm_call)
apply clarsimp                 (* porghvam yISach! *)
apply (rule vdm_conseq)
apply (rule vdm_basics)
apply (rule vdm_basics)
apply (rule vdm_basics)
apply (rule vdm_basics)
prefer 2 apply clarsimp prefer 2 (*apply (case_tac "i = 0", clarsimp)prefer 2 apply clarsimp *)
apply (rule vdm_basics)
apply (rule vdm_basics)
apply (rule vdm_basics)
apply (rule vdm_basics)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_basics)
apply (rule vdm_basics)
apply (rule vdm_basics)
apply (rule vdm_basics)
apply (rule vdm_basics)
apply (rule vdm_ax, simp)
prefer 2 apply clarsimp prefer 2
apply (rule vdm_basics)
apply (rule vdm_basics)
apply (rule vdm_basics)
apply (rule vdm_basics)
apply (rule vdm_basics)
apply (rule vdm_basics)
apply (rule vdm_basics)
apply clarsimp
apply (case_tac "i=0", clarsimp)
apply clarsimp
apply auto
apply rule
apply rule
apply clarsimp
apply (case_tac "a<m:=aa<a\<lceil>x\<rceil>\<bullet>count>><q:=0><m:=aa<a\<lceil>x\<rceil>\<bullet>count>><m:=aa<a\<lceil>x\<rceil>\<bullet>count> - 1><z:=ib>\<lceil>x\<rceil> = a\<lceil>x\<rceil>", auto)
apply (case_tac "aa<a\<lceil>x\<rceil>\<bullet>count> = h1c<a\<lceil>x\<rceil>\<bullet>count> + 1", auto)
apply clarsimp
apply fast
done

lemma (in konst_flat_example)
  "\<rhd> ((CALL konst) :: state expr) : {(E::env,h::heap,h'::heap,v,p). (heap.iheap (h::heap)) count E\<lceil>x\<rceil> = (heap.iheap (h'::heap)) count E\<lceil>x\<rceil>}"
apply (insert vardistinct)
apply (rule vdm_call)
apply simp                 (* porghvam yISach! *)
apply (rule vdm_conseq)
apply (rule vdm_leti)
apply (rule vdm_basics)
apply (rule vdm_leti)
apply (rule vdm_basics)
apply (rule vdm_basics)
apply (rule vdm_basics)
apply (rule vdm_leti)
apply (rule vdm_basics)
apply (rule vdm_leti)
apply (rule vdm_basics)
apply (rule vdm_leti)
apply (rule vdm_basics)
apply (rule vdm_leti)
apply (rule vdm_ax)
apply simp
apply (rule vdm_leti)
apply (rule vdm_basics)
apply (rule vdm_leti)
apply (rule vdm_basics)
apply (rule vdm_leti)
apply (rule vdm_basics)
apply (rule vdm_basics)
apply clarsimp
apply (tactic {* all_tac *})
sorry (* , NOT! *)

end
