(*  
   File:	$RCSfile: ExampleDecI.thy,v $
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ExampleDecI.thy,v 1.1 2003/08/22 11:53:19 lenb Exp $

   Decrement w/ invoke using VDM rules.
   Uses MH_InvokeStatic and MH_Invoke.
*)

theory ExampleDecI = Prelude + Lemmas + VDM:

section {* MH_Invoke tests *}

locale example1 =
  fixes   m  :: iname
  fixes   x  :: rname
  fixes   a1 :: locn
  fixes   foo :: mname
  fixes   Foo :: cname
  assumes cheat1:  "\<And> h a . fmap_lookup (heap.oheap h) a = Some Foo"
  assumes cheat2:  "methtable c foo = ((1\<^sup>z)::'a expr)"
  assumes foobody: "methtable Foo foo = ((1\<^sup>z)::'a expr)"
  assumes foospec: "spectable Foo foo = {(E,h,hh,v,p). v = (1::int) \<and> hh=h \<and> p=\<langle>1 0 0 0\<rangle>}"

lemma (in example1) bonzo999:
 "\<rhd> ((MH_InvokeStatic Foo foo) :: 'a expr) : {(E,h,hh,v,p). E\<lfloor>self\<rfloor> \<noteq> Nullref}"
apply (rule vdm_mhinvokestatic)
apply (simp add: foobody)
apply (rule vdm_conseq)
apply (rule vdm_int)
apply clarsimp
oops
(* False; good! *)

constdefs one :: val
 "one == IVal (1::int)"

lemma (in example1) bonzo999:
 "\<rhd> ((MH_InvokeStatic Foo foo)::'a expr) :  {(E,h,hh,v,p). v = IVal 1 \<and> hh = h \<and> p = \<langle>1 0 0 0\<rangle>}"
apply (simp add: foospec)
apply (rule vdm_mhinvokestatic)
apply (simp add: foobody)
apply (rule vdm_conseq)
apply (rule vdm_int)
apply clarsimp
oops
(* False; bad! *)

(*
lemma (in example1) "\<forall> E h. E \<turnstile> h,(methtable Foo foo) \<Down>1 (h,IVal 1, \<langle>1 0 0 0\<rangle>)"
apply (clarsimp)
apply (simp add: foobody)
apply (rule semInt)
oops
*)

lemma (in example1) bonzo999:
 "\<rhd> ((methtable Foo foo) :: 'a expr) : {(E,h,hh,v,p). (v = IVal 1)}"
 apply (simp add: foobody)
 apply (rule vdm_conseq)
 apply (rule vdm_int)
 apply clarsimp
done

subsection {* Proper MH_Invoke *}

(* (\<exists> a . E\<lfloor>x\<rfloor> = Ref a \<and> fmap_lookup (heap.oheap h) a = Some Foo) \<longrightarrow> *)
(*
lemma (in example1) bonzo999:
 "\<rhd> ((MH_Invoke x foo) :: 'a expr) : {(E,h,hh,v,p). v = IVal 1 \<and> hh = h \<and> p = \<langle>5 0 1 1\<rangle>}"
apply (rule vdm_mhinvoke)
apply clarsimp
apply (case_tac "C=Foo")
 (* right class *)
 apply (simp add: qach_QaQ_def)
 apply (simp add: foobody)
 apply (rule vdm_conseq)
 apply (rule vdm_int)
 apply clarsimp
 (* .. case ok *)
 (* wrong class *)
 (* we assume that this doesn't happen; otherwise op sem gets stuck anyway *)
oops
*)

section {* \texttt{decI}: decrement a field *}

text {* Example program:  count field in self *}

subsection {*  Version: MH_InvokeStatic  *}

locale decI_example =
  fixes    m         :: iname
  fixes	   n         :: iname
  fixes	   q         :: iname
  fixes	   z         :: iname
  fixes    count     :: ifldname
  fixes	   decI      :: mname
  fixes    DecClass  :: cname
  assumes  decI_methtable[simp]: "methtable DecClass decI = 
              ((LET 
                m    = self\<bullet>count ;
                q    = m :0?
                IN 
                  IF q
                    THEN m\<^sup>I
                    ELSE LET
                           n = m :-- ;
                           z = self\<bullet>count := n
                         IN
                           n\<^sup>I
                         END
               END) :: 'a expr)"
  assumes decI_mspectable[simp]: "mspectable DecClass decI = {(E,h,hh,v,p). 0 < h<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> \<longrightarrow> v = IVal (h<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> - 1) \<and> (h'<(theloc E\<lfloor>self\<rfloor>)\<bullet>count>) = (h<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> - 1) }"
  assumes  vardistinct: "distinct [m,n,q,z] \<and> distinct [z,q,n,m]"
  assumes  allclasses:  "all_classes = {DecClass}"

lemma (in decI_example) 
   "\<rhd> ((MH_InvokeStatic DecClass decI)::'a expr) : {(E,h,hh,v,(p::Semantics.renv)). 0 < h<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> --> (v = IVal (h<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> - 1) \<and> (hh<(theloc E\<lfloor>self\<rfloor>)\<bullet>count>) = (h<(theloc E\<lfloor>self\<rfloor>)\<bullet>count> - 1)) }"
apply (insert vardistinct)
(* apply (rule vdm_conseq) *)
apply (rule vdm_mhinvokestatic)
apply simp                 (* porghvam yISach! *)
apply (rule vdm_conseq)
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) defer 1
apply (rule vdm_basics)
apply (rule vdm_basics)
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) defer 1
apply (rule vdm_basics)
apply (rule vdm_basics) defer 1
apply (rule vdm_basics)
apply clarsimp
(*
apply (case_tac "i= 0")
 apply clarsimp
 apply clarsimp
*)
apply (simp add: update_lemmas)
done

subsection {*  Version w/ MH_Invoke  *}

lemma (in decI_example) 
   "\<rhd> ((MH_Invoke x decI)::'a expr) : {(E,h,hh,v,(p::Semantics.renv)). \<forall> a . (qach_QaQ E h a x DecClass) \<longrightarrow> 0 < h<a\<bullet>count> \<longrightarrow> (v = IVal (h<a\<bullet>count> - 1) \<and> hh<a\<bullet>count> = h<a\<bullet>count> - 1) }"
apply (insert vardistinct)
apply (rule vdm_mhinvoke)
apply (rule allI)+ apply (rule impI) apply (erule conjE)+
apply (insert finclasses)
apply (simp add: allclasses qach_QaQ_def)
apply (erule_tac x="C" in allE)
(* apply (case_tac "C=DecClass") *)
apply simp
apply (rule vdm_conseq)
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) 
apply (rule vdm_basics)
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) 
apply (rule vdm_basics) 
apply (rule vdm_basics) 
apply (rule vdm_basics) 
apply clarsimp
apply (simp add: update_lemmas)
done

subsection {*  Version: InvokeStatic  *}

(* not yet *)

text {*
decrement the count field of the object pointed to by param
*}

locale decI_example2 =
  fixes    m         :: iname
  fixes	   n         :: iname
  fixes	   q         :: iname
  fixes	   x         :: rname
  fixes	   z         :: iname
  fixes    count     :: ifldname
  fixes	   decI      :: mname
  fixes    DecClass  :: cname
  assumes  decI_methtable[simp]: "methtable DecClass decI = 
              ((LET 
                m    = param\<bullet>count ;
                q    = m :0?
                IN 
                  IF q
                    THEN m\<^sup>I
                    ELSE LET
                           n = m :-- ;
                           z = param\<bullet>count := n
                         IN
                           n\<^sup>I
                         END
               END) :: 'a expr)"
  assumes decI_mspectable[simp]: "mspectable DecClass decI = {(E,h,hh,v,p). 0 < h<E\<lceil>param\<rceil>\<bullet>count> --> v = IVal (h<E\<lceil>param\<rceil>\<bullet>count> - 1) \<and> (h'<E\<lceil>param\<rceil>\<bullet>count>) = (h<E\<lceil>param\<rceil>\<bullet>count> - 1) }"
  assumes  vardistinct: "distinct [m,n,q,z] \<and> distinct [z,q,n,m]"
  assumes  allclasses:  "all_classes = {DecClass}"

subsection {* Version w/ InvokeStatic *}

(*
declare (in decI_example2) oheap_fct_def [simp]
declare (in decI_example2) iheap_fct_def [simp]
declare (in decI_example2) rheap_fct_def [simp]
declare (in decI_example2) ienv_fct_def [simp]
declare (in decI_example2) renv_fct_def [simp]
declare (in decI_example2) maxstack_fct_def [simp]
declare (in decI_example2) callcount_fct_def [simp]
declare (in decI_example2) invokedepth_fct_def [simp]
declare (in decI_example2) clock_fct_def [simp]
*)

(* yIngor! {param}DaQ *)
lemma (in decI_example2) 
  "\<rhd> ((InvokeStatic DecClass decI param)::'a expr) : {(E,h,hh,v,p). \<forall> a. qach_QaQ E h a param DecClass \<and> 0 < h<a\<bullet>count> \<longrightarrow> (v = IVal (h<a\<bullet>count> - 1) \<and> (hh<a\<bullet>count>) = (h<a\<bullet>count> - 1)) }"
apply (insert vardistinct)
(* apply (rule vdm_conseq) *)
apply (rule vdm_invokestatic)
apply simp                 (* porghvam yISach! *)
apply (rule vdm_conseq)
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) defer 1
apply (rule vdm_basics)
apply (rule vdm_basics)
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) defer 1
apply (rule vdm_basics)
apply (rule vdm_basics) defer 1
apply (rule vdm_basics)
apply clarsimp
apply (rename_tac h h' v E' a p aa)
apply (case_tac "h<a\<bullet>count> = 0")
 defer 1
 (* recursion case *)
 apply (simp add: qach_QaQ_def update_lemmas)
 (* base case *)
 apply (simp add: qach_QaQ_def update_lemmas)
done

(* yIngor! {param}DaQ *)
lemma (in decI_example2) 
  "\<rhd> ((InvokeStatic DecClass decI x)::'a expr) : {(E,h,hh,v,p). \<forall> a. qach_QaQ E h a x DecClass \<and> 0 < h<a\<bullet>count> \<longrightarrow> (v = IVal (h<a\<bullet>count> - 1) \<and> (hh<a\<bullet>count>) = (h<a\<bullet>count> - 1)) }"
apply (insert vardistinct)
(* apply (rule vdm_conseq) *)
apply (rule vdm_invokestatic)
apply simp                 (* porghvam yISach! *)
apply (rule vdm_conseq)
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) defer 1
apply (rule vdm_basics)
apply (rule vdm_basics)
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) defer 1
apply (rule vdm_basics) defer 1
apply (rule vdm_basics)
apply (rule vdm_basics) defer 1
apply (rule vdm_basics)
apply clarsimp
apply (rename_tac h h' v E' a p aa)
apply (case_tac "h<a\<bullet>count> = 0")
 defer 1
 (* recursion case *)
 apply (simp add: qach_QaQ_def update_lemmas)
 (* base case *)
 apply (simp add: qach_QaQ_def update_lemmas)
done

subsection {* Testing adaptation *}

(* --------------------------------------------------------------------------- *)

section {* Different version of adaptation *}

(* UNPROVEN LEMMA on context adaptation *)
lemma vdm_adapt_context: 
      "(insert (y\<diamondsuit>\<diamondsuit>mn, subst Q x y) G) \<rhd> e : P  
        \<Longrightarrow>
       (insert (x\<diamondsuit>\<diamondsuit>mn, Q) G) \<rhd> e : P"
sorry

(* adaptation lemma with built in alias branch *)
lemma vdm_adapt_context_with_alias: "\<lbrakk> {(x\<diamondsuit>\<diamondsuit>mn, subst Q x y)} \<rhd> e : P ; (\<forall> E h hh v p C a. (E,h,hh,v,p) \<in> P \<longrightarrow> qach_QaQ E h a x C \<longrightarrow> qach_QaQ E h a y C) \<rbrakk> \<Longrightarrow> {(y\<diamondsuit>\<diamondsuit>mn, Q)} \<rhd> e : P"
sorry (* , NOT! *)

lemma vdm_adapt_context_param: 
      "(insert (C\<bullet>mn(y), subst Q x y) G) \<rhd> e : P  
        \<Longrightarrow>
       (insert (C\<bullet>mn(x), Q) G) \<rhd> e : P"
sorry

lemma vdm_adapt_with_alias: "\<lbrakk> \<rhd> x\<diamondsuit>\<diamondsuit>mn : Q ; (\<forall> E h hh v p C a. (E,h,hh,v,p) \<in> Q \<longrightarrow> qach_QaQ E h a x C \<longrightarrow> qach_QaQ E h a y C) \<rbrakk> \<Longrightarrow>
                             \<rhd> y\<diamondsuit>\<diamondsuit>mn : Q"
sorry

lemma vdm_adapt_with_alias_InvokeStatic: "\<lbrakk> G \<rhd> (C\<bullet>mn(x)) : Q  ; (\<forall> E h hh v p C a. (E,h,hh,v,p) \<in> Q \<longrightarrow> qach_QaQ E h a x C \<longrightarrow> qach_QaQ E h a y C) \<rbrakk> \<Longrightarrow>
                             (G \<rhd> (C\<bullet>mn(y)) : Q)"
sorry

(*
lemma vdm_adapt_bonzo: "nuke y (subst Q x y) \<subseteq> nuke y Q"
apply (simp add: subst_def nuke_def)
apply clarsimp
apply (rule_tac x="E" in exI)
apply simp
done
*)

section {* Lemmas over these aux functions; SHOULD GO INTO Lemmas.thy !!!!!!!!!!! *}

lemma qach_QaQ_inj_arg: "\<lbrakk> qach_QaQ E h a r C ; qach_QaQ E h a' r C \<rbrakk> \<Longrightarrow> a = a'"
by (simp add: qach_QaQ_def)

lemma qach_QaQ_rvarIUpd[simp]: "qach_QaQ E<x:=n> h a r C = qach_QaQ E h a r C"
by (simp add: qach_QaQ_def)

lemma qach_QaQ_rvarRUpdSame[simp]: "qach_QaQ E\<lfloor>r:=Ref a\<rfloor> h a r C = (fmap_lookup (heap.oheap h) a = Some C)"
by (simp add: qach_QaQ_def)

lemma qach_QaQ_rvarRUpdOther[simp]: "r \<noteq> x  \<Longrightarrow> qach_QaQ E\<lfloor>x:=b\<rfloor> h a r C = qach_QaQ E h a r C"
by (simp add: qach_QaQ_def)

lemma qach_QaQ_heap1[simp]: "qach_QaQ E \<lparr> oheap = oheap h, iheap = foo, rheap = rheap h \<rparr> a r C = qach_QaQ E h a r C"
by (simp add: qach_QaQ_def)

lemma qach_QaQ9: "\<lbrakk> E\<lfloor>x\<rfloor> = E\<lfloor>y\<rfloor> ; qach_QaQ E h a x C \<rbrakk> \<Longrightarrow>  qach_QaQ E h a y C"
by (simp add: qach_QaQ_def)

lemma qach_QaQ8: "\<lbrakk> qach_QaQ E\<lfloor>x:=E\<lfloor>y\<rfloor>\<rfloor> h a x DecClass \<rbrakk> \<Longrightarrow> qach_QaQ E h a y DecClass"
by (simp add: qach_QaQ_def)

declare subst_def [simp]


(* --------------------------------------------------------------------------- *)

(* test with a context using a different name in calling decI *)
lemma (in decI_example) 
  "\<lbrakk> x \<noteq> y ; y \<noteq> x \<rbrakk> \<Longrightarrow> 
   {(y\<diamondsuit>\<diamondsuit>decI, {(E,h,hh,v,(p::Semantics.renv)). 
     \<forall> a . (qach_QaQ E h a y DecClass) \<longrightarrow> 0 < h<a\<bullet>count> \<longrightarrow> (v = IVal (h<a\<bullet>count> - 1) \<and> hh<a\<bullet>count> = h<a\<bullet>count> - 1)})} 
   \<rhd> ((x\<diamondsuit>\<diamondsuit>decI)::'a expr) : {(E,h,hh,v,(p::Semantics.renv)). 
   (\<forall> a . (qach_QaQ E h a x DecClass) \<longrightarrow> 0 < h<a\<bullet>count> \<longrightarrow> (v = IVal (h<a\<bullet>count> - 1) \<and> hh<a\<bullet>count> = h<a\<bullet>count> - 1)) }"
apply (rule vdm_adapt_context)
apply (rule vdm_ax)
apply (simp add: subst_def)
apply auto
defer 1
(* 3 subgoals left *)
apply (rename_tac h' h v E a)
apply (erule_tac x="a" in allE)
apply (simp add: qach_QaQ_def update_lemmas renv_fct_def)
apply (rename_tac h' h v E a)
apply (erule_tac x="a" in allE)
apply (simp add: qach_QaQ_def update_lemmas renv_fct_def)
(* 1 subgoal left *)
apply (rename_tac E' h' h v)
apply (rule_tac x="E'\<lfloor>y:=E'\<lfloor>x\<rfloor>\<rfloor>" in exI)
apply clarsimp
apply (rule conjI)
apply (simp add: qach_QaQ_def update_lemmas renv_fct_def)
oops

(*
apply (tactic {* all_tac *})
apply (drule mp) defer 1 
 apply (drule mp) apply assumption 
 apply simp
apply (tactic {* all_tac *})
apply (rename_tac h h' v E a)
apply (erule_tac x="a" in allE)
apply (drule mp) defer 1 
 apply (drule mp) apply assumption 
 apply simp
apply (tactic {* all_tac *})
apply (rename_tac E' h h' v)
apply (erule_tac x="a" in allE)
apply (rule_tac x="E'\<lfloor>x:=E'\<lfloor>y\<rfloor>\<rfloor>" in exI)
apply (drule mp) defer 1 
  apply (drule mp) apply simp
 apply simp
apply (tactic {* all_tac *})
apply (tactic {* all_tac *})
(* EX version *)
defer 1
apply (rename_tac h h' v E a)
apply (erule_tac x="a" in allE)
apply (drule mp) defer 1 
 apply (drule mp) apply assumption 
 apply simp
apply (tactic {* all_tac *})
apply (rename_tac h h' v E a)
apply (erule_tac x="a" in allE)
apply (drule mp) defer 1 
 apply (drule mp) apply assumption 
 apply simp
apply (rotate_tac 3) apply (erule thin_rl)
apply (frule qach_QaQ9) 
apply simp
apply assumption
defer 1
apply (frule qach_QaQ8)
apply assumption
apply (frule qach_QaQ8)
apply assumption
apply rule
apply rule
defer 1
apply (rule allI)
apply (erule_tac x="ad" in allE)
apply safe
apply (rule_tac x="E\<lfloor>x:=E\<lfloor>y\<rfloor>\<rfloor>" in exI)
apply clarsimp
apply (tactic {* all_tac *})

apply (subgoal_tac "y \<noteq> x")
apply (simp add: rvarUpdOther)
defer 1
apply (simp add: subst_def)
oops
*)
end
