(*  
   File:	$RCSfile: ExampleCoastPedal.thy,v $
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ExampleCoastPedal.thy,v 1.2 2003/08/25 10:46:22 lenb Exp $

   coast/pedal example from \cite{NipkowXX}
*)

theory ExampleCoastPedal = Prelude + Lemmas + VDMderived :

locale coast_pedal_example =
    fixes    m  :: iname
    fixes    n  :: iname
    fixes    a  :: iname
    fixes    b  :: iname
    fixes    c  :: iname
    fixes    q :: iname
    fixes pedal :: funame
    fixes coast :: funame
    fixes pedalBody :: "'a expr"
    fixes coastBody :: "'a expr"
    fixes coastSpec :: "vdmassn"
    fixes pedalSpec :: "vdmassn"
  defines "pedalBody == (LET q = Primop (% x y. if ((x = 0) \<or> (y = 0)) then 1 else 0) n m 
                         IN IF q 
                       	    THEN IVar c
                       	    ELSE LET c = Primop (% x y. x + y) c m;
                                     q = Primop (% x y. if x < y then 1 else 0) n m
                       	         IN  IF q
                       	             THEN LET n = n :-- ;
                       	                      m = m :--
                       	                  IN CALL coast END
                       	              ELSE LET n = n:-- IN CALL pedal END
	                         END
                         END) :: 'a expr"
 defines "coastBody == (LET c = Primop (% x y. x + y) c n;
                            q =  Primop (% x y. if x < y then 1 else 0) n m
                        IN IF q 
                           THEN LET m = m :-- IN CALL coast END
                           ELSE CALL pedal
                        END) :: 'a expr"
  defines "pedalSpec == {(E,h,hh,v,p). (E<n> * E<m> + E<c> = E<a> * E<b>) \<longrightarrow> (v = IVal (E<a> * E<b>))}"
  defines "coastSpec == {(E,h,hh,v,p). (E<n> * (E<m> + 1) + E<c> = E<a> * E<b>) \<longrightarrow> (v = IVal (E<a> * E<b>))}"
  assumes pedalspec : "spectable pedal = pedalSpec"
  assumes coastspec : "spectable coast = coastSpec"
  assumes pedalfnbdy : "funtable pedal = pedalBody"
  assumes coastfnbdy : "funtable coast = coastBody"
  assumes vardistinct: "distinct [m,n,q,a,b,c] \<and> distinct [c,a,b,q,n,m] \<and> distinct[coast,pedal] \<and> distinct[pedal,coast]"

declare (in coast_pedal_example) pedalfnbdy [simp]  (* function body lookup *)
declare (in coast_pedal_example) coastfnbdy [simp]  (* function body lookup *)
declare (in coast_pedal_example) pedalBody_def [simp]  (* unfold function body *)
declare (in coast_pedal_example) coastBody_def [simp]  (* unfold function body *)

lemma Law1: "\<forall> A B . (A * (B + 1::int) = A * B + A)"
apply clarsimp
sorry

lemma Law2: "\<forall> A B C. (A * B + C = (A - 1::int) * B + (C + B))"
apply clarsimp
sorry

lemma (in coast_pedal_example) 
   "\<rhd> (Call pedal)::'a expr : spectable pedal"
apply (rule MUTREC)
apply (subgoal_tac "finite {(Call pedal, spectable pedal), (Call coast, spectable coast)}")
apply assumption
apply (simp_all add: consistent_def)
apply (insert vardistinct)
apply clarsimp
apply (case_tac "f = pedal")
  apply clarsimp
  prefer 2 apply clarsimp prefer 2
  apply (rule vdm_conseq)
  apply (rule vdm_leti, rule vdm_prim) prefer 2 apply clarsimp prefer 2
  apply (rule vdm_if, rule vdm_ivar) prefer 2 apply clarsimp prefer 2
  apply (rule vdm_leti, rule vdm_prim) prefer 2 apply clarsimp prefer 2
  apply (rule vdm_leti, rule vdm_prim) prefer 2 apply clarsimp prefer 2
  apply (rule vdm_if)
  apply (rule vdm_leti, rule vdm_prim) prefer 3 apply clarsimp prefer 2
  apply (rule vdm_leti, rule vdm_prim) prefer 2 apply clarsimp prefer 2
  apply (rule vdm_ax, simp)
  defer 1
  apply (rule vdm_leti, rule vdm_prim) prefer 3 apply clarsimp prefer 2
  apply (rule vdm_ax, simp)
  defer 1
  apply (rule vdm_conseq)
  apply (rule vdm_leti, rule vdm_prim) prefer 2 apply clarsimp prefer 2 
  apply (rule vdm_leti, rule vdm_prim) prefer 2 apply clarsimp prefer 2 
  apply (rule vdm_if) 
  apply (rule vdm_leti, rule vdm_prim) prefer 3 apply clarsimp prefer 2 
  apply (rule vdm_ax, simp)
  prefer 2
  apply (rule vdm_ax, simp)
(*end of vcg*)
  apply (simp_all add: coastspec coastSpec_def pedalspec pedalSpec_def)
  apply clarsimp
  apply (case_tac "aa<n> < aa<m>", clarsimp)
  apply (insert Law1, fastsimp)
  apply clarsimp
  apply clarsimp
  apply (rotate_tac -2, erule thin_rl)
  apply (case_tac "aa<m> = 0", clarsimp)
  apply (clarsimp, insert Law2)
  apply (erule_tac x="aa<n>" in allE, erule_tac x="aa<m>" in allE, erule_tac x="aa<c>" in allE, simp)
  apply fastsimp
done
end

