theory cloneVCGLenSpec = DiamondListIntMH:

(* This specific part for a prticular program, in its turn, contains a subpart, 
common for all Isabelle presentation for Grail programs with DIAMOND*)
(* This subpart is about freelist management: alloc, make, fill, free *)

(* We consider the Grail image CloneList.gr of CloneList.cmlt *)

(* We do mot take into account intreface methods, with java.Lang.string,
 generated the compiler *)
(* We are interested in a method to which a camelot-function "clone"
is mapped *)
(*
CAMELOT 
type intlist = Nil | Cons of int*intlist
val clone: intlist -> intlist

let clone l = 
	match l with 
	   Nil@_ -> Nil
         | Cons(h, t)@_ -> Cons(h, clone t)

let start args  =
let l = clone  (Cons(2, Cons(1, Nil)))
in ()
   
   

GRAIL:
method static public CloneList$dia_0 clone (CloneList$dia_0 l) =
   let

      fun f:clone(CloneList$dia_0 l) =
      let
         val v2 = getfield l <int CloneList$dia_0.$>
      in
         if v2 = 0
         then f:0(l)
         else f:1(l)
      end

      fun f:1(CloneList$dia_0 l) =
      let
         val v2 = getfield l <int CloneList$dia_0.f0>
         val v1 = getfield l <CloneList$dia_0 CloneList$dia_0.f1>
         val () = invokestatic <void CloneList$dia_0.free (CloneList$dia_0)> (l)
         val l = invokestatic <CloneList$dia_0 CloneList.clone (CloneList$dia_0)> (v1)
      in
         invokestatic <CloneList$dia_0 CloneList$dia_0.make (int, int, CloneList$dia_0)> (1, v2, l)
      end

      fun f:0(CloneList$dia_0 l) =
      let
         val () = invokestatic <void CloneList$dia_0.free (CloneList$dia_0)> (l)
      in
         invokestatic <CloneList$dia_0 CloneList$dia_0.make (int)> (0)
      end
   in
      f:clone(l)
   end

*)

(* make1 - "make" of arity 1 *)
(* make3 - "make" of arity 3 *) 
(* fill2 - "fill" of arity 2 *)
(* fill4 - "fill" of arity 4 *)

(* fill2 has 2 parameters so can't be a method. But fortunately fill2 
is invoked using the Grail convention. 
So we model it as a function. Same applies to fill4 *)


(* for modelling the arguments to make1 and make3 *)
(* a parameter "param" has 3 fields, - TAG, V0, V1 *)
(* the content of these fields will be assigned to vars tag, v0, v1 *)
(* these vars will be processed by a "function call" of fill1/fill3 *)

constdefs subst :: "vdmassn \<Rightarrow> rname \<Rightarrow> rname \<Rightarrow> vdmassn"
"subst P y x \<equiv> {(E,h,hh,v,p). (E\<lfloor>x := E\<lfloor>y\<rfloor>\<rfloor>,h,hh,v,p) \<in> P}"

constdefs nuke :: "rname \<Rightarrow> vdmassn \<Rightarrow> vdmassn"
"nuke y P \<equiv> {(E,h,hh,v,p). (E\<lfloor>y := Nullref\<rfloor>,h,hh,v,p) \<in> P}"

constdefs not_free_in_assn :: "rname \<Rightarrow> vdmassn \<Rightarrow> bool"
"not_free_in_assn y Q \<equiv> \<forall> x E h hh v p. (E,h,hh,v,p) \<in> Q \<longrightarrow> (E\<lfloor>y:=E\<lfloor>x\<rfloor>\<rfloor>,h,hh,v,p) \<in> Q"

lemmas petaQ_lemmas = subst_def nuke_def not_free_in_assn_def

lemma vdm_adapt_context: 
      "\<lbrakk> {(InvokeStatic cn mn rn', subst Q rn' rn), (e1, P1), (e2, P2), (e3, P3), (e4, P4), (e5, P5)} \<rhd> e : P \<rbrakk> 
        \<Longrightarrow>
       {(e1, P1), (e2, P2), (InvokeStatic cn mn rn, Q), (e3, P3), (e4, P4), (e5, P5)}\<rhd> e : P"
sorry

lemma vdm_adapt_context1: 
      "\<lbrakk> {(InvokeStatic cn mn rn', subst Q rn' rn), (e1, P1), (e2, P2), (e3, P3), (e4, P4), (e5, P5)} \<rhd> e : P \<rbrakk> 
        \<Longrightarrow>
       ({(e1, P1), (e2, P2), (e3, P3)} \<union> {(InvokeStatic cn mn rn, Q)} \<union>  {(e4, P4), (e5, P5)}) \<rhd> e : P"
sorry



consts TAG :: ifldname
       V0 :: ifldname
       V1 :: rfldname

(* locale DiamondClone = *)
consts
     (* freelist management: for conversion of CloneList$dia.gr *) 
     alloc :: mname 
consts free :: mname 
consts make1 :: mname 
consts make3 :: mname 
consts 
     (* *)
     allocQ :: funame 
consts fill2TEMP :: funame 
consts fill4TEMP :: funame 
consts
     (* tag, v0 are int parameters, for "fill", "make" *)
     b :: iname 
consts tag :: iname 
consts v0 :: iname 
consts
     (* flp is a static pointer to a freelist *)
     flp ::rname 
consts freelist :: rname 
consts t :: rname 
consts
     (* node, x, v1 are ref parameters, for "free", "fill", "make" *) 
     node :: rname 
consts x :: rname 
consts v1 :: rname 
consts 
     (* to model 0-param. "alloc", 
consts multiparam. "fill", "make" *)
     dummyPar :: rname 
consts PARmake::rname 
consts
     (* bodies *)
     allocBODY::"nat expr" 
consts allocQBODY::"nat expr" 
consts freeBODY::"nat expr" 
consts
     fill2BODY::"nat expr" 
consts fill4BODY::"nat expr" 
consts make1BODY::"nat expr" 
consts make3BODY::"nat expr" 
     
     (* specific part: for conversion of CloneList.gr *)
consts CLONELIST :: cname 
consts
     clone :: mname 
consts fclone :: funame 
consts ff0 :: funame 
consts ff1 :: funame 
consts 
     cloneBODY :: "nat expr" 
consts fcloneBODY  ::"nat expr"  
consts ff0BODY  ::"nat expr"  
consts ff1BODY  ::"nat expr" 
     
consts cloneb :: iname 
consts clonetempf0 :: rname 
consts clonetempf1 :: rname 
consts
     clonev1 :: rname 
consts clonev2 :: iname 
consts clonezero :: iname 
consts  cloneone :: iname 
(*
consts 
     renvQ :: renv 
consts renvAllocNone :: renv 
consts renvAllocSome :: renv 
consts renvFree :: renv 
consts 
     renvFill2 :: renv and renvFill4 :: renv and renvMake1 :: renv and renvMake3 :: renv
*)
     (* ??? Env-s for specific part ???? *)
constdefs
 renvQ  :: renv
 "renvQ == \<langle>8 1 0 0\<rangle>"
constdefs
 renvAllocNone  :: renv
 "renvAllocNone == \<langle>15 0 1 1\<rangle>"
constdefs
 renvAllocSome  :: renv
 "renvAllocSome == \<langle>18 2 0 0\<rangle>"
constdefs
 renvFree  :: renv
 "renvFree == \<langle>14 0 1 1\<rangle>"
constdefs
 renvFill2  :: renv
 "renvFill2 == \<langle>5 1 0 0\<rangle>"
constdefs
 renvFill4  :: renv
 "renvFill4 == \<langle>11 1 0 0\<rangle>"
constdefs
 renvMake1  :: renv
 "renvMake1 == \<langle>13 0 1 1\<rangle>"
constdefs
 renvMake3  :: renv
 "renvMake3 == \<langle>19 0 1 1\<rangle>"
    (* ??? Env-s for specific part ???? *)

(* method and function BODies *)
axioms frbd[simp]: "freeBODY == (LET rf freelist = GetFr flp DollarF;
                                       _ = PutFr node DollarN freelist
                                     IN PutFr flp DollarF node
                                    END)::nat expr"
axioms alcbd[simp]: "allocBODY == (LET rf freelist = GetFr flp DollarF; 
                                       b = RPrimop (% r1 r2 . if r1 = Nullref then 1 else 0) freelist freelist
                                       IN IF b THEN (NEW <DIAMOND> ([],[])) ELSE CALL allocQ 
                                       END)::nat expr"
axioms alcqbd[simp]: "allocQBODY == (LET rf t = GetFr freelist DollarN;
                                                _ = PutFr flp DollarF t
                                         IN RVar freelist 
                                         END)::nat expr"
axioms fl2bd[simp]: "fill2BODY == (LET _ = PutFi x Dollar tag IN RVar x END)::nat expr"
axioms fl4bd[simp]: "fill4BODY == (LET _ = PutFi x Dollar tag;
                                           _ = PutFi x F0 v0;
                                           _ = PutFr x F1 v1
                                       IN RVar x END)::nat expr"
axioms mk1bd[simp]: "make1BODY == ( LET rf dummyPar = Null;
                                           rf x = InvokeStatic DIAMOND alloc dummyPar;
                                            tag = GetFi param TAG
                                       IN CALL fill2TEMP END)::nat expr" 
axioms  mk3bd[simp]:"make3BODY == (LET rf dummyPar = Null;
                                          rf x = InvokeStatic DIAMOND alloc dummyPar;
                                             tag = GetFi param TAG;
                                             v0 = GetFi param V0;
                                          rf v1 = GetFr param V1
                                     IN CALL fill4TEMP END)::nat expr"  
axioms fclbd[simp]:"fcloneBODY == (LET clonev2 = GetFi param Dollar;
                         cloneb = Primop (% l1 l2. if l1 =0 then 1 else 0) clonev2 clonev2 
                         IN IF cloneb THEN CALL ff0 ELSE CALL ff1
                         END) :: nat expr"
axioms f1bd[simp]:"ff1BODY == (LET    clonev2 = GetFi param F0;
                        rf  clonev1 = GetFr param F1;
                                 _  = InvokeStatic DIAMOND free param;
                        rf    param =  InvokeStatic CLONELIST clone clonev1;
                           cloneone = expr.Int 1;
                           _   = PutFi PARmake TAG cloneone;
                           _   = PutFi PARmake V0  clonev2; 
                           _   = PutFr PARmake V1  param;
                        rf clonetempf0 = InvokeStatic DIAMOND make3 PARmake
                    IN RVar clonetempf0
                    END) :: nat expr"
axioms f0bd[simp]:"ff0BODY == ( LET _  = InvokeStatic DIAMOND free param;
                                   clonezero = expr.Int 0;
                                   _   = PutFi PARmake TAG clonezero;
                                  rf clonetempf1 = InvokeStatic DIAMOND make1 PARmake
                     IN RVar clonetempf1 
                     END) :: nat expr"
axioms clbd[simp]: "cloneBODY == ( CALL fclone ) :: nat expr"

constdefs
  myContext :: "nat vdmcontext" 
 "myContext == {((InvokeStatic DIAMOND  alloc dummyPar)::nat expr, Mspectable DIAMOND alloc), 
                      ((InvokeStatic DIAMOND free param)::nat expr,  Mspectable DIAMOND free), 
                      ((InvokeStatic DIAMOND make1 PARmake)::nat expr, Mspectable DIAMOND make1), 
                      ((InvokeStatic DIAMOND make3 PARmake)::nat expr, Mspectable DIAMOND make3), 
                      ((Call allocQ)::nat expr, spectable allocQ), 
                      ((Call fill2TEMP)::nat expr, spectable fill2TEMP), 
                      ((Call fill4TEMP)::nat expr, spectable fill4TEMP),
                      ((Call fclone)::nat expr, spectable fclone),
                      ((Call ff0)::nat expr, spectable ff0),
                      ((Call ff1)::nat expr, spectable ff1),
                      ((InvokeStatic CLONELIST clone param)::nat expr, Mspectable CLONELIST clone)}"
                           
                         
axioms FREE[simp]: "methtable DIAMOND free == freeBODY" 
axioms ALLOC[simp]: "methtable DIAMOND alloc == allocBODY" 
axioms ALLOCQ[simp]: "funtable allocQ == allocQBODY"
axioms FILL2TEMP[simp]: "funtable fill2TEMP == fill2BODY" 
axioms FILL4TEMP[simp]: "funtable fill4TEMP == fill4BODY" 
axioms MAKE1[simp]: "methtable DIAMOND make1 == make1BODY" 
axioms MAKE3[simp]: "methtable DIAMOND make3 == make3BODY"
 (*****************************************************************) 
axioms FCLONE[simp]: "funtable fclone == fcloneBODY"
axioms FF0[simp]: "funtable ff0 == ff0BODY"
axioms FF1[simp]: "funtable ff1 == ff1BODY"
axioms CLONE[simp]: "methtable CLONELIST clone == cloneBODY"


(*****************************************************************) 
consts spectPredFill2TEMP:: "env \<Rightarrow>  heap  \<Rightarrow>   heap   \<Rightarrow>  val  \<Rightarrow>   renv \<Rightarrow> bool"
defs spectPredFill2TEMP_def: "spectPredFill2TEMP E h hh v p ==  \<forall> loc i x tag.
                                          ((E\<lfloor>x\<rfloor> = Ref loc \<and> E<tag> = i) \<longrightarrow>
                                           (v = RVal (Ref loc) \<and> p = renvFill2 \<and> hh = h<loc\<bullet>Dollar:=i>))"
declare spectPredFill2TEMP_def[simp]
(*****************************************************************) 
consts spectPredFill4TEMP:: "env \<Rightarrow>  heap  \<Rightarrow>   heap   \<Rightarrow>  val  \<Rightarrow>   renv \<Rightarrow> bool"
defs spectPredFill4TEMP_def: "spectPredFill4TEMP E h hh v p == \<forall> l i V1 V0 x tag v1 v0.
               ((E\<lfloor>x\<rfloor> = Ref l \<and> E<tag> = i \<and> E\<lfloor>v1\<rfloor> = V1 \<and> E<v0> = V0) 
               \<longrightarrow> (v = RVal (Ref l) \<and> p = renvFill4 \<and> hh = h<l\<bullet>Dollar:=i><l\<bullet>F0:=V0>\<lfloor>l\<diamondsuit>F1:=V1\<rfloor>))"
declare spectPredFill4TEMP_def[simp]
(*****************************************************************) 
consts spectPredFree:: "env \<Rightarrow>  heap  \<Rightarrow>   heap   \<Rightarrow>  val  \<Rightarrow>   renv \<Rightarrow> ref \<Rightarrow> bool"
defs spectPredFree_def: "spectPredFree E h hh v p arg == \<forall> freeLST FL X n d f0 f1 l flp node. 
               (arg = Ref l \<and>
                (E\<lfloor>flp\<rfloor> = (Ref freeLST) \<and> (FL, Ref freeLST,  X, h) \<in> modelsStaticMH \<and> 
                 E\<lfloor>node\<rfloor> = Ref l \<and> (n,d,f0,f1,l,h) : modelsDIAMOND \<and> l \<notin> X)
               \<longrightarrow> (v = arbitrary \<and> p = renvFree \<and> hh = h\<lfloor>l\<diamondsuit>DollarN := h\<lfloor>freeLST\<diamondsuit>DollarF\<rfloor>\<rfloor>\<lfloor>freeLST\<diamondsuit>DollarF := Ref l\<rfloor> 
                    \<and> (Suc FL, Ref freeLST,  X\<union>{l}, h) \<in> modelsStaticMH)) "
declare spectPredFree_def[simp]

(*              
 axioms spectFree[simp]:
            "Mspectable DIAMOND free == 
             {(E,h,hh,v,p) . \<forall> freeLST FL X n d f0 f1 flopt l fl nn. 
                ((E\<lfloor>flp\<rfloor> = Ref freeLST \<and> (FL,freeLST,flopt,X,h) \<in> modelsStatic \<and> 
                  E\<lfloor>node\<rfloor> = Ref l \<and> (n,d,f0,f1,l,h) : modelsDIAMOND \<and> l \<notin> X)
                \<longrightarrow> (v = arbitrary \<and> p = renvFree \<and> hh = h\<lfloor>l\<diamondsuit>DollarN := h\<lfloor>freeLST\<diamondsuit>DollarF\<rfloor>\<rfloor>\<lfloor>freeLST\<diamondsuit>DollarF := Ref l\<rfloor> \<and> 
                      ((flopt = None \<longrightarrow> (0,freeLST,Some l,{l},hh) : modelsStatic) \<and> 
                      (flopt = Some fl \<longrightarrow> (Suc FL,freeLST,Some l, X \<union> {l},hh) : modelsStatic))))}"
*)
(*****************************************************************) 
consts spectPredAllocQ:: "env \<Rightarrow>  heap  \<Rightarrow>   heap   \<Rightarrow>  val  \<Rightarrow>   renv \<Rightarrow> bool"
defs spectPredAllocQ_def: "spectPredAllocQ E h hh v p == \<forall> flp freeLST FL X freelist fl. 
               (E\<lfloor>flp\<rfloor> = Ref freeLST \<and> (FL, Ref freeLST, X,h) \<in> modelsStaticMH \<and> 
                  E\<lfloor>freelist\<rfloor> = h\<lfloor>freeLST\<diamondsuit>DollarF\<rfloor> \<and> E\<lfloor>freelist\<rfloor>=Ref fl 
                \<longrightarrow> v = RVal (Ref fl) \<and> p = renvQ \<and> (FL, Ref fl, X, h) \<in> modelsFreelistMH \<and> 
                      (\<exists> n d f0 f1. (n,d,f0,f1,fl,h) \<in> modelsDIAMOND \<and> fl \<in> X \<and>
                        hh = \<lparr>oheap = oheap h, iheap = iheap h, 
                               rheap = (rheap h)(DollarF := (rheap h DollarF)(freeLST := h\<lfloor>fl\<diamondsuit>DollarN\<rfloor>))\<rparr> \<and>
                         (FL-(1::nat), Ref freeLST, X-{fl}, hh) \<in> modelsStaticMH))"
declare spectPredAllocQ_def[simp]


(* Lennart:
axioms spectAllocQ[simp]:
           "spectable allocQ == {(E,h,hh,v,p) . \<forall> freeLST FL X i flopt fl. 
               ((E\<lfloor>flp\<rfloor> = Ref freeLST \<and> (FL,freeLST,flopt,X,h) \<in> modelsStatic \<and> 
                 (flopt = Some fl) \<and> E\<lfloor>freelist\<rfloor> = h\<lfloor>freeLST\<diamondsuit>DollarF\<rfloor>)
                \<longrightarrow> ( v = RVal (Ref fl) \<and> p = renvQ \<and> (FL, fl,X,h) \<in> modelsFreelist \<and> 
                      (\<exists> n d f0 f1. (n,d,f0,f1,fl,h) \<in> modelsDIAMOND \<and> fl \<in> X \<and> 
                         hh = \<lparr>oheap = oheap h, iheap = iheap h, 
                               rheap = (rheap h)(DollarF := (rheap h DollarF)(freeLST := h\<lfloor>fl\<diamondsuit>DollarN\<rfloor>))\<rparr> \<and> 
                         (((n = Nullref) \<longrightarrow> (0,freeLST,None,{},hh) : modelsStatic) \<and>
                                               (\<forall> nn . n = Ref nn \<longrightarrow> (\<exists> i . FL = Suc i \<and> nn \<in> X - {fl} \<and> 
                                                                             (i,nn, X - {fl}, h) : modelsFreelist \<and>
                                                                             (i,freeLST,Some nn,X - {fl},hh) : modelsStatic))))))}"
*)
(*****************************************************************) 
consts spectPredAlloc:: "env \<Rightarrow>  heap  \<Rightarrow>   heap   \<Rightarrow>  val  \<Rightarrow>   renv \<Rightarrow> bool"
defs spectPredAlloc_def: "spectPredAlloc E h hh v p == \<forall> flp freeLST FL X fl. 
               (E\<lfloor>flp\<rfloor> = Ref freeLST \<and> (FL, Ref freeLST, X, h) \<in> modelsStaticMH \<longrightarrow> 
                   (rheap h DollarF freeLST  = Nullref \<longrightarrow> 
                                                (\<exists> r . (0, Ref freeLST, X, hh) \<in> modelsStaticMH \<and> v = RVal (Ref r) \<and> 
                                                 r \<notin> fmap_dom (oheap h) \<and> hh = newObj h r E DIAMOND [] [] \<and> p = renvAllocNone)) \<and> 
                    (rheap h DollarF freeLST  = Ref fl \<longrightarrow> 
                           v = RVal (Ref fl) \<and> p = renvAllocSome \<and> (FL, Ref fl, X ,h) \<in> modelsFreelistMH \<and> 
                                             (\<exists> n d f0 f1. (n,d,f0,f1,fl,h) \<in> modelsDIAMOND \<and> fl \<in> X \<and> 
                                               hh = \<lparr>oheap = oheap h, iheap = iheap h, 
                                                     rheap = (rheap h)(DollarF := (rheap h DollarF)(freeLST := h\<lfloor>fl\<diamondsuit>DollarN\<rfloor>))\<rparr> \<and> 
                                               (FL - 1, Ref freeLST, X-{fl}, hh) \<in> modelsStaticMH)))"
declare spectPredAlloc_def[simp]

(*Lennart:
axioms spectAlloc[simp]:
            "Mspectable DIAMOND alloc == 
             {(E,h,hh,v,p) . \<forall> freeLST FL X i flopt fl. 
                ((E\<lfloor>flp\<rfloor> = Ref freeLST \<and> (FL,freeLST,flopt,X,h) \<in> modelsStatic) \<longrightarrow> 
                    (((flopt = None) \<longrightarrow> (\<exists> r . (0,freeLST,None,X,hh) \<in> modelsStatic \<and> v = RVal (Ref r) \<and> 
                                                  r \<notin> fmap_dom (oheap h) \<and> hh = newObj h r E DIAMOND [] [] \<and> p = renvAllocNone)) \<and> 
                     ((flopt = Some fl) \<longrightarrow> ( v = RVal (Ref fl) \<and> p = renvAllocSome \<and> (FL, fl,X,h) \<in> modelsFreelist \<and> 
                                              (\<exists> n d f0 f1. (n,d,f0,f1,fl,h) \<in> modelsDIAMOND \<and> fl \<in> X \<and> 
                                                hh = \<lparr>oheap = oheap h, iheap = iheap h, 
                                                       rheap = (rheap h)(DollarF := (rheap h DollarF)(freeLST := h\<lfloor>fl\<diamondsuit>DollarN\<rfloor>))\<rparr> \<and> 
                                                (((n = Nullref) \<longrightarrow> (0,freeLST,None,{},hh) : modelsStatic) \<and>
                                                  (\<forall> nn . n = Ref nn \<longrightarrow> (\<exists> i . FL = Suc i \<and> nn \<in> X - {fl} \<and>
                                                                           (i,nn, X - {fl}, h) : modelsFreelist \<and>
                                                        (i,freeLST,Some nn,X - {fl},hh) : modelsStatic))))))))}" 
*)   
(*****************************************************************)

consts spectPredMake1:: "env \<Rightarrow>  heap  \<Rightarrow>   heap   \<Rightarrow>  val  \<Rightarrow>   renv \<Rightarrow> ref \<Rightarrow> bool"
defs spectPredMake1_def: "spectPredMake1 E h hh v p arg  == \<forall> flp freeLST FL X ploc PARmake param dummyPar x tag. 
                  (arg=E\<lfloor>PARmake\<rfloor> \<and>
                  E\<lfloor>flp\<rfloor> = Ref freeLST \<and> (FL, Ref freeLST, X, h) \<in> modelsStaticMH \<and> E\<lfloor>PARmake\<rfloor> = Ref ploc \<longrightarrow> 
                  (\<exists>  r h1 p1 p2. 
                   ((spectPredAlloc  \<lparr>ienv = emptyi, renv = emptyr\<rparr>\<lfloor>self:=Ref freeLST\<rfloor>\<lfloor>param:=Ref ploc\<rfloor>\<lfloor>dummyPar:=Nullref\<rfloor>\<lfloor>flp:=Ref freeLST\<rfloor>
                                    h h1 (RVal r) p1)  
                     \<and>
                  (spectPredFill2TEMP 
                                  \<lparr>ienv = emptyi, renv = emptyr\<rparr>\<lfloor>self:=Ref freeLST\<rfloor>\<lfloor>param:=Ref ploc\<rfloor>\<lfloor>dummyPar:=Nullref\<rfloor>
                                   \<lfloor>flp:=Ref freeLST\<rfloor>\<lfloor>x:=r\<rfloor><tag:=(heap.iheap h1) TAG ploc> 
                                   h1 hh v p2) \<and>
                  p = (renvMake1 \<oplus> p1 \<smile> p2))))"
declare spectPredMake1_def[simp]

(* Lennart                                                                        
axioms spectMake1[simp]:
           "Mspectable DIAMOND make1 == 
               {(E,h,hh,v,p) . \<forall> freeLST FL X i flopt fl pref sref. 
                 ((E\<lfloor>flp\<rfloor> = Ref freeLST \<and> (FL,freeLST,flopt,X,h) \<in> modelsStatic) \<and> E\<lfloor>PARmake\<rfloor> = Ref pref \<longrightarrow> 
                  (\<exists> X h1 p1 p2. 
                  (\<lparr>ienv = emptyi, renv = emptyr\<rparr>\<lfloor>self:=Ref freeLST\<rfloor>\<lfloor>param:=Ref pref\<rfloor>\<lfloor>dummyPar:=Nullref\<rfloor>\<lfloor>flp:=Ref freeLST\<rfloor>,h,h1,RVal X,p1) : 
                    Mspectable DIAMOND alloc \<and>
                  (\<lparr>ienv = emptyi, renv = emptyr\<rparr>\<lfloor>self:=Ref freeLST\<rfloor>\<lfloor>param:=Ref pref\<rfloor>\<lfloor>dummyPar:=Nullref\<rfloor>\<lfloor>flp:=Ref freeLST\<rfloor>\<lfloor>x:=X\<rfloor>
                   <tag:=(heap.iheap h1) TAG pref>,h1,hh,v,p2) : spectable fill2TEMP \<and>
                  p = (renvMake1 \<oplus> p1 \<smile> p2)))}"
*)

(*****************************************************************)

consts spectPredMake3:: "env \<Rightarrow>  heap  \<Rightarrow>   heap   \<Rightarrow>  val  \<Rightarrow>   renv \<Rightarrow> ref \<Rightarrow> bool"
defs spectPredMake3_def: "spectPredMake3 E h hh v p arg == \<forall> flp freeLST FL X PARmake ploc param dummyPar x tag. 
                  (arg= E\<lfloor>PARmake\<rfloor> \<and> 
                   E\<lfloor>flp\<rfloor> = Ref freeLST \<and> (FL, Ref freeLST, X, h) \<in> modelsStaticMH \<and> E\<lfloor>PARmake\<rfloor> = Ref ploc \<longrightarrow> 
                  (\<exists>  r h1 p1 p2. 
                   ((spectPredAlloc  \<lparr>ienv = emptyi, renv = emptyr\<rparr>\<lfloor>self:=Ref freeLST\<rfloor>\<lfloor>param:=Ref ploc\<rfloor>\<lfloor>dummyPar:=Nullref\<rfloor>\<lfloor>flp:=Ref freeLST\<rfloor>
                                    h h1 (RVal r) p1)  
                     \<and>
                  (spectPredFill4TEMP 
                                  \<lparr>ienv = emptyi, renv = emptyr\<rparr>\<lfloor>self:=Ref freeLST\<rfloor>\<lfloor>param:=Ref ploc\<rfloor>\<lfloor>dummyPar:=Nullref\<rfloor>
                                   \<lfloor>flp:=Ref freeLST\<rfloor>\<lfloor>x:=r\<rfloor>
                                   <tag:=(heap.iheap h1) TAG ploc> 
                                   <v0:=(heap.iheap h1) V0 ploc>\<lfloor>v1:=(heap.rheap h1) V1 ploc\<rfloor>
                                   h1 hh v p2) \<and>
                  p = (renvMake3 \<oplus> p1 \<smile> p2))))"
declare spectPredMake3_def[simp]

(* Lennart:
axioms spectMake3[simp]:
           "Mspectable DIAMOND make3 == 
               {(E,h,hh,v,p) . \<forall> freeLST FL X i flopt fl pref sref. 
                 ((E\<lfloor>flp\<rfloor> = Ref freeLST \<and> (FL,freeLST,flopt,X,h) \<in> modelsStatic) \<and> E\<lfloor>PARmake\<rfloor> = Ref pref \<longrightarrow> 
                  (\<exists> X h1 p1 p2. 
                  (\<lparr>ienv = emptyi, renv = emptyr\<rparr>\<lfloor>self:=Ref freeLST\<rfloor>\<lfloor>param:=Ref pref\<rfloor>\<lfloor>dummyPar:=Nullref\<rfloor>\<lfloor>flp:=Ref freeLST\<rfloor>,h,h1,RVal X,p1) : 
                   Mspectable DIAMOND alloc \<and>
                  (\<lparr>ienv = emptyi, renv = emptyr\<rparr>\<lfloor>self:=Ref freeLST\<rfloor>\<lfloor>param:=Ref pref\<rfloor>\<lfloor>dummyPar:=Nullref\<rfloor>\<lfloor>flp:=Ref freeLST\<rfloor>\<lfloor>x:=X\<rfloor>
                    <tag:=(heap.iheap h1) TAG pref><v0:=(heap.iheap h1) V0 pref>\<lfloor>v1:=(heap.rheap h1) V1 pref\<rfloor>,h1,hh,v,p2) : spectable fill4TEMP \<and>
                  p = (renvMake3 \<oplus> p1 \<smile> p2)))}"
*)
(*****************************************************************)
axioms spectFf0:
           "spectable ff0 == 
               {(E,h,hh,v,p). 1=1}"

axioms spectFf1:
           "spectable ff1 == 
               {(E,h,hh,v,p) . 1 = 1}" 
axioms spectFclone3:
          "spectable fclone3 == 
               {(E,h,hh,v,p) .  1 = 1}" 

        
axioms spectClone:
           "Mspectable CLONELIST  clone ==  
              {(E,h,hh,v,p) . \<forall> loc X Ups rst Y m q loc' X' Ups'. 
                              (E\<lfloor>param\<rfloor> = Ref loc) \<longrightarrow>
                              (Ups, loc, X, h) \<in> LocLength \<longrightarrow> 
                              (E\<lfloor>flp \<rfloor> = rst ) \<longrightarrow>
                               (\<forall>  floc. rst = Ref floc  \<longrightarrow> floc \<notin> X) \<longrightarrow>
                               X \<inter> Y ={} \<longrightarrow>
                               (m, rst , Y, h) \<in> modelsStaticMH \<longrightarrow>
                               (0::nat) + 0 * Ups + q \<le> m  \<longrightarrow> 
                                (v = RVal (Ref loc')) \<longrightarrow> 
                                (Ups', loc', X', hh) \<in> LocLength \<longrightarrow> 
                                 (HSize h) = (HSize hh)  \<and> 
                                 (\<forall>  floc. rst = Ref floc  \<longrightarrow> floc \<notin> X') \<and> 
                                 (\<exists> m' Y'.  X' \<inter> Y'={} \<and> (m', rst , Y', hh) \<in> modelsStaticMH \<and> 
                                  (0::nat) + 0 * Ups' + q \<le> m')}"
              
(*****************************************************************) 

axioms alldistinct: "distinct[flp,freelist,t,node,x,v1,dummyPar,self, param, PARmake, 
                                  clonetempf0, clonetempf1, clonev1] \<and>
                         distinct[clonev1,  clonetempf1,  clonetempf0,
                                  PARmake, param,self,dummyPar,v1,x,node,t,freelist,flp] \<and>
                         distinct[b,tag,v0, cloneb, clonev2, clonezero, cloneone] 
                         \<and> distinct[cloneone, clonezero, clonev2, cloneb, v0,tag,b] \<and>
                         distinct[DollarF, DollarN, F1] \<and> distinct[F1,DollarN,DollarF] \<and>
                         distinct[Dollar, F0] \<and> distinct[F0,Dollar] \<and>
                         distinct[STATICFL, DIAMOND, CLONELIST] \<and> 
                         distinct[CLONELIST, DIAMOND, STATICFL] \<and>
                         distinct[make1, make3, free, alloc, clone] \<and>
                         distinct[clone, alloc, free, make3, make1] \<and>
                         distinct[fill2TEMP, fill4TEMP, allocQ, fclone, ff0, ff1] \<and>
                         distinct[ff1, ff0, fclone, allocQ, fill4TEMP, fill2TEMP]"
                         
axioms typing[simp] : "\<forall> E h l C . (qach_QaQ E h l flp C \<longrightarrow> C = DIAMOND)"

declare obj_ifieldupdate_def [simp]
declare obj_rfieldupdate_def [simp]
declare ivarupdate_def [simp]
declare rvarupdate_def [simp]
declare ienv_fct_def [simp]
declare renv_fct_def [simp]
declare newframe_env_def [simp]
declare emptyr_def [simp]

lemma vdm_adapt_context0: 
      " \<lbrakk>(InvokeStatic CLONELIST clone l, Q) : G ;  (insert (InvokeStatic CLONELIST clone l', subst Q l' l) G) \<rhd> e : P \<rbrakk> 
        \<Longrightarrow>
       G \<rhd> e : P"
sorry



lemma  vdm_callmh : 
"\<lbrakk>(G \<union> {(CALL f,{(E,h,hh,v,p) . \<exists> p'. tkcall p' = p \<and> (E, h, hh, v, p') : P})}) \<rhd> (funtable f) : P\<rbrakk> \<Longrightarrow>
           G \<rhd> (CALL f) : {(E,h,hh,v,p) . \<exists> p'. tkcall p' = p \<and> (E, h, hh, v, p') : P}"
sorry


(* Lemma to prove *)
lemma cloneAbstr:
"{(((InvokeStatic DIAMOND make1 PARmake)::nat expr),  {(E,h,hh,v,p). spectPredMake1 E h hh v p E\<lfloor>PARmake\<rfloor> }),
  (((InvokeStatic DIAMOND make3 PARmake)::nat expr),  {(E,h,hh,v,p). spectPredMake3 E h hh v p E\<lfloor>PARmake\<rfloor>}), 
  (((InvokeStatic DIAMOND  free param)::nat expr), {(E,h,hh,v,p). spectPredFree E h hh v p  E\<lfloor>param\<rfloor>})}
   \<rhd> ((InvokeStatic CLONELIST clone l):: nat expr) : (Mspectable CLONELIST clone)"
apply (rule vdm_invokestatic) 
apply (simp only: CLONE) apply (simp only: clbd)
apply (rule vdm_conseq) (* prefer 2 apply clarsimp prefer 2*)
apply (rule vdm_callmh)
apply (simp only: FCLONE) apply (simp only: fclbd) (* apply clarsimp *)
apply (rule vdm_leti) apply (rule vdm_getfi) (* prefer 2 apply clarsimp prefer 2*) 
apply (rule vdm_leti, rule vdm_prim) (* prefer 2 apply clarsimp prefer 2 *)
apply (rule vdm_if) (* prefer 3 apply clarsimp prefer 3 prefer 3 *)
apply (rule vdm_callmh) 
apply (simp only: FF0) apply (simp only: f0bd)
apply (rule vdm_letv) apply (rule vdm_ax) (* prefer 3 apply clarsimp prefer 3 prefer 3*)
apply (rule UnI1)+
apply (rule insertI2)
apply (rule insertI2)
apply (rule insertI1)
apply (rule vdm_leti, rule vdm_int) (* prefer 2 apply clarsimp prefer 2 *)
apply (rule vdm_letv, rule vdm_putfi) (* prefer 2 apply clarsimp prefer 2 *)
apply (rule vdm_letr) apply (rule vdm_ax) (* prefer 3 apply clarsimp prefer 3 prefer 3 *)
apply (rule UnI1)+
apply (rule insertI1)
apply (rule vdm_rvar) 
apply (rule vdm_callmh)
apply (simp only: FF1) apply (simp only: f1bd)
apply (rule vdm_leti, rule vdm_getfi) (* prefer 2 apply clarsimp prefer 2 *)
apply (rule vdm_letr, rule vdm_getfr) (* prefer 2 apply clarsimp prefer 2 *)
apply (rule vdm_letv) apply (rule vdm_ax) (* prefer 3 apply clarsimp prefer 3 prefer 3 *)
apply (rule UnI1)+
apply (rule insertI2)
apply (rule insertI2)
apply (rule insertI1)
apply (rule vdm_letr)
(* or change the instance of the adaptation rule *)
(* apply (clarsimp) *)
apply (rule vdm_adapt_context0) 
defer 1
apply (rule vdm_ax) (* prefer 3 apply clarsimp prefer 3 prefer 3*)
apply (rule insertI1)
apply (rule vdm_leti, rule vdm_int) (* prefer 2 apply clarsimp prefer 2 *)
apply (rule vdm_letv, rule vdm_putfi) (* prefer 2 apply clarsimp prefer 2 *)
apply (rule vdm_letv, rule vdm_putfi) (* prefer 2 apply clarsimp prefer 2 *)
apply (rule vdm_letv, rule vdm_putfr) (* prefer 2 apply clarsimp prefer 2 *)
apply (rule vdm_letr) apply (rule vdm_ax) (* prefer 3 apply clarsimp prefer 3 prefer 3*)
apply (rule UnI1)+
apply (rule insertI2)
apply (rule insertI1)
apply (rule vdm_rvar)
apply (simp only: spectClone)
defer 1
apply (simp only: spectClone)
apply (rule UnI1)
apply (rule UnI1)
apply (rule UnI2)
apply (rule insertI1)
(* apply (insert alldistinct) apply simp *)
(* VCs; 2 schematic vars left from weird adaptation rule ---------------------------- *)
apply (simp only: spectPredFree_def)
apply (simp only: spectPredMake1_def)
apply (simp only: spectPredMake3_def)
apply (simp only: spectPredAlloc_def)
apply (simp only: spectPredFill2TEMP_def)
apply (simp only: spectPredFill4TEMP_def)
apply clarsimp
(*
apply blast
apply fastsimp
apply fastsimp
apply best
*)
(*
apply force 
apply best
apply best
apply force
defer 1
apply force
apply force
apply (insert alldistinct) defer 1
apply (insert alldistinct) defer 1
apply (insert alldistinct) defer 1
apply (insert alldistinct) defer 1
apply auto
*)
apply best
apply best
apply clarsimp? apply (insert alldistinct) defer 1
apply clarsimp? apply (insert alldistinct) defer 1
apply clarsimp? apply (insert alldistinct) defer 1
apply clarsimp? apply (insert alldistinct) defer 1
apply clarsimp? apply (insert alldistinct) defer 1
apply clarsimp? apply (insert alldistinct) defer 1
apply (best intro!: ST_MH, intro!: FL_MHsomething, intro!: FL_MH_nothing)


(*

Mspectable CLONELIST clone
(InvokeStatic cn mn rn, Q) : G}
*)