
theory cloneVCG = DiamondListInt:

(* This specific part for a prticular program, in its turn, contains a subpart, 
common for all Isabelle presentation for Grail programs with DIAMOND*)
(* This subpart is about freelist management: alloc, make, fill, free *)

(* We consider the Grail image CloneList.gr of CloneList.cmlt *)

(* We do mot take into account intreface methods, with java.Lang.string,
 generated the compiler *)
(* We are interested in a method to which a camelot-function "clone"
is mapped *)
(*
CAMELOT 
type intlist = Nil | Cons of int*intlist
val clone: intlist -> intlist

let clone l = 
	match l with 
	   Nil@_ -> Nil
         | Cons(h, t)@_ -> Cons(h, clone t)

let start args  =
let l = clone  (Cons(2, Cons(1, Nil)))
in ()
   
   

GRAIL:
method static public CloneList$dia_0 clone (CloneList$dia_0 l) =
   let

      fun f:clone(CloneList$dia_0 l) =
      let
         val v2 = getfield l <int CloneList$dia_0.$>
      in
         if v2 = 0
         then f:0(l)
         else f:1(l)
      end

      fun f:1(CloneList$dia_0 l) =
      let
         val v2 = getfield l <int CloneList$dia_0.f0>
         val v1 = getfield l <CloneList$dia_0 CloneList$dia_0.f1>
         val () = invokestatic <void CloneList$dia_0.free (CloneList$dia_0)> (l)
         val l = invokestatic <CloneList$dia_0 CloneList.clone (CloneList$dia_0)> (v1)
      in
         invokestatic <CloneList$dia_0 CloneList$dia_0.make (int, int, CloneList$dia_0)> (1, v2, l)
      end

      fun f:0(CloneList$dia_0 l) =
      let
         val () = invokestatic <void CloneList$dia_0.free (CloneList$dia_0)> (l)
      in
         invokestatic <CloneList$dia_0 CloneList$dia_0.make (int)> (0)
      end
   in
      f:clone(l)
   end

*)

(* make1 - "make" of arity 1 *)
(* make3 - "make" of arity 3 *) 
(* fill2 - "fill" of arity 2 *)
(* fill4 - "fill" of arity 4 *)

(* fill2 has 2 parameters so can't be a method. But fortunately fill2 
is invoked using the Grail convention. 
So we model it as a function. Same applies to fill4 *)


(* for modelling the arguments to make1 and make3 *)
(* a parameter "param" has 3 fields, - TAG, V0, V1 *)
(* the content of these fields will be assigned to vars tag, v0, v1 *)
(* these vars will be processed by a "function call" of fill1/fill3 *)

constdefs XOR :: "bool \<Rightarrow> bool \<Rightarrow> bool"
"XOR P Q \<equiv> ( P \<or> Q) \<and> \<not> (P \<and> Q)"
declare XOR_def[simp]

lemma vdm_adapt_context: 
      "\<lbrakk> {(InvokeStatic cn mn rn', subst Q rn' rn), (e1, P1), (e2, P2), (e3, P3), (e4, P4), (e5, P5)} \<rhd> e : P \<rbrakk> 
        \<Longrightarrow>
       {(e1, P1), (e2, P2), (InvokeStatic cn mn rn, Q), (e3, P3), (e4, P4), (e5, P5)}\<rhd> e : P"
sorry


consts TAG :: ifldname
       V0 :: ifldname
       V1 :: rfldname


locale DiamondClone = 
fixes
     (* freelist management: for conversion of CloneList$dia.gr *) 
     alloc :: mname and free :: mname and make1 :: mname and make3 :: mname and 
     (* *)
     allocQ :: funame and fill2TEMP :: funame and fill4TEMP :: funame and
     (* tag, v0 are int parameters, for "fill", "make" *)
     b :: iname and tag :: iname and v0 :: iname and
     (* flp is a static pointer to a freelist *)
     flp ::rname and freelist :: rname and t :: rname and
     (* node, x, v1 are ref parameters, for "free", "fill", "make" *) 
     node :: rname and x :: rname and v1 :: rname and 
     (* to model 0-param. "alloc", and multiparam. "fill", "make" *)
     dummyPar :: rname and PARmake::rname and
     (* bodies *)
     allocBODY::"nat expr" and allocQBODY::"nat expr" and freeBODY::"nat expr" and
     fill2BODY::"nat expr" and fill4BODY::"nat expr" and make1BODY::"nat expr" and make3BODY::"nat expr" and
     
     (* specific part: for conversion of CloneList.gr *)
     CLONELIST :: cname and 
     clone :: mname and fclone :: funame and ff0 :: funame and ff1 :: funame and 
     cloneBODY :: "nat expr" and fcloneBODY  ::"nat expr"  and ff0BODY  ::"nat expr"  and ff1BODY  ::"nat expr" 
     and cloneb :: iname and clonetempf0 :: rname and clonetempf1 :: rname and
     clonev1 :: rname and clonev2 :: iname and clonezero :: iname and  cloneone :: iname and
     (* *)
     myContext :: "nat vdmcontext" and 
     (* *)
     renvQ :: renv and renvAllocNone :: renv and renvAllocSome :: renv and renvFree :: renv and 
     renvFill2 :: renv and renvFill4 :: renv and renvMake1 :: renv and renvMake3 :: renv
     (* ??? Env-s for specific part ???? *)
     defines "renvQ == \<langle>8 1 0 0\<rangle>"
       and "renvAllocNone == \<langle>15 0 1 1\<rangle>"
       and "renvAllocSome == \<langle>18 2 0 0\<rangle>"
       and "renvFree == \<langle>14 0 1 1\<rangle>"
       and "renvFill2 == \<langle>5 1 0 0\<rangle>"
       and "renvFill4 == \<langle>11 1 0 0\<rangle>"
       and "renvMake1 == \<langle>13 0 1 1\<rangle>"
       and "renvMake3 == \<langle>19 0 1 1\<rangle>"
    (* ??? Env-s for specific part ???? *)

(* method and function BODies *)
       and frbd[simp]: "freeBODY == (LET rf freelist = GetFr flp DollarF;
                                       _ = PutFr node DollarN freelist
                                     IN PutFr flp DollarF node
                                    END)::nat expr"
       and alcbd[simp]: "allocBODY == (LET rf freelist = GetFr flp DollarF; 
                                       b = RPrimop (% r1 r2 . if r1 = Nullref then 1 else 0) freelist freelist
                                       IN IF b THEN (NEW <DIAMOND> ([],[])) ELSE CALL allocQ 
                                       END)::nat expr"
       and alcqbd[simp]: "allocQBODY == (LET rf t = GetFr freelist DollarN;
                                                _ = PutFr flp DollarF t
                                         IN RVar freelist 
                                         END)::nat expr"
       and fl2bd[simp]: "fill2BODY == (LET _ = PutFi x Dollar tag IN RVar x END)::nat expr"
       and fl4bd[simp]: "fill4BODY == (LET _ = PutFi x Dollar tag;
                                           _ = PutFi x F0 v0;
                                           _ = PutFr x F1 v1
                                       IN RVar x END)::nat expr"
      and mk1bd[simp]: "make1BODY == ( LET rf dummyPar = Null;
                                           rf x = InvokeStatic DIAMOND alloc dummyPar;
                                            tag = GetFi param TAG
                                       IN CALL fill2TEMP END)::nat expr" 
       and  mk3bd[simp]:"make3BODY == (LET rf dummyPar = Null;
                                          rf x = InvokeStatic DIAMOND alloc dummyPar;
                                             tag = GetFi param TAG;
                                             v0 = GetFi param V0;
                                          rf v1 = GetFr param V1
                                     IN CALL fill4TEMP END)::nat expr"  
    and fclbd[simp]:"fcloneBODY == (LET clonev2 = GetFi param Dollar;
                         cloneb = Primop (% l1 l2. if l1 =0 then 1 else 0) clonev2 clonev2 
                         IN IF cloneb THEN CALL ff0 ELSE CALL ff1
                         END) :: nat expr"
    and f1bd[simp]:"ff1BODY == (LET    clonev2 = GetFi param F0;
                        rf  clonev1 = GetFr param F1;
                                 _  = InvokeStatic DIAMOND free param;
                        rf    param =  InvokeStatic CLONELIST clone clonev1;
                           cloneone = expr.Int 1;
                           _   = PutFi PARmake TAG cloneone;
                           _   = PutFi PARmake V0  clonev2; 
                           _   = PutFr PARmake V1  param;
                        rf clonetempf0 = InvokeStatic DIAMOND make3 PARmake
                    IN RVar clonetempf0
                    END) :: nat expr"
   and f0bd[simp]:"ff0BODY == ( LET _  = InvokeStatic DIAMOND free param;
                                   clonezero = expr.Int 0;
                                   _   = PutFi PARmake TAG clonezero;
                                  rf clonetempf1 = InvokeStatic DIAMOND make1 PARmake
                     IN RVar clonetempf1 
                     END) :: nat expr"
   and clbd[simp]: "cloneBODY == ( CALL fclone ) :: nat expr"

   and "myContext == {((InvokeStatic DIAMOND  alloc dummyPar)::nat expr, Mspectable DIAMOND alloc), 
                      ((InvokeStatic DIAMOND free param)::nat expr,  Mspectable DIAMOND free), 
                      ((InvokeStatic DIAMOND make1 PARmake)::nat expr, Mspectable DIAMOND make1), 
                      ((InvokeStatic DIAMOND make3 PARmake)::nat expr, Mspectable DIAMOND make3), 
                      ((Call allocQ)::nat expr, spectable allocQ), 
                      ((Call fill2TEMP)::nat expr, spectable fill2TEMP), 
                      ((Call fill4TEMP)::nat expr, spectable fill4TEMP),
                      ((Call fclone)::nat expr, spectable fclone),
                      ((Call ff0)::nat expr, spectable ff0),
                      ((Call ff1)::nat expr, spectable ff1),
                      ((InvokeStatic CLONELIST clone param)::nat expr, Mspectable CLONELIST clone)}"
                           
                         
 assumes FREE[simp]: "methtable DIAMOND free == freeBODY" 
       and ALLOC[simp]: "methtable DIAMOND alloc == allocBODY" 
       and ALLOCQ[simp]: "funtable allocQ == allocQBODY"
       and FILL2TEMP[simp]: "funtable fill2TEMP == fill2BODY" 
       and FILL4TEMP[simp]: "funtable fill4TEMP == fill4BODY" 
       and MAKE1[simp]: "methtable DIAMOND make1 == make1BODY" 
       and MAKE3[simp]: "methtable DIAMOND make3 == make3BODY"
 (*****************************************************************) 
       and FCLONE[simp]: "funtable fclone == fcloneBODY"
       and FF0[simp]: "funtable ff0 == ff0BODY"
       and FF1[simp]: "funtable ff1 == ff1BODY"
       and CLONE[simp]: "methtable CLONELIST clone == cloneBODY"

       and spectFill2TEMP:
           "spectable fill2TEMP == 
            {(E,h,hh,v,p) . \<forall> l i .
               ((E\<lfloor>x\<rfloor> = Ref l \<and> E<tag> = i) 
               \<longrightarrow> (v = RVal (Ref l) \<and> p = renvFill2 \<and> hh = h<l\<bullet>Dollar:=i>))}" 
       and spectFill4TEMP:
           "spectable fill4TEMP == 
            {(E,h,hh,v,p) . \<forall> l i V1 V0.
               ((E\<lfloor>x\<rfloor> = Ref l \<and> E<tag> = i \<and> E\<lfloor>v1\<rfloor> = V1 \<and> E<v0> = V0) 
               \<longrightarrow> (v = RVal (Ref l) \<and> p = renvFill4 \<and> hh = h<l\<bullet>Dollar:=i><l\<bullet>F0:=V0>\<lfloor>l\<diamondsuit>F1:=V1\<rfloor>))}"
       and spectFree:
           "Mspectable DIAMOND free == 
            {(E,h,hh,v,p) . \<forall> freeLST FL X n d f0 f1 flopt l fl nn. 
               ((E\<lfloor>flp\<rfloor> = Ref freeLST \<and> (FL,freeLST,flopt,X,h) \<in> modelsStatic \<and> 
                 E\<lfloor>node\<rfloor> = Ref l \<and> (n,d,f0,f1,l,h) : modelsDIAMOND \<and> l \<notin> X)
               \<longrightarrow> (v = arbitrary \<and> p = renvFree \<and> hh = h\<lfloor>l\<diamondsuit>DollarN := h\<lfloor>freeLST\<diamondsuit>DollarF\<rfloor>\<rfloor>\<lfloor>freeLST\<diamondsuit>DollarF := Ref l\<rfloor> \<and> 
                     ((flopt = None \<longrightarrow> (0,freeLST,Some l,{l},hh) : modelsStatic) \<and> 
                      (flopt = Some fl \<longrightarrow> (Suc FL,freeLST,Some l, X \<union> {l},hh) : modelsStatic))))}"
       and spectAllocQ:
           "spectable allocQ == {(E,h,hh,v,p) . \<forall> freeLST FL X i flopt fl. 
               ((E\<lfloor>flp\<rfloor> = Ref freeLST \<and> (FL,freeLST,flopt,X,h) \<in> modelsStatic \<and> 
                 (flopt = Some fl) \<and> E\<lfloor>freelist\<rfloor> = h\<lfloor>freeLST\<diamondsuit>DollarF\<rfloor>)
                \<longrightarrow> ( v = RVal (Ref fl) \<and> p = renvQ \<and> (FL, fl,X,h) \<in> modelsFreelist \<and> 
                      (\<exists> n d f0 f1. (n,d,f0,f1,fl,h) \<in> modelsDIAMOND \<and> fl \<in> X \<and> 
                         hh = \<lparr>oheap = oheap h, iheap = iheap h, 
                               rheap = (rheap h)(DollarF := (rheap h DollarF)(freeLST := h\<lfloor>fl\<diamondsuit>DollarN\<rfloor>))\<rparr> \<and> 
                         (((n = Nullref) \<longrightarrow> (0,freeLST,None,{},hh) : modelsStatic) \<and>
                                               (\<forall> nn . n = Ref nn \<longrightarrow> (\<exists> i . FL = Suc i \<and> nn \<in> X - {fl} \<and> 
                                                                             (i,nn, X - {fl}, h) : modelsFreelist \<and>
                                                                             (i,freeLST,Some nn,X - {fl},hh) : modelsStatic))))))}"
       and spectAlloc:
           "Mspectable DIAMOND alloc == 
            {(E,h,hh,v,p) . \<forall> freeLST FL X i flopt fl. 
               ((E\<lfloor>flp\<rfloor> = Ref freeLST \<and> (FL,freeLST,flopt,X,h) \<in> modelsStatic) \<longrightarrow> 
                   (((flopt = None) \<longrightarrow> (\<exists> r . (0,freeLST,None,X,hh) \<in> modelsStatic \<and> v = RVal (Ref r) \<and> 
                                                 r \<notin> fmap_dom (oheap h) \<and> hh = newObj h r E DIAMOND [] [] \<and> p = renvAllocNone)) \<and> 
                    ((flopt = Some fl) \<longrightarrow> ( v = RVal (Ref fl) \<and> p = renvAllocSome \<and> (FL, fl,X,h) \<in> modelsFreelist \<and> 
                                             (\<exists> n d f0 f1. (n,d,f0,f1,fl,h) \<in> modelsDIAMOND \<and> fl \<in> X \<and> 
                                               hh = \<lparr>oheap = oheap h, iheap = iheap h, 
                                                     rheap = (rheap h)(DollarF := (rheap h DollarF)(freeLST := h\<lfloor>fl\<diamondsuit>DollarN\<rfloor>))\<rparr> \<and> 
                                               (((n = Nullref) \<longrightarrow> (0,freeLST,None,{},hh) : modelsStatic) \<and>
                                                 (\<forall> nn . n = Ref nn \<longrightarrow> (\<exists> i . FL = Suc i \<and> nn \<in> X - {fl} \<and>
                                                                          (i,nn, X - {fl}, h) : modelsFreelist \<and>
                                                                          (i,freeLST,Some nn,X - {fl},hh) : modelsStatic))))))))}" 
       and spectMake1:
           "Mspectable DIAMOND make1 == 
               {(E,h,hh,v,p) . \<forall> freeLST FL X i flopt fl pref sref. 
                 ((E\<lfloor>flp\<rfloor> = Ref freeLST \<and> (FL,freeLST,flopt,X,h) \<in> modelsStatic) \<and> E\<lfloor>PARmake\<rfloor> = Ref pref \<longrightarrow> 
                  (\<exists> X h1 p1 p2. 
                  (\<lparr>ienv = emptyi, renv = emptyr\<rparr>\<lfloor>self:=Ref freeLST\<rfloor>\<lfloor>param:=Ref pref\<rfloor>\<lfloor>dummyPar:=Nullref\<rfloor>\<lfloor>flp:=Ref freeLST\<rfloor>,h,h1,RVal X,p1) : 
                    Mspectable DIAMOND alloc \<and>
                  (\<lparr>ienv = emptyi, renv = emptyr\<rparr>\<lfloor>self:=Ref freeLST\<rfloor>\<lfloor>param:=Ref pref\<rfloor>\<lfloor>dummyPar:=Nullref\<rfloor>\<lfloor>flp:=Ref freeLST\<rfloor>\<lfloor>x:=X\<rfloor>
                   <tag:=(heap.iheap h1) TAG pref>,h1,hh,v,p2) : spectable fill2TEMP \<and>
                  p = (renvMake1 \<oplus> p1 \<smile> p2)))}"
       and spectMake3:
           "Mspectable DIAMOND make3 == 
               {(E,h,hh,v,p) . \<forall> freeLST FL X i flopt fl pref sref. 
                 ((E\<lfloor>flp\<rfloor> = Ref freeLST \<and> (FL,freeLST,flopt,X,h) \<in> modelsStatic) \<and> E\<lfloor>PARmake\<rfloor> = Ref pref \<longrightarrow> 
                  (\<exists> X h1 p1 p2. 
                  (\<lparr>ienv = emptyi, renv = emptyr\<rparr>\<lfloor>self:=Ref freeLST\<rfloor>\<lfloor>param:=Ref pref\<rfloor>\<lfloor>dummyPar:=Nullref\<rfloor>\<lfloor>flp:=Ref freeLST\<rfloor>,h,h1,RVal X,p1) : 
                   Mspectable DIAMOND alloc \<and>
                  (\<lparr>ienv = emptyi, renv = emptyr\<rparr>\<lfloor>self:=Ref freeLST\<rfloor>\<lfloor>param:=Ref pref\<rfloor>\<lfloor>dummyPar:=Nullref\<rfloor>\<lfloor>flp:=Ref freeLST\<rfloor>\<lfloor>x:=X\<rfloor>
                    <tag:=(heap.iheap h1) TAG pref><v0:=(heap.iheap h1) V0 pref>\<lfloor>v1:=(heap.rheap h1) V1 pref\<rfloor>,h1,hh,v,p2) : spectable fill4TEMP \<and>
                  p = (renvMake3 \<oplus> p1 \<smile> p2)))}"
(*****************************************************************)
and spectFf0:
           "spectable ff0 == 
               {(E,h,hh,v,p). 1=1}"

and spectFf1:
           "spectable ff1 == 
               {(E,h,hh,v,p) . 1 = 1}" 
and spectFclone3:
          "spectable fclone3 == 
               {(E,h,hh,v,p) . 1 = 1}" 

        
and spectClone:
           "Mspectable CLONELIST  clone == 
               {(E,h,hh,v,p) . \<forall> lloc X Ups flloc m q llocRet XRet UpsRet. 
                              (E\<lfloor>param\<rfloor> = Ref lloc) \<longrightarrow>
                              (Ups, lloc, X, h) \<in> LocLength \<longrightarrow> 
                              (E\<lfloor>flp \<rfloor> = Ref flloc) \<longrightarrow>
                               flloc \<notin> X  \<longrightarrow> flloc \<notin> XRet \<longrightarrow>
                               ( XOR ((0, flloc, None, {}, h) \<in> modelsStatic  \<and> m=0)
                                 (\<exists> fl Y. 0 < m \<and> (Card Y = m) \<and> X \<inter> Y = {} \<and> (m, flloc, Some fl, Y, h) \<in> modelsStatic)) 
                                \<longrightarrow> (0::nat) + 0 * Ups + q \<le> m  \<longrightarrow> 
                                (v = RVal (Ref llocRet)) \<longrightarrow> 
                                (UpsRet, llocRet, XRet, hh) \<in> LocLength \<longrightarrow> 
                                 (HSize h) = (HSize hh)  \<and> 
                                 (\<exists> mRet.
                                  (XOR ((0, flloc, None, {}, hh) \<in> modelsStatic  \<and> mRet=0)
                                   (\<exists> fl Y. 0 < mRet \<and> (Card Y = mRet) \<and> XRet \<inter> YRet = {} 
                                        \<and> (mRet, flloc, Some fl, YRet, hh) \<in> modelsStatic))
                                     \<and> 
                                   (0::nat) + 0 * UpsRet + q \<le> mRet) }"
                                   

(*****************************************************************) 

       and alldistinct: "distinct[flp,freelist,t,node,x,v1,dummyPar,self, param, PARmake, 
                                  clonetempf0, clonetempf1, clonev1] \<and>
                         distinct[clonev1,  clonetempf1,  clonetempf0,
                                  PARmake, param,self,dummyPar,v1,x,node,t,freelist,flp] \<and>
                         distinct[b,tag,v0, cloneb, clonev2, clonezero, cloneone] 
                         \<and> distinct[cloneone, clonezero, clonev2, cloneb, v0,tag,b] \<and>
                         distinct[DollarF, DollarN, F1] \<and> distinct[F1,DollarN,DollarF] \<and>
                         distinct[Dollar, F0] \<and> distinct[F0,Dollar] \<and>
                         distinct[STATICFL, DIAMOND, CLONELIST] \<and> 
                         distinct[CLONELIST, DIAMOND, STATICFL] \<and>
                         distinct[make1, make3, free, alloc, clone] \<and>
                         distinct[clone, alloc, free, make3, make1] \<and>
                         distinct[fill2TEMP, fill4TEMP, allocQ, fclone, ff0, ff1] \<and>
                         distinct[ff1, ff0, fclone, allocQ, fill4TEMP, fill2TEMP]"
                         
       and typing[simp] : "\<forall> E h l C . (qach_QaQ E h l flp C \<longrightarrow> C = DIAMOND)"

declare obj_ifieldupdate_def [simp]
declare obj_rfieldupdate_def [simp]
declare ivarupdate_def [simp]
declare rvarupdate_def [simp]
declare ienv_fct_def [simp]
declare renv_fct_def [simp]
declare newframe_env_def [simp]
declare emptyr_def [simp]

(* Some cheating *)
lemma (in DiamondClone) allocSpec:"\<rhd> ((InvokeStatic DIAMOND  alloc dummyPar)::nat expr) : (Mspectable DIAMOND alloc)"
sorry

(*
constdefs pentAlloc :: "(env \<times> heap \<times> heap \<times> val \<times>  renv) set"
"pentAlloc \<equiv>  {(E, h, hh, v, p). \<forall> flloc.  E\<lfloor>flp \<rfloor> = Ref flloc \<longrightarrow>
                                (XOR ((0, flloc, None, {}, h) \<in> modelsStatic)
                                 (\<exists> fl n X. 0 < n \<and> ((Card X) = n) \<and> (n, flloc, Some fl, X, h) \<in> modelsStatic))                                                    \<and> 
                               ((0, flloc, None, {}, h) \<in> modelsStatic \<longrightarrow>  
                                 (Hsize hh = (Hsize h) + (1::nat)) \<and> 
                                 (0, flloc, None, {}, hh) \<in> modelsStatic)  \<and>
                               (((\<exists> fl n X. 0 < n \<and> ((Card X) = n) \<and> (n, flloc, Some fl, X, h) \<in> modelsStatic)
                                 \<longrightarrow>  (Hsize hh  = Hsize h ) \<and>                                 
                                 ((n=(1::nat)\<longrightarrow> (0, flloc, None, {}, hh) \<in> modelsStatic)) \<and> 
                                 ((1:: nat)< n \<longrightarrow> 
                                 (\<exists> fll XX nn. nn+1=n \<and> (Card XX) = nn \<and> (nn, flloc, Some fll, XX, hh) \<in> modelsStatic))))}"
declare pentAlloc_def[simp]
*)

lemma (in DiamondClone) allocAbstr:"\<rhd> ((InvokeStatic DIAMOND  alloc dummyPar)::nat expr) : 
{(E, h, hh, v, p). \<forall> flloc.  E\<lfloor>flp \<rfloor> = Ref flloc \<longrightarrow>
                                (XOR ((0, flloc, None, {}, h) \<in> modelsStatic)
                                 (\<exists> fl n X. 0 < n \<and> (Card X = n) \<and> (n, flloc, Some fl, X, h) \<in> modelsStatic))                                                    \<and> 
                               ((0, flloc, None, {}, h) \<in> modelsStatic \<longrightarrow>  
                                 (Hsize hh = (Hsize h) + (1::nat)) \<and> 
                                 (0, flloc, None, {}, hh) \<in> modelsStatic)  \<and>
                               (((\<exists> fl n X. 0 < n \<and> (Card X = n) \<and> (n, flloc, Some fl, X, h) \<in> modelsStatic)
                                 \<longrightarrow>  (Hsize hh  = Hsize h ) \<and>                                 
                                 ((n=(1::nat)\<longrightarrow> (0, flloc, None, {}, hh) \<in> modelsStatic)) \<and> 
                                 ((1:: nat)< n \<longrightarrow> 
                                 (\<exists> fll XX nn. nn+1=n \<and> (Card XX) = nn \<and> (nn, flloc, Some fll, XX, hh) \<in> modelsStatic))))}"
sorry

lemma (in DiamondClone) make1Abstr:"\<rhd> ((InvokeStatic DIAMOND  make1 PARmake)::nat expr) : 
{(E, h, hh, v, p). \<forall> flloc.  E\<lfloor>flp \<rfloor> = Ref flloc \<longrightarrow>
                                (XOR ((0, flloc, None, {}, h) \<in> modelsStatic)
                                 (\<exists> fl n X. 0 < n \<and> (Card X = n) \<and> (n, flloc, Some fl, X, h) \<in> modelsStatic))                                                    \<and> 
                               ((0, flloc, None, {}, h) \<in> modelsStatic \<longrightarrow>  
                                 (Hsize hh = (Hsize h) + (1::nat)) \<and> 
                                 (0, flloc, None, {}, hh) \<in> modelsStatic)  \<and>
                               (((\<exists> fl n X. 0 < n \<and> (Card X = n) \<and> (n, flloc, Some fl, X, h) \<in> modelsStatic)
                                 \<longrightarrow>  (Hsize hh  = Hsize h ) \<and>                                 
                                 ((n=(1::nat)\<longrightarrow> (0, flloc, None, {}, hh) \<in> modelsStatic)) \<and> 
                                 ((1:: nat)< n \<longrightarrow> 
                                 (\<exists> fll XX nn. nn+1=n \<and> (Card XX) = nn \<and> (nn, flloc, Some fll, XX, hh) \<in> modelsStatic))))}"
sorry


lemma (in DiamondClone) make3Abstr:"\<rhd> ((InvokeStatic DIAMOND  make3 PARmake)::nat expr) : 
{(E, h, hh, v, p). \<forall> flloc. E\<lfloor>flp \<rfloor> = Ref flloc \<longrightarrow>
                                (XOR ((0, flloc, None, {}, h) \<in> modelsStatic)
                                 (\<exists> fl n X. 0 < n \<and> (Card X = n) \<and> (n, flloc, Some fl, X, h) \<in> modelsStatic))                                                    \<and> 
                               ((0, flloc, None, {}, h) \<in> modelsStatic \<longrightarrow>  
                                 (Hsize hh = (Hsize h) + (1::nat)) \<and> 
                                 (0, flloc, None, {}, hh) \<in> modelsStatic)  \<and>
                               (((\<exists> fl n X. 0 < n \<and> (Card X = n) \<and> (n, flloc, Some fl, X, h) \<in> modelsStatic)
                                 \<longrightarrow>  (Hsize hh  = Hsize h ) \<and>                                 
                                 ((n=(1::nat)\<longrightarrow> (0, flloc, None, {}, hh) \<in> modelsStatic)) \<and> 
                                 ((1:: nat)< n \<longrightarrow> 
                                 (\<exists> fll XX nn. nn+1=n \<and> (Card XX) = nn \<and> (nn, flloc, Some fll, XX, hh) \<in> modelsStatic))))}"
sorry


lemma (in DiamondClone) freeSpec:"\<rhd> ((InvokeStatic DIAMOND  free param)::nat expr) : (Mspectable DIAMOND free)"
sorry

lemma (in DiamondClone) freeAbstr:"\<rhd> ((InvokeStatic DIAMOND  free param)::nat expr) : 
{(E, h, hh, v, p). \<forall> flloc.  E\<lfloor>flp \<rfloor> = Ref flloc \<longrightarrow>
                                ( XOR ((0, flloc, None, {}, h) \<in> modelsStatic) 
                                 (\<exists> fl n X. 0 < n \<and> (Card X = n) \<and> (n, flloc, Some fl, X, h) \<in> modelsStatic)) \<and>                                                      ((0, flloc, None, {}, h) \<in> modelsStatic \<longrightarrow> 
                                (\<exists> fll XX. (Card XX) = (1::nat) \<and> ((1::nat), flloc, Some fll, XX, hh) \<in> modelsStatic))
                                \<and> 
                               ((\<exists> fl n X. 0 < n \<and> (Card X = n) \<and> (n, flloc, Some fl, X, h) \<in> modelsStatic)
                                \<longrightarrow> 
                               (\<exists> fll XX nn. nn= n + (1::nat) \<and> (Card XX) = nn \<and> (nn, flloc, Some fll, XX, hh) \<in> modelsStatic))}"
sorry



(* Lemma to prove *)
lemma (in DiamondClone) cloneAbstr:
"{(((InvokeStatic DIAMOND make1 PARmake)::nat expr), 
{(E, h, hh, v, p). \<forall> flloc. E\<lfloor>flp \<rfloor> = Ref flloc \<longrightarrow>
                                (XOR ((0, flloc, None, {}, h) \<in> modelsStatic)
                                 (\<exists> fl n X. 0 < n \<and> (Card X = n) \<and> (n, flloc, Some fl, X, h) \<in> modelsStatic))                                                    \<and> 
                               ((0, flloc, None, {}, h) \<in> modelsStatic \<longrightarrow>  
                                 (Hsize hh = (Hsize h) + (1::nat)) \<and> 
                                 (0, flloc, None, {}, hh) \<in> modelsStatic)  \<and>
                               (((\<exists> fl n X. 0 < n \<and> (Card X = n) \<and> (n, flloc, Some fl, X, h) \<in> modelsStatic)
                                 \<longrightarrow>  (Hsize hh  = Hsize h ) \<and>                                 
                                 ((n=(1::nat)\<longrightarrow> (0, flloc, None, {}, hh) \<in> modelsStatic)) \<and> 
                                 ((1:: nat)< n \<longrightarrow> 
                                 (\<exists> fll XX nn. nn+1=n \<and> (Card XX) = nn \<and> (nn, flloc, Some fll, XX, hh) \<in> modelsStatic)))) }),
(((InvokeStatic DIAMOND  make3 PARmake)::nat expr), 
{(E, h, hh, v, p). \<forall> flloc. E\<lfloor>flp \<rfloor> = Ref flloc \<longrightarrow>
                                (XOR ((0, flloc, None, {}, h) \<in> modelsStatic)
                                 (\<exists> fl n X. 0 < n \<and> (Card X = n) \<and> (n, flloc, Some fl, X, h) \<in> modelsStatic))                                                    \<and> 
                               ((0, flloc, None, {}, h) \<in> modelsStatic \<longrightarrow>  
                                 (Hsize hh = (Hsize h) + (1::nat)) \<and> 
                                 (0, flloc, None, {}, hh) \<in> modelsStatic)  \<and>
                               (((\<exists> fl n X. 0 < n \<and> (Card X = n) \<and> (n, flloc, Some fl, X, h) \<in> modelsStatic)
                                 \<longrightarrow>  (Hsize hh  = Hsize h ) \<and>                                 
                                 ((n=(1::nat)\<longrightarrow> (0, flloc, None, {}, hh) \<in> modelsStatic)) \<and> 
                                 ((1:: nat)< n \<longrightarrow> 
                                 (\<exists> fll XX nn. nn+1=n \<and> (Card XX) = nn \<and> (nn, flloc, Some fll, XX, hh) \<in> modelsStatic)))) }),
(((InvokeStatic DIAMOND  free param)::nat expr),
{(E, h, hh, v, p). \<forall> flloc. E\<lfloor>flp \<rfloor> = Ref flloc \<longrightarrow>
                                ( XOR ((0, flloc, None, {}, h) \<in> modelsStatic) 
                                 (\<exists> fl n X. 0 < n \<and> (Card X = n) \<and> (n, flloc, Some fl, X, h) \<in> modelsStatic)) \<and>                                                    ((0, flloc, None, {}, h) \<in> modelsStatic \<longrightarrow> 
                                (\<exists> fll XX. (Card XX) = (1::nat) \<and> ((1::nat), flloc, Some fll, XX, hh) \<in> modelsStatic))
                                \<and> 
                               ((\<exists> fl n X. 0 < n \<and> (Card X = n) \<and> (n, flloc, Some fl, X, h) \<in> modelsStatic)
                                \<longrightarrow> 
                               (\<exists> fll XX nn. nn= n + (1::nat) \<and> (Card XX) = nn \<and> (nn, flloc, Some fll, XX, hh) \<in> modelsStatic)) })}
\<rhd> ((InvokeStatic CLONELIST clone l):: nat expr) : (Mspectable CLONELIST clone)"
apply (rule vdm_invokestatic) 
(* apply (insert alldistinct) *)
apply auto
apply (rule vdm_conseq) prefer 2 apply clarsimp prefer 2
apply (rule vdm_call, clarsimp, rule vdm_conseq)
apply (rule vdm_leti) apply (rule vdm_getfi) prefer 2 apply clarsimp prefer 2
apply (rule vdm_leti, rule vdm_prim) prefer 2 apply clarsimp prefer 2
apply (rule vdm_if) prefer 3 apply clarsimp prefer 3 prefer 3
apply (rule vdm_call, clarsimp, rule vdm_conseq)
apply (rule vdm_letv) apply (rule vdm_ax) prefer 3 apply clarsimp prefer 3 prefer 3
defer 1
apply (rule vdm_leti, rule vdm_int) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv, rule vdm_putfi) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr) apply (rule vdm_ax)prefer 3 apply clarsimp prefer 3 prefer 3
defer 1
apply (rule vdm_rvar) defer 1
apply (rule vdm_call, clarsimp, rule vdm_conseq)
apply (rule vdm_leti, rule vdm_getfi) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr, rule vdm_getfr) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv) apply (rule vdm_ax) prefer 3 apply clarsimp prefer 3 prefer 3
defer 1
apply (rule vdm_letr) 
apply (rule vdm_adapt_context) apply (rule vdm_ax)prefer 3 apply clarsimp prefer 3 prefer 3
defer 1
apply (rule vdm_leti, rule vdm_int) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv, rule vdm_putfi) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv, rule vdm_putfi) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letv, rule vdm_putfr) prefer 2 apply clarsimp prefer 2
apply (rule vdm_letr) apply (rule vdm_ax) prefer 3 apply clarsimp prefer 3 prefer 3 
defer 1
apply (rule vdm_rvar)
apply (insert alldistinct)
apply clarsimp?
defer 1
apply (insert alldistinct)
apply clarsimp?
defer 1
apply (insert alldistinct)
apply clarsimp?
defer 1
apply (insert alldistinct)
apply clarsimp?
defer 1
apply (insert alldistinct)
apply clarsimp?
defer 1
apply (insert alldistinct)
apply clarsimp?
defer 1
apply (insert alldistinct)
apply clarsimp?
defer 1
apply (insert alldistinct)
apply clarsimp?
defer 1
apply (insert alldistinct)
apply clarsimp?
defer 1
apply auto

end
