theory cloneLocals5 = DiaListInt3:

(**************** Add to general VDM-files !**************************************************)

lemma  vdm_callmh : 
"\<lbrakk>(G \<union> {(CALL f,{(E,h,hh,v,p) . \<exists> p'. tkcall p' = p \<and> (E, h, hh, v, p') : P})}) \<rhd> (funtable f) : P\<rbrakk> \<Longrightarrow>
           G \<rhd> (CALL f) : {(E,h,hh,v,p) . \<exists> p'. tkcall p' = p \<and> (E, h, hh, v, p') : P}"
sorry

(*********** questionnable: new "pure backward" rules \<dots>\<dots> *****************************************)

lemma letv_putfi_vdm:"\<lbrakk>G \<rhd> e : {(E,h,hh,v,p) . \<forall> h' loc. 
                                             (E\<lfloor>x\<rfloor> =Ref loc \<longrightarrow> h= h'<loc\<bullet>f:=E<y>>\<longrightarrow> (E,h',hh,v, \<langle>3 0 0 0\<rangle>\<smile>p)\<in> P)}\<rbrakk>
 \<Longrightarrow>  G \<rhd> (Letv (Putfi x f y) e ): P" 
sorry



lemma rvar_vdm:"\<lbrakk>P \<subseteq> {(E,h,hh,v,p) .h=hh \<and> v=(RVal E\<lfloor>x\<rfloor>) \<and> p=\<langle>1 0 0 0\<rangle>}\<rbrakk> \<Longrightarrow>  G \<rhd> RVar x : P" 
sorry




(**********************************************************************************************)

(* This specific part for a prticular program, in its turn, contains a subpart, 
common for all Isabelle presentation for Grail programs with DIAMOND*)
(* This subpart is about freelist management: alloc, make, fill, free *)

(* We consider the Grail image CloneList.gr of CloneList.cmlt *)

(* We do mot take into account intreface methods, with java.Lang.string,
 generated the compiler *)
(* We are interested in a method to which a camelot-function "clone"
is mapped *)
(*
CAMELOT 
type intlist = Nil | Cons of int*intlist
val clone: intlist -> intlist

let clone l = 
	match l with 
	   Nil@_ -> Nil
         | Cons(h, t)@_ -> Cons(h, clone t)

let start args  =
let l = clone  (Cons(2, Cons(1, Nil)))
in ()
   
   

GRAIL:
method static public CloneList$dia_0 clone (CloneList$dia_0 l) =
   let

      fun f:clone(CloneList$dia_0 l) =
      let
         val v2 = getfield l <int CloneList$dia_0.$>
      in
         if v2 = 0
         then f:0(l)
         else f:1(l)
      end

      fun f:1(CloneList$dia_0 l) =
      let
         val v2 = getfield l <int CloneList$dia_0.f0>
         val v1 = getfield l <CloneList$dia_0 CloneList$dia_0.f1>
         val () = invokestatic <void CloneList$dia_0.free (CloneList$dia_0)> (l)
         val l = invokestatic <CloneList$dia_0 CloneList.clone (CloneList$dia_0)> (v1)
      in
         invokestatic <CloneList$dia_0 CloneList$dia_0.make (int, int, CloneList$dia_0)> (1, v2, l)
      end

      fun f:0(CloneList$dia_0 l) =
      let
         val () = invokestatic <void CloneList$dia_0.free (CloneList$dia_0)> (l)
      in
         invokestatic <CloneList$dia_0 CloneList$dia_0.make (int)> (0)
      end
   in
      f:clone(l)
   end

*)

(* make1 - "make" of arity 1 *)
(* make3 - "make" of arity 3 *) 
(* fill2 - "fill" of arity 2 *)
(* fill4 - "fill" of arity 4 *)

(* fill2 has 2 parameters so can't be a method. But fortunately fill2 
is invoked using the Grail convention. 
So we model it as a function. Same applies to fill4 *)


(* for modelling the arguments to make1 and make3 *)
(* a parameter "param" has 3 fields, - TAG, V0, V1 *)
(* the content of these fields will be assigned to vars tag, v0, v1 *)
(* these vars will be processed by a "function call" of fill1/fill3 *)


consts TAG :: ifldname
       V0 :: ifldname
       V1 :: rfldname


locale DiamondClone =
fixes
     (* freelist management: for conversion of CloneList$dia.gr *) 
     alloc :: mname and free :: mname and make1 :: mname and make3 :: mname and 
     (* *)
     allocQ :: funame and fill2TEMP :: funame and fill4TEMP :: funame and
     (* tag, v0 are int parameters, for "fill", "make" *)
     b :: iname and tag :: iname and v0 :: iname and
     (* flp is a static pointer to a freelist *)
     flp ::rname and freelist :: rname and t :: rname and
     (* node, x, v1 are ref parameters, for "free", "fill", "make" *) 
     node :: rname and x :: rname and v1 :: rname and 
     (* to model 0-param. "alloc", and multiparam. "fill", "make" *)
     dummyPar :: rname and PARmake::rname and
     (* bodies *)
     allocBODY::"nat expr" and allocQBODY::"nat expr" and freeBODY::"nat expr" and
     fill2BODY::"nat expr" and fill4BODY::"nat expr" and make1BODY::"nat expr" and make3BODY::"nat expr" and
     
     (* specific part: for conversion of CloneList.gr *)
     CLONELIST :: cname and
     clone :: mname and fclone :: funame and ff0 :: funame and ff1 :: funame and 
     cloneBODY :: "nat expr" and fcloneBODY  ::"nat expr"  and ff0BODY  ::"nat expr"  and ff1BODY  ::"nat expr" 
     and cloneb :: iname and clonetempf0 :: rname and clonetempf1 :: rname and
     clonev1 :: rname and clonev2 :: iname and clonezero :: iname and  cloneone :: iname and
     (* *)
     l :: rname and
     (* *)
     myContext :: "nat vdmcontext" and 
     (* *)
     renvQ :: renv and renvAllocNone :: renv and renvAllocSome :: renv and renvFree :: renv and 
     renvFill2 :: renv and renvFill4 :: renv and renvMake1 :: renv and renvMake3 :: renv
     (* ??? Env-s for specific part ???? *)
     defines "renvQ == \<langle>8 1 0 0\<rangle>"
       and "renvAllocNone == \<langle>15 0 1 1\<rangle>"
       and "renvAllocSome == \<langle>18 2 0 0\<rangle>"
       and "renvFree == \<langle>14 0 1 1\<rangle>"
       and "renvFill2 == \<langle>5 1 0 0\<rangle>"
       and "renvFill4 == \<langle>11 1 0 0\<rangle>"
       and "renvMake1 == \<langle>13 0 1 1\<rangle>"
       and "renvMake3 == \<langle>19 0 1 1\<rangle>"
    (* ??? Env-s for specific part ???? *)

(* method and function BODies *)
       and frbd[simp]: "freeBODY == (LET rf freelist = GetFr flp DollarF;
                                       _ = PutFr node DollarN freelist
                                     IN PutFr flp DollarF node
                                    END)::nat expr"
       and alcbd[simp]: "allocBODY == (LET rf freelist = GetFr flp DollarF; 
                                       b = RPrimop (% r1 r2 . if r1 = Nullref then 1 else 0) freelist freelist
                                       IN IF b THEN (NEW <DIAMOND> ([],[])) ELSE CALL allocQ 
                                       END)::nat expr"
       and alcqbd[simp]: "allocQBODY == (LET rf t = GetFr freelist DollarN;
                                                _ = PutFr flp DollarF t
                                         IN RVar freelist 
                                         END)::nat expr"
       and fl2bd[simp]: "fill2BODY == (LET _ = PutFi x Dollar tag IN RVar x END)::nat expr"
       and fl4bd[simp]: "fill4BODY == (LET _ = PutFi x Dollar tag;
                                           _ = PutFi x F0 v0;
                                           _ = PutFr x F1 v1
                                       IN RVar x END)::nat expr"
      and mk1bd[simp]: "make1BODY == ( LET rf dummyPar = Null;
                                           rf x = InvokeStatic DIAMOND alloc dummyPar;
                                            tag = GetFi param TAG
                                       IN CALL fill2TEMP END)::nat expr" 
       and  mk3bd[simp]:"make3BODY == (LET rf dummyPar = Null;
                                          rf x = InvokeStatic DIAMOND alloc dummyPar;
                                             tag = GetFi param TAG;
                                             v0 = GetFi param V0;
                                          rf v1 = GetFr param V1
                                     IN CALL fill4TEMP END)::nat expr"  
    and fclbd[simp]:"fcloneBODY == (LET clonev2 = GetFi param Dollar;
                         cloneb = Primop (% l1 l2. if l1 =0 then 1 else 0) clonev2 clonev2 
                         IN IF cloneb THEN CALL ff0 ELSE CALL ff1
                         END) :: nat expr"
    and f1bd[simp]:"ff1BODY == (LET    clonev2 = GetFi param F0;
                        rf  clonev1 = GetFr param F1;
                                 _  = InvokeStatic DIAMOND free param;
                        rf    param =  InvokeStatic CLONELIST clone clonev1;
                           cloneone = expr.Int 1;
                           _   = PutFi PARmake TAG cloneone;
                           _   = PutFi PARmake V0  clonev2; 
                           _   = PutFr PARmake V1  param;
                        rf clonetempf0 = InvokeStatic DIAMOND make3 PARmake
                    IN RVar clonetempf0
                    END) :: nat expr"
   and f0bd[simp]:"ff0BODY == ( LET _  = InvokeStatic DIAMOND free param;
                                   clonezero = expr.Int 0;
                                   _   = PutFi PARmake TAG clonezero;
                                  rf clonetempf1 = InvokeStatic DIAMOND make1 PARmake
                     IN RVar clonetempf1 
                     END) :: nat expr"
   and clbd[simp]: "cloneBODY == ( CALL fclone ) :: nat expr"

   and "myContext == {((InvokeStatic DIAMOND  alloc dummyPar)::nat expr, Mspectable DIAMOND alloc), 
                      ((InvokeStatic DIAMOND free param)::nat expr,  Mspectable DIAMOND free), 
                      ((InvokeStatic DIAMOND make1 PARmake)::nat expr, Mspectable DIAMOND make1), 
                      ((InvokeStatic DIAMOND make3 PARmake)::nat expr, Mspectable DIAMOND make3), 
                      ((Call allocQ)::nat expr, spectable allocQ), 
                      ((Call fill2TEMP)::nat expr, spectable fill2TEMP), 
                      ((Call fill4TEMP)::nat expr, spectable fill4TEMP),
                      ((Call fclone)::nat expr, spectable fclone),
                      ((Call ff0)::nat expr, spectable ff0),
                      ((Call ff1)::nat expr, spectable ff1),
                      ((InvokeStatic CLONELIST clone param)::nat expr, Mspectable CLONELIST clone)}"
                           
                         
 assumes FREE[simp]: "methtable DIAMOND free == freeBODY" 
       and ALLOC[simp]: "methtable DIAMOND alloc == allocBODY" 
       and ALLOCQ[simp]: "funtable allocQ == allocQBODY"
       and FILL2TEMP[simp]: "funtable fill2TEMP == fill2BODY" 
       and FILL4TEMP[simp]: "funtable fill4TEMP == fill4BODY" 
       and MAKE1[simp]: "methtable DIAMOND make1 == make1BODY" 
       and MAKE3[simp]: "methtable DIAMOND make3 == make3BODY"
 (*****************************************************************) 
       and FCLONE[simp]: "funtable fclone == fcloneBODY"
       and FF0[simp]: "funtable ff0 == ff0BODY"
       and FF1[simp]: "funtable ff1 == ff1BODY"
       and CLONE[simp]: "methtable CLONELIST clone == cloneBODY"

(*****************************************************************)
      and spectFill2: "spectable fill2TEMP == {(E, h, hh, v, p). \<forall> loc i. 
                                                                 E\<lfloor>x\<rfloor> = Ref loc \<longrightarrow>
                                                                 E<tag> = i \<longrightarrow>
                                                                 (hh=h<loc\<bullet>Dollar:=i>)}"

     and spectFill4: "spectable fill4TEMP == {(E, h, hh, v, p). \<forall> loc i j r. 
                                                                 E\<lfloor>x\<rfloor> = Ref loc \<longrightarrow>
                                                                 E<tag> = i \<longrightarrow> E<v0>=j \<longrightarrow>E\<lfloor>v1\<rfloor>=r \<longrightarrow> 
                                                                 hh = h<loc\<bullet>Dollar:=i><loc\<bullet>F0:=j>\<lfloor>loc\<diamondsuit>F1:=r\<rfloor>}"
     
      and spectAlloc:
                  "Mspectable DIAMOND alloc == {(E,h,hh,v,p) . 
                                       \<exists>  stloc m Y locout. (
                                       v = RVal (Ref locout)
                                       \<and> 
                                       E \<lfloor>flp\<rfloor> = Ref stloc 
                                       \<and> 
                                       (rheap h DollarF stloc = Nullref \<or> rheap h DollarF stloc = Ref locout)
                                        \<and>  (rheap h DollarF stloc = Nullref  \<longrightarrow>
                                            locout \<notin> fmap_dom (oheap h) \<and> hh = newObj h locout E DIAMOND [] []
                                            \<and>  (0,  rheap h DollarF stloc, Y, h) \<in> modelsFreelistMH 
                                            \<and> (0, rheap hh DollarF stloc, Y, hh) \<in> modelsFreelistMH)
                                        \<and>  (rheap h DollarF stloc = Ref locout \<longrightarrow>
                                            hh = \<lparr>oheap = oheap h, iheap = iheap h, 
                                            rheap = (rheap h)(DollarF := (rheap h DollarF)(stloc := h\<lfloor>locout\<diamondsuit>DollarN\<rfloor>))\<rparr>  \<and>
                                            (m-(1::nat),  rheap hh DollarF stloc, Y-{locout}, hh) \<in> modelsFreelistMH))}"
                                  
         
      and spectMake1:
           "Mspectable DIAMOND make1 == {(E,h,hh,v,p). 
                                           \<forall> floc m Y hloc.  (E\<lfloor>flp\<rfloor> = Ref floc \<longrightarrow>
                                           (m,  rheap h DollarF floc, Y, h) \<in> modelsFreelistMH \<longrightarrow> 
                                           (rheap h DollarF floc = Nullref \<longrightarrow> (HSize hh = (HSize h)+1))  \<and> 
                                           (rheap h DollarF floc = (Ref hloc) \<longrightarrow>  
                              (HSize hh = HSize h) \<and> (m-(1::nat),  rheap hh DollarF floc, Y-{hloc}, hh) \<in> modelsFreelistMH))}"

     and spectMake3:
           "Mspectable DIAMOND make3 == {(E,h,hh,v,p). 
                                           \<forall> floc m Y hloc.  (E\<lfloor>flp\<rfloor> = Ref floc \<longrightarrow>
                                           (m,  rheap h DollarF floc, Y, h) \<in> modelsFreelistMH \<longrightarrow> 
                                           (rheap h DollarF floc = Nullref \<longrightarrow> (HSize hh = (HSize h)+1))  \<and> 
                                           (rheap h DollarF floc = (Ref hloc) \<longrightarrow>  
                              (HSize hh = HSize h) \<and> (m-(1::nat),  rheap hh DollarF floc, Y-{hloc}, hh) \<in> modelsFreelistMH))}"

    and spectFree:
          "Mspectable DIAMOND free == {(E,h,hh,v,p). \<forall> floc m Y loc. 
                                                         ( E\<lfloor>flp\<rfloor> = Ref floc \<longrightarrow>
                                                         (m, rheap h DollarF floc, Y, h) \<in> modelsFreelistMH \<longrightarrow> 
                                                          E\<lfloor>node\<rfloor>  = Ref loc \<longrightarrow> 
                                                   (m+(1::nat), rheap hh DollarF floc, Y\<union> {loc} , hh) \<in> modelsFreelistMH)}"

(******************)

      and spectClone:
           "Mspectable CLONELIST  clone == 
               {(E,h,hh,v,p) . \<forall> loc X Ups Y m q loc' X' Ups'. 
                              (E\<lfloor>l\<rfloor> = Ref loc) \<longrightarrow>
                              (Ups, loc, X, h) \<in> LocLength \<longrightarrow> 
                              (E\<lfloor>flp \<rfloor> = Ref floc)  \<longrightarrow>
                               floc \<notin> X \<longrightarrow>
                               X \<inter> Y ={} \<longrightarrow>
                               (m,  rheap h DollarF floc, Y, h) \<in> modelsFreelistMH \<longrightarrow>
                               (0::nat) + 0 * Ups + q \<le> m  \<longrightarrow> 
                                (v = RVal (Ref loc')) \<longrightarrow> 
                                (Ups', loc', X', hh) \<in> LocLength \<longrightarrow> 
                                 (HSize h) = (HSize hh)  \<and>  floc \<notin> X' \<and>
                                 (\<exists> m' Y'.  X' \<inter> Y'={} \<and> (m', rheap h DollarF floc , Y', hh) \<in> modelsFreelistMH \<and> 
                                  (0::nat) + 0 * Ups' + q \<le> m')}"

and alldistinct: "distinct[flp,freelist,t,node,x,v1,dummyPar,self, param, PARmake, 
                                  clonetempf0, clonetempf1, clonev1] \<and>
                         distinct[clonev1,  clonetempf1,  clonetempf0,
                                  PARmake, param,self,dummyPar,v1,x,node,t,freelist,flp] \<and>
                         distinct[b,tag,v0, cloneb, clonev2, clonezero, cloneone] 
                         \<and> distinct[cloneone, clonezero, clonev2, cloneb, v0,tag,b] \<and>
                         distinct[DollarF, DollarN, F1] \<and> distinct[F1,DollarN,DollarF] \<and>
                         distinct[Dollar, F0] \<and> distinct[F0,Dollar] \<and>
                         distinct[STATICFL, DIAMOND, CLONELIST] \<and> 
                         distinct[CLONELIST, DIAMOND, STATICFL] \<and>
                         distinct[make1, make3, free, alloc, clone] \<and>
                         distinct[clone, alloc, free, make3, make1] \<and>
                         distinct[fill2TEMP, fill4TEMP, allocQ, fclone, ff0, ff1] \<and>
                         distinct[ff1, ff0, fclone, allocQ, fill4TEMP, fill2TEMP]"
                         
and typing[simp] : "\<forall> E h l C . (qach_QaQ E h l flp C \<longrightarrow> C = DIAMOND)"

declare obj_ifieldupdate_def [simp]
declare obj_rfieldupdate_def [simp]
declare ivarupdate_def [simp]
declare rvarupdate_def [simp]
declare ienv_fct_def [simp]
declare renv_fct_def [simp]
declare newframe_env_def [simp]
declare emptyr_def [simp]



lemma (in DiamondClone) fill2abstr[simp]: " \<rhd> ((CALL fill2TEMP)::nat expr) : spectable fill2TEMP" 
apply (rule vdm_call)
apply (simp only: FILL2TEMP) 
apply (simp only: fl2bd)
apply (rule vdm_conseq) 
apply (rule vdm_letv, rule vdm_putfi) 
apply (rule vdm_rvar) 
(* end of VCG *)
apply (simp only: spectFill2)
apply (insert alldistinct)
apply clarsimp
done

lemma (in DiamondClone) fill4abstr[simp]: " \<rhd> ((CALL fill4TEMP)::nat expr) : spectable fill4TEMP" 
apply (rule vdm_call)
apply (simp only: FILL4TEMP) 
apply (simp only: fl4bd)
apply (rule vdm_conseq) 
apply (rule vdm_letv, rule vdm_putfi) 
apply (rule vdm_letv, rule vdm_putfi)
apply (rule vdm_letv, rule vdm_putfr)
apply (rule vdm_rvar) 
(* end of VCG *)
apply (simp only: spectFill4)
apply (insert alldistinct)
apply clarsimp
done


lemma (in DiamondClone) allocAbstr:"\<rhd> ((InvokeStatic DIAMOND  alloc dummyPar)::nat expr) : Mspectable DIAMOND alloc"
apply (rule vdm_invokestatic) 
apply (simp only: ALLOC)
apply (simp only: alcbd)
apply (rule vdm_conseq)
apply (rule vdm_letr) apply (rule vdm_getfr)
apply (rule vdm_leti) apply (rule vdm_rprim)
apply (rule vdm_if) 
apply (rule vdm_new)
apply (rule vdm_callmh)
apply (simp only: ALLOCQ)
apply (simp only: alcqbd)
apply (rule vdm_letr) apply (rule vdm_getfr)
apply (rule vdm_letv) apply (rule vdm_putfr)
apply (rule vdm_rvar)
(******* end of VCG *************)
apply (simp only: spectAlloc)
apply (insert alldistinct)
apply (clarsimp)
done


lemma (in DiamondClone)
         make1Abstr[simp]:"{(((InvokeStatic DIAMOND  alloc dummyPar)::nat expr), Mspectable DIAMOND alloc),
                             (((CALL fill2TEMP)::nat expr), spectable fill2TEMP) }
                        \<rhd> ((InvokeStatic DIAMOND  make1 PARmake)::nat expr) : Mspectable DIAMOND make1"
apply (rule vdm_invokestatic) 
apply (simp only: MAKE1)
apply (simp only: mk1bd)
apply (rule vdm_conseq)
apply (rule vdm_letr) apply (rule vdm_null)
apply (rule vdm_letr) apply (rule vdm_ax)
apply (rule UnI1)+
apply (rule insertI1)
apply (rule vdm_leti) apply (rule vdm_getfi)
apply  (rule vdm_ax)
apply (rule UnI1)+
apply (rule insertI2)
apply (rule insertI1)
(* end of VCG ************)
apply clarify
apply (simp only: spectAlloc)
apply (simp only: spectFill2)
apply (simp only: spectMake1)
apply (insert alldistinct)
apply clarsimp
done

lemma (in DiamondClone)
         make3Abstr[simp]:"{(((InvokeStatic DIAMOND  alloc dummyPar)::nat expr), Mspectable DIAMOND alloc),
                             (((CALL fill4TEMP)::nat expr), spectable fill4TEMP) }
                        \<rhd> ((InvokeStatic DIAMOND  make3 PARmake)::nat expr) : Mspectable DIAMOND make3"
apply (rule vdm_invokestatic) 
apply (simp only: MAKE3)
apply (simp only: mk3bd)
apply (rule vdm_conseq)
apply (rule vdm_letr) apply (rule vdm_null)
apply (rule vdm_letr) apply (rule vdm_ax)
apply (rule UnI1)+
apply (rule insertI1)
apply (rule vdm_leti) apply (rule vdm_getfi)
apply (rule vdm_leti) apply (rule vdm_getfi)
apply (rule vdm_letr) apply (rule vdm_getfr)
apply  (rule vdm_ax)
apply (rule UnI1)+
apply (rule insertI2)
apply (rule insertI1)
(* end of VCG ************)
apply clarify
apply (simp only: spectAlloc)
apply (simp only: spectFill4)
apply (simp only: spectMake3)
apply (insert alldistinct)
apply clarsimp
done



lemma (in DiamondClone) freeAbstr[simp]:"\<rhd> ((InvokeStatic DIAMOND  free param)::nat expr) : Mspectable DIAMOND free"
apply (rule vdm_invokestatic) 
apply (simp only: FREE)
apply (simp only: frbd)
apply (rule vdm_conseq)
apply (rule vdm_letr) apply (rule vdm_getfr)
apply (rule vdm_letv) apply (rule vdm_putfr)
apply (rule vdm_putfr)
apply (insert alldistinct)
apply clarsimp
done


lemma union31: "{a, b, c}\<union> {d}={a, b, c, d}"
by blast

lemma union41: "{a, b, c, d}\<union> {e}={a, b, c, d, e}"
by blast

lemma union51: "{a, b, c, d, e}\<union> {f}={a, b, c, d, e, f}"
by blast

lemma union61: "{a, b, c, d, e, f}\<union> {g}={a, b, c, d, e, f, g}"
by blast

constdefs subst :: "vdmassn \<Rightarrow> rname \<Rightarrow> rname \<Rightarrow> vdmassn"
"subst P y x \<equiv> {(E,h,hh,v,p). (E\<lfloor>x := E\<lfloor>y\<rfloor>\<rfloor>,h,hh,v,p) \<in> P}"

lemma vdm_adapt_context: 
      "\<lbrakk> {(InvokeStatic cn mn rn', subst Q rn' rn), (e1, P1), (e2, P2), (e3, P3), (e4, P4), (e5, P5)} \<rhd> e : P \<rbrakk> 
        \<Longrightarrow>
       {(e1, P1), (e2, P2), (e3, P3), (InvokeStatic cn mn rn, Q), (e4, P4), (e5, P5)}\<rhd> e : P"
sorry



lemma (in DiamondClone) cloneAbstr:
"{(((InvokeStatic DIAMOND make1 PARmake)::nat expr), Mspectable DIAMOND make1),
  (((InvokeStatic DIAMOND make3 PARmake)::nat expr), Mspectable DIAMOND make3),
  (((InvokeStatic DIAMOND  free param)::nat expr), Mspectable DIAMOND free)}
   \<rhd> ((InvokeStatic CLONELIST clone l):: nat expr) : Mspectable CLONELIST clone"
apply (rule vdm_invokestatic) apply (simp only: union31)
apply (simp only: CLONE) apply (simp only: clbd)
apply (rule vdm_conseq) 
apply (rule vdm_callmh) apply (simp only: union41)
apply (simp only: FCLONE) apply (simp only: fclbd) 
apply (rule vdm_leti) apply (rule vdm_getfi) 
apply (rule vdm_leti, rule vdm_prim) 
apply (rule vdm_if) 
apply (rule vdm_callmh) apply (simp only: union51)
apply (simp only: FF0) apply (simp only: f0bd)
apply (rule vdm_letv) apply (rule vdm_ax) 
apply (rule insertI2)
apply (rule insertI2)
apply (rule insertI1)
apply (rule vdm_leti, rule vdm_int) 
apply (rule vdm_letv, rule vdm_putfi) 
apply (rule vdm_letr) apply (rule vdm_ax) 
apply (rule insertI1)
apply (rule vdm_rvar) 
apply (rule vdm_callmh)apply (simp only: union51)
apply (simp only: FF1) apply (simp only: f1bd)
apply (rule vdm_leti, rule vdm_getfi) 
apply (rule vdm_letr, rule vdm_getfr) 
apply (rule vdm_letv) apply (rule vdm_ax) 
apply (rule insertI2)
apply (rule insertI2)
apply (rule insertI1)
apply (rule vdm_letr)
apply (rule_tac  rn="l" and rn'="clonev1" in vdm_adapt_context)
apply (rule vdm_ax) 
apply (rule insertI1)
apply (rule vdm_leti, rule vdm_int) 
apply (rule vdm_letv, rule vdm_putfi) 
apply (rule vdm_letv, rule vdm_putfi) 
apply (rule vdm_letv, rule vdm_putfr)
apply (rule vdm_letr) apply (rule vdm_ax) 
apply (rule insertI2)
apply (rule insertI1)
apply (rule vdm_rvar)
(******** End of VCG ***********************)
apply clarify
apply (simp only: spectMake1)
apply (simp only: spectMake3)
apply (simp only: spectFree)
apply (insert alldistinct) 
apply clarsimp
done



