
theory clone = VDMaux:
(***************************************************************************************)

(************************ To lemmas.thy ! ******************************************)
 
lemma ilfdUpdElsewhere2: "a \<noteq> a' \<Longrightarrow> h<a\<bullet>f:=n><a'\<bullet>f'> = h<a'\<bullet>f'>"
by (simp add: obj_ifieldupdate_def obj_rfieldupdate_def)

lemma rlfdUpdElsewhere2: "a \<noteq> a' \<Longrightarrow> h\<lfloor>a\<diamondsuit>f:=r\<rfloor>\<lfloor>a'\<diamondsuit>f'\<rfloor> = h\<lfloor>a'\<diamondsuit>f'\<rfloor>"
by (simp add: obj_ifieldupdate_def obj_rfieldupdate_def)

lemma rlfdUpdIfldElsewhere2: "a \<noteq> a' \<Longrightarrow> h<a\<bullet>f:=n>\<lfloor>a'\<diamondsuit>f'\<rfloor> = h\<lfloor>a'\<diamondsuit>f'\<rfloor>"
by (simp add: obj_ifieldupdate_def obj_rfieldupdate_def)

lemma ilfdUpdRfldElsewhere2: "h\<lfloor>a\<diamondsuit>f:=r\<rfloor><a'\<bullet>f'> = h<a'\<bullet>f'>"
by (simp add: obj_ifieldupdate_def obj_rfieldupdate_def)

lemma ilfdUpdElsewhere3: "f \<noteq> f' \<Longrightarrow> h<a\<bullet>f:=n><a'\<bullet>f'> = h<a'\<bullet>f'>"
apply (auto simp add: obj_ifieldupdate_def) 
done

lemma rlfdUpdElsewhere3: "f \<noteq> f' \<Longrightarrow> h\<lfloor>a\<diamondsuit>f:=r\<rfloor>\<lfloor>a'\<diamondsuit>f'\<rfloor> = h\<lfloor>a'\<diamondsuit>f'\<rfloor>"
apply (auto simp add: obj_rfieldupdate_def)
done


lemma rlfdUpdIfldElsewhere3: "h<a\<bullet>f:=n>\<lfloor>a'\<diamondsuit>f'\<rfloor> = h\<lfloor>a'\<diamondsuit>f'\<rfloor>"
by (simp add: obj_ifieldupdate_def obj_rfieldupdate_def)


(**************** Add to general VDM-files !**************************************************)

lemma  vdm_callmh: 
"\<lbrakk>( G \<union> {(CALL f, {(E,h,hh,v,p) . \<exists> p'. tkcall p' = p \<and> (E, h, hh, v, p') : P})}) 
\<rhd> (funtable f) : P\<rbrakk> \<Longrightarrow>
           G \<rhd> (CALL f) : {(E,h,hh,v,p) . \<exists> p'. tkcall p' = p \<and> (E, h, hh, v, p') : P}"
sorry

(*********************************************************************************) 

consts flp :: rname

axioms
  constdistinct_o: "distinct [self,param, flp]\<and> distinct [flp, param, self]"

(**************** ersatz - invokation for flp **************************************)
constdefs
  newframe_env_o :: "ref \<Rightarrow> ref \<Rightarrow>  ref \<Rightarrow> env"
  "newframe_env_o objref arg ptr \<equiv>   \<lparr> ienv = emptyi, 
                                 renv = (((emptyr(self := objref))(param := arg)) (flp := ptr)) \<rparr>"

lemma vdm_invokestatic_o:
  "\<lbrakk> ({(InvokeStatic C mn y,P)} \<union> G) \<rhd> 
    (methtable C mn) :  
    {(E,h,hh,v,p) . \<forall> E'. E = newframe_env_o Nullref (E'\<lfloor>y\<rfloor>) (E'\<lfloor>flp\<rfloor>) \<longrightarrow>
                    (E',h,hh,v,\<langle>3 0 1 1\<rangle> \<oplus> p) \<in> P} \<rbrakk> \<Longrightarrow>
   G \<rhd> (InvokeStatic C mn y) : P"
sorry

consts DIAMOND ::cname
consts DollarN :: rfldname (* to point to the next member in a freelist *)
       Dollar :: ifldname (* a tag to discriminate constructors in our "universal" diamond *)
       F0 :: ifldname (* a working field *)
       F1 :: rfldname (* a working field *)
       DollarF :: rfldname (* the pointer to a head of a freelist*)

axioms iflddistinct: "distinct[F0, Dollar] \<and> distinct[Dollar, F0]"
axioms rflddistinct: "distinct[DollarN, F1, DollarF] \<and> distinct[DollarF, F1, DollarN]"

consts Freelist::"(nat \<times> ref \<times> (locn set) \<times> heap) set"
(*(i,l,X,h) : Freelist if h\<lfloor>l\<rfloor> is the head of a list of diamonds of length i*) 
inductive Freelist intros
FL_nothing[intro!] : "(0, Nullref,{},h) \<in>  Freelist"
FL_something[intro!] : "\<lbrakk> fmap_lookup(oheap h) loc = Some DIAMOND;
                                    iheap h Dollar loc = d;
                                    iheap h F0 loc = f0;
                                    rheap h F1 loc = f1;
                                    rheap h DollarF loc = df;
                                    rheap h DollarN loc = n;
                       loc \<notin> X;
                   (i, n , X , h) \<in> Freelist\<rbrakk> 
                   \<Longrightarrow> (Suc i, Ref loc, X\<union> {loc}, h) : Freelist"

lemma flistZero: "(0,  r, X, h)  \<in>  Freelist \<Longrightarrow> r=Nullref"
apply (erule Freelist.cases)
apply simp
apply simp
done

lemma flistZeroClassic: "\<forall> r X h.  (0,  r, X, h)  \<in>  Freelist \<longrightarrow>  r=Nullref"
apply clarify
apply (rule_tac r="r" and X="X" and h="h" in  flistZero) 
apply assumption
done


lemma flistTail [rule_format]: "\<lbrakk> (m,  r, X, h)  \<in>  Freelist\<rbrakk> 
                                \<Longrightarrow>
                              (\<forall> hloc. r= Ref hloc \<longrightarrow> (m- Suc 0,  rheap h DollarN hloc, X-{hloc}, h) \<in>  Freelist)"   
apply (erule Freelist.cases)
apply simp
apply simp
done

lemma flistTailClassic:  "\<forall> m r X h hloc. (m,  r, X, h)  \<in>  Freelist \<longrightarrow>
                                     r =  Ref hloc \<longrightarrow>  (m - Suc 0,  rheap h DollarN hloc, X-{hloc}, h) \<in>  Freelist"
apply clarify
apply (erule Freelist.cases)
apply simp
apply simp
done

lemma flistTail2 [rule_format]: "(m, Ref hloc, X, h)  \<in>  Freelist 
                                \<Longrightarrow>
                              (m- Suc 0,  rheap h DollarN hloc, X-{hloc}, h) \<in>  Freelist"   
apply (erule Freelist.cases)
apply simp
apply simp
done

lemma flistTailClassic2:  "\<forall> m X h hloc. (m, Ref hloc  , X, h)  \<in>  Freelist \<longrightarrow>
                                     (m - Suc 0,  rheap h DollarN hloc, X-{hloc}, h) \<in>  Freelist"
apply clarify
apply (rule_tac m="m" and X="X" and h="h" and hloc="hloc" in flistTail2)
apply assumption
done


lemma flistSame [rule_format]: "(m,  r, X, h)  \<in>  Freelist
                                \<Longrightarrow>
                                (\<forall> Y hh. X\<subseteq> Y \<longrightarrow> 
                                                 same Y h hh \<longrightarrow>
                                                 (m,  r, X, hh)  \<in>  Freelist)"
apply (erule Freelist.induct)
apply clarify
apply (rule allI)
apply (rule allI)
apply (rule impI)
apply (rule impI)
apply (rule FL_something)
apply (unfold same_def)
apply simp
apply simp
apply simp
apply simp
apply simp
apply simp
apply (assumption)
apply force
done

lemma flistSameClassic: "\<forall> m r X h Y hh .(m,  r, X, h)  \<in>  Freelist \<longrightarrow> 
                                          X\<subseteq> Y \<longrightarrow> 
                                          same Y h hh \<longrightarrow>
                                          (m,  r, X, hh)  \<in>  Freelist"
apply clarify
apply (rule_tac m="m" and  r="r" and  X="X" and  h="h" and  Y="Y" and  hh="hh" in flistSame)
apply assumption
apply assumption
apply assumption
done

lemma flistSame2Ref [rule_format]: "(m,  r, X, h)  \<in>  Freelist
                                \<Longrightarrow>
                                (\<forall> Y hh rr. X\<subseteq> Y \<longrightarrow> 
                                                 same Y h hh \<longrightarrow> 
                                                 r=rr\<longrightarrow>
                                                 (m,  rr, X, hh)  \<in>  Freelist)"
apply clarify
apply (insert flistSame)
apply blast
done

lemma flistSame2RefClassic: "\<forall> m r rr X h Y hh .(m,  r, X, h)  \<in>  Freelist \<longrightarrow> r=rr \<longrightarrow> 
                                          X\<subseteq> Y \<longrightarrow> 
                                          same Y h hh \<longrightarrow> 
                                          (m,  rr, X, hh)  \<in>  Freelist"
apply clarify
apply (rule_tac m="m" and r="rr" and  X="X" and  h="h" and  Y="Y" and  hh="hh" in flistSame)
apply assumption
apply assumption
apply assumption
done

lemma flistDecr[rule_format]: "\<lbrakk> (m,  rheap h DollarF stloc, X, h)  \<in>  Freelist\<rbrakk> \<Longrightarrow>
                               (\<forall> hloc hh. stloc \<notin> X \<longrightarrow> 
                                 rheap h DollarF stloc =  Ref hloc  \<longrightarrow>  
                                 hh = \<lparr>oheap = oheap h, iheap = iheap h, 
        rheap = (rheap h)(DollarF := (rheap h DollarF)(stloc :=  rheap h DollarN hloc))\<rparr> \<longrightarrow>  
                               
                             (m-Suc 0,  rheap hh DollarF stloc, X-{hloc}, hh) \<in>  Freelist)"   
apply (erule Freelist.cases)
apply clarsimp
apply clarsimp
apply (rule_tac X="X" and
                Y="X" and
                h="h" in flistSame)
apply assumption
apply clarify
apply (simp add: same_def)
done

lemma flistDecrClassic: "\<forall> m stloc X h hloc hh.
                         (m,  rheap h DollarF stloc, X, h)  \<in>  Freelist \<longrightarrow>  
                          stloc \<notin> X \<longrightarrow> 
                          rheap h DollarF stloc =  Ref hloc  \<longrightarrow>  
                          hh = \<lparr>oheap = oheap h, iheap = iheap h, 
        rheap = (rheap h)(DollarF := (rheap h DollarF)(stloc :=  rheap h DollarN hloc))\<rparr> \<longrightarrow>  
                               
                             (m-Suc 0,  rheap hh DollarF stloc, X-{hloc}, hh) \<in>  Freelist"   
apply clarify
apply (rule_tac  m="m" and X="X" and h="h" in flistDecr)
apply assumption
apply assumption
apply assumption
apply clarify
done

lemma flistDecr2[rule_format]: "\<lbrakk> (m,  Ref hloc, X, h)  \<in>  Freelist\<rbrakk> \<Longrightarrow>
                               (\<forall> stloc hh. stloc \<notin> X \<longrightarrow> 
                                 rheap h DollarF stloc =  Ref hloc  \<longrightarrow>  
                                 hh = \<lparr>oheap = oheap h, iheap = iheap h, 
        rheap = (rheap h)(DollarF := (rheap h DollarF)(stloc :=  rheap h DollarN hloc))\<rparr> \<longrightarrow>  
                               
                             (m-Suc 0,  h\<lfloor>hloc\<diamondsuit>DollarN\<rfloor> , X-{hloc}, hh) \<in>  Freelist)"   
apply clarify
apply (erule Freelist.cases)
apply clarsimp
apply clarsimp
apply (rule_tac X="X" and
                Y="X" and
                h="h" in flistSame)
apply assumption
apply clarify
apply (simp add: same_def)
done

lemma flistDecr2Classic: "\<forall>  m hloc X h stloc hh.(m,  Ref hloc, X, h)  \<in>  Freelist \<longrightarrow> 
                               stloc \<notin> X \<longrightarrow> 
                               rheap h DollarF stloc =  Ref hloc  \<longrightarrow>  
                               hh = \<lparr>oheap = oheap h, iheap = iheap h, 
        rheap = (rheap h)(DollarF := (rheap h DollarF)(stloc :=  rheap h DollarN hloc))\<rparr> \<longrightarrow>  
                               
                             (m-Suc 0,  h\<lfloor>hloc\<diamondsuit>DollarN\<rfloor> , X-{hloc}, hh) \<in>  Freelist"   
apply clarify
apply (rule_tac  stloc="stloc" in flistDecr2)
apply assumption
apply assumption
apply assumption
apply clarify
done

lemma flistIncrStage1 [rule_format]: "\<lbrakk> (m, r , X, h)  \<in>  Freelist \<rbrakk>  \<Longrightarrow>
                      (\<forall> newloc d f0 f1 n hh.
                                 newloc \<notin> X \<longrightarrow> 
                                 fmap_lookup(oheap h) newloc = Some DIAMOND \<longrightarrow> 
                                 iheap h Dollar newloc = d \<longrightarrow> 
                                 iheap h F0 newloc = f0 \<longrightarrow> 
                                 rheap h F1 newloc = f1 \<longrightarrow> 
                                 rheap h DollarF newloc = df \<longrightarrow> 
                                 rheap h DollarN newloc = n \<longrightarrow> 
                      hh = \<lparr>oheap = oheap h, iheap = iheap h, rheap = (rheap h)
                                          (DollarN := (rheap h DollarN)(newloc := r))\<rparr> \<longrightarrow> 
                               
                             (Suc m,  
                              Ref newloc, X\<union> {newloc}, hh) \<in>  Freelist)"
apply (rule allI)
apply (rule allI)
apply (rule allI)
apply (rule allI)
apply (rule allI)
apply (rule allI)
apply (rule impI)
apply (rule impI)
apply (rule impI)
apply (rule impI)
apply (rule impI)
apply (rule impI)
apply (rule impI)
apply (rule impI)
apply (rule_tac loc="newloc" and d="d" and n="r" and df="df" and
                h="hh" in FL_something)
apply simp
apply (insert rflddistinct)
apply (simp add: rlfdUpdElsewhere3) 
apply (simp add: rlfdUpdElsewhere3)
apply (simp add: rlfdUpdElsewhere3)
apply (simp add: rlfdUpdElsewhere3)
apply (simp add: rlfdUpdElsewhere3)
apply (assumption)
apply (subgoal_tac "same X h hh")
apply (rule_tac  X="X" and
                 Y="X" and
                 r="r" and 
                 h="h" and
                 hh="hh" in flistSame)
apply (assumption)                
apply clarify
apply (assumption)
apply (unfold same_def)
apply simp
done

lemma flistIncrStage1Classic: "\<forall> m r X h newloc d f0 f1 df n hh. 
                                (m, r , X, h)  \<in>  Freelist  \<longrightarrow> 
                                 newloc \<notin> X \<longrightarrow> 
                                 fmap_lookup(oheap h) newloc = Some DIAMOND \<longrightarrow> 
                                 iheap h Dollar newloc = d \<longrightarrow> 
                                 iheap h F0 newloc = f0 \<longrightarrow> 
                                 rheap h F1 newloc = f1 \<longrightarrow> 
                                 rheap h DollarF newloc = df \<longrightarrow> 
                                 rheap h DollarN newloc = n \<longrightarrow> 
                      hh = \<lparr>oheap = oheap h, iheap = iheap h, rheap = (rheap h)
                                          (DollarN := (rheap h DollarN)(newloc := r))\<rparr> \<longrightarrow> 
                               
                             (Suc m,  
                              Ref newloc, X\<union> {newloc}, hh) \<in>  Freelist"
apply (rule allI)
apply (rule allI)
apply (rule allI)
apply (rule allI)
apply (rule allI)
apply (rule allI)
apply (rule allI)
apply (rule allI)
apply (rule allI)
apply (rule allI)
apply (rule allI)
apply (rule impI)
apply (rule impI)
apply (rule impI)
apply (rule impI)
apply (rule impI)
apply (rule impI)
apply (rule impI)
apply (rule impI)
apply (rule impI)
apply (rule flistIncrStage1)
apply (assumption)
apply (assumption)
apply (assumption)
apply (assumption)
apply (assumption)
apply (assumption)
apply (assumption)
apply (assumption)
apply (assumption)
done

lemma flistIncrStage2 [rule_format]: "(m, r, X, h)  \<in>  Freelist \<Longrightarrow>
                       (\<forall> stloc newloc hh.
                                   stloc \<notin> X \<longrightarrow> 
                                   newloc \<notin> X \<longrightarrow> 
                                   stloc ~= newloc \<longrightarrow> 
                                 hh = \<lparr>oheap = oheap h, iheap = iheap h, 
        rheap = (rheap h)(DollarF := (rheap h DollarF)(stloc :=  r)) \<rparr>  \<longrightarrow> 
                                 (m, rheap hh DollarF stloc, X, hh) \<in>  Freelist)" 
apply (rule allI)
apply (rule allI)
apply (rule allI)
apply (rule impI)
apply (rule impI)
apply (rule impI)
apply (rule impI)
apply (subgoal_tac "(m, r, X, hh)\<in>  Freelist")
apply simp
apply (subgoal_tac "same X h hh")
apply (rule_tac  X="X" and
                 Y="X" and
                 r="r" and 
                 h="h" and
                 hh="hh" in flistSame)
apply assumption
apply clarify
apply assumption
apply (unfold same_def)
apply simp
done

lemma flistIncrStage2Classic: "\<forall> m r X h stloc newloc hh. (m, r, X, h)  \<in>  Freelist \<longrightarrow> 
                                   stloc \<notin> X \<longrightarrow> 
                                   newloc \<notin> X \<longrightarrow> 
                                   stloc ~= newloc \<longrightarrow> 
                                 hh = \<lparr>oheap = oheap h, iheap = iheap h, 
        rheap = (rheap h)(DollarF := (rheap h DollarF)(stloc :=  r)) \<rparr>  \<longrightarrow> 
                                 (m, rheap hh DollarF stloc, X, hh) \<in>  Freelist" 
apply (rule allI)
apply (rule allI)
apply (rule allI)
apply (rule allI)
apply (rule allI)
apply (rule allI)
apply (rule allI)
apply (rule impI)
apply (rule impI)
apply (rule impI)
apply (rule impI)
apply (rule impI)
apply (rule_tac stloc="stloc" and newloc="newloc" in flistIncrStage2)
apply assumption
apply assumption
apply assumption
apply assumption
apply assumption
done


(****** operations on heap that do not change freelist ******************)

lemma FLDollarNRelsewhere [rule_format]:
"(m, r, X, h) \<in> Freelist \<Longrightarrow>   (\<forall> loc r'. loc \<notin> X \<longrightarrow> 
(m, r, X, h\<lfloor> loc\<diamondsuit> DollarN := r'\<rfloor>) \<in> Freelist)"
apply clarify
apply (subgoal_tac "same X h  h\<lfloor> loc\<diamondsuit> DollarN := r'\<rfloor> ")
apply (rule_tac  X="X" and
                 Y="X" and
                 r="r" and 
                 h="h" and
                 hh="h\<lfloor> loc\<diamondsuit> DollarN := r'\<rfloor>" in flistSame)
apply assumption
apply clarify
apply assumption
apply (unfold same_def)
apply (rule allI)
apply (rule impI)
apply (rule conjI)
apply simp
apply (rule  conjI)
apply (rule allI)
apply (simp add: ilfdUpdRfldElsewhere2)
apply (rule allI)
apply (subgoal_tac "loc~=l")   
apply (simp add: rlfdUpdElsewhere2)
apply clarify
done

lemma FLDollarNRelsewhereClassic:
" \<forall> m r X h loc r'. (m, r, X, h) \<in> Freelist \<longrightarrow> loc \<notin> X  \<longrightarrow> 
(m, r, X, h\<lfloor> loc\<diamondsuit> DollarN := r'\<rfloor>) \<in> Freelist"
apply clarify
apply (rule FLDollarNRelsewhere)
apply assumption
apply assumption
done


lemma FLF0 [rule_format]:
  "\<lbrakk>(m, r, X, h) \<in> Freelist\<rbrakk> \<Longrightarrow>  (\<forall> loc' f0'. (m, r, X, h<loc'\<bullet>F0 := f0'>) \<in> Freelist)"
apply clarify
apply (erule Freelist.induct)
apply (rule FL_nothing)
apply (subgoal_tac "loc=loc'\<or> loc~=loc'")
prefer 2
apply clarify
apply (erule disjE)
apply (rule FL_something)
apply simp
apply simp
apply simp
apply simp
apply simp
apply simp
apply assumption
apply (simp add: rlfdUpdIfldElsewhere3)
apply (rule FL_something)
apply simp
apply simp
apply simp
apply simp
apply simp
apply simp
apply assumption
apply (simp add: rlfdUpdIfldElsewhere3)
done

lemma FLF0classic:
  "\<forall> m r X h loc' f0'. (m, r, X, h) \<in> Freelist \<longrightarrow>   (m, r, X, h<loc'\<bullet>F0 := f0'>) \<in> Freelist"
apply clarify
apply (rule FLF0)
apply assumption
done


lemma FLDollar [rule_format]:
  "\<lbrakk>(m, r, X, h) \<in> Freelist\<rbrakk> \<Longrightarrow> (\<forall> loc' d'.  (m, r, X, h<loc'\<bullet>Dollar := d'>) \<in> Freelist)"
apply (rule allI)
apply (rule allI)
apply (erule Freelist.induct)
apply (rule FL_nothing)
apply (subgoal_tac "loc=loc'\<or> loc~=loc'")
prefer 2
apply clarify
apply (erule disjE)
apply (rule FL_something)
apply simp
apply simp
apply simp
apply simp
apply simp
apply simp
apply assumption
apply (simp add: rlfdUpdIfldElsewhere3)
apply (rule FL_something)
apply simp
apply simp
apply simp
apply simp
apply simp
apply simp
apply assumption
apply (simp add: rlfdUpdIfldElsewhere3)
done


lemma FLDollarClassic:
  "\<forall> m r X h loc' d'. (m, r, X, h) \<in> Freelist \<longrightarrow>   (m, r, X, h<loc'\<bullet>Dollar := d'>) \<in> Freelist"
apply clarify
apply (rule FLDollar)
apply assumption
done

lemma FLF1 [rule_format]:
  "\<lbrakk>(m, r, X, h) \<in> Freelist\<rbrakk> \<Longrightarrow>  (\<forall> loc' f1'. (m, r, X, h\<lfloor> loc'\<diamondsuit>F1 := f1'\<rfloor>) \<in> Freelist)"
apply (rule allI)
apply (rule allI)
apply (erule Freelist.induct)
apply (rule FL_nothing)
apply (subgoal_tac "loc=loc'\<or> loc~=loc'")
prefer 2
apply clarify
apply (erule disjE)
apply (rule FL_something)
apply simp
apply simp
apply simp
apply simp
apply simp
apply simp
apply assumption
apply (insert rflddistinct)
apply simp
apply (rule FL_something)
apply simp
apply simp
apply simp
apply simp
apply simp
apply simp
apply assumption
apply (simp add: rlfdUpdElsewhere2)
done

lemma FLF1Classic:
  "\<forall> m r X h loc' f1'. (m, r, X, h) \<in> Freelist \<longrightarrow>  (m, r, X, h\<lfloor> loc'\<diamondsuit>F1 := f1'\<rfloor>)  \<in> Freelist"
apply clarify
apply (rule FLF1)
apply assumption
done


lemma FLDollarF [rule_format]:
  "\<lbrakk>(m, r, X, h) \<in> Freelist\<rbrakk> \<Longrightarrow> (\<forall> loc' df' . (m, r, X, h\<lfloor> loc'\<diamondsuit>DollarF := df'\<rfloor>) \<in> Freelist)"
apply (rule allI)
apply (rule allI)
apply (erule Freelist.induct)
apply (rule FL_nothing)
apply (subgoal_tac "loc=loc'\<or> loc~=loc'")
prefer 2
apply clarify
apply (erule disjE)
apply (rule FL_something)
apply simp
apply simp
apply simp
apply simp
apply simp
apply simp
apply assumption
apply (insert rflddistinct)
apply simp
apply (rule FL_something)
apply simp
apply simp
apply simp
apply simp
apply simp
apply simp
apply assumption
apply (simp add: rlfdUpdElsewhere2)
done

lemma FLDollarFClassic: "\<forall> m r X h loc' df'. (m, r, X, h) \<in> Freelist \<longrightarrow>  (m, r, X, h\<lfloor> loc'\<diamondsuit>DollarF := df'\<rfloor>) \<in> Freelist"
apply clarify
apply (rule FLDollarF)
apply assumption
done


consts arg :: rname

locale DiamondClone =
fixes
     alloc :: mname and free :: mname and make1 :: mname and make3 :: mname and
     allocQ :: funame and fill2TEMP :: funame and fill4TEMP :: funame and
     b :: iname and tag :: iname and v0 :: iname and
     freelist :: rname and tl :: rname and
     node :: rname and x :: rname and v1 :: rname and 
     dummyPar :: rname and PARmake::rname and
     allocBODY::"nat expr" and allocQBODY::"nat expr" and freeBODY::"nat expr" and
     fill2BODY::"nat expr" and fill4BODY::"nat expr" and make1BODY::"nat expr" and make3BODY::"nat expr"  and

 (* specific part: for conversion of CloneList.gr *)
     CLONELIST :: cname and
     clone :: mname and fclone :: funame and ff0 :: funame and ff1 :: funame and 
     cloneBODY :: "nat expr" and fcloneBODY  ::"nat expr"  and ff0BODY  ::"nat expr"  and ff1BODY  ::"nat expr" 
     and cloneb :: iname and clonetempf0 :: rname and clonetempf1 :: rname and
     clonev1 :: rname and clonev2 :: iname and clonezero :: iname and  cloneone :: iname and

     myContext :: "nat vdmcontext" 
defines 
       frbd[simp]: "freeBODY == (LET rf freelist = GetFr flp DollarF;
                                       _ = PutFr param DollarN freelist
                                     IN PutFr flp DollarF param
                                    END)::nat expr "
       and alcbd[simp]: "allocBODY == (LET rf freelist = GetFr flp DollarF;
                                              b = RPrimop (% r1 r2 . if r1 = Nullref then 1 else 0) freelist freelist
                                      IN IF b THEN (NEW <DIAMOND> ([],[])) ELSE CALL allocQ 
                                      END)::nat expr" 
       and alcqbd[simp]: "allocQBODY == (LET rf tl = GetFr freelist DollarN;
                                                _ = PutFr flp DollarF tl
                                         IN RVar freelist 
                                         END)::nat expr"
       and fl2bd[simp]: "fill2BODY == (LET _ = PutFi x Dollar tag IN RVar x END)::nat expr"
       and fl4bd[simp]: "fill4BODY == (LET _ = PutFi x Dollar tag;
                                           _ = PutFi x F0 v0;
                                           _ = PutFr x F1 v1
                                       IN RVar x END)::nat expr"
      and mk1bd[simp]: "make1BODY == ( LET rf dummyPar = Null;
                                           rf x = InvokeStatic DIAMOND alloc dummyPar;
                                            tag = GetFi param Dollar
                                       IN CALL fill2TEMP END)::nat expr" 
       and  mk3bd[simp]:"make3BODY == (LET rf dummyPar = Null;
                                          rf x = InvokeStatic DIAMOND alloc dummyPar;
                                             tag = GetFi param Dollar;
                                             v0 = GetFi param F0;
                                          rf v1 = GetFr param F1
                                     IN CALL fill4TEMP END)::nat expr"
 and fclbd[simp]:"fcloneBODY == (LET clonev2 = GetFi param Dollar;
                         cloneb = Primop (% l1 l2. if l1 =0 then 1 else 0) clonev2 clonev2 
                         IN IF cloneb THEN CALL ff0 ELSE CALL ff1
                         END) :: nat expr"
    and f1bd[simp]:"ff1BODY == (LET    clonev2 = GetFi param F0;
                        rf  clonev1 = GetFr param F1;
                                 _  = InvokeStatic DIAMOND free param;
                        rf    param =  InvokeStatic CLONELIST clone clonev1;
                           cloneone = expr.Int 1;
                           _   = PutFi PARmake Dollar cloneone;
                           _   = PutFi PARmake F0  clonev2; 
                           _   = PutFr PARmake F1  param;
                        rf clonetempf0 = InvokeStatic DIAMOND make3 PARmake
                    IN RVar clonetempf0
                    END) :: nat expr"
   and f0bd[simp]:"ff0BODY == ( LET _  = InvokeStatic DIAMOND free param;
                                   clonezero = expr.Int 0;
                                   _   = PutFi PARmake Dollar clonezero;
                                  rf clonetempf1 = InvokeStatic DIAMOND make1 PARmake
                     IN RVar clonetempf1 
                     END) :: nat expr"
   and clbd[simp]: "cloneBODY == ( CALL fclone ) :: nat expr"

   and "myContext == {((InvokeStatic DIAMOND  alloc dummyPar)::nat expr, Mspectable DIAMOND alloc), 
                      ((InvokeStatic DIAMOND free param)::nat expr,  Mspectable DIAMOND free), 
                      ((InvokeStatic DIAMOND make1 PARmake)::nat expr, Mspectable DIAMOND make1), 
                      ((InvokeStatic DIAMOND make3 PARmake)::nat expr, Mspectable DIAMOND make3), 
                      ((Call allocQ)::nat expr, spectable allocQ), 
                      ((Call fill2TEMP)::nat expr, spectable fill2TEMP), 
                      ((Call fill4TEMP)::nat expr, spectable fill4TEMP),
                      ((Call fclone)::nat expr, spectable fclone),
                      ((Call ff0)::nat expr, spectable ff0),
                      ((Call ff1)::nat expr, spectable ff1),
                      ((InvokeStatic CLONELIST clone param)::nat expr, Mspectable CLONELIST clone)}"
                           
                         
 assumes FREE[simp]: "methtable DIAMOND free == freeBODY"
       and FREEE[simp]: "funtable freeE == freeEBODY"
       and ALLOC[simp]: "methtable DIAMOND alloc == allocBODY" 
       and ALLOCE[simp]: "funtable allocE == allocEBODY"
       and ALLOCQ[simp]: "funtable allocQ == allocQBODY"
       and FILL2TEMP[simp]: "funtable fill2TEMP == fill2BODY" 
       and FILL4TEMP[simp]: "funtable fill4TEMP == fill4BODY" 
       and MAKE1[simp]: "methtable DIAMOND make1 == make1BODY" 
       and MAKE3[simp]: "methtable DIAMOND make3 == make3BODY"
 (*****************************************************************) 
       and FCLONE[simp]: "funtable fclone == fcloneBODY"
       and FF0[simp]: "funtable ff0 == ff0BODY"
       and FF1[simp]: "funtable ff1 == ff1BODY"
       and CLONE[simp]: "methtable CLONELIST clone == cloneBODY"

(*****************************************************************)
      and spectFill2: "spectable fill2TEMP == {(E, h, hh, v, p). \<forall> loc i. 
                                                                 E\<lfloor>x\<rfloor> = Ref loc \<longrightarrow>
                                                                 E<tag> = i \<longrightarrow>
                                                                 (hh=h<loc\<bullet>Dollar:=i>)}"

     
      and spectFill4: "spectable fill4TEMP == {(E, h, hh, v, p). \<forall> loc i j r. 
                                                                 E\<lfloor>x\<rfloor> = Ref loc \<longrightarrow>
                                                                 E<tag> = i \<longrightarrow> E<v0>=j \<longrightarrow>E\<lfloor>v1\<rfloor>=r \<longrightarrow> 
                                                                 hh = h<loc\<bullet>Dollar:=i><loc\<bullet>F0:=j>\<lfloor>loc\<diamondsuit>F1:=r\<rfloor>}"
    and spectAlloc:
                  "Mspectable DIAMOND alloc == {(E,h,hh,v,p) . \<forall> stloc locout m Y. v= RVal (Ref locout) \<longrightarrow>
                                                             E \<lfloor>flp\<rfloor> = Ref stloc \<longrightarrow> 
                                                            (rheap h DollarF stloc = Nullref  \<longrightarrow>
                                                             locout \<notin> fmap_dom (oheap h) 
                                                             \<and> hh = newObj h locout E DIAMOND [] []
                                                             \<and> rheap hh DollarF stloc = Nullref)
                                                         \<and>  
                                                         (rheap h DollarF stloc = Ref locout \<longrightarrow> 
                                                          stloc \<notin> Y \<longrightarrow> 
                                                         (m,  rheap h DollarF stloc, Y, h) \<in> Freelist \<longrightarrow> 
                                                      hh = \<lparr>oheap = oheap h, iheap = iheap h, 
                                             rheap = (rheap h)(DollarF := (rheap h DollarF)(stloc := h\<lfloor>locout\<diamondsuit>DollarN\<rfloor>))\<rparr>  \<and>
                                            (m-(1::nat),  rheap hh DollarF stloc, Y-{locout}, hh) \<in> Freelist)}"
                                  
         
      and spectMake1:
           "Mspectable DIAMOND make1 == {(E,h,hh,v,p). 
                                           \<forall> floc m Y hloc.  (E\<lfloor>flp\<rfloor> = Ref floc \<longrightarrow>
                                           (m,  rheap h DollarF floc, Y, h) \<in> Freelist \<longrightarrow> 
                                           (rheap h DollarF floc = Nullref \<longrightarrow> (HSize hh = (HSize h)+1))  \<and> 
                                           (rheap h DollarF floc = (Ref hloc) \<longrightarrow>  
                              (HSize hh = HSize h) \<and> (m-(1::nat),  rheap hh DollarF floc, Y-{hloc}, hh) \<in> Freelist))}"

     and spectMake3:
           "Mspectable DIAMOND make3 == {(E,h,hh,v,p). 
                                           \<forall> floc m Y hloc.  (E\<lfloor>flp\<rfloor> = Ref floc \<longrightarrow>
                                           (m,  rheap h DollarF floc, Y, h) \<in> Freelist \<longrightarrow> 
                                           (rheap h DollarF floc = Nullref \<longrightarrow> (HSize hh = (HSize h)+1))  \<and> 
                                           (rheap h DollarF floc = (Ref hloc) \<longrightarrow>  
                              (HSize hh = HSize h) \<and> (m-(1::nat),  rheap hh DollarF floc, Y-{hloc}, hh) \<in> Freelist))}"

    and spectFree:
          "Mspectable DIAMOND free == {(E,h,hh,v,p). \<forall> floc m Y loc. 
                                                         ( E\<lfloor>flp\<rfloor> = Ref floc \<longrightarrow>
                                                         (m, rheap h DollarF floc, Y, h) \<in> Freelist \<longrightarrow> 
                                                          E\<lfloor>node\<rfloor>  = Ref loc \<longrightarrow> 
                                                   (m+(1::nat), rheap hh DollarF floc, Y\<union> {loc} , hh) \<in> Freelist)}"
     and spectClone:"Mspectable CLONELIST  clone == 
               {(E,h,hh,v,p) . \<forall> loc X Ups Y m q loc' X' Ups' floc. 
                              (E\<lfloor>clonev1\<rfloor> = Ref loc) \<longrightarrow>
                              (Ups, loc, X, h) \<in> LocLength \<longrightarrow> 
                              (E\<lfloor>flp \<rfloor> = Ref floc)  \<longrightarrow>
                               floc \<notin> X \<longrightarrow>
                               X \<inter> Y ={} \<longrightarrow>
                               (m,  rheap h DollarF floc, Y, h) \<in> Freelist \<longrightarrow>
                               (0::nat) + 0 * Ups + q \<le> m  \<longrightarrow> 
                                (v = RVal (Ref loc')) \<longrightarrow> 
                                (Ups', loc', X', hh) \<in> LocLength \<longrightarrow> 
                                 ((HSize h)+2) = (HSize hh)  \<and>  floc \<notin> X' \<and>
                                 (\<exists> m' Y'.  X' \<inter> Y'={} \<and> (m', rheap hh DollarF floc , Y', hh) \<in> Freelist \<and> 
                                  (0::nat) + 0 * Ups' + q \<le> m')}" 

and alldistinct: "distinct[flp,freelist,tl,node,x,v1,dummyPar,self, param, PARmake, clonev1] \<and>
                         distinct[clonev1, PARmake, param,self,dummyPar,v1,x,node,tl,freelist,flp] \<and>
                         distinct[b,tag,v0, cloneb, cloneone, clonev2] \<and> 
                         distinct[clonev2, cloneone, cloneb, v0,tag,b] \<and>
                         distinct[DollarF, DollarN, F1] \<and> distinct[F1,DollarN,DollarF] \<and>
                         distinct[Dollar, F0] \<and> distinct[F0,Dollar] \<and>
                         distinct[CLONELIST, DIAMOND] \<and> 
                         distinct[DIAMOND, CLONELIST] \<and>
                         distinct[make1, make3, free, alloc] \<and>
                         distinct[alloc, free, make3, make1] \<and>
                         distinct[fill2TEMP, fill4TEMP, allocQ] \<and>
                         distinct[allocQ, fill4TEMP, fill2TEMP]"
                         
and typing[simp] : "\<forall> E h l C . (qach_QaQ E h l flp C \<longrightarrow> C = DIAMOND)"

declare obj_ifieldupdate_def [simp]
declare obj_rfieldupdate_def [simp]
declare ivarupdate_def [simp]
declare rvarupdate_def [simp]
declare ienv_fct_def [simp]
declare renv_fct_def [simp]
declare emptyi_def [simp]
declare emptyr_def [simp]


lemma (in DiamondClone) fill2abstr[simp]: " \<rhd> ((CALL fill2TEMP)::nat expr) : spectable fill2TEMP" 
apply (rule vdm_call)
apply (simp only: FILL2TEMP) 
apply (simp only: fl2bd)
apply (rule vdm_conseq) 
apply (rule vdm_letv, rule vdm_putfi) 
apply (rule vdm_rvar) 
(* end of VCG *)
apply (simp only: spectFill2)
apply (insert alldistinct)
apply clarsimp
done

lemma (in DiamondClone) fill4abstr[simp]: " \<rhd> ((CALL fill4TEMP)::nat expr) : spectable fill4TEMP" 
apply (rule vdm_call)
apply (simp only: FILL4TEMP) 
apply (simp only: fl4bd)
apply (rule vdm_conseq) 
apply (rule vdm_letv, rule vdm_putfi) 
apply (rule vdm_letv, rule vdm_putfi)
apply (rule vdm_letv, rule vdm_putfr)
apply (rule vdm_rvar) 
(* end of VCG *)
apply (simp only: spectFill4)
apply (insert alldistinct)
apply clarsimp
done

lemma (in DiamondClone) allocFalseTest:"\<rhd> ((InvokeStatic DIAMOND  alloc dummyPar)::nat expr) : {(E, h, hh, v, p). False}"
apply (rule vdm_invokestatic_o) 
apply (simp only: ALLOC)
apply (simp only: alcbd)
apply (rule vdm_conseq)
apply (rule vdm_letr) apply (rule vdm_getfr)
apply (rule vdm_leti) apply (rule vdm_rprim)
apply (rule vdm_if)
apply (rule vdm_new)
apply (rule vdm_callmh)
apply (simp only: ALLOCQ) 
apply (simp only: alcqbd)
apply (rule vdm_letr, rule vdm_getfr)
apply (rule vdm_letv, rule vdm_putfr) 
apply (rule vdm_rvar)
(* end of VCG *)
apply (unfold newframe_env_o_def)
apply (insert alldistinct)
apply clarsimp
oops

lemma newLoc: " freshloc (fmap_dom (oheap h)) \<in> fmap_dom (oheap h) \<Longrightarrow> False"
apply (subgoal_tac "freshloc (fmap_dom (oheap h)) \<notin> fmap_dom (oheap h)")
apply force
apply (rule freshloc)
apply (rule finite_dom_fmap)
done

lemma (in DiamondClone) allocSpec1:"\<rhd> ((InvokeStatic DIAMOND  alloc arg)::nat expr) :  
                                                       {(E,h,hh,v,p) . \<forall> stloc locout. v= RVal (Ref locout) \<longrightarrow>
                                                             E \<lfloor>flp\<rfloor> = Ref stloc \<longrightarrow> 
                                                             rheap h DollarF stloc = Nullref  \<longrightarrow>
                                                             locout \<notin> fmap_dom (oheap h) 
                                                             \<and> hh = newObj h locout E DIAMOND [] []
                                                             \<and> rheap hh DollarF stloc = Nullref}"
apply (rule vdm_invokestatic_o) 
apply (simp only: ALLOC)
apply (simp only: alcbd)
apply (rule vdm_conseq)
apply (rule vdm_letr) apply (rule vdm_getfr)
apply (rule vdm_leti) apply (rule vdm_rprim)
apply (rule vdm_if)
apply (rule vdm_new)
apply (rule vdm_callmh)
apply (simp only: ALLOCQ) 
apply (simp only: alcqbd)
apply (rule vdm_letr, rule vdm_getfr)
apply (rule vdm_letv, rule vdm_putfr) 
apply (rule vdm_rvar)
(* end of VCG *)
apply (unfold newframe_env_o_def)
apply clarify
apply (rule conjI)
apply clarsimp
apply (rule_tac h="aa" in newLoc)
apply assumption
apply clarsimp
apply (rule conjI)
apply (unfold newObj_def)
apply simp
apply simp
done


lemma (in DiamondClone) allocSpec21:"\<rhd> ((InvokeStatic DIAMOND  alloc arg)::nat expr) :  
                                                       {(E,h,hh,v,p) . \<forall> stloc locout hloc. v= RVal (Ref locout) \<longrightarrow>
                                                          E \<lfloor>flp\<rfloor> = Ref stloc \<longrightarrow> 
                                                          rheap h DollarF stloc = Ref hloc \<longrightarrow> hloc=locout}"
apply (rule vdm_invokestatic_o) 
apply (simp only: ALLOC)
apply (simp only: alcbd)
apply (rule vdm_conseq)
apply (rule vdm_letr) apply (rule vdm_getfr)
apply (rule vdm_leti) apply (rule vdm_rprim)
apply (rule vdm_if)
apply (rule vdm_new)
apply (rule vdm_callmh)
apply (simp only: ALLOCQ) 
apply (simp only: alcqbd)
apply (rule vdm_letr, rule vdm_getfr)
apply (rule vdm_letv, rule vdm_putfr) 
apply (rule vdm_rvar)
(* end of VCG *)
apply (unfold newframe_env_o_def)
apply clarify
apply simp
apply clarify
apply (subgoal_tac "freelist~= tl")
apply (subgoal_tac "flp~=tl")
apply simp
apply (insert alldistinct)
apply simp
apply simp
done

lemma (in DiamondClone) allocSpec22:"\<rhd> ((InvokeStatic DIAMOND  alloc arg)::nat expr) :  
                                                       {(E,h,hh,v,p) . \<forall> stloc locout hloc. 
                                                          E \<lfloor>flp\<rfloor> = Ref stloc \<longrightarrow>   rheap h DollarF stloc = Ref hloc  \<longrightarrow>
                                                        hh = \<lparr>oheap = oheap h, iheap = iheap h, 
                                                   rheap = (rheap h)(DollarF := (rheap h DollarF)(stloc := h\<lfloor>hloc\<diamondsuit>DollarN\<rfloor>))\<rparr> }"
apply (rule vdm_invokestatic_o) 
apply (simp only: ALLOC)
apply (simp only: alcbd)
apply (rule vdm_conseq)
apply (rule vdm_letr) apply (rule vdm_getfr)
apply (rule vdm_leti) apply (rule vdm_rprim)
apply (rule vdm_if)
apply (rule vdm_new)
apply (rule vdm_callmh)
apply (simp only: ALLOCQ) 
apply (simp only: alcqbd)
apply (rule vdm_letr, rule vdm_getfr)
apply (rule vdm_letv, rule vdm_putfr) 
apply (rule vdm_rvar)
(* end of VCG *)
apply (unfold newframe_env_o_def)
apply clarify
apply simp
apply clarify
apply (subgoal_tac "flp~=tl")
apply simp
apply (subgoal_tac "a=stloc")
apply simp
apply (subgoal_tac "flp~=freelist")
apply simp
apply (insert alldistinct)
apply simp
apply simp
done

lemma (in DiamondClone) allocSpec23:"\<rhd> ((InvokeStatic DIAMOND  alloc arg)::nat expr) :  
                                                       {(E,h,hh,v,p) . \<forall> stloc hloc Y. 
                                                        E \<lfloor>flp\<rfloor> = Ref stloc \<longrightarrow>  
                                                        stloc \<notin> Y \<longrightarrow>   
                                                        rheap h DollarF stloc = Ref hloc  \<longrightarrow>
                                                        (m,  rheap h DollarF stloc, Y, h) \<in> Freelist \<longrightarrow>
                                                        (m-(1::nat),  rheap hh DollarF stloc, Y-{hloc}, hh) \<in> Freelist}"
apply (rule vdm_invokestatic_o) 
apply (simp only: ALLOC)
apply (simp only: alcbd)
apply (rule vdm_conseq)
apply (rule vdm_letr) apply (rule vdm_getfr)
apply (rule vdm_leti) apply (rule vdm_rprim)
apply (rule vdm_if)
apply (rule vdm_new)
apply (rule vdm_callmh)
apply (simp only: ALLOCQ) 
apply (simp only: alcqbd)
apply (rule vdm_letr, rule vdm_getfr)
apply (rule vdm_letv, rule vdm_putfr) 
apply (rule vdm_rvar)
(* end of VCG *)
apply (unfold newframe_env_o_def)
apply clarify
apply simp
apply clarify
apply (subgoal_tac "flp~=tl")
apply simp
apply (subgoal_tac "flp~=freelist ")
apply simp
apply (rule_tac stloc="a" and X="Y" and h="aa" and hloc="hloc" in flistDecr2)
apply assumption
apply assumption      
apply assumption 
apply simp
apply (insert alldistinct)
apply simp
apply simp
done

(****************************************************************************************)

lemma myUnionLeft: "{a}\<union> B= insert a B"
apply simp
done

lemma myUnionRight: "B\<union> {a}= insert a B"
apply simp
done

lemma (in DiamondClone) cloneNonter: "{(((InvokeStatic DIAMOND make1 PARmake)::nat expr), Mspectable DIAMOND make1),
                                       (((InvokeStatic DIAMOND make3 PARmake)::nat expr), Mspectable DIAMOND make3),
                                       (((InvokeStatic DIAMOND  free param)::nat expr), Mspectable DIAMOND free)}
                                         \<rhd> ((InvokeStatic CLONELIST clone clonev1):: nat expr) : 
                                      {(E, h, hh, v, p). False}"
apply (rule vdm_invokestatic_o) 
apply (simp only: CLONE) apply (simp only: clbd) apply (simp only: myUnionLeft)
apply (rule vdm_conseq) 
apply (rule vdm_callmh) 
apply (simp only: FCLONE) apply (simp only: fclbd) apply (simp only: myUnionRight)
apply (rule vdm_leti) apply (rule vdm_getfi) 
apply (rule vdm_leti, rule vdm_prim) 
apply (rule vdm_if) 
apply (rule vdm_callmh) 
apply (simp only: FF0) apply (simp only: f0bd) apply (simp only: myUnionRight)
apply (rule vdm_letv) apply (rule vdm_ax)
apply (rule insertI2)
apply (rule insertI2)
apply (rule insertI2)
apply (rule insertI2)
apply (rule insertI2)
apply (rule insertI1)
apply (rule vdm_leti, rule vdm_int) 
apply (rule vdm_letv, rule vdm_putfi) 
apply (rule vdm_letr) apply (rule vdm_ax) 
apply (rule insertI2)
apply (rule insertI2)
apply (rule insertI2)
apply (rule insertI1)
apply (rule vdm_rvar) 
apply (rule vdm_callmh) 
apply (simp only: FF1) apply (simp only: f1bd) apply (simp only: myUnionRight)
apply (rule vdm_leti, rule vdm_getfi) 
apply (rule vdm_letr, rule vdm_getfr) 
apply (rule vdm_letv) apply (rule vdm_ax) 
apply (rule insertI2)
apply (rule insertI2)
apply (rule insertI2)
apply (rule insertI2)
apply (rule insertI2)
apply (rule insertI1)
apply (rule vdm_letr)
apply (rule vdm_ax) 
apply (rule insertI2)
apply (rule insertI2)
apply (rule insertI1)
apply (rule vdm_leti, rule vdm_int) 
apply (rule vdm_letv, rule vdm_putfi) 
apply (rule vdm_letv, rule vdm_putfi) 
apply (rule vdm_letv, rule vdm_putfr)
apply (rule vdm_letr) apply (rule vdm_ax) 
apply (rule insertI2)
apply (rule insertI2)
apply (rule insertI2)
apply (rule insertI2)
apply (rule insertI1)
apply (rule vdm_rvar)
(******** end of VCG ********************)
apply (clarify)
apply simp
apply clarify
(******** why make3 dissappear ? ****)
apply (simp only: spectFree)
apply (simp only: spectMake1)
apply clarify
apply simp
oops

lemma (in DiamondClone) specCloneLight:
"{(((InvokeStatic DIAMOND make1 PARmake)::nat expr), Mspectable DIAMOND make1),
  (((InvokeStatic DIAMOND make3 PARmake)::nat expr), Mspectable DIAMOND make3),
  (((InvokeStatic DIAMOND  free param)::nat expr), Mspectable DIAMOND free)}
   \<rhd> ((InvokeStatic CLONELIST clone clonev1):: nat expr) : {(E,h,hh,v,p) . \<forall> Y m q floc. 
                              (E\<lfloor>flp \<rfloor> = Ref floc)  \<longrightarrow>
                               (m,  rheap h DollarF floc, Y, h) \<in> Freelist \<longrightarrow>
                               (0::nat) + 0  + q \<le> m  \<longrightarrow> 
                                 (\<exists> m' Y'.  (m', rheap hh DollarF floc , Y', hh) \<in> Freelist \<and> 
                                  (0::nat) + 0 + q \<le> m')}"
apply (rule vdm_invokestatic_o) 
apply (simp only: CLONE) apply (simp only: clbd) apply (simp only: myUnionLeft)
apply (rule vdm_conseq) 
apply (rule vdm_callmh) 
apply (simp only: FCLONE) apply (simp only: fclbd) apply (simp only: myUnionRight)
apply (rule vdm_leti) apply (rule vdm_getfi) 
apply (rule vdm_leti, rule vdm_prim) 
apply (rule vdm_if) 
apply (rule vdm_callmh) 
apply (simp only: FF0) apply (simp only: f0bd) apply (simp only: myUnionRight)
apply (rule vdm_letv) apply (rule vdm_ax)
apply (rule insertI2)
apply (rule insertI2)
apply (rule insertI2)
apply (rule insertI2)
apply (rule insertI2)
apply (rule insertI1)
apply (rule vdm_leti, rule vdm_int) 
apply (rule vdm_letv, rule vdm_putfi) 
apply (rule vdm_letr) apply (rule vdm_ax) 
apply (rule insertI2)
apply (rule insertI2)
apply (rule insertI2)
apply (rule insertI1)
apply (rule vdm_rvar) 
apply (rule vdm_callmh) 
apply (simp only: FF1) apply (simp only: f1bd) apply (simp only: myUnionRight)
apply (rule vdm_leti, rule vdm_getfi) 
apply (rule vdm_letr, rule vdm_getfr) 
apply (rule vdm_letv) apply (rule vdm_ax) 
apply (rule insertI2)
apply (rule insertI2)
apply (rule insertI2)
apply (rule insertI2)
apply (rule insertI2)
apply (rule insertI1)
apply (rule vdm_letr)
apply (rule vdm_ax) 
apply (rule insertI2)
apply (rule insertI2)
apply (rule insertI1)
apply (rule vdm_leti, rule vdm_int) 
apply (rule vdm_letv, rule vdm_putfi) 
apply (rule vdm_letv, rule vdm_putfi) 
apply (rule vdm_letv, rule vdm_putfr)
apply (rule vdm_letr) apply (rule vdm_ax) 
apply (rule insertI2)
apply (rule insertI2)
apply (rule insertI2)
apply (rule insertI2)
apply (rule insertI1)
apply (rule vdm_rvar)
(******** end of VCG ********************)
apply (clarify)
apply simp
(******** OK: all methspecs are here ****)

apply (simp only: spectFree)
apply (simp only: spectMake1)
apply (simp only: spectMake3)
apply simp

(*apply (simp add: FLDollarNRelsewhere FLF0 FLDollar FLF1 FLDollar)*)


apply (insert FLDollarNRelsewhereClassic
              FLF0classic
              FLDollarClassic
              FLF1Classic
              FLDollarFClassic)
apply clarsimp
oops
(*apply (force)
apply (insert alldistinct)
apply clarsimp *)


(*

lemma (in DiamondClone) specCloneSuperLight:
"{(((InvokeStatic DIAMOND make1 PARmake)::nat expr),  {(E,h,hh,v,p) . \<forall> floc hloc m Y.
                                                      (E\<lfloor>flp \<rfloor> = Ref floc)  \<longrightarrow> 
                                                       rheap h DollarF floc = Ref hloc \<longrightarrow> floc \<notin> Y  \<longrightarrow> 
                                                      (m, Ref hloc, Y, h) \<in> Freelist \<longrightarrow> 
                                                      (m-Suc 0 , rheap hh DollarN hloc, Y-{hloc}, hh) \<in> Freelist}),
  (((InvokeStatic DIAMOND make3 PARmake)::nat expr), {(E,h,hh,v,p) . \<forall> floc hloc m Y.
                                                      (E\<lfloor>flp \<rfloor> = Ref floc)  \<longrightarrow> 
                                                       rheap h DollarF floc = Ref hloc \<longrightarrow> floc \<notin> Y  \<longrightarrow> 
                                                      (m, Ref hloc, Y, h) \<in> Freelist \<longrightarrow> 
                                                      (m - Suc 0, rheap hh DollarN hloc, Y-{hloc}, hh) \<in> Freelist}),
  (((InvokeStatic DIAMOND  free param)::nat expr), {(E,h,hh,v,p) . \<forall> floc loc m Y.
                                                      (E\<lfloor>flp \<rfloor> = Ref floc)  \<longrightarrow> floc \<notin> Y  \<longrightarrow>   
                                                       E\<lfloor>param \<rfloor> = Ref loc \<longrightarrow> 
                                                      (m, rheap h DollarF floc, Y, h) \<in> Freelist \<longrightarrow> 
                                                      (m + Suc 0, Ref loc, Y\<union>{loc}, hh) \<in> Freelist})}
   \<rhd> ((InvokeStatic CLONELIST clone clonev1):: nat expr) : {(E,h,hh,v,p) .\<forall> floc hloc m Y.
                              (E\<lfloor>flp \<rfloor> = Ref floc)  \<longrightarrow> rheap h DollarF floc = Ref hloc \<longrightarrow> floc \<notin> Y \<longrightarrow>  
                               (m, Ref hloc , Y, h) \<in> Freelist \<longrightarrow> 
                                 (m, Ref hloc , Y, hh) \<in> Freelist}"

apply (rule vdm_invokestatic_o) 
apply (simp only: CLONE) apply (simp only: clbd) apply (simp only: myUnionLeft)

apply (rule vdm_conseq)
prefer 2
apply clarify
defer 1

apply (rule vdm_callmh) 
apply (simp only: FCLONE) apply (simp only: fclbd) apply (simp only: myUnionRight)

apply (rule vdm_leti) apply (rule vdm_getfi) 
prefer 2
apply clarify
defer 1


apply (rule vdm_leti, rule vdm_prim) 
prefer 2
apply clarify
defer 1


apply (rule vdm_if) 
prefer 3
apply clarify
defer 1

apply (rule vdm_callmh)
prefer 3
apply safe
defer 1
defer 1
defer 1
defer 1
 
apply (simp only: FF0) apply (simp only: f0bd) apply (simp only: myUnionRight)
apply (rule vdm_letv) apply (rule vdm_ax)
apply (rule insertI2)
apply (rule insertI2)
apply (rule insertI2)
apply (rule insertI2)
apply (rule insertI2)
apply (rule insertI1)

prefer 3
apply clarify
defer 1

prefer 3
apply clarify
defer 1


prefer 3
defer 1

prefer 3
apply clarify
defer 1


apply (rule vdm_leti, rule vdm_int)
prefer 3
apply clarify
defer 1

prefer 3
apply clarify
defer 1


prefer 3
defer 1


prefer 3
apply clarify
defer 1

 
apply (rule vdm_letv, rule vdm_putfi)
prefer 3
apply clarify
defer 1

prefer 3
apply clarify
defer 1


prefer 3
defer 1


prefer 3
apply clarify
defer 1

apply (rule vdm_letr) apply (rule vdm_ax) 
apply (rule insertI2)
apply (rule insertI2)
apply (rule insertI2)
apply (rule insertI1)
apply (rule vdm_rvar)

prefer 2
apply clarsimp
apply (simp only: newframe_env_o_def)
apply (simp)
apply (subgoal_tac " PARmake ~= flp")
defer 2
apply simp
apply (subgoal_tac " PARmake ~= param")
defer 2
apply simp
apply (subgoal_tac "param ~= flp")
defer 2
apply simp
apply (subgoal_tac "PARmake ~=self")
defer 2
apply simp


prefer 2
apply clarify
prefer 2


prefer 4
apply clarify
prefer 2
 
apply (rule vdm_callmh) 
prefer 2
apply clarify
prefer 2




apply (simp only: FF1) apply (simp only: f1bd) apply (simp only: myUnionRight)
apply (rule vdm_leti, rule vdm_getfi) 
apply (rule vdm_letr, rule vdm_getfr) 
apply (rule vdm_letv) apply (rule vdm_ax) 
apply (rule insertI2)
apply (rule insertI2)
apply (rule insertI2)
apply (rule insertI2)
apply (rule insertI2)
apply (rule insertI1)
apply (rule vdm_letr)
apply (rule vdm_ax) 
apply (rule insertI2)
apply (rule insertI2)
apply (rule insertI1)
apply (rule vdm_leti, rule vdm_int) 
apply (rule vdm_letv, rule vdm_putfi) 
apply (rule vdm_letv, rule vdm_putfi) 
apply (rule vdm_letv, rule vdm_putfr)
apply (rule vdm_letr) apply (rule vdm_ax) 
apply (rule insertI2)
apply (rule insertI2)
apply (rule insertI2)
apply (rule insertI2)
apply (rule insertI1)
apply (rule vdm_rvar)


apply (rule subsetI) 
apply (simp only: mem_Collect_eq)
apply simp
apply (insert alldistinct)
apply clarsimp

apply blast



apply (insert FLDollarNRelsewhereClassic
              FLF0classic
              FLDollarClassic
              FLF1Classic
              FLDollarFClassic)
apply clarsimp
apply force

*)

lemma (in DiamondClone) specCloneSuperLight:
"{(((InvokeStatic DIAMOND make1 PARmake)::nat expr),  {(E,h,hh,v,p) . \<forall> floc hloc m Y.
                                                      (E\<lfloor>flp \<rfloor> = Ref floc)  \<longrightarrow> 
                                                       rheap h DollarF floc = Ref hloc \<longrightarrow> floc \<notin> Y  \<longrightarrow> 
                                                      (m, Ref hloc, Y, h) \<in> Freelist \<longrightarrow> 
                                                      (m-Suc 0 , rheap hh DollarN hloc, Y-{hloc}, hh) \<in> Freelist}),
  (((InvokeStatic DIAMOND make3 PARmake)::nat expr), {(E,h,hh,v,p) . \<forall> floc hloc m Y.
                                                      (E\<lfloor>flp \<rfloor> = Ref floc)  \<longrightarrow> 
                                                       rheap h DollarF floc = Ref hloc \<longrightarrow> floc \<notin> Y  \<longrightarrow> 
                                                      (m, Ref hloc, Y, h) \<in> Freelist \<longrightarrow> 
                                                      (m - Suc 0, rheap hh DollarN hloc, Y-{hloc}, hh) \<in> Freelist}),
  (((InvokeStatic DIAMOND  free param)::nat expr), {(E,h,hh,v,p) . \<forall> floc loc m Y.
                                                      (E\<lfloor>flp \<rfloor> = Ref floc)  \<longrightarrow> floc \<notin> Y  \<longrightarrow>   
                                                       E\<lfloor>param \<rfloor> = Ref loc \<longrightarrow> 
                                                      (m, rheap h DollarF floc, Y, h) \<in> Freelist \<longrightarrow> 
                                                      (m + Suc 0, Ref loc, Y\<union>{loc}, hh) \<in> Freelist})}
   \<rhd> ((InvokeStatic CLONELIST clone clonev1):: nat expr) : {(E,h,hh,v,p) .\<forall> floc hloc m Y.
                              (E\<lfloor>flp \<rfloor> = Ref floc)  \<longrightarrow> rheap h DollarF floc = Ref hloc \<longrightarrow> floc \<notin> Y \<longrightarrow>  
                               (m, Ref hloc , Y, h) \<in> Freelist \<longrightarrow> 
                                 (m, Ref hloc , Y, hh) \<in> Freelist}"

apply (rule vdm_invokestatic_o) 
apply (simp only: CLONE) apply (simp only: clbd) apply (simp only: myUnionLeft)
apply (rule vdm_conseq)
apply (rule vdm_callmh) 
apply (simp only: FCLONE) apply (simp only: fclbd) apply (simp only: myUnionRight)
apply (rule vdm_leti) apply (rule vdm_getfi) 
apply (rule vdm_leti, rule vdm_prim) 
apply (rule vdm_if) 
apply (rule vdm_callmh)
apply (simp only: FF0) apply (simp only: f0bd) apply (simp only: myUnionRight)
apply (rule vdm_letv) apply (rule vdm_ax)
apply (rule insertI2)
apply (rule insertI2)
apply (rule insertI2)
apply (rule insertI2)
apply (rule insertI2)
apply (rule insertI1)
apply (rule vdm_leti, rule vdm_int)
apply (rule vdm_letv, rule vdm_putfi)
apply (rule vdm_letr) apply (rule vdm_ax) 
apply (rule insertI2)
apply (rule insertI2)
apply (rule insertI2)
apply (rule insertI1)
apply (rule vdm_rvar)
apply (rule vdm_callmh) 
apply (simp only: FF1) apply (simp only: f1bd) apply (simp only: myUnionRight)
apply (rule vdm_leti, rule vdm_getfi) 
apply (rule vdm_letr, rule vdm_getfr) 
apply (rule vdm_letv) apply (rule vdm_ax) 
apply (rule insertI2)
apply (rule insertI2)
apply (rule insertI2)
apply (rule insertI2)
apply (rule insertI2)
apply (rule insertI1)
apply (rule vdm_letr)
apply (rule vdm_ax) 
apply (rule insertI2)
apply (rule insertI2)
apply (rule insertI1)
apply (rule vdm_leti, rule vdm_int) 
apply (rule vdm_letv, rule vdm_putfi) 
apply (rule vdm_letv, rule vdm_putfi) 
apply (rule vdm_letv, rule vdm_putfr)
apply (rule vdm_letr) apply (rule vdm_ax) 
apply (rule insertI2)
apply (rule insertI2)
apply (rule insertI2)
apply (rule insertI2)
apply (rule insertI1)
apply (rule vdm_rvar)
(******** end of VCG ***************)

apply (rule subsetI)
(* apply clarify *)
apply (unfold newframe_env_o_def)
apply (insert alldistinct)
apply safe (* we need splitting because of if cases *)
apply (simp_all)
done