(* 				 
   File:	$RCSfile: VDM2.thy,v $
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: VDM2.thy,v 1.1 2003/11/18 11:30:32 a1hloidl Exp $

   VDM-style rules for the program logic.
   Version with modified contexts and assertions to make substitution easier.
*)

theory VDM2 = Semantics + Lemmas:

consts all_classes :: "cname set"

axioms finclasses: "\<forall> (C::cname). C \<in> all_classes \<and> finite all_classes"

(*derivation system for VDM*)

section {* Basic types *}

types
  "vdmassn" = "(env \<times> heap \<times> heap \<times> val \<times> renv) set"

types
  "vdmaaassn" = "rname \<Rightarrow> rname \<Rightarrow> vdmassn"

types
  'a vdmtuple = "'a expr \<times> vdmassn"

types
  'a vdmaatuple = "rname \<Rightarrow> rname \<Rightarrow> 'a vdmtuple"

(* EXPERIMENTAL version:
   contexts are sets of lambda-abstractions over object and param, yielding a
   tuple of expression and assertion;
   this way, no explicit substitution is needed when pulling the specification of
   a method out of the context; instead, it suffices to apply the abstraction to
   the concrete object and parameter;
   the invoke rules have to construct the abstraction and put it into the context
   the axiom rule has to instantiate it 
*)
types
  'a vdmcontext = "('a vdmaatuple) set"

consts vdm_proof :: "('a vdmcontext \<times> 'a expr \<times> vdmassn) set"

syntax
  vdm_deriv :: "'a vdmcontext \<Rightarrow> 'a expr \<Rightarrow> vdmaaassn \<Rightarrow> bool"
		  ("_ \<rhd>  _ : _ " [900,100,100] 50)

translations
 "G \<rhd> e : P" == "(G,e,P) \<in> vdm_proof"

syntax
  vdm_emptyctx :: "'a expr \<Rightarrow> vdmaaassn \<Rightarrow> bool" ("\<rhd> _ : _ " 40)
translations
  "\<rhd> e : P " == "{} \<rhd> e : P"

(* --------------------------------------------------------------------------- *)
(* ToDo: move this into a separate file and sort out dependencies *)

section {* Aux functions and lemmas for context adaptation *}

subsection {* Well-structured heaps etc *}

(* well-structured heap (qach_QaQ) means "in an environment E and heap h, the
   r-variable points to location a in the heap, where we find an object of class C" *)
constdefs qach_QaQ :: "env \<Rightarrow> heap \<Rightarrow> locn \<Rightarrow> rname \<Rightarrow> cname \<Rightarrow> bool"
 "qach_QaQ E h a x C == (E\<lfloor>x\<rfloor> = Ref a \<and> (fmap_lookup (heap.oheap h) a = Some C))" 

subsection {* Substitutions on assertions *}

text {* 
Substitutions on assertions are needed to adapt assertions in context to the body
when we meet a recursive call. Since we use a shallow embedding of assertions, all
we have to do is to modify the environment to take the substituter instead of the
substitee. Since we only need this to substitute argument for formal parameter,
we only have to define the case of substituting rname for rname.
*}

constdefs subst :: "vdmassn \<Rightarrow> rname \<Rightarrow> rname \<Rightarrow> vdmassn"
"subst P y x == {(E',h,hh,v,p). (\<exists> E. E' = E\<lfloor>x := E\<lfloor>y\<rfloor>\<rfloor> \<and> (E,h,hh,v,p) \<in> P)}"

constdefs nuke :: "rname \<Rightarrow> vdmassn \<Rightarrow> vdmassn"
"nuke y P == {(E',h,hh,v,p). (\<exists> E. E' = E\<lfloor>y := Nullref\<rfloor> \<and> (E,h,hh,v,p) \<in> P)}"

(*
lemma bonzo3_TheRevengeOfTheSubstitutor: "distinct [x,y] \<Longrightarrow>
 \<forall> E h hh v p x y P . (E,h,hh,v,p) \<in> P --> 
           (E\<lfloor>x := E\<lfloor>y\<rfloor>\<rfloor>,h,hh,v,p) \<in> subst P y x"
apply clarify
apply (simp add: subst_def)
apply (rule_tac x="E" in exI)
apply clarsimp
done
*)
(*
lemma bonzo_TheGovernor: "distinct [x,y] \<Longrightarrow>
 z : P --> 
 z : (% (E,h,hh,v,p). (E\<lfloor>x := E\<lfloor>y\<rfloor>\<rfloor>,h,hh,v,p)) ` subst P y x"
apply clarify
apply (simp add: subst_def image_def)
*)
(* apply (rule_tac x="E" in exI) *)
(*apply clarsimp
oops
*)


(* --------------------------------------------------------------------------- *)


inductive vdm_proof intros
vdm_conseq: "\<lbrakk>G \<rhd> e : P; P \<subseteq> Q  \<rbrakk> \<Longrightarrow> G \<rhd> e : Q"

vdm_null: "G \<rhd> NULL : {(E,h,hh,v,p). hh = h \<and> v = RVal Nullref \<and> p = tickRo}"

vdm_int: "G \<rhd> expr.Int i : {(E,h,hh,v,p). hh = h \<and> v = IVal i \<and> p = tickRo}"

vdm_ivar: "G \<rhd> IVar x : {(E,h,hh,v,p). hh = h \<and> v = IVal (E<x>) \<and> p = tickRo}"

vdm_rvar: "G \<rhd> RVar x : {(E,h,hh,v,p). hh = h \<and> v = RVal (E\<lfloor>x\<rfloor>) \<and> p = tickRo}"

vdm_prim: "G \<rhd> Primop f x y : {(E,h,hh,v,p) . hh = h \<and> v = IVal (f (E<x>) (E<y>)) \<and> p = \<langle>3 0 0 0\<rangle>}"

vdm_rprim: "G \<rhd> RPrimop f x y : {(E,h,hh,v,p) . hh = h \<and> v = IVal (f (E\<lfloor>x\<rfloor>) (E\<lfloor>y\<rfloor>)) \<and> p = \<langle>3 0 0 0\<rangle>}"

vdm_getfi: "G \<rhd> GetFi x f : {(E,h,hh,v,p) . \<exists> a . E\<lfloor>x\<rfloor> = Ref a \<and> hh = h \<and>  
                                                   v = IVal ((heap.iheap hh) f a) \<and> 
                                                   p = \<langle>2 0 0 0\<rangle>}"
vdm_getfr: "G \<rhd> GetFr x f : {(E,h,hh,v,p) . \<exists> a . E\<lfloor>x\<rfloor> = Ref a \<and> hh = h \<and> 
                                                   v = RVal ((heap.rheap hh) f a) \<and> 
                                                   p = \<langle>2 0 0 0\<rangle>}"

vdm_putfi: "G \<rhd> PutFi x f y : 
            {(E,h,hh,v,p) . \<exists> a . E\<lfloor>x\<rfloor>  = Ref a \<and> hh = h<a\<bullet>f:=E<y>> \<and>
                                  v = arbitrary \<and>  p = \<langle>3 0 0 0\<rangle>}"

vdm_putfr: "G \<rhd> PutFr x f y : 
            {(E,h,hh,v,p) . \<exists> a . E\<lfloor>x\<rfloor>  = Ref a \<and> hh = h\<lfloor>a\<diamondsuit>f:=E\<lfloor>y\<rfloor>\<rfloor> \<and>
                                  v = arbitrary \<and> p = \<langle>3 0 0 0\<rangle>}"

vdm_new: "G \<rhd> New c ifldvals rfldvals :
              {(E,h,hh,v,p) . \<exists> l . l = freshloc (fmap_dom (heap.oheap h)) \<and> 
                                    hh = newObj h l E c ifldvals rfldvals \<and>
                                    v = RVal (Ref l) \<and>
                                    p = tickRo}"

vdm_if: "\<lbrakk>G \<rhd> e1 : P1; G \<rhd> e2 : P2\<rbrakk> \<Longrightarrow> 
         G \<rhd> (IF x THEN e1 ELSE e2) :
           {(E,h,hh,v,p). \<exists> pp. p = tkn 2 pp \<and> 
                               (E<x> = grailbool True \<longrightarrow> (E,h,hh,v,pp) \<in> P1) \<and> 
                               (E<x> = grailbool False \<longrightarrow> (E,h,hh,v,pp) \<in> P2) \<and>
                               (E<x> = grailbool True \<or> E<x> = grailbool False)}"

vdm_leti: "\<lbrakk>G \<rhd> e1 : P1; G \<rhd> e2 : P2\<rbrakk> \<Longrightarrow>
           G \<rhd> (Leti x e1 e2) :
                {(E,h,hh,v,p) . \<exists> p1 p2 h1 i . (E,h,h1,IVal i,p1) \<in> P1  \<and>
                                               (E<x:=i>,h1,hh,v,p2) \<in> P2  \<and>
                                               p = tk (p1 \<smile> p2)}"

vdm_letr: "\<lbrakk>G \<rhd> e1 : P1; G \<rhd> e2 : P2\<rbrakk> \<Longrightarrow>
           G \<rhd> (Letr x e1 e2) :
                {(E,h,hh,v,p) . \<exists> p1 p2 h1 r . (E,h,h1,RVal r,p1) \<in> P1  \<and>
                                               (E\<lfloor>x:=r\<rfloor>,h1,hh,v,p2) \<in> P2  \<and>
                                               p = tk (p1 \<smile> p2)}"

vdm_letv: "\<lbrakk>G \<rhd> e1 : P1; G \<rhd> e2 : P2\<rbrakk> \<Longrightarrow>
           G \<rhd> (Letv e1 e2) :
                {(E,h,hh,v,p) . \<exists> p1 p2 h1 w . (E,h,h1,w,p1) \<in> P1  \<and>
                                               (E,h1,hh,v,p2) \<in> P2  \<and>
                                               p = (p1 \<smile> p2)}"

vdm_call: "\<lbrakk>(G \<union> {(% s b . (Call f,P s b))}) \<rhd> (funtable f) : {(E,h,hh,v,p) . (E,h,hh,v,tkcall p) \<in> P q q'}\<rbrakk> \<Longrightarrow>
           G \<rhd> (Call f) : P q q'"

vdm_mhinvokestatic:
  "\<lbrakk> (G \<union> {(% s b . (MH_InvokeStatic C mn,P s b))}) \<rhd> 
    (methtable C mn) :  
    {(E,h,hh,v,p) . (E,h,hh,v,\<langle>2 0 1 1\<rangle> \<oplus> p) \<in> P q q'} \<rbrakk> \<Longrightarrow>
   G \<rhd> (MH_InvokeStatic C mn) : P q q'"

(* OLD rule; only left in here to ensure some older proofs in VDMderived go through 
vdm_mhinvoke:
  "\<lbrakk> (E'::env)\<lfloor>x\<rfloor> = Ref a ; fmap_lookup (heap.oheap h') a = Some C ;
     (G \<union> {(MH_Invoke x mn,P)}) \<rhd> 
     (methtable C mn) :  
     {(E,h,hh,v,p) . E = E'\<lfloor>self := Ref a\<rfloor> \<and> h = h' \<and> (E',h,hh,v,\<langle>4 0 1 1\<rangle> \<oplus> p) \<in> P} \<rbrakk> \<Longrightarrow>
   G \<rhd> (MH_Invoke x mn) : P"
*)
(* NEW Invoke rule; we need quantification over E' h'
vdm_mhinvoke:
  "\<lbrakk> \<forall> E' h' a C. 
     (qach_QaQ E' h' a x C \<longrightarrow>
      (G \<union> {(MH_Invoke x mn,P)}) \<rhd> 
      (methtable C mn) :  
      {(E,h,hh,v,p) . (E = E'\<lfloor>self := Ref a\<rfloor> \<and> h = h') \<longrightarrow> (E',h,hh,v,\<langle>4 0 1 1\<rangle> \<oplus> p) \<in> P}) \<rbrakk> \<Longrightarrow>
   G \<rhd> (MH_Invoke x mn) : P"
*)

vdm_mhinvoke:
  "\<lbrakk> \<forall> E' h' a C. 
     (qach_QaQ E' h' a x C \<longrightarrow>
      (G \<union> {(% s b . (MH_Invoke s mn,P s b))}) \<rhd> 
      (methtable C mn) :  
      {(E,h,hh,v,p) . (E = E'\<lfloor>self := Ref a\<rfloor> \<and> h = h') \<longrightarrow> (E',h,hh,v,\<langle>4 0 1 1\<rangle> \<oplus> p) \<in> P x q }) \<rbrakk> \<Longrightarrow>
   G \<rhd> (MH_Invoke x mn) : P x q"


vdm_invokestatic:
  "\<lbrakk> (G \<union> {(% s b . (InvokeStatic C mn b,P s b))}) \<rhd> 
    (methtable C mn) :  
    {(E,h,hh,v,p) . \<forall> E'. E = newframe_env Nullref (E'\<lfloor>y\<rfloor>)  \<longrightarrow>
                    (E',h,hh,v,\<langle>3 0 1 1\<rangle> \<oplus> p) \<in> P q y} \<rbrakk> \<Longrightarrow>
   G \<rhd> (InvokeStatic C mn y) : P q y"

vdm_invoke:
  "\<lbrakk> \<forall> E' h' a C. 
     qach_QaQ E' h' a x C \<longrightarrow>
     (G \<union> {(% s b . (Invoke s mn b,P s b))}) \<rhd> 
     (methtable C mn) :  
     {(E,h,hh,v,p) . E = newframe_env (E'\<lfloor>x\<rfloor>) (E'\<lfloor>y\<rfloor>) \<and> h = h' \<longrightarrow>  (E',h,hh,v,\<langle>5 0 1 1\<rangle> \<oplus> p) \<in> P x y } \<rbrakk> \<Longrightarrow>
   G \<rhd> (Invoke x mn y) : P x y"

vdm_ax: "\<lbrakk> t \<in> G ; (e,P) = t s b \<rbrakk> \<Longrightarrow> G \<rhd> e : P"
(* vdm_ax: "\<lbrakk> (e,P) \<in> G \<rbrakk> \<Longrightarrow> G \<rhd> e : P" *) 

subsection {*Semantic validity*}

constdefs  vdm_validn :: "nat \<Rightarrow> 'a expr \<Rightarrow> vdmassn \<Rightarrow> bool"  ("\<Turnstile>\<^sub>_ _ : _" 50)
"\<Turnstile>\<^sub>n e : P \<equiv> (\<forall> m . m \<le> n \<longrightarrow> (\<forall> E h hh v p . ((E \<turnstile> h,e \<Down>m (hh,v,p)) \<longrightarrow> (E,h,hh,v,p) \<in> P)))"
(*
constdefs reccount::"renv \<Rightarrow> nat"
"reccount r == (callc r) + (invkc r)"

constdefs  vdm_validn :: "nat \<Rightarrow> 'a expr \<Rightarrow> vdmassn \<Rightarrow> bool"  ("\<Turnstile>\<^sub>_ _ : _" 50)
"\<Turnstile>\<^sub>n e : P \<equiv> (\<forall> E h hh v p . ((E \<turnstile> h,e \<Down> hh,v,p) \<and> (reccount p = n) \<longrightarrow> (E,h,hh,v,p) \<in> P))"
*)
constdefs  vdm_valid :: "'a expr \<Rightarrow> vdmassn \<Rightarrow> bool"  ("\<Turnstile> _ : _" 50)
"\<Turnstile> e : P \<equiv> (\<forall> E h hh v p . ((E \<turnstile> h,e \<Down> hh,v,p) \<longrightarrow> (E,h,hh,v,p) \<in> P))"

constdefs vdm_context_validn::"nat \<Rightarrow> 'a vdmcontext \<Rightarrow> bool"  ("|\<Turnstile>\<^sub>_ _" 60)
"|\<Turnstile>\<^sub>n G \<equiv> (\<forall> t \<in> G . \<forall> s b e P . (e,P) = t s b \<longrightarrow> \<Turnstile>\<^sub>n e : P)"

constdefs vdm_context_valid::"'a vdmcontext \<Rightarrow> bool"  ("|\<Turnstile> _" 60)
"|\<Turnstile> G \<equiv> (\<forall> t \<in> G . \<forall> s b e P . (e,P) = t s b \<longrightarrow> \<Turnstile> e : P)"

lemma valid_validn: "\<Turnstile> e : P \<Longrightarrow>  \<Turnstile>\<^sub>n e : P"
by (simp add: vdm_valid_def vdm_validn_def sem_def, fastsimp)
(*by (simp add: vdm_valid_def vdm_validn_def)*)

lemma validn_valid: "(\<forall> n . \<Turnstile>\<^sub>n e : P) \<Longrightarrow> \<Turnstile> e : P"
by (simp add: vdm_valid_def vdm_validn_def sem_def, fastsimp)

lemma ctxt_valid_validn: "( |\<Turnstile> G) \<Longrightarrow> (\<forall> n.( |\<Turnstile>\<^sub>n G))"
apply (simp add: vdm_context_validn_def vdm_context_valid_def)
apply clarsimp
sorry 
(*
apply (auto elim: valid_validn)
done
*)

lemma emptyctxn [simp]: "|\<Turnstile>\<^sub>n {}"
by (simp add: vdm_context_validn_def)

lemma ctx_projn[rule_format]: "t \<in> G \<and> (e,P) = t s b \<and> |\<Turnstile>\<^sub>n G \<Longrightarrow> (\<Turnstile>\<^sub>n e : P)"
by (simp add: vdm_context_validn_def, fastsimp)

lemma ctxt_drop: "( |\<Turnstile> {t} \<union> G) \<Longrightarrow> |\<Turnstile> G"
by (simp add: vdm_context_valid_def)

lemma ctxt_ext[simp]: "( |\<Turnstile> {t} \<union> G) = (((e,P) = t s b) \<longrightarrow> (\<Turnstile> e : P ) \<and> ( |\<Turnstile> G))"
sorry
(*
by (simp add: vdm_context_valid_def)
*)

lemma emptyctx [simp]: "|\<Turnstile> {}"
by (simp add: vdm_context_valid_def)

lemma ctx_subn[rule_format]:  "H \<subseteq> G \<and> |\<Turnstile>\<^sub>n G \<Longrightarrow> |\<Turnstile>\<^sub>n H"
sorry
(*
by (simp add: vdm_context_validn_def, auto)
*)

lemma ctxt_cons: "\<lbrakk> |\<Turnstile> G; \<Turnstile> e : P \<rbrakk> \<Longrightarrow> |\<Turnstile> G \<union> {% s b . (e,P)}"

by (simp add: vdm_context_valid_def)


lemma contxt_validn_valid[rule_format]: "(\<forall> n. |\<Turnstile>\<^sub>n G) \<Longrightarrow> |\<Turnstile> G"
by (simp add: vdm_context_validn_def vdm_context_valid_def 
              vdm_valid_def vdm_validn_def sem_def,
    fastsimp)

lemma contxt_valid_validn: "|\<Turnstile> G \<Longrightarrow> (\<forall> n. |\<Turnstile>\<^sub>n G)"
by (simp add: vdm_context_validn_def vdm_context_valid_def 
              vdm_valid_def vdm_validn_def sem_def,
    fastsimp)

lemma lowerm: "\<lbrakk>  m < n; \<Turnstile>\<^sub>n e:P \<rbrakk> \<Longrightarrow> \<Turnstile>\<^sub>m e : P"
apply (simp add: vdm_validn_def)
apply clarsimp
apply (subgoal_tac "ma < n")
prefer 2 apply simp
apply (erule_tac thin_rl)
apply (erule_tac x="ma" in allE)
apply simp
done

(* lemmas lowerm_suc = lowerm [of n "Suc n"] *)
 
(* yes, I know this is sad; so what? *)
lemma lowerm_suc: "\<lbrakk>  \<Turnstile>\<^sub>Suc n e:P \<rbrakk> \<Longrightarrow> \<Turnstile>\<^sub>n e : P"
apply (simp add: vdm_validn_def)
apply clarsimp
apply (erule_tac x="m" in allE)
apply simp
done

lemma ctxt_lower: "\<lbrakk> |\<Turnstile>\<^sub>n G; m<n \<rbrakk> \<Longrightarrow> |\<Turnstile>\<^sub>m G"
apply (simp add: vdm_context_validn_def)
apply clarsimp
apply (rule lowerm)
apply fastsimp+
done

(* lemmas ctxt_lower_suc = ctxt_lower [of "Suc n" G n]; *)

(* yes, I know this is sad; so what? *)
lemma ctxt_lower_suc: "\<lbrakk> |\<Turnstile>\<^sub>Suc n G \<rbrakk> \<Longrightarrow> |\<Turnstile>\<^sub>n G"
apply (simp add: vdm_context_validn_def)
apply clarsimp
apply (rule lowerm)
apply fastsimp+
done


lemma ctxt_consn: "\<lbrakk> |\<Turnstile>\<^sub>n G; \<Turnstile>\<^sub>n e : P \<rbrakk> \<Longrightarrow> ( |\<Turnstile>\<^sub>n {% s b . (e,P)} \<union> G)"
by (simp add: vdm_context_validn_def)



lemma ctxt_insertn: "\<lbrakk> |\<Turnstile>\<^sub>n G; \<Turnstile>\<^sub>n e : P \<rbrakk> \<Longrightarrow> ( |\<Turnstile>\<^sub>n (insert (% s b . (e,P)) G))"
by (simp add: vdm_context_validn_def)



subsection {* Validity in context *}

constdefs
vdm_valid_in_ctxt :: "'a vdmcontext \<Rightarrow> 'a expr \<Rightarrow> vdmassn \<Rightarrow> bool" ("_ \<Turnstile> _ : _" 75)
  "G \<Turnstile> e : P \<equiv>  ( |\<Turnstile> G ) \<longrightarrow> (\<Turnstile> e:P)"

constdefs
vdm_valid_in_ctxt_n :: "'a vdmcontext \<Rightarrow> nat \<Rightarrow> 'a expr \<Rightarrow> vdmassn \<Rightarrow> bool" ("_ \<Turnstile>\<^sub> _ _ : _" 75)
  "G \<Turnstile>\<^sub>n e : P \<equiv>  ( |\<Turnstile>\<^sub>n G ) \<longrightarrow> ( \<Turnstile>\<^sub>n e:P)"
(*  "G \<Turnstile>\<^sub>n e : P \<equiv>  \<forall> m . m \<le> n \<longrightarrow> ( |\<Turnstile>\<^sub>m G ) \<longrightarrow> ( \<Turnstile>\<^sub>m e:P)"*)


subsection {* Collecting rules *}

lemmas vdm_basics = vdm_null vdm_int vdm_ivar vdm_rvar vdm_prim vdm_rprim vdm_getfi vdm_getfr vdm_putfi vdm_putfr vdm_new vdm_if vdm_leti vdm_letr vdm_letv 
lemmas vdm_calls = vdm_call vdm_mhinvokestatic vdm_mhinvoke 

lemmas vdm_pathetic = vdm_null vdm_int vdm_ivar vdm_rvar vdm_prim vdm_rprim vdm_getfi vdm_getfr vdm_putfi vdm_putfr vdm_new 

end

