theory Test = VDMaux:

consts arg :: rname
consts feld:: rfldname
consts CLS :: cname
consts testMeth :: mname

axioms differ: "distinct[param, arg] \<and> distinct[arg, param]"
axioms assign: "methtable CLS testMeth == GetFr param feld"

lemma testSpec: "\<rhd> ((InvokeStatic CLS testMeth arg)::nat expr) :  {(E,h,hh,v,p) . False}"
apply (rule vdm_invokestatic) 
apply (simp only: assign)
apply (rule vdm_conseq)
apply (rule vdm_getfr)
(*** end of VCG ***)
apply (insert differ)
apply clarsimp
oops

(*******************************************************)

locale Test =
fixes arg :: rname and 
      feld:: rfldname and
      CLS :: cname and
      testMeth :: mname and 
      tstbd :: "nat expr" and 
      tstfn :: funame and
      fnbd :: "nat expr"
defines tst: "tstbd== (CALL tstfn) :: nat expr"
    and funct: "fnbd== (GetFr param feld) :: nat expr"
assumes TST: "methtable CLS testMeth == tstbd"
     and   FUN: "funtable tstfn == fnbd"
     and diff:  "distinct[param, arg] \<and> distinct[arg, param] \<and> 
                 distinct[tstbd, fnbd] \<and> distinct[fnbd, tstbd]"

declare obj_ifieldupdate_def [simp]
declare obj_rfieldupdate_def [simp]
declare ivarupdate_def [simp]
declare rvarupdate_def [simp]
declare ienv_fct_def [simp]
declare renv_fct_def [simp]
declare newframe_env_def [simp]
declare emptyr_def [simp]

lemma  vdm_callmh : 
"\<lbrakk>(G \<union> {(CALL f,{(E,h,hh,v,p) . \<exists> p'. tkcall p' = p \<and> (E, h, hh, v, p') : P})}) \<rhd> (funtable f) : P\<rbrakk> \<Longrightarrow>
           G \<rhd> (CALL f) : {(E,h,hh,v,p) . \<exists> p'. tkcall p' = p \<and> (E, h, hh, v, p') : P}"
sorry


lemma (in Test) tstSpec: "\<rhd> ((InvokeStatic CLS testMeth arg)::nat expr) :  {(E,h,hh,v,p) . False}"
apply (rule vdm_invokestatic)
apply (simp only: TST) 
apply (simp only: tst)
apply (rule vdm_conseq)
apply (rule vdm_callmh)
apply (simp only: FUN) 
apply (simp only: funct)
apply (rule vdm_getfr)
(*** end of VCG ***)
apply (insert differ)
apply clarsimp
oops

(*******************************************************)

locale Test2 =
fixes arg :: rname and 
      feld:: rfldname and
      CLS :: cname and
      testMeth :: mname and 
      tstbd :: "nat expr" 
defines tstbd: "tstbd== (GetFr param feld) :: nat expr"
assumes TST: "methtable CLS testMeth == tstbd"
     and diff:  "distinct[param, arg] \<and> distinct[arg, param]"

declare obj_ifieldupdate_def [simp]
declare obj_rfieldupdate_def [simp]
declare ivarupdate_def [simp]
declare rvarupdate_def [simp]
declare ienv_fct_def [simp]
declare renv_fct_def [simp]
declare newframe_env_def [simp]
declare emptyr_def [simp]

lemma (in Test2) tstSpec: "\<rhd> ((InvokeStatic CLS testMeth arg)::nat expr) :  {(E,h,hh,v,p) . False}"
apply (rule vdm_invokestatic)
apply (simp only: TST) 
apply (simp only: tstbd)
apply (rule vdm_conseq)
apply (rule vdm_getfr)
(*** end of VCG ***)
apply (insert differ)
apply clarsimp
oops