theory DiaListInt3 = VDMaux:

(************************ To lemmas.thy ! ******************************************)
 
lemma ilfdUpdElsewhere2: "a \<noteq> a' \<Longrightarrow> h<a\<bullet>f:=n><a'\<bullet>f'> = h<a'\<bullet>f'>"
by (simp add: obj_ifieldupdate_def obj_rfieldupdate_def)

lemma rlfdUpdElsewhere2: "a \<noteq> a' \<Longrightarrow> h\<lfloor>a\<diamondsuit>f:=r\<rfloor>\<lfloor>a'\<diamondsuit>f'\<rfloor> = h\<lfloor>a'\<diamondsuit>f'\<rfloor>"
by (simp add: obj_ifieldupdate_def obj_rfieldupdate_def)

lemma rlfdUpdIfldElsewhere2: "a \<noteq> a' \<Longrightarrow> h<a\<bullet>f:=n>\<lfloor>a'\<diamondsuit>f'\<rfloor> = h\<lfloor>a'\<diamondsuit>f'\<rfloor>"
by (simp add: obj_ifieldupdate_def obj_rfieldupdate_def)

lemma ilfdUpdRfldElsewhere2: "h\<lfloor>a\<diamondsuit>f:=r\<rfloor><a'\<bullet>f'> = h<a'\<bullet>f'>"
by (simp add: obj_ifieldupdate_def obj_rfieldupdate_def)

lemma ilfdUpdElsewhere3: "f \<noteq> f' \<Longrightarrow> h<a\<bullet>f:=n><a'\<bullet>f'> = h<a'\<bullet>f'>"
apply (auto simp add: obj_ifieldupdate_def) 
done

lemma rlfdUpdElsewhere3: "f \<noteq> f' \<Longrightarrow> h\<lfloor>a\<diamondsuit>f:=r\<rfloor>\<lfloor>a'\<diamondsuit>f'\<rfloor> = h\<lfloor>a'\<diamondsuit>f'\<rfloor>"
apply (auto simp add: obj_rfieldupdate_def)
done


lemma rlfdUpdIfldElsewhere3: "h<a\<bullet>f:=n>\<lfloor>a'\<diamondsuit>f'\<rfloor> = h\<lfloor>a'\<diamondsuit>f'\<rfloor>"
by (simp add: obj_ifieldupdate_def obj_rfieldupdate_def)

(*********************************************************************************) 

(*Grail
public class CloneList$dia_0  {
   field public static CloneList$dia_0 $f

   field public CloneList$dia_0 $n

   field public int $

   field public int f0

   field public CloneList$dia_0 f1

   field public java.lang.String f2

   method static public CloneList$dia_0 alloc () =
   let
      val freelist = getstatic <CloneList$dia_0 CloneList$dia_0.$f>

      fun q(CloneList$dia_0 freelist) =
      let
         val tl = getfield freelist <CloneList$dia_0 CloneList$dia_0.$n>
         val () = putstatic <CloneList$dia_0 CloneList$dia_0.$f> tl
      in
         freelist
      end
   in
      if freelist = null[CloneList$dia_0]
      then new <CloneList$dia_0()> ()
      else q(freelist)
   end

   method static public void free (CloneList$dia_0 node) =
   let
      val freelist = getstatic <CloneList$dia_0 CloneList$dia_0.$f>
      val () = putfield node <CloneList$dia_0 CloneList$dia_0.$n> freelist
      val () = putstatic <CloneList$dia_0 CloneList$dia_0.$f> node
   in
      ()
   end

   method static public java.lang.String diamond_info () =
   let
   in
      ""
   end

   method public static CloneList$dia_0 fill (CloneList$dia_0 ?x, int tag, int v0, CloneList$dia_0 v1) =
   let
      val () = putfield ?x <int CloneList$dia_0.$> tag
      val () = putfield ?x <int CloneList$dia_0.f0> v0
      val () = putfield ?x <CloneList$dia_0 CloneList$dia_0.f1> v1
   in
      ?x
   end

   method public static CloneList$dia_0 fill (CloneList$dia_0 ?x, int tag, java.lang.String v0, CloneList$dia_0 v1) =
   let
      val () = putfield ?x <int CloneList$dia_0.$> tag
      val () = putfield ?x <java.lang.String CloneList$dia_0.f2> v0
      val () = putfield ?x <CloneList$dia_0 CloneList$dia_0.f1> v1
   in
      ?x
   end

   method public static CloneList$dia_0 fill (CloneList$dia_0 ?x, int tag) =
   let
      val () = putfield ?x <int CloneList$dia_0.$> tag
   in
      ?x
   end

   method public static CloneList$dia_0 make (int tag, int v0, CloneList$dia_0 v1) =
   let
      val ?x = invokestatic <CloneList$dia_0 CloneList$dia_0.alloc ()> ()
   in
      invokestatic <CloneList$dia_0 CloneList$dia_0.fill (CloneList$dia_0, int, int, CloneList$dia_0)> (?x, tag, v0, v1)
   end

   method public static CloneList$dia_0 make (int tag, java.lang.String v0, CloneList$dia_0 v1) =
   let
      val ?x = invokestatic <CloneList$dia_0 CloneList$dia_0.alloc ()> ()
   in
      invokestatic <CloneList$dia_0 CloneList$dia_0.fill (CloneList$dia_0, int, java.lang.String, CloneList$dia_0)> (?x, tag, v0, v1)
   end

   method public static CloneList$dia_0 make (int tag) =
   let
      val ?x = invokestatic <CloneList$dia_0 CloneList$dia_0.alloc ()> ()
   in
      invokestatic <CloneList$dia_0 CloneList$dia_0.fill (CloneList$dia_0, int)> (?x, tag)
   end
}
*)

(*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*)
(* This is the part common for all ToyGrail certifying thy-files *)
(* It defines a diamond, a freelist, and a pointer to a freelist, see D2a *) 


(******************************************************************)
(*************** DIAMOND stuff *************************************)


consts DIAMOND ::cname
consts DollarN :: rfldname (* to point to the next member in a freelist *)
       Dollar :: ifldname (* a tag to discriminate constructors in our "universal" diamond *)
       F0 :: ifldname (* a working field *)
       F1 :: rfldname (* a working field *)
consts STATICFL::cname 
consts DollarF :: rfldname (* the pointer to a head of a freelist*)



constdefs modelsDIAMOND:: "(ref \<times> int \<times> int \<times> ref \<times> locn \<times> heap) set"
"modelsDIAMOND == {(n,d,f0,f1,loc,h). fmap_lookup(oheap h) loc = Some DIAMOND
                                    \<and> rheap h DollarN loc = n
                                    \<and> iheap h Dollar loc = d
                                    \<and> iheap h F0 loc = f0
                                    \<and> rheap h F1 loc = f1}"

lemma modelsDIAMONDintro: "\<lbrakk>fmap_lookup(oheap h) loc = Some DIAMOND;
                            rheap h DollarN loc = n;
                            iheap h Dollar loc = d;
                            iheap h F0 loc = f0;
                             rheap h F1 loc = f1 \<rbrakk> \<Longrightarrow> (n,d,f0,f1,loc,h)\<in> modelsDIAMOND"
apply (unfold modelsDIAMOND_def)
apply safe
done

lemma modelsDIAMONDelim: "\<lbrakk>(n,d,f0,f1,loc,h)\<in> modelsDIAMOND \<rbrakk> \<Longrightarrow>
                           (fmap_lookup(oheap h) loc = Some DIAMOND \<and> 
                            rheap h DollarN loc = n \<and>
                            iheap h Dollar loc = d \<and>
                            iheap h F0 loc = f0 \<and>
                             rheap h F1 loc = f1 )"
apply (unfold modelsDIAMOND_def)
apply safe
done



axioms flddistinct: "distinct[DollarF, DollarN, F1] \<and> distinct[F1,DollarN,DollarF] \<and>
                    distinct[Dollar, F0] \<and> distinct[F0,Dollar]"


lemma modelsDIAMOND_Same:
"\<lbrakk>same Y h hh; loc:Y; (n,d,f0,f1,loc,h) : modelsDIAMOND\<rbrakk> \<Longrightarrow> (n,d,f0,f1,loc,hh) : modelsDIAMOND" 
apply (simp add:  modelsDIAMOND_def same_def)
done


lemma modelsDIAMOND_heaps:
"\<lbrakk>same {loc} h hh; (n,d,f0,f1,loc,h) : modelsDIAMOND\<rbrakk> \<Longrightarrow> (n,d,f0,f1,loc,hh) : modelsDIAMOND" 
apply (simp add:  modelsDIAMOND_def same_def)
done

  (**** Updating DollarN gives again a DIAMOND *************)

lemma modelsDIAMOND_updOtherDollarNaux:
"\<forall> n n' d f0 f1 loc h loc'. ((n,d,f0,f1,loc,h) \<in>  modelsDIAMOND \<and> loc ~= loc' 
\<longrightarrow> (n ,d,f0,f1,loc,h\<lfloor>loc'\<diamondsuit>DollarN:=n'\<rfloor>) \<in>  modelsDIAMOND)"
apply clarsimp
apply (unfold modelsDIAMOND_def)
apply safe
apply clarsimp
apply clarsimp
apply (simp add: ilfdUpdRfldElsewhere2)
apply (simp add: ilfdUpdRfldElsewhere2)
apply (simp add:  rlfdUpdElsewhere2)
done

lemma modelsDIAMOND_updSameDollarNaux:
"\<forall> n n' d f0 f1 loc h. ((n,d,f0,f1,loc,h) \<in>  modelsDIAMOND
\<longrightarrow> (n' ,d,f0,f1,loc,h\<lfloor>loc\<diamondsuit>DollarN:=n'\<rfloor>) \<in>  modelsDIAMOND)"
apply clarsimp
apply (unfold modelsDIAMOND_def)
apply safe
apply clarsimp
apply clarsimp
apply (simp add: ilfdUpdRfldElsewhere2) 
apply (simp add: ilfdUpdRfldElsewhere2)
apply (insert flddistinct) 
apply (simp add:  rlfdUpdElsewhere3)
done

lemma modelsDIAMOND_updOtherDollarN:
"\<lbrakk>(n,d,f0,f1,loc,h) \<in>  modelsDIAMOND; loc~=loc'\<rbrakk> \<Longrightarrow> (n,d,f0,f1,loc,h\<lfloor>loc'\<diamondsuit>DollarN:=n'\<rfloor>) : modelsDIAMOND"
apply (insert  modelsDIAMOND_updOtherDollarNaux)
apply blast
done

lemma modelsDIAMOND_updSameDollarN:
"\<lbrakk>(n,d,f0,f1,loc,h) \<in>  modelsDIAMOND\<rbrakk> \<Longrightarrow> (n',d,f0,f1,loc,h\<lfloor>loc\<diamondsuit>DollarN:=n'\<rfloor>) : modelsDIAMOND"
apply (insert  modelsDIAMOND_updSameDollarNaux)
apply blast
done

 (**** Updating Dollar gives again a DIAMOND *************)

lemma modelsDIAMOND_updOtherDollaraux:
"\<forall> n d d' f0 f1 loc h loc'. ((n,d,f0,f1,loc,h) \<in>  modelsDIAMOND \<and> loc ~= loc' 
\<longrightarrow> (n ,d,f0,f1,loc,h<loc'\<bullet> Dollar:=d'>) \<in>  modelsDIAMOND)"
apply clarsimp
apply (unfold modelsDIAMOND_def)
apply safe
apply clarsimp
apply (simp add:  rlfdUpdIfldElsewhere2)
apply clarsimp
apply (simp add: ilfdUpdElsewhere2)
apply (simp add:  rlfdUpdIfldElsewhere2)
done

lemma modelsDIAMOND_updSameDollaraux:
"\<forall> n d d' f0 f1 loc h. ((n,d,f0,f1,loc,h) \<in>  modelsDIAMOND
\<longrightarrow> (n ,d',f0,f1,loc,h<loc\<bullet> Dollar:=d'>) \<in>  modelsDIAMOND)"
apply clarsimp
apply (unfold modelsDIAMOND_def)
apply safe
apply clarsimp
apply (simp add:  rlfdUpdIfldElsewhere3)
apply clarsimp
apply (insert flddistinct) 
apply (simp add: ilfdUpdElsewhere2)
apply (simp add:  rlfdUpdIfldElsewhere3)
done

lemma modelsDIAMOND_updOtherDollar:
"\<lbrakk>(n,d,f0,f1,loc,h) \<in>  modelsDIAMOND; loc~=loc'\<rbrakk> \<Longrightarrow> (n,d,f0,f1,loc,h<loc'\<bullet> Dollar:=d'>) \<in>  modelsDIAMOND"
apply (insert  modelsDIAMOND_updOtherDollaraux)
apply blast
done

lemma modelsDIAMOND_updSameDollar:
"\<lbrakk>(n,d,f0,f1,loc,h) \<in>  modelsDIAMOND\<rbrakk> \<Longrightarrow> (n,d',f0,f1,loc,h<loc\<bullet> Dollar:=d'>) : modelsDIAMOND"
apply (insert  modelsDIAMOND_updSameDollaraux)
apply blast
done

 (**** Updating F0 gives again a DIAMOND *************)

lemma modelsDIAMOND_updOtherF0aux:
"\<forall> n d  f0 f0' f1 loc h loc'. ((n,d,f0,f1,loc,h) \<in>  modelsDIAMOND \<and> loc ~= loc' 
\<longrightarrow> (n ,d,f0,f1,loc,h<loc'\<bullet> F0 :=f0'>) \<in>  modelsDIAMOND)"
apply clarsimp
apply (unfold modelsDIAMOND_def)
apply safe
apply clarsimp
apply (simp add:  rlfdUpdIfldElsewhere2)
apply (simp add: ilfdUpdElsewhere2)
apply clarsimp
apply (simp add:  rlfdUpdIfldElsewhere2)
done

lemma modelsDIAMOND_updSameF0aux:
"\<forall> n d f0 f0' f1 loc h. ((n,d,f0,f1,loc,h) \<in>  modelsDIAMOND
\<longrightarrow> (n ,d,f0',f1,loc,h<loc\<bullet> F0:=f0'>) \<in>  modelsDIAMOND)"
apply clarsimp
apply (unfold modelsDIAMOND_def)
apply safe
apply clarsimp
apply (simp add:  rlfdUpdIfldElsewhere3)
apply (insert flddistinct) 
apply (simp add: ilfdUpdElsewhere2)
apply clarsimp
apply (simp add:  rlfdUpdIfldElsewhere3)
done

lemma modelsDIAMOND_updOtherF0:
"\<lbrakk>(n,d,f0,f1,loc,h) \<in>  modelsDIAMOND; loc~=loc'\<rbrakk> \<Longrightarrow> (n,d,f0,f1,loc,h<loc'\<bullet> F0:=f0''>) \<in>  modelsDIAMOND"
apply (insert  modelsDIAMOND_updOtherF0aux)
apply blast
done

lemma modelsDIAMOND_updOtherF0Adapt:
"\<lbrakk>(n,d,f0,f1,loc,h) \<in>  modelsDIAMOND; P1; P2; P3; loc~=loc'\<rbrakk> \<Longrightarrow> (n,d,f0,f1,loc,h<loc'\<bullet> F0:=f0''>) \<in>  modelsDIAMOND"
apply (insert  modelsDIAMOND_updOtherF0aux)
apply blast
done

lemma modelsDIAMOND_updSameF0:
"\<lbrakk>(n,d,f0,f1,loc,h) \<in>  modelsDIAMOND\<rbrakk> \<Longrightarrow> (n,d,f0',f1,loc,h<loc\<bullet> F0:=f0'>) : modelsDIAMOND"
apply (insert  modelsDIAMOND_updSameF0aux)
apply blast
done

 (**** Updating F1 gives again a DIAMOND *************)

lemma modelsDIAMOND_updOtherF1aux:
"\<forall> n d f0 f1 f1' loc h loc'. ((n,d,f0,f1,loc,h) \<in>  modelsDIAMOND \<and> loc ~= loc' 
\<longrightarrow> (n ,d,f0,f1,loc,h\<lfloor>loc'\<diamondsuit>F1:=f1'\<rfloor>) \<in>  modelsDIAMOND)"
apply clarsimp
apply (unfold modelsDIAMOND_def)
apply safe
apply clarsimp
apply (simp add:  rlfdUpdElsewhere2)
apply (simp add: ilfdUpdRfldElsewhere2)
apply (simp add: ilfdUpdRfldElsewhere2)
apply (simp add:  rlfdUpdElsewhere2)
done

lemma modelsDIAMOND_updSameF1aux:
"\<forall> n d f0 f1 f1' loc h. ((n,d,f0,f1,loc,h) \<in>  modelsDIAMOND
\<longrightarrow> (n ,d,f0,f1',loc,h\<lfloor>loc\<diamondsuit>F1:=f1'\<rfloor>) \<in>  modelsDIAMOND)"
apply clarsimp
apply (unfold modelsDIAMOND_def)
apply safe
apply clarsimp
apply (insert flddistinct) 
apply (simp add:  rlfdUpdElsewhere3)
apply (simp add: ilfdUpdRfldElsewhere2) 
apply (simp add: ilfdUpdRfldElsewhere2)
apply clarsimp 
done

lemma modelsDIAMOND_updOtherF1:
"\<lbrakk>(n,d,f0,f1,loc,h) \<in>  modelsDIAMOND; loc~=loc'\<rbrakk> \<Longrightarrow> (n,d,f0,f1,loc,h\<lfloor>loc'\<diamondsuit>F1:=f1'\<rfloor>) : modelsDIAMOND"
apply (insert  modelsDIAMOND_updOtherF1aux)
apply blast
done

lemma modelsDIAMOND_updSameF1:
"\<lbrakk>(n,d,f0,f1,loc,h) \<in>  modelsDIAMOND\<rbrakk> \<Longrightarrow> (n,d,f0,f1',loc,h\<lfloor>loc\<diamondsuit>F1:=f1'\<rfloor>) : modelsDIAMOND"
apply (insert  modelsDIAMOND_updSameF1aux)
apply blast
done




(*****************************************************************************)
(************************ FREELIST stuff  ***********************************)


consts modelsFreelistMH::"(nat \<times> ref \<times> (locn set) \<times> heap) set"
(*(i,l,X,h) : modelsFreelistMH if h\<lfloor>l\<rfloor> is the head of a list of diamonds of length i*) 
inductive modelsFreelistMH intros
FL_MHnothing[intro!] : "(0, Nullref,{},h) \<in>  modelsFreelistMH"
FL_MHsomething[intro!] : "\<lbrakk>(rtl, d, f0, f1, loc ,h) \<in> modelsDIAMOND; 
                   loc \<notin> X;
                   (i, rtl , X , h) \<in> modelsFreelistMH\<rbrakk> 
                   \<Longrightarrow> (Suc i, Ref loc, X\<union> {loc}, h) : modelsFreelistMH"


lemma modelsFreelistMH_Nullref:
"\<lbrakk>(0,r,X,h) : modelsFreelistMH\<rbrakk> \<Longrightarrow> r=Nullref"
apply (erule modelsFreelistMH.elims) 
apply simp
apply clarify
done

lemma modelsFreelistMH_empty:
"\<lbrakk>(0,r,X,h) : modelsFreelistMH\<rbrakk> \<Longrightarrow> X={}"
apply (erule modelsFreelistMH.elims) 
apply simp
apply blast
done

lemma modelsFreelistMH_SameAux:
"(n,r,X,h) : modelsFreelistMH \<Longrightarrow> (\<forall> Y hh.  
                                (same Y h hh \<and> X \<subseteq> Y \<longrightarrow> 
                                 (n, r, X,hh) : modelsFreelistMH))" 
apply (erule modelsFreelistMH.induct)
apply clarsimp 
apply clarify
apply (subgoal_tac "(rtl, d, f0, f1, loc, hh) \<in> modelsDIAMOND")
prefer 2
apply (simp add: modelsDIAMOND_Same) 
apply blast
done


lemma modelsFreelistMH_Same:
"\<lbrakk>same Y h hh; X \<subseteq> Y; (n,r,X,h) : modelsFreelistMH\<rbrakk> \<Longrightarrow> (n,r,X,hh) : modelsFreelistMH"
apply (insert modelsFreelistMH_SameAux)
apply blast
done


lemma modelsFreelistMHDomAux:"(L,r,X,h) : modelsFreelistMH \<Longrightarrow> 
                               (\<forall> x. x\<in> X  \<longrightarrow> x \<in> fmap_dom (oheap h))"
 apply (erule modelsFreelistMH.induct) 
 apply clarify
 apply (simp add: modelsDIAMOND_def fmap_lookup_def fmap_dom_def dom_def)
done

lemma modelsFreelistMHDom: "\<lbrakk>(L, r, X, h) \<in> modelsFreelistMH\<rbrakk> \<Longrightarrow>  X \<subseteq> fmap_dom (oheap h)"
apply (insert modelsFreelistMHDomAux)
apply blast
done


lemma FLDollarNelsewhereAux[simp]:
  "\<forall> N r X h l r'.
   ((N, r, X, h) \<in> modelsFreelistMH \<and> l \<notin> X \<longrightarrow> (N, r, X, h\<lfloor> l\<diamondsuit> DollarN := r'\<rfloor> ) \<in> modelsFreelistMH)"
apply clarify
apply (subgoal_tac "same X h  h\<lfloor> l\<diamondsuit> DollarN := r'\<rfloor>  ")
apply (erule modelsFreelistMH_Same)
apply safe
apply (unfold same_def)
apply (unfold fmap_lookup_def)
apply clarsimp
apply (subgoal_tac "l~=la")   
prefer 2
apply clarify
apply (simp add: ilfdUpdRfldElsewhere2 rlfdUpdElsewhere2)
done

lemma FLDollarNRelsewhere[simp]:
"\<lbrakk>(N, r, X, h) \<in> modelsFreelistMH; l \<notin> X\<rbrakk>  \<Longrightarrow>  (N, r, X, h\<lfloor> l\<diamondsuit> DollarN := r'\<rfloor>) \<in> modelsFreelistMH"
apply (subgoal_tac "same X h  h\<lfloor> l\<diamondsuit> DollarN := r'\<rfloor> ")
apply (erule modelsFreelistMH_Same)
apply safe
apply (unfold same_def)
apply (unfold fmap_lookup_def)
apply clarify
apply (subgoal_tac "l~=la")   
prefer 2
apply clarify
apply (simp add: ilfdUpdRfldElsewhere2 rlfdUpdElsewhere2)
done


lemma FLDollarreduce[simp]:
  "\<forall> r X oh ih rh.
   ((N, r, X, \<lparr>objhp = oh, inthp = ih, refhp = rh\<rparr>) \<in> modelsFreelistMH \<longrightarrow> 
    (N, r, X, \<lparr>objhp = oh, inthp = ih(Dollar := ih Dollar ), refhp = rh\<rparr>) \<in> modelsFreelistMH)"
apply (clarsimp)
done

lemma FLF0reduce[simp]:
  "\<forall> r X oh ih rh.
   ((N, r, X, \<lparr>objhp = oh, inthp = ih, refhp = rh\<rparr>) \<in> modelsFreelistMH \<longrightarrow> 
    (N, r, X, \<lparr>objhp = oh, inthp = ih(F0 := ih F0), refhp = rh\<rparr>) \<in> modelsFreelistMH)"
apply (clarsimp)
done

lemma FLF1reduce[simp]:
  "\<forall> r X oh ih rh.
   ((N, r, X, \<lparr>objhp = oh, inthp = ih, refhp = rh\<rparr>) \<in> modelsFreelistMH \<longrightarrow> 
    (N, r, X, \<lparr>objhp = oh, inthp = ih, refhp = rh(F1 := rh F1)\<rparr>) \<in> modelsFreelistMH)"
apply clarsimp
done

lemma FLDollarNreduce[simp]:
  "\<forall> r X oh ih rh.
   ((N, r, X, \<lparr>objhp = oh, inthp = ih, refhp = rh\<rparr>) \<in> modelsFreelistMH \<longrightarrow> 
    (N, r, X, \<lparr>objhp = oh, inthp = ih, refhp = rh(DollarN := rh DollarN)\<rparr>) \<in> modelsFreelistMH)"
apply clarsimp
done


lemma FLF0[simp]:
  "\<lbrakk>(N, r, X, h) \<in> modelsFreelistMH\<rbrakk> \<Longrightarrow>  (N, r, X, h<loc'\<bullet>F0 := f0'>) \<in> modelsFreelistMH"
apply (erule modelsFreelistMH.induct)
apply (intro FL_MHnothing)
apply (subgoal_tac "loc=loc'\<or> loc~=loc'")
prefer 2
apply clarify
apply (erule disjE)
apply (subgoal_tac "(rtl, d, f0', f1, loc, h<loc'\<bullet>F0:=f0'>) \<in> modelsDIAMOND")
apply (erule FL_MHsomething)
apply assumption
apply assumption
apply clarify
apply (erule modelsDIAMOND_updSameF0)
apply (subgoal_tac "(rtl, d, f0, f1, loc, h<loc'\<bullet>F0:=f0'>) \<in> modelsDIAMOND")
apply (erule FL_MHsomething)
apply assumption
apply assumption
apply (erule modelsDIAMOND_updOtherF0)
apply assumption
done

lemma FLF1[simp]:
  "\<lbrakk>(N, r, X, h) \<in> modelsFreelistMH\<rbrakk> \<Longrightarrow>  (N, r, X, h\<lfloor>loc'\<diamondsuit>F1 := f1'\<rfloor>) \<in> modelsFreelistMH"
apply (erule modelsFreelistMH.induct)
apply (intro FL_MHnothing)
apply (subgoal_tac "loc=loc'\<or> loc~=loc'")
prefer 2
apply clarify
apply (erule disjE)
apply (subgoal_tac "(rtl, d, f0, f1', loc, h\<lfloor>loc'\<diamondsuit>F1 := f1'\<rfloor>) \<in> modelsDIAMOND")
apply (erule FL_MHsomething)
apply assumption
apply assumption
apply clarify
apply (erule modelsDIAMOND_updSameF1)
apply (subgoal_tac "(rtl, d, f0, f1, loc, h\<lfloor>loc'\<diamondsuit>F1 := f1'\<rfloor>) \<in> modelsDIAMOND")
apply (erule FL_MHsomething)
apply assumption
apply assumption
apply (erule modelsDIAMOND_updOtherF1)
apply assumption
done


lemma FLDOLLAR[simp]:
  "\<lbrakk>(N, r, X, h) \<in> modelsFreelistMH\<rbrakk> \<Longrightarrow>  (N, r, X,  h<loc'\<bullet>Dollar := d'>) \<in> modelsFreelistMH"
apply (erule modelsFreelistMH.induct)
apply (intro FL_MHnothing)
apply (subgoal_tac "loc=loc'\<or> loc~=loc'")
prefer 2
apply clarify
apply (erule disjE)
apply (subgoal_tac "(rtl, d', f0, f1, loc, h<loc'\<bullet>Dollar := d'>) \<in> modelsDIAMOND")
apply (erule FL_MHsomething)
apply assumption
apply assumption
apply clarify
apply (erule modelsDIAMOND_updSameDollar)
apply (subgoal_tac "(rtl, d, f0, f1, loc, h<loc'\<bullet>Dollar := d'>) \<in> modelsDIAMOND")
apply (erule FL_MHsomething)
apply assumption
apply assumption
apply (erule modelsDIAMOND_updOtherDollar)
apply assumption
done




(* this is about the static field pointing to a freelist *)

constdefs modelsStaticMH::"(nat \<times> ref \<times> (locn set) \<times> heap) set"
         "modelsStaticMH == {(i, rst, X, h).   \<exists>  loc r . (rst= Ref loc \<and> 
                                                          loc \<notin> X  \<and> 
                                                          fmap_lookup(oheap h) loc = Some STATICFL    \<and> 
                                                          rheap h DollarF loc = r   \<and>  
                                                          (i, r, X, h) \<in> modelsFreelistMH)}"

lemma modelsStaticMH_Same:
"\<lbrakk>r = Ref loc; same Y h hh ; loc \<in> Y; X \<subseteq> Y; (i,r, X,h) : modelsStaticMH\<rbrakk> \<Longrightarrow> (i,r, X,hh) : modelsStaticMH"
apply (simp add: modelsStaticMH_def)
apply (insert modelsFreelistMH_Same)
apply (simp add: same_def)
done



lemma oheapFreshMonotone:
 "fmap_lookup (oheap h) l = Some C \<Longrightarrow> 
 fmap_lookup (oheap h(freshloc (fmap_dom (oheap h))\<mapsto>\<^sub>f D)) l = Some C"
 apply (subgoal_tac "l \<noteq> freshloc (fmap_dom (oheap h))")
 apply (simp add: FMAPlookup2)
 apply (subgoal_tac "freshloc (fmap_dom (oheap h)) \<notin> fmap_dom (oheap h)")
 prefer 2 apply (subgoal_tac "finite (fmap_dom (oheap h))")
          apply (simp add: freshloc)
          apply fast
 apply (subgoal_tac "l \<in> fmap_dom (oheap h)")
 apply fast
 apply (simp add: fmap_dom_def fmap_lookup_def dom_def)
done

(*********************************************************************)
(* Length of a list of  DIAMONDS with NIL! representing lists of ints*)

constdefs HSize ::"heap \<Rightarrow> int"
"HSize h == int (card (fmap_dom (heap.oheap h)))"
declare HSize_def [simp]

lemma SizeInsert[simp]: "int (card (insert (freshloc (fmap_dom H)) (fmap_dom H))) = 
                         int (card (fmap_dom H)) + 1"
apply (subgoal_tac "card (insert (freshloc (fmap_dom H)) (fmap_dom H)) = Suc (card (fmap_dom H))")
apply simp
apply (rule card_insert_disjoint)
apply fastsimp
apply (rule freshloc, fastsimp)
done

declare obj_ifieldupdate_def [simp]
declare obj_rfieldupdate_def [simp]

consts LocLengthBang::"(nat \<times> ref \<times> (locn set) \<times> heap) set"
inductive LocLengthBang intros
NIL_LocLB[intro!]:   "(0, Nullref, {}, h) \<in> LocLengthBang"
CONS_LocLB[intro!]:  "\<lbrakk>(rtl, d, f0, f1, loc, h) \<in> modelsDIAMOND;
	              loc \<notin> X;
                      (i, f1, X, h) \<in> LocLengthBang\<rbrakk> 
                      \<Longrightarrow> (Suc i, Ref loc, X\<union> {loc}, h) \<in>  LocLengthBang"

lemma LocLengthBang_Nullref:
"\<lbrakk>(0,r,X,h) : LocLengthBang\<rbrakk> \<Longrightarrow> r=Nullref"
apply (erule LocLengthBang.elims)
apply safe 
done

lemma LocLengthBang_empty:
"\<lbrakk>(0,r,X,h) :  LocLengthBang\<rbrakk> \<Longrightarrow> X={}"
apply (erule  LocLengthBang.elims) 
apply safe
done

lemma LocLengthBang_SameAux:
"(n,r,X,h) : LocLengthBang \<Longrightarrow> (\<forall> Y hh.  
                                (same Y h hh \<and> X \<subseteq> Y \<longrightarrow> 
                                 (n, r, X,hh) : LocLengthBang))" 
apply (erule LocLengthBang.induct)
apply clarsimp
apply clarify
apply (subgoal_tac "(rtl, d, f0, f1, loc, hh) \<in> modelsDIAMOND")
prefer 2
apply (simp add: modelsDIAMOND_Same) 
apply blast
done

lemma LocLengthBang_Same:
"\<lbrakk>same Y h hh; X \<subseteq> Y; (n,r,X,h) : LocLengthBang \<rbrakk> \<Longrightarrow> (n,r,X,hh) : LocLengthBang"
apply (insert LocLengthBang_SameAux)
apply blast
done

lemma LocLengthBang_DomAux:"(L,r,X,h) : LocLengthBang  \<Longrightarrow> 
                               (\<forall> x. x\<in> X  \<longrightarrow> x \<in> fmap_dom (oheap h))"
 apply (erule LocLengthBang.induct) 
 apply clarify
 apply (simp add: modelsDIAMOND_def fmap_lookup_def fmap_dom_def dom_def)
done

lemma LocLengthBang_Dom: "\<lbrakk>(L, r, X, h) \<in> LocLengthBang\<rbrakk> \<Longrightarrow>  X \<subseteq> fmap_dom (oheap h)"
apply (erule LocLengthBang.induct) 
 apply clarify
 apply (simp add: modelsDIAMOND_def fmap_lookup_def fmap_dom_def dom_def)
done

lemma LocLengthBangF1elsewhere[simp]:
"\<lbrakk>(N, r, X, h) \<in> LocLengthBang; l \<notin> X\<rbrakk>  \<Longrightarrow>  (N, r, X, h\<lfloor> l\<diamondsuit> F1 := r'\<rfloor>) \<in> LocLengthBang"
apply (subgoal_tac "same X h  h\<lfloor> l\<diamondsuit> F1 := r'\<rfloor> ")
apply (erule LocLengthBang_Same)
apply safe
apply (unfold same_def)
apply (unfold fmap_lookup_def)
apply clarify
apply (subgoal_tac "l~=la")   
prefer 2
apply clarify
apply (simp add: ilfdUpdRfldElsewhere2 rlfdUpdElsewhere2)
done

lemma LocLengthBangDollarreduce[simp]:
  "\<forall> r X oh ih rh.
   ((N, r, X, \<lparr>objhp = oh, inthp = ih, refhp = rh\<rparr>) \<in>  LocLengthBang \<longrightarrow> 
    (N, r, X, \<lparr>objhp = oh, inthp = ih(Dollar := ih Dollar), refhp = rh\<rparr>) \<in> LocLengthBang)"
apply (clarsimp)
done

lemma LocLengthBangF0reduce[simp]:
  "\<forall> r X oh ih rh.
   ((N, r, X, \<lparr>objhp = oh, inthp = ih, refhp = rh\<rparr>) \<in>  LocLengthBang \<longrightarrow> 
    (N, r, X, \<lparr>objhp = oh, inthp = ih(F0 := ih F0), refhp = rh\<rparr>) \<in> LocLengthBang)"
apply (clarsimp)
done

lemma LocLengthBangF1reduce[simp]:
  "\<forall> r X oh ih rh.
   ((N, r, X, \<lparr>objhp = oh, inthp = ih, refhp = rh\<rparr>) \<in>   LocLengthBang \<longrightarrow> 
    (N, r, X, \<lparr>objhp = oh, inthp = ih, refhp = rh(F1 := rh F1)\<rparr>) \<in>  LocLengthBang)"
apply clarsimp
done

lemma LocLengthBangDollarNreduce[simp]:
  "\<forall> r X oh ih rh.
   ((N, r, X, \<lparr>objhp = oh, inthp = ih, refhp = rh\<rparr>) \<in>   LocLengthBang \<longrightarrow> 
    (N, r, X, \<lparr>objhp = oh, inthp = ih, refhp = rh(DollarN := rh DollarN)\<rparr>) \<in>  LocLengthBang)"
apply clarsimp
done


lemma LocLengthBangF0[simp]:
  "\<lbrakk>(N, r, X, h) \<in> LocLengthBang\<rbrakk> \<Longrightarrow>  (N, r, X, h<loc'\<bullet>F0 := f0'>) \<in> LocLengthBang"
apply (erule LocLengthBang.induct)
apply (intro NIL_LocLB)
apply (subgoal_tac "loc=loc'\<or> loc~=loc'")
prefer 2
apply clarify
apply (erule disjE)
apply (subgoal_tac "(rtl, d, f0', f1, loc, h<loc'\<bullet>F0:=f0'>) \<in> modelsDIAMOND")
apply (erule CONS_LocLB)
apply assumption
apply assumption
apply clarify
apply (erule modelsDIAMOND_updSameF0)
apply (subgoal_tac "(rtl, d, f0, f1, loc, h<loc'\<bullet>F0:=f0'>) \<in> modelsDIAMOND")
apply (erule CONS_LocLB)
apply assumption
apply assumption
apply (erule modelsDIAMOND_updOtherF0)
apply assumption
done


lemma LocLengthBangDollarN[simp]:
  "\<lbrakk>(N, r, X, h) \<in> LocLengthBang\<rbrakk> \<Longrightarrow>  (N, r, X, h\<lfloor>loc'\<diamondsuit>DollarN:= n'\<rfloor>) \<in> LocLengthBang"
apply (erule LocLengthBang.induct)
apply (intro NIL_LocLB)
apply (subgoal_tac "loc=loc'\<or> loc~=loc'")
prefer 2
apply clarify
apply (erule disjE)
apply (subgoal_tac "(n', d, f0, f1, loc, h\<lfloor>loc'\<diamondsuit>DollarN:= n'\<rfloor>) \<in> modelsDIAMOND")
apply (erule CONS_LocLB)
apply assumption
apply assumption
apply clarify
apply (erule modelsDIAMOND_updSameDollarN)
apply (subgoal_tac "(rtl, d, f0, f1, loc, h\<lfloor>loc'\<diamondsuit>DollarN:= n'\<rfloor>) \<in> modelsDIAMOND")
apply (erule  CONS_LocLB)
apply assumption
apply assumption
apply (erule modelsDIAMOND_updOtherDollarN)
apply assumption
done


lemma LocLengthBangDollar[simp]:
  "\<lbrakk>(N, r, X, h) \<in>   LocLengthBang\<rbrakk> \<Longrightarrow>  (N, r, X,  h<loc'\<bullet>Dollar := d'>) \<in> LocLengthBang"
apply (erule LocLengthBang.induct)
apply (intro NIL_LocLB)
apply (subgoal_tac "loc=loc'\<or> loc~=loc'")
prefer 2
apply clarify
apply (erule disjE)
apply (subgoal_tac "(rtl, d', f0, f1, loc, h<loc'\<bullet>Dollar := d'>) \<in> modelsDIAMOND")
apply (erule  CONS_LocLB)
apply assumption
apply assumption
apply clarify
apply (erule modelsDIAMOND_updSameDollar)
apply (subgoal_tac "(rtl, d, f0, f1, loc, h<loc'\<bullet>Dollar := d'>) \<in> modelsDIAMOND")
apply (erule  CONS_LocLB)
apply assumption
apply assumption
apply (erule modelsDIAMOND_updOtherDollar)
apply assumption
done

(*****************************************************************************)
(* Lists without Bang, just with Nil: Datatype *)




(*****************************************************************************)
(* Lists without Bang, just with Nil: Relations *)

consts LocLength::"(nat \<times> locn \<times> (locn set) \<times> heap) set"
inductive LocLength intros
NIL_LocL[intro!]:   "\<lbrakk>(rtl, 0, f0, f1, loc, h) \<in> modelsDIAMOND\<rbrakk> \<Longrightarrow>
                      (0, loc, {loc}, h) \<in> LocLength"
CONS_LocL[intro!]:  "\<lbrakk>(rtl, 1, f0, Ref loc', loc, h) \<in> modelsDIAMOND;
                      (i, loc', X, h) \<in> LocLength;
	               loc \<notin> X\<rbrakk> 
                      \<Longrightarrow> (Suc i, loc, X\<union> {loc}, h) \<in>  LocLength"

(* NIL is also a Diamond? Yes\<dots> *)

lemma LocLength_head: "\<lbrakk>(n,loc,X,h) \<in> LocLength\<rbrakk> \<Longrightarrow> loc\<in> X"
apply (erule LocLength.elims)
apply safe
done


lemma LocLength_Dollar0:
"\<lbrakk>(0,loc,X,h) \<in> LocLength\<rbrakk>   \<Longrightarrow> X={loc}"
apply (erule LocLength.elims)
apply safe
done


lemma LocLength_Same[rule_format]:
"((n,loc,X,h) \<in>   LocLength \<Longrightarrow> same Y h hh \<longrightarrow> X \<subseteq> Y \<longrightarrow> (n, loc, X,hh) \<in> LocLength)"
apply (erule LocLength.induct)
(**** nil-branch ****)
apply (rule impI)
apply (rule impI)
apply (subgoal_tac "(rtl, 0, f0, f1, loc, hh)\<in> modelsDIAMOND")
apply force
apply (simp add: modelsDIAMOND_Same)
(**** cons-branch ****)
apply (rule impI)
apply (rule impI)
apply (clarify)
apply (subgoal_tac "(rtl, 1, f0, Ref loc', loc, hh)\<in> modelsDIAMOND")
apply (erule CONS_LocL)
apply force
apply assumption
apply (simp add: modelsDIAMOND_Same)
done

declare  LocLength_Same[simp]

lemma LocLength_SameShort:
"\<lbrakk>(n,loc,X,h) \<in>   LocLength; same X h hh\<rbrakk> \<Longrightarrow> (n,loc,X,hh) :  LocLength"
apply (erule_tac Y="X" and h="h" in LocLength_Same)
apply safe
done

(* No lemmas about X\<subseteq> Dom (oheap), since the "base", NIL, guy is not
necessary in  Dom (oheap) *)

lemma LocLength_F1Elsewhere[rule_format]:
"(N, loc, X, h) \<in> LocLength \<Longrightarrow> loc' \<notin> X \<longrightarrow> (N, loc, X, h\<lfloor> loc'\<diamondsuit> F1 := r\<rfloor> ) \<in> LocLength"
apply (erule LocLength.induct)
(**** nil-branch ****)
apply (rule impI)
apply (subgoal_tac "(rtl, 0, f0, f1, loc, h\<lfloor>loc'\<diamondsuit>F1:=r\<rfloor>) \<in> modelsDIAMOND ")
apply (force)
apply (subgoal_tac "loc~=loc'")
apply (rule modelsDIAMOND_updOtherF1)
apply assumption
apply assumption
apply force
(**** cons-branch ****)
apply (rule impI)
apply (subgoal_tac "(rtl, 1, f0,Ref loc'a , loc, h\<lfloor>loc'\<diamondsuit>F1:=r\<rfloor>) \<in> modelsDIAMOND ")
apply (erule CONS_LocL)
apply force
apply assumption
apply (subgoal_tac "loc'a~=loc'")
apply (rule modelsDIAMOND_updOtherF1)
apply assumption
apply force
apply (subgoal_tac "loc'a \<in> X")
apply force
apply (erule LocLength_head)
done

declare LocLength_F1Elsewhere[simp]

lemma LocLength_DollarElsewhere[rule_format]:
"(N, loc, X, h) \<in> LocLength \<Longrightarrow> loc' \<notin> X \<longrightarrow> (N, loc, X, h<loc'\<bullet>Dollar:=d>) \<in> LocLength"
apply (erule LocLength.induct)
(**** nil-branch ****)
apply (rule impI)
apply (subgoal_tac "(rtl, 0, f0, f1, loc, h<loc'\<bullet>Dollar:=d>) \<in> modelsDIAMOND ")
apply (force)
apply (subgoal_tac "loc~=loc'")
apply (rule modelsDIAMOND_updOtherDollar)
apply assumption
apply assumption
apply force
(**** cons-branch ****)
apply (rule impI)
apply (subgoal_tac "(rtl, 1, f0, Ref loc'a , loc, h<loc'\<bullet>Dollar:=d>) \<in> modelsDIAMOND ")
apply (erule CONS_LocL)
apply force
apply assumption
apply (subgoal_tac "loc'a~=loc'")
apply (rule modelsDIAMOND_updOtherDollar)
apply assumption
apply force
apply (subgoal_tac "loc'a \<in> X")
apply force
apply (erule LocLength_head)
done

declare LocLength_DollarElsewhere[simp]


lemma LocLengthDollarreduce[simp]:
  "\<forall> r X oh ih rh.
   ((N, r, X, \<lparr>objhp = oh, inthp = ih, refhp = rh\<rparr>) \<in> LocLength \<longrightarrow> 
    (N, r, X, \<lparr>objhp = oh, inthp = ih(Dollar := ih Dollar), refhp = rh\<rparr>) \<in> LocLength)"
apply (clarsimp)
done

lemma LocLengthF0reduce[simp]:
  "\<forall> r X oh ih rh.
   ((N, r, X, \<lparr>objhp = oh, inthp = ih, refhp = rh\<rparr>) \<in> LocLength \<longrightarrow> 
    (N, r, X, \<lparr>objhp = oh, inthp = ih(F0 := ih F0), refhp = rh\<rparr>) \<in> LocLength)"
apply clarsimp
done

lemma  LocLengthF1reduce[simp]:
  "\<forall> r X oh ih rh.
   ((N, r, X, \<lparr>objhp = oh, inthp = ih, refhp = rh\<rparr>) \<in>  LocLength \<longrightarrow> 
    (N, r, X, \<lparr>objhp = oh, inthp = ih, refhp = rh(F1 := rh F1)\<rparr>) \<in>  LocLength)"
apply clarsimp
done


lemma  LocLengthDollarNreduce[simp]:
  "\<forall> r X oh ih rh.
   ((N, r, X, \<lparr>objhp = oh, inthp = ih, refhp = rh\<rparr>) \<in>  LocLength \<longrightarrow> 
    (N, r, X, \<lparr>objhp = oh, inthp = ih, refhp = rh(DollarN := rh DollarN)\<rparr>) \<in>  LocLength)"
apply clarsimp
done

lemma LocLength_F0[simp]:
"(N, loc, X, h) \<in> LocLength \<Longrightarrow> (N, loc, X, h<loc'\<bullet>F0:=f0>) \<in> LocLength"
apply (erule LocLength.induct)
(**** nil-branch ****)
apply (subgoal_tac "loc~=loc' \<or> loc=loc'")
apply (erule disjE)
apply (subgoal_tac "(rtl, 0, f0a, f1, loc, h<loc'\<bullet>F0:=f0>) \<in> modelsDIAMOND ")
apply (force)
apply (rule modelsDIAMOND_updOtherF0)
apply assumption
apply assumption
apply (subgoal_tac "(rtl, 0, f0, f1, loc, h<loc'\<bullet>F0:=f0>) \<in> modelsDIAMOND ")
apply force
apply clarify
apply (erule modelsDIAMOND_updSameF0)
apply force
(**** cons-branch ****)
apply (subgoal_tac "loc~=loc' \<or> loc=loc'")
apply (erule disjE)
apply (subgoal_tac "(rtl, 1, f0a, Ref loc'a, loc, h<loc'\<bullet>F0:=f0>) \<in> modelsDIAMOND ")
apply (erule CONS_LocL)
apply assumption
apply assumption
apply (rule modelsDIAMOND_updOtherF0)
apply assumption
apply assumption
apply (subgoal_tac "(rtl, 1, f0, Ref loc'a , loc, h<loc'\<bullet>F0:=f0>) \<in> modelsDIAMOND ")
apply (erule CONS_LocL)
apply assumption
apply assumption
apply clarify
apply (erule modelsDIAMOND_updSameF0)
apply force
done

lemma LocLength_DollarN[simp]:
"(N, loc, X, h) \<in> LocLength \<Longrightarrow> (N, loc, X, h\<lfloor>loc'\<diamondsuit>DollarN:=r\<rfloor> ) \<in> LocLength"
apply (erule LocLength.induct)
(**** nil-branch ****)
apply (subgoal_tac "loc~=loc' \<or> loc=loc'")
apply (erule disjE)
apply (subgoal_tac "(rtl, 0, f0, f1, loc, h\<lfloor>loc'\<diamondsuit>DollarN:=r\<rfloor>) \<in> modelsDIAMOND ")
apply (force)
apply (rule modelsDIAMOND_updOtherDollarN)
apply assumption
apply assumption
apply (subgoal_tac "(r, 0, f0, f1, loc, h\<lfloor>loc'\<diamondsuit>DollarN:=r\<rfloor>) \<in> modelsDIAMOND ")
apply force
apply clarify
apply (erule modelsDIAMOND_updSameDollarN)
apply force
(**** cons-branch ****)
apply (subgoal_tac "loc~=loc' \<or> loc=loc'")
apply (erule disjE)
apply (subgoal_tac "(rtl, 1, f0, Ref loc'a, loc, h\<lfloor>loc'\<diamondsuit>DollarN:=r\<rfloor>) \<in> modelsDIAMOND ")
apply (erule CONS_LocL)
apply assumption
apply assumption
apply (rule modelsDIAMOND_updOtherDollarN)
apply assumption
apply assumption
apply (subgoal_tac "(r, 1, f0, Ref loc'a , loc, h\<lfloor>loc'\<diamondsuit>DollarN:=r\<rfloor>) \<in> modelsDIAMOND ")
apply (erule CONS_LocL)
apply assumption
apply assumption
apply clarify
apply (erule modelsDIAMOND_updSameDollarN)
apply force
done



(************************************************************************)
(********* Old Lennart's stuff *****************************************)

(*
lemma LocLengthDomAux:
"\<forall> l X h . ((L, l, X, h) \<in> LocLength \<longrightarrow>  X \<subseteq> fmap_dom (oheap h))"
apply (induct L)
apply clarsimp
apply (erule LocLength.elims, simp_all, clarsimp)
apply (simp add: fmap_lookup_def fmap_dom_def dom_def, fast)
apply clarsimp
apply (erule LocLength.elims, simp_all, clarsimp)
apply (simp add: fmap_lookup_def fmap_dom_def dom_def, fast)
done

lemma LocLengthDom: "\<lbrakk>(L, l, X, h) \<in> LocLength\<rbrakk> \<Longrightarrow>  X \<subseteq> fmap_dom (oheap h)"
by (insert LocLengthDomAux, fast)

lemma LocLDOLLAR[simp]:
  "\<forall> r X h l tag.
   ((N, r, X, h) \<in> LocLength \<and> l \<notin> X \<longrightarrow> (N, r, X, h<l\<bullet>Dollar := tag>) \<in> LocLength)"
apply clarsimp
apply (induct N)
apply (erule LocLength.elims)
apply clarsimp
apply (rule NIL_LocL, fastsimp+)
apply (erule LocLength.elims)
apply clarsimp
apply clarsimp
by (rule CONS_LocL, fastsimp+)

lemma LocLF0[simp]:
  "\<forall> r X oh ih rh.
   ((N, r, X, \<lparr>objhp = oh, inthp = ih, refhp = rh\<rparr>) \<in> LocLength \<longrightarrow> 
    (N, r, X, \<lparr>objhp = oh, inthp = ih(F0 := ih F0), refhp = rh\<rparr>) \<in> LocLength)"
by fastsimp


lemma LocLengthSameAux:
"\<forall> l X h hh . (((n,l,X,h) \<in> LocLength \<and> same X h hh) \<longrightarrow> (n,l,X,hh) \<in> LocLength)"
apply (induct n)
apply clarsimp
apply (erule LocLength.elims, simp_all, clarsimp)
apply (rule NIL_LocL)
apply (simp_all add: same_def)
apply clarsimp
apply (subgoal_tac "x \<in> fmap_dom (oheap hp)")
prefer 2 apply fast
apply (simp add: fmap_dom_def dom_def, clarsimp)
apply (rule_tac x=y in exI,simp add: fmap_lookup_def)
apply clarsimp
apply (erule LocLength.elims, simp)
apply (erule_tac x=tt in allE)
apply (erule_tac x="Xa - {la}" in allE)
apply (erule_tac x=hp in allE)
apply (erule_tac x=hh in allE)
apply (rule CONS_LocL, simp_all)
done

lemma LocLengthSame:
"\<lbrakk>(n,l,X,h) \<in> LocLength; same X h hh\<rbrakk> \<Longrightarrow> (n,l,X,hh) \<in> LocLength"
by (insert LocLengthSameAux, fast)
*)

end


