(* 
   Problems with namespace: docu says that all names in a theory file are exported
   Example how sharing of modules in dependency breaks Isabelle/Proof General
*)


(*
theory ToyVCGtest_BROKEN = ToyVCG1 + ToyPrelude + ToyHLbasic1:
*)
(* THis should work (ToyVCG1.thy imports ToyHLbasic1 already) but doesn't 
   Isabelle complains about 
*** Unknown theorem(s) "HIf'"
*)
theory ToyVCGtest_BROKEN = ToyVCG1 + ToyPrelude:


section {* \texttt{decN}: decrement a field *}

locale decN_example =
  fixes    m         :: iname
    and	   n         :: iname
    and	   q         :: iname
    and	   zero      :: iname
    and    N         :: int    
    and	   decN      :: funame
    and	   decNBody  :: expr
  defines "decNBody \<equiv>  LET 
                n    = m :-- ;
                zero = 0\<^sup>z ;
                q    = n :> zero
              IN
                IF q 
                  THEN zero\<^sup>I
                  ELSE n\<^sup>I
              END"
  assumes  vardistinct: "distinct [m,n,z1,q1,zero]"
      and  decN_fnbdy:  "funtable decN = decNBody"

declare (in decN_example) decNBody_def[simp]
declare (in decN_example) decN_fnbdy[simp]

lemma (in decN_example) 
   "\<Turnstile> {(z,s). s<n> = z<n>}
      decNBody
      {(z,s,v). v = IVal (z<n> - 1) }"
apply (insert vardistinct)
apply (simp)
apply hoare_simp
apply auto
done

end