(*  
   Problems with namespace: docu says that all names in a theory file are exported
   Example how sharing of modules in dependency breaks Isabelle/Proof General
   
*)

(* Importing theories like this works 
theory ToyVCGtest_BROKEN = ToyVCG1 + ToyPrelude + ToyHLbasic1:
*)
(* THis should work (ToyVCG1.thy imports ToyHLbasic1 already) but doesn't 
   Isabelle complains about 
*** Unknown theorem(s) "HIf'"
*)
theory ToyVCGtest0xc = ToyVCG1 + ToyPrelude:

locale bonzo0xc_example =
  fixes    m         :: iname
    and	   n         :: iname
    and	   z1        :: iname
    and	   z2        :: iname
    and	   zero      :: iname
    and    DecClass  :: cname 
    and	   decBody   :: expr
    and    const     :: funame
    and	   constBody  :: expr
  defines "constBody \<equiv> IVar n"
  assumes  vardistinct: "distinct [m,n,z1,z2,zero]"
    (* function tables *)
    and    const_fnbdy: "funtable const = constBody "
    (* measures *)
    and    const_wfmeasure: "fun_wfmeasure_table const = {}"

declare (in bonzo0xc_example) constBody_def[simp]
declare (in bonzo0xc_example) const_fnbdy[simp]

(* Works in both cases: "HIf'" seems to be visible in *this* module *)
lemma (in bonzo0xc_example) 
   "\<Turnstile> {(z,s). s<n>=z<n> \<and> s<z1>=1}	
      IF z1
        THEN CALL const
        ELSE IVar n
      {(z,s,v). v = IVal (z<n>)}"
apply (insert vardistinct)
apply (rule "HIf'")
oops

(* This breaks, using the 2nd option of importing theories: "HIf'" apparently not visible in hoare_simp *)
lemma (in bonzo0xc_example) 
   "\<Turnstile> {(z,s). s<n>=z<n> \<and> s<z1>=1}	
      IF z1
        THEN CALL const
        ELSE IVar n
      {(z,s,v). v = IVal (z<n>)}"
apply (insert vardistinct)
apply (simp)
apply hoare_simp
oops

end
