(*  
   File:        ToyVCGtest0xb.thy
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ToyVCGtest0xb.thy,v 1.2 2003/05/29 11:47:38 a1hloidl Exp $

   Example how VCG w/ polymorphic assertion tables breaks.
   Same as ToyVCGtest0xa but using preassn specialised to state.
*)

theory ToyVCGtest0xb = ToyVCG0 + ToyPrelude + ToyHLbasic0:

section {* Testing the VCGen *}

subsection {* bonzo0xb *}

locale bonzo0xb_example =
  fixes    m         :: iname
    and	   n         :: iname
    and	   z1        :: iname
    and	   z2        :: iname
    and	   zero      :: iname
    and    DecClass  :: cname 
    and	   decBody   :: expr
    and    const     :: funame
    and	   constBody  :: expr
    (*
    and    constPreInv  :: "int preassn"
    and    constPostInv :: "int postassn"
    *)
  defines "constBody \<equiv> IVar n"
    (*
    and   "constPreInv == {(z, s). s<n> = z}"
    and   "constPostInv == {(z, s, v). v = IVal z \<and> s<n> = z}"
    *)
  assumes  vardistinct: "distinct [m,n,z1,z2,zero]"
    (* function tables *)
    and    const_fnbdy: "funtable const = constBody "
    (* measures *)
    and    const_wfmeasure: "fun_wfmeasure_table const = {}"
    (* invariants *)
    and    const_preinv:  "fun_preassn_table const == {(z, s). s<n> = z<n>}"
    and    const_postinv: "fun_postassn_table const == {(z, s, v). v = IVal (z<n>) \<and> s<n> = z<n>}"
    and    dec_preinv:  "fun_preassn_table dec == {(z, s). s<n> = z<n>}"
    and    dec_postinv: "fun_postassn_table dec == {(z, s, v). v = IVal (z<n>) \<and> s<n> = z<n>}"

declare (in bonzo0xb_example) constBody_def[simp]
declare (in bonzo0xb_example) const_fnbdy[simp]
declare (in bonzo0xb_example) const_preinv[simp]
declare (in bonzo0xb_example) const_postinv[simp]
(*
declare (in bonzo0xb_example) constPreInv_def[simp]
declare (in bonzo0xb_example) constPostInv_def[simp]
*)

lemma (in bonzo0xb_example) 
   "[| \<Turnstile> (fun_preassn_table const) (CALL const) (fun_postassn_table const) |] ==>
    \<Turnstile> {(z,s). s<n>=z<n> \<and> s<z1>=1}	
      IF z1
        THEN CALL const
        ELSE IVar n
      {(z,s,v). v = IVal (z<n>)}"
apply (insert vardistinct)
apply (simp)
apply hoare_rec_simp
(* none of the "fun_preassn_table const" etc has been expanded *)
apply auto
done

lemma (in bonzo0xb_example) 
   "[| \<Turnstile> (fun_preassn_table const) (CALL const) (fun_postassn_table const) ;
       \<Turnstile> (fun_preassn_table dec)   (CALL dec)   (fun_postassn_table dec) ;
       wf (fun_wfmeasure_table const) |] 
    ==>
    \<Turnstile> {(z,s). s<n>=z<n>}	
      LET 
        zero' = expr.Int 0
      IN 
        CALL const
      END
      {(z,s,v). v = IVal (z<n>)}"
apply (insert vardistinct)
apply (simp)
apply hoare_rec_simp
(* program is sufficiently pathetic to be taken apart *)
oops

subsection {* dec3 *}

subsection {* bonzo0xa *}

locale dec3_example =
  fixes    m         :: iname
    and	   n         :: iname
    and	   z1        :: iname
    and	   z2        :: iname
    and	   i'1       :: iname
    and	   r'1       :: rname
    and	   q1        :: iname
    and	   zero      :: iname
    and	   zero'     :: iname
    and    l1        :: locn
    and    N         :: int    
    and    count     :: ifldname
    and	   dec       :: funame
    and    DecClass  :: cname 
    and	   decBody   :: expr
    and    const     :: funame
    and	   constBody  :: expr
    and    constPreInv :: "int preassn"
    and    constPostInv :: "int postassn"
  defines "decBody \<equiv>  LET 
                m  = GetFi self count ;
                n  = Primop (\<lambda> x y . x - 1) m m ;
                z1 = PutFi self count n ; 
                zero = expr.Int 0 ;
                q1 = Primop (\<lambda> x y . if \<not> y<x then (1::int) else (0::int)) n zero
              IN
                IF q1 
                  THEN IVar zero
                  ELSE IVar n
              END"
  and     "constBody \<equiv> IVar n"
  and     "constPreInv == {(z::int, s). s<n> = z}"
  and     "constPostInv == {(z::int, s, v). v = IVal z \<and> s<n> = z}"
  assumes  DecClass:    "classtable DecClass = \<lparr> iflds = [count], rflds = [], meths = \<lambda> mn. K mn \<rparr>"
      and  vardistinct: "distinct [m,n,z1,z2,i'1,q1,zero]"
      and  vardistinct': "distinct [zero,q1]"
      and  vardistinct'': "distinct [r'1]"
      (* function tables *)
      and  dec_fnbdy:   "funtable dec = decBody"
      and  const_fnbdy: "funtable const = constBody "
      (* measures *)
      and  dec_wfmeasure: "fun_wfmeasure_table dec = inv_image less_than (the_ifld self count)"
      and  const_wfmeasure: "fun_wfmeasure_table const = {}"
      (*
      and  const_inv: "fun_assn_table const = (
             {(z, s). s<n>=z \<and> s\<lfloor>self\<rfloor> = Ref l1 \<and> s\<lless>l1\<ggreater> = Some (DecClass, emptyi(count := N), emptyr)},
             {(z, s, v). v = IVal z \<and> s<n>=z \<and> s\<lfloor>self\<rfloor> = Ref l1 \<and>
             s\<lless>l1\<ggreater> = Some (DecClass, emptyi(count := N), emptyr)} )"
      *)
      (* invariants *)
      and  dec_preinv: "fun_preassn_table dec == {(z, s). s\<lfloor>self\<rfloor> = Ref l1 \<and> s\<lless>l1\<ggreater> = Some (DecClass, emptyi(count := z), emptyr)}"
      and  dec_postinv: "fun_postassn_table dec == {(z, s, v). s\<lfloor>self\<rfloor> = Ref l1 \<and> v = IVal (z - 1)}"
      and  const_preinv: "fun_preassn_table const == constPreInv"
      and  const_postinv: "fun_postassn_table const == constPostInv"
      and  dec_inv_holds: "\<Turnstile> (fun_preassn_table dec) (CALL dec) (fun_postassn_table dec)"
      and  const_inv_holds: "\<Turnstile> (fun_preassn_table const) (CALL const) (fun_postassn_table const)"

declare (in dec3_example) decBody_def[simp]
declare (in dec3_example) dec_fnbdy[simp]
declare (in dec3_example) constBody_def[simp]
declare (in dec3_example) const_fnbdy[simp]
declare (in dec3_example) dec_wfmeasure[simp]
declare (in dec3_example) dec_preinv[simp]
declare (in dec3_example) dec_postinv[simp]
declare (in dec3_example) const_preinv[simp]
declare (in dec3_example) const_postinv[simp]
declare (in dec3_example) constPreInv_def[simp]
declare (in dec3_example) constPostInv_def[simp]


subsection {* const after field manipulation *}

lemma (in dec3_example) 
   "[| \<Turnstile> (fun_preassn_table const) (CALL const) (fun_postassn_table const) ;
       \<Turnstile> (fun_preassn_table dec) (CALL dec) (fun_postassn_table dec) |] 
    ==>
    \<Turnstile> {(z, s). s\<lfloor>self\<rfloor> = Ref l1 \<and> s\<lless>l1\<ggreater> = Some (DecClass, emptyi, emptyr)}
      LET
        n = 4\<^sup>z ; 
        z2 = (self\<bullet>count := n)
      IN
        CALL const
      END
      {(z,s,v). v = IVal 4}"
apply (insert vardistinct vardistinct'')
apply (simp)
apply hoare_rec_simp
defer 1
defer 1
(* the following simp is supposed to expand "fun_preassn_table const" but doesn't *)
apply simp
oops


end
