(*  
   File:	ToyHLbasic.thy
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ToyHLmutrec.thy,v 1.1 2003/06/08 13:39:52 da Exp $

   Derived mutual recursion rules of Hoare Logic for Toy Grail  [UNFINISHED]
*)   

theory ToyHLmutrec = ToyHLbasic:

types
 'a cntxt = "('a preassn \<times> 'a expr \<times> 'a postassn) set"

constdefs
 hoare_valids :: "'a cntxt \<Rightarrow> bool"               ("|\<Turnstile> _" 50)
 "|\<Turnstile> C \<equiv> \<forall>(P,e,Q) \<in> C. \<Turnstile> P e Q"

constdefs
 cntxt_hoare_valid :: "['a cntxt, 'a preassn, 'a expr, 'a postassn]  \<Rightarrow> bool" ("(_ /\<Turnstile> (1_)/ (_)/ (1_))" 80)
 "C \<Turnstile> P e Q \<equiv> ( |\<Turnstile> C ) \<longrightarrow> \<Turnstile> P e Q "

 cntxt_hoare_valids :: "['a cntxt, 'a cntxt] \<Rightarrow> bool" ("_ |\<Turnstile>/ _" 80)
 "C |\<Turnstile> D  \<equiv>  ( |\<Turnstile> C ) \<longrightarrow> |\<Turnstile> D "



(********************************************************************************)


subsection {* HCallMutRec --- sets of mutually recursive functions  *}

text {*
This uses the rule Nipkow has in his paper~\cite{Nipkow-CSL02}. It simultaneously
reasons over all functions and uses pre- and post-assertions indexed by function
name (we probably should grab them from the tables). *}

lemma HCallMutRec:
 "\<lbrakk> wf r;
   \<forall>fn s' pre. (\<Union>fn'. {({(z, s). (z,s') \<in> (P fn') \<and> s=tick (incrcallcount s') \<and> ((fn',s'),(fn,pre)) \<in> r}, CALL fn', (Q fn'))})
           |\<Turnstile> { ({(z, s). (z,s) \<in> (P fn) \<and> s = pre}, funtable fn, (Q fn)) } \<rbrakk>
 \<Longrightarrow> |\<Turnstile> \<Union>fn. {(P fn, (CALL fn), Q fn)}"
apply (unfold hoare_valids_def)
apply (simp)
apply (rule allI)
apply (drule_tac x="a" in spec)
oops

text {* 
An introduction rule for contextual validity. Not sure whether we need it, but it looks nice. 
*}

lemma HConjI:
 "\<forall>(P,e,Q) \<in> D. C |\<Turnstile> {(P,e,Q)} \<Longrightarrow> C |\<Turnstile> D"
apply (unfold cntxt_hoare_valids_def)
apply (rule impI)
apply (unfold hoare_valids_def)
apply auto
done

lemma HConjE:
 "\<lbrakk> C |\<Turnstile> D ; (P,e,Q) \<in> D \<rbrakk> \<Longrightarrow> C |\<Turnstile> {(P,e,Q)}"
apply (unfold cntxt_hoare_valids_def)
apply (rule impI)
apply simp
apply (unfold hoare_valids_def)
apply auto
done

end
