(*  
   File:        ToyVCGtest.ML
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: VCGtest.thy,v 1.3 2003/05/27 19:27:46 da Exp $

   Some tests of the VCG.
   
*)

theory VCGtest = SimpleVCG:

section {* Testing the VCGen *}


subsection {* Simple function *}

locale simple_example =
  fixes    j :: iname and k :: iname and l :: iname and m :: iname
    and	   F :: funame
  assumes  [simp]:  "funtable F = (LET j = expr.Int 6;
				       k = expr.Int 7;
				       l = Primop (op*) j k
				    IN (Primop (op+) l m) END::int expr)"

(* NB: to reuse same funbody for different aux var types could declare it as 'a expr
   bound to another identifier.  Q: does typing regime prohibit change of type of
   auxiliary variables during proof? *)
     and  vardistinct:  "distinct [j,k,l,m]"

lemma (in simple_example) "\<Turnstile> {(M,s). s<m> = M} (CALL F) {(M, s, result). result=IVal (M + 42)}"
apply (insert vardistinct)
apply (vcg, auto)
done

subsubsection {* GetF *}

lemma "\<Turnstile> {(a, s). s\<lfloor>vn\<rfloor> = Ref a \<and> fmap_lookup (oheap s) a = Some obj}
	   (GetFi vn f)
         {(a, s, result). result = IVal (iheap s f a)}"
by (vcg, auto)

lemma "\<Turnstile> {(obj, s). s\<lfloor>vn\<rfloor> = Ref a \<and> fmap_lookup (oheap s) a = Some obj}
	   (GetFr vn f)
         {(obj, s, result). result = RVal (rheap s f a)}"
by (vcg, auto)

(* Putf/GetF/New not here *)

subsubsection {* IF *}

lemma "\<Turnstile> {(z,s). s<b>=z \<and> s<x1> = 3 \<and> s<x2> = 5}
        (IF b THEN IVar x1 ELSE IVar x2)
         {(z, s, result). (z=1 \<longrightarrow> result=IVal 3)  \<and>  z=0 \<longrightarrow> result=IVal 5}"
by (vcg, auto)

lemma "\<Turnstile> {((B1,B2),s). s<b1>=B1 \<and> s<b2>=B2}
         (IF b1 THEN IVar x1 ELSE (IF b2 THEN IVar x2 ELSE IVar x3))
         {((B1,B2), s, result). (B1=1 \<longrightarrow> result=IVal s<x1>)  
			     \<and> ((B1=0 \<and> B2=1) \<longrightarrow> result = IVal s<x2>)
			    \<and>  ((B1=0 \<and> B2=0) \<longrightarrow> result = IVal s<x3>)}"
by (vcg, auto)


end
