(*  
   File:	$RCSfile: ToyVDMderived.thy,v $
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ToyVDMderived.thy,v 1.10 2003/06/29 21:41:12 a1hloidl Exp $

   Derived VDM rules
*)

theory ToyVDMderived = ToyVDM + ToyHLderived:

subsection {* Derived syntax *}

types vdmexpr = "state expr"

syntax Satisfies :: "state postassn \<Rightarrow> vdmexpr \<Rightarrow> vdmexpr"  ("(SATISFIES _:/ _)" [0,60] 66)
translations
 "SATISFIES P : e" => "(POST P : e) :: vdmexpr"   (* fix type *)
 "SATISFIES P : e" <= "POST P : e"

subsection {* Rules for recursion *}

(* long-winded proof to derive from Hoare version *)
(* NB: HCallRec is still unproven *)
lemma VCallRec: "\<lbrakk> \<Turnstile>\<^sub>v (CALL fn) : P \<Longrightarrow> \<Turnstile>\<^sub>v (funtable fn) :
					      {(s,s',v). \<exists> s''. s=tickcall s''
							 \<and> (s'',s',v) \<in> P} \<rbrakk>  \<Longrightarrow>  
	      \<Turnstile>\<^sub>v (CALL fn) : P"
apply (rule HtoV)
apply (rule HCallRec)
apply (drule HtoV)
apply (subgoal_tac "\<Turnstile>\<^sub>v funtable fn : {(s, s', v). \<exists>s''. s = tickcall s'' \<and> (s'', s', v) \<in> P}")
apply (rule HConseq, rule VtoH)
apply assumption
prefer 2
apply simp
apply auto
apply (erule thin_rl)
apply (subgoal_tac "s''=b")
apply auto
apply (rotate_tac -1)
apply (simp add: tickn_def incrcallcount_def)
apply (rule_tac r=s'' in state.cases)
apply (rule_tac r=b in state.cases)
apply auto
done

(* for some reason this doesn't work any more; inlined the incrcallcount_inj proof
apply (rule incrcallcount_inj)
apply (rule_tac i="1" in tickn_inj)
apply assumption
done
*)

(* This version uses inverse image: avoids need for untick uncall junk *)
lemma VCallRec1: "\<lbrakk> \<Turnstile>\<^sub>v (CALL fn) : {(s,s',v). (tickcall s,s',v)\<in> P}
                    \<Longrightarrow> \<Turnstile>\<^sub>v (funtable fn) : P \<rbrakk>
		  \<Longrightarrow> \<Turnstile>\<^sub>v (CALL fn) : {(s,s',v). (tickcall s,s',v)\<in> P}"
apply (rule VCallRec)
apply clarsimp
apply (rule VW)
apply assumption
apply clarsimp
apply (simp add: tickn_def incrcallcount_def)
apply (rule_tac x="a \<lparr> callcount := callcount a - 1, clock := clock a - 1\<rparr>" in exI)
apply auto
apply (rule_tac r=a in state.cases)
apply auto
done

text {*  A customized rule for using post condition in code. *}

lemma VCallRecSat: "\<lbrakk> funtable fn = SATISFIES P : body;
		      \<Turnstile>\<^sub>v (CALL fn) : {(s,s',v). (tickcall s,s',v)\<in> P}
                        \<Longrightarrow> \<Turnstile>\<^sub>v body : P;
		      {(s,s',v). (tickcall s,s',v)\<in> P} \<subseteq> Q \<rbrakk>
		  \<Longrightarrow> \<Turnstile>\<^sub>v (CALL fn) : Q"
apply (rule VW)
apply (rule VCallRec1)
apply auto
apply (rule VPost, auto)
done



subsection {* tweaked rules to make existentials disappear *}

constdefs 
  apfstofthree :: "['a \<Rightarrow> 'd, 'a \<times> 'b \<times> 'c ] \<Rightarrow> 'd \<times> 'b \<times> 'c"
  "apfstofthree \<equiv> \<lambda> f (a,b,c). (f a, b, c)"

declare apfstofthree_def [simp add]

(* alternative version of VCallRec using image operator to hide existential 
lemma VCallRec2: "\<lbrakk> \<Turnstile>\<^sub>v (CALL fn) : P \<Longrightarrow> 
                   \<Turnstile>\<^sub>v (funtable fn) :
                       apfstofthree tickcall ` P \<rbrakk>  \<Longrightarrow>  
	      \<Turnstile>\<^sub>v (CALL fn) : P"
apply (rule VCallRec)
apply (simp add: image_def)
oops
*)


subsection {* Same for static invocation *}

lemma bonzo_1963: "\<forall> m n n'. max m n = max m n' \<and> m <= n \<and> m <= n' --> n=n'"
by (simp add: max_def)

lemma newframe_sort_of_inj: "\<forall> r v mn s s'. (maxstack s) = (maxstack s') \<and> newframe s mn r s\<lfloor>v\<rfloor> = newframe s' mn r s'\<lfloor>v\<rfloor> \<longrightarrow> s=s'"
apply (rule allI)+
apply (rule impI)
apply (simp add: newframe_def)
apply (rule_tac r=s in state.cases)
apply (rule_tac r=s' in state.cases)
apply clarsimp
done

lemma VInvokeStaticUseless: "
    \<lbrakk> (* \<Turnstile>\<^sub>v InvokeStatic C mn vn2 : P \<Longrightarrow> *)
     \<Turnstile>\<^sub>v methtable C mn : {(s,s',v) . \<exists> s''.  
                                      s = newframe s'' mn Nullref (s''\<lfloor>vn2\<rfloor>) \<and>
                                      (s'', tickn 4 (oldframe s' s''), v) \<in> P} \<rbrakk> \<Longrightarrow>      
     \<Turnstile>\<^sub>v InvokeStatic C mn vn2 : P"
apply (rule VW)
apply (rule VInvokeStatic)
apply assumption
apply clarsimp
apply (insert newframe_sort_of_inj)
apply (rotate_tac -1)
apply (erule_tac x="Nullref" in allE)
apply (erule_tac x="vn2" in allE)
apply (erule_tac x="mn" in allE)
apply (erule_tac x="a" in allE)
apply (erule_tac x="s''a" in allE)
apply clarsimp
apply (subgoal_tac "maxstack a = maxstack s''a")
apply clarsimp
done

lemma VInvokeStaticRecNaive: "
    \<lbrakk> \<Turnstile>\<^sub>v InvokeStatic C mn vn2 : P \<Longrightarrow>
     \<Turnstile>\<^sub>v methtable C mn : {(s,s',v) . \<exists> s''.  
                                      s = newframe s'' mn Nullref (s''\<lfloor>vn2\<rfloor>) \<and>
                                      (s'', tickn 4 (oldframe s' s''), v) \<in> P} \<rbrakk> \<Longrightarrow>      
     \<Turnstile>\<^sub>v InvokeStatic C mn vn2 : P"
sorry

(*
lemma VInvokeStaticRec1: "
    \<lbrakk> \<Turnstile>\<^sub>v InvokeStatic C mn vn2 : apfstofthree (\<lambda> s. newframe s mn Nullref (s\<lfloor>vn2\<rfloor>)) ` P \<Longrightarrow>
     \<Turnstile>\<^sub>v methtable C mn : {(s,s',v) . (s, tickn 4 (oldframe s' s), v) \<in> P} \<rbrakk> \<Longrightarrow>
     \<Turnstile>\<^sub>v InvokeStatic C mn vn2 : {(s,s',v). (newframe s mn Nullref (s\<lfloor>vn2\<rfloor>),s',v) \<in> P}"
sorry
*)

(* P specifies method body, plus post-admin stuff *)
lemma VInvokeStaticRec2: "
    \<lbrakk> \<Turnstile>\<^sub>v InvokeStatic C mn vn2 : {(s,s',v). (newframe s mn Nullref (s\<lfloor>vn2\<rfloor>),s',v) \<in> P} \<Longrightarrow>
     \<Turnstile>\<^sub>v methtable C mn : {(s,s',v) . (s, tickn 4 (oldframe s' s), v) \<in> P} \<rbrakk> \<Longrightarrow>
     \<Turnstile>\<^sub>v InvokeStatic C mn vn2 : {(s,s',v). (newframe s mn Nullref (s\<lfloor>vn2\<rfloor>),s',v) \<in> P}"
sorry

(* P specifies method body *)
lemma VInvokeStaticRec0: "
    \<lbrakk> \<Turnstile>\<^sub>v InvokeStatic C mn vn2 : {(s,s',v). \<exists> s''. s'=tickn 4 (oldframe s'' s) \<and> (newframe s mn Nullref (s\<lfloor>vn2\<rfloor>),s'',v) \<in> P} \<Longrightarrow>
     \<Turnstile>\<^sub>v methtable C mn :  P \<rbrakk> \<Longrightarrow>
     \<Turnstile>\<^sub>v InvokeStatic C mn vn2 : {(s,s',v). \<exists> s''. s'=tickn 4 (oldframe s'' s) \<and> (newframe s mn Nullref (s\<lfloor>vn2\<rfloor>),s'',v) \<in> P}"
apply (rule VW)
apply (rule VInvokeStaticRecNaive)
apply fastsimp
sorry

(*
apply (rule VW)
apply (rule VInvokeStaticRecNaive)
apply auto
apply (subgoal_tac "\<Turnstile>\<^sub>v InvokeStatic C mn vn2 : {(s,s',v). (newframe s mn Nullref (s\<lfloor>vn2\<rfloor>),s',v) \<in> P}")
apply simp
apply (rule VdmI)
apply (rule allI)+
apply (rule impI)
apply auto
apply (rule VInvokeStaticRec1)
apply (subgoal_tac "\<Turnstile>\<^sub>v InvokeStatic C mn vn2 : {(s,s',v). (newframe s mn Nullref (s\<lfloor>vn2\<rfloor>),s',v) \<in> P}")
apply simp
apply (rotate_tac -1)
apply (frule VdmE)
apply simp
apply simp
apply (rule VInvokeStaticRec1)
oops
*)

lemma VInvokeStaticRecSat: "\<lbrakk> methtable C mn = SATISFIES P : body ;
     \<Turnstile>\<^sub>v InvokeStatic C mn vn2 : (apfstofthree (\<lambda> s. newframe s mn Nullref (s\<lfloor>vn2\<rfloor>)) ` P) \<Longrightarrow>
     \<Turnstile>\<^sub>v body : {(s,s',v) . (s, tickn 4 (oldframe s' s), v) \<in> P};
     (apfstofthree (\<lambda> s. newframe s mn Nullref (s\<lfloor>vn2\<rfloor>)) ` P) \<subseteq> Q \<rbrakk> \<Longrightarrow>      
     \<Turnstile>\<^sub>v InvokeStatic C mn vn2 : Q"
sorry

(* no ` ; coolest InvokeStatic rule so far *)
lemma VInvokeStaticRecSat2: "\<lbrakk> methtable C mn = SATISFIES P : body ;
     \<Turnstile>\<^sub>v InvokeStatic C mn vn2 : (\<lambda> (s,s',v). (newframe s mn Nullref (s\<lfloor>vn2\<rfloor>),tickn 4 (oldframe s' s),v)) ` P \<Longrightarrow>
     \<Turnstile>\<^sub>v body : P ; 
     (\<lambda> (s,s',v). (newframe s mn Nullref (s\<lfloor>vn2\<rfloor>),tickn 4 (oldframe s' s),v)) ` P \<subseteq> Q \<rbrakk> \<Longrightarrow>      
     \<Turnstile>\<^sub>v InvokeStatic C mn vn2 : Q"
apply (rule VW)
apply (rule VInvokeStaticRec0)
defer 1
apply auto
apply (rule VW)
apply (rule VPost)
apply auto
sorry

subsection {* Interactive versions of rule (differing from VCG versions) *}

lemma VLetI: "\<lbrakk>  \<Turnstile>\<^sub>v e' : P2; \<Turnstile>\<^sub>v e :  P1 \<rbrakk> \<Longrightarrow>
	  \<Turnstile>\<^sub>v (LET x=e IN e' END) : 
	       {(s,s',v). \<exists> s'' v'. (s,s'',v')\<in> P1
				  \<and> (ivarupdate (tick s'') x (theival v'),s',v) \<in> P2}"
by (simp add: vdm_valid_def, fastsimp elim: evalLeti_cases)


(********************************************************************************)

subsection {* Collecting the rules together *}

text {* The set @{text vdmbasics} are rules used for non-looping code;
  @{text vdmprocs} are the procedure rules.  These rule sets are
  for interactive use, the VCG uses a custom set. *}

lemmas vdmbasicsI = VNull VInt VIVar VVarr VPrimop VRPrimop VGetFi VGetFr VPutFi VPutFr VNew VIf VLetI VLetR 

lemmas vdmprocs  = VCall VInvokeStatic 
(* VInvoke  *) (* you wish! *)


end
