(*  
   File:        ToyVCG.ML
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ToyVDMVCG.thy,v 1.1 2003/06/29 21:41:12 a1hloidl Exp $

   Verification Condition Generator for ToyGrail.
   Version to be used with VDM-style logic.
   
   TODO:
     -- Improve efficiency of VCG
     -- Fixup documentation

   MONOMORPHIC PRE-and-POST-ASSERTIONS
*)

theory ToyVDMVCG = ToyGrailDefBD + ToyVDMBD
files ("ToyVDMVCG.ML"):

section {* VCGen *}

subsection {* Simplifications used in VCGen tactic below *}

text {* These simplifications are taken from Hoare/hoare.ML and need changes
to fit with our stuff. Basic simplifications on sets should be still useful,
though *}

(*****************************************************************************)
(** Simplifying:                                                            **)
(** Some useful lemmata, lists and simplification tactics to control which  **)
(** theorems are used to simplify at each moment, so that the original      **)
(** input does not suffer any unexpected transformation                     **)
(*****************************************************************************)

lemma Compl_Collect: "-(Collect b) = {x. ~(b x)}"
by (fast)


subsection {* Tactic for the generation of the verification conditions *} 

text {* @{text "HoareRuleTac"} is the VCGen tactic. 
This tactic doesn't use @{text "WlpTac"} since there is no explicit
sequencing construct.
It uses the lemmas in ToyHLbasic directly. The example tactic in HoareParallel
encodes rule of consequence directly in the syntax-direct rules. I suppose we 
need more applications of HSP etc in this tactic.
*}

text {* Our master plan of handling recursive functions/methods:

\begin{enumerate}
\item Try applying assumption (if we have ind hypo on fct in assumptions already)
\item Apply HRec or HRecWF (the latter is more flexible and probably better)
   WIth HRecWF, this needs to instantiate a measure. Maybe assume that we have
   a table mapping fnames to measures and get it from there.
   (similar to the assertion table we need anyway)
\item Apply HCall
\item Unfold the body of the function. Maybe feed the funtable directly to simplifier.
*} 

use "ToyVDMVCG.ML";

subsubsection {* standard VCG *}

method_setup vcg = {*
  Method.no_args
    (Method.SIMPLE_METHOD' HEADGOAL (vcg_tac (K all_tac) ))  *}
  "ToyGrail verification condition generator"

method_setup vcg_simp = {*
  Method.ctxt_args (fn ctxt =>
    Method.METHOD (fn facts => 
      vcg_tac (asm_full_simp_tac (Simplifier.get_local_simpset ctxt)) 1))  *}
  "ToyGrail verification condition generator plus simplification"

method_setup vcg_arith = {*
  Method.ctxt_args (fn ctxt =>
    Method.METHOD (fn facts => 
      vcg_tac (asm_full_simp_tac (Simplifier.get_local_simpset ctxt)
		 ORELSE' arith_tac) 1))  *}
  "ToyGrail verification condition generator plus simplification and arithmetic"

method_setup vcg_step = {*
  Method.no_args
    (Method.SIMPLE_METHOD' HEADGOAL (vcg_step_tac (K all_tac))) *}
  "ToyGrail verification condition generator, single step"

method_setup vcg_simp_step = {*
  Method.ctxt_args (fn ctxt =>
    Method.METHOD (fn facts => 
      vcg_step_tac (asm_full_simp_tac (Simplifier.get_local_simpset ctxt)) 1))  *}
  "ToyGrail verification condition generator plus simplification, single step"

subsubsection {* vcg1 (WAS hoare3_simp) *}

method_setup vcg1 = {*
  Method.no_args
    (Method.SIMPLE_METHOD' HEADGOAL (vcg1_tac (K all_tac) ))  *}
  "ToyGrail verification condition generator"

method_setup vcg1_simp = {*
  Method.ctxt_args (fn ctxt =>
    Method.METHOD (fn facts => 
      vcg1_tac (asm_full_simp_tac (Simplifier.get_local_simpset ctxt)) 1))  *}
  "ToyGrail verification condition generator plus simplification"

method_setup vcg1_arith = {*
  Method.ctxt_args (fn ctxt =>
    Method.METHOD (fn facts => 
      vcg1_tac (asm_full_simp_tac (Simplifier.get_local_simpset ctxt)
		 ORELSE' arith_tac) 1))  *}
  "ToyGrail verification condition generator plus simplification and arithmetic"

method_setup vcg1_step = {*
  Method.no_args
    (Method.SIMPLE_METHOD' HEADGOAL (vcg1_step_tac (K all_tac))) *}
  "ToyGrail verification condition generator, single step"

method_setup vcg1_simp_step = {*
  Method.ctxt_args (fn ctxt =>
    Method.METHOD (fn facts => 
      vcg1_step_tac (asm_full_simp_tac (Simplifier.get_local_simpset ctxt)) 1))  *}
  "ToyGrail verification condition generator plus simplification, single step"

subsubsection {* VCG using invariants in function calls *}

method_setup vcg_rec = {*
  Method.no_args
    (Method.SIMPLE_METHOD' HEADGOAL (vcg_rec_tac (K all_tac) ))  *}
  "ToyGrail verification condition generator"

method_setup vcg_rec_simp = {*
  Method.ctxt_args (fn ctxt =>
    Method.METHOD (fn facts => 
      vcg_rec_tac (asm_full_simp_tac (Simplifier.get_local_simpset ctxt)) 1))  *}
  "ToyGrail verification condition generator plus simplification"

method_setup vcg_rec_step = {*
  Method.no_args
    (Method.SIMPLE_METHOD' HEADGOAL (vcg_rec_step_tac (K all_tac))) *}
  "ToyGrail verification condition generator, single step"

method_setup vcg_rec_simp_step = {*
  Method.ctxt_args (fn ctxt =>
    Method.METHOD (fn facts => 
      vcg_rec_step_tac (asm_full_simp_tac (Simplifier.get_local_simpset ctxt)) 1))  *}
  "ToyGrail verification condition generator plus simplification, single step"


subsubsection {* Check expression *}

method_setup hoare_check_expr = {*
  Method.no_args
    (Method.SIMPLE_METHOD' HEADGOAL (vcg_check_expr_tac (K all_tac) ))  *}
  "petaQ bortaS"

method_setup hoare_check_invoke = {*
  Method.no_args
    (Method.SIMPLE_METHOD' HEADGOAL (vcg_check_invoke_tac (K all_tac) ))  *}
  "petaQ bortaS"
end

