(*  
   File:	$RCSfile: ToyVDMBD.thy,v $
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: ToyVDMBD.thy,v 1.7 2003/07/09 20:58:44 a1hloidl Exp $

   Experimental instantiation to VDM
   
   Naming convention for states: s,t,... are pre-states; s',t',... are post-states 
*)

theory ToyVDMBD = ToyHLderivedBD: (* Temporarily based on HL: could remove this easily *)

types
  "vdmassn" = "(state \<times> state \<times> val) set"  (* before state, after state, value *)

constdefs
  vdm_valid :: "state expr \<Rightarrow> vdmassn \<Rightarrow> bool"       ("\<Turnstile>\<^sub>v (1_)/ : (1_)" 50)
  "\<Turnstile>\<^sub>v e : P   \<equiv>  (\<forall> s t v. \<langle>s,e\<rangle> \<longrightarrow>e \<langle>v,t\<rangle> \<longrightarrow> (s,t,v) \<in> P)"


text {* Meaning of VDM validity related to Hoare validity: optional *}

lemma VDM_Hoare: "vdm_valid e P  \<equiv>  hoare_valid {(z,s).z=s} e P"
by (simp add: vdm_valid_def hoare_valid_def)

lemma HtoV: "\<Turnstile> {(z,s). z=s} e Q \<Longrightarrow> \<Turnstile>\<^sub>v e : Q"
by (simp add: vdm_valid_def hoare_valid_def)

lemma VtoH: "\<Turnstile>\<^sub>v e : Q \<Longrightarrow> \<Turnstile> {(z,s). z=s} e Q"
by (simp add: vdm_valid_def hoare_valid_def)

lemma VdmI [intro]:
"(\<forall> s t v. \<langle>s,e\<rangle> \<longrightarrow>e \<langle>v,t\<rangle> \<longrightarrow> (s,t,v) \<in> P) \<Longrightarrow> \<Turnstile>\<^sub>v e : P"
by (simp add: vdm_valid_def)

lemma VdmE [elim]: "\<lbrakk> \<Turnstile>\<^sub>v e : P; \<langle>s,e\<rangle> \<longrightarrow>e \<langle>v,t\<rangle> \<rbrakk> \<Longrightarrow> (s,t,v) \<in> P"
by (simp add: vdm_valid_def)

text {* Single structural rule of weakening *}

lemma VW: "\<lbrakk> \<Turnstile>\<^sub>v e : P'; P'\<subseteq>P \<rbrakk> \<Longrightarrow> \<Turnstile>\<^sub>v e:P"
by fastsimp

text {* The main rules *}

lemma VNull:  "\<Turnstile>\<^sub>v NULL : {(s, s', v). (s' = tick s) \<and> (v = RVal Nullref)}"
(* can be derived with: by (rule HtoV, rule HSP, rule HNull, auto) *)
by (auto elim: evalNull_cases)

lemma VInt:   "\<Turnstile>\<^sub>v (expr.Int i) : {(s,s',v). (s' = tick s) \<and> (v = IVal i)}"
by (auto elim: evalInt_cases)

lemma VIVar: "\<Turnstile>\<^sub>v (expr.IVar vn) : {(s, s', v). (s' = tick s) \<and> v = IVal s<vn>}"
by (fastsimp elim: evalIVar_cases)


lemma VVarr: "\<Turnstile>\<^sub>v (expr.RVar vn) : {(s, s', v). (s' = tick s) \<and> v = RVal s\<lfloor>vn\<rfloor>}"
by (fastsimp elim: evalRVar_cases)

subsection {* VPrimop, VRPrimop *}

lemma VPrimop: 
  "\<Turnstile>\<^sub>v (expr.Primop f vn1 vn2) : {(s,s',v). s' = tickn 3 s \<and> v = IVal (f (s<vn1>) (s<vn2>))}"
by (fastsimp elim: evalPrimop_cases)

lemma VRPrimop: 
  "\<Turnstile>\<^sub>v (expr.RPrimop f vn1 vn2) : {(s,s',v). s'=tickn 3 s \<and> v = IVal (f (s\<lfloor>vn1\<rfloor>) (s\<lfloor>vn2\<rfloor>))}"
by (fastsimp elim: evalRPrimop_cases)

lemma VGetFi: "\<Turnstile>\<^sub>v (GetFi vn f) : {(s,s',v). s'=tickn 2 s \<and> v = IVal (s<(theloc s\<lfloor>vn\<rfloor>)\<bullet>f>)}"
by (fastsimp elim: evalGetFi_cases)

lemma VGetFr: "\<Turnstile>\<^sub>v (GetFr vn f) : {(s,s',v). s'=tickn 2 s \<and> v = RVal (s\<lfloor>(theloc s\<lfloor>vn\<rfloor>)\<diamondsuit>f\<rfloor>)}"
by (fastsimp elim: evalGetFr_cases)

lemma VPutFi: 
  "\<Turnstile>\<^sub>v (PutFi vn f valv) : {(s,s',v). s' = tickn 3 (s<(theloc s\<lfloor>vn\<rfloor>)\<bullet>f := (s<valv>)>)
				     \<and> v = IVal (s<valv>)}"
by (fastsimp elim: evalPutFi_cases)

lemma VPutFr: 
  "\<Turnstile>\<^sub>v (PutFr vn f valv) : {(s,s',v). s'= tickn 3 (s\<lfloor>(theloc s\<lfloor>vn\<rfloor>)\<diamondsuit>f := (s\<lfloor>valv\<rfloor>)\<rfloor>) 
				     \<and> v = RVal (s\<lfloor>valv\<rfloor>)}"
by (fastsimp elim: evalPutFr_cases)

lemma VNew: "\<Turnstile>\<^sub>v (New c ifldvals rfldvals) : 
	  {(s,s',v). s'=tick (s \<lparr> oheap := (oheap s)((freshlocst s) \<mapsto>\<^sub>f c),
				  iheap := iheapflds ifldvals (freshlocst s) (iheap s) s,
			          rheap := rheapflds rfldvals (freshlocst s) (rheap s) s\<rparr>)
			           \<and> v = RVal (Ref (freshlocst s))}"
by (fastsimp elim: evalNew_cases)


subsection {* Conditionals *}

text {* VIf is the first rule which has nested sub-expressions.
  This combines an instance of strengthening pre-condition. 
  *}

lemma VIf : "\<lbrakk> \<Turnstile>\<^sub>v e1 : P1; \<Turnstile>\<^sub>v e2 : P2 \<rbrakk>
          \<Longrightarrow> \<Turnstile>\<^sub>v (IF x THEN e1 ELSE e2) : 
		{(s,s',v).  (s<x>=grailbool True \<longrightarrow> (tick s,s',v)\<in> P1)
		 	  \<and> (s<x>=grailbool False \<longrightarrow> (tick s,s',v)\<in> P2)}"
by (unfold vdm_valid_def, fastsimp elim!: evalIf_cases)

text {* We can derive a stronger version of this rule which specifies
  additionally that the condition should be true or false (unused
  presently). *}

lemma VIfstrong : "\<lbrakk> \<Turnstile>\<^sub>v e1 : P1; \<Turnstile>\<^sub>v e2 : P2 \<rbrakk>
          \<Longrightarrow> \<Turnstile>\<^sub>v (IF x THEN e1 ELSE e2) : 
		{(s,s',v).  (s<x>=grailbool True \<and> (tick s,s',v)\<in> P1)
		 	  \<or> (s<x>=grailbool False \<and> (tick s,s',v)\<in> P2)}"
by (unfold vdm_valid_def, fastsimp elim!: evalIf_cases)

subsection {* Composition and assignment *}

text {* The rules for Let combine sequencing with assignment. *}

lemma VLet: "\<lbrakk> \<Turnstile>\<^sub>v e :  P1; \<Turnstile>\<^sub>v e' : P2 \<rbrakk> \<Longrightarrow>
	     \<Turnstile>\<^sub>v (LET x=e IN e' END) : 
	       {(s,s',v). \<exists> t' v'. (s,t',v')\<in> P1
				  \<and> (ivarupdate (tick t') x (theival v'),s',v) \<in> P2}"
by (simp add: vdm_valid_def, fastsimp elim: evalLeti_cases)

lemma VLetR: "\<lbrakk> \<Turnstile>\<^sub>v e : P1;  \<Turnstile>\<^sub>v e' : P2 \<rbrakk> \<Longrightarrow>
	  \<Turnstile>\<^sub>v (LET rf x=e IN e' END) : 
	       {(s,s',v). \<exists> t' v'. (s,t',v')\<in> P1
				  \<and> (rvarupdate (tick t') x (therval v'),s',v) \<in> P2}"
by (simp add: vdm_valid_def, fastsimp elim: evalLetr_cases)


subsection {* Function calls *}

text {*  The basic rule for CALL unwinds the function body. To avoid
  existentials in the pre-condition, we use Isabelle's image operator. 
  The pre-condition is equivalent to: 
  \begin{quote}
  @{term [source] "{(s,s'). \<exists> s'. (s, s') \<in> P \<and> s=tick (incrcallcount s')}"}
  \end{quote}
  (which is the version tested so far in examples').
  *}

(* ngoqvam vImuS!! *)
(* yIHoH! yIHoH! yIHoH! yIHoH! yIHoH! yIHoH! yIHoH! yIHoH! yIHoH! yIHoH! yIHoH! 
constdefs 
  apsnd :: "['b \<Rightarrow> 'c, 'a \<times> 'b ] \<Rightarrow> 'a \<times> 'c"
  "apsnd \<equiv> \<lambda> f (a,b). (a, f b)"

declare apsnd_def [simp add]
*)
constdefs 
  apfstofthree :: "['a \<Rightarrow> 'd, 'a \<times> 'b \<times> 'c ] \<Rightarrow> 'd \<times> 'b \<times> 'c"
  "apfstofthree \<equiv> \<lambda> f (a,b,c). (f a, b, c)"

declare apfstofthree_def [simp add]

constdefs 
  apsndofthree :: "['b \<Rightarrow> 'd, 'a \<times> 'b \<times> 'c ] \<Rightarrow> 'a \<times> 'd \<times> 'c"
  "apsndofthree \<equiv> \<lambda> f (a,b,c). (a, f b, c)"

declare apsndofthree_def [simp add]

constdefs  
 vdmimagepre :: "(state => state) \<Rightarrow> vdmassn \<Rightarrow> vdmassn"
 "vdmimagepre f == \<lambda> Q. (apfstofthree f) ` Q"

constdefs  
 vdminvimagepre :: "(state \<Rightarrow> state) \<Rightarrow> vdmassn \<Rightarrow> vdmassn"
 "vdminvimagepre g == \<lambda> Q. (apfstofthree g) -` Q"

constdefs  
 vdmimagepost :: "(state => state) \<Rightarrow> vdmassn \<Rightarrow> vdmassn"
 "vdmimagepost f == \<lambda> Q. (apsndofthree f) ` Q"

constdefs  
 vdminvimagepost :: "(state \<Rightarrow> state) \<Rightarrow> vdmassn \<Rightarrow> vdmassn"
 "vdminvimagepost g == \<lambda> Q. (apsndofthree g) -` Q"

declare vdmimagepre_def [simp] vdminvimagepre_def [simp] 
declare vdmimagepost_def [simp] vdminvimagepost_def [simp]

lemma vdmpreassninvimage_image: "inj f \<Longrightarrow> vdminvimagepre f (vdmimagepre f P) = P"
apply simp
apply auto
apply (subgoal_tac "ad=a")
apply simp
apply (auto elim: injD)
done

lemma vdmpreassnimage_invimage: "surj f \<Longrightarrow> vdmimagepre f (vdminvimagepre f P) = P"
oops

lemma [simp]: "vdminvimagepre tickcall (vdmimagepre tickcall P) = P"
apply (rule vdmpreassninvimage_image)
apply (rule inj_onI)
apply (simp add: tickn_def incrcallcount_def)
apply (rule_tac r=x in state.cases)
apply (rule_tac r=y in state.cases)
apply auto
done

(* FIXME: below is deprecated.  Use better rule next *)
lemma VCall: "\<Turnstile>\<^sub>v (funtable fn) : P  \<Longrightarrow>  
	      \<Turnstile>\<^sub>v (CALL fn) : {(s,s',v). (tickcall s,s',v) \<in> P}"
by (fastsimp elim: eval_cases)

(* stuff from ToyHLbasic ------------------------------------------------------- *)
(*
lemma evalintro_cong: "\<lbrakk> \<langle>s,e\<rangle> \<longrightarrow>e \<langle>v,t\<rangle>; s=s'; v=v'; t=t' \<rbrakk> \<Longrightarrow> \<langle>s',e\<rangle> \<longrightarrow>e \<langle>v',t'\<rangle>"
by auto

lemma plusone (*[simp]*): "x + 1 = (1::int) + x" by auto 

declare plusone [simp]

lemma clock_add : "\<langle>s,e\<rangle> \<longrightarrow>e \<langle>v,t\<rangle> \<Longrightarrow> \<langle>tickn i s,e\<rangle> \<longrightarrow>e \<langle>v,tickn i t\<rangle>"
apply (erule evalexpr.induct)
prefer 12 (* Treat True/False rules in correct order first *)
apply (rule_tac s="tickn i s" in evalintro_cong, rule evalIf_True, simp+)
prefer 12
apply (rule_tac s="tickn i s" in evalintro_cong, rule evalIf_False, simp+)
apply (rule_tac s="tickn i s" in evalintro_cong, rule evalexpr.intros, simp+)+
done

declare plusone [rule del]

lemma callcount_add: "\<langle>s,e\<rangle> \<longrightarrow>e \<langle>v,t\<rangle> \<Longrightarrow> \<langle>incrcallcount s,e\<rangle> \<longrightarrow>e \<langle>v,incrcallcount t\<rangle>"
sorry (* , NOT *)
(*
apply (erule evalexpr.induct)
prefer 12 (* Treat True/False rules in correct order first *)
(* -- *)
apply (rule_tac s="incrcallcount s" in evalintro_cong)
apply (rule evalIf_True)
(* apply (subgoal_tac "istore (tickn k s) = istore s") *)
apply (simp)
apply (simp)
apply (simp)
apply (simp)
prefer 12
(* apply (rule_tac s="tickn i s" in evalintro_cong, rule evalIf_False, simp+) *)
apply (rule_tac s="incrcallcount s" in evalintro_cong, rule evalexpr.intros, simp+)+
defer 1
apply simp
apply (rule_tac s="incrcallcount s" in evalintro_cong, rule evalexpr.intros, simp+)+
sorry
(*
apply (rule_tac s="tickn i s" in evalintro_cong, rule evalIf_False, simp+)
apply (rule_tac s="tickn i s" in evalintro_cong, rule evalexpr.intros, simp+)+
done
*)
*)
lemma tickcall_add: "\<langle>s,e\<rangle> \<longrightarrow>e \<langle>v,t\<rangle> \<Longrightarrow> \<langle>tickcall s,e\<rangle> \<longrightarrow>e \<langle>v,tickcall t\<rangle>"
by (drule clock_add, drule callcount_add, simp)

(*
lemma VngoqQIp_wa': "\<langle>tickcall s,e\<rangle> \<longrightarrow>e \<langle>v,t\<rangle> \<Longrightarrow> \<exists> t'. t = tickcall t' \<and> \<langle>s,e\<rangle> \<longrightarrow>e \<langle>v,t\<rangle>"
apply (erule evalexpr.induct)
apply clarsimp
apply rule
apply (rule_tac x="s(| callcount := (callcount s) - (1::int) |)" in exI)
apply (simp add: state_functions)
sorry
*)

(* FIXME: next rule not proven yet!  See ToyHLbasic.thy. *)
lemma VCallpost: "\<Turnstile>\<^sub>v (funtable fn) : {(s,s',v). (s,tickcall s',v) \<in> P} \<Longrightarrow>
		  \<Turnstile>\<^sub>v (CALL fn) : P"
apply (rule VdmI)
apply (rule allI)+
apply (rule impI)
apply (frule VdmE)
apply (fastsimp elim: eval_cases)
apply clarsimp
(* apply (frule call_add) *)
oops
*)

(********************************************************************************)

subsection {* Method calls *}

text {* The rules for method invocation are the most delicate.  The operational
  semantics rule adjusts the state in two places: creating a new frame before
  evaluating the method body, and then restoring the old frame 
  afterwards.\footnote{With a small step semantics and a return instruction 
   these two steps could be separated.}
  The basic Voare rule has the same structure, adjusting both the
  pre-condition and the post-condition in the premise.  
  Furthermore, because we use the trick of keeping the 
  old frame in the evaluation rule rather than the machine,
  this rule is really a rule scheme: hence the quantification
  over @{term s_init}.  
  *}
(* typing condition:  mn \<in> dom (meths (classtable c))  *)

(* popframe version
lemma VInvokeStatic:
  "\<Turnstile>\<^sub>v (methtable C mn) : P \<Longrightarrow>
   \<Turnstile>\<^sub>v (InvokeStatic C mn vn2) : 
	{(s,s',v). \<exists> t'. (newframe s mn Nullref (s\<lfloor>vn2\<rfloor>),t',v) \<in> P
		        \<and> s' = tickn 4 (popframe t')}"
by (fastsimp elim: evalInvokeStatic_cases)
*)

(*++ Version ngoqQIp_cha' ++*)
(* oldframe version *)
lemma VInvokeStatic:
  "\<Turnstile>\<^sub>v (methtable C mn) : P \<Longrightarrow>
   \<Turnstile>\<^sub>v (InvokeStatic C mn vn2) : 
	{(s,s',v). \<exists> t'. (newframe s mn Nullref (s\<lfloor>vn2\<rfloor>),t',v) \<in> P
		        \<and> s' = tickn 4 (oldframe t' s)}"
by (fastsimp elim: evalInvokeStatic_cases)


(* oldframe version from popframe
lemma VInvokeStaticOldframeFromPopframe:
  "\<Turnstile>\<^sub>v (methtable C mn) : P \<Longrightarrow>
   \<Turnstile>\<^sub>v (InvokeStatic C mn vn2) : 
	{(s,s',v). \<exists> t'. (newframe s mn Nullref (s\<lfloor>vn2\<rfloor>),t',v) \<in> P
		        \<and> s' = tickn 4 (oldframe t' s)}"
apply (rule VW)
apply (rule VInvokeStatic)
apply auto
apply (insert popframe1)
apply (rule_tac x="s'" in exI)
apply (erule_tac x="a" in allE)
apply (erule_tac x="t'" in allE)
apply (erule_tac x="mn" in allE)
apply rule
apply assumption
apply clarsimp
oops
*)
(* fails *)

text {* The rule @{text VInvoke} is slightly more complicated.  
  We additionally quantify globally over the location @{text a} of the 
  object, and use @{term "(the (s_init\<guillemotleft>a\<guillemotright>))"} to extract the class
  of the object --- this is a bit ugly, but writing 
  @{term "s_init\<guillemotleft>a\<guillemotright>=Some C"} in the pre-condition (inside
  quantifiers'), we would have to show that this gives the same class 
  as the one in the @{text Invoke} rule.
*}

(* P = body *)
(* oldframe version *)
(*
lemma VInvoke:
  "\<And> s_init a .
   \<lbrakk> \<Turnstile>\<^sub>v (methtable (the (s_init\<guillemotleft>a\<guillemotright>)) mn) : P \<rbrakk> 
   \<Longrightarrow>
    \<Turnstile>\<^sub>v (Invoke vn1 mn vn2) : 
	{(s,s',v). (s=s_init \<and> s\<lfloor>vn1\<rfloor> = Ref a \<and> s\<guillemotleft>a\<guillemotright> = Some C \<and> 
                   (\<exists> t' . (newframe s mn (Ref a) (s\<lfloor>vn2\<rfloor>),t',v) \<in> P
		        \<and> s' = tickn 5 (oldframe t' s)))} "
apply (fastsimp elim: evalInvoke_cases)
oops
*)

(* methtable (the (s_init\<guillemotleft>a\<guillemotright>)) mn *)
lemma VInvoke:
  "\<forall> s_init a C . 
   \<Turnstile>\<^sub>v (methtable C mn) : 
         {(s,s',v) . (\<exists> t t' . t=s_init \<and> t\<lfloor>vn1\<rfloor> = Ref a \<and> t\<guillemotleft>a\<guillemotright> = Some C \<and> 
                     (t,t',v) \<in> P \<and> s=newframe t mn (Ref a) (t\<lfloor>vn2\<rfloor>) \<and> 
		     t' = tickn 5 (oldframe s' t))}
   \<Longrightarrow>
    \<Turnstile>\<^sub>v (Invoke vn1 mn vn2) : P"
apply (unfold vdm_valid_def, clarify)
apply (erule evalInvoke_cases)
apply (erule_tac x="s" in allE)
apply (erule_tac x="a" in allE)
apply (erule_tac x="C" in allE)
apply (erule_tac x="newframe s mn (Ref a) s\<lfloor>vn2\<rfloor>" in allE)
apply (erule_tac x="s'" in allE)
apply (erule_tac x="v" in allE)
(* apply (subgoal_tac "distinct [vn1,vn2,self,param]") *)
apply clarsimp
done

text {*  
  Neither of these rules has been well tested in our examples yet and
  alternative formulations may be possible.
*}



(********************************************************************************)

subsection {* VPre, VPost, VMeasure --- rules for assertions *}

text {* Invariants are checked in the operational semantics',
  and their meaning is characterised by these rules. *}

(* FIXME: types are wrong here for pre-assertions: only want assertion on pre-state *)

lemma VPost: "\<lbrakk> \<Turnstile>\<^sub>v e : P \<rbrakk> \<Longrightarrow> \<Turnstile>\<^sub>v (POST P: e) : P"
by (fastsimp elim: evalPost_cases)

text {* The measure annotation is used to decorate an expression
  with a well-founded decreasing relation on states.  The relation
  decreases when the expression @{term e} is evaluated. *}

(* NB: with measure in op. sems we could derive this:
  lemma VMeasure: "\<lbrakk> \<Turnstile>\<^sub>v e : P \<rbrakk> \<Longrightarrow> \<Turnstile>\<^sub>v (MEASURE M: e) : {(s,s',v). (s,s')\<in> M \<and> (s,s',v)\<in> P}"
 But now we get that measure is ignored: *)
lemma VMeasure: "\<lbrakk> \<Turnstile>\<^sub>v e : P \<rbrakk> \<Longrightarrow> \<Turnstile>\<^sub>v (MEASURE M: e) : {(s,s',v). (s,s',v)\<in> P}"
by (fastsimp elim: evalMeasure_cases)

text {* This is a new rule which hasn't been tested yet (previous formulation
  used tables for storing measures rather than syntax). *}


(********************************************************************************)


subsection {* VRecWF --- total correctness rule for recursion *}

text {* From a suggestion of Robert Atkey: we have a separate rule
  for recursion, meaning that we can re-use @{text VRecWF} to derive
  rules for both call and invoke.  The recursion rule
  uses induction along a well-founded relation \cite{Nipkow,Kleymann}. *}
(*
lemma VRecWF:
 "\<lbrakk> wf r; (\<Turnstile>\<^sub>v e : {(s,s',v).(s,s',v)\<in> P \<and> (s,s')\<in> r}) \<longrightarrow> \<Turnstile>\<^sub>v e : {(s,s',v).(s,s',v)\<in> P \<and> s=s'} \<rbrakk>
  \<Longrightarrow> \<Turnstile>\<^sub>v e : P"
apply (rule, rule)
apply (erule_tac a = "s" and 
       P = "\<lambda> s. \<forall> t v. \<langle>s,e\<rangle> \<longrightarrow>e \<langle>v,t\<rangle> \<longrightarrow> (s,t,v)\<in> P" in wf_induct)
apply (erule_tac x="x" in allE)
apply (fastsimp)
done
*)

(********************************************************************************)

subsection {* Collecting the rules together *}

text {* The set @{text vdmbasics} are rules used for non-looping code;
  @{text vdmprocs} are the procedure rules.  These rule sets are
  for interactive use, the VCG uses a custom set. *}

lemmas vdmbasics = VNull VInt VIVar VVarr VPrimop VRPrimop VGetFi VGetFr VPutFi VPutFr VNew VIf  VLet VLetR 

lemmas vdmprocs  = VCall VInvokeStatic 
(* VInvoke  *) (* you wish! *)



subsection {* Cleanup *}

text {* Finally, we adjust the rules known to the classical reasoners so that
  hoare\_valid\_def is never expanded automatically; we restrict to using
  the Hoare rules defined above from now on. *}

declare VdmI [rule del] VdmE [rule del]

end
